const Joi = require('joi');

class AreaSchema {
    getSaveSchema()
    { 
        const saveAreaSchema = Joi.object().keys({
            Sys_CubicNo: Joi.number().max(255).required(),
            Sys_CubicName: Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_IDSNo: Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_rpi: Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_MachineCode: Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_CubType: Joi.string().max(100).required().not(['', null, 'undefined']),
            Sys_Area: Joi.string().max(50).required().not(['', null, 'undefined']),
            userid: Joi.string().max(50).required().not(['', null, 'undefined']),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            Act: Joi.string().max(50).required().not(['', null, 'undefined']),
            activitylog: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark:Joi.string().max(500).required().not(['',null,'undefined']),
            OldData:Joi.string().max(500).required().not(['',null,'undefined']),
            NewData:Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_cubTypes:Joi.string().max(300).required().not(['', null, 'undefined']),
            Setting:Joi.string().max(300).required().not(['', null, 'undefined'])
        });
        
        return saveAreaSchema;
    }
}



module.exports = AreaSchema;