/**
 * Granulation
 */
var IterateObject = require('iterate-object');

class ValidateProductGranulation {
    constructor() {
        const objResult = {};
        this.objResult = objResult;
        this.strNullValue = "99999.00000";
        this.intNullValue = 99999;
    }

    validateLodDry(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodDry = {
                LodDry: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_CompDryMin != "" && objProductNew.flt_CompDryMin != undefined) {
                    objLodDry.LodDry.MIN.oldValue = "NA";
                    objLodDry.LodDry.MIN.newValue = objProductNew.flt_CompDryMin;
                    IsChanged = true;
                }
                else {
                    objLodDry.LodDry.MIN.oldValue = false;
                    objLodDry.LodDry.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param1_Low === "" || objProductOld.Param1_Low == this.strNullValue || objProductOld.Param1_Low == undefined) {
                    objProductOld.Param1_Low = null;
                }

                if (objProductNew.flt_CompDryMin == "" || objProductNew.flt_CompDryMin == this.strNullValue || objProductNew.flt_CompDryMin == undefined) {
                    objProductNew.flt_CompDryMin = null;
                }

                if ((objProductOld.Param1_Low !== null) && (objProductNew.flt_CompDryMin !== null)) {
                    if (parseFloat(objProductOld.Param1_Low).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_CompDryMin).toFixed(objProductNew.int_dryDpGran)) {
                        objLodDry.LodDry.MIN.oldValue = false;
                        objLodDry.LodDry.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodDry.LodDry.MIN.oldValue = parseFloat(objProductOld.Param1_Low).toFixed(objProductOld.Param1_DP);
                        objLodDry.LodDry.MIN.newValue = objProductNew.flt_CompDryMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_Low === null) && (objProductNew.flt_CompDryMin !== null)) {
                        objLodDry.LodDry.MIN.oldValue = "NA";
                        objLodDry.LodDry.MIN.newValue = objProductNew.flt_CompDryMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_Low !== null) && (objProductNew.flt_CompDryMin === null)) {
                        objLodDry.LodDry.MIN.oldValue = parseFloat(objProductOld.Param1_Low).toFixed(objProductOld.Param1_DP);
                        objLodDry.LodDry.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_CompDryMax != "" && objProductNew.flt_CompDryMax != undefined) {
                    objLodDry.LodDry.MAX.oldValue = "NA";
                    objLodDry.LodDry.MAX.newValue = objProductNew.flt_CompDryMax;
                    IsChanged = true;
                }
                else {
                    objLodDry.LodDry.MAX.oldValue = false;
                    objLodDry.LodDry.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {

                if (objProductOld.Param1_Upp == "" || objProductOld.Param1_Upp == this.strNullValue || objProductOld.Param1_Upp == undefined) {
                    objProductOld.Param1_Upp = null;
                }

                if (objProductNew.flt_CompDryMax == "" || objProductNew.flt_CompDryMax == this.strNullValue || objProductNew.flt_CompDryMax == undefined) {
                    objProductNew.flt_CompDryMax = null;
                }
                
                if ((objProductOld.Param1_Upp !== null) && (objProductNew.flt_CompDryMax !== null)) {
                    if (parseFloat(objProductOld.Param1_Upp).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_CompDryMax).toFixed(objProductNew.int_dryDpGran)) {
                        objLodDry.LodDry.MAX.oldValue = false;
                        objLodDry.LodDry.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodDry.LodDry.MAX.oldValue = parseFloat(objProductOld.Param1_Upp).toFixed(objProductOld.Param1_DP);
                        objLodDry.LodDry.MAX.newValue = objProductNew.flt_CompDryMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_Upp === null) && (objProductNew.flt_CompDryMax !== null)) {
                        objLodDry.LodDry.MAX.oldValue = "NA";
                        objLodDry.LodDry.MAX.newValue = objProductNew.flt_CompDryMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_Upp !== null) && (objProductNew.flt_CompDryMax === null)) {
                        objLodDry.LodDry.MAX.oldValue = parseFloat(objProductOld.Param1_Upp).toFixed(objProductOld.Param1_DP);
                        objLodDry.LodDry.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLodDry);
            }
            resolve(IsChanged);
        });
    }

    validateLodLubricated(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodLubricated = {
                LodLubricated: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_CompLubMin != "" && objProductNew.flt_CompLubMin != undefined) {
                    objLodLubricated.LodLubricated.MIN.oldValue = "NA";
                    objLodLubricated.LodLubricated.MIN.newValue = objProductNew.flt_CompLubMin;
                    IsChanged = true;
                }
                else {
                    objLodLubricated.LodLubricated.MIN.oldValue = false;
                    objLodLubricated.LodLubricated.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param43_Low === "" || objProductOld.Param43_Low == this.strNullValue || objProductOld.Param43_Low == undefined) {
                    objProductOld.Param43_Low = null;
                }

                if (objProductNew.flt_CompLubMin == "" || objProductNew.flt_CompLubMin == this.strNullValue || objProductNew.flt_CompLubMin == undefined) {
                    objProductNew.flt_CompLubMin = null;
                }
                
                if ((objProductOld.Param43_Low !== null) && (objProductNew.flt_CompLubMin !== null)) {
                    if (parseFloat(objProductOld.Param43_Low).toFixed(objProductOld.Param43_DP) == parseFloat(objProductNew.flt_CompLubMin).toFixed(objProductNew.int_lubDpGran)) {
                        objLodLubricated.LodLubricated.MIN.oldValue = false;
                        objLodLubricated.LodLubricated.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodLubricated.LodLubricated.MIN.oldValue = parseFloat(objProductOld.Param43_Low).toFixed(objProductOld.Param43_DP);
                        objLodLubricated.LodLubricated.MIN.newValue = objProductNew.flt_CompLubMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param43_Low === null) && (objProductNew.flt_CompLubMin !== null)) {
                        objLodLubricated.LodLubricated.MIN.oldValue = "NA";
                        objLodLubricated.LodLubricated.MIN.newValue = objProductNew.flt_CompLubMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param43_Low !== null) && (objProductNew.flt_CompLubMin === null)) {
                        objLodLubricated.LodLubricated.MIN.oldValue = parseFloat(objProductOld.Param43_Low).toFixed(objProductOld.Param43_DP);
                        objLodLubricated.LodLubricated.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }


            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_CompLubMax != "" && objProductNew.flt_CompLubMax != undefined) {
                    objLodLubricated.LodLubricated.MAX.oldValue = "NA";
                    objLodLubricated.LodLubricated.MAX.newValue = objProductNew.flt_CompLubMax;
                    IsChanged = true;
                }
                else {
                    objLodLubricated.LodLubricated.MAX.oldValue = false;
                    objLodLubricated.LodLubricated.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param43_Upp == "" || objProductOld.Param43_Upp == this.strNullValue || objProductOld.Param43_Upp == undefined) {
                    objProductOld.Param43_Upp = null;
                }

                if (objProductNew.flt_CompLubMax == "" || objProductNew.flt_CompLubMax == this.strNullValue || objProductNew.flt_CompLubMax == undefined) {
                    objProductNew.flt_CompLubMax = null;
                }

                if ((objProductOld.Param43_Upp !== null) && (objProductNew.flt_CompLubMax !== null)) {
                    if (parseFloat(objProductOld.Param43_Upp).toFixed(objProductOld.Param43_DP) == parseFloat(objProductNew.flt_CompLubMax).toFixed(objProductNew.int_lubDpGran)) {
                        objLodLubricated.LodLubricated.MAX.oldValue = false;
                        objLodLubricated.LodLubricated.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodLubricated.LodLubricated.MAX.oldValue = parseFloat(objProductOld.Param43_Upp).toFixed(objProductOld.Param43_DP);
                        objLodLubricated.LodLubricated.MAX.newValue = objProductNew.flt_CompLubMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param43_Upp === null) && (objProductNew.flt_CompLubMax !== null)) {
                        objLodLubricated.LodLubricated.MAX.oldValue = "NA";
                        objLodLubricated.LodLubricated.MAX.newValue = objProductNew.flt_CompLubMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param43_Upp !== null) && (objProductNew.flt_CompLubMax === null)) {
                        objLodLubricated.LodLubricated.MAX.oldValue = parseFloat(objProductOld.Param43_Upp).toFixed(objProductOld.Param43_DP);
                        objLodLubricated.LodLubricated.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLodLubricated);
            }
            resolve(IsChanged);
        });
    }

    validateLodLayer1Dry(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodDry_Lay_1 = {
                LodDry_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_Layer1DryMin != "" && objProductNew.flt_Layer1DryMin != undefined) {
                    objLodDry_Lay_1.LodDry_Lay_1.MIN.oldValue = "NA";
                    objLodDry_Lay_1.LodDry_Lay_1.MIN.newValue = objProductNew.flt_Layer1DryMin;
                    IsChanged = true;
                }
                else {
                    objLodDry_Lay_1.LodDry_Lay_1.MIN.oldValue = false;
                    objLodDry_Lay_1.LodDry_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param4_Low === "" || objProductOld.Param4_Low == this.strNullValue || objProductOld.Param4_Low == undefined) {
                    objProductOld.Param4_Low = null;
                }

                if (objProductNew.flt_Layer1DryMin == "" || objProductNew.flt_Layer1DryMin == this.strNullValue || objProductNew.flt_Layer1DryMin == undefined) {
                    objProductNew.flt_Layer1DryMin = null;
                }

                if ((objProductOld.Param4_Low !== null) && (objProductNew.flt_Layer1DryMin !== null)) {
                    if (parseFloat(objProductOld.Param4_Low).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_Layer1DryMin).toFixed(objProductNew.int_dryL1DpGran)) {
                        objLodDry_Lay_1.LodDry_Lay_1.MIN.oldValue = false;
                        objLodDry_Lay_1.LodDry_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodDry_Lay_1.LodDry_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param4_Low).toFixed(objProductOld.Param4_DP);
                        objLodDry_Lay_1.LodDry_Lay_1.MIN.newValue = objProductNew.flt_Layer1DryMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_Low === null) && (objProductNew.flt_Layer1DryMin !== null)) {
                        objLodDry_Lay_1.LodDry_Lay_1.MIN.oldValue = "NA";
                        objLodDry_Lay_1.LodDry_Lay_1.MIN.newValue = objProductNew.flt_Layer1DryMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param4_Low !== null) && (objProductNew.flt_Layer1DryMin === null)) {
                        objLodDry_Lay_1.LodDry_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param4_Low).toFixed(objProductOld.Param4_DP);
                        objLodDry_Lay_1.LodDry_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_Layer1DryMax != "" && objProductNew.flt_Layer1DryMax != undefined) {
                    objLodDry_Lay_1.LodDry_Lay_1.MAX.oldValue = "NA";
                    objLodDry_Lay_1.LodDry_Lay_1.MAX.newValue = objProductNew.flt_Layer1DryMax;
                    IsChanged = true;
                }
                else {
                    objLodDry_Lay_1.LodDry_Lay_1.MAX.oldValue = false;
                    objLodDry_Lay_1.LodDry_Lay_1.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param4_Upp == "" || objProductOld.Param4_Upp == this.strNullValue || objProductOld.Param4_Upp == undefined) {
                    objProductOld.Param4_Upp = null;
                }

                if (objProductNew.flt_Layer1DryMax == "" || objProductNew.flt_Layer1DryMax == this.strNullValue || objProductNew.flt_Layer1DryMax == undefined) {
                    objProductNew.flt_Layer1DryMax = null;
                }

                if ((objProductOld.Param4_Upp !== null) && (objProductNew.flt_Layer1DryMax !== null)) {
                    if (parseFloat(objProductOld.Param4_Upp).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_Layer1DryMax).toFixed(objProductNew.int_dryL1DpGran)) {
                        objLodDry_Lay_1.LodDry_Lay_1.MAX.oldValue = false;
                        objLodDry_Lay_1.LodDry_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodDry_Lay_1.LodDry_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param4_Upp).toFixed(objProductOld.Param4_DP);
                        objLodDry_Lay_1.LodDry_Lay_1.MAX.newValue = objProductNew.flt_Layer1DryMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_Upp === null) && (objProductNew.flt_Layer1DryMax !== null)) {
                        objLodDry_Lay_1.LodDry_Lay_1.MAX.oldValue = "NA";
                        objLodDry_Lay_1.LodDry_Lay_1.MAX.newValue = objProductNew.flt_Layer1DryMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param4_Upp !== null) && (objProductNew.flt_Layer1DryMax === null)) {
                        objLodDry_Lay_1.LodDry_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param4_Upp).toFixed(objProductOld.Param4_DP);
                        objLodDry_Lay_1.LodDry_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objLodDry_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateLodLayer1Lubricated(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodLayer1Lubricated = {
                LodLayer1Lubricated: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_Layer1LubMin != "" && objProductNew.flt_Layer1LubMin != undefined ) {
                    objLodLayer1Lubricated.LodLayer1Lubricated.MIN.oldValue = "NA";
                    objLodLayer1Lubricated.LodLayer1Lubricated.MIN.newValue = objProductNew.flt_Layer1LubMin;
                    IsChanged = true;
                }
                else {
                    objLodLayer1Lubricated.LodLayer1Lubricated.MIN.oldValue = false;
                    objLodLayer1Lubricated.LodLayer1Lubricated.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param44_Low === "" || objProductOld.Param44_Low == this.strNullValue || objProductOld.Param44_Low == undefined) {
                    objProductOld.Param44_Low = null;
                }

                if (objProductNew.flt_Layer1LubMin == "" || objProductNew.flt_Layer1LubMin == this.strNullValue || objProductNew.flt_Layer1LubMin == undefined) {
                    objProductNew.flt_Layer1LubMin = null;
                }

                if ((objProductOld.Param44_Low !== null) && (objProductNew.flt_Layer1LubMin !== null)) {
                    if (parseFloat(objProductOld.Param44_Low).toFixed(objProductOld.Param44_DP) == parseFloat(objProductNew.flt_Layer1LubMin).toFixed(objProductNew.int_lubL1DpGran)) {
                        objLodLayer1Lubricated.LodLayer1Lubricated.MIN.oldValue = false;
                        objLodLayer1Lubricated.LodLayer1Lubricated.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodLayer1Lubricated.LodLayer1Lubricated.MIN.oldValue = parseFloat(objProductOld.Param44_Low).toFixed(objProductOld.Param44_DP);
                        objLodLayer1Lubricated.LodLayer1Lubricated.MIN.newValue = objProductNew.flt_Layer1LubMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param44_Low === null) && (objProductNew.flt_Layer1LubMin !== null)) {
                        objLodLayer1Lubricated.LodLayer1Lubricated.MIN.oldValue = "NA";
                        objLodLayer1Lubricated.LodLayer1Lubricated.MIN.newValue = objProductNew.flt_Layer1LubMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param44_Low !== null) && (objProductNew.flt_Layer1LubMin === null)) {
                        objLodLayer1Lubricated.LodLayer1Lubricated.MIN.oldValue = parseFloat(objProductOld.Param44_Low).toFixed(objProductOld.Param44_DP);
                        objLodLayer1Lubricated.LodLayer1Lubricated.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_Layer1LubMax != "" && objProductNew.flt_Layer1LubMax != undefined) {
                    objLodLayer1Lubricated.LodLayer1Lubricated.MAX.oldValue = "NA";
                    objLodLayer1Lubricated.LodLayer1Lubricated.MAX.newValue = objProductNew.flt_Layer1LubMax;
                    IsChanged = true;
                }
                else {
                    objLodLayer1Lubricated.LodLayer1Lubricated.MAX.oldValue = false;
                    objLodLayer1Lubricated.LodLayer1Lubricated.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param44_Upp == "" || objProductOld.Param44_Upp == this.strNullValue || objProductOld.Param44_Upp == undefined) {
                    objProductOld.Param44_Upp = null;
                }

                if (objProductNew.flt_Layer1LubMax == "" || objProductNew.flt_Layer1LubMax == this.strNullValue || objProductNew.flt_Layer1LubMax == undefined) {
                    objProductNew.flt_Layer1LubMax = null;
                }

                if ((objProductOld.Param44_Upp !== null) && (objProductNew.flt_Layer1LubMax !== null)) {
                    if (parseFloat(objProductOld.Param44_Upp).toFixed(objProductOld.Param44_DP) == parseFloat(objProductNew.flt_Layer1LubMax).toFixed(objProductNew.int_lubL1DpGran)) {
                        objLodLayer1Lubricated.LodLayer1Lubricated.MAX.oldValue = false;
                        objLodLayer1Lubricated.LodLayer1Lubricated.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodLayer1Lubricated.LodLayer1Lubricated.MAX.oldValue = parseFloat(objProductOld.Param44_Upp).toFixed(objProductOld.Param44_DP);
                        objLodLayer1Lubricated.LodLayer1Lubricated.MAX.newValue = objProductNew.flt_Layer1LubMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param44_Upp === null) && (objProductNew.flt_Layer1LubMax !== null)) {
                        objLodLayer1Lubricated.LodLayer1Lubricated.MAX.oldValue = "NA";
                        objLodLayer1Lubricated.LodLayer1Lubricated.MAX.newValue = objProductNew.flt_Layer1LubMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param44_Upp !== null) && (objProductNew.flt_Layer1LubMax === null)) {
                        objLodLayer1Lubricated.LodLayer1Lubricated.MAX.oldValue = parseFloat(objProductOld.Param44_Upp).toFixed(objProductOld.Param44_DP);
                        objLodLayer1Lubricated.LodLayer1Lubricated.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objLodLayer1Lubricated);
            }
            resolve(IsChanged);
        });
    }

    validateLodLayer2Dry(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodDry_Lay_2 = {
                LodDry_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_Layer2DryMin != "" && objProductNew.flt_Layer2DryMin != undefined) {
                    objLodDry_Lay_2.LodDry_Lay_2.MIN.oldValue = "NA";
                    objLodDry_Lay_2.LodDry_Lay_2.MIN.newValue = objProductNew.flt_Layer2DryMin;
                    IsChanged = true;
                }
                else {
                    objLodDry_Lay_2.LodDry_Lay_2.MIN.oldValue = false;
                    objLodDry_Lay_2.LodDry_Lay_2.MIN.newValue = false;
                    IsChanged = true;
                }

            }
            else {
                if (objProductOld.Param7_Low === "" || objProductOld.Param7_Low == this.strNullValue || objProductOld.Param7_Low == undefined) {
                    objProductOld.Param7_Low = null;
                }

                if (objProductNew.flt_Layer2DryMin == "" || objProductNew.flt_Layer2DryMin == this.strNullValue || objProductNew.flt_Layer2DryMin == undefined) {
                    objProductNew.flt_Layer2DryMin = null;
                }

                if ((objProductOld.Param7_Low !== null) && (objProductNew.flt_Layer2DryMin !== null)) {
                    if (parseFloat(objProductOld.Param7_Low).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_Layer2DryMin).toFixed(objProductNew.int_dryL2DpGran)) {
                        objLodDry_Lay_2.LodDry_Lay_2.MIN.oldValue = false;
                        objLodDry_Lay_2.LodDry_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodDry_Lay_2.LodDry_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param7_Low).toFixed(objProductOld.Param7_DP);
                        objLodDry_Lay_2.LodDry_Lay_2.MIN.newValue = objProductNew.flt_Layer2DryMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_Low === null) && (objProductNew.flt_Layer2DryMin !== null)) {
                        objLodDry_Lay_2.LodDry_Lay_2.MIN.oldValue = "NA";
                        objLodDry_Lay_2.LodDry_Lay_2.MIN.newValue = objProductNew.flt_Layer2DryMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_Low !== null) && (objProductNew.flt_Layer2DryMin === null)) {
                        objLodDry_Lay_2.LodDry_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param7_Low).toFixed(objProductOld.Param7_DP);
                        objLodDry_Lay_2.LodDry_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_Layer2DryMax != "" && objProductNew.flt_Layer2DryMax != undefined) {
                    objLodDry_Lay_2.LodDry_Lay_2.MAX.oldValue = "NA";
                    objLodDry_Lay_2.LodDry_Lay_2.MAX.newValue = objProductNew.flt_Layer2DryMax;
                    IsChanged = true;
                }
                else {
                    objLodDry_Lay_2.LodDry_Lay_2.MAX.oldValue = false;
                    objLodDry_Lay_2.LodDry_Lay_2.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param7_Upp == "" || objProductOld.Param7_Upp == this.strNullValue || objProductOld.Param7_Upp == undefined) {
                    objProductOld.Param7_Upp = null;
                }

                if (objProductNew.flt_Layer2DryMax == "" || objProductNew.flt_Layer2DryMax == this.strNullValue || objProductNew.flt_Layer2DryMax == undefined) {
                    objProductNew.flt_Layer2DryMax = null;
                }

                if ((objProductOld.Param7_Upp !== null) && (objProductNew.flt_Layer2DryMax !== null)) {
                    if (parseFloat(objProductOld.Param7_Upp).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_Layer2DryMax).toFixed(objProductNew.int_dryL2DpGran)) {
                        objLodDry_Lay_2.LodDry_Lay_2.MAX.oldValue = false;
                        objLodDry_Lay_2.LodDry_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodDry_Lay_2.LodDry_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param7_Upp).toFixed(objProductOld.Param7_DP);
                        objLodDry_Lay_2.LodDry_Lay_2.MAX.newValue = objProductNew.flt_Layer2DryMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_Upp === null) && (objProductNew.flt_Layer2DryMax !== null)) {
                        objLodDry_Lay_2.LodDry_Lay_2.MAX.oldValue = "NA";
                        objLodDry_Lay_2.LodDry_Lay_2.MAX.newValue = objProductNew.flt_Layer2DryMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_Upp !== null) && (objProductNew.flt_Layer2DryMax === null)) {
                        objLodDry_Lay_2.LodDry_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param7_Upp).toFixed(objProductOld.Param7_DP);
                        objLodDry_Lay_2.LodDry_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLodDry_Lay_2);
            }
            resolve(IsChanged);
        });
    }

    validateLodLayer2Lubricated(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodLayer2Lubricated = {
                LodLayer2Lubricated: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_Layer2LubMin != "" && objProductNew.flt_Layer2LubMin != undefined) {
                    objLodLayer2Lubricated.LodLayer2Lubricated.MIN.oldValue = "NA";
                    objLodLayer2Lubricated.LodLayer2Lubricated.MIN.newValue = objProductNew.flt_Layer2LubMin;
                    IsChanged = true;
                }
                else {
                    objLodLayer2Lubricated.LodLayer2Lubricated.MIN.oldValue = false;
                    objLodLayer2Lubricated.LodLayer2Lubricated.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param45_Low === "" || objProductOld.Param45_Low == this.strNullValue || objProductOld.Param45_Low == undefined) {
                    objProductOld.Param45_Low = null;
                }

                if (objProductNew.flt_Layer2LubMin == "" || objProductNew.flt_Layer2LubMin == this.strNullValue || objProductNew.flt_Layer2LubMin == undefined) {
                    objProductNew.flt_Layer2LubMin = null;
                }

                if ((objProductOld.Param45_Low !== null) && (objProductNew.flt_Layer2LubMin !== null)) {
                    if (parseFloat(objProductOld.Param45_Low).toFixed(objProductOld.Param45_DP) == parseFloat(objProductNew.flt_Layer2LubMin).toFixed(objProductNew.int_lubL2DpGran)) {
                        objLodLayer2Lubricated.LodLayer2Lubricated.MIN.oldValue = false;
                        objLodLayer2Lubricated.LodLayer2Lubricated.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodLayer2Lubricated.LodLayer2Lubricated.MIN.oldValue = parseFloat(objProductOld.Param45_Low).toFixed(objProductOld.Param45_DP);
                        objLodLayer2Lubricated.LodLayer2Lubricated.MIN.newValue = objProductNew.flt_Layer2LubMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param45_Low === null) && (objProductNew.flt_Layer2LubMin !== null)) {
                        objLodLayer2Lubricated.LodLayer2Lubricated.MIN.oldValue = "NA";
                        objLodLayer2Lubricated.LodLayer2Lubricated.MIN.newValue = objProductNew.flt_Layer2LubMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param45_Low !== null) && (objProductNew.flt_Layer2LubMin === null)) {
                        objLodLayer2Lubricated.LodLayer2Lubricated.MIN.oldValue = parseFloat(objProductOld.Param45_Low).toFixed(objProductOld.Param45_DP);
                        objLodLayer2Lubricated.LodLayer2Lubricated.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_Layer2LubMax != "" && objProductNew.flt_Layer2LubMax != undefined ) {
                    objLodLayer2Lubricated.LodLayer2Lubricated.MAX.oldValue = "NA";
                    objLodLayer2Lubricated.LodLayer2Lubricated.MAX.newValue = objProductNew.flt_Layer2LubMax;
                    IsChanged = true;
                }
                else {
                    objLodLayer2Lubricated.LodLayer2Lubricated.MAX.oldValue = false;
                    objLodLayer2Lubricated.LodLayer2Lubricated.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param45_Upp == "" || objProductOld.Param45_Upp == this.strNullValue || objProductOld.Param45_Upp == undefined) {
                    objProductOld.Param45_Upp = null;
                }

                if (objProductNew.flt_Layer2LubMax == "" || objProductNew.flt_Layer2LubMax == this.strNullValue || objProductNew.flt_Layer2LubMax == undefined) {
                    objProductNew.flt_Layer2LubMax = null;
                }

                if ((objProductOld.Param45_Upp !== null) && (objProductNew.flt_Layer2LubMax !== null)) {
                    if (parseFloat(objProductOld.Param45_Upp).toFixed(objProductOld.Param45_DP) == parseFloat(objProductNew.flt_Layer2LubMax).toFixed(objProductNew.int_lubL2DpGran)) {
                        objLodLayer2Lubricated.LodLayer2Lubricated.MAX.oldValue = false;
                        objLodLayer2Lubricated.LodLayer2Lubricated.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLodLayer2Lubricated.LodLayer2Lubricated.MAX.oldValue = parseFloat(objProductOld.Param45_Upp).toFixed(objProductOld.Param45_DP);
                        objLodLayer2Lubricated.LodLayer2Lubricated.MAX.newValue = objProductNew.flt_Layer2LubMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param45_Upp === null) && (objProductNew.flt_Layer2LubMax !== null)) {
                        objLodLayer2Lubricated.LodLayer2Lubricated.MAX.oldValue = "NA";
                        objLodLayer2Lubricated.LodLayer2Lubricated.MAX.newValue = objProductNew.flt_Layer2LubMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param45_Upp !== null) && (objProductNew.flt_Layer2LubMax === null)) {
                        objLodLayer2Lubricated.LodLayer2Lubricated.MAX.oldValue = parseFloat(objProductOld.Param45_Upp).toFixed(objProductOld.Param45_DP);
                        objLodLayer2Lubricated.LodLayer2Lubricated.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLodLayer2Lubricated);
            }
            resolve(IsChanged);
        });
    }

    validateTabDensity(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objTabDensity = {
                TappedDensity: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_TapDenMin != "" && objProductNew.flt_TapDenMin != undefined) {
                    objTabDensity.TappedDensity.MIN.oldValue = "NA";
                    objTabDensity.TappedDensity.MIN.newValue = objProductNew.flt_TapDenMin;
                    IsChanged = true;
                }
                else {
                    objTabDensity.TappedDensity.MIN.oldValue = false;
                    objTabDensity.TappedDensity.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param2_Low === "" || objProductOld.Param2_Low == this.strNullValue || objProductOld.Param2_Low == undefined) {
                    objProductOld.Param2_Low = null;
                }

                if (objProductNew.flt_TapDenMin == "" || objProductNew.flt_TapDenMin == this.strNullValue || objProductNew.flt_TapDenMin == undefined) {
                    objProductNew.flt_TapDenMin = null;
                }

                if ((objProductOld.Param2_Low !== null) && (objProductNew.flt_TapDenMin !== null)) {
                    if (parseFloat(objProductOld.Param2_Low).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_TapDenMin).toFixed(objProductNew.int_tdDpGran)) {
                        objTabDensity.TappedDensity.MIN.oldValue = false;
                        objTabDensity.TappedDensity.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objTabDensity.TappedDensity.MIN.oldValue = parseFloat(objProductOld.Param2_Low).toFixed(objProductOld.Param2_DP);
                        objTabDensity.TappedDensity.MIN.newValue = objProductNew.flt_TapDenMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_Low === null) && (objProductNew.flt_TapDenMin !== null)) {
                        objTabDensity.TappedDensity.MIN.oldValue = "NA";
                        objTabDensity.TappedDensity.MIN.newValue = objProductNew.flt_TapDenMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_Low !== null) && (objProductNew.flt_TapDenMin === null)) {
                        objTabDensity.TappedDensity.MIN.oldValue = parseFloat(objProductOld.Param2_Low).toFixed(objProductOld.Param2_DP);
                        objTabDensity.TappedDensity.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_TapDenMax != "" && objProductNew.flt_TapDenMax != undefined) {
                    objTabDensity.TappedDensity.MAX.oldValue = "NA";
                    objTabDensity.TappedDensity.MAX.newValue = objProductNew.flt_TapDenMax;
                    IsChanged = true;
                }
                else {
                    objTabDensity.TappedDensity.MAX.oldValue = false;
                    objTabDensity.TappedDensity.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param2_Upp == "" || objProductOld.Param2_Upp == this.strNullValue || objProductOld.Param2_Upp == undefined) {
                    objProductOld.Param2_Upp = null;
                }

                if (objProductNew.flt_TapDenMax == "" || objProductNew.flt_TapDenMax == this.strNullValue || objProductNew.flt_TapDenMax == undefined) {
                    objProductNew.flt_TapDenMax = null;
                }

                if ((objProductOld.Param2_Upp !== null) && (objProductNew.flt_TapDenMax !== null)) {
                    if (parseFloat(objProductOld.Param2_Upp).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_TapDenMax).toFixed(objProductNew.int_tdDpGran)) {
                        objTabDensity.TappedDensity.MAX.oldValue = false;
                        objTabDensity.TappedDensity.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objTabDensity.TappedDensity.MAX.oldValue = parseFloat(objProductOld.Param2_Upp).toFixed(objProductOld.Param2_DP);
                        objTabDensity.TappedDensity.MAX.newValue = objProductNew.flt_TapDenMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_Upp === null) && (objProductNew.flt_TapDenMax !== null)) {
                        objTabDensity.TappedDensity.MAX.oldValue = "NA";
                        objTabDensity.TappedDensity.MAX.newValue = objProductNew.flt_TapDenMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_Upp !== null) && (objProductNew.flt_TapDenMax === null)) {
                        objTabDensity.TappedDensity.MAX.oldValue = parseFloat(objProductOld.Param2_Upp).toFixed(objProductOld.Param2_DP);
                        objTabDensity.TappedDensity.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objTabDensity);
            }

            resolve(IsChanged);
        });
    }

    validateFine(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine = {
                Fine: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin != "" && objProductNew.flt_FineMin != undefined) {
                    objFine.Fine.MIN.oldValue = "NA";
                    objFine.Fine.MIN.newValue = objProductNew.flt_FineMin;
                    IsChanged = true;
                }
                else {
                    objFine.Fine.MIN.oldValue = false;
                    objFine.Fine.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param46_Low === "" || objProductOld.Param46_Low == this.strNullValue || objProductOld.Param46_Low == undefined) {
                    objProductOld.Param46_Low = null;
                }

                if (objProductNew.flt_FineMin == "" || objProductNew.flt_FineMin == this.strNullValue || objProductNew.flt_FineMin == undefined) {
                    objProductNew.flt_FineMin = null;
                }

                if ((objProductOld.Param46_Low !== null) && (objProductNew.flt_FineMin !== null)) {
                    if (parseFloat(objProductOld.Param46_Low).toFixed(objProductOld.Param46_DP) == parseFloat(objProductNew.flt_FineMin).toFixed(objProductNew.int_fineDpGran)) {
                        objFine.Fine.MIN.oldValue = false;
                        objFine.Fine.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine.Fine.MIN.oldValue = parseFloat(objProductOld.Param46_Low).toFixed(objProductOld.Param46_DP);
                        objFine.Fine.MIN.newValue = objProductNew.flt_FineMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param46_Low === null) && (objProductNew.flt_FineMin !== null)) {
                        objFine.Fine.MIN.oldValue = "NA";
                        objFine.Fine.MIN.newValue = objProductNew.flt_FineMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param46_Low !== null) && (objProductNew.flt_FineMin === null)) {
                        objFine.Fine.MIN.oldValue = parseFloat(objProductOld.Param46_Low).toFixed(objProductOld.Param46_DP);
                        objFine.Fine.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax != "" && objProductNew.flt_FineMax != undefined) {
                    objFine.Fine.MAX.oldValue = "NA";
                    objFine.Fine.MAX.newValue = objProductNew.flt_FineMax;
                    IsChanged = true;
                }
                else {
                    objFine.Fine.MAX.oldValue = false;
                    objFine.Fine.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param46_Upp == "" || objProductOld.Param46_Upp == this.strNullValue || objProductOld.Param46_Upp == undefined) {
                    objProductOld.Param46_Upp = null;
                }

                if (objProductNew.flt_FineMax == "" || objProductNew.flt_FineMax == this.strNullValue || objProductNew.flt_FineMax == undefined) {
                    objProductNew.flt_FineMax = null;
                }

                if ((objProductOld.Param46_Upp !== null) && (objProductNew.flt_FineMax !== null)) {
                    if (parseFloat(objProductOld.Param46_Upp).toFixed(objProductOld.Param46_DP) == parseFloat(objProductNew.flt_FineMax).toFixed(objProductNew.int_fineDpGran)) {
                        objFine.Fine.MAX.oldValue = false;
                        objFine.Fine.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine.Fine.MAX.oldValue = parseFloat(objProductOld.Param46_Upp).toFixed(objProductOld.Param46_DP);
                        objFine.Fine.MAX.newValue = objProductNew.flt_FineMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param46_Upp === null) && (objProductNew.flt_FineMax !== null)) {
                        objFine.Fine.MAX.oldValue = "NA";
                        objFine.Fine.MAX.newValue = objProductNew.flt_FineMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param46_Upp !== null) && (objProductNew.flt_FineMax === null)) {
                        objFine.Fine.MAX.oldValue = parseFloat(objProductOld.Param46_Upp).toFixed(objProductOld.Param46_DP);
                        objFine.Fine.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSeizing(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objParticleSeizing = {
                ParticleSizing: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PartSizingMin != "" && objProductNew.flt_PartSizingMin != undefined) {
                    objParticleSeizing.ParticleSizing.MIN.oldValue = "NA";
                    objParticleSeizing.ParticleSizing.MIN.newValue = objProductNew.flt_PartSizingMin;
                    IsChanged = true;
                }
                else {
                    objParticleSeizing.ParticleSizing.MIN.oldValue = false;
                    objParticleSeizing.ParticleSizing.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param47_Low === "" || objProductOld.Param47_Low == this.strNullValue || objProductOld.Param47_Low == undefined) {
                    objProductOld.Param47_Low = null;
                }

                if (objProductNew.flt_PartSizingMin == "" || objProductNew.flt_PartSizingMin == this.strNullValue || objProductNew.flt_PartSizingMin == undefined) {
                    objProductNew.flt_PartSizingMin = null;
                }

                if ((objProductOld.Param47_Low !== null) && (objProductNew.flt_PartSizingMin !== null)) {
                    if (parseFloat(objProductOld.Param47_Low).toFixed(objProductOld.Param47_DP) == parseFloat(objProductNew.flt_PartSizingMin).toFixed(objProductNew.int_psDpGran)) {
                        objParticleSeizing.ParticleSizing.MIN.oldValue = false;
                        objParticleSeizing.ParticleSizing.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objParticleSeizing.ParticleSizing.MIN.oldValue = parseFloat(objProductOld.Param47_Low).toFixed(objProductOld.Param47_DP);
                        objParticleSeizing.ParticleSizing.MIN.newValue = objProductNew.flt_PartSizingMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param47_Low === null) && (objProductNew.flt_PartSizingMin !== null)) {
                        objParticleSeizing.ParticleSizing.MIN.oldValue = "NA";
                        objParticleSeizing.ParticleSizing.MIN.newValue = objProductNew.flt_PartSizingMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param47_Low !== null) && (objProductNew.flt_PartSizingMin === null)) {
                        objParticleSeizing.ParticleSizing.MIN.oldValue = parseFloat(objProductOld.Param47_Low).toFixed(objProductOld.Param47_DP);
                        objParticleSeizing.ParticleSizing.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PartSizingMax != "" && objProductNew.flt_PartSizingMax != undefined) {
                    objParticleSeizing.ParticleSizing.MAX.oldValue = "NA";
                    objParticleSeizing.ParticleSizing.MAX.newValue = objProductNew.flt_PartSizingMax;
                    IsChanged = true;
                }
                else {
                    objParticleSeizing.ParticleSizing.MAX.oldValue = false;
                    objParticleSeizing.ParticleSizing.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param47_Upp == "" || objProductOld.Param47_Upp == this.strNullValue || objProductOld.Param47_Upp == undefined) {
                    objProductOld.Param47_Upp = null;
                }

                if (objProductNew.flt_PartSizingMax == "" || objProductNew.flt_PartSizingMax == this.strNullValue || objProductNew.flt_PartSizingMax == undefined) {
                    objProductNew.flt_PartSizingMax = null;
                }

                if ((objProductOld.Param47_Upp !== null) && (objProductNew.flt_PartSizingMax !== null)) {
                    if (parseFloat(objProductOld.Param47_Upp).toFixed(objProductOld.Param47_DP) == parseFloat(objProductNew.flt_PartSizingMax).toFixed(objProductNew.int_psDpGran)) {
                        objParticleSeizing.ParticleSizing.MAX.oldValue = false;
                        objParticleSeizing.ParticleSizing.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objParticleSeizing.ParticleSizing.MAX.oldValue = parseFloat(objProductOld.Param47_Upp).toFixed(objProductOld.Param47_DP);
                        objParticleSeizing.ParticleSizing.MAX.newValue = objProductNew.flt_PartSizingMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param47_Upp === null) && (objProductNew.flt_PartSizingMax !== null)) {
                        objParticleSeizing.ParticleSizing.MAX.oldValue = "NA";
                        objParticleSeizing.ParticleSizing.MAX.newValue = objProductNew.flt_PartSizingMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param47_Upp !== null) && (objProductNew.flt_PartSizingMax === null)) {
                        objParticleSeizing.ParticleSizing.MAX.oldValue = parseFloat(objProductOld.Param47_Upp).toFixed(objProductOld.Param47_DP);
                        objParticleSeizing.ParticleSizing.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objParticleSeizing);
            }
            resolve(IsChanged);
        });
    }

    validateBulkDensity(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const obj_bulkDensity = {
                BulkDensity: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_bulkMin != "" && objProductNew.flt_bulkMin != undefined) {
                    obj_bulkDensity.BulkDensity.MIN.oldValue = "NA";
                    obj_bulkDensity.BulkDensity.MIN.newValue = objProductNew.flt_bulkMin;
                    IsChanged = true;
                }
                else {
                    obj_bulkDensity.BulkDensity.MIN.oldValue = false;
                    obj_bulkDensity.BulkDensity.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param3_Low === "" || objProductOld.Param3_Low == this.strNullValue || objProductOld.Param3_Low == undefined) {
                    objProductOld.Param3_Low = null;
                }

                if (objProductNew.flt_bulkMin == "" || objProductNew.flt_bulkMin == this.strNullValue || objProductNew.flt_bulkMin == undefined) {
                    objProductNew.flt_bulkMin = null;
                }

                if ((objProductOld.Param3_Low !== null) && (objProductNew.flt_bulkMin !== null)) {
                    if (parseFloat(objProductOld.Param3_Low).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_bulkMin).toFixed(objProductNew.int_bulkDpGran)) {
                        obj_bulkDensity.BulkDensity.MIN.oldValue = false;
                        obj_bulkDensity.BulkDensity.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        obj_bulkDensity.BulkDensity.MIN.oldValue = parseFloat(objProductOld.Param3_Low).toFixed(objProductOld.Param3_DP);
                        obj_bulkDensity.BulkDensity.MIN.newValue = objProductNew.flt_bulkMin;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_Low === null) && (objProductNew.flt_bulkMin !== null)) {
                        obj_bulkDensity.BulkDensity.MIN.oldValue = "NA";
                        obj_bulkDensity.BulkDensity.MIN.newValue = objProductNew.flt_bulkMin;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_Low !== null) && (objProductNew.flt_bulkMin === null)) {
                        obj_bulkDensity.BulkDensity.MIN.oldValue = parseFloat(objProductOld.Param3_Low).toFixed(objProductOld.Param3_DP);
                        obj_bulkDensity.BulkDensity.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_bulkMax != "" && objProductNew.flt_bulkMax != undefined) {
                    obj_bulkDensity.BulkDensity.MAX.oldValue = "NA";
                    obj_bulkDensity.BulkDensity.MAX.newValue = objProductNew.flt_bulkMax;
                    IsChanged = true;
                }
                else {
                    obj_bulkDensity.BulkDensity.MAX.oldValue = false;
                    obj_bulkDensity.BulkDensity.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }

            }
            else {
                if (objProductOld.Param3_Upp == "" || objProductOld.Param3_Upp == this.strNullValue || objProductOld.Param3_Upp == undefined) {
                    objProductOld.Param3_Upp = null;
                }

                if (objProductNew.flt_bulkMax == "" || objProductNew.flt_bulkMax == this.strNullValue || objProductNew.flt_bulkMax == undefined) {
                    objProductNew.flt_bulkMax = null;
                }

                if ((objProductOld.Param3_Upp !== null) && (objProductNew.flt_bulkMax !== null)) {
                    if (parseFloat(objProductOld.Param3_Upp).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_bulkMax).toFixed(objProductNew.int_bulkDpGran)) {
                        obj_bulkDensity.BulkDensity.MAX.oldValue = false;
                        obj_bulkDensity.BulkDensity.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        obj_bulkDensity.BulkDensity.MAX.oldValue = parseFloat(objProductOld.Param3_Upp).toFixed(objProductOld.Param3_DP);
                        obj_bulkDensity.BulkDensity.MAX.newValue = objProductNew.flt_bulkMax;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_Upp === null) && (objProductNew.flt_bulkMax !== null)) {
                        obj_bulkDensity.BulkDensity.MAX.oldValue = "NA";
                        obj_bulkDensity.BulkDensity.MAX.newValue = objProductNew.flt_bulkMax;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_Upp !== null) && (objProductNew.flt_bulkMax === null)) {
                        obj_bulkDensity.BulkDensity.MAX.oldValue = parseFloat(objProductOld.Param3_Upp).toFixed(objProductOld.Param3_DP);
                        obj_bulkDensity.BulkDensity.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, obj_bulkDensity);
            }
            resolve(IsChanged);
        });
    }


    async validateGranulationParams(objProductOld, objProductNew) {
        var LodDry = await this.validateLodDry(objProductOld, objProductNew);
        var LodLubri = await this.validateLodLubricated(objProductOld, objProductNew);
        var Fine = await this.validateFine(objProductOld, objProductNew);
        var TappedDensity = await this.validateTabDensity(objProductOld, objProductNew);
        var BulkDensity = await this.validateBulkDensity(objProductOld, objProductNew);
        var ParticleSizing = await this.validateParticleSeizing(objProductOld, objProductNew);
        var LodDry_Lay_1 = await this.validateLodLayer1Dry(objProductOld, objProductNew);
        var LodLayer1Lubri = await this.validateLodLayer1Lubricated(objProductOld, objProductNew);
        var Fine_Lay_1 = await this.validateFine_Lay_1(objProductOld, objProductNew);
        var TappedDensity_Lay_1 = await this.validateTabDensity_Lay_1(objProductOld, objProductNew);
        var BulkDensity_Lay_1 = await this.validateBulkDensity_Lay_1(objProductOld, objProductNew);
        var ParticleSizing_Lay_1 = await this.validateParticleSeizing_Lay_1(objProductOld, objProductNew);
        var LodDry_Lay_2 = await this.validateLodLayer2Dry(objProductOld, objProductNew);
        var LodLayer2Lubri = await this.validateLodLayer2Lubricated(objProductOld, objProductNew);
        var Fine_Lay_2 = await this.validateFine_Lay_2(objProductOld, objProductNew);
        var TappedDensity_Lay_2 = await this.validateTabDensity_Lay_2(objProductOld, objProductNew);
        var BulkDensity_Lay_2 = await this.validateBulkDensity_Lay_2(objProductOld, objProductNew);
        var ParticleSizing_Lay_2 = await this.validateParticleSeizing_Lay_2(objProductOld, objProductNew);

        var ParticleSizeDistribution = await this.validateParticleSizeDistribution(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_20 = await this.validateParticleSizeDistribution_abv_20(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_40 = await this.validateParticleSizeDistribution_abv_40(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_60 = await this.validateParticleSizeDistribution_abv_60(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_80 = await this.validateParticleSizeDistribution_abv_80(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_100 = await this.validateParticleSizeDistribution_abv_100(objProductOld, objProductNew);
        var ParticleSizeDistribution_blw_100 = await this.validateParticleSizeDistribution_blw_100(objProductOld, objProductNew);
        var ParticleSizeDistribution_Lay_1 = await this.validateParticleSizeDistribution_Lay_1(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_20_Lay_1 = await this.validateParticleSizeDistribution_abv_20_Lay_1(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_40_Lay_1 = await this.validateParticleSizeDistribution_abv_40_Lay_1(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_60_Lay_1 = await this.validateParticleSizeDistribution_abv_60_Lay_1(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_80_Lay_1 = await this.validateParticleSizeDistribution_abv_80_Lay_1(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_100_Lay_1 = await this.validateParticleSizeDistribution_abv_100_Lay_1(objProductOld, objProductNew);
        var ParticleSizeDistribution_blw_100_Lay_1 = await this.validateParticleSizeDistribution_blw_100_Lay_1(objProductOld, objProductNew);
        var Fine_blw_30 = await this.validateFine_blw_30(objProductOld, objProductNew);
        var Fine_abv_30 = await this.validateFine_abv_30(objProductOld, objProductNew);
        var Fine_blw_40 = await this.validateFine_blw_40(objProductOld, objProductNew);
        var Fine_abv_40 = await this.validateFine_abv_40(objProductOld, objProductNew);
        var Fine_blw_60 = await this.validateFine_blw_60(objProductOld, objProductNew);
        var Fine_abv_60 = await this.validateFine_abv_60(objProductOld, objProductNew);
        var Fine_blw_80 = await this.validateFine_blw_80(objProductOld, objProductNew);
        var Fine_abv_80 = await this.validateFine_abv_80(objProductOld, objProductNew);
        var Fine_blw_100 = await this.validateFine_blw_100(objProductOld, objProductNew);
        var Fine_abv_100 = await this.validateFine_abv_100(objProductOld, objProductNew);
        var Fine_blw_Pan = await this.validateFine_Pan(objProductOld, objProductNew);
        var Fine_blw_30_Lay_1 = await this.validateFine_blw_30_Lay_1(objProductOld, objProductNew);
        var Fine_abv_30_Lay_1 = await this.validateFine_abv_30_Lay_1(objProductOld, objProductNew);
        var Fine_blw_40_Lay_1 = await this.validateFine_blw_40_Lay_1(objProductOld, objProductNew);
        var Fine_abv_40_Lay_1 = await this.validateFine_abv_40_Lay_1(objProductOld, objProductNew);
        var Fine_blw_60_Lay_1 = await this.validateFine_blw_60_Lay_1(objProductOld, objProductNew);
        var Fine_abv_60_Lay_1 = await this.validateFine_abv_60_Lay_1(objProductOld, objProductNew);
        var Fine_blw_80_Lay_1 = await this.validateFine_blw_80_Lay_1(objProductOld, objProductNew);
        var Fine_abv_80_Lay_1 = await this.validateFine_abv_80_Lay_1(objProductOld, objProductNew);
        var Fine_blw_100_Lay_1 = await this.validateFine_blw_100_Lay_1(objProductOld, objProductNew);
        var Fine_abv_100_Lay_1 = await this.validateFine_abv_100_Lay_1(objProductOld, objProductNew);
        var Fine_blw_Pan_Lay_1 = await this.validateFine_Pan_Lay_1(objProductOld, objProductNew);
        var Fine_blw_30_Lay_2 = await this.validateFine_blw_30_Lay_2(objProductOld, objProductNew);
        var Fine_abv_30_Lay_2 = await this.validateFine_abv_30_Lay_2(objProductOld, objProductNew);
        var Fine_blw_40_Lay_2 = await this.validateFine_blw_40_Lay_2(objProductOld, objProductNew);
        var Fine_abv_40_Lay_2 = await this.validateFine_abv_40_Lay_2(objProductOld, objProductNew);
        var Fine_blw_60_Lay_2 = await this.validateFine_blw_60_Lay_2(objProductOld, objProductNew);
        var Fine_abv_60_Lay_2 = await this.validateFine_abv_60_Lay_2(objProductOld, objProductNew);
        var Fine_blw_80_Lay_2 = await this.validateFine_blw_80_Lay_2(objProductOld, objProductNew);
        var Fine_abv_80_Lay_2 = await this.validateFine_abv_80_Lay_2(objProductOld, objProductNew);
        var Fine_blw_100_Lay_2 = await this.validateFine_blw_100_Lay_2(objProductOld, objProductNew);
        var Fine_abv_100_Lay_2 = await this.validateFine_abv_100_Lay_2(objProductOld, objProductNew);
        var Fine_blw_Pan_Lay_2 = await this.validateFine_Pan_Lay_2(objProductOld, objProductNew);
        

        if (LodDry != true && LodLubri != true && LodDry_Lay_1 != true && LodLayer1Lubri != true &&
            LodDry_Lay_2 != true && LodLayer2Lubri != true && TappedDensity != true && 
            Fine!= true && ParticleSizing != true && BulkDensity != true &&
            TappedDensity_Lay_1 != true && TappedDensity_Lay_2 != true &&
            BulkDensity_Lay_1 != true && BulkDensity_Lay_2 != true &&
            Fine_blw_30 != true && Fine_abv_30 != true && Fine_blw_40 != true && Fine_abv_40 != true &&
            Fine_blw_60 != true && Fine_abv_60 != true && Fine_blw_80 != true && Fine_abv_80 != true &&
            Fine_blw_100 != true && Fine_abv_100 != true && Fine_blw_Pan != true &&
            Fine_blw_30_Lay_1 != true && Fine_abv_30_Lay_1 != true && Fine_blw_40_Lay_1 != true && Fine_abv_40_Lay_1 != true &&
            Fine_blw_60_Lay_1 != true && Fine_abv_60_Lay_1 != true && Fine_blw_80_Lay_1 != true && Fine_abv_80_Lay_1 != true &&
            Fine_blw_100_Lay_1 != true && Fine_abv_100_Lay_1 != true && Fine_blw_Pan_Lay_1 != true &&
            Fine_blw_30_Lay_2 != true && Fine_abv_30_Lay_2 != true && Fine_blw_40_Lay_2 != true && Fine_abv_40_Lay_2 != true &&
            Fine_blw_60_Lay_2 != true && Fine_abv_60_Lay_2 != true && Fine_blw_80_Lay_2 != true && Fine_abv_80_Lay_2 != true &&
            Fine_blw_100_Lay_2 != true && Fine_abv_100_Lay_2 != true && Fine_blw_Pan_Lay_2 != true &&
            Fine_Lay_1 != true && Fine_Lay_2 != true &&
            ParticleSizeDistribution != true && ParticleSizeDistribution_abv_20 != true && ParticleSizeDistribution_abv_40 != true &&
            ParticleSizeDistribution_abv_60 != true && ParticleSizeDistribution_abv_80 != true && 
            ParticleSizeDistribution_abv_100 != true && ParticleSizeDistribution_blw_100 != true &&
            ParticleSizeDistribution_Lay_1 != true && ParticleSizeDistribution_abv_20_Lay_1 != true && 
            ParticleSizeDistribution_abv_40_Lay_1 != true && ParticleSizeDistribution_abv_60_Lay_1 != true && 
            ParticleSizeDistribution_abv_80_Lay_1 != true && ParticleSizeDistribution_abv_100_Lay_1 != true && 
            ParticleSizeDistribution_blw_100_Lay_1 != true && 
            ParticleSizing_Lay_1 != true && ParticleSizing_Lay_2 != true) 
        {
            return "No Change";
        }
        else {
            var strChanged = "";
            var strNewValue = "";


            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                var obj = value;
                strChanged = strChanged + "|";
                strNewValue = strNewValue + "|";

                IterateObject(obj, (value, key) => {
                    if ((value.oldValue !== false) && ((value.oldValue !== "") && (value.newValue !== ""))) {
                        strChanged = strChanged + key1 + "-";
                        strChanged = strChanged + key + ":";
                        strChanged = strChanged + ((value.oldValue == null || value.oldValue == "NaN") ? "NA" : value.oldValue) + ", ";

                        if (strChanged.includes("null:null:null")) {
                            strChanged = strChanged.replace(/null/g, "NA");
                        }

                        strNewValue = strNewValue + key1 + "-";
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + ((value.newValue == null || value.newValue == "NaN") ? "NA" : value.newValue) + ", ";

                        if (strNewValue.includes("null:null:null")) {
                            strNewValue = strNewValue.replace(/null/g, "NA");
                        }
                    }

                });
            });

            return { oldData: strChanged.slice(1), newData: strNewValue.slice(1) };
        }
    }

    async validateGranulationParamsCap(objProductOld, objProductNew) {
        var LodDry = await this.validateLodDry(objProductOld, objProductNew);
        var LodLubri = await this.validateLodLubricated(objProductOld, objProductNew);
        var TappedDensity = await this.validateTabDensity(objProductOld, objProductNew);
        var Fine = await this.validateFine(objProductOld, objProductNew);
        var BulkDensity = await this.validateBulkDensity(objProductOld, objProductNew);
        
        var ParticleSizing = await this.validateParticleSeizing(objProductOld, objProductNew);
        var ParticleSizeDistribution = await this.validateParticleSizeDistribution(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_20 = await this.validateParticleSizeDistribution_abv_20(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_40 = await this.validateParticleSizeDistribution_abv_40(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_60 = await this.validateParticleSizeDistribution_abv_60(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_80 = await this.validateParticleSizeDistribution_abv_80(objProductOld, objProductNew);
        var ParticleSizeDistribution_abv_100 = await this.validateParticleSizeDistribution_abv_100(objProductOld, objProductNew);
        var ParticleSizeDistribution_blw_100 = await this.validateParticleSizeDistribution_blw_100(objProductOld, objProductNew);


        if (LodDry != true && LodLubri != true && TappedDensity != true && 
            Fine!= true && ParticleSizing != true && BulkDensity != true &&
            
            ParticleSizeDistribution != true && ParticleSizeDistribution_abv_20 != true && ParticleSizeDistribution_abv_40 != true &&
            ParticleSizeDistribution_abv_60 != true && ParticleSizeDistribution_abv_80 != true && 
            ParticleSizeDistribution_abv_100 != true && ParticleSizeDistribution_blw_100 != true) 
        {
            return "No Change";
        }
        else {
            var strChanged = "";
            var strNewValue = "";


            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                var obj = value;
                strChanged = strChanged + "|";
                strNewValue = strNewValue + "|";

                IterateObject(obj, (value, key) => {
                    if (value.oldValue !== false) {
                        strChanged = strChanged + key1 + "-";
                        strChanged = strChanged + key + ":";
                        strChanged = strChanged + ((value.oldValue == null || value.oldValue == "NaN") ? "NA" : value.oldValue) + ", ";

                        if (strChanged.includes("null:null:null")) {
                            strChanged = strChanged.replace(/null/g, "NA");
                        }

                        strNewValue = strNewValue + key1 + "-";
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + ((value.newValue == null || value.newValue == "NaN") ? "NA" : value.newValue) + ", ";

                        if (strNewValue.includes("null:null:null")) {
                            strNewValue = strNewValue.replace(/null/g, "NA");
                        }
                    }

                });
            });

            return { oldData: strChanged.slice(1), newData: strNewValue.slice(1) };
        }
    }

    validateTabDensity_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objTabDensity_Lay_1 = {
                TappedDensity_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_TapDenMin_Lay_1 != "" && objProductNew.flt_TapDenMin_Lay_1 != undefined) {
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.oldValue = "NA";
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.newValue = objProductNew.flt_TapDenMin_Lay_1;
                    IsChanged = true;
                }
                else {
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.oldValue = false;
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param5_Low === "" || objProductOld.Param5_Low == this.strNullValue || objProductOld.Param5_Low == undefined) {
                    objProductOld.Param5_Low = null;
                }

                if (objProductNew.flt_TapDenMin_Lay_1 == "" || objProductNew.flt_TapDenMin_Lay_1 == this.strNullValue || objProductNew.flt_TapDenMin_Lay_1 == undefined) {
                    objProductNew.flt_TapDenMin_Lay_1 = null;
                }
    
                if ((objProductOld.Param5_Low !== null) && (objProductNew.flt_TapDenMin_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param5_Low).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_TapDenMin_Lay_1).toFixed(objProductNew.int_tdDpGran_Lay_1)) {
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.oldValue = false;
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param5_Low).toFixed(objProductOld.Param5_DP);
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.newValue = objProductNew.flt_TapDenMin_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_Low === null) && (objProductNew.flt_TapDenMin_Lay_1 !== null)) {
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.oldValue = "NA";
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.newValue = objProductNew.flt_TapDenMin_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_Low !== null) && (objProductNew.flt_TapDenMin_Lay_1 === null)) {
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param5_Low).toFixed(objProductOld.Param5_DP);
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_TapDenMax_Lay_1 != "" && objProductNew.flt_TapDenMax_Lay_1 != undefined) {
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.oldValue = "NA";
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.newValue = objProductNew.flt_TapDenMax_Lay_1;
                    IsChanged = true;
                }
                else {
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.oldValue = false;
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param5_Upp == "" || objProductOld.Param5_Upp == this.strNullValue || objProductOld.Param5_Upp == undefined) {
                    objProductOld.Param5_Upp = null;
                }

                if (objProductNew.flt_TapDenMax_Lay_1 == "" || objProductNew.flt_TapDenMax_Lay_1 == this.strNullValue || objProductNew.flt_TapDenMax_Lay_1 == undefined) {
                    objProductNew.flt_TapDenMax_Lay_1 = null;
                }
    
                if ((objProductOld.Param5_Upp !== null) && (objProductNew.flt_TapDenMax_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param5_Upp).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_TapDenMax_Lay_1).toFixed(objProductNew.int_tdDpGran_Lay_1)) {
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.oldValue = false;
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param5_Upp).toFixed(objProductOld.Param5_DP);
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.newValue = objProductNew.flt_TapDenMax_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_Upp === null) && (objProductNew.flt_TapDenMax_Lay_1 !== null)) {
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.oldValue = "NA";
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.newValue = objProductNew.flt_TapDenMax_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_Upp !== null) && (objProductNew.flt_TapDenMax_Lay_1 === null)) {
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param5_Upp).toFixed(objProductOld.Param5_DP);
                        objTabDensity_Lay_1.TappedDensity_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objTabDensity_Lay_1);
            }
    
            resolve(IsChanged);
        });
    }

    validateTabDensity_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objTabDensity_Lay_2 = {
                TappedDensity_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_TapDenMin_Lay_2 != "" && objProductNew.flt_TapDenMin_Lay_2 != undefined) {
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.oldValue = "NA";
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.newValue = objProductNew.flt_TapDenMin_Lay_2;
                    IsChanged = true;
                }
                else {
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.oldValue = false;
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param8_Low === "" || objProductOld.Param8_Low == this.strNullValue || objProductOld.Param8_Low == undefined) {
                    objProductOld.Param8_Low = null;
                }

                if (objProductNew.flt_TapDenMin_Lay_2 == "" || objProductNew.flt_TapDenMin_Lay_2 == this.strNullValue || objProductNew.flt_TapDenMin_Lay_2 == undefined) {
                    objProductNew.flt_TapDenMin_Lay_2 = null;
                }
    
                if ((objProductOld.Param8_Low !== null) && (objProductNew.flt_TapDenMin_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param8_Low).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.flt_TapDenMin_Lay_2).toFixed(objProductNew.int_tdDpGran_Lay_2)) {
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.oldValue = false;
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param8_Low).toFixed(objProductOld.Param8_DP);
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.newValue = objProductNew.flt_TapDenMin_Lay_2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_Low === null) && (objProductNew.flt_TapDenMin_Lay_2 !== null)) {
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.oldValue = "NA";
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.newValue = objProductNew.flt_TapDenMin_Lay_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_Low !== null) && (objProductNew.flt_TapDenMin_Lay_2 === null)) {
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param8_Low).toFixed(objProductOld.Param8_DP);
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_TapDenMax_Lay_2 != "" && objProductNew.flt_TapDenMax_Lay_2 != undefined) {
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.oldValue = "NA";
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.newValue = objProductNew.flt_TapDenMax_Lay_2;
                    IsChanged = true;
                }
                else {
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.oldValue = false;
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param8_Upp == "" || objProductOld.Param8_Upp == this.strNullValue || objProductOld.Param8_Upp == undefined) {
                    objProductOld.Param8_Upp = null;
                }

                if (objProductNew.flt_TapDenMax_Lay_2 == "" || objProductNew.flt_TapDenMax_Lay_2 == this.strNullValue || objProductNew.flt_TapDenMax_Lay_2 == undefined) {
                    objProductNew.flt_TapDenMax_Lay_2 = null;
                }
    
                if ((objProductOld.Param8_Upp !== null) && (objProductNew.flt_TapDenMax_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param8_Upp).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.flt_TapDenMax_Lay_2).toFixed(objProductNew.int_tdDpGran_Lay_2)) {
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.oldValue = false;
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param8_Upp).toFixed(objProductOld.Param8_DP);
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.newValue = objProductNew.flt_TapDenMax_Lay_2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_Upp === null) && (objProductNew.flt_TapDenMax_Lay_2 !== null)) {
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.oldValue = "NA";
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.newValue = objProductNew.flt_TapDenMax_Lay_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_Upp !== null) && (objProductNew.flt_TapDenMax_Lay_2 === null)) {
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param8_Upp).toFixed(objProductOld.Param8_DP);
                        objTabDensity_Lay_2.TappedDensity_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objTabDensity_Lay_2);
            }
    
            resolve(IsChanged);
        });
    }

    validateBulkDensity_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const obj_bulkDensity_Lay_1 = {
                BulkDensity_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_bulkMin_Lay_1 != "" && objProductNew.flt_bulkMin_Lay_1 != undefined) {
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.oldValue = "NA";
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.newValue = objProductNew.flt_bulkMin_Lay_1;
                    IsChanged = true;
                }
                else {
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.oldValue = false;
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param6_Low === "" || objProductOld.Param6_Low == this.strNullValue || objProductOld.Param6_Low == undefined) {
                    objProductOld.Param6_Low = null;
                }

                if (objProductNew.flt_bulkMin_Lay_1 == "" || objProductNew.flt_bulkMin_Lay_1 == this.strNullValue || objProductNew.flt_bulkMin_Lay_1 == undefined) {
                    objProductNew.flt_bulkMin_Lay_1 = null;
                }
    
                if ((objProductOld.Param6_Low !== null) && (objProductNew.flt_bulkMin_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param6_Low).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_bulkMin_Lay_1).toFixed(objProductNew.int_bulkDpGran_Lay_1)) {
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.oldValue = false;
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param6_Low).toFixed(objProductOld.Param6_DP);
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.newValue = objProductNew.flt_bulkMin_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_Low === null) && (objProductNew.flt_bulkMin_Lay_1 !== null)) {
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.oldValue = "NA";
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.newValue = objProductNew.flt_bulkMin_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_Low !== null) && (objProductNew.flt_bulkMin_Lay_1 === null)) {
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param6_Low).toFixed(objProductOld.Param6_DP);
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_bulkMax_Lay_1 != "" && objProductNew.flt_bulkMax_Lay_1 != undefined) {
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.oldValue = "NA";
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.newValue = objProductNew.flt_bulkMax_Lay_1;
                    IsChanged = true;
                }
                else {
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.oldValue = false;
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param6_Upp == "" || objProductOld.Param6_Upp == this.strNullValue || objProductOld.Param6_Upp == undefined) {
                    objProductOld.Param6_Upp = null;
                }

                if (objProductNew.flt_bulkMax_Lay_1 == "" || objProductNew.flt_bulkMax_Lay_1 == this.strNullValue || objProductNew.flt_bulkMax_Lay_1 == undefined) {
                    objProductNew.flt_bulkMax_Lay_1 = null;
                }
    
                if ((objProductOld.Param6_Upp !== null) && (objProductNew.flt_bulkMax_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param6_Upp).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_bulkMax_Lay_1).toFixed(objProductNew.int_bulkDpGran_Lay_1)) {
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.oldValue = false;
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param6_Upp).toFixed(objProductOld.Param6_DP);
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.newValue = objProductNew.flt_bulkMax_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_Upp === null) && (objProductNew.flt_bulkMax_Lay_1 !== null)) {
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.oldValue = "NA";
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.newValue = objProductNew.flt_bulkMax_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_Upp !== null) && (objProductNew.flt_bulkMax_Lay_1 === null)) {
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param6_Upp).toFixed(objProductOld.Param6_DP);
                        obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, obj_bulkDensity_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateBulkDensity_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const obj_bulkDensity_Lay_2 = {
                BulkDensity_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_bulkMin_Lay_2 != "" && objProductNew.flt_bulkMin_Lay_2 != undefined) {
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.oldValue = "NA";
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.newValue = objProductNew.flt_bulkMin_Lay_2;
                    IsChanged = true;
                }
                else {
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.oldValue = false;
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param9_Low === "" || objProductOld.Param9_Low == this.strNullValue || objProductOld.Param9_Low == undefined) {
                    objProductOld.Param9_Low = null;
                }

                if (objProductNew.flt_bulkMin_Lay_2 == "" || objProductNew.flt_bulkMin_Lay_2 == this.strNullValue || objProductNew.flt_bulkMin_Lay_2 == undefined) {
                    objProductNew.flt_bulkMin_Lay_2 = null;
                }
    
                if ((objProductOld.Param9_Low !== null) && (objProductNew.flt_bulkMin_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param9_Low).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_bulkMin_Lay_2).toFixed(objProductNew.int_bulkDpGran_Lay_2)) {
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.oldValue = false;
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param9_Low).toFixed(objProductOld.Param9_DP);
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.newValue = objProductNew.flt_bulkMin_Lay_2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_Low === null) && (objProductNew.flt_bulkMin_Lay_2 !== null)) {
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.oldValue = "NA";
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.newValue = objProductNew.flt_bulkMin_Lay_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_Low !== null) && (objProductNew.flt_bulkMin_Lay_2 === null)) {
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param9_Low).toFixed(objProductOld.Param9_DP);
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_bulkMax_Lay_2 != "" && objProductNew.flt_bulkMax_Lay_2 != undefined) {
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.oldValue = "NA";
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.newValue = objProductNew.flt_bulkMax_Lay_2;
                    IsChanged = true;
                }
                else {
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.oldValue = false;
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param9_Upp == "" || objProductOld.Param9_Upp == this.strNullValue || objProductOld.Param9_Upp == undefined) {
                    objProductOld.Param9_Upp = null;
                }

                if (objProductNew.flt_bulkMax_Lay_2 == "" || objProductNew.flt_bulkMax_Lay_2 == this.strNullValue || objProductNew.flt_bulkMax_Lay_2 == undefined) {
                    objProductNew.flt_bulkMax_Lay_2 = null;
                }
    
                if ((objProductOld.Param9_Upp !== null) && (objProductNew.flt_bulkMax_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param9_Upp).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_bulkMax_Lay_2).toFixed(objProductNew.int_bulkDpGran_Lay_2)) {
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.oldValue = false;
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param9_Upp).toFixed(objProductOld.Param9_DP);
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.newValue = objProductNew.flt_bulkMax_Lay_2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_Upp === null) && (objProductNew.flt_bulkMax_Lay_2 !== null)) {
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.oldValue = "NA";
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.newValue = objProductNew.flt_bulkMax_Lay_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_Upp !== null) && (objProductNew.flt_bulkMax_Lay_2 === null)) {
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param9_Upp).toFixed(objProductOld.Param9_DP);
                        obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, obj_bulkDensity_Lay_2);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_30(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_30 = {
                Fine_blw_30: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_30 != "" && objProductNew.flt_FineMin_blw_30 != undefined) {
                    objFine_blw_30.Fine_blw_30.MIN.oldValue = "NA";
                    objFine_blw_30.Fine_blw_30.MIN.newValue = objProductNew.flt_FineMin_blw_30;
                    IsChanged = true;
                }
                else {
                    objFine_blw_30.Fine_blw_30.MIN.oldValue = false;
                    objFine_blw_30.Fine_blw_30.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param10_Low === "" || objProductOld.Param10_Low == this.strNullValue || objProductOld.Param10_Low == undefined) {
                    objProductOld.Param10_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_30 == "" || objProductNew.flt_FineMin_blw_30 == this.strNullValue || objProductNew.flt_FineMin_blw_30 == undefined) {
                    objProductNew.flt_FineMin_blw_30 = null;
                }
    
                if ((objProductOld.Param10_Low !== null) && (objProductNew.flt_FineMin_blw_30 !== null)) {
                    if (parseFloat(objProductOld.Param10_Low).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_FineMin_blw_30).toFixed(objProductNew.int_fineDpGran_blw_30)) {
                        objFine_blw_30.Fine_blw_30.MIN.oldValue = false;
                        objFine_blw_30.Fine_blw_30.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_30.Fine_blw_30.MIN.oldValue = parseFloat(objProductOld.Param10_Low).toFixed(objProductOld.Param10_DP);
                        objFine_blw_30.Fine_blw_30.MIN.newValue = objProductNew.flt_FineMin_blw_30;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param10_Low === null) && (objProductNew.flt_FineMin_blw_30 !== null)) {
                        objFine_blw_30.Fine_blw_30.MIN.oldValue = "NA";
                        objFine_blw_30.Fine_blw_30.MIN.newValue = objProductNew.flt_FineMin_blw_30;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param10_Low !== null) && (objProductNew.flt_FineMin_blw_30 === null)) {
                        objFine_blw_30.Fine_blw_30.MIN.oldValue = parseFloat(objProductOld.Param10_Low).toFixed(objProductOld.Param10_DP);
                        objFine_blw_30.Fine_blw_30.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_30 != "" && objProductNew.flt_FineMax_blw_30 != undefined) {
                    objFine_blw_30.Fine_blw_30.MAX.oldValue = "NA";
                    objFine_blw_30.Fine_blw_30.MAX.newValue = objProductNew.flt_FineMax_blw_30;
                    IsChanged = true;
                }
                else {
                    objFine_blw_30.Fine_blw_30.MAX.oldValue = false;
                    objFine_blw_30.Fine_blw_30.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param10_Upp == "" || objProductOld.Param10_Upp == this.strNullValue || objProductOld.Param10_Upp == undefined) {
                    objProductOld.Param10_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_30 == "" || objProductNew.flt_FineMax_blw_30 == this.strNullValue || objProductNew.flt_FineMax_blw_30 == undefined) {
                    objProductNew.flt_FineMax_blw_30 = null;
                }
    
                if ((objProductOld.Param10_Upp !== null) && (objProductNew.flt_FineMax_blw_30 !== null)) {
                    if (parseFloat(objProductOld.Param10_Upp).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_FineMax_blw_30).toFixed(objProductNew.int_fineDpGran_blw_30)) {
                        objFine_blw_30.Fine_blw_30.MAX.oldValue = false;
                        objFine_blw_30.Fine_blw_30.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_30.Fine_blw_30.MAX.oldValue = parseFloat(objProductOld.Param10_Upp).toFixed(objProductOld.Param10_DP);
                        objFine_blw_30.Fine_blw_30.MAX.newValue = objProductNew.flt_FineMax_blw_30;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param10_Upp === null) && (objProductNew.flt_FineMax_blw_30 !== null)) {
                        objFine_blw_30.Fine_blw_30.MAX.oldValue = "NA";
                        objFine_blw_30.Fine_blw_30.MAX.newValue = objProductNew.flt_FineMax_blw_30;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param10_Upp !== null) && (objProductNew.flt_FineMax_blw_30 === null)) {
                        objFine_blw_30.Fine_blw_30.MAX.oldValue = parseFloat(objProductOld.Param10_Upp).toFixed(objProductOld.Param10_DP);
                        objFine_blw_30.Fine_blw_30.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_30);
            }
            resolve(IsChanged);
        });
    }

    validateFine_abv_30(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_30 = {
                Fine_abv_30: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_30 != "" && objProductNew.flt_FineMin_abv_30 != undefined) {
                    objFine_abv_30.Fine_abv_30.MIN.oldValue = "NA";
                    objFine_abv_30.Fine_abv_30.MIN.newValue = objProductNew.flt_FineMin_abv_30;
                    IsChanged = true;
                }
                else {
                    objFine_abv_30.Fine_abv_30.MIN.oldValue = false;
                    objFine_abv_30.Fine_abv_30.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param15_Low === "" || objProductOld.Param15_Low == this.strNullValue || objProductOld.Param15_Low == undefined) {
                    objProductOld.Param15_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_30 == "" || objProductNew.flt_FineMin_abv_30 == this.strNullValue || objProductNew.flt_FineMin_abv_30 == undefined) {
                    objProductNew.flt_FineMin_abv_30 = null;
                }
    
                if ((objProductOld.Param15_Low !== null) && (objProductNew.flt_FineMin_abv_30 !== null)) {
                    if (parseFloat(objProductOld.Param15_Low).toFixed(objProductOld.Param15_DP) == parseFloat(objProductNew.flt_FineMin_abv_30).toFixed(objProductNew.int_fineDpGran_abv_30)) {
                        objFine_abv_30.Fine_abv_30.MIN.oldValue = false;
                        objFine_abv_30.Fine_abv_30.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_30.Fine_abv_30.MIN.oldValue = parseFloat(objProductOld.Param15_Low).toFixed(objProductOld.Param15_DP);
                        objFine_abv_30.Fine_abv_30.MIN.newValue = objProductNew.flt_FineMin_abv_30;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param15_Low === null) && (objProductNew.flt_FineMin_abv_30 !== null)) {
                        objFine_abv_30.Fine_abv_30.MIN.oldValue = "NA";
                        objFine_abv_30.Fine_abv_30.MIN.newValue = objProductNew.flt_FineMin_abv_30;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param15_Low !== null) && (objProductNew.flt_FineMin_abv_30 === null)) {
                        objFine_abv_30.Fine_abv_30.MIN.oldValue = parseFloat(objProductOld.Param15_Low).toFixed(objProductOld.Param15_DP);
                        objFine_abv_30.Fine_abv_30.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_30 != "" && objProductNew.flt_FineMax_abv_30 != undefined) {
                    objFine_abv_30.Fine_abv_30.MAX.oldValue = "NA";
                    objFine_abv_30.Fine_abv_30.MAX.newValue = objProductNew.flt_FineMax_abv_30;
                    IsChanged = true;
                }
                else {
                    objFine_abv_30.Fine_abv_30.MAX.oldValue = false;
                    objFine_abv_30.Fine_abv_30.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param15_Upp == "" || objProductOld.Param15_Upp == this.strNullValue || objProductOld.Param15_Upp == undefined) {
                    objProductOld.Param15_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_30 == "" || objProductNew.flt_FineMax_abv_30 == this.strNullValue || objProductNew.flt_FineMax_abv_30 == undefined) {
                    objProductNew.flt_FineMax_abv_30 = null;
                }
    
                if ((objProductOld.Param15_Upp !== null) && (objProductNew.flt_FineMax_abv_30 !== null)) {
                    if (parseFloat(objProductOld.Param15_Upp).toFixed(objProductOld.Param15_DP) == parseFloat(objProductNew.flt_FineMax_abv_30).toFixed(objProductNew.int_fineDpGran_abv_30)) {
                        objFine_abv_30.Fine_abv_30.MAX.oldValue = false;
                        objFine_abv_30.Fine_abv_30.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_30.Fine_abv_30.MAX.oldValue = parseFloat(objProductOld.Param15_Upp).toFixed(objProductOld.Param15_DP);
                        objFine_abv_30.Fine_abv_30.MAX.newValue = objProductNew.flt_FineMax_abv_30;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param15_Upp === null) && (objProductNew.flt_FineMax_abv_30 !== null)) {
                        objFine_abv_30.Fine_abv_30.MAX.oldValue = "NA";
                        objFine_abv_30.Fine_abv_30.MAX.newValue = objProductNew.flt_FineMax_abv_30;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param15_Upp !== null) && (objProductNew.flt_FineMax_abv_30 === null)) {
                        objFine_abv_30.Fine_abv_30.MAX.oldValue = parseFloat(objProductOld.Param15_Upp).toFixed(objProductOld.Param15_DP);
                        objFine_abv_30.Fine_abv_30.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_30);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_40(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_40 = {
                Fine_blw_40: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_40 != "" && objProductNew.flt_FineMin_blw_40 != undefined) {
                    objFine_blw_40.Fine_blw_40.MIN.oldValue = "NA";
                    objFine_blw_40.Fine_blw_40.MIN.newValue = objProductNew.flt_FineMin_blw_40;
                    IsChanged = true;
                }
                else {
                    objFine_blw_40.Fine_blw_40.MIN.oldValue = false;
                    objFine_blw_40.Fine_blw_40.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param11_Low === "" || objProductOld.Param11_Low == this.strNullValue || objProductOld.Param11_Low == undefined) {
                    objProductOld.Param11_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_40 == "" || objProductNew.flt_FineMin_blw_40 == this.strNullValue || objProductNew.flt_FineMin_blw_40 == undefined) {
                    objProductNew.flt_FineMin_blw_40 = null;
                }
    
                if ((objProductOld.Param11_Low !== null) && (objProductNew.flt_FineMin_blw_40 !== null)) {
                    if (parseFloat(objProductOld.Param11_Low).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_FineMin_blw_40).toFixed(objProductNew.int_fineDpGran_blw_40)) {
                        objFine_blw_40.Fine_blw_40.MIN.oldValue = false;
                        objFine_blw_40.Fine_blw_40.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_40.Fine_blw_40.MIN.oldValue = parseFloat(objProductOld.Param11_Low).toFixed(objProductOld.Param11_DP);
                        objFine_blw_40.Fine_blw_40.MIN.newValue = objProductNew.flt_FineMin_blw_40;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param11_Low === null) && (objProductNew.flt_FineMin_blw_40 !== null)) {
                        objFine_blw_40.Fine_blw_40.MIN.oldValue = "NA";
                        objFine_blw_40.Fine_blw_40.MIN.newValue = objProductNew.flt_FineMin_blw_40;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param11_Low !== null) && (objProductNew.flt_FineMin_blw_40 === null)) {
                        objFine_blw_40.Fine_blw_40.MIN.oldValue = parseFloat(objProductOld.Param11_Low).toFixed(objProductOld.Param11_DP);
                        objFine_blw_40.Fine_blw_40.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_40 != "" && objProductNew.flt_FineMax_blw_40 != undefined) {
                    objFine_blw_40.Fine_blw_40.MAX.oldValue = "NA";
                    objFine_blw_40.Fine_blw_40.MAX.newValue = objProductNew.flt_FineMax_blw_40;
                    IsChanged = true;
                }
                else {
                    objFine_blw_40.Fine_blw_40.MAX.oldValue = false;
                    objFine_blw_40.Fine_blw_40.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param11_Upp == "" || objProductOld.Param11_Upp == this.strNullValue || objProductOld.Param11_Upp == undefined) {
                    objProductOld.Param11_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_40 == "" || objProductNew.flt_FineMax_blw_40 == this.strNullValue || objProductNew.flt_FineMax_blw_40 == undefined) {
                    objProductNew.flt_FineMax_blw_40 = null;
                }
    
                if ((objProductOld.Param11_Upp !== null) && (objProductNew.flt_FineMax_blw_40 !== null)) {
                    if (parseFloat(objProductOld.Param11_Upp).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_FineMax_blw_40).toFixed(objProductNew.int_fineDpGran_blw_40)) {
                        objFine_blw_40.Fine_blw_40.MAX.oldValue = false;
                        objFine_blw_40.Fine_blw_40.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_40.Fine_blw_40.MAX.oldValue = parseFloat(objProductOld.Param11_Upp).toFixed(objProductOld.Param11_DP);
                        objFine_blw_40.Fine_blw_40.MAX.newValue = objProductNew.flt_FineMax_blw_40;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param11_Upp === null) && (objProductNew.flt_FineMax_blw_40 !== null)) {
                        objFine_blw_40.Fine_blw_40.MAX.oldValue = "NA";
                        objFine_blw_40.Fine_blw_40.MAX.newValue = objProductNew.flt_FineMax_blw_40;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param11_Upp !== null) && (objProductNew.flt_FineMax_blw_40 === null)) {
                        objFine_blw_40.Fine_blw_40.MAX.oldValue = parseFloat(objProductOld.Param11_Upp).toFixed(objProductOld.Param11_DP);
                        objFine_blw_40.Fine_blw_40.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_40);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_40(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_40 = {
                Fine_abv_40: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_40 != "" && objProductNew.flt_FineMin_abv_40 != undefined) {
                    objFine_abv_40.Fine_abv_40.MIN.oldValue = "NA";
                    objFine_abv_40.Fine_abv_40.MIN.newValue = objProductNew.flt_FineMin_abv_40;
                    IsChanged = true;
                }
                else {
                    objFine_abv_40.Fine_abv_40.MIN.oldValue = false;
                    objFine_abv_40.Fine_abv_40.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param16_Low === "" || objProductOld.Param16_Low == this.strNullValue || objProductOld.Param16_Low == undefined) {
                    objProductOld.Param16_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_40 == "" || objProductNew.flt_FineMin_abv_40 == this.strNullValue || objProductNew.flt_FineMin_abv_40 == undefined) {
                    objProductNew.flt_FineMin_abv_40 = null;
                }
    
                if ((objProductOld.Param16_Low !== null) && (objProductNew.flt_FineMin_abv_40 !== null)) {
                    if (parseFloat(objProductOld.Param16_Low).toFixed(objProductOld.Param16_DP) == parseFloat(objProductNew.flt_FineMin_abv_40).toFixed(objProductNew.int_fineDpGran_abv_40)) {
                        objFine_abv_40.Fine_abv_40.MIN.oldValue = false;
                        objFine_abv_40.Fine_abv_40.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_40.Fine_abv_40.MIN.oldValue = parseFloat(objProductOld.Param16_Low).toFixed(objProductOld.Param16_DP);
                        objFine_abv_40.Fine_abv_40.MIN.newValue = objProductNew.flt_FineMin_abv_40;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param16_Low === null) && (objProductNew.flt_FineMin_abv_40 !== null)) {
                        objFine_abv_40.Fine_abv_40.MIN.oldValue = "NA";
                        objFine_abv_40.Fine_abv_40.MIN.newValue = objProductNew.flt_FineMin_abv_40;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param16_Low !== null) && (objProductNew.flt_FineMin_abv_40 === null)) {
                        objFine_abv_40.Fine_abv_40.MIN.oldValue = parseFloat(objProductOld.Param16_Low).toFixed(objProductOld.Param16_DP);
                        objFine_abv_40.Fine_abv_40.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_40 != "" && objProductNew.flt_FineMax_abv_40 != undefined) {
                    objFine_abv_40.Fine_abv_40.MAX.oldValue = "NA";
                    objFine_abv_40.Fine_abv_40.MAX.newValue = objProductNew.flt_FineMax_abv_40;
                    IsChanged = true;
                }
                else {
                    objFine_abv_40.Fine_abv_40.MAX.oldValue = false;
                    objFine_abv_40.Fine_abv_40.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param16_Upp == "" || objProductOld.Param16_Upp == this.strNullValue || objProductOld.Param16_Upp == undefined) {
                    objProductOld.Param16_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_40 == "" || objProductNew.flt_FineMax_abv_40 == this.strNullValue || objProductNew.flt_FineMax_abv_40 == undefined) {
                    objProductNew.flt_FineMax_abv_40 = null;
                }
    
                if ((objProductOld.Param16_Upp !== null) && (objProductNew.flt_FineMax_abv_40 !== null)) {
                    if (parseFloat(objProductOld.Param16_Upp).toFixed(objProductOld.Param16_DP) == parseFloat(objProductNew.flt_FineMax_abv_40).toFixed(objProductNew.int_fineDpGran_abv_40)) {
                        objFine_abv_40.Fine_abv_40.MAX.oldValue = false;
                        objFine_abv_40.Fine_abv_40.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_40.Fine_abv_40.MAX.oldValue = parseFloat(objProductOld.Param16_Upp).toFixed(objProductOld.Param16_DP);
                        objFine_abv_40.Fine_abv_40.MAX.newValue = objProductNew.flt_FineMax_abv_40;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param16_Upp === null) && (objProductNew.flt_FineMax_abv_40 !== null)) {
                        objFine_abv_40.Fine_abv_40.MAX.oldValue = "NA";
                        objFine_abv_40.Fine_abv_40.MAX.newValue = objProductNew.flt_FineMax_abv_40;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param16_Upp !== null) && (objProductNew.flt_FineMax_abv_40 === null)) {
                        objFine_abv_40.Fine_abv_40.MAX.oldValue = parseFloat(objProductOld.Param16_Upp).toFixed(objProductOld.Param16_DP);
                        objFine_abv_40.Fine_abv_40.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_40);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_60(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_60 = {
                Fine_blw_60: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_60 != "" && objProductNew.flt_FineMin_blw_60 != undefined) {
                    objFine_blw_60.Fine_blw_60.MIN.oldValue = "NA";
                    objFine_blw_60.Fine_blw_60.MIN.newValue = objProductNew.flt_FineMin_blw_60;
                    IsChanged = true;
                }
                else {
                    objFine_blw_60.Fine_blw_60.MIN.oldValue = false;
                    objFine_blw_60.Fine_blw_60.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param12_Low === "" || objProductOld.Param12_Low == this.strNullValue || objProductOld.Param12_Low == undefined) {
                    objProductOld.Param12_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_60 == "" || objProductNew.flt_FineMin_blw_60 == this.strNullValue || objProductNew.flt_FineMin_blw_60 == undefined) {
                    objProductNew.flt_FineMin_blw_60 = null;
                }
    
                if ((objProductOld.Param12_Low !== null) && (objProductNew.flt_FineMin_blw_60 !== null)) {
                    if (parseFloat(objProductOld.Param12_Low).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_FineMin_blw_60).toFixed(objProductNew.int_fineDpGran_blw_60)) {
                        objFine_blw_60.Fine_blw_60.MIN.oldValue = false;
                        objFine_blw_60.Fine_blw_60.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_60.Fine_blw_60.MIN.oldValue = parseFloat(objProductOld.Param12_Low).toFixed(objProductOld.Param12_DP);
                        objFine_blw_60.Fine_blw_60.MIN.newValue = objProductNew.flt_FineMin_blw_60;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param12_Low === null) && (objProductNew.flt_FineMin_blw_60 !== null)) {
                        objFine_blw_60.Fine_blw_60.MIN.oldValue = "NA";
                        objFine_blw_60.Fine_blw_60.MIN.newValue = objProductNew.flt_FineMin_blw_60;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param12_Low !== null) && (objProductNew.flt_FineMin_blw_60 === null)) {
                        objFine_blw_60.Fine_blw_60.MIN.oldValue = parseFloat(objProductOld.Param12_Low).toFixed(objProductOld.Param12_DP);
                        objFine_blw_60.Fine_blw_60.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_60 != "" && objProductNew.flt_FineMax_blw_60 != undefined) {
                    objFine_blw_60.Fine_blw_60.MAX.oldValue = "NA";
                    objFine_blw_60.Fine_blw_60.MAX.newValue = objProductNew.flt_FineMax_blw_60;
                    IsChanged = true;
                }
                else {
                    objFine_blw_60.Fine_blw_60.MAX.oldValue = false;
                    objFine_blw_60.Fine_blw_60.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param12_Upp == "" || objProductOld.Param12_Upp == this.strNullValue || objProductOld.Param12_Upp == undefined) {
                    objProductOld.Param12_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_60 == "" || objProductNew.flt_FineMax_blw_60 == this.strNullValue || objProductNew.flt_FineMax_blw_60 == undefined) {
                    objProductNew.flt_FineMax_blw_60 = null;
                }
    
                if ((objProductOld.Param12_Upp !== null) && (objProductNew.flt_FineMax_blw_60 !== null)) {
                    if (parseFloat(objProductOld.Param12_Upp).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_FineMax_blw_60).toFixed(objProductNew.int_fineDpGran_blw_60)) {
                        objFine_blw_60.Fine_blw_60.MAX.oldValue = false;
                        objFine_blw_60.Fine_blw_60.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_60.Fine_blw_60.MAX.oldValue = parseFloat(objProductOld.Param12_Upp).toFixed(objProductOld.Param12_DP);
                        objFine_blw_60.Fine_blw_60.MAX.newValue = objProductNew.flt_FineMax_blw_60;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param12_Upp === null) && (objProductNew.flt_FineMax_blw_60 !== null)) {
                        objFine_blw_60.Fine_blw_60.MAX.oldValue = "NA";
                        objFine_blw_60.Fine_blw_60.MAX.newValue = objProductNew.flt_FineMax_blw_60;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param12_Upp !== null) && (objProductNew.flt_FineMax_blw_60 === null)) {
                        objFine_blw_60.Fine_blw_60.MAX.oldValue = parseFloat(objProductOld.Param12_Upp).toFixed(objProductOld.Param12_DP);
                        objFine_blw_60.Fine_blw_60.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_60);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_60(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_60 = {
                Fine_abv_60: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_60 != "" && objProductNew.flt_FineMin_abv_60 != undefined) {
                    objFine_abv_60.Fine_abv_60.MIN.oldValue = "NA";
                    objFine_abv_60.Fine_abv_60.MIN.newValue = objProductNew.flt_FineMin_abv_60;
                    IsChanged = true;
                }
                else {
                    objFine_abv_60.Fine_abv_60.MIN.oldValue = false;
                    objFine_abv_60.Fine_abv_60.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param17_Low === "" || objProductOld.Param17_Low == this.strNullValue || objProductOld.Param17_Low == undefined) {
                    objProductOld.Param17_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_60 == "" || objProductNew.flt_FineMin_abv_60 == this.strNullValue || objProductNew.flt_FineMin_abv_60 == undefined) {
                    objProductNew.flt_FineMin_abv_60 = null;
                }
    
                if ((objProductOld.Param17_Low !== null) && (objProductNew.flt_FineMin_abv_60 !== null)) {
                    if (parseFloat(objProductOld.Param17_Low).toFixed(objProductOld.Param17_DP) == parseFloat(objProductNew.flt_FineMin_abv_60).toFixed(objProductNew.int_fineDpGran_abv_60)) {
                        objFine_abv_60.Fine_abv_60.MIN.oldValue = false;
                        objFine_abv_60.Fine_abv_60.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_60.Fine_abv_60.MIN.oldValue = parseFloat(objProductOld.Param17_Low).toFixed(objProductOld.Param17_DP);
                        objFine_abv_60.Fine_abv_60.MIN.newValue = objProductNew.flt_FineMin_abv_60;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param17_Low === null) && (objProductNew.flt_FineMin_abv_60 !== null)) {
                        objFine_abv_60.Fine_abv_60.MIN.oldValue = "NA";
                        objFine_abv_60.Fine_abv_60.MIN.newValue = objProductNew.flt_FineMin_abv_60;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param17_Low !== null) && (objProductNew.flt_FineMin_abv_60 === null)) {
                        objFine_abv_60.Fine_abv_60.MIN.oldValue = parseFloat(objProductOld.Param17_Low).toFixed(objProductOld.Param17_DP);
                        objFine_abv_60.Fine_abv_60.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_60 != "" && objProductNew.flt_FineMax_abv_60 != undefined) {
                    objFine_abv_60.Fine_abv_60.MAX.oldValue = "NA";
                    objFine_abv_60.Fine_abv_60.MAX.newValue = objProductNew.flt_FineMax_abv_60;
                    IsChanged = true;
                }
                else {
                    objFine_abv_60.Fine_abv_60.MAX.oldValue = false;
                    objFine_abv_60.Fine_abv_60.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param17_Upp == "" || objProductOld.Param17_Upp == this.strNullValue || objProductOld.Param17_Upp == undefined) {
                    objProductOld.Param17_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_60 == "" || objProductNew.flt_FineMax_abv_60 == this.strNullValue || objProductNew.flt_FineMax_abv_60 == undefined) {
                    objProductNew.flt_FineMax_abv_60 = null;
                }
    
                if ((objProductOld.Param17_Upp !== null) && (objProductNew.flt_FineMax_abv_60 !== null)) {
                    if (parseFloat(objProductOld.Param17_Upp).toFixed(objProductOld.Param17_DP) == parseFloat(objProductNew.flt_FineMax_abv_60).toFixed(objProductNew.int_fineDpGran_abv_60)) {
                        objFine_abv_60.Fine_abv_60.MAX.oldValue = false;
                        objFine_abv_60.Fine_abv_60.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_60.Fine_abv_60.MAX.oldValue = parseFloat(objProductOld.Param17_Upp).toFixed(objProductOld.Param17_DP);
                        objFine_abv_60.Fine_abv_60.MAX.newValue = objProductNew.flt_FineMax_abv_60;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param17_Upp === null) && (objProductNew.flt_FineMax_abv_60 !== null)) {
                        objFine_abv_60.Fine_abv_60.MAX.oldValue = "NA";
                        objFine_abv_60.Fine_abv_60.MAX.newValue = objProductNew.flt_FineMax_abv_60;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param17_Upp !== null) && (objProductNew.flt_FineMax_abv_60 === null)) {
                        objFine_abv_60.Fine_abv_60.MAX.oldValue = parseFloat(objProductOld.Param17_Upp).toFixed(objProductOld.Param17_DP);
                        objFine_abv_60.Fine_abv_60.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_60);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_80(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_80 = {
                Fine_blw_80: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_80 != "" && objProductNew.flt_FineMin_blw_80 != undefined) {
                    objFine_blw_80.Fine_blw_80.MIN.oldValue = "NA";
                    objFine_blw_80.Fine_blw_80.MIN.newValue = objProductNew.flt_FineMin_blw_80;
                    IsChanged = true;
                }
                else {
                    objFine_blw_80.Fine_blw_80.MIN.oldValue = false;
                    objFine_blw_80.Fine_blw_80.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param13_Low === "" || objProductOld.Param13_Low == this.strNullValue || objProductOld.Param13_Low == undefined) {
                    objProductOld.Param13_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_80 == "" || objProductNew.flt_FineMin_blw_80 == this.strNullValue || objProductNew.flt_FineMin_blw_80 == undefined) {
                    objProductNew.flt_FineMin_blw_80 = null;
                }
    
                if ((objProductOld.Param13_Low !== null) && (objProductNew.flt_FineMin_blw_80 !== null)) {
                    if (parseFloat(objProductOld.Param13_Low).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_FineMin_blw_80).toFixed(objProductNew.int_fineDpGran_blw_80)) {
                        objFine_blw_80.Fine_blw_80.MIN.oldValue = false;
                        objFine_blw_80.Fine_blw_80.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_80.Fine_blw_80.MIN.oldValue = parseFloat(objProductOld.Param13_Low).toFixed(objProductOld.Param13_DP);
                        objFine_blw_80.Fine_blw_80.MIN.newValue = objProductNew.flt_FineMin_blw_80;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param13_Low === null) && (objProductNew.flt_FineMin_blw_80 !== null)) {
                        objFine_blw_80.Fine_blw_80.MIN.oldValue = "NA";
                        objFine_blw_80.Fine_blw_80.MIN.newValue = objProductNew.flt_FineMin_blw_80;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param13_Low !== null) && (objProductNew.flt_FineMin_blw_80 === null)) {
                        objFine_blw_80.Fine_blw_80.MIN.oldValue = parseFloat(objProductOld.Param13_Low).toFixed(objProductOld.Param13_DP);
                        objFine_blw_80.Fine_blw_80.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_80 != "" && objProductNew.flt_FineMax_blw_80 != undefined) {
                    objFine_blw_80.Fine_blw_80.MAX.oldValue = "NA";
                    objFine_blw_80.Fine_blw_80.MAX.newValue = objProductNew.flt_FineMax_blw_80;
                    IsChanged = true;
                }
                else {
                    objFine_blw_80.Fine_blw_80.MAX.oldValue = false;
                    objFine_blw_80.Fine_blw_80.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param13_Upp == "" || objProductOld.Param13_Upp == this.strNullValue || objProductOld.Param13_Upp == undefined) {
                    objProductOld.Param13_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_80 == "" || objProductNew.flt_FineMax_blw_80 == this.strNullValue || objProductNew.flt_FineMax_blw_80 == undefined) {
                    objProductNew.flt_FineMax_blw_80 = null;
                }
    
                if ((objProductOld.Param13_Upp !== null) && (objProductNew.flt_FineMax_blw_80 !== null)) {
                    if (parseFloat(objProductOld.Param13_Upp).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_FineMax_blw_80).toFixed(objProductNew.int_fineDpGran_blw_80)) {
                        objFine_blw_80.Fine_blw_80.MAX.oldValue = false;
                        objFine_blw_80.Fine_blw_80.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_80.Fine_blw_80.MAX.oldValue = parseFloat(objProductOld.Param13_Upp).toFixed(objProductOld.Param13_DP);
                        objFine_blw_80.Fine_blw_80.MAX.newValue = objProductNew.flt_FineMax_blw_80;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param13_Upp === null) && (objProductNew.flt_FineMax_blw_80 !== null)) {
                        objFine_blw_80.Fine_blw_80.MAX.oldValue = "NA";
                        objFine_blw_80.Fine_blw_80.MAX.newValue = objProductNew.flt_FineMax_blw_80;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param13_Upp !== null) && (objProductNew.flt_FineMax_blw_80 === null)) {
                        objFine_blw_80.Fine_blw_80.MAX.oldValue = parseFloat(objProductOld.Param13_Upp).toFixed(objProductOld.Param13_DP);
                        objFine_blw_80.Fine_blw_80.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_80);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_80(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_80 = {
                Fine_abv_80: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_80 != "" && objProductNew.flt_FineMin_abv_80 != undefined) {
                    objFine_abv_80.Fine_abv_80.MIN.oldValue = "NA";
                    objFine_abv_80.Fine_abv_80.MIN.newValue = objProductNew.flt_FineMin_abv_80;
                    IsChanged = true;
                }
                else {
                    objFine_abv_80.Fine_abv_80.MIN.oldValue = false;
                    objFine_abv_80.Fine_abv_80.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param18_Low === "" || objProductOld.Param18_Low == this.strNullValue || objProductOld.Param18_Low == undefined) {
                    objProductOld.Param18_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_80 == "" || objProductNew.flt_FineMin_abv_80 == this.strNullValue || objProductNew.flt_FineMin_abv_80 == undefined) {
                    objProductNew.flt_FineMin_abv_80 = null;
                }
    
                if ((objProductOld.Param18_Low !== null) && (objProductNew.flt_FineMin_abv_80 !== null)) {
                    if (parseFloat(objProductOld.Param18_Low).toFixed(objProductOld.Param18_DP) == parseFloat(objProductNew.flt_FineMin_abv_80).toFixed(objProductNew.int_fineDpGran_abv_80)) {
                        objFine_abv_80.Fine_abv_80.MIN.oldValue = false;
                        objFine_abv_80.Fine_abv_80.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_80.Fine_abv_80.MIN.oldValue = parseFloat(objProductOld.Param18_Low).toFixed(objProductOld.Param18_DP);
                        objFine_abv_80.Fine_abv_80.MIN.newValue = objProductNew.flt_FineMin_abv_80;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param18_Low === null) && (objProductNew.flt_FineMin_abv_80 !== null)) {
                        objFine_abv_80.Fine_abv_80.MIN.oldValue = "NA";
                        objFine_abv_80.Fine_abv_80.MIN.newValue = objProductNew.flt_FineMin_abv_80;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param18_Low !== null) && (objProductNew.flt_FineMin_abv_80 === null)) {
                        objFine_abv_80.Fine_abv_80.MIN.oldValue = parseFloat(objProductOld.Param18_Low).toFixed(objProductOld.Param18_DP);
                        objFine_abv_80.Fine_abv_80.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_80 != "" && objProductNew.flt_FineMax_abv_80 != undefined) {
                    objFine_abv_80.Fine_abv_80.MAX.oldValue = "NA";
                    objFine_abv_80.Fine_abv_80.MAX.newValue = objProductNew.flt_FineMax_abv_80;
                    IsChanged = true;
                }
                else {
                    objFine_abv_80.Fine_abv_80.MAX.oldValue = false;
                    objFine_abv_80.Fine_abv_80.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param18_Upp == "" || objProductOld.Param18_Upp == this.strNullValue || objProductOld.Param18_Upp == undefined) {
                    objProductOld.Param18_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_80 == "" || objProductNew.flt_FineMax_abv_80 == this.strNullValue || objProductNew.flt_FineMax_abv_80 == undefined) {
                    objProductNew.flt_FineMax_abv_80 = null;
                }
    
                if ((objProductOld.Param18_Upp !== null) && (objProductNew.flt_FineMax_abv_80 !== null)) {
                    if (parseFloat(objProductOld.Param18_Upp).toFixed(objProductOld.Param18_DP) == parseFloat(objProductNew.flt_FineMax_abv_80).toFixed(objProductNew.int_fineDpGran_abv_80)) {
                        objFine_abv_80.Fine_abv_80.MAX.oldValue = false;
                        objFine_abv_80.Fine_abv_80.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_80.Fine_abv_80.MAX.oldValue = parseFloat(objProductOld.Param18_Upp).toFixed(objProductOld.Param18_DP);
                        objFine_abv_80.Fine_abv_80.MAX.newValue = objProductNew.flt_FineMax_abv_80;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param18_Upp === null) && (objProductNew.flt_FineMax_abv_80 !== null)) {
                        objFine_abv_80.Fine_abv_80.MAX.oldValue = "NA";
                        objFine_abv_80.Fine_abv_80.MAX.newValue = objProductNew.flt_FineMax_abv_80;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param18_Upp !== null) && (objProductNew.flt_FineMax_abv_80 === null)) {
                        objFine_abv_80.Fine_abv_80.MAX.oldValue = parseFloat(objProductOld.Param18_Upp).toFixed(objProductOld.Param18_DP);
                        objFine_abv_80.Fine_abv_80.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_80);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_100(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_100 = {
                Fine_blw_100: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_100 != "" && objProductNew.flt_FineMin_blw_100 != undefined) {
                    objFine_blw_100.Fine_blw_100.MIN.oldValue = "NA";
                    objFine_blw_100.Fine_blw_100.MIN.newValue = objProductNew.flt_FineMin_blw_100;
                    IsChanged = true;
                }
                else {
                    objFine_blw_100.Fine_blw_100.MIN.oldValue = false;
                    objFine_blw_100.Fine_blw_100.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param14_Low === "" || objProductOld.Param14_Low == this.strNullValue || objProductOld.Param14_Low == undefined) {
                    objProductOld.Param14_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_100 == "" || objProductNew.flt_FineMin_blw_100 == this.strNullValue || objProductNew.flt_FineMin_blw_100 == undefined) {
                    objProductNew.flt_FineMin_blw_100 = null;
                }
    
                if ((objProductOld.Param14_Low !== null) && (objProductNew.flt_FineMin_blw_100 !== null)) {
                    if (parseFloat(objProductOld.Param14_Low).toFixed(objProductOld.Param14_DP) == parseFloat(objProductNew.flt_FineMin_blw_100).toFixed(objProductNew.int_fineDpGran_blw_100)) {
                        objFine_blw_100.Fine_blw_100.MIN.oldValue = false;
                        objFine_blw_100.Fine_blw_100.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_100.Fine_blw_100.MIN.oldValue = parseFloat(objProductOld.Param14_Low).toFixed(objProductOld.Param14_DP);
                        objFine_blw_100.Fine_blw_100.MIN.newValue = objProductNew.flt_FineMin_blw_100;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param14_Low === null) && (objProductNew.flt_FineMin_blw_100 !== null)) {
                        objFine_blw_100.Fine_blw_100.MIN.oldValue = "NA";
                        objFine_blw_100.Fine_blw_100.MIN.newValue = objProductNew.flt_FineMin_blw_100;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param14_Low !== null) && (objProductNew.flt_FineMin_blw_100 === null)) {
                        objFine_blw_100.Fine_blw_100.MIN.oldValue = parseFloat(objProductOld.Param14_Low).toFixed(objProductOld.Param14_DP);
                        objFine_blw_100.Fine_blw_100.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_100 != "" && objProductNew.flt_FineMax_blw_100 != undefined) {
                    objFine_blw_100.Fine_blw_100.MAX.oldValue = "NA";
                    objFine_blw_100.Fine_blw_100.MAX.newValue = objProductNew.flt_FineMax_blw_100;
                    IsChanged = true;
                }
                else {
                    objFine_blw_100.Fine_blw_100.MAX.oldValue = false;
                    objFine_blw_100.Fine_blw_100.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param14_Upp == "" || objProductOld.Param14_Upp == this.strNullValue || objProductOld.Param14_Upp == undefined) {
                    objProductOld.Param14_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_100 == "" || objProductNew.flt_FineMax_blw_100 == this.strNullValue || objProductNew.flt_FineMax_blw_100 == undefined) {
                    objProductNew.flt_FineMax_blw_100 = null;
                }
    
                if ((objProductOld.Param14_Upp !== null) && (objProductNew.flt_FineMax_blw_100 !== null)) {
                    if (parseFloat(objProductOld.Param14_Upp).toFixed(objProductOld.Param14_DP) == parseFloat(objProductNew.flt_FineMax_blw_100).toFixed(objProductNew.int_fineDpGran_blw_100)) {
                        objFine_blw_100.Fine_blw_100.MAX.oldValue = false;
                        objFine_blw_100.Fine_blw_100.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_100.Fine_blw_100.MAX.oldValue = parseFloat(objProductOld.Param14_Upp).toFixed(objProductOld.Param14_DP);
                        objFine_blw_100.Fine_blw_100.MAX.newValue = objProductNew.flt_FineMax_blw_100;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param14_Upp === null) && (objProductNew.flt_FineMax_blw_100 !== null)) {
                        objFine_blw_100.Fine_blw_100.MAX.oldValue = "NA";
                        objFine_blw_100.Fine_blw_100.MAX.newValue = objProductNew.flt_FineMax_blw_100;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param14_Upp !== null) && (objProductNew.flt_FineMax_blw_100 === null)) {
                        objFine_blw_100.Fine_blw_100.MAX.oldValue = parseFloat(objProductOld.Param14_Upp).toFixed(objProductOld.Param14_DP);
                        objFine_blw_100.Fine_blw_100.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_100);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_100(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_100 = {
                Fine_abv_100: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_100 != "" && objProductNew.flt_FineMin_abv_100 != undefined) {
                    objFine_abv_100.Fine_abv_100.MIN.oldValue = "NA";
                    objFine_abv_100.Fine_abv_100.MIN.newValue = objProductNew.flt_FineMin_abv_100;
                    IsChanged = true;
                }
                else {
                    objFine_abv_100.Fine_abv_100.MIN.oldValue = false;
                    objFine_abv_100.Fine_abv_100.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param19_Low === "" || objProductOld.Param19_Low == this.strNullValue || objProductOld.Param19_Low == undefined) {
                    objProductOld.Param19_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_100 == "" || objProductNew.flt_FineMin_abv_100 == this.strNullValue || objProductNew.flt_FineMin_abv_100 == undefined) {
                    objProductNew.flt_FineMin_abv_100 = null;
                }
    
                if ((objProductOld.Param19_Low !== null) && (objProductNew.flt_FineMin_abv_100 !== null)) {
                    if (parseFloat(objProductOld.Param19_Low).toFixed(objProductOld.Param19_DP) == parseFloat(objProductNew.flt_FineMin_abv_100).toFixed(objProductNew.int_fineDpGran_abv_100)) {
                        objFine_abv_100.Fine_abv_100.MIN.oldValue = false;
                        objFine_abv_100.Fine_abv_100.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_100.Fine_abv_100.MIN.oldValue = parseFloat(objProductOld.Param19_Low).toFixed(objProductOld.Param19_DP);
                        objFine_abv_100.Fine_abv_100.MIN.newValue = objProductNew.flt_FineMin_abv_100;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param19_Low === null) && (objProductNew.flt_FineMin_abv_100 !== null)) {
                        objFine_abv_100.Fine_abv_100.MIN.oldValue = "NA";
                        objFine_abv_100.Fine_abv_100.MIN.newValue = objProductNew.flt_FineMin_abv_100;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param19_Low !== null) && (objProductNew.flt_FineMin_abv_100 === null)) {
                        objFine_abv_100.Fine_abv_100.MIN.oldValue = parseFloat(objProductOld.Param19_Low).toFixed(objProductOld.Param19_DP);
                        objFine_abv_100.Fine_abv_100.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_100 != "" && objProductNew.flt_FineMax_abv_100 != undefined) {
                    objFine_abv_100.Fine_abv_100.MAX.oldValue = "NA";
                    objFine_abv_100.Fine_abv_100.MAX.newValue = objProductNew.flt_FineMax_abv_100;
                    IsChanged = true;
                }
                else {
                    objFine_abv_100.Fine_abv_100.MAX.oldValue = false;
                    objFine_abv_100.Fine_abv_100.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param19_Upp == "" || objProductOld.Param19_Upp == this.strNullValue || objProductOld.Param19_Upp == undefined) {
                    objProductOld.Param19_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_100 == "" || objProductNew.flt_FineMax_abv_100 == this.strNullValue || objProductNew.flt_FineMax_abv_100 == undefined) {
                    objProductNew.flt_FineMax_abv_100 = null;
                }
    
                if ((objProductOld.Param19_Upp !== null) && (objProductNew.flt_FineMax_abv_100 !== null)) {
                    if (parseFloat(objProductOld.Param19_Upp).toFixed(objProductOld.Param19_DP) == parseFloat(objProductNew.flt_FineMax_abv_100).toFixed(objProductNew.int_fineDpGran_abv_100)) {
                        objFine_abv_100.Fine_abv_100.MAX.oldValue = false;
                        objFine_abv_100.Fine_abv_100.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_100.Fine_abv_100.MAX.oldValue = parseFloat(objProductOld.Param19_Upp).toFixed(objProductOld.Param19_DP);
                        objFine_abv_100.Fine_abv_100.MAX.newValue = objProductNew.flt_FineMax_abv_100;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param19_Upp === null) && (objProductNew.flt_FineMax_abv_100 !== null)) {
                        objFine_abv_100.Fine_abv_100.MAX.oldValue = "NA";
                        objFine_abv_100.Fine_abv_100.MAX.newValue = objProductNew.flt_FineMax_abv_100;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param19_Upp !== null) && (objProductNew.flt_FineMax_abv_100 === null)) {
                        objFine_abv_100.Fine_abv_100.MAX.oldValue = parseFloat(objProductOld.Param19_Upp).toFixed(objProductOld.Param19_DP);
                        objFine_abv_100.Fine_abv_100.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_100);
            }
            resolve(IsChanged);
        });
    }

    validateFine_Pan(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Pan = {
                Fine_Pan: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_Pan != "" && objProductNew.flt_FineMin_Pan != undefined) {
                    objFine_Pan.Fine_Pan.MIN.oldValue = "NA";
                    objFine_Pan.Fine_Pan.MIN.newValue = objProductNew.flt_FineMin_Pan;
                    IsChanged = true;
                }
                else {
                    objFine_Pan.Fine_Pan.MIN.oldValue = false;
                    objFine_Pan.Fine_Pan.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param20_Low === "" || objProductOld.Param20_Low == this.strNullValue || objProductOld.Param20_Low == undefined) {
                    objProductOld.Param20_Low = null;
                }
    
                if (objProductNew.flt_FineMin_Pan == "" || objProductNew.flt_FineMin_Pan == this.strNullValue || objProductNew.flt_FineMin_Pan == undefined) {
                    objProductNew.flt_FineMin_Pan = null;
                }
    
                if ((objProductOld.Param20_Low !== null) && (objProductNew.flt_FineMin_Pan !== null)) {
                    if (parseFloat(objProductOld.Param20_Low).toFixed(objProductOld.Param20_DP) == parseFloat(objProductNew.flt_FineMin_Pan).toFixed(objProductNew.int_fineDpGran_Pan)) {
                        objFine_Pan.Fine_Pan.MIN.oldValue = false;
                        objFine_Pan.Fine_Pan.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Pan.Fine_Pan.MIN.oldValue = parseFloat(objProductOld.Param20_Low).toFixed(objProductOld.Param20_DP);
                        objFine_Pan.Fine_Pan.MIN.newValue = objProductNew.flt_FineMin_Pan;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param20_Low === null) && (objProductNew.flt_FineMin_Pan !== null)) {
                        objFine_Pan.Fine_Pan.MIN.oldValue = "NA";
                        objFine_Pan.Fine_Pan.MIN.newValue = objProductNew.flt_FineMin_Pan;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param20_Low !== null) && (objProductNew.flt_FineMin_Pan === null)) {
                        objFine_Pan.Fine_Pan.MIN.oldValue = parseFloat(objProductOld.Param20_Low).toFixed(objProductOld.Param20_DP);
                        objFine_Pan.Fine_Pan.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_Pan != "" && objProductNew.flt_FineMax_Pan != undefined) {
                    objFine_Pan.Fine_Pan.MAX.oldValue = "NA";
                    objFine_Pan.Fine_Pan.MAX.newValue = objProductNew.flt_FineMax_Pan;
                    IsChanged = true;
                }
                else {
                    objFine_Pan.Fine_Pan.MAX.oldValue = false;
                    objFine_Pan.Fine_Pan.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param20_Upp == "" || objProductOld.Param20_Upp == this.strNullValue || objProductOld.Param20_Upp == undefined) {
                    objProductOld.Param20_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_Pan == "" || objProductNew.flt_FineMax_Pan == this.strNullValue || objProductNew.flt_FineMax_Pan == undefined) {
                    objProductNew.flt_FineMax_Pan = null;
                }
    
                if ((objProductOld.Param20_Upp !== null) && (objProductNew.flt_FineMax_Pan !== null)) {
                    if (parseFloat(objProductOld.Param20_Upp).toFixed(objProductOld.Param20_DP) == parseFloat(objProductNew.flt_FineMax_Pan).toFixed(objProductNew.int_fineDpGran_Pan)) {
                        objFine_Pan.Fine_Pan.MAX.oldValue = false;
                        objFine_Pan.Fine_Pan.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Pan.Fine_Pan.MAX.oldValue = parseFloat(objProductOld.Param20_Upp).toFixed(objProductOld.Param20_DP);
                        objFine_Pan.Fine_Pan.MAX.newValue = objProductNew.flt_FineMax_Pan;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param20_Upp === null) && (objProductNew.flt_FineMax_Pan !== null)) {
                        objFine_Pan.Fine_Pan.MAX.oldValue = "NA";
                        objFine_Pan.Fine_Pan.MAX.newValue = objProductNew.flt_FineMax_Pan;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param20_Upp !== null) && (objProductNew.flt_FineMax_Pan === null)) {
                        objFine_Pan.Fine_Pan.MAX.oldValue = parseFloat(objProductOld.Param20_Upp).toFixed(objProductOld.Param20_DP);
                        objFine_Pan.Fine_Pan.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Pan);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_30_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_30_Lay_1 = {
                Fine_blw_30_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_30_Lay_1 != "" && objProductNew.flt_FineMin_blw_30_Lay_1 != undefined) {
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.oldValue = "NA";
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_30_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.oldValue = false;
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param21_Low === "" || objProductOld.Param21_Low == this.strNullValue || objProductOld.Param21_Low == undefined) {
                    objProductOld.Param21_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_30_Lay_1 == "" || objProductNew.flt_FineMin_blw_30_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_blw_30_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_blw_30_Lay_1 = null;
                }
    
                if ((objProductOld.Param21_Low !== null) && (objProductNew.flt_FineMin_blw_30_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param21_Low).toFixed(objProductOld.Param21_DP) == parseFloat(objProductNew.flt_FineMin_blw_30_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_30_Lay_1)) {
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.oldValue = false;
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param21_Low).toFixed(objProductOld.Param21_DP);
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_30_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param21_Low === null) && (objProductNew.flt_FineMin_blw_30_Lay_1 !== null)) {
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.oldValue = "NA";
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_30_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param21_Low !== null) && (objProductNew.flt_FineMin_blw_30_Lay_1 === null)) {
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param21_Low).toFixed(objProductOld.Param21_DP);
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_30_Lay_1 != "" && objProductNew.flt_FineMax_blw_30_Lay_1 != undefined) {
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.oldValue = "NA";
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_30_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.oldValue = false;
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param21_Upp == "" || objProductOld.Param21_Upp == this.strNullValue || objProductOld.Param21_Upp == undefined) {
                    objProductOld.Param21_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_30_Lay_1 == "" || objProductNew.flt_FineMax_blw_30_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_blw_30_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_blw_30_Lay_1 = null;
                }
    
                if ((objProductOld.Param21_Upp !== null) && (objProductNew.flt_FineMax_blw_30_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param21_Upp).toFixed(objProductOld.Param21_DP) == parseFloat(objProductNew.flt_FineMax_blw_30_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_30_Lay_1)) {
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.oldValue = false;
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param21_Upp).toFixed(objProductOld.Param21_DP);
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_30_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param21_Upp === null) && (objProductNew.flt_FineMax_blw_30_Lay_1 !== null)) {
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.oldValue = "NA";
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_30_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param21_Upp !== null) && (objProductNew.flt_FineMax_blw_30_Lay_1 === null)) {
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param21_Upp).toFixed(objProductOld.Param21_DP);
                        objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_30_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_30_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_30_Lay_1 = {
                Fine_abv_30_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_30_Lay_1 != "" && objProductNew.flt_FineMin_abv_30_Lay_1 != undefined) {
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.oldValue = "NA";
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_30_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.oldValue = false;
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param26_Low === "" || objProductOld.Param26_Low == this.strNullValue || objProductOld.Param26_Low == undefined) {
                    objProductOld.Param26_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_30_Lay_1 == "" || objProductNew.flt_FineMin_abv_30_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_abv_30_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_abv_30_Lay_1 = null;
                }
    
                if ((objProductOld.Param26_Low !== null) && (objProductNew.flt_FineMin_abv_30_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param26_Low).toFixed(objProductOld.Param26_DP) == parseFloat(objProductNew.flt_FineMin_abv_30_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_30_Lay_1)) {
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.oldValue = false;
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param26_Low).toFixed(objProductOld.Param26_DP);
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_30_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param26_Low === null) && (objProductNew.flt_FineMin_abv_30_Lay_1 !== null)) {
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.oldValue = "NA";
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_30_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param26_Low !== null) && (objProductNew.flt_FineMin_abv_30_Lay_1 === null)) {
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param26_Low).toFixed(objProductOld.Param26_DP);
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_30_Lay_1 != "" && objProductNew.flt_FineMax_abv_30_Lay_1 != undefined) {
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.oldValue = "NA";
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_30_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.oldValue = false;
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param26_Upp == "" || objProductOld.Param26_Upp == this.strNullValue || objProductOld.Param26_Upp == undefined) {
                    objProductOld.Param26_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_30_Lay_1 == "" || objProductNew.flt_FineMax_abv_30_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_abv_30_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_abv_30_Lay_1 = null;
                }
    
                if ((objProductOld.Param26_Upp !== null) && (objProductNew.flt_FineMax_abv_30_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param26_Upp).toFixed(objProductOld.Param26_DP) == parseFloat(objProductNew.flt_FineMax_abv_30_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_30_Lay_1)) {
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.oldValue = false;
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param26_Upp).toFixed(objProductOld.Param26_DP);
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_30_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param26_Upp === null) && (objProductNew.flt_FineMax_abv_30_Lay_1 !== null)) {
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.oldValue = "NA";
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_30_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param26_Upp !== null) && (objProductNew.flt_FineMax_abv_30_Lay_1 === null)) {
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param26_Upp).toFixed(objProductOld.Param26_DP);
                        objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_30_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_40_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_40_Lay_1 = {
                Fine_blw_40_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_40_Lay_1 != "" && objProductNew.flt_FineMin_blw_40_Lay_1 != undefined) {
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.oldValue = "NA";
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_40_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.oldValue = false;
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param22_Low === "" || objProductOld.Param22_Low == this.strNullValue || objProductOld.Param22_Low == undefined) {
                    objProductOld.Param22_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_40_Lay_1 == "" || objProductNew.flt_FineMin_blw_40_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_blw_40_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_blw_40_Lay_1 = null;
                }
    
                if ((objProductOld.Param22_Low !== null) && (objProductNew.flt_FineMin_blw_40_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param22_Low).toFixed(objProductOld.Param22_DP) == parseFloat(objProductNew.flt_FineMin_blw_40_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_40_Lay_1)) {
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.oldValue = false;
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param22_Low).toFixed(objProductOld.Param22_DP);
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_40_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param22_Low === null) && (objProductNew.flt_FineMin_blw_40_Lay_1 !== null)) {
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.oldValue = "NA";
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_40_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param22_Low !== null) && (objProductNew.flt_FineMin_blw_40_Lay_1 === null)) {
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param22_Low).toFixed(objProductOld.Param22_DP);
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_40_Lay_1 != "" && objProductNew.flt_FineMax_blw_40_Lay_1 != undefined) {
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.oldValue = "NA";
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_40_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.oldValue = false;
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param22_Upp == "" || objProductOld.Param22_Upp == this.strNullValue || objProductOld.Param22_Upp == undefined) {
                    objProductOld.Param22_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_40_Lay_1 == "" || objProductNew.flt_FineMax_blw_40_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_blw_40_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_blw_40_Lay_1 = null;
                }
    
                if ((objProductOld.Param22_Upp !== null) && (objProductNew.flt_FineMax_blw_40_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param22_Upp).toFixed(objProductOld.Param22_DP) == parseFloat(objProductNew.flt_FineMax_blw_40_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_40_Lay_1)) {
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.oldValue = false;
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param22_Upp).toFixed(objProductOld.Param22_DP);
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_40_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param22_Upp === null) && (objProductNew.flt_FineMax_blw_40_Lay_1 !== null)) {
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.oldValue = "NA";
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_40_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param22_Upp !== null) && (objProductNew.flt_FineMax_blw_40_Lay_1 === null)) {
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param22_Upp).toFixed(objProductOld.Param22_DP);
                        objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_40_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_40_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_40_Lay_1 = {
                Fine_abv_40_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_40_Lay_1 != "" && objProductNew.flt_FineMin_abv_40_Lay_1 != undefined) {
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.oldValue = "NA";
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_40_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.oldValue = false;
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param27_Low === "" || objProductOld.Param27_Low == this.strNullValue || objProductOld.Param27_Low == undefined) {
                    objProductOld.Param27_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_40_Lay_1 == "" || objProductNew.flt_FineMin_abv_40_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_abv_40_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_abv_40_Lay_1 = null;
                }
    
                if ((objProductOld.Param27_Low !== null) && (objProductNew.flt_FineMin_abv_40_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param27_Low).toFixed(objProductOld.Param27_DP) == parseFloat(objProductNew.flt_FineMin_abv_40_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_40_Lay_1)) {
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.oldValue = false;
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param27_Low).toFixed(objProductOld.Param27_DP);
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_40_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param27_Low === null) && (objProductNew.flt_FineMin_abv_40_Lay_1 !== null)) {
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.oldValue = "NA";
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_40_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param27_Low !== null) && (objProductNew.flt_FineMin_abv_40_Lay_1 === null)) {
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param27_Low).toFixed(objProductOld.Param27_DP);
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_40_Lay_1 != "" && objProductNew.flt_FineMax_abv_40_Lay_1 != undefined) {
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.oldValue = "NA";
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_40_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.oldValue = false;
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param27_Upp == "" || objProductOld.Param27_Upp == this.strNullValue || objProductOld.Param27_Upp == undefined) {
                    objProductOld.Param27_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_40_Lay_1 == "" || objProductNew.flt_FineMax_abv_40_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_abv_40_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_abv_40_Lay_1 = null;
                }
    
                if ((objProductOld.Param27_Upp !== null) && (objProductNew.flt_FineMax_abv_40_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param27_Upp).toFixed(objProductOld.Param27_DP) == parseFloat(objProductNew.flt_FineMax_abv_40_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_40_Lay_1)) {
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.oldValue = false;
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param27_Upp).toFixed(objProductOld.Param27_DP);
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_40_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param27_Upp === null) && (objProductNew.flt_FineMax_abv_40_Lay_1 !== null)) {
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.oldValue = "NA";
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_40_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param27_Upp !== null) && (objProductNew.flt_FineMax_abv_40_Lay_1 === null)) {
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param27_Upp).toFixed(objProductOld.Param27_DP);
                        objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_40_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_60_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_60_Lay_1 = {
                Fine_blw_60_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_60_Lay_1 != "" && objProductNew.flt_FineMin_blw_60_Lay_1 != undefined) {
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.oldValue = "NA";
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_60_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.oldValue = false;
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param23_Low === "" || objProductOld.Param23_Low == this.strNullValue || objProductOld.Param23_Low == undefined) {
                    objProductOld.Param23_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_60_Lay_1 == "" || objProductNew.flt_FineMin_blw_60_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_blw_60_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_blw_60_Lay_1 = null;
                }
    
                if ((objProductOld.Param23_Low !== null) && (objProductNew.flt_FineMin_blw_60_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param23_Low).toFixed(objProductOld.Param23_DP) == parseFloat(objProductNew.flt_FineMin_blw_60_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_60_Lay_1)) {
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.oldValue = false;
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param23_Low).toFixed(objProductOld.Param23_DP);
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_60_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param23_Low === null) && (objProductNew.flt_FineMin_blw_60_Lay_1 !== null)) {
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.oldValue = "NA";
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_60_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param23_Low !== null) && (objProductNew.flt_FineMin_blw_60_Lay_1 === null)) {
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param23_Low).toFixed(objProductOld.Param23_DP);
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_60_Lay_1 != "" && objProductNew.flt_FineMax_blw_60_Lay_1 != undefined) {
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.oldValue = "NA";
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_60_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.oldValue = false;
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param23_Upp == "" || objProductOld.Param23_Upp == this.strNullValue || objProductOld.Param23_Upp == undefined) {
                    objProductOld.Param23_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_60_Lay_1 == "" || objProductNew.flt_FineMax_blw_60_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_blw_60_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_blw_60_Lay_1 = null;
                }
    
                if ((objProductOld.Param23_Upp !== null) && (objProductNew.flt_FineMax_blw_60_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param23_Upp).toFixed(objProductOld.Param23_DP) == parseFloat(objProductNew.flt_FineMax_blw_60_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_60_Lay_1)) {
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.oldValue = false;
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param23_Upp).toFixed(objProductOld.Param23_DP);
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_60_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param23_Upp === null) && (objProductNew.flt_FineMax_blw_60_Lay_1 !== null)) {
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.oldValue = "NA";
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_60_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param23_Upp !== null) && (objProductNew.flt_FineMax_blw_60_Lay_1 === null)) {
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param23_Upp).toFixed(objProductOld.Param23_DP);
                        objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_60_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_60_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_60_Lay_1 = {
                Fine_abv_60_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_60_Lay_1 != "" && objProductNew.flt_FineMin_abv_60_Lay_1 != undefined) {
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.oldValue = "NA";
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_60_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.oldValue = false;
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param28_Low === "" || objProductOld.Param28_Low == this.strNullValue || objProductOld.Param28_Low == undefined) {
                    objProductOld.Param28_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_60_Lay_1 == "" || objProductNew.flt_FineMin_abv_60_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_abv_60_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_abv_60_Lay_1 = null;
                }
    
                if ((objProductOld.Param28_Low !== null) && (objProductNew.flt_FineMin_abv_60_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param28_Low).toFixed(objProductOld.Param28_DP) == parseFloat(objProductNew.flt_FineMin_abv_60_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_60_Lay_1)) {
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.oldValue = false;
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param28_Low).toFixed(objProductOld.Param28_DP);
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_60_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param28_Low === null) && (objProductNew.flt_FineMin_abv_60_Lay_1 !== null)) {
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.oldValue = "NA";
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_60_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param28_Low !== null) && (objProductNew.flt_FineMin_abv_60_Lay_1 === null)) {
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param28_Low).toFixed(objProductOld.Param28_DP);
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_60_Lay_1 != "" && objProductNew.flt_FineMax_abv_60_Lay_1 != undefined) {
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.oldValue = "NA";
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_60_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.oldValue = false;
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param28_Upp == "" || objProductOld.Param28_Upp == this.strNullValue || objProductOld.Param28_Upp == undefined) {
                    objProductOld.Param28_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_60_Lay_1 == "" || objProductNew.flt_FineMax_abv_60_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_abv_60_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_abv_60_Lay_1 = null;
                }
    
                if ((objProductOld.Param28_Upp !== null) && (objProductNew.flt_FineMax_abv_60_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param28_Upp).toFixed(objProductOld.Param28_DP) == parseFloat(objProductNew.flt_FineMax_abv_60_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_60_Lay_1)) {
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.oldValue = false;
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param28_Upp).toFixed(objProductOld.Param28_DP);
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_60_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param28_Upp === null) && (objProductNew.flt_FineMax_abv_60_Lay_1 !== null)) {
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.oldValue = "NA";
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_60_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param28_Upp !== null) && (objProductNew.flt_FineMax_abv_60_Lay_1 === null)) {
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param28_Upp).toFixed(objProductOld.Param28_DP);
                        objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_60_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_80_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_80_Lay_1 = {
                Fine_blw_80_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_80_Lay_1 != "" && objProductNew.flt_FineMin_blw_80_Lay_1 != undefined) {
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.oldValue = "NA";
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_80_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.oldValue = false;
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param24_Low === "" || objProductOld.Param24_Low == this.strNullValue || objProductOld.Param24_Low == undefined) {
                    objProductOld.Param24_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_80_Lay_1 == "" || objProductNew.flt_FineMin_blw_80_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_blw_80_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_blw_80_Lay_1 = null;
                }
    
                if ((objProductOld.Param24_Low !== null) && (objProductNew.flt_FineMin_blw_80_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param24_Low).toFixed(objProductOld.Param24_DP) == parseFloat(objProductNew.flt_FineMin_blw_80_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_80_Lay_1)) {
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.oldValue = false;
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param24_Low).toFixed(objProductOld.Param24_DP);
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_80_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param24_Low === null) && (objProductNew.flt_FineMin_blw_80_Lay_1 !== null)) {
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.oldValue = "NA";
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_80_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param24_Low !== null) && (objProductNew.flt_FineMin_blw_80_Lay_1 === null)) {
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param24_Low).toFixed(objProductOld.Param24_DP);
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_80_Lay_1 != "" && objProductNew.flt_FineMax_blw_80_Lay_1 != undefined) {
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.oldValue = "NA";
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_80_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.oldValue = false;
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param24_Upp == "" || objProductOld.Param24_Upp == this.strNullValue || objProductOld.Param24_Upp == undefined) {
                    objProductOld.Param24_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_80_Lay_1 == "" || objProductNew.flt_FineMax_blw_80_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_blw_80_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_blw_80_Lay_1 = null;
                }
    
                if ((objProductOld.Param24_Upp !== null) && (objProductNew.flt_FineMax_blw_80_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param24_Upp).toFixed(objProductOld.Param24_DP) == parseFloat(objProductNew.flt_FineMax_blw_80_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_80_Lay_1)) {
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.oldValue = false;
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param24_Upp).toFixed(objProductOld.Param24_DP);
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_80_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param24_Upp === null) && (objProductNew.flt_FineMax_blw_80_Lay_1 !== null)) {
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.oldValue = "NA";
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_80_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param24_Upp !== null) && (objProductNew.flt_FineMax_blw_80_Lay_1 === null)) {
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param24_Upp).toFixed(objProductOld.Param24_DP);
                        objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_80_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_80_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_80_Lay_1 = {
                Fine_abv_80_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_80_Lay_1 != "" && objProductNew.flt_FineMin_abv_80_Lay_1 != undefined) {
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.oldValue = "NA";
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_80_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.oldValue = false;
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param29_Low === "" || objProductOld.Param29_Low == this.strNullValue || objProductOld.Param29_Low == undefined) {
                    objProductOld.Param29_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_80_Lay_1 == "" || objProductNew.flt_FineMin_abv_80_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_abv_80_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_abv_80_Lay_1 = null;
                }
    
                if ((objProductOld.Param29_Low !== null) && (objProductNew.flt_FineMin_abv_80_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param29_Low).toFixed(objProductOld.Param29_DP) == parseFloat(objProductNew.flt_FineMin_abv_80_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_80_Lay_1)) {
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.oldValue = false;
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param29_Low).toFixed(objProductOld.Param29_DP);
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_80_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param29_Low === null) && (objProductNew.flt_FineMin_abv_80_Lay_1 !== null)) {
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.oldValue = "NA";
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_80_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param29_Low !== null) && (objProductNew.flt_FineMin_abv_80_Lay_1 === null)) {
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param29_Low).toFixed(objProductOld.Param29_DP);
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_80_Lay_1 != "" && objProductNew.flt_FineMax_abv_80_Lay_1 != undefined) {
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.oldValue = "NA";
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_80_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.oldValue = false;
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param29_Upp == "" || objProductOld.Param29_Upp == this.strNullValue || objProductOld.Param29_Upp == undefined) {
                    objProductOld.Param29_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_80_Lay_1 == "" || objProductNew.flt_FineMax_abv_80_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_abv_80_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_abv_80_Lay_1 = null;
                }
    
                if ((objProductOld.Param29_Upp !== null) && (objProductNew.flt_FineMax_abv_80_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param29_Upp).toFixed(objProductOld.Param29_DP) == parseFloat(objProductNew.flt_FineMax_abv_80_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_80_Lay_1)) {
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.oldValue = false;
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param29_Upp).toFixed(objProductOld.Param29_DP);
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_80_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param29_Upp === null) && (objProductNew.flt_FineMax_abv_80_Lay_1 !== null)) {
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.oldValue = "NA";
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_80_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param29_Upp !== null) && (objProductNew.flt_FineMax_abv_80_Lay_1 === null)) {
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param29_Upp).toFixed(objProductOld.Param29_DP);
                        objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_80_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_100_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_100_Lay_1 = {
                Fine_blw_100_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_100_Lay_1 != "" && objProductNew.flt_FineMin_blw_100_Lay_1 != undefined) {
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.oldValue = "NA";
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_100_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.oldValue = false;
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param25_Low === "" || objProductOld.Param25_Low == this.strNullValue || objProductOld.Param25_Low == undefined) {
                    objProductOld.Param25_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_100_Lay_1 == "" || objProductNew.flt_FineMin_blw_100_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_blw_100_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_blw_100_Lay_1 = null;
                }
    
                if ((objProductOld.Param25_Low !== null) && (objProductNew.flt_FineMin_blw_100_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param25_Low).toFixed(objProductOld.Param25_DP) == parseFloat(objProductNew.flt_FineMin_blw_100_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_100_Lay_1)) {
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.oldValue = false;
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param25_Low).toFixed(objProductOld.Param25_DP);
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_100_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param25_Low === null) && (objProductNew.flt_FineMin_blw_100_Lay_1 !== null)) {
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.oldValue = "NA";
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.newValue = objProductNew.flt_FineMin_blw_100_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param25_Low !== null) && (objProductNew.flt_FineMin_blw_100_Lay_1 === null)) {
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param25_Low).toFixed(objProductOld.Param25_DP);
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_100_Lay_1 != "" && objProductNew.flt_FineMax_blw_100_Lay_1 != undefined) {
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.oldValue = "NA";
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_100_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.oldValue = false;
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param25_Upp == "" || objProductOld.Param25_Upp == this.strNullValue || objProductOld.Param25_Upp == undefined) {
                    objProductOld.Param25_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_100_Lay_1 == "" || objProductNew.flt_FineMax_blw_100_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_blw_100_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_blw_100_Lay_1 = null;
                }
    
                if ((objProductOld.Param25_Upp !== null) && (objProductNew.flt_FineMax_blw_100_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param25_Upp).toFixed(objProductOld.Param25_DP) == parseFloat(objProductNew.flt_FineMax_blw_100_Lay_1).toFixed(objProductNew.int_fineDpGran_blw_100_Lay_1)) {
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.oldValue = false;
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param25_Upp).toFixed(objProductOld.Param25_DP);
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_100_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param25_Upp === null) && (objProductNew.flt_FineMax_blw_100_Lay_1 !== null)) {
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.oldValue = "NA";
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.newValue = objProductNew.flt_FineMax_blw_100_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param25_Upp !== null) && (objProductNew.flt_FineMax_blw_100_Lay_1 === null)) {
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param25_Upp).toFixed(objProductOld.Param25_DP);
                        objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_100_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_100_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_100_Lay_1 = {
                Fine_abv_100_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_100_Lay_1 != "" && objProductNew.flt_FineMin_abv_100_Lay_1 != undefined) {
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.oldValue = "NA";
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_100_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.oldValue = false;
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param30_Low === "" || objProductOld.Param30_Low == this.strNullValue || objProductOld.Param30_Low == undefined) {
                    objProductOld.Param30_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_100_Lay_1 == "" || objProductNew.flt_FineMin_abv_100_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_abv_100_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_abv_100_Lay_1 = null;
                }
    
                if ((objProductOld.Param30_Low !== null) && (objProductNew.flt_FineMin_abv_100_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param30_Low).toFixed(objProductOld.Param30_DP) == parseFloat(objProductNew.flt_FineMin_abv_100_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_100_Lay_1)) {
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.oldValue = false;
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param30_Low).toFixed(objProductOld.Param30_DP);
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_100_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param30_Low === null) && (objProductNew.flt_FineMin_abv_100_Lay_1 !== null)) {
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.oldValue = "NA";
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.newValue = objProductNew.flt_FineMin_abv_100_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param30_Low !== null) && (objProductNew.flt_FineMin_abv_100_Lay_1 === null)) {
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param30_Low).toFixed(objProductOld.Param30_DP);
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_100_Lay_1 != "" && objProductNew.flt_FineMax_abv_100_Lay_1 != undefined) {
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.oldValue = "NA";
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_100_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.oldValue = false;
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param30_Upp == "" || objProductOld.Param30_Upp == this.strNullValue || objProductOld.Param30_Upp == undefined) {
                    objProductOld.Param30_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_100_Lay_1 == "" || objProductNew.flt_FineMax_abv_100_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_abv_100_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_abv_100_Lay_1 = null;
                }
    
                if ((objProductOld.Param30_Upp !== null) && (objProductNew.flt_FineMax_abv_100_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param30_Upp).toFixed(objProductOld.Param30_DP) == parseFloat(objProductNew.flt_FineMax_abv_100_Lay_1).toFixed(objProductNew.int_fineDpGran_abv_100_Lay_1)) {
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.oldValue = false;
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param30_Upp).toFixed(objProductOld.Param30_DP);
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_100_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param30_Upp === null) && (objProductNew.flt_FineMax_abv_100_Lay_1 !== null)) {
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.oldValue = "NA";
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.newValue = objProductNew.flt_FineMax_abv_100_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param30_Upp !== null) && (objProductNew.flt_FineMax_abv_100_Lay_1 === null)) {
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param30_Upp).toFixed(objProductOld.Param30_DP);
                        objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_100_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_Pan_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Pan_Lay_1 = {
                Fine_Pan_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_Pan_Lay_1 != "" && objProductNew.flt_FineMin_Pan_Lay_1 != undefined) {
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.oldValue = "NA";
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.newValue = objProductNew.flt_FineMin_Pan_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.oldValue = false;
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param31_Low === "" || objProductOld.Param31_Low == this.strNullValue || objProductOld.Param31_Low == undefined) {
                    objProductOld.Param31_Low = null;
                }
    
                if (objProductNew.flt_FineMin_Pan_Lay_1 == "" || objProductNew.flt_FineMin_Pan_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_Pan_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_Pan_Lay_1 = null;
                }
    
                if ((objProductOld.Param31_Low !== null) && (objProductNew.flt_FineMin_Pan_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param31_Low).toFixed(objProductOld.Param31_DP) == parseFloat(objProductNew.flt_FineMin_Pan_Lay_1).toFixed(objProductNew.int_fineDpGran_Pan_Lay_1)) {
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.oldValue = false;
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param31_Low).toFixed(objProductOld.Param31_DP);
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.newValue = objProductNew.flt_FineMin_Pan_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param31_Low === null) && (objProductNew.flt_FineMin_Pan_Lay_1 !== null)) {
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.oldValue = "NA";
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.newValue = objProductNew.flt_FineMin_Pan_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param31_Low !== null) && (objProductNew.flt_FineMin_Pan_Lay_1 === null)) {
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param31_Low).toFixed(objProductOld.Param31_DP);
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_Pan_Lay_1 != "" && objProductNew.flt_FineMax_Pan_Lay_1 != undefined) {
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.oldValue = "NA";
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.newValue = objProductNew.flt_FineMax_Pan_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.oldValue = false;
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param31_Upp == "" || objProductOld.Param31_Upp == this.strNullValue || objProductOld.Param31_Upp == undefined) {
                    objProductOld.Param31_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_Pan_Lay_1 == "" || objProductNew.flt_FineMax_Pan_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_Pan_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_Pan_Lay_1 = null;
                }
    
                if ((objProductOld.Param31_Upp !== null) && (objProductNew.flt_FineMax_Pan_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param31_Upp).toFixed(objProductOld.Param31_DP) == parseFloat(objProductNew.flt_FineMax_Pan_Lay_1).toFixed(objProductNew.int_fineDpGran_Pan_Lay_1)) {
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.oldValue = false;
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param31_Upp).toFixed(objProductOld.Param31_DP);
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.newValue = objProductNew.flt_FineMax_Pan_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param31_Upp === null) && (objProductNew.flt_FineMax_Pan_Lay_1 !== null)) {
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.oldValue = "NA";
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.newValue = objProductNew.flt_FineMax_Pan_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param31_Upp !== null) && (objProductNew.flt_FineMax_Pan_Lay_1 === null)) {
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param31_Upp).toFixed(objProductOld.Param31_DP);
                        objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Pan_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_30_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_30_Lay_2 = {
                Fine_blw_30_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_30_Lay_2 != "" && objProductNew.flt_FineMin_blw_30_Lay_2 != undefined) {
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.oldValue = "NA";
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_30_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.oldValue = false;
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param32_Low === "" || objProductOld.Param32_Low == this.strNullValue || objProductOld.Param32_Low == undefined) {
                    objProductOld.Param32_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_30_Lay_2 == "" || objProductNew.flt_FineMin_blw_30_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_blw_30_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_blw_30_Lay_2 = null;
                }
    
                if ((objProductOld.Param32_Low !== null) && (objProductNew.flt_FineMin_blw_30_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param32_Low).toFixed(objProductOld.Param32_DP) == parseFloat(objProductNew.flt_FineMin_blw_30_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_30_Lay_2)) {
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.oldValue = false;
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param32_Low).toFixed(objProductOld.Param32_DP);
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_30_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param32_Low === null) && (objProductNew.flt_FineMin_blw_30_Lay_2 !== null)) {
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.oldValue = "NA";
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_30_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param32_Low !== null) && (objProductNew.flt_FineMin_blw_30_Lay_2 === null)) {
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param32_Low).toFixed(objProductOld.Param32_DP);
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_30_Lay_2 != "" && objProductNew.flt_FineMax_blw_30_Lay_2 != undefined) {
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.oldValue = "NA";
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_30_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.oldValue = false;
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param32_Upp == "" || objProductOld.Param32_Upp == this.strNullValue || objProductOld.Param32_Upp == undefined) {
                    objProductOld.Param32_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_30_Lay_2 == "" || objProductNew.flt_FineMax_blw_30_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_blw_30_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_blw_30_Lay_2 = null;
                }
    
                if ((objProductOld.Param32_Upp !== null) && (objProductNew.flt_FineMax_blw_30_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param32_Upp).toFixed(objProductOld.Param32_DP) == parseFloat(objProductNew.flt_FineMax_blw_30_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_30_Lay_2)) {
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.oldValue = false;
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param32_Upp).toFixed(objProductOld.Param32_DP);
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_30_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param32_Upp === null) && (objProductNew.flt_FineMax_blw_30_Lay_2 !== null)) {
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.oldValue = "NA";
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_30_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param32_Upp !== null) && (objProductNew.flt_FineMax_blw_30_Lay_2 === null)) {
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param32_Upp).toFixed(objProductOld.Param32_DP);
                        objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_30_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_30_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_30_Lay_2 = {
                Fine_abv_30_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_30_Lay_2 != "" && objProductNew.flt_FineMin_abv_30_Lay_2 != undefined) {
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.oldValue = "NA";
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_30_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.oldValue = false;
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param37_Low === "" || objProductOld.Param37_Low == this.strNullValue || objProductOld.Param37_Low == undefined) {
                    objProductOld.Param37_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_30_Lay_2 == "" || objProductNew.flt_FineMin_abv_30_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_abv_30_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_abv_30_Lay_2 = null;
                }
    
                if ((objProductOld.Param37_Low !== null) && (objProductNew.flt_FineMin_abv_30_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param37_Low).toFixed(objProductOld.Param37_DP) == parseFloat(objProductNew.flt_FineMin_abv_30_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_30_Lay_2)) {
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.oldValue = false;
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param37_Low).toFixed(objProductOld.Param37_DP);
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_30_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param37_Low === null) && (objProductNew.flt_FineMin_abv_30_Lay_2 !== null)) {
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.oldValue = "NA";
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_30_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param37_Low !== null) && (objProductNew.flt_FineMin_abv_30_Lay_2 === null)) {
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param37_Low).toFixed(objProductOld.Param37_DP);
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_30_Lay_2 != "" && objProductNew.flt_FineMax_abv_30_Lay_2 != undefined) {
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.oldValue = "NA";
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_30_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.oldValue = false;
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param37_Upp == "" || objProductOld.Param37_Upp == this.strNullValue || objProductOld.Param37_Upp == undefined) {
                    objProductOld.Param37_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_30_Lay_2 == "" || objProductNew.flt_FineMax_abv_30_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_abv_30_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_abv_30_Lay_2 = null;
                }
    
                if ((objProductOld.Param37_Upp !== null) && (objProductNew.flt_FineMax_abv_30_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param37_Upp).toFixed(objProductOld.Param37_DP) == parseFloat(objProductNew.flt_FineMax_abv_30_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_30_Lay_2)) {
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.oldValue = false;
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param37_Upp).toFixed(objProductOld.Param37_DP);
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_30_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param37_Upp === null) && (objProductNew.flt_FineMax_abv_30_Lay_2 !== null)) {
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.oldValue = "NA";
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_30_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param37_Upp !== null) && (objProductNew.flt_FineMax_abv_30_Lay_2 === null)) {
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param37_Upp).toFixed(objProductOld.Param37_DP);
                        objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_30_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_40_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_40_Lay_2 = {
                Fine_blw_40_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_40_Lay_2 != "" && objProductNew.flt_FineMin_blw_40_Lay_2 != undefined) {
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.oldValue = "NA";
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_40_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.oldValue = false;
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param33_Low === "" || objProductOld.Param33_Low == this.strNullValue || objProductOld.Param33_Low == undefined) {
                    objProductOld.Param33_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_40_Lay_2 == "" || objProductNew.flt_FineMin_blw_40_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_blw_40_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_blw_40_Lay_2 = null;
                }
    
                if ((objProductOld.Param33_Low !== null) && (objProductNew.flt_FineMin_blw_40_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param33_Low).toFixed(objProductOld.Param33_DP) == parseFloat(objProductNew.flt_FineMin_blw_40_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_40_Lay_2)) {
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.oldValue = false;
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param33_Low).toFixed(objProductOld.Param33_DP);
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_40_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param33_Low === null) && (objProductNew.flt_FineMin_blw_40_Lay_2 !== null)) {
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.oldValue = "NA";
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_40_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param33_Low !== null) && (objProductNew.flt_FineMin_blw_40_Lay_2 === null)) {
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param33_Low).toFixed(objProductOld.Param33_DP);
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_40_Lay_2 != "" && objProductNew.flt_FineMax_blw_40_Lay_2 != undefined) {
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.oldValue = "NA";
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_40_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.oldValue = false;
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param33_Upp == "" || objProductOld.Param33_Upp == this.strNullValue || objProductOld.Param33_Upp == undefined) {
                    objProductOld.Param33_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_40_Lay_2 == "" || objProductNew.flt_FineMax_blw_40_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_blw_40_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_blw_40_Lay_2 = null;
                }
    
                if ((objProductOld.Param33_Upp !== null) && (objProductNew.flt_FineMax_blw_40_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param33_Upp).toFixed(objProductOld.Param33_DP) == parseFloat(objProductNew.flt_FineMax_blw_40_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_40_Lay_2)) {
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.oldValue = false;
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param33_Upp).toFixed(objProductOld.Param33_DP);
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_40_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param33_Upp === null) && (objProductNew.flt_FineMax_blw_40_Lay_2 !== null)) {
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.oldValue = "NA";
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_40_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param33_Upp !== null) && (objProductNew.flt_FineMax_blw_40_Lay_2 === null)) {
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param33_Upp).toFixed(objProductOld.Param33_DP);
                        objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_40_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_40_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_40_Lay_2 = {
                Fine_abv_40_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_40_Lay_2 != "" && objProductNew.flt_FineMin_abv_40_Lay_2 != undefined) {
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.oldValue = "NA";
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_40_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.oldValue = false;
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param38_Low === "" || objProductOld.Param38_Low == this.strNullValue || objProductOld.Param38_Low == undefined) {
                    objProductOld.Param38_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_40_Lay_2 == "" || objProductNew.flt_FineMin_abv_40_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_abv_40_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_abv_40_Lay_2 = null;
                }
    
                if ((objProductOld.Param38_Low !== null) && (objProductNew.flt_FineMin_abv_40_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param38_Low).toFixed(objProductOld.Param38_DP) == parseFloat(objProductNew.flt_FineMin_abv_40_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_40_Lay_2)) {
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.oldValue = false;
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param38_Low).toFixed(objProductOld.Param38_DP);
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_40_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param38_Low === null) && (objProductNew.flt_FineMin_abv_40_Lay_2 !== null)) {
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.oldValue = "NA";
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_40_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param38_Low !== null) && (objProductNew.flt_FineMin_abv_40_Lay_2 === null)) {
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param38_Low).toFixed(objProductOld.Param38_DP);
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_40_Lay_2 != "" && objProductNew.flt_FineMax_abv_40_Lay_2 != undefined) {
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.oldValue = "NA";
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_40_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.oldValue = false;
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param38_Upp == "" || objProductOld.Param38_Upp == this.strNullValue || objProductOld.Param38_Upp == undefined) {
                    objProductOld.Param38_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_40_Lay_2 == "" || objProductNew.flt_FineMax_abv_40_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_abv_40_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_abv_40_Lay_2 = null;
                }
    
                if ((objProductOld.Param38_Upp !== null) && (objProductNew.flt_FineMax_abv_40_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param38_Upp).toFixed(objProductOld.Param38_DP) == parseFloat(objProductNew.flt_FineMax_abv_40_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_40_Lay_2)) {
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.oldValue = false;
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param38_Upp).toFixed(objProductOld.Param38_DP);
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_40_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param38_Upp === null) && (objProductNew.flt_FineMax_abv_40_Lay_2 !== null)) {
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.oldValue = "NA";
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_40_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param38_Upp !== null) && (objProductNew.flt_FineMax_abv_40_Lay_2 === null)) {
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param38_Upp).toFixed(objProductOld.Param38_DP);
                        objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_40_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_60_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_60_Lay_2 = {
                Fine_blw_60_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_60_Lay_2 != "" && objProductNew.flt_FineMin_blw_60_Lay_2 != undefined) {
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.oldValue = "NA";
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_60_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.oldValue = false;
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param34_Low === "" || objProductOld.Param34_Low == this.strNullValue || objProductOld.Param34_Low == undefined) {
                    objProductOld.Param34_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_60_Lay_2 == "" || objProductNew.flt_FineMin_blw_60_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_blw_60_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_blw_60_Lay_2 = null;
                }
    
                if ((objProductOld.Param34_Low !== null) && (objProductNew.flt_FineMin_blw_60_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param34_Low).toFixed(objProductOld.Param34_DP) == parseFloat(objProductNew.flt_FineMin_blw_60_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_60_Lay_2)) {
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.oldValue = false;
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param34_Low).toFixed(objProductOld.Param34_DP);
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_60_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param34_Low === null) && (objProductNew.flt_FineMin_blw_60_Lay_2 !== null)) {
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.oldValue = "NA";
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_60_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param34_Low !== null) && (objProductNew.flt_FineMin_blw_60_Lay_2 === null)) {
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param34_Low).toFixed(objProductOld.Param34_DP);
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_60_Lay_2 != "" && objProductNew.flt_FineMax_blw_60_Lay_2 != undefined) {
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.oldValue = "NA";
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_60_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.oldValue = false;
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param34_Upp == "" || objProductOld.Param34_Upp == this.strNullValue || objProductOld.Param34_Upp == undefined) {
                    objProductOld.Param34_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_60_Lay_2 == "" || objProductNew.flt_FineMax_blw_60_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_blw_60_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_blw_60_Lay_2 = null;
                }
    
                if ((objProductOld.Param34_Upp !== null) && (objProductNew.flt_FineMax_blw_60_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param34_Upp).toFixed(objProductOld.Param34_DP) == parseFloat(objProductNew.flt_FineMax_blw_60_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_60_Lay_2)) {
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.oldValue = false;
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param34_Upp).toFixed(objProductOld.Param34_DP);
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_60_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param34_Upp === null) && (objProductNew.flt_FineMax_blw_60_Lay_2 !== null)) {
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.oldValue = "NA";
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_60_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param34_Upp !== null) && (objProductNew.flt_FineMax_blw_60_Lay_2 === null)) {
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param34_Upp).toFixed(objProductOld.Param34_DP);
                        objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_60_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_60_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_60_Lay_2 = {
                Fine_abv_60_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_60_Lay_2 != "" && objProductNew.flt_FineMin_abv_60_Lay_2 != undefined) {
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.oldValue = "NA";
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_60_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.oldValue = false;
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param39_Low === "" || objProductOld.Param39_Low == this.strNullValue || objProductOld.Param39_Low == undefined) {
                    objProductOld.Param39_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_60_Lay_2 == "" || objProductNew.flt_FineMin_abv_60_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_abv_60_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_abv_60_Lay_2 = null;
                }
    
                if ((objProductOld.Param39_Low !== null) && (objProductNew.flt_FineMin_abv_60_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param39_Low).toFixed(objProductOld.Param39_DP) == parseFloat(objProductNew.flt_FineMin_abv_60_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_60_Lay_2)) {
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.oldValue = false;
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param39_Low).toFixed(objProductOld.Param39_DP);
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_60_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param39_Low === null) && (objProductNew.flt_FineMin_abv_60_Lay_2 !== null)) {
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.oldValue = "NA";
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_60_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param39_Low !== null) && (objProductNew.flt_FineMin_abv_60_Lay_2 === null)) {
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param39_Low).toFixed(objProductOld.Param39_DP);
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_60_Lay_2 != "" && objProductNew.flt_FineMax_abv_60_Lay_2 != undefined) {
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.oldValue = "NA";
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_60_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.oldValue = false;
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param39_Upp == "" || objProductOld.Param39_Upp == this.strNullValue || objProductOld.Param39_Upp == undefined) {
                    objProductOld.Param39_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_60_Lay_2 == "" || objProductNew.flt_FineMax_abv_60_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_abv_60_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_abv_60_Lay_2 = null;
                }
    
                if ((objProductOld.Param39_Upp !== null) && (objProductNew.flt_FineMax_abv_60_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param39_Upp).toFixed(objProductOld.Param39_DP) == parseFloat(objProductNew.flt_FineMax_abv_60_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_60_Lay_2)) {
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.oldValue = false;
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param39_Upp).toFixed(objProductOld.Param39_DP);
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_60_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param39_Upp === null) && (objProductNew.flt_FineMax_abv_60_Lay_2 !== null)) {
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.oldValue = "NA";
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_60_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param39_Upp !== null) && (objProductNew.flt_FineMax_abv_60_Lay_2 === null)) {
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param39_Upp).toFixed(objProductOld.Param39_DP);
                        objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_60_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_80_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_80_Lay_2 = {
                Fine_blw_80_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_80_Lay_2 != "" && objProductNew.flt_FineMin_blw_80_Lay_2 != undefined) {
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.oldValue = "NA";
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_80_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.oldValue = false;
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param35_Low === "" || objProductOld.Param35_Low == this.strNullValue || objProductOld.Param35_Low == undefined) {
                    objProductOld.Param35_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_80_Lay_2 == "" || objProductNew.flt_FineMin_blw_80_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_blw_80_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_blw_80_Lay_2 = null;
                }
    
                if ((objProductOld.Param35_Low !== null) && (objProductNew.flt_FineMin_blw_80_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param35_Low).toFixed(objProductOld.Param35_DP) == parseFloat(objProductNew.flt_FineMin_blw_80_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_80_Lay_2)) {
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.oldValue = false;
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param35_Low).toFixed(objProductOld.Param35_DP);
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_80_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param35_Low === null) && (objProductNew.flt_FineMin_blw_80_Lay_2 !== null)) {
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.oldValue = "NA";
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_80_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param35_Low !== null) && (objProductNew.flt_FineMin_blw_80_Lay_2 === null)) {
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param35_Low).toFixed(objProductOld.Param35_DP);
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_80_Lay_2 != "" && objProductNew.flt_FineMax_blw_80_Lay_2 != undefined) {
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.oldValue = "NA";
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_80_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.oldValue = false;
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param35_Upp == "" || objProductOld.Param35_Upp == this.strNullValue || objProductOld.Param35_Upp == undefined) {
                    objProductOld.Param35_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_80_Lay_2 == "" || objProductNew.flt_FineMax_blw_80_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_blw_80_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_blw_80_Lay_2 = null;
                }
    
                if ((objProductOld.Param35_Upp !== null) && (objProductNew.flt_FineMax_blw_80_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param35_Upp).toFixed(objProductOld.Param35_DP) == parseFloat(objProductNew.flt_FineMax_blw_80_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_80_Lay_2)) {
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.oldValue = false;
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param35_Upp).toFixed(objProductOld.Param35_DP);
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_80_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param35_Upp === null) && (objProductNew.flt_FineMax_blw_80_Lay_2 !== null)) {
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.oldValue = "NA";
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_80_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param35_Upp !== null) && (objProductNew.flt_FineMax_blw_80_Lay_2 === null)) {
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param35_Upp).toFixed(objProductOld.Param35_DP);
                        objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_80_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_80_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_80_Lay_2 = {
                Fine_abv_80_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_80_Lay_2 != "" && objProductNew.flt_FineMin_abv_80_Lay_2 != undefined) {
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.oldValue = "NA";
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_80_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.oldValue = false;
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param40_Low === "" || objProductOld.Param40_Low == this.strNullValue || objProductOld.Param40_Low == undefined) {
                    objProductOld.Param40_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_80_Lay_2 == "" || objProductNew.flt_FineMin_abv_80_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_abv_80_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_abv_80_Lay_2 = null;
                }
    
                if ((objProductOld.Param40_Low !== null) && (objProductNew.flt_FineMin_abv_80_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param40_Low).toFixed(objProductOld.Param40_DP) == parseFloat(objProductNew.flt_FineMin_abv_80_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_80_Lay_2)) {
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.oldValue = false;
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param40_Low).toFixed(objProductOld.Param40_DP);
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_80_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param40_Low === null) && (objProductNew.flt_FineMin_abv_80_Lay_2 !== null)) {
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.oldValue = "NA";
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_80_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param40_Low !== null) && (objProductNew.flt_FineMin_abv_80_Lay_2 === null)) {
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param40_Low).toFixed(objProductOld.Param40_DP);
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_80_Lay_2 != "" && objProductNew.flt_FineMax_abv_80_Lay_2 != undefined) {
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.oldValue = "NA";
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_80_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.oldValue = false;
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param40_Upp == "" || objProductOld.Param40_Upp == this.strNullValue || objProductOld.Param40_Upp == undefined) {
                    objProductOld.Param40_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_80_Lay_2 == "" || objProductNew.flt_FineMax_abv_80_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_abv_80_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_abv_80_Lay_2 = null;
                }
    
                if ((objProductOld.Param40_Upp !== null) && (objProductNew.flt_FineMax_abv_80_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param40_Upp).toFixed(objProductOld.Param40_DP) == parseFloat(objProductNew.flt_FineMax_abv_80_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_80_Lay_2)) {
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.oldValue = false;
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param40_Upp).toFixed(objProductOld.Param40_DP);
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_80_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param40_Upp === null) && (objProductNew.flt_FineMax_abv_80_Lay_2 !== null)) {
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.oldValue = "NA";
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_80_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param40_Upp !== null) && (objProductNew.flt_FineMax_abv_80_Lay_2 === null)) {
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param40_Upp).toFixed(objProductOld.Param40_DP);
                        objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_80_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_100_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_100_Lay_2 = {
                Fine_blw_100_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_blw_100_Lay_2 != "" && objProductNew.flt_FineMin_blw_100_Lay_2 != undefined) {
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.oldValue = "NA";
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_100_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.oldValue = false;
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param36_Low === "" || objProductOld.Param36_Low == this.strNullValue || objProductOld.Param36_Low == undefined) {
                    objProductOld.Param36_Low = null;
                }
    
                if (objProductNew.flt_FineMin_blw_100_Lay_2 == "" || objProductNew.flt_FineMin_blw_100_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_blw_100_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_blw_100_Lay_2 = null;
                }
    
                if ((objProductOld.Param36_Low !== null) && (objProductNew.flt_FineMin_blw_100_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param36_Low).toFixed(objProductOld.Param36_DP) == parseFloat(objProductNew.flt_FineMin_blw_100_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_100_Lay_2)) {
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.oldValue = false;
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param36_Low).toFixed(objProductOld.Param36_DP);
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_100_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param36_Low === null) && (objProductNew.flt_FineMin_blw_100_Lay_2 !== null)) {
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.oldValue = "NA";
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.newValue = objProductNew.flt_FineMin_blw_100_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param36_Low !== null) && (objProductNew.flt_FineMin_blw_100_Lay_2 === null)) {
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param36_Low).toFixed(objProductOld.Param36_DP);
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_blw_100_Lay_2 != "" && objProductNew.flt_FineMax_blw_100_Lay_2 != undefined) {
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.oldValue = "NA";
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_100_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.oldValue = false;
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param36_Upp == "" || objProductOld.Param36_Upp == this.strNullValue || objProductOld.Param36_Upp == undefined) {
                    objProductOld.Param36_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_blw_100_Lay_2 == "" || objProductNew.flt_FineMax_blw_100_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_blw_100_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_blw_100_Lay_2 = null;
                }
    
                if ((objProductOld.Param36_Upp !== null) && (objProductNew.flt_FineMax_blw_100_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param36_Upp).toFixed(objProductOld.Param36_DP) == parseFloat(objProductNew.flt_FineMax_blw_100_Lay_2).toFixed(objProductNew.int_fineDpGran_blw_100_Lay_2)) {
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.oldValue = false;
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param36_Upp).toFixed(objProductOld.Param36_DP);
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_100_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param36_Upp === null) && (objProductNew.flt_FineMax_blw_100_Lay_2 !== null)) {
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.oldValue = "NA";
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.newValue = objProductNew.flt_FineMax_blw_100_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param36_Upp !== null) && (objProductNew.flt_FineMax_blw_100_Lay_2 === null)) {
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param36_Upp).toFixed(objProductOld.Param36_DP);
                        objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_100_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_100_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_100_Lay_2 = {
                Fine_abv_100_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_abv_100_Lay_2 != "" && objProductNew.flt_FineMin_abv_100_Lay_2 != undefined) {
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.oldValue = "NA";
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_100_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.oldValue = false;
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param41_Low === "" || objProductOld.Param41_Low == this.strNullValue || objProductOld.Param41_Low == undefined) {
                    objProductOld.Param41_Low = null;
                }
    
                if (objProductNew.flt_FineMin_abv_100_Lay_2 == "" || objProductNew.flt_FineMin_abv_100_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_abv_100_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_abv_100_Lay_2 = null;
                }
    
                if ((objProductOld.Param41_Low !== null) && (objProductNew.flt_FineMin_abv_100_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param41_Low).toFixed(objProductOld.Param41_DP) == parseFloat(objProductNew.flt_FineMin_abv_100_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_100_Lay_2)) {
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.oldValue = false;
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param41_Low).toFixed(objProductOld.Param41_DP);
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_100_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param41_Low === null) && (objProductNew.flt_FineMin_abv_100_Lay_2 !== null)) {
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.oldValue = "NA";
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.newValue = objProductNew.flt_FineMin_abv_100_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param41_Low !== null) && (objProductNew.flt_FineMin_abv_100_Lay_2 === null)) {
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param41_Low).toFixed(objProductOld.Param41_DP);
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_abv_100_Lay_2 != "" && objProductNew.flt_FineMax_abv_100_Lay_2 != undefined) {
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.oldValue = "NA";
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_100_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.oldValue = false;
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param41_Upp == "" || objProductOld.Param41_Upp == this.strNullValue || objProductOld.Param41_Upp == undefined) {
                    objProductOld.Param41_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_abv_100_Lay_2 == "" || objProductNew.flt_FineMax_abv_100_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_abv_100_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_abv_100_Lay_2 = null;
                }
    
                if ((objProductOld.Param41_Upp !== null) && (objProductNew.flt_FineMax_abv_100_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param41_Upp).toFixed(objProductOld.Param41_DP) == parseFloat(objProductNew.flt_FineMax_abv_100_Lay_2).toFixed(objProductNew.int_fineDpGran_abv_100_Lay_2)) {
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.oldValue = false;
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param41_Upp).toFixed(objProductOld.Param41_DP);
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_100_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param41_Upp === null) && (objProductNew.flt_FineMax_abv_100_Lay_2 !== null)) {
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.oldValue = "NA";
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.newValue = objProductNew.flt_FineMax_abv_100_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param41_Upp !== null) && (objProductNew.flt_FineMax_abv_100_Lay_2 === null)) {
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param41_Upp).toFixed(objProductOld.Param41_DP);
                        objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_100_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_Pan_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Pan_Lay_2 = {
                Fine_Pan_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_Pan_Lay_2 != "" && objProductNew.flt_FineMin_Pan_Lay_2 != undefined) {
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.oldValue = "NA";
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.newValue = objProductNew.flt_FineMin_Pan_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.oldValue = false;
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param42_Low === "" || objProductOld.Param42_Low == this.strNullValue || objProductOld.Param42_Low == undefined) {
                    objProductOld.Param42_Low = null;
                }
    
                if (objProductNew.flt_FineMin_Pan_Lay_2 == "" || objProductNew.flt_FineMin_Pan_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_Pan_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_Pan_Lay_2 = null;
                }
    
                if ((objProductOld.Param42_Low !== null) && (objProductNew.flt_FineMin_Pan_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param42_Low).toFixed(objProductOld.Param42_DP) == parseFloat(objProductNew.flt_FineMin_Pan_Lay_2).toFixed(objProductNew.int_fineDpGran_Pan_Lay_2)) {
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.oldValue = false;
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param42_Low).toFixed(objProductOld.Param42_DP);
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.newValue = objProductNew.flt_FineMin_Pan_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param42_Low === null) && (objProductNew.flt_FineMin_Pan_Lay_2 !== null)) {
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.oldValue = "NA";
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.newValue = objProductNew.flt_FineMin_Pan_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param42_Low !== null) && (objProductNew.flt_FineMin_Pan_Lay_2 === null)) {
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param42_Low).toFixed(objProductOld.Param42_DP);
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_Pan_Lay_2 != "" && objProductNew.flt_FineMax_Pan_Lay_2 != undefined) {
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.oldValue = "NA";
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.newValue = objProductNew.flt_FineMax_Pan_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.oldValue = false;
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param42_Upp == "" || objProductOld.Param42_Upp == this.strNullValue || objProductOld.Param42_Upp == undefined) {
                    objProductOld.Param42_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_Pan_Lay_2 == "" || objProductNew.flt_FineMax_Pan_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_Pan_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_Pan_Lay_2 = null;
                }
    
                if ((objProductOld.Param42_Upp !== null) && (objProductNew.flt_FineMax_Pan_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param42_Upp).toFixed(objProductOld.Param42_DP) == parseFloat(objProductNew.flt_FineMax_Pan_Lay_2).toFixed(objProductNew.int_fineDpGran_Pan_Lay_2)) {
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.oldValue = false;
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param42_Upp).toFixed(objProductOld.Param42_DP);
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.newValue = objProductNew.flt_FineMax_Pan_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param42_Upp === null) && (objProductNew.flt_FineMax_Pan_Lay_2 !== null)) {
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.oldValue = "NA";
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.newValue = objProductNew.flt_FineMax_Pan_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param42_Upp !== null) && (objProductNew.flt_FineMax_Pan_Lay_2 === null)) {
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param42_Upp).toFixed(objProductOld.Param42_DP);
                        objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Pan_Lay_2);
            }
            resolve(IsChanged);
        });
    }

    validateFine_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Lay_1 = {
                Fine_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_Lay_1 != "" && objProductNew.flt_FineMin_Lay_1 != undefined) {
                    objFine_Lay_1.Fine_Lay_1.MIN.oldValue = "NA";
                    objFine_Lay_1.Fine_Lay_1.MIN.newValue = objProductNew.flt_FineMin_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_Lay_1.Fine_Lay_1.MIN.oldValue = false;
                    objFine_Lay_1.Fine_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param48_Low === "" || objProductOld.Param48_Low == this.strNullValue || objProductOld.Param48_Low == undefined) {
                    objProductOld.Param48_Low = null;
                }
    
                if (objProductNew.flt_FineMin_Lay_1 == "" || objProductNew.flt_FineMin_Lay_1 == this.strNullValue || objProductNew.flt_FineMin_Lay_1 == undefined) {
                    objProductNew.flt_FineMin_Lay_1 = null;
                }
    
                if ((objProductOld.Param48_Low !== null) && (objProductNew.flt_FineMin_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param48_Low).toFixed(objProductOld.Param48_DP) == parseFloat(objProductNew.flt_FineMin_Lay_1).toFixed(objProductNew.int_fineDpGran_Lay_1)) {
                        objFine_Lay_1.Fine_Lay_1.MIN.oldValue = false;
                        objFine_Lay_1.Fine_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Lay_1.Fine_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param48_Low).toFixed(objProductOld.Param48_DP);
                        objFine_Lay_1.Fine_Lay_1.MIN.newValue = objProductNew.flt_FineMin_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param48_Low === null) && (objProductNew.flt_FineMin_Lay_1 !== null)) {
                        objFine_Lay_1.Fine_Lay_1.MIN.oldValue = "NA";
                        objFine_Lay_1.Fine_Lay_1.MIN.newValue = objProductNew.flt_FineMin_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param48_Low !== null) && (objProductNew.flt_FineMin_Lay_1 === null)) {
                        objFine_Lay_1.Fine_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param48_Low).toFixed(objProductOld.Param48_DP);
                        objFine_Lay_1.Fine_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_Lay_1 != "" && objProductNew.flt_FineMax_Lay_1 != undefined) {
                    objFine_Lay_1.Fine_Lay_1.MAX.oldValue = "NA";
                    objFine_Lay_1.Fine_Lay_1.MAX.newValue = objProductNew.flt_FineMax_Lay_1;
                    IsChanged = true;
                }
                else {
                    objFine_Lay_1.Fine_Lay_1.MAX.oldValue = false;
                    objFine_Lay_1.Fine_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param48_Upp == "" || objProductOld.Param48_Upp == this.strNullValue || objProductOld.Param48_Upp == undefined) {
                    objProductOld.Param48_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_Lay_1 == "" || objProductNew.flt_FineMax_Lay_1 == this.strNullValue || objProductNew.flt_FineMax_Lay_1 == undefined) {
                    objProductNew.flt_FineMax_Lay_1 = null;
                }
    
                if ((objProductOld.Param48_Upp !== null) && (objProductNew.flt_FineMax_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param48_Upp).toFixed(objProductOld.Param48_DP) == parseFloat(objProductNew.flt_FineMax_Lay_1).toFixed(objProductNew.int_fineDpGran_Lay_1)) {
                        objFine_Lay_1.Fine_Lay_1.MAX.oldValue = false;
                        objFine_Lay_1.Fine_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Lay_1.Fine_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param48_Upp).toFixed(objProductOld.Param48_DP);
                        objFine_Lay_1.Fine_Lay_1.MAX.newValue = objProductNew.flt_FineMax_Lay_1;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param48_Upp === null) && (objProductNew.flt_FineMax_Lay_1 !== null)) {
                        objFine_Lay_1.Fine_Lay_1.MAX.oldValue = "NA";
                        objFine_Lay_1.Fine_Lay_1.MAX.newValue = objProductNew.flt_FineMax_Lay_1;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param48_Upp !== null) && (objProductNew.flt_FineMax_Lay_1 === null)) {
                        objFine_Lay_1.Fine_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param48_Upp).toFixed(objProductOld.Param48_DP);
                        objFine_Lay_1.Fine_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Lay_2 = {
                Fine_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMin_Lay_2 != "" && objProductNew.flt_FineMin_Lay_2 != undefined) {
                    objFine_Lay_2.Fine_Lay_2.MIN.oldValue = "NA";
                    objFine_Lay_2.Fine_Lay_2.MIN.newValue = objProductNew.flt_FineMin_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_Lay_2.Fine_Lay_2.MIN.oldValue = false;
                    objFine_Lay_2.Fine_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param49_Low === "" || objProductOld.Param49_Low == this.strNullValue || objProductOld.Param49_Low == undefined) {
                    objProductOld.Param49_Low = null;
                }
    
                if (objProductNew.flt_FineMin_Lay_2 == "" || objProductNew.flt_FineMin_Lay_2 == this.strNullValue || objProductNew.flt_FineMin_Lay_2 == undefined) {
                    objProductNew.flt_FineMin_Lay_2 = null;
                }
    
                if ((objProductOld.Param49_Low !== null) && (objProductNew.flt_FineMin_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param49_Low).toFixed(objProductOld.Param49_DP) == parseFloat(objProductNew.flt_FineMin_Lay_2).toFixed(objProductNew.int_fineDpGran_Lay_2)) {
                        objFine_Lay_2.Fine_Lay_2.MIN.oldValue = false;
                        objFine_Lay_2.Fine_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Lay_2.Fine_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param49_Low).toFixed(objProductOld.Param49_DP);
                        objFine_Lay_2.Fine_Lay_2.MIN.newValue = objProductNew.flt_FineMin_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param49_Low === null) && (objProductNew.flt_FineMin_Lay_2 !== null)) {
                        objFine_Lay_2.Fine_Lay_2.MIN.oldValue = "NA";
                        objFine_Lay_2.Fine_Lay_2.MIN.newValue = objProductNew.flt_FineMin_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param49_Low !== null) && (objProductNew.flt_FineMin_Lay_2 === null)) {
                        objFine_Lay_2.Fine_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param49_Low).toFixed(objProductOld.Param49_DP);
                        objFine_Lay_2.Fine_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FineMax_Lay_2 != "" && objProductNew.flt_FineMax_Lay_2 != undefined) {
                    objFine_Lay_2.Fine_Lay_2.MAX.oldValue = "NA";
                    objFine_Lay_2.Fine_Lay_2.MAX.newValue = objProductNew.flt_FineMax_Lay_2;
                    IsChanged = true;
                }
                else {
                    objFine_Lay_2.Fine_Lay_2.MAX.oldValue = false;
                    objFine_Lay_2.Fine_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param49_Upp == "" || objProductOld.Param49_Upp == this.strNullValue || objProductOld.Param49_Upp == undefined) {
                    objProductOld.Param49_Upp = null;
                }
    
                if (objProductNew.flt_FineMax_Lay_2 == "" || objProductNew.flt_FineMax_Lay_2 == this.strNullValue || objProductNew.flt_FineMax_Lay_2 == undefined) {
                    objProductNew.flt_FineMax_Lay_2 = null;
                }
    
                if ((objProductOld.Param49_Upp !== null) && (objProductNew.flt_FineMax_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param49_Upp).toFixed(objProductOld.Param49_DP) == parseFloat(objProductNew.flt_FineMax_Lay_2).toFixed(objProductNew.int_fineDpGran_Lay_2)) {
                        objFine_Lay_2.Fine_Lay_2.MAX.oldValue = false;
                        objFine_Lay_2.Fine_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objFine_Lay_2.Fine_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param49_Upp).toFixed(objProductOld.Param49_DP);
                        objFine_Lay_2.Fine_Lay_2.MAX.newValue = objProductNew.flt_FineMax_Lay_2;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param49_Upp === null) && (objProductNew.flt_FineMax_Lay_2 !== null)) {
                        objFine_Lay_2.Fine_Lay_2.MAX.oldValue = "NA";
                        objFine_Lay_2.Fine_Lay_2.MAX.newValue = objProductNew.flt_FineMax_Lay_2;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param49_Upp !== null) && (objProductNew.flt_FineMax_Lay_2 === null)) {
                        objFine_Lay_2.Fine_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param49_Upp).toFixed(objProductOld.Param49_DP);
                        objFine_Lay_2.Fine_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Lay_2);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD = {
                ParticleSizeDistribution: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin != "" && objProductNew.flt_PSDMin != undefined) {
                    objPSD.ParticleSizeDistribution.MIN.oldValue = "NA";
                    objPSD.ParticleSizeDistribution.MIN.newValue = objProductNew.flt_PSDMin;
                    IsChanged = true;
                }
                else {
                    objPSD.ParticleSizeDistribution.MIN.oldValue = false;
                    objPSD.ParticleSizeDistribution.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param50_Low === "" || objProductOld.Param50_Low == this.strNullValue || objProductOld.Param50_Low == undefined) {
                    objProductOld.Param50_Low = null;
                }
    
                if (objProductNew.flt_PSDMin == "" || objProductNew.flt_PSDMin == this.strNullValue || objProductNew.flt_PSDMin == undefined) {
                    objProductNew.flt_PSDMin = null;
                }
    
                if ((objProductOld.Param50_Low !== null) && (objProductNew.flt_PSDMin !== null)) {
                    if (parseFloat(objProductOld.Param50_Low).toFixed(objProductOld.Param50_DP) == parseFloat(objProductNew.flt_PSDMin).toFixed(objProductNew.int_PSD_DpGran)) {
                        objPSD.ParticleSizeDistribution.MIN.oldValue = false;
                        objPSD.ParticleSizeDistribution.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD.ParticleSizeDistribution.MIN.oldValue = parseFloat(objProductOld.Param50_Low).toFixed(objProductOld.Param50_DP);
                        objPSD.ParticleSizeDistribution.MIN.newValue = objProductNew.flt_PSDMin;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param50_Low === null) && (objProductNew.flt_PSDMin !== null)) {
                        objPSD.ParticleSizeDistribution.MIN.oldValue = "NA";
                        objPSD.ParticleSizeDistribution.MIN.newValue = objProductNew.flt_PSDMin;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param50_Low !== null) && (objProductNew.flt_PSDMin === null)) {
                        objPSD.ParticleSizeDistribution.MIN.oldValue = parseFloat(objProductOld.Param50_Low).toFixed(objProductOld.Param50_DP);
                        objPSD.ParticleSizeDistribution.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax != "" && objProductNew.flt_PSDMax != undefined) {
                    objPSD.ParticleSizeDistribution.MAX.oldValue = "NA";
                    objPSD.ParticleSizeDistribution.MAX.newValue = objProductNew.flt_PSDMax;
                    IsChanged = true;
                }
                else {
                    objPSD.ParticleSizeDistribution.MAX.oldValue = false;
                    objPSD.ParticleSizeDistribution.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
    
            }
            else {
                if (objProductOld.Param50_Upp == "" || objProductOld.Param50_Upp == this.strNullValue || objProductOld.Param50_Upp == undefined) {
                    objProductOld.Param50_Upp = null;
                }
    
                if (objProductNew.flt_PSDMax == "" || objProductNew.flt_PSDMax == this.strNullValue || objProductNew.flt_PSDMax == undefined) {
                    objProductNew.flt_PSDMax = null;
                }
    
                if ((objProductOld.Param50_Upp !== null) && (objProductNew.flt_PSDMax !== null)) {
                    if (parseFloat(objProductOld.Param50_Upp).toFixed(objProductOld.Param50_DP) == parseFloat(objProductNew.flt_PSDMax).toFixed(objProductNew.int_PSD_DpGran)) {
                        objPSD.ParticleSizeDistribution.MAX.oldValue = false;
                        objPSD.ParticleSizeDistribution.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD.ParticleSizeDistribution.MAX.oldValue = parseFloat(objProductOld.Param50_Upp).toFixed(objProductOld.Param50_DP);
                        objPSD.ParticleSizeDistribution.MAX.newValue = objProductNew.flt_PSDMax;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param50_Upp === null) && (objProductNew.flt_PSDMax !== null)) {
                        objPSD.ParticleSizeDistribution.MAX.oldValue = "NA";
                        objPSD.ParticleSizeDistribution.MAX.newValue = objProductNew.flt_PSDMax;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param50_Upp !== null) && (objProductNew.flt_PSDMax === null)) {
                        objPSD.ParticleSizeDistribution.MAX.oldValue = parseFloat(objProductOld.Param50_Upp).toFixed(objProductOld.Param50_DP);
                        objPSD.ParticleSizeDistribution.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_20(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_20 = {
                ParticleSizeDistribution_abv_20: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_20 != "" && objProductNew.flt_PSDMin_abv_20 != undefined) {
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.oldValue = "NA";
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.newValue = objProductNew.flt_PSDMin_abv_20;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.oldValue = false;
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param51_Low === "" || objProductOld.Param51_Low == this.strNullValue || objProductOld.Param51_Low == undefined) {
                    objProductOld.Param51_Low = null;
                }
    
                if (objProductNew.flt_PSDMin_abv_20 == "" || objProductNew.flt_PSDMin_abv_20 == this.strNullValue || objProductNew.flt_PSDMin_abv_20 == undefined) {
                    objProductNew.flt_PSDMin_abv_20 = null;
                }
    
                if ((objProductOld.Param51_Low !== null) && (objProductNew.flt_PSDMin_abv_20 !== null)) {
                    if (parseFloat(objProductOld.Param51_Low).toFixed(objProductOld.Param51_DP) == parseFloat(objProductNew.flt_PSDMin_abv_20).toFixed(objProductNew.int_PSD_DpGran_abv_20)) {
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.oldValue = false;
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.oldValue = parseFloat(objProductOld.Param51_Low).toFixed(objProductOld.Param51_DP);
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.newValue = objProductNew.flt_PSDMin_abv_20;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param51_Low === null) && (objProductNew.flt_PSDMin_abv_20 !== null)) {
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.oldValue = "NA";
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.newValue = objProductNew.flt_PSDMin_abv_20;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param51_Low !== null) && (objProductNew.flt_PSDMin_abv_20 === null)) {
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.oldValue = parseFloat(objProductOld.Param51_Low).toFixed(objProductOld.Param51_DP);
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_20 != "" && objProductNew.flt_PSDMax_abv_20 != undefined) {
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.oldValue = "NA";
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.newValue = objProductNew.flt_PSDMax_abv_20;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.oldValue = false;
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
    
            }
            else {
                if (objProductOld.Param51_Upp == "" || objProductOld.Param51_Upp == this.strNullValue || objProductOld.Param51_Upp == undefined) {
                    objProductOld.Param51_Upp = null;
                }
    
                if (objProductNew.flt_PSDMax_abv_20 == "" || objProductNew.flt_PSDMax_abv_20 == this.strNullValue || objProductNew.flt_PSDMax_abv_20 == undefined) {
                    objProductNew.flt_PSDMax_abv_20 = null;
                }
    
                if ((objProductOld.Param51_Upp !== null) && (objProductNew.flt_PSDMax_abv_20 !== null)) {
                    if (parseFloat(objProductOld.Param51_Upp).toFixed(objProductOld.Param51_DP) == parseFloat(objProductNew.flt_PSDMax_abv_20).toFixed(objProductNew.int_PSD_DpGran_abv_20)) {
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.oldValue = false;
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.oldValue = parseFloat(objProductOld.Param51_Upp).toFixed(objProductOld.Param51_DP);
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.newValue = objProductNew.flt_PSDMax_abv_20;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param51_Upp === null) && (objProductNew.flt_PSDMax_abv_20 !== null)) {
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.oldValue = "NA";
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.newValue = objProductNew.flt_PSDMax_abv_20;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param51_Upp !== null) && (objProductNew.flt_PSDMax_abv_20 === null)) {
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.oldValue = parseFloat(objProductOld.Param51_Upp).toFixed(objProductOld.Param51_DP);
                        objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_20);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_40(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_40 = {
                ParticleSizeDistribution_abv_40: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_40 != "" && objProductNew.flt_PSDMin_abv_40 != undefined) {
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.oldValue = "NA";
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.newValue = objProductNew.flt_PSDMin_abv_40;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.oldValue = false;
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param52_Low === "" || objProductOld.Param52_Low == this.strNullValue || objProductOld.Param52_Low == undefined) {
                    objProductOld.Param52_Low = null;
                }
    
                if (objProductNew.flt_PSDMin_abv_40 == "" || objProductNew.flt_PSDMin_abv_40 == this.strNullValue || objProductNew.flt_PSDMin_abv_40 == undefined) {
                    objProductNew.flt_PSDMin_abv_40 = null;
                }
    
                if ((objProductOld.Param52_Low !== null) && (objProductNew.flt_PSDMin_abv_40 !== null)) {
                    if (parseFloat(objProductOld.Param52_Low).toFixed(objProductOld.Param52_DP) == parseFloat(objProductNew.flt_PSDMin_abv_40).toFixed(objProductNew.int_PSD_DpGran_abv_40)) {
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.oldValue = false;
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.oldValue = parseFloat(objProductOld.Param52_Low).toFixed(objProductOld.Param52_DP);
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.newValue = objProductNew.flt_PSDMin_abv_40;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param52_Low === null) && (objProductNew.flt_PSDMin_abv_40 !== null)) {
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.oldValue = "NA";
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.newValue = objProductNew.flt_PSDMin_abv_40;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param52_Low !== null) && (objProductNew.flt_PSDMin_abv_40 === null)) {
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.oldValue = parseFloat(objProductOld.Param52_Low).toFixed(objProductOld.Param52_DP);
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_40 != "" && objProductNew.flt_PSDMax_abv_40 != undefined) {
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.oldValue = "NA";
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.newValue = objProductNew.flt_PSDMax_abv_40;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.oldValue = false;
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
    
            }
            else {
                if (objProductOld.Param52_Upp == "" || objProductOld.Param52_Upp == this.strNullValue || objProductOld.Param52_Upp == undefined) {
                    objProductOld.Param52_Upp = null;
                }
    
                if (objProductNew.flt_PSDMax_abv_40 == "" || objProductNew.flt_PSDMax_abv_40 == this.strNullValue || objProductNew.flt_PSDMax_abv_40 == undefined) {
                    objProductNew.flt_PSDMax_abv_40 = null;
                }
    
                if ((objProductOld.Param52_Upp !== null) && (objProductNew.flt_PSDMax_abv_40 !== null)) {
                    if (parseFloat(objProductOld.Param52_Upp).toFixed(objProductOld.Param52_DP) == parseFloat(objProductNew.flt_PSDMax_abv_40).toFixed(objProductNew.int_PSD_DpGran_abv_40)) {
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.oldValue = false;
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.oldValue = parseFloat(objProductOld.Param52_Upp).toFixed(objProductOld.Param52_DP);
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.newValue = objProductNew.flt_PSDMax_abv_40;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param52_Upp === null) && (objProductNew.flt_PSDMax_abv_40 !== null)) {
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.oldValue = "NA";
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.newValue = objProductNew.flt_PSDMax_abv_40;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param52_Upp !== null) && (objProductNew.flt_PSDMax_abv_40 === null)) {
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.oldValue = parseFloat(objProductOld.Param52_Upp).toFixed(objProductOld.Param52_DP);
                        objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_40);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_60(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_60 = {
                ParticleSizeDistribution_abv_60: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_60 != "" && objProductNew.flt_PSDMin_abv_60 != undefined) {
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.oldValue = "NA";
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.newValue = objProductNew.flt_PSDMin_abv_60;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.oldValue = false;
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param53_Low === "" || objProductOld.Param53_Low == this.strNullValue || objProductOld.Param53_Low == undefined) {
                    objProductOld.Param53_Low = null;
                }
    
                if (objProductNew.flt_PSDMin_abv_60 == "" || objProductNew.flt_PSDMin_abv_60 == this.strNullValue || objProductNew.flt_PSDMin_abv_60 == undefined) {
                    objProductNew.flt_PSDMin_abv_60 = null;
                }
    
                if ((objProductOld.Param53_Low !== null) && (objProductNew.flt_PSDMin_abv_60 !== null)) {
                    if (parseFloat(objProductOld.Param53_Low).toFixed(objProductOld.Param53_DP) == parseFloat(objProductNew.flt_PSDMin_abv_60).toFixed(objProductNew.int_PSD_DpGran_abv_60)) {
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.oldValue = false;
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.oldValue = parseFloat(objProductOld.Param53_Low).toFixed(objProductOld.Param53_DP);
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.newValue = objProductNew.flt_PSDMin_abv_60;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param53_Low === null) && (objProductNew.flt_PSDMin_abv_60 !== null)) {
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.oldValue = "NA";
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.newValue = objProductNew.flt_PSDMin_abv_60;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param53_Low !== null) && (objProductNew.flt_PSDMin_abv_60 === null)) {
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.oldValue = parseFloat(objProductOld.Param53_Low).toFixed(objProductOld.Param53_DP);
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_60 != "" && objProductNew.flt_PSDMax_abv_60 != undefined) {
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.oldValue = "NA";
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.newValue = objProductNew.flt_PSDMax_abv_60;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.oldValue = false;
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
    
            }
            else {
                if (objProductOld.Param53_Upp == "" || objProductOld.Param53_Upp == this.strNullValue || objProductOld.Param53_Upp == undefined) {
                    objProductOld.Param53_Upp = null;
                }
    
                if (objProductNew.flt_PSDMax_abv_60 == "" || objProductNew.flt_PSDMax_abv_60 == this.strNullValue || objProductNew.flt_PSDMax_abv_60 == undefined) {
                    objProductNew.flt_PSDMax_abv_60 = null;
                }
    
                if ((objProductOld.Param53_Upp !== null) && (objProductNew.flt_PSDMax_abv_60 !== null)) {
                    if (parseFloat(objProductOld.Param53_Upp).toFixed(objProductOld.Param53_DP) == parseFloat(objProductNew.flt_PSDMax_abv_60).toFixed(objProductNew.int_PSD_DpGran_abv_60)) {
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.oldValue = false;
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.oldValue = parseFloat(objProductOld.Param53_Upp).toFixed(objProductOld.Param53_DP);
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.newValue = objProductNew.flt_PSDMax_abv_60;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param53_Upp === null) && (objProductNew.flt_PSDMax_abv_60 !== null)) {
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.oldValue = "NA";
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.newValue = objProductNew.flt_PSDMax_abv_60;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param53_Upp !== null) && (objProductNew.flt_PSDMax_abv_60 === null)) {
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.oldValue = parseFloat(objProductOld.Param53_Upp).toFixed(objProductOld.Param53_DP);
                        objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_60);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_80(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_80 = {
                ParticleSizeDistribution_abv_80: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_80 != "" && objProductNew.flt_PSDMin_abv_80 != undefined) {
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.oldValue = "NA";
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.newValue = objProductNew.flt_PSDMin_abv_80;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.oldValue = false;
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param54_Low === "" || objProductOld.Param54_Low == this.strNullValue || objProductOld.Param54_Low == undefined) {
                    objProductOld.Param54_Low = null;
                }
    
                if (objProductNew.flt_PSDMin_abv_80 == "" || objProductNew.flt_PSDMin_abv_80 == this.strNullValue || objProductNew.flt_PSDMin_abv_80 == undefined) {
                    objProductNew.flt_PSDMin_abv_80 = null;
                }
    
                if ((objProductOld.Param54_Low !== null) && (objProductNew.flt_PSDMin_abv_80 !== null)) {
                    if (parseFloat(objProductOld.Param54_Low).toFixed(objProductOld.Param54_DP) == parseFloat(objProductNew.flt_PSDMin_abv_80).toFixed(objProductNew.int_PSD_DpGran_abv_80)) {
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.oldValue = false;
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.oldValue = parseFloat(objProductOld.Param54_Low).toFixed(objProductOld.Param54_DP);
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.newValue = objProductNew.flt_PSDMin_abv_80;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param54_Low === null) && (objProductNew.flt_PSDMin_abv_80 !== null)) {
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.oldValue = "NA";
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.newValue = objProductNew.flt_PSDMin_abv_80;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param54_Low !== null) && (objProductNew.flt_PSDMin_abv_80 === null)) {
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.oldValue = parseFloat(objProductOld.Param54_Low).toFixed(objProductOld.Param54_DP);
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_80 != "" && objProductNew.flt_PSDMax_abv_80 != undefined) {
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.oldValue = "NA";
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.newValue = objProductNew.flt_PSDMax_abv_80;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.oldValue = false;
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
    
            }
            else {
                if (objProductOld.Param54_Upp == "" || objProductOld.Param54_Upp == this.strNullValue || objProductOld.Param54_Upp == undefined) {
                    objProductOld.Param54_Upp = null;
                }
    
                if (objProductNew.flt_PSDMax_abv_80 == "" || objProductNew.flt_PSDMax_abv_80 == this.strNullValue || objProductNew.flt_PSDMax_abv_80 == undefined) {
                    objProductNew.flt_PSDMax_abv_80 = null;
                }
    
                if ((objProductOld.Param54_Upp !== null) && (objProductNew.flt_PSDMax_abv_80 !== null)) {
                    if (parseFloat(objProductOld.Param54_Upp).toFixed(objProductOld.Param54_DP) == parseFloat(objProductNew.flt_PSDMax_abv_80).toFixed(objProductNew.int_PSD_DpGran_abv_80)) {
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.oldValue = false;
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.oldValue = parseFloat(objProductOld.Param54_Upp).toFixed(objProductOld.Param54_DP);
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.newValue = objProductNew.flt_PSDMax_abv_80;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param54_Upp === null) && (objProductNew.flt_PSDMax_abv_80 !== null)) {
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.oldValue = "NA";
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.newValue = objProductNew.flt_PSDMax_abv_80;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param54_Upp !== null) && (objProductNew.flt_PSDMax_abv_80 === null)) {
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.oldValue = parseFloat(objProductOld.Param54_Upp).toFixed(objProductOld.Param54_DP);
                        objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_80);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_100(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_100 = {
                ParticleSizeDistribution_abv_100: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_100 != "" && objProductNew.flt_PSDMin_abv_100 != undefined) {
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.oldValue = "NA";
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.newValue = objProductNew.flt_PSDMin_abv_100;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.oldValue = false;
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param55_Low === "" || objProductOld.Param55_Low == this.strNullValue || objProductOld.Param55_Low == undefined) {
                    objProductOld.Param55_Low = null;
                }
    
                if (objProductNew.flt_PSDMin_abv_100 == "" || objProductNew.flt_PSDMin_abv_100 == this.strNullValue || objProductNew.flt_PSDMin_abv_100 == undefined) {
                    objProductNew.flt_PSDMin_abv_100 = null;
                }
    
                if ((objProductOld.Param55_Low !== null) && (objProductNew.flt_PSDMin_abv_100 !== null)) {
                    if (parseFloat(objProductOld.Param55_Low).toFixed(objProductOld.Param55_DP) == parseFloat(objProductNew.flt_PSDMin_abv_100).toFixed(objProductNew.int_PSD_DpGran_abv_100)) {
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.oldValue = false;
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.oldValue = parseFloat(objProductOld.Param55_Low).toFixed(objProductOld.Param55_DP);
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.newValue = objProductNew.flt_PSDMin_abv_100;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param55_Low === null) && (objProductNew.flt_PSDMin_abv_100 !== null)) {
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.oldValue = "NA";
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.newValue = objProductNew.flt_PSDMin_abv_100;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param55_Low !== null) && (objProductNew.flt_PSDMin_abv_100 === null)) {
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.oldValue = parseFloat(objProductOld.Param55_Low).toFixed(objProductOld.Param55_DP);
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_100 != "" && objProductNew.flt_PSDMax_abv_100 != undefined) {
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.oldValue = "NA";
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.newValue = objProductNew.flt_PSDMax_abv_100;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.oldValue = false;
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
    
            }
            else {
                if (objProductOld.Param55_Upp == "" || objProductOld.Param55_Upp == this.strNullValue || objProductOld.Param55_Upp == undefined) {
                    objProductOld.Param55_Upp = null;
                }
    
                if (objProductNew.flt_PSDMax_abv_100 == "" || objProductNew.flt_PSDMax_abv_100 == this.strNullValue || objProductNew.flt_PSDMax_abv_100 == undefined) {
                    objProductNew.flt_PSDMax_abv_100 = null;
                }
    
                if ((objProductOld.Param55_Upp !== null) && (objProductNew.flt_PSDMax_abv_100 !== null)) {
                    if (parseFloat(objProductOld.Param55_Upp).toFixed(objProductOld.Param55_DP) == parseFloat(objProductNew.flt_PSDMax_abv_100).toFixed(objProductNew.int_PSD_DpGran_abv_100)) {
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.oldValue = false;
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.oldValue = parseFloat(objProductOld.Param55_Upp).toFixed(objProductOld.Param55_DP);
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.newValue = objProductNew.flt_PSDMax_abv_100;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param55_Upp === null) && (objProductNew.flt_PSDMax_abv_100 !== null)) {
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.oldValue = "NA";
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.newValue = objProductNew.flt_PSDMax_abv_100;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param55_Upp !== null) && (objProductNew.flt_PSDMax_abv_100 === null)) {
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.oldValue = parseFloat(objProductOld.Param55_Upp).toFixed(objProductOld.Param55_DP);
                        objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_100);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_blw_100(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_blw_100 = {
                ParticleSizeDistribution_blw_100: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
    
            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;
    
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_blw_100 != "" && objProductNew.flt_PSDMin_blw_100 != undefined) {
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.oldValue = "NA";
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.newValue = objProductNew.flt_PSDMin_blw_100;
                    IsChanged = true;
                }
                else {
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.oldValue = false;
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param56_Low === "" || objProductOld.Param56_Low == this.strNullValue || objProductOld.Param56_Low == undefined) {
                    objProductOld.Param56_Low = null;
                }
    
                if (objProductNew.flt_PSDMin_blw_100 == "" || objProductNew.flt_PSDMin_blw_100 == this.strNullValue || objProductNew.flt_PSDMin_blw_100 == undefined) {
                    objProductNew.flt_PSDMin_blw_100 = null;
                }
    
                if ((objProductOld.Param56_Low !== null) && (objProductNew.flt_PSDMin_blw_100 !== null)) {
                    if (parseFloat(objProductOld.Param56_Low).toFixed(objProductOld.Param56_DP) == parseFloat(objProductNew.flt_PSDMin_blw_100).toFixed(objProductNew.int_PSD_DpGran_blw_100)) {
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.oldValue = false;
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.oldValue = parseFloat(objProductOld.Param56_Low).toFixed(objProductOld.Param56_DP);
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.newValue = objProductNew.flt_PSDMin_blw_100;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param56_Low === null) && (objProductNew.flt_PSDMin_blw_100 !== null)) {
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.oldValue = "NA";
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.newValue = objProductNew.flt_PSDMin_blw_100;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param56_Low !== null) && (objProductNew.flt_PSDMin_blw_100 === null)) {
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.oldValue = parseFloat(objProductOld.Param56_Low).toFixed(objProductOld.Param56_DP);
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_blw_100 != "" && objProductNew.flt_PSDMax_blw_100 != undefined) {
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.oldValue = "NA";
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.newValue = objProductNew.flt_PSDMax_blw_100;
                    IsChanged = true;
                }
                else {
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.oldValue = false;
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
    
            }
            else {
                if (objProductOld.Param56_Upp == "" || objProductOld.Param56_Upp == this.strNullValue || objProductOld.Param56_Upp == undefined) {
                    objProductOld.Param56_Upp = null;
                }
    
                if (objProductNew.flt_PSDMax_blw_100 == "" || objProductNew.flt_PSDMax_blw_100 == this.strNullValue || objProductNew.flt_PSDMax_blw_100 == undefined) {
                    objProductNew.flt_PSDMax_blw_100 = null;
                }
    
                if ((objProductOld.Param56_Upp !== null) && (objProductNew.flt_PSDMax_blw_100 !== null)) {
                    if (parseFloat(objProductOld.Param56_Upp).toFixed(objProductOld.Param56_DP) == parseFloat(objProductNew.flt_PSDMax_blw_100).toFixed(objProductNew.int_PSD_DpGran_blw_100)) {
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.oldValue = false;
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.oldValue = parseFloat(objProductOld.Param56_Upp).toFixed(objProductOld.Param56_DP);
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.newValue = objProductNew.flt_PSDMax_blw_100;
                        IsChanged = true;
                    }
    
                } else {
    
                    if ((objProductOld.Param56_Upp === null) && (objProductNew.flt_PSDMax_blw_100 !== null)) {
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.oldValue = "NA";
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.newValue = objProductNew.flt_PSDMax_blw_100;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param56_Upp !== null) && (objProductNew.flt_PSDMax_blw_100 === null)) {
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.oldValue = parseFloat(objProductOld.Param56_Upp).toFixed(objProductOld.Param56_DP);
                        objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_blw_100);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_Lay_1 = {
                ParticleSizeDistribution_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_Lay_1 != "" && objProductNew.flt_PSDMin_Lay_1 != undefined) {
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.oldValue = "NA";
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.oldValue = false;
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param57_Low === "" || objProductOld.Param57_Low == this.strNullValue || objProductOld.Param57_Low == undefined) {
                    objProductOld.Param57_Low = null;
                }

                if (objProductNew.flt_PSDMin_Lay_1 == "" || objProductNew.flt_PSDMin_Lay_1 == this.strNullValue || objProductNew.flt_PSDMin_Lay_1 == undefined) {
                    objProductNew.flt_PSDMin_Lay_1 = null;
                }

                if ((objProductOld.Param57_Low !== null) && (objProductNew.flt_PSDMin_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param57_Low).toFixed(objProductOld.Param57_DP) == parseFloat(objProductNew.flt_PSDMin_Lay_1).toFixed(objProductNew.int_PSD_DpGran_Lay_1)) {
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.oldValue = false;
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param57_Low).toFixed(objProductOld.Param57_DP);
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param57_Low === null) && (objProductNew.flt_PSDMin_Lay_1 !== null)) {
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.oldValue = "NA";
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param57_Low !== null) && (objProductNew.flt_PSDMin_Lay_1 === null)) {
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param57_Low).toFixed(objProductOld.Param57_DP);
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_Lay_1 != "" && objProductNew.flt_PSDMax_Lay_1 != undefined) {
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.oldValue = "NA";
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.oldValue = false;
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param57_Upp == "" || objProductOld.Param57_Upp == this.strNullValue || objProductOld.Param57_Upp == undefined) {
                    objProductOld.Param57_Upp = null;
                }

                if (objProductNew.flt_PSDMax_Lay_1 == "" || objProductNew.flt_PSDMax_Lay_1 == this.strNullValue || objProductNew.flt_PSDMax_Lay_1 == undefined) {
                    objProductNew.flt_PSDMax_Lay_1 = null;
                }

                if ((objProductOld.Param57_Upp !== null) && (objProductNew.flt_PSDMax_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param57_Upp).toFixed(objProductOld.Param57_DP) == parseFloat(objProductNew.flt_PSDMax_Lay_1).toFixed(objProductNew.int_PSD_DpGran_Lay_1)) {
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.oldValue = false;
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param57_Upp).toFixed(objProductOld.Param57_DP);
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param57_Upp === null) && (objProductNew.flt_PSDMax_Lay_1 !== null)) {
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.oldValue = "NA";
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param57_Upp !== null) && (objProductNew.flt_PSDMax_Lay_1 === null)) {
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param57_Upp).toFixed(objProductOld.Param57_DP);
                        objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_20_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_20_Lay_1 = {
                ParticleSizeDistribution_abv_20_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_20_Lay_1 != "" && objProductNew.flt_PSDMin_abv_20_Lay_1 != undefined) {
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.oldValue = "NA";
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_20_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.oldValue = false;
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param58_Low === "" || objProductOld.Param58_Low == this.strNullValue || objProductOld.Param58_Low == undefined) {
                    objProductOld.Param58_Low = null;
                }

                if (objProductNew.flt_PSDMin_abv_20_Lay_1 == "" || objProductNew.flt_PSDMin_abv_20_Lay_1 == this.strNullValue || objProductNew.flt_PSDMin_abv_20_Lay_1 == undefined) {
                    objProductNew.flt_PSDMin_abv_20_Lay_1 = null;
                }

                if ((objProductOld.Param58_Low !== null) && (objProductNew.flt_PSDMin_abv_20_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param58_Low).toFixed(objProductOld.Param58_DP) == parseFloat(objProductNew.flt_PSDMin_abv_20_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_20_Lay_1)) {
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.oldValue = false;
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param58_Low).toFixed(objProductOld.Param58_DP);
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_20_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param58_Low === null) && (objProductNew.flt_PSDMin_abv_20_Lay_1 !== null)) {
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.oldValue = "NA";
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_20_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param58_Low !== null) && (objProductNew.flt_PSDMin_abv_20_Lay_1 === null)) {
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param58_Low).toFixed(objProductOld.Param58_DP);
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_20_Lay_1 != "" && objProductNew.flt_PSDMax_abv_20_Lay_1 != undefined) {
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.oldValue = "NA";
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_20_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.oldValue = false;
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param58_Upp == "" || objProductOld.Param58_Upp == this.strNullValue || objProductOld.Param58_Upp == undefined) {
                    objProductOld.Param58_Upp = null;
                }

                if (objProductNew.flt_PSDMax_abv_20_Lay_1 == "" || objProductNew.flt_PSDMax_abv_20_Lay_1 == this.strNullValue || objProductNew.flt_PSDMax_abv_20_Lay_1 == undefined) {
                    objProductNew.flt_PSDMax_abv_20_Lay_1 = null;
                }

                if ((objProductOld.Param58_Upp !== null) && (objProductNew.flt_PSDMax_abv_20_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param58_Upp).toFixed(objProductOld.Param58_DP) == parseFloat(objProductNew.flt_PSDMax_abv_20_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_20_Lay_1)) {
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.oldValue = false;
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param58_Upp).toFixed(objProductOld.Param58_DP);
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_20_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param58_Upp === null) && (objProductNew.flt_PSDMax_abv_20_Lay_1 !== null)) {
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.oldValue = "NA";
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_20_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param58_Upp !== null) && (objProductNew.flt_PSDMax_abv_20_Lay_1 === null)) {
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param58_Upp).toFixed(objProductOld.Param58_DP);
                        objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_20_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_40_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_40_Lay_1 = {
                ParticleSizeDistribution_abv_40_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_40_Lay_1 != "" && objProductNew.flt_PSDMin_abv_40_Lay_1 != undefined) {
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.oldValue = "NA";
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_40_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.oldValue = false;
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param59_Low === "" || objProductOld.Param59_Low == this.strNullValue || objProductOld.Param59_Low == undefined) {
                    objProductOld.Param59_Low = null;
                }

                if (objProductNew.flt_PSDMin_abv_40_Lay_1 == "" || objProductNew.flt_PSDMin_abv_40_Lay_1 == this.strNullValue || objProductNew.flt_PSDMin_abv_40_Lay_1 == undefined) {
                    objProductNew.flt_PSDMin_abv_40_Lay_1 = null;
                }

                if ((objProductOld.Param59_Low !== null) && (objProductNew.flt_PSDMin_abv_40_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param59_Low).toFixed(objProductOld.Param59_DP) == parseFloat(objProductNew.flt_PSDMin_abv_40_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_40_Lay_1)) {
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.oldValue = false;
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param59_Low).toFixed(objProductOld.Param59_DP);
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_40_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param59_Low === null) && (objProductNew.flt_PSDMin_abv_40_Lay_1 !== null)) {
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.oldValue = "NA";
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_40_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param59_Low !== null) && (objProductNew.flt_PSDMin_abv_40_Lay_1 === null)) {
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param59_Low).toFixed(objProductOld.Param59_DP);
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_40_Lay_1 != "" && objProductNew.flt_PSDMax_abv_40_Lay_1 != undefined) {
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.oldValue = "NA";
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_40_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.oldValue = false;
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param59_Upp == "" || objProductOld.Param59_Upp == this.strNullValue || objProductOld.Param59_Upp == undefined) {
                    objProductOld.Param59_Upp = null;
                }

                if (objProductNew.flt_PSDMax_abv_40_Lay_1 == "" || objProductNew.flt_PSDMax_abv_40_Lay_1 == this.strNullValue || objProductNew.flt_PSDMax_abv_40_Lay_1 == undefined) {
                    objProductNew.flt_PSDMax_abv_40_Lay_1 = null;
                }

                if ((objProductOld.Param59_Upp !== null) && (objProductNew.flt_PSDMax_abv_40_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param59_Upp).toFixed(objProductOld.Param59_DP) == parseFloat(objProductNew.flt_PSDMax_abv_40_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_40_Lay_1)) {
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.oldValue = false;
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param59_Upp).toFixed(objProductOld.Param59_DP);
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_40_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param59_Upp === null) && (objProductNew.flt_PSDMax_abv_40_Lay_1 !== null)) {
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.oldValue = "NA";
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_40_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param59_Upp !== null) && (objProductNew.flt_PSDMax_abv_40_Lay_1 === null)) {
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param59_Upp).toFixed(objProductOld.Param59_DP);
                        objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_40_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_60_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_60_Lay_1 = {
                ParticleSizeDistribution_abv_60_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_60_Lay_1 != "" && objProductNew.flt_PSDMin_abv_60_Lay_1 != undefined) {
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.oldValue = "NA";
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_60_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.oldValue = false;
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param60_Low === "" || objProductOld.Param60_Low == this.strNullValue || objProductOld.Param60_Low == undefined) {
                    objProductOld.Param60_Low = null;
                }

                if (objProductNew.flt_PSDMin_abv_60_Lay_1 == "" || objProductNew.flt_PSDMin_abv_60_Lay_1 == this.strNullValue || objProductNew.flt_PSDMin_abv_60_Lay_1 == undefined) {
                    objProductNew.flt_PSDMin_abv_60_Lay_1 = null;
                }

                if ((objProductOld.Param60_Low !== null) && (objProductNew.flt_PSDMin_abv_60_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param60_Low).toFixed(objProductOld.Param60_DP) == parseFloat(objProductNew.flt_PSDMin_abv_60_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_60_Lay_1)) {
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.oldValue = false;
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param60_Low).toFixed(objProductOld.Param60_DP);
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_60_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param60_Low === null) && (objProductNew.flt_PSDMin_abv_60_Lay_1 !== null)) {
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.oldValue = "NA";
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_60_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param60_Low !== null) && (objProductNew.flt_PSDMin_abv_60_Lay_1 === null)) {
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param60_Low).toFixed(objProductOld.Param60_DP);
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_60_Lay_1 != "" && objProductNew.flt_PSDMax_abv_60_Lay_1 != undefined) {
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.oldValue = "NA";
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_60_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.oldValue = false;
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param60_Upp == "" || objProductOld.Param60_Upp == this.strNullValue || objProductOld.Param60_Upp == undefined) {
                    objProductOld.Param60_Upp = null;
                }

                if (objProductNew.flt_PSDMax_abv_60_Lay_1 == "" || objProductNew.flt_PSDMax_abv_60_Lay_1 == this.strNullValue || objProductNew.flt_PSDMax_abv_60_Lay_1 == undefined) {
                    objProductNew.flt_PSDMax_abv_60_Lay_1 = null;
                }

                if ((objProductOld.Param60_Upp !== null) && (objProductNew.flt_PSDMax_abv_60_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param60_Upp).toFixed(objProductOld.Param60_DP) == parseFloat(objProductNew.flt_PSDMax_abv_60_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_60_Lay_1)) {
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.oldValue = false;
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param60_Upp).toFixed(objProductOld.Param60_DP);
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_60_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param60_Upp === null) && (objProductNew.flt_PSDMax_abv_60_Lay_1 !== null)) {
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.oldValue = "NA";
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_60_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param60_Upp !== null) && (objProductNew.flt_PSDMax_abv_60_Lay_1 === null)) {
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param60_Upp).toFixed(objProductOld.Param60_DP);
                        objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_60_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_80_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_80_Lay_1 = {
                ParticleSizeDistribution_abv_80_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_80_Lay_1 != "" && objProductNew.flt_PSDMin_abv_80_Lay_1 != undefined) {
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.oldValue = "NA";
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_80_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.oldValue = false;
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param61_Low === "" || objProductOld.Param61_Low == this.strNullValue || objProductOld.Param61_Low == undefined) {
                    objProductOld.Param61_Low = null;
                }

                if (objProductNew.flt_PSDMin_abv_80_Lay_1 == "" || objProductNew.flt_PSDMin_abv_80_Lay_1 == this.strNullValue || objProductNew.flt_PSDMin_abv_80_Lay_1 == undefined) {
                    objProductNew.flt_PSDMin_abv_80_Lay_1 = null;
                }

                if ((objProductOld.Param61_Low !== null) && (objProductNew.flt_PSDMin_abv_80_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param61_Low).toFixed(objProductOld.Param61_DP) == parseFloat(objProductNew.flt_PSDMin_abv_80_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_80_Lay_1)) {
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.oldValue = false;
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param61_Low).toFixed(objProductOld.Param61_DP);
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_80_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param61_Low === null) && (objProductNew.flt_PSDMin_abv_80_Lay_1 !== null)) {
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.oldValue = "NA";
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_80_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param61_Low !== null) && (objProductNew.flt_PSDMin_abv_80_Lay_1 === null)) {
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param61_Low).toFixed(objProductOld.Param61_DP);
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_80_Lay_1 != "" && objProductNew.flt_PSDMax_abv_80_Lay_1 != undefined) {
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.oldValue = "NA";
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_80_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.oldValue = false;
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param61_Upp == "" || objProductOld.Param61_Upp == this.strNullValue || objProductOld.Param61_Upp == undefined) {
                    objProductOld.Param61_Upp = null;
                }

                if (objProductNew.flt_PSDMax_abv_80_Lay_1 == "" || objProductNew.flt_PSDMax_abv_80_Lay_1 == this.strNullValue || objProductNew.flt_PSDMax_abv_80_Lay_1 == undefined) {
                    objProductNew.flt_PSDMax_abv_80_Lay_1 = null;
                }

                if ((objProductOld.Param61_Upp !== null) && (objProductNew.flt_PSDMax_abv_80_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param61_Upp).toFixed(objProductOld.Param61_DP) == parseFloat(objProductNew.flt_PSDMax_abv_80_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_80_Lay_1)) {
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.oldValue = false;
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param61_Upp).toFixed(objProductOld.Param61_DP);
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_80_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param61_Upp === null) && (objProductNew.flt_PSDMax_abv_80_Lay_1 !== null)) {
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.oldValue = "NA";
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_80_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param61_Upp !== null) && (objProductNew.flt_PSDMax_abv_80_Lay_1 === null)) {
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param61_Upp).toFixed(objProductOld.Param61_DP);
                        objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_80_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_100_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_100_Lay_1 = {
                ParticleSizeDistribution_abv_100_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_abv_100_Lay_1 != "" && objProductNew.flt_PSDMin_abv_100_Lay_1 != undefined) {
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.oldValue = "NA";
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_100_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.oldValue = false;
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param62_Low === "" || objProductOld.Param62_Low == this.strNullValue || objProductOld.Param62_Low == undefined) {
                    objProductOld.Param62_Low = null;
                }

                if (objProductNew.flt_PSDMin_abv_100_Lay_1 == "" || objProductNew.flt_PSDMin_abv_100_Lay_1 == this.strNullValue || objProductNew.flt_PSDMin_abv_100_Lay_1 == undefined) {
                    objProductNew.flt_PSDMin_abv_100_Lay_1 = null;
                }

                if ((objProductOld.Param62_Low !== null) && (objProductNew.flt_PSDMin_abv_100_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param62_Low).toFixed(objProductOld.Param62_DP) == parseFloat(objProductNew.flt_PSDMin_abv_100_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_100_Lay_1)) {
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.oldValue = false;
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param62_Low).toFixed(objProductOld.Param62_DP);
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_100_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param62_Low === null) && (objProductNew.flt_PSDMin_abv_100_Lay_1 !== null)) {
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.oldValue = "NA";
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_abv_100_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param62_Low !== null) && (objProductNew.flt_PSDMin_abv_100_Lay_1 === null)) {
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param62_Low).toFixed(objProductOld.Param62_DP);
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_abv_100_Lay_1 != "" && objProductNew.flt_PSDMax_abv_100_Lay_1 != undefined) {
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.oldValue = "NA";
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_100_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.oldValue = false;
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param62_Upp == "" || objProductOld.Param62_Upp == this.strNullValue || objProductOld.Param62_Upp == undefined) {
                    objProductOld.Param62_Upp = null;
                }

                if (objProductNew.flt_PSDMax_abv_100_Lay_1 == "" || objProductNew.flt_PSDMax_abv_100_Lay_1 == this.strNullValue || objProductNew.flt_PSDMax_abv_100_Lay_1 == undefined) {
                    objProductNew.flt_PSDMax_abv_100_Lay_1 = null;
                }

                if ((objProductOld.Param62_Upp !== null) && (objProductNew.flt_PSDMax_abv_100_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param62_Upp).toFixed(objProductOld.Param62_DP) == parseFloat(objProductNew.flt_PSDMax_abv_100_Lay_1).toFixed(objProductNew.int_PSD_DpGran_abv_100_Lay_1)) {
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.oldValue = false;
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param62_Upp).toFixed(objProductOld.Param62_DP);
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_100_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param62_Upp === null) && (objProductNew.flt_PSDMax_abv_100_Lay_1 !== null)) {
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.oldValue = "NA";
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_abv_100_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param62_Upp !== null) && (objProductNew.flt_PSDMax_abv_100_Lay_1 === null)) {
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param62_Upp).toFixed(objProductOld.Param62_DP);
                        objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_100_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_blw_100_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_blw_100_Lay_1 = {
                ParticleSizeDistribution_blw_100_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMin_blw_100_Lay_1 != "" && objProductNew.flt_PSDMin_blw_100_Lay_1 != undefined) {
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.oldValue = "NA";
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_blw_100_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.oldValue = false;
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param63_Low === "" || objProductOld.Param63_Low == this.strNullValue || objProductOld.Param63_Low == undefined) {
                    objProductOld.Param63_Low = null;
                }

                if (objProductNew.flt_PSDMin_blw_100_Lay_1 == "" || objProductNew.flt_PSDMin_blw_100_Lay_1 == this.strNullValue || objProductNew.flt_PSDMin_blw_100_Lay_1 == undefined) {
                    objProductNew.flt_PSDMin_blw_100_Lay_1 = null;
                }

                if ((objProductOld.Param63_Low !== null) && (objProductNew.flt_PSDMin_blw_100_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param63_Low).toFixed(objProductOld.Param63_DP) == parseFloat(objProductNew.flt_PSDMin_blw_100_Lay_1).toFixed(objProductNew.int_PSD_DpGran_blw_100_Lay_1)) {
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.oldValue = false;
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param63_Low).toFixed(objProductOld.Param63_DP);
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_blw_100_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param63_Low === null) && (objProductNew.flt_PSDMin_blw_100_Lay_1 !== null)) {
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.oldValue = "NA";
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.newValue = objProductNew.flt_PSDMin_blw_100_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param63_Low !== null) && (objProductNew.flt_PSDMin_blw_100_Lay_1 === null)) {
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param63_Low).toFixed(objProductOld.Param63_DP);
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PSDMax_blw_100_Lay_1 != "" && objProductNew.flt_PSDMax_blw_100_Lay_1 != undefined) {
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.oldValue = "NA";
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_blw_100_Lay_1;
                    IsChanged = true;
                }
                else {
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.oldValue = false;
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param63_Upp == "" || objProductOld.Param63_Upp == this.strNullValue || objProductOld.Param63_Upp == undefined) {
                    objProductOld.Param63_Upp = null;
                }

                if (objProductNew.flt_PSDMax_blw_100_Lay_1 == "" || objProductNew.flt_PSDMax_blw_100_Lay_1 == this.strNullValue || objProductNew.flt_PSDMax_blw_100_Lay_1 == undefined) {
                    objProductNew.flt_PSDMax_blw_100_Lay_1 = null;
                }

                if ((objProductOld.Param63_Upp !== null) && (objProductNew.flt_PSDMax_blw_100_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param63_Upp).toFixed(objProductOld.Param63_DP) == parseFloat(objProductNew.flt_PSDMax_blw_100_Lay_1).toFixed(objProductNew.int_PSD_DpGran_blw_100_Lay_1)) {
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.oldValue = false;
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param63_Upp).toFixed(objProductOld.Param63_DP);
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_blw_100_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param63_Upp === null) && (objProductNew.flt_PSDMax_blw_100_Lay_1 !== null)) {
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.oldValue = "NA";
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.newValue = objProductNew.flt_PSDMax_blw_100_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param63_Upp !== null) && (objProductNew.flt_PSDMax_blw_100_Lay_1 === null)) {
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param63_Upp).toFixed(objProductOld.Param63_DP);
                        objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_blw_100_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSeizing_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objParticleSeizing_Lay_1 = {
                ParticleSizing_Lay_1: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PartSizingMin_Lay_1 != "" && objProductNew.flt_PartSizingMin_Lay_1 != undefined) {
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.oldValue = "NA";
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.newValue = objProductNew.flt_PartSizingMin_Lay_1;
                    IsChanged = true;
                }
                else {
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.oldValue = false;
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param64_Low === "" || objProductOld.Param64_Low == this.strNullValue || objProductOld.Param64_Low == undefined) {
                    objProductOld.Param64_Low = null;
                }

                if (objProductNew.flt_PartSizingMin_Lay_1 == "" || objProductNew.flt_PartSizingMin_Lay_1 == this.strNullValue || objProductNew.flt_PartSizingMin_Lay_1 == undefined) {
                    objProductNew.flt_PartSizingMin_Lay_1 = null;
                }

                if ((objProductOld.Param64_Low !== null) && (objProductNew.flt_PartSizingMin_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param64_Low).toFixed(objProductOld.Param64_DP) == parseFloat(objProductNew.flt_PartSizingMin_Lay_1).toFixed(objProductNew.int_psDpGran_Lay_1)) {
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.oldValue = false;
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param64_Low).toFixed(objProductOld.Param64_DP);
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.newValue = objProductNew.flt_PartSizingMin_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param64_Low === null) && (objProductNew.flt_PartSizingMin_Lay_1 !== null)) {
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.oldValue = "NA";
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.newValue = objProductNew.flt_PartSizingMin_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param64_Low !== null) && (objProductNew.flt_PartSizingMin_Lay_1 === null)) {
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.oldValue = parseFloat(objProductOld.Param64_Low).toFixed(objProductOld.Param64_DP);
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PartSizingMax_Lay_1 != "" && objProductNew.flt_PartSizingMax_Lay_1 != undefined) {
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.oldValue = "NA";
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.newValue = objProductNew.flt_PartSizingMax_Lay_1;
                    IsChanged = true;
                }
                else {
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.oldValue = false;
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param64_Upp == "" || objProductOld.Param64_Upp == this.strNullValue || objProductOld.Param64_Upp == undefined) {
                    objProductOld.Param64_Upp = null;
                }

                if (objProductNew.flt_PartSizingMax_Lay_1 == "" || objProductNew.flt_PartSizingMax_Lay_1 == this.strNullValue || objProductNew.flt_PartSizingMax_Lay_1 == undefined) {
                    objProductNew.flt_PartSizingMax_Lay_1 = null;
                }

                if ((objProductOld.Param64_Upp !== null) && (objProductNew.flt_PartSizingMax_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param64_Upp).toFixed(objProductOld.Param64_DP) == parseFloat(objProductNew.flt_PartSizingMax_Lay_1).toFixed(objProductNew.int_psDpGran_Lay_1)) {
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.oldValue = false;
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param64_Upp).toFixed(objProductOld.Param64_DP);
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.newValue = objProductNew.flt_PartSizingMax_Lay_1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param64_Upp === null) && (objProductNew.flt_PartSizingMax_Lay_1 !== null)) {
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.oldValue = "NA";
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.newValue = objProductNew.flt_PartSizingMax_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param64_Upp !== null) && (objProductNew.flt_PartSizingMax_Lay_1 === null)) {
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.oldValue = parseFloat(objProductOld.Param64_Upp).toFixed(objProductOld.Param64_DP);
                        objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objParticleSeizing_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSeizing_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objParticleSeizing_Lay_2 = {
                ParticleSizing_Lay_2: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;

            /**
             * For MIN
             */
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty == true) {
                if (objProductNew.flt_PartSizingMin_Lay_2 != "" && objProductNew.flt_PartSizingMin_Lay_2 != undefined) {
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.oldValue = "NA";
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.newValue = objProductNew.flt_PartSizingMin_Lay_2;
                    IsChanged = true;
                }
                else {
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.oldValue = false;
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param65_Low === "" || objProductOld.Param65_Low == this.strNullValue || objProductOld.Param65_Low == undefined) {
                    objProductOld.Param65_Low = null;
                }

                if (objProductNew.flt_PartSizingMin_Lay_2 == "" || objProductNew.flt_PartSizingMin_Lay_2 == this.strNullValue || objProductNew.flt_PartSizingMin_Lay_2 == undefined) {
                    objProductNew.flt_PartSizingMin_Lay_2 = null;
                }

                if ((objProductOld.Param65_Low !== null) && (objProductNew.flt_PartSizingMin_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param65_Low).toFixed(objProductOld.Param65_DP) == parseFloat(objProductNew.flt_PartSizingMin_Lay_2).toFixed(objProductNew.int_psDpGran_Lay_2)) {
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.oldValue = false;
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param65_Low).toFixed(objProductOld.Param65_DP);
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.newValue = objProductNew.flt_PartSizingMin_Lay_2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param65_Low === null) && (objProductNew.flt_PartSizingMin_Lay_2 !== null)) {
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.oldValue = "NA";
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.newValue = objProductNew.flt_PartSizingMin_Lay_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param65_Low !== null) && (objProductNew.flt_PartSizingMin_Lay_2 === null)) {
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.oldValue = parseFloat(objProductOld.Param65_Low).toFixed(objProductOld.Param65_DP);
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For MAX
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_PartSizingMax_Lay_2 != "" && objProductNew.flt_PartSizingMax_Lay_2 != undefined) {
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.oldValue = "NA";
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.newValue = objProductNew.flt_PartSizingMax_Lay_2;
                    IsChanged = true;
                }
                else {
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.oldValue = false;
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param65_Upp == "" || objProductOld.Param65_Upp == this.strNullValue || objProductOld.Param65_Upp == undefined) {
                    objProductOld.Param65_Upp = null;
                }

                if (objProductNew.flt_PartSizingMax_Lay_2 == "" || objProductNew.flt_PartSizingMax_Lay_2 == this.strNullValue || objProductNew.flt_PartSizingMax_Lay_2 == undefined) {
                    objProductNew.flt_PartSizingMax_Lay_2 = null;
                }

                if ((objProductOld.Param65_Upp !== null) && (objProductNew.flt_PartSizingMax_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param65_Upp).toFixed(objProductOld.Param65_DP) == parseFloat(objProductNew.flt_PartSizingMax_Lay_2).toFixed(objProductNew.int_psDpGran_Lay_2)) {
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.oldValue = false;
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param65_Upp).toFixed(objProductOld.Param65_DP);
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.newValue = objProductNew.flt_PartSizingMax_Lay_2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param65_Upp === null) && (objProductNew.flt_PartSizingMax_Lay_2 !== null)) {
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.oldValue = "NA";
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.newValue = objProductNew.flt_PartSizingMax_Lay_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param65_Upp !== null) && (objProductNew.flt_PartSizingMax_Lay_2 === null)) {
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.oldValue = parseFloat(objProductOld.Param65_Upp).toFixed(objProductOld.Param65_DP);
                        objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objParticleSeizing_Lay_2);
            }
            resolve(IsChanged);
        });
    }

}
module.exports = ValidateProductGranulation;