const clsvalidateCompressed = require('./validateProductCompressed.class');
const clsvalidateCoated = require('./validateProductCoated.class');
const clsvalidateGrannuals = require('./validateProductGranulation.class');
const clsValidateCapsule = require('./validateCapsule.class');
const clsvalidateProductDetail = require('./validateProductDetail.class');
class ValidateProduct {

    /**
    * Before Adding Tablet or Capsule each parameter has to validate for any change in existing parameters
    * So Below function will validation tablet as well as capsule and return result as per it .
    * @param {*} objProductOld : Old Values Object In Add Tablet or Capsule the object is undefined
    * @param {*} objProductNew : New values object
    * @param {*} intProductType : Product Type 1 = Tablet , 2 = Capsule
    */
    async validateProduct(objProductOld, objProductNew, intProductType = 1, objProductDetail, strProjectName, intGenericName) {
        if (intProductType == 1) {
            let resCompressed = "", resCoated = "", resGrannual = "", resProductDetail = "";

            const objClsValidateProductDetail = new clsvalidateProductDetail();
            resProductDetail = await objClsValidateProductDetail.validateProductDetails(objProductDetail, intGenericName);

            if (objProductNew.bln_TypeCompressed == true || objProductNew.wasCompressed == true) {
                const objClsValidateCompressed = new clsvalidateCompressed();
                // No Change Message when you add new compressed parameter while editing the product which has only granulation parameter
                //BEcause validation got skiped because there is no old data for compression
                // if(objProductOld.Compressed != undefined){
                resCompressed = await objClsValidateCompressed.validateCompressedParams(objProductOld.Compressed, objProductNew, strProjectName);
                // }
            }
            if (objProductNew.bln_TypeBiLayPrd == true || objProductNew.wasBilayer == true) {
                const objClsValidateCompressed = new clsvalidateCompressed();
                resCompressed = await objClsValidateCompressed.validateCompressedParams(objProductOld.Compressed, objProductNew, strProjectName);
            }
            if (objProductNew.bln_TypeTriLayPrd == true || objProductNew.wasTrilayer == true) {
                const objClsValidateCompressed = new clsvalidateCompressed();
                resCompressed = await objClsValidateCompressed.validateCompressedParams(objProductOld.Compressed, objProductNew, strProjectName);
            }
            if (objProductNew.bln_TypeCoatPrd == true || objProductNew.wasCoated == true) {
                const objClsValidateCoated = new clsvalidateCoated();
                resCoated = await objClsValidateCoated.validateCoatedParams(objProductOld.Coated, objProductNew);
            }
            if (objProductNew.bln_TypeGrannualPrd == true || objProductNew.wasGrannual == true) {
                const objClsvalidateGrannuals = new clsvalidateGrannuals();
                resGrannual = await objClsvalidateGrannuals.validateGranulationParams(objProductOld.Granulation, objProductNew);
            }

            resCompressed = resCompressed == undefined || resCompressed == "" ? "No Change" : resCompressed;
            resCoated = resCoated == undefined || resCoated == "" ? "No Change" : resCoated;
            resGrannual = resGrannual == undefined || resGrannual == "" ? "No Change" : resGrannual;

            if (resCompressed == "No Change" && resCoated == "No Change" && resGrannual == "No Change" && resProductDetail == "No Change") {
                return { result: "No Change" };
            }
            else {
                //var resCompressed,resCoated,resGrannual;
                if (resCompressed == "No Change") {
                    resCompressed = { result: "No Change" };
                }
                if (resCoated == "No Change") {
                    resCoated = { result: "No Change" };
                }
                if (resGrannual == "No Change") {
                    resGrannual = { result: "No Change" };
                }
                if (resProductDetail == "No Change") {
                    resProductDetail = { result: "No Change" };
                }

                const objProduct = {};
                Object.assign(objProduct, { Compressed: resCompressed }, { Coated: resCoated });
                Object.assign(objProduct, { Grannual: resGrannual }, { ProductDetail: resProductDetail });
                return objProduct;
            }
        }
        else {
            let resCapsule = "", resProductDetail = "", resGrannual = "";

            const objClsValidateProductDetail = new clsvalidateProductDetail();
            resProductDetail = await objClsValidateProductDetail.validateProductDetails(objProductDetail, intGenericName);

            //wasCompressed and bln_TypeCompressed is used for capsule only
            if (objProductNew.bln_TypeCompressed == true || objProductNew.wasCompressed == true) {
                const objValidateCapsule = new clsValidateCapsule();
                resCapsule = await objValidateCapsule.validateCapsuleParams(objProductOld.Capsule, objProductNew);
            }

            if (objProductNew.bln_TypeGrannualPrd == true || objProductNew.wasGrannual == true) {
                const objClsvalidateGrannuals = new clsvalidateGrannuals();
                resGrannual = await objClsvalidateGrannuals.validateGranulationParamsCap(objProductOld.Granulation, objProductNew);
            }

            if((resCapsule.newData == '') && (resCapsule.oldData == '')){
                resCapsule = 'No Change';
            }

            resCapsule = resCapsule == undefined ? "No Change" : resCapsule;
            resCapsule = resCapsule == "" ? "No Change" : resCapsule;
            resGrannual = resGrannual == undefined || resGrannual == "" ? "No Change" : resGrannual;

            if (resCapsule == "No Change" && resProductDetail == "No Change" && resGrannual == "No Change") {
                return { result: "No Change" };
            }
            else {
                if (resCapsule == "No Change") {
                    resCapsule = { result: "No Change" };
                }
                if (resProductDetail == "No Change") {
                    resProductDetail = { result: "No Change" };
                }
                if (resGrannual == "No Change") {
                    resGrannual = { result: "No Change" };
                }
                const objProduct = {};
                Object.assign(objProduct, { Capsule: resCapsule }, { ProductDetail: resProductDetail });
                Object.assign(objProduct, { Grannual: resGrannual });
                return objProduct;
            }
        }

    }


}

module.exports = ValidateProduct;