const date = require('date-and-time')
const models = require('./../dbConnection').models;
const sequelize = require('./../dbConnection').sequelize;
const seqTransaction = require('./../dbConnection');
const { Op } = require("sequelize");

class PrecalibrationModel{

async getcalibrationArea(){
    try{
           
            const objPrecaliArea = await models.tbl_cubicle_area.findAll({
                where: {
                    Flag: 1
                }
            });
            var result = objPrecaliArea;
            return result;
        }catch(error){
            return error;
        }
    }
    async getEqpID()
    {
        try{
            
            let result = await models.tbl_audit_precalibration.findAll({
                attributes: [[sequelize.fn('DISTINCT', sequelize.col('Equipment_ID')), 'Equipment_ID']],
                where:{
                    Equipment_Type:'Balance'
                },
            });
            return result;
        }catch(error){
            return error;
        }
    }

    async getEqpIDVernier()
    {
        try{
         
            let eqpIDObj = await models.tbl_audit_precalibration.findAll({
                attributes: [[sequelize.fn('DISTINCT', sequelize.col('Equipment_ID')), 'Equipment_ID']],
                where:{
                    Equipment_Type:{[Op.eq]:'Vernier'}
                },
            });
            let result = eqpIDObj;
            return result[0];
        }catch(error){
            return error;
        }
        
    }

  async getcubicleNo(req){
        try{
           

            let objPrecaliArea = await models.tbl_cubical.findAll({
                //attributes: [[sequelize.fn('DISTINCT', sequelize.col('Equipment_ID')), 'Equipment_ID']],
                where:{
                    Sys_Area:{[Op.eq]:req.body.area},
                    Sys_CalibInProcess:{[Op.eq]:0}
                },
            });
            let result = objPrecaliArea;
            return result;
            
        }catch(error){
            return error;
        }
    }

 async storePrecalibration(req){
        try{
            let responseObj = {};
            var strPrecalibration = req.body.calibrationType;
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var now = new Date();
                var wtArray = req.body.weights;
                var weightbox = [],weights = [],identificationNo = [],weightUnit = [];
                var certificateNo = [],ValidateDate = [],calibDate = [];
                for(var wtVal of wtArray){
                    weightbox.push(wtVal.weightBox);
                    weights.push(wtVal.weights);
                    identificationNo.push(wtVal.identificationNo);
                    weightUnit.push(wtVal.calibrationWeightUnit);
                    certificateNo.push(wtVal.certificateNo);
                    ValidateDate.push(wtVal.cbValidDate );
                    calibDate.push(wtVal.cbCalibDate );
                }
                var weightboxVal = weightbox.toString();
                var weightsVal = weights.toString();
                var identificationNoVal = identificationNo.toString();
                var weightUnitVal = weightUnit.toString();
                var certificateVal = certificateNo.toString();
                var cbValidDateVal = ValidateDate.toString();
                var calibDateVal = calibDate.toString();
                
    
                var Objprecalibration;
               if(strPrecalibration == "Daily"){
                    Objprecalibration = await models.tbl_precalibration_daily.create({
                        UID: req.body.UID,
                        Equipment_ID: req.body.equipmentID,
                        Equipment_Type: req.body.equipmentType,
                        Cubicle_Number: parseInt(req.body.cublicleNo),
                        Area_Name: req.body.area,
                        Cubicle_Name: req.body.cubicleName,
                        Standard_Weight_Block: req.body.standardWeight,
                        Negative_Tolerance: req.body.negativeTolerance,
                        Positive_Tolerance: req.body.positiveTolerance,
                        CalibrationBox_ID: weightboxVal,
                        CalibrationBox_Calibration_Date: calibDateVal,
                        CalibrationBox_Validity_Date: cbValidDateVal,
                        CalibrationBox_Calibration_CertificateNo: certificateVal,
                        CalibrationBox_Elements_IDNo: identificationNoVal,
                        CalibrationBox_Selected_Elements: weightsVal,
                        CalibrationBox_Elements_Unit: weightUnitVal ,
                        Repeat_Count: parseInt(req.body.repeatCount),
                        Percent_of_Capacity: parseInt(req.body.percentageOfCapacity),
                        Decimal_Point: parseInt(req.body.decimalPoint)
                    },{
                        transaction: t
                    });
                } else if(["Accuracy","Periodic"].includes(strPrecalibration)){
                    Objprecalibration = await models.tbl_precalibration_periodic.create({
                        UID: req.body.UID,
                        Equipment_ID: req.body.equipmentID,
                        Equipment_Type: req.body.equipmentType,
                        Cubicle_Number: parseInt(req.body.cublicleNo),
                        Area_Name: req.body.area,
                        Cubicle_Name: req.body.cubicleName,
                        Standard_Weight_Block: req.body.standardWeight,
                        Negative_Tolerance: req.body.negativeTolerance,
                        Positive_Tolerance: req.body.positiveTolerance,
                        CalibrationBox_ID: weightboxVal,
                        CalibrationBox_Calibration_Date: calibDateVal,
                        CalibrationBox_Validity_Date: cbValidDateVal,
                        CalibrationBox_Calibration_CertificateNo: certificateVal,
                        CalibrationBox_Elements_IDNo: identificationNoVal,
                        CalibrationBox_Selected_Elements: weightsVal,
                        CalibrationBox_Elements_Unit: weightUnitVal ,
                        Repeat_Count: parseInt(req.body.repeatCount),
                        Percent_of_Capacity: parseInt(req.body.percentageOfCapacity),
                        Decimal_Point: parseInt(req.body.decimalPoint)
                    },{
                        transaction: t
                    });
                } else if(strPrecalibration == "Eccentricity"){
                    Objprecalibration = await models.tbl_precalibration_eccentricity.create({
                        UID: req.body.UID,
                        Equipment_ID: req.body.equipmentID,
                        Equipment_Type: req.body.equipmentType,
                        Cubicle_Number: parseInt(req.body.cublicleNo),
                        Area_Name: req.body.area,
                        Cubicle_Name: req.body.cubicleName,
                        Standard_Weight_Block: req.body.standardWeight,
                        Negative_Tolerance: req.body.negativeTolerance,
                        Positive_Tolerance: req.body.positiveTolerance,
                        CalibrationBox_ID: weightboxVal,
                        CalibrationBox_Calibration_Date: calibDateVal,
                        CalibrationBox_Validity_Date: cbValidDateVal,
                        CalibrationBox_Calibration_CertificateNo: certificateVal,
                        CalibrationBox_Elements_IDNo: identificationNoVal,
                        CalibrationBox_Selected_Elements: weightsVal,
                        CalibrationBox_Elements_Unit: weightUnitVal ,
                        Repeat_Count: parseInt(req.body.repeatCount),
                        Percent_of_Capacity: parseInt(req.body.percentageOfCapacity),
                        Decimal_Point: parseInt(req.body.decimalPoint)
                    },{
                        transaction: t
                    });
                } else if(strPrecalibration == "Linearity"){
                    Objprecalibration = await models.tbl_precalibration_linearity.create({
                        UID: req.body.UID,
                        Equipment_ID: req.body.equipmentID,
                        Equipment_Type: req.body.equipmentType,
                        Cubicle_Number: parseInt(req.body.cublicleNo),
                        Area_Name: req.body.area,
                        Cubicle_Name: req.body.cubicleName,
                        Standard_Weight_Block: req.body.standardWeight,
                        Negative_Tolerance: req.body.negativeTolerance,
                        Positive_Tolerance: req.body.positiveTolerance,
                        CalibrationBox_ID: weightboxVal,
                        CalibrationBox_Calibration_Date: calibDateVal,
                        CalibrationBox_Validity_Date: cbValidDateVal,
                        CalibrationBox_Calibration_CertificateNo: certificateVal,
                        CalibrationBox_Elements_IDNo: identificationNoVal,
                        CalibrationBox_Selected_Elements: weightsVal,
                        CalibrationBox_Elements_Unit: weightUnitVal ,
                        Repeat_Count: parseInt(req.body.repeatCount),
                        Percent_of_Capacity: parseInt(req.body.percentageOfCapacity),
                        Decimal_Point: parseInt(req.body.decimalPoint)
                    },{
                        transaction: t
                    });
                } else if(strPrecalibration == "Repeatability"){
                    Objprecalibration = await models.tbl_precalibration_repeatability.create({
                            UID: req.body.UID,
                            Equipment_ID: req.body.equipmentID,
                            Equipment_Type: req.body.equipmentType,
                            Cubicle_Number: parseInt(req.body.cublicleNo),
                            Area_Name: req.body.area,
                            Cubicle_Name: req.body.cubicleName,
                            Standard_Weight_Block: req.body.standardWeight,
                            Negative_Tolerance: req.body.negativeTolerance,
                            Positive_Tolerance: req.body.positiveTolerance,
                            CalibrationBox_ID: weightboxVal,
                            CalibrationBox_Calibration_Date: calibDateVal,
                            CalibrationBox_Validity_Date: cbValidDateVal,
                            CalibrationBox_Calibration_CertificateNo: certificateVal,
                            CalibrationBox_Elements_IDNo: identificationNoVal,
                            CalibrationBox_Selected_Elements: weightsVal,
                            CalibrationBox_Elements_Unit: weightUnitVal ,
                            Repeat_Count: parseInt(req.body.repeatCount),
                            Percent_of_Capacity: parseInt(req.body.percentageOfCapacity),
                            Decimal_Point: parseInt(req.body.decimalPoint)
                    },{
                        transaction: t
                    });
                } else if(["Sensitivity","Uncertainity"].includes(strPrecalibration)){
                    Objprecalibration = await models.tbl_precalibration_uncertainty.create({
                        UID: req.body.UID,
                        Equipment_ID: req.body.equipmentID,
                        Equipment_Type: req.body.equipmentType,
                        Cubicle_Number: parseInt(req.body.cublicleNo),
                        Area_Name: req.body.area,
                        Cubicle_Name: req.body.cubicleName,
                        Standard_Weight_Block: req.body.standardWeight,
                        Negative_Tolerance: req.body.negativeTolerance,
                        Positive_Tolerance: req.body.positiveTolerance,
                        CalibrationBox_ID: weightboxVal,
                        CalibrationBox_Calibration_Date: calibDateVal,
                        CalibrationBox_Validity_Date: cbValidDateVal,
                        CalibrationBox_Calibration_CertificateNo: certificateVal,
                        CalibrationBox_Elements_IDNo: identificationNoVal,
                        CalibrationBox_Selected_Elements: weightsVal,
                        CalibrationBox_Elements_Unit: weightUnitVal ,
                        Repeat_Count: parseInt(req.body.repeatCount),
                        Percent_of_Capacity: parseInt(req.body.percentageOfCapacity),
                        Decimal_Point: parseInt(req.body.decimalPoint)
                    },{
                        transaction: t
                    });
                }
                
               await models.tbl_audit_precalibration.create({
                DT: date.format(now, 'YYYY-MM-DD'),
                TM: date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                userid: req.body.userId,
                username: req.body.userName,
                ACT: req.body.act,
                Cubicle_Number: parseInt(req.body.cublicleNo),
                Area_Name: req.body.area,
                Cubicle_Name: req.body.cubicleName,
                Equipment_Type: req.body.equipmentType,
                Calibration_Type: req.body.calibrationType,
                Equipment_ID: req.body.equipmentID,
                Standard_Weight_Block: req.body.standardWeight,
                CalibrationBox_ID: weightboxVal,
                CalibrationBox_Elements_IDNo: identificationNoVal,
                CalibrationBox_Selected_Elements: weightsVal,
                CalibrationBox_Elements_Unit: weightUnitVal
                },{
                    transaction: t
                });
            });
           
            Object.assign(responseObj, { status: 'success' }, { result: strPrecalibration+ ' Added Successfully' })
            return responseObj;  
        }catch(error){
            return error;
        }
    }

  async getPrecalibrationRecord(req)
    {
        try{
            let responseObj = {};
            var strPrecalibration = req.body.calibrationType;
            var objPrecalibrationData;
            if(strPrecalibration == "Daily"){
                objPrecalibrationData = await models.tbl_precalibration_daily.findAll({
                    where:{
                        Equipment_ID:{[Op.eq]:req.body.equipmentId},
                        Equipment_Type:{[Op.eq]:req.body.equiType}
                    },
                });
            } else if([ "Accuracy","Periodic"].includes(strPrecalibration)){
                objPrecalibrationData = await models.tbl_precalibration_periodic.findAll({
                    where:{
                        Equipment_ID:{[Op.eq]:req.body.equipmentId},
                        Equipment_Type:{[Op.eq]:req.body.equiType}
                    },
                });
            } else if(strPrecalibration == "Eccentricity"){
                objPrecalibrationData = await models.tbl_precalibration_eccentricity.findAll({
                    where:{
                        Equipment_ID:{[Op.eq]:req.body.equipmentId},
                        Equipment_Type:{[Op.eq]:req.body.equiType}
                    },
                });
            } else if(strPrecalibration == "Linearity" || strPrecalibration == "Positional"){
                objPrecalibrationData = await models.tbl_precalibration_linearity.findAll({
                    where:{
                        Equipment_ID:{[Op.eq]:req.body.equipmentId},
                        Equipment_Type:{[Op.eq]:req.body.equiType}
                    },
                });
            } else if(strPrecalibration == "Repeatability"){
                objPrecalibrationData = await models.tbl_precalibration_repeatability.findAll({
                    where:{
                        Equipment_ID:{[Op.eq]:req.body.equipmentId},
                        Equipment_Type:{[Op.eq]:req.body.equiType}
                    },
                });
            } else if(["Sensitivity","Uncertainity"].includes(strPrecalibration)){
                objPrecalibrationData = await models.tbl_precalibration_uncertainty.findAll({
                    where:{
                        Equipment_ID:{[Op.eq]:req.body.equipmentId},
                        Equipment_Type:{[Op.eq]:req.body.equiType}
                    },
                });
            } 
            var result = objPrecalibrationData;
            Object.assign(responseObj, { status: 'success' }, { result: result });
            return responseObj;
            
        }catch(error){
            return error;
        }
    }

  async  handledWeighmentData(obj){
        try{
            let responseObj = {};
            var now = new Date();
            var strPrecalibration = obj.calibrationType;
            var transactionRes = await seqTransaction.sequelize.transaction( async (t) => {
                if(strPrecalibration == "Daily"){
                    await models.tbl_precalibration_daily.destroy({
                        where: {
                            UID: obj.UID ,
                            Equipment_ID: obj.Equipment_ID ,
                            Standard_Weight_Block: obj.Standard_Weight_Block ,
                        },
                        transaction: t
                    });
                } else if([ "Accuracy","Periodic"].includes(strPrecalibration)){
                    await models.tbl_precalibration_periodic.destroy({
                        where: {
                            UID: obj.UID ,
                            Equipment_ID: obj.Equipment_ID ,
                            Standard_Weight_Block: obj.Standard_Weight_Block ,
                        },
                        transaction:t
                    });
                } else if(strPrecalibration == "Eccentricity"){
                   await models.tbl_precalibration_eccentricity.destroy({
                    where: {
                        UID: obj.UID ,
                        Equipment_ID: obj.Equipment_ID ,
                        Standard_Weight_Block: obj.Standard_Weight_Block ,
                    },
                    transaction:t
                });
                } else if(strPrecalibration == "Linearity"){
                    await models.tbl_precalibration_linearity.destroy({
                        where: {
                            UID: obj.UID ,
                            Equipment_ID: obj.Equipment_ID ,
                            Standard_Weight_Block: obj.Standard_Weight_Block ,
                        },
                        transaction:t
                    });
                } else if(strPrecalibration == "Repeatability"){
                    await models.tbl_precalibration_repeatability.destroy({
                        where: {
                            UID: obj.UID ,
                            Equipment_ID: obj.Equipment_ID ,
                            Standard_Weight_Block: obj.Standard_Weight_Block ,
                        },
                        transaction:t
                    });
                } else if(["Sensitivity","Uncertainity"].includes(strPrecalibration)){
                    await models.tbl_precalibration_uncertainty.destroy({
                        where: {
                            UID: obj.UID ,
                            Equipment_ID: obj.Equipment_ID ,
                            Standard_Weight_Block: obj.Standard_Weight_Block ,
                        },
                        transaction:t
                    });
                }

                if(obj.Equipment_Type === 'Balance'){ 
                    await models.tbl_balance.update({
                        Bal_ChangeWt: 1
                    },{
                        where: { Bal_ID: obj.Equipment_ID },
                        transaction:t
                    });
                }
                    
               await models.tbl_audit_precalibration.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                    userid: obj.userId,
                    username: obj.userName,
                    ACT: obj.act ,
                    Cubicle_Number: parseInt(obj.Cubicle_Number),
                    Area_Name: obj.Area_Name,
                    Cubicle_Name: obj.Cubicle_Name,
                    Equipment_Type: obj.Equipment_Type,
                    Calibration_Type: obj.calibrationType,
                    Equipment_ID: obj.Equipment_ID,
                    Standard_Weight_Block: obj.Standard_Weight_Block,
                    CalibrationBox_ID: obj.CalibrationBox_ID,
                    CalibrationBox_Elements_IDNo: obj.CalibrationBox_Elements_IDNo,
                    CalibrationBox_Selected_Elements: obj.CalibrationBox_Selected_Elements,
                    CalibrationBox_Elements_Unit: obj.CalibrationBox_Elements_Unit
                },{
                    transaction:t
                });

                return 'success';
            });
            
             
             Object.assign(responseObj, { status: 'success' }, { result: 'Data Remove Successfully' });
             return responseObj;
            
        }catch(error){
            console.log(error);
            throw error;
        }
    }

    async getBalID(req)
    {
        try{
            var responseObj = {};
            var objPrecalibrationData = await models.tbl_calibration_status.findAll({
                attributes:[[sequelize.fn('DISTINCT', sequelize.col('BalID')),'BalID']],
                where:{
                    Sys_Area:{[Op.eq]:req.body.area},
                    Sys_CubicName:{[Op.eq]:req.body.cubicleName}
                },
            });
            var result = objPrecalibrationData;
            Object.assign(responseObj, { status: 'success' }, { result: result });
            return responseObj;
            
        }catch(error){
            return error;
        }
    }

}

module.exports = PrecalibrationModel;