const models = require('./../dbConnection').models;
const sequelize = require('./../dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
const date = require('date-and-time')


class DeptModel {
    
    async getDepatments() {
        try{
           const obj_Department = await models.tbl_department.findAll();
           return obj_Department;
        }catch(error){
            return error;
        }
    }

    async getDepartmentsForAuditTrail() {
        try {
            var sarr_oldValue = [],sarr_newValue = [],sarr_finalValue = [];

            // const obj_getOldValue = {
            //     str_tableName: 'tbl_audit_department',
            //     data: 'distinct OldValue as value',
            //     condition:[
            //         { str_colName: 'OldValue', value: 'NULL', comp:'ne' },
            //     ]
            // }
            // let resultOld = await database.select(obj_getOldValue); 
            const obj_getOldValue = await models.tbl_audit_department.findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('OldValue')) ,'value'],
                ],
                where:{
                   OldValue:{[Op.ne]:'NULL'}
                }
            });
            let resultOld = obj_getOldValue; 
            // const obj_getNewValue = {
            //     str_tableName: 'tbl_audit_department',
            //     data: 'distinct NewValue as value',
            //     condition:[
            //         { str_colName: 'NewValue', value: 'NULL', comp:'ne' },
            //     ]
            // }
            // let resultNew = await database.select(obj_getNewValue); 
            const obj_getNewValue = await models.tbl_audit_department.findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('NewValue')) ,'value'],
                ],
                where:{
                   // OldValue:value.selectedUserID
                   NewValue:{[Op.ne]:'NULL'}
                }
            });
            let resultNew = obj_getNewValue; 
            if(resultOld[0] != undefined)
            {
                for(let i=0;i<=resultOld[0].length-1;i++)
                {
                    sarr_oldValue.push(resultOld[0][i]);
                }
            }
            if(resultNew[0] != undefined)
            {
                for(let i=0;i<=resultNew[0].length-1;i++)
                {
                    sarr_newValue.push(resultNew[0][i]);
                }
            }

            if(sarr_oldValue.length > 0 && sarr_newValue.length > 0)
            {
                sarr_finalValue = sarr_oldValue.concat(sarr_newValue);
            }
            else if(sarr_oldValue.length > 0)
            {
                sarr_finalValue = sarr_oldValue;
            }
            else if(sarr_newValue.length > 0)
            {
                sarr_finalValue = sarr_newValue;
            }
            else
            {
                sarr_finalValue = [];
            }

            return sarr_finalValue; 
        } catch (error) {
            return error; 
        }
    }

 async storeDepartment(value) {    
    try{
        var responseObj = {};
        var now = new Date();
        
        var obj_Department = await models.tbl_department.findAll({
            where: {
                department_name: value.department
            }
        });
            
        var result = obj_Department;
            if(result.length != 0){
                Object.assign(responseObj, { status: 'success' }, { result: 'Department Already Exist' })
                return responseObj;
            }else{
       
            const obj_InsertBalance = await models.tbl_department.create({
                department_name : value.department,
                locked : 0,
            });
               
            const obj_InsertAuditDepartment = await models.tbl_audit_department.create({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                UserId:value.loggedUserId,
                UserName:value.loggedUserName,
                Act:value.action,
                NewValue:value.department,
                Remark:value.remark

            });
               
            const obj_InsertDepartmentActivity = await models.tbl_activity_log.create({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                userid:value.loggedUserId,
                username:value.loggedUserName,
                activity:'Department Added'
            });
            Object.assign(responseObj, { status: 'success' }, { result: 'Department Added Successfully' })
            return responseObj;
            }
        
    }catch(error){
        return error;
    }
}

   async updateDepartment(value) {
        try{
            var responseObj = {};
            var now = new Date();
            
            var obj_Department = await models.tbl_department.findAll({
                where: {
                    department_id: value.deptId
                }
            }); 
            var result = obj_Department;
            var data = {};
            data = result[0];
            var oldDepartment = data.department_name;
            
           await models.tbl_department.update({
                department_name : value.deptName,
                locked : 0},
            {
                where: {department_id:value.deptId}
            });
            
            await models.tbl_audit_department.create({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                UserId:value.loggeduserid,
                UserName:value.loggedusername,
                Act:value.action,
                OldValue: oldDepartment,
                NewValue:value.deptName,
                Remark:value.remark

            });
            
            await models.tbl_activity_log.create({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                userid:value.loggeduserid,
                username:value.loggedusername,
                activity:'Department Updated'
            });
            Object.assign(responseObj, { status: 'success' }, { result: 'Department Updated Successfully' })
            return responseObj;
        
    }catch(error){
        return error; 
    }
}

async updateDeptLockStatus(value){
    try{
        var responseObj = {};
        var lock = parseInt(value.lock_status);
        
        var Obj_updateDepartmentLockValue;
        if(lock == 1){
            var obj_Department = await models.tbl_department.findAll({
                where: {
                    department_id: value.deptId
                }
            }); 
            var result = obj_Department;
            var data = {};
            data = result[0];
            var deptlock = data.locked;
            var deptlockstatus = deptlock;
            if (deptlockstatus == 1) {
                Object.assign(responseObj, { status: 'success' }, { result: 'Already in use by other user' });
                return responseObj;
            }else{
                    
                    Obj_updateDepartmentLockValue = await models.tbl_department.update({
                        locked : lock
                    },
                    {
                        where: {department_id:value.deptId}
                    });
                    Object.assign(responseObj, { status: 'success' }, { result: 'lock value update' });
                    return responseObj;
            }
              
        } else{
            
            Obj_updateDepartmentLockValue = await models.tbl_department.update({
                locked : lock
            },
            {
                where: {department_id:value.deptId}
            });
            Object.assign(responseObj, { status: 'success' }, { result: 'lock value deleted' })
            return responseObj;
        }
        
    }catch(error){
        return error;
    }
}

async assignedToCubicleManageUSer(req)
    {
        try{
            var  objResponse = {};
            var sarr_dept = [];
            var cnt = 0;

            for(let i=0;i<=req.length-1;i++)
            {
                const obj_assignToCubicle  = await models.tbl_cubical.findAndCountAll({
                    where:                 
                    {   Sys_dept: req[i].department_name}
                  });
                  var resCubic = obj_assignToCubicle;

                const obj_assignToUser  = await models.tbl_users.findAndCountAll({
                    where:                 
                    {   Department: req[i].department_name}
                  });
                  var resUser = obj_assignToUser;


                if(resCubic.count > 0)
                {
                    sarr_dept.push(req[i].department_name);
                    cnt = cnt + 1; 
                }
                if(resUser.count > 0)
                {
                    sarr_dept.push(req[i].department_name);
                    cnt = cnt + 1; 
                }
            }
            return Object.assign(objResponse,{sarr_dept:sarr_dept});
        }catch(error){
            console.log(error);
            return error;
        }
}

async getDepartmentsAudit() {
    try{

        let result = await models.tbl_audit_department.findAll({
            attributes:[[sequelize.fn('DISTINCT',sequelize.col('NewValue')),'value']]
        });
       return result;
    }catch(error){
        console.log(error);
        throw error;
    }
}
}
module.exports = DeptModel;