var config = require('../global/serverConfig');
// var mssql = require('mssql');
const models = require('./../dbConnection').models;
const sequelize = require('./../dbConnection').sequelize;
const { QueryTypes } = require('sequelize');

// var connection = mssql.createConnection({
//     host: config.dbHost,    
//     user: config.dbUser,
//     password: config.dbPass,
//     database: config.dbName,
//     multipleStatements: true
// });

class StoredProcedure {

    getIndividual(RepSerNo, value, intProductType = 1) {
        return new Promise((resolve, reject) => {
            var masterTable, detailTable;
            var int_paramNo;
            if (intProductType == 1) {
                (value.reportOption == "Individual") ? int_paramNo = 1 :
            (value.reportOption == "Individual Layer1") ? int_paramNo = 9 : 
            (value.reportOption == "Individual Empty") ? int_paramNo = 9 : int_paramNo = 11;
            }
            else // capsule
            {
                int_paramNo = 1;
            }
            
            
            if (intProductType == 1) {
                if (value.reportType == 'Complete') {
                    if (value.recordFrom == 'Current') {
                        masterTable = 'tbl_tab_master' + int_paramNo;
                        detailTable = 'tbl_tab_detail' + int_paramNo;
                    }
                    else {
                        masterTable = 'tbl_tab_master' + int_paramNo + '_archived';
                        detailTable = 'tbl_tab_detail' + int_paramNo + '_archived'
                    }
                }
                else {
                    masterTable = 'tbl_tab_master' + int_paramNo + '_incomplete';
                    detailTable = 'tbl_tab_detail' + int_paramNo + '_incomplete'
                }
            }
            else {
                if (value.reportType == 'Complete') {
                    if (value.recordFrom == 'Current') { //current Complete
                        masterTable = 'tbl_cap_master' + int_paramNo;
                        detailTable = 'tbl_cap_detail' + int_paramNo;
                    } else {  //archive Complete
                        masterTable = 'tbl_cap_master' + int_paramNo + '_archived';
                        detailTable = 'tbl_cap_detail' + int_paramNo + '_archived'
                    }
                } else {
                    if (value.recordFrom == 'Current') { // current Incomplete
                        masterTable = 'tbl_cap_master' + int_paramNo + '_incomplete';
                        detailTable = 'tbl_cap_detail' + int_paramNo + '_incomplete'
                    }
                }
            }

            let strquery = "CALL calculateMinMaxPercentage(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "'," +
                "@nominal,@minWeight,@maxWeight,@minPercentage,@maxPercentage,@average,@standardDeviation," +
                "@rptHeading,@T1Neg,@T1Pos,@T2Neg,@T2Pos,@limiton,@graphType,@nmtTab,@labelT1,@labelT2,@valueT1," +
                "@valueT2,@reportRemark,@RecSeqNo); SELECT @nominal,@minWeight,@maxWeight,@minPercentage,@maxPercentage,@average," +
                "@standardDeviation,@rptHeading,@T1Neg,@T1Pos,@T2Neg,@T2Pos,@limiton,@graphType,@nmtTab,@labelT1,@labelT2," +
                "@valueT1,@valueT2,@reportRemark,@RecSeqNo;";
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });

            //connection.end();

        })
    }

    getCalculationForHTDSunVapi(RepSerNo, value) {
        return new Promise((resolve, reject) => {
            var masterTable, detailTable;
            var selectedParameter = value.reportOption;
            if (selectedParameter == "Hardness") {
                if (value.reportType == 'Complete') {
                    if (value.recordFrom == 'Current') { //current Complete
                        masterTable = 'tbl_tab_master7';
                        detailTable = 'tbl_tab_detail7'
                    } else {  //archive Complete
                        masterTable = 'tbl_tab_master7_archived';
                        detailTable = 'tbl_tab_detail7_archived'
                    }
                } else {
                    if (value.recordFrom == 'Current') { // current Incomplete
                        masterTable = 'tbl_tab_master7_incomplete';
                        detailTable = 'tbl_tab_detail7_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
            }

            connection.connect();
            let strquery = "CALL calculateMinMaxPercentageSunVapi(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "'"
                + ",@nominal, @minWeight,@maxWeight, @average,@lowT1,@uppT1,@AbvLmt1NoSide, @BlwLmt1NoSide,@CalStandDev,@result)"
                + ";SELECT @nominal, @minWeight,@maxWeight, @average,@lowT1,@uppT1,@AbvLmt1NoSide, @BlwLmt1NoSide,@CalStandDev,@result;";
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });

            //connection.end();

        })
    }


    getCalculationForHTD(RepSerNo, value) {
        return new Promise((resolve, reject) => {
            var masterTable, detailTable;
            var selectedParameter = value.reportOption;
            if (selectedParameter == "Hardness") {
                if (value.reportType == 'Complete') {
                    if (value.recordFrom == 'Current') { //current Complete
                        masterTable = 'tbl_tab_masterhtd';
                        detailTable = 'tbl_tab_detailhtd'
                    } else {  //archive Complete
                        masterTable = 'tbl_tab_masterhtd_archived';
                        detailTable = 'tbl_tab_detailhtd_archived'
                    }
                } else {
                    if (value.recordFrom == 'Current') { // current Incomplete
                        masterTable = 'tbl_tab_masterhtd_incomplete';
                        detailTable = 'tbl_tab_detailhtd_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
            }
            else (selectedParameter == "Tablet Tester")
            {
                if (value.reportType == 'Complete') {
                    if (value.recordFrom == 'Current') { //current Complete
                        masterTable = 'tbl_tab_masterhtd';
                        detailTable = 'tbl_tab_detailhtd'
                    } else {  //archive Complete
                        masterTable = 'tbl_tab_masterhtd_archived';
                        detailTable = 'tbl_tab_detailhtd_archived'
                    }
                } else {
                    if (value.recordFrom == 'Current') { // current Incomplete
                        masterTable = 'tbl_tab_masterhtd_incomplete';
                        detailTable = 'tbl_tab_detailhtd_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
            }

            connection.connect();
            let strquery = "CALL tabletTesterReportCalculation('" + masterTable + "','" + detailTable + "'," + RepSerNo
                + ",@HardnessNominalN,@HardnessPosN,@HardnessNegN,@HardnessAverageN,@HardnessStdDevN,@HardnessMinN,@HardnessMaxN"
                + ",@HardnessNominalKp,@HardnessPosKp,@HardnessNegKp,@HardnessAverageKp,@HardnessStdDevKp,@HardnessMinKp,@HardnessMaxKp"
                + ",@DOLOBONominal,@DOLOBOPos,@DOLOBONeg,@DOLOBOAverage,@DOLOBStdDev,@DOLOBOMin,@DOLOBOMax,@ThicknessNominal,@ThicknessPos"
                + ",@ThicknessNeg,@ThicknessAverage,@ThicknessStdDev,@ThicknessMin,@ThicknessMax,@Unit,@RecSeqNo,"
                +" @DiameterNominal,@DiameterPos,@DiameterNeg,@DiameterAverage,@DiameterStdDev,@DiameterMin,@DiameterMax); "
                + "SELECT @HardnessNominalN,@HardnessPosN,@HardnessNegN,@HardnessAverageN,@HardnessStdDevN,@HardnessMinN,@HardnessMaxN"
                + ",@HardnessNominalKp,@HardnessPosKp,@HardnessNegKp,@HardnessAverageKp,@HardnessStdDevKp,@HardnessMinKp,@HardnessMaxKp"
                + ",@DOLOBONominal,@DOLOBOPos,@DOLOBONeg,@DOLOBOAverage,@DOLOBStdDev,@DOLOBOMin,@DOLOBOMax,@ThicknessNominal,@ThicknessPos"
                +",@ThicknessNeg,@ThicknessAverage,@ThicknessStdDev,@ThicknessMin,@ThicknessMax,@Unit,@RecSeqNo,@DiameterNominal,"
                +"@DiameterPos,@DiameterNeg,@DiameterAverage,@DiameterStdDev,@DiameterMin,@DiameterMax;";
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });

            //connection.end();

        })
    }

    getCalulationForGroupVernier(RepSerNo, value, intProductType = 1,str_projectName) {
        return new Promise((resolve, reject) => {
            var masterTable, detailTable;
            var int_paramNo;

            (value.reportOption == "Group") ? int_paramNo = 2 : (value.reportOption == "Group Layer1") ? int_paramNo = 10 :
            (value.reportOption == "Group Layer2") ? int_paramNo = 12 : (value.reportOption == "Thickness") ? int_paramNo = 3 : (value.reportOption == "Hardness") ? int_paramNo = 7 : (value.reportOption == "Diameter" && intProductType == 2) ? int_paramNo = 4 :
                (value.reportOption == "Breadth" && intProductType == 1) ? int_paramNo = 4 : (value.reportOption == "Length" || value.reportOption == "Locked Length") ? int_paramNo = 5 : int_paramNo = 6; 
           
                if (value.reportType == 'Complete') {
                    if (value.recordFrom == 'Current') {
                        if(intProductType == 2)
                        {
                            masterTable = 'tbl_cap_master' + int_paramNo;
                            detailTable = 'tbl_cap_detail' + int_paramNo;
                        }
                        else
                        {
                            masterTable = 'tbl_tab_master' + int_paramNo;
                            detailTable = 'tbl_tab_detail' + int_paramNo;
                        }
                    }
                    else {
                        if(intProductType == 2)
                        {
                            masterTable = 'tbl_cap_master' + int_paramNo + '_archived';
                            detailTable = 'tbl_cap_detail' + int_paramNo + '_archived';
                        }
                        else
                        {
                            masterTable = 'tbl_tab_master' + int_paramNo + '_archived';
                            detailTable = 'tbl_tab_detail' + int_paramNo + '_archived';
                        }

                    }
                }
                else {
                    if(intProductType == 2)
                    {
                        masterTable = 'tbl_cap_master' + int_paramNo + '_incomplete';
                        detailTable = 'tbl_cap_detail' + int_paramNo + '_incomplete';
                    }
                    else
                    {
                        masterTable = 'tbl_tab_master' + int_paramNo + '_incomplete';
                        detailTable = 'tbl_tab_detail' + int_paramNo + '_incomplete';
                    }

                }
         
         

            connection.connect();
            let strquery = "";
            if ((value.reportOption == "Group") || (value.reportOption == "Group Layer1") || (value.reportOption == "Group Layer2")) {
                if(str_projectName == "SVP")
                {
                    strquery = "CALL reportCalculationGroupForSunVapi(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "',@Nom,@Low1,@Upp1,@Low2,@Upp2,@TolN1,@TolP1,@TolN2,@TolP2," +
                    "@Average,@Stdev,@Mininum,@Maximum,@limiton,@graphType,@RecSeqNo,@RecSeqNoR); SELECT @Nom,@Low1,@Upp1,@Low2,@Upp2,@TolN1,@TolP1,@TolN2,@TolP2,@Average,@Stdev,@Mininum,@Maximum,@limiton,@graphType,@RecSeqNo,@RecSeqNoR;";
                }
                else
                {
                    strquery = "CALL reportCalculationGroup(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "',@Nom,@Low,@Upp," +
                    "@Average,@Stdev,@Mininum,@Maximum,@limiton,@graphType,@strLimitText1,@strLimitText2,@RecSeqNo,@RecSeqNoR,@AverageWT); SELECT @Nom,@Low,@Upp,@Average,@Stdev,@Mininum,@Maximum,@limiton,@graphType,@strLimitText1,@strLimitText2,@RecSeqNo,@RecSeqNoR,@AverageWT;";
                }
               
            }
            else {
                strquery = "CALL reportCalculationVernier(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "',@Nom,@Low1,@Upp1,@Low2,@Upp2," +
                    "@Average,@Stdev,@Mininum,@Maximum,@MininumPer,@MaximumPer,@RecSeqNo,@NMT,@T1Pos); SELECT @Nom,@Low1,@Upp1,@Low2,@Upp2,@Average,@Stdev,@Mininum,@Maximum,@MininumPer,@MaximumPer,@RecSeqNo,@NMT,@T1Pos;";
            }

            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });

            //connection.end();

        })
    }
    getFriability(RepSerNo, value) {
        return new Promise((resolve, reject) => {
            var masterTable;
            if (value.reportType == 'Complete') {
                if (value.recordFrom == 'Current') { //current Complete
                    masterTable = 'tbl_tab_friability';

                } else {  //archive Complete
                    masterTable = 'tbl_tab_friability_archived';
                }
            }

            let strquery = "CALL reportCalculationFriability(" + RepSerNo + ",'" + masterTable + "'," +
                "@FriNMTLimit,@NWtBeforeTest,@NWtAfterTest,@LWtBeforeTest,@LWtAfterTest," +
                "@RWtBeforeTest,@RWtAfterTest,@FriabilityPercentageNA,@FriabilityPercentageRight,@FriabilityPercentageLeft,@remark,@DP);" +
                "SELECT @FriNMTLimit,@NWtBeforeTest,@NWtAfterTest,@LWtBeforeTest,@LWtAfterTest," +
                "@RWtBeforeTest,@RWtAfterTest,@FriabilityPercentageNA,@FriabilityPercentageRight,@FriabilityPercentageLeft,@remark,@DP;";
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });

            //connection.end();

        })
    }
  
    getTabDensity(RepSerNo, masterTableName) {
        return new Promise((resolve, reject) => {
            let strquery = "CALL reportCalculationTapDensity(" + RepSerNo + ",'" + masterTableName + "'," +
                "@stdNeg,@stdPos,@bulkNegLimit,@bulkPosLimit,@tapDensity,@bulkDensity,@remark);" +
                "SELECT @stdNeg,@stdPos,@bulkNegLimit,@bulkPosLimit,@tapDensity,@bulkDensity,@remark;";
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });

            //connection.end();

        })
    }

    getCalculationForNetMultihaler(insertVal, RepSerNo, ip, value,reportType){
        return new Promise((resolve,reject) =>{
            var masterTable, detailTable;
            if (reportType == 'Complete') {
                if (value.recordFrom == 'Current') { //current Complete
                    masterTable = 'tbl_cap_master7';
                    detailTable = 'tbl_cap_detail7';
                } else {  //archive Complete
                    masterTable = 'tbl_cap_master7_archived';
                    detailTable = 'tbl_cap_detail7_archived'
                }
            } else {
                if (value.recordFrom == 'Current') { // current Incomplete
                    masterTable = 'tbl_cap_master7_incomplete';
                    detailTable = 'tbl_cap_detail7_incomplete'
                } else {
                    // TO - DO for incomplete archive
                }
            }
            let strquery = "CALL reportCalculationForMultihalerNet(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "'," +
            "@nominal,@lowerLimitActual,@upperLimitActual,@lowerLimitPercentage,@upperLimitPercentage,@minWeight,@maxWeight," +
            "@minPercentage,@maxPercentage,@belowLimitCount,@aboveLimitCount,@average,@standardDeviation,@result);" +
            "SELECT @nominal,@lowerLimitActual,@upperLimitActual,@lowerLimitPercentage,@upperLimitPercentage,@minWeight," +
            "@maxWeight,@minPercentage,@maxPercentage,@belowLimitCount,@aboveLimitCount,@average,@standardDeviation,@result;";
            connection.query(strquery, function (err, rows, fields) {
                    if (err) {
                        console.log(err);
                    }
                    resolve(rows);
            });
            })
    }

 getCalculationForGrpMultihaler(insertVal, RepSerNo, ip, value,reportType){
    return new Promise((resolve,reject) =>{
        var masterTable,detailTable;
        if (value.reportType == 'Complete') {
            if (value.recordFrom == 'Current') { //current Complete
                masterTable = 'tbl_cap_master8';
                detailTable = 'tbl_cap_detail8'
            } else {  //archive Complete
                masterTable = 'tbl_cap_master8_archived';
                detailTable = 'tbl_cap_detail8_archived'
            }
        }
            let strquery = "CALL reportCalculationForMultihalerGroup(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "'," +
                "@nominal, @lowerLimitActual, @upperLimitActual, @lowerLimitPercentage, @upperLimitPercentage,@minWeight,@maxWeight,@minPercentage,@maxPercentage, @belowLimitCount, @aboveLimitCount,@average,@standardDeviation,@result);"+
                "SELECT @nominal, @lowerLimitActual, @upperLimitActual, @lowerLimitPercentage, @upperLimitPercentage,@minWeight,@maxWeight,@minPercentage,@maxPercentage, @belowLimitCount, @aboveLimitCount,@average,@standardDeviation,@result;";
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });
        })
    }

    getCalculationMultiComponent(RepSerNo,value)
    {
        return new Promise((resolve, reject) => {
            var masterTable,detailTable;
            if (value.reportType == 'Complete') {
                if (value.recordFrom == 'Current') { //current Complete
                    masterTable = 'tbl_cap_master3';
                    detailTable = 'tbl_cap_detail3';
                } else {  //archive Complete
                    masterTable = 'tbl_cap_master3_archived';
                    detailTable = 'tbl_cap_detail3_archived';
                }
            } else {
                if (value.recordFrom == 'Current') { // current Incomplete
                    masterTable = 'tbl_cap_master3_incomplete';
                    detailTable = 'tbl_cap_detail3_incomplete';
                }
            }

            let strquery = "CALL reportCalculationForDifferentialContents(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "',@nomFilledCont,@stdLmt1TxtFilledCont,@stdLmt2TxtFilledCont,@lowT1FilledCont,@uppT1FilledCont,@lowT2FilledCont, @uppT2FilledCont, @AverageValueFilledCont, @minWeightFilledCont, @maxWeightFilledCont, @minPercentageFilledCont, @maxPercentageFilledCont, @CalStandDevFilledCont, @AbvLmt1NoSideFilledCont, @BlwLmt1NoSideFilledCont, @AbvLmt2NoSideFilledCont, @BlwLmt2NoSideFilledCont, @nomTab1, @stdLmt1TxtTab1, @stdLmt2TxtTab1, @lowT1Tab1, @uppT1Tab1, @lowT2Tab1, @uppT2Tab1, @AverageValueTab1, @minWeightTab1, @maxWeightTab1, @minPercentageTab1, @maxPercentageTab1, @CalStandDevTab1, @AbvLmt1NoSideTab1, @BlwLmt1NoSideTab1, @AbvLmt2NoSideTab1, @BlwLmt2NoSideTab1, @nomTab2, @stdLmt1TxtTab2, @stdLmt2TxtTab2, @lowT1Tab2, @uppT1Tab2, @lowT2Tab2, @uppT2Tab2, @AverageValueTab2, @minWeightTab2, @maxWeightTab2, @minPercentageTab2, @maxPercentageTab2, @CalStandDevTab2, @AbvLmt1NoSideTab2, @BlwLmt1NoSideTab2, @AbvLmt2NoSideTab2, @BlwLmt2NoSideTab2, @nomTab3, @stdLmt1TxtTab3, @stdLmt2TxtTab3, @lowT1Tab3, @uppT1Tab3, @lowT2Tab3, @uppT2Tab3, @AverageValueTab3, @minWeightTab3, @maxWeightTab3, @minPercentageTab3, @maxPercentageTab3, @CalStandDevTab3, @AbvLmt1NoSideTab3, @BlwLmt1NoSideTab3, @AbvLmt2NoSideTab3, @BlwLmt2NoSideTab3, @nomTab4, @stdLmt1TxtTab4, @stdLmt2TxtTab4, @lowT1Tab4, @uppT1Tab4, @lowT2Tab4, @uppT2Tab4, @AverageValueTab4, @minWeightTab4, @maxWeightTab4, @minPercentageTab4, @maxPercentageTab4, @CalStandDevTab4, @AbvLmt1NoSideTab4, @BlwLmt1NoSideTab4, @AbvLmt2NoSideTab4, @BlwLmt2NoSideTab4, @ICReport, @Result); SELECT @nomFilledCont, @stdLmt1TxtFilledCont, @stdLmt2TxtFilledCont, @lowT1FilledCont, @uppT1FilledCont, @lowT2FilledCont, @uppT2FilledCont, @AverageValueFilledCont, @minWeightFilledCont, @maxWeightFilledCont, @minPercentageFilledCont, @maxPercentageFilledCont, @CalStandDevFilledCont, @AbvLmt1NoSideFilledCont, @BlwLmt1NoSideFilledCont, @AbvLmt2NoSideFilledCont, @BlwLmt2NoSideFilledCont, @nomTab1, @stdLmt1TxtTab1, @stdLmt2TxtTab1, @lowT1Tab1, @uppT1Tab1, @lowT2Tab1, @uppT2Tab1, @AverageValueTab1, @minWeightTab1, @maxWeightTab1, @minPercentageTab1, @maxPercentageTab1, @CalStandDevTab1, @AbvLmt1NoSideTab1, @BlwLmt1NoSideTab1, @AbvLmt2NoSideTab1, @BlwLmt2NoSideTab1, @nomTab2, @stdLmt1TxtTab2, @stdLmt2TxtTab2, @lowT1Tab2, @uppT1Tab2, @lowT2Tab2, @uppT2Tab2, @AverageValueTab2, @minWeightTab2, @maxWeightTab2, @minPercentageTab2, @maxPercentageTab2, @CalStandDevTab2, @AbvLmt1NoSideTab2, @BlwLmt1NoSideTab2, @AbvLmt2NoSideTab2, @BlwLmt2NoSideTab2, @nomTab3, @stdLmt1TxtTab3, @stdLmt2TxtTab3, @lowT1Tab3, @uppT1Tab3, @lowT2Tab3, @uppT2Tab3, @AverageValueTab3, @minWeightTab3, @maxWeightTab3, @minPercentageTab3, @maxPercentageTab3, @CalStandDevTab3, @AbvLmt1NoSideTab3, @BlwLmt1NoSideTab3, @AbvLmt2NoSideTab3, @BlwLmt2NoSideTab3, @nomTab4, @stdLmt1TxtTab4, @stdLmt2TxtTab4, @lowT1Tab4, @uppT1Tab4, @lowT2Tab4, @uppT2Tab4, @AverageValueTab4, @minWeightTab4, @maxWeightTab4, @minPercentageTab4, @maxPercentageTab4, @CalStandDevTab4, @AbvLmt1NoSideTab4, @BlwLmt1NoSideTab4, @AbvLmt2NoSideTab4, @BlwLmt2NoSideTab4, @ICReport, @Result;";
           
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                resolve(rows);
           });
        });
    }
  


getCalculationDiff(RepSerNo,value){
        return new Promise((resolve, reject) => {
            var masterTable,detailTable;
            if (value.reportType == 'Complete') {
                if (value.recordFrom == 'Current') { //current Complete
                    masterTable = 'tbl_cap_master3';
                    detailTable = 'tbl_cap_detail3';
                } else {  //archive Complete
                    masterTable = 'tbl_cap_master3_archived';
                    detailTable = 'tbl_cap_detail3_archived';
                }
            } else {
                if (value.recordFrom == 'Current') { // current Incomplete
                    masterTable = 'tbl_cap_master3_incomplete';
                    detailTable = 'tbl_cap_detail3_incomplete';
                }
            }
            let strquery = "CALL reportCalculationDifferential(" + RepSerNo + ",'" + masterTable + "','" + detailTable + "'," +
            "@nominal,@minWeight,@maxWeight,@minPercentage,@maxPercentage,@average,@T1Neg,@T1Pos,@T2Neg,@T2Pos,@belowLimitT2Count,@aboveLimitT2Count,"+
            "@belowLimitT1Count , @aboveLimitT1Count,@labelT2,@labelT1,"+
            "@Stdev,@result);SELECT @nominal,@minWeight,@maxWeight,@minPercentage ,@maxPercentage,@average,@T1Neg,@T1Pos,@T2Neg,@T2Pos,"+
            "@belowLimitT2Count ,@aboveLimitT2Count,@belowLimitT1Count,@aboveLimitT1Count,@labelT2,"+
            "@labelT1,@Stdev,@result;";
           
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                resolve(rows);
           });
        });
       }

getCalculationDiffRegular(RepSerNo, masterTableName, detailTableName,insertVal){
    return new Promise((resolve,reject) => {
        let strquery = "CALL reportCalculationForDifferentialMVL(" + RepSerNo + ",'"+ insertVal[0].BFGCode +"','"+ insertVal[0].ProductName 
        +"','"+ insertVal[0].PVersion +"','"+ insertVal[0].Version +"','"+ insertVal[0].BatchNo +"','"+ insertVal[0].CubicleType +"','"+ insertVal[0].RepoLabel14 +"','" 
        + masterTableName + "','" + detailTableName + "'," +
        "@nom,@lowT2,@uppT2,@averageValue,@minWeight,@maxWeight,@wtOf20TabWgtofFilledCap1,@wtOf20TabWgtofFilledCap2,@wtOf20TabWgtofFilledCap3,@wtOf20TabWgtofEmptyCap1,@wtOf20TabWgtofEmptyCap2,@wtOf20TabWgtofEmptyCap3,"+
        "@wtOf20TabWgtofNetWgt1,@wtOf20TabWgtofNetWgt2,@wtOf20TabWgtofNetWgt3,@minWtofFilledCap1,@minWtofFilledCap2,@minWtofFilledCap3,@minWtofEmptyCap1,@minWtofEmptyCap2,@minWtofEmptyCap3,@minWtofNetWgt1,@minWtofNetWgt2,"+
        "@minWtofNetWgt3,@maxWtofFilledCap1,@maxWtofFilledCap2,@maxWtofFilledCap3,@maxWtofEmptyCap1,@maxWtofEmptyCap2,@maxWtofEmptyCap3,@maxWtofNetWgt1,@maxWtofNetWgt2,@maxWtofNetWgt3,@avgWtofFilledCap1,@avgWtofFilledCap2,@avgWtofFilledCap3,"+
        "@avgWtofEmptyCap1,@avgWtofEmptyCap2,@avgWtofEmptyCap3,@avgWtofNetWgt1,@avgWtofNetWgt2,@avgWtofNetWgt3,@stdDevofFilledCap1,@stdDevofFilledCap2,@stdDevofFilledCap3,@stdDevWtofEmptyCap1,@stdDevWtofEmptyCap2,@stdDevWtofEmptyCap3,"+
        "@stdDevWtofNetWgt1,@stdDevWtofNetWgt2,@stdDevWtofNetWgt3,@minPerWgtofFilledCap1,@minPerWgtofFilledCap2,@minPerWgtofFilledCap3,@minPerWgtofEmptyCap1,@minPerWgtofEmptyCap2,@minPerWgtofEmptyCap3,@minPerWgtofNetWgt1,@minPerWgtofNetWgt2,@minPerWgtofNetWgt3,"+
        "@maxPerWgtofFilledCap1,@maxPerWgtofFilledCap2,@maxPerWgtofFilledCap3,@maxPerWgtofEmptyCap1,@maxPerWgtofEmptyCap2,@maxPerWgtofEmptyCap3,@maxPerWgtofNetWgt1,@maxPerWgtofNetWgt2,@maxPerWgtofNetWgt3,@remark1,@remark2,@remark3,"+
        "@RecSeqNo,@result,@Run_Time_Erros);SELECT @nom,@lowT2,@uppT2,@averageValue,@minWeight,@maxWeight,@wtOf20TabWgtofFilledCap1,@wtOf20TabWgtofFilledCap2,@wtOf20TabWgtofFilledCap3,@wtOf20TabWgtofEmptyCap1,@wtOf20TabWgtofEmptyCap2,@wtOf20TabWgtofEmptyCap3,"+
        "@wtOf20TabWgtofNetWgt1,@wtOf20TabWgtofNetWgt2,@wtOf20TabWgtofNetWgt3,@minWtofFilledCap1,@minWtofFilledCap2,@minWtofFilledCap3,@minWtofEmptyCap1,@minWtofEmptyCap2,@minWtofEmptyCap3,@minWtofNetWgt1,@minWtofNetWgt2,"+
        "@minWtofNetWgt3,@maxWtofFilledCap1,@maxWtofFilledCap2,@maxWtofFilledCap3,@maxWtofEmptyCap1,@maxWtofEmptyCap2,@maxWtofEmptyCap3,@maxWtofNetWgt1,@maxWtofNetWgt2,@maxWtofNetWgt3,@avgWtofFilledCap1,@avgWtofFilledCap2,@avgWtofFilledCap3,"+
        "@avgWtofEmptyCap1,@avgWtofEmptyCap2,@avgWtofEmptyCap3,@avgWtofNetWgt1,@avgWtofNetWgt2,@avgWtofNetWgt3,@stdDevofFilledCap1,@stdDevofFilledCap2,@stdDevofFilledCap3,@stdDevWtofEmptyCap1,@stdDevWtofEmptyCap2,@stdDevWtofEmptyCap3,"+
        "@stdDevWtofNetWgt1,@stdDevWtofNetWgt2,@stdDevWtofNetWgt3,@minPerWgtofFilledCap1,@minPerWgtofFilledCap2,@minPerWgtofFilledCap3,@minPerWgtofEmptyCap1,@minPerWgtofEmptyCap2,@minPerWgtofEmptyCap3,@minPerWgtofNetWgt1,@minPerWgtofNetWgt2,@minPerWgtofNetWgt3,"+
        "@maxPerWgtofFilledCap1,@maxPerWgtofFilledCap2,@maxPerWgtofFilledCap3,@maxPerWgtofEmptyCap1,@maxPerWgtofEmptyCap2,@maxPerWgtofEmptyCap3,@maxPerWgtofNetWgt1,@maxPerWgtofNetWgt2,@maxPerWgtofNetWgt3,@remark1,@remark2,@remark3,"+
        "@RecSeqNo,@result,@Run_Time_Erros";
        connection.query(strquery, function (err, rows, fields) {
            if (err) {
                console.log(err);
            }
            resolve(rows);
       });  
    })
}

  async  CalrepeatPercantage(repSrNo,repetabilityDetailTable,repmasterTableName){
        try{
            let strquery =`CALL RepeatabilityPercentage('${repSrNo}','${repetabilityDetailTable}','${repmasterTableName}',@stddevWT,@avgWT,@repeatabilityPer);SELECT @stddevWT,@avgWT,@repeatabilityPer;`;    
            var result = await sequelize.query(strquery,{ type: QueryTypes.SELECT });
            return result;
        }catch(error){
            console.log(error);
            return error;
        }
    }

    CalrepeatPeriodicPercantage(repSrNo,balId,repetabilityDetailTable){
        return new Promise((resolve,reject) => {
            let strquery = "CALL RepeatabilityPeriodicPercentage(" + repSrNo + ",'" + balId + "','" + repetabilityDetailTable + "'," +
                "@balLeastCount,@balDSNW,@repeatabilityPer,@result,@LResult,@EResult);"+
                "SELECT @balLeastCount,@balDSNW,@repeatabilityPer,@result,@LResult,@EResult;";
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });
        })
    }

    

    getIndividualMVL(RepSerNo, masterTableName, detailTableName, value){
        return new Promise((resolve,reject) => {
            var MstSerNo = RepSerNo;
            var BFGCode = value.BFGCode;
            var ProductName = value.ProductName;
            var PVersion = value.PVersion;
            var Version = value.Version;
            var BatchNo = value.batchNo;
            var CubicleType = value.cubicleType;
            var RepoLabel14 = value.cubicleSubType;
            var Side = value.Side;
            //var ReportType = value.reportType;

            var strquery = "CALL reportCalculationForMVL(" + MstSerNo + ",'" + BFGCode + "','" + ProductName + "','" + PVersion + "','" + Version + "','" + BatchNo + "','" + CubicleType + "','" + RepoLabel14 + "','" + Side + "','" + masterTableName + "','" + detailTableName + "'," +
            "@nom,@lowT2,@uppT2,@averageValue,@minWeight,@maxWeight,@sumOfDataValue1,@sumOfDataValue2,@sumOfDataValue3,@sumOfDataValue4,@sumOfDataValue5,"+
            "@sumOfDataValue6,@sumOfDataValue7,@sumOfDataValue8,@sumOfDataValue9,@sumOfDataValue10,@minWeight1,@minWeight2,@minWeight3,@minWeight4,@minWeight5,@minWeight6,"+
            "@minWeight7,@minWeight8,@minWeight9,@minWeight10,@maxWeight1,@maxWeight2,@maxWeight3,@maxWeight4,@maxWeight5,@maxWeight6,@maxWeight7,@maxWeight8,@maxWeight9,"+
            "@maxWeight10,@avgWeight1,@avgWeight2,@avgWeight3,@avgWeight4,@avgWeight5,@avgWeight6,@avgWeight7,@avgWeight8,@avgWeight9,@avgWeight10,@stdDeviation1,"+
            "@stdDeviation2,@stdDeviation3,@stdDeviation4,@stdDeviation5,@stdDeviation6,@stdDeviation7,@stdDeviation8,@stdDeviation9,@stdDeviation10,"+
            "@minPercentage1,@minPercentage2,@minPercentage3,@minPercentage4,@minPercentage5,@minPercentage6,@minPercentage7,@minPercentage8,@minPercentage9,@minPercentage10,"+
            "@maxPercentage1,@maxPercentage2,@maxPercentage3,@maxPercentage4,@maxPercentage5,@maxPercentage6,@maxPercentage7,@maxPercentage8,@maxPercentage9,"+
            "@maxPercentage10,@remark1,@remark2,@remark3,@remark4,@remark5,@remark6,@remark7,@remark8,@remark9,@remark10,@RecSeqNo,@result,@Run_Time_Erros);"+
            "SELECT @nom,@lowT2,@uppT2,@averageValue,@minWeight,@maxWeight,@sumOfDataValue1,@sumOfDataValue2,@sumOfDataValue3,@sumOfDataValue4,@sumOfDataValue5,"+
            "@sumOfDataValue6,@sumOfDataValue7,@sumOfDataValue8,@sumOfDataValue9,@sumOfDataValue10,@minWeight1,@minWeight2,@minWeight3,@minWeight4,@minWeight5,@minWeight6,"+
            "@minWeight7,@minWeight8,@minWeight9,@minWeight10,@maxWeight1,@maxWeight2,@maxWeight3,@maxWeight4,@maxWeight5,@maxWeight6,@maxWeight7,@maxWeight8,@maxWeight9,"+
            "@maxWeight10,@avgWeight1,@avgWeight2,@avgWeight3,@avgWeight4,@avgWeight5,@avgWeight6,@avgWeight7,@avgWeight8,@avgWeight9,@avgWeight10,@stdDeviation1,"+
            "@stdDeviation2,@stdDeviation3,@stdDeviation4,@stdDeviation5,@stdDeviation6,@stdDeviation7,@stdDeviation8,@stdDeviation9,@stdDeviation10,"+
            "@minPercentage1,@minPercentage2,@minPercentage3,@minPercentage4,@minPercentage5,@minPercentage6,@minPercentage7,@minPercentage8,@minPercentage9,@minPercentage10,"+
            "@maxPercentage1,@maxPercentage2,@maxPercentage3,@maxPercentage4,@maxPercentage5,@maxPercentage6,@maxPercentage7,@maxPercentage8,@maxPercentage9,"+
            "@maxPercentage10,@remark1,@remark2,@remark3,@remark4,@remark5,@remark6,@remark7,@remark8,@remark9,@remark10,@RecSeqNo,@result,@Run_Time_Erros;";
            //console.log(strquery);
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });

        })
    }

}
module.exports = StoredProcedure;