const Database = require('../database/clsQueryProcess');
const database = new Database();
const clsQueryBuilder = require('../database/clsQueryTransactProcess');
const ObjQueryBuilder = new clsQueryBuilder();
const date = require('date-and-time');
const requestIp = require('request-ip');
const clsStoredProcedure = require('./clsStoredProcedure');
const objStoredProcedure = new clsStoredProcedure();

class SoftshellReportModel{

    async getSoftshellDetails(value) {
        try{
            var projectName = await this.getProjectName();
            if(projectName != false){
                var proj_name = projectName;   
            }
            var fromDate = value.fromDate;
            var toDate = value.toDate;
            var reportType = value.reportType;
            var recordFrom = value.recordFrom;
            var responseObj = {};
            var masterTableName, detailTableName;
            var reciveObj = await this.commanFunctionForFindingOutTableName(reportType, recordFrom, proj_name);
            masterTableName = reciveObj.masterTableName;
            detailTableName = reciveObj.detailTableName
            const selectMaster = {
                str_tableName: masterTableName,
                data: '*',
                condition: [
                    {
                        str_colName: 'PrDate', value: fromDate, value1: toDate, comp: 'btn'
                    }
                ]
            }
            let result = await database.select(selectMaster);
            if (result[0].length > 0) {
                Object.assign(responseObj, { status: 'success' }, { result: result[0] });
                return responseObj;
    
            } else {
                Object.assign(responseObj, { status: 'success' }, { result: "Data Not Found" });
                return responseObj;
            }
        }catch(error){
            return error;
        }
    }

    async viewSoftshellReport(value,req){
        try{
            var responseObj = {};
            var projectName = await this.getProjectName();
            if(projectName != false){
                var proj_name = projectName;   
            }
            var reportType = value.reportType;
            var recordFrom = value.recordFrom;
            var RepSerNo = value.RepSerNo;
            
            var masterTableName, detailTableName;
            var reciveObj = await this.commanFunctionForFindingOutTableName(reportType, recordFrom, proj_name);
            masterTableName = reciveObj.masterTableName;
            detailTableName = reciveObj.detailTableName;
            var clientIp = requestIp.getClientIp(req);
            var ip = clientIp.split(':')[3];
            if (ip === undefined) {
                ip = '127.0.0.1';
            } else {
                ip = ip;
            }
            var gerRepsr = {
                str_tableName:detailTableName,
                data:'MAX(RecSeqNo) as SeqNo',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo, comp:'eq' }
                ]
            }
            var maxrep = await database.select(gerRepsr);
            var SeqNo = maxrep[0][0].SeqNo;
            var selectObj = {
                str_tableName: masterTableName,
                data: '*',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo, comp:'eq' }
                ]
            }
            var masterRes = await database.select(selectObj);
            var insertVal = masterRes[0][0];
            var tbl_master = "tbl_temp_master";
            var tbl_detail= "tbl_temp_detaildiff";
            var selectTempData = {
                str_tableName: 'tbl_temp_master',
                data: '*',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3],comp:'eq' }
                ]
            }
            var tempRes = await database.select(selectTempData);
            if(tempRes[0].length > 0){
                var deleteTempMaster = {
                    str_tableName: tbl_master,
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: tbl_detail,
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
            var deleteTempMasterData = await database.delete(deleteTempMaster);
            var deleteTempDetailData = await database.delete(deleteTempDetail);
            var res = await this.insertSoftshellTempTables(insertVal, ip, detailTableName, RepSerNo);
            var calRes = await this.calculationSoftshell(insertVal, RepSerNo, ip, value, reportType, SeqNo);
            return calRes;
            }else{
                var res = await this.insertSoftshellTempTables(insertVal, ip, detailTableName, RepSerNo);
                var calRes = await this.calculationSoftshell(insertVal, RepSerNo, ip, value, reportType);
                return calRes;
            }

        }catch(error){
            return error;
        }
    }

    async insertSoftshellTempTables(insertVal, ip, detailTableName, RepSerNo){
        try{
            const resultDp = {
                str_tableName:'tbl_product_softshell',
                data:'*',
                condition:[
                    { str_colName: 'ProductId', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName },
                    { str_colName: 'ProductVersion', value: insertVal.PVersion },
                    { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'BatchNo', value: insertVal.BatchNo },
                ]
            }
            var dpData = await database.select(resultDp);
            var dpVal = dpData[0][0];
            var dp = dpVal.Param0_Dp;

            var insertTempObj = {
                str_tableName: 'tbl_temp_master',
                data: [
                    { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                    { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                    { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                    { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                    { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                    { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                    { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                    { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                    { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                    { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                    { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                    { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                    { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: insertVal.T1NegTol },
                    { str_colName: 'T1PosTol', value: insertVal.T1PosTol }, { str_colName: 'T2NegTol', value: (insertVal.T2NegTol == undefined) ? 'NULL' : insertVal.T2NegTol },
                    { str_colName: 'T2PosTol', value: (insertVal.T2PosTol == undefined) ? 'NULL' : insertVal.T2PosTol }, { str_colName: 'limitOn', value: insertVal.limitOn },
                    { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                    { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: (insertVal.T2NegEmpty == undefined) ? 'NULL' : insertVal.T2NegEmpty },
                    { str_colName: 'T2PosEmpty', value: (insertVal.T2PosEmpty == undefined) ? 'NULL' : insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: Number(insertVal.NomNet).toFixed(dp) },
                    { str_colName: 'T1NegNet', value: (insertVal.T1NegNet == undefined) ? 'NULL' : Number(insertVal.T1NegNet).toFixed(dp) }, { str_colName: 'T1PosNet', value: (insertVal.T1PosNet == undefined) ? 'NULL' : Number(insertVal.T1PosNet).toFixed(dp) },
                    { str_colName: 'T2NegNet', value: (insertVal.T2NegNet == undefined) ? 'NULL' : Number(insertVal.T2NegNet).toFixed(dp) }, { str_colName: 'T2PosNet', value: (insertVal.T2PosNet == undefined) ? 'NULL' : Number(insertVal.T2PosNet).toFixed(dp) },
                    { str_colName: 'T3NegNet', value: (insertVal.T3NegNet == undefined) ? 'NULL' : Number(insertVal.T3NegNet).toFixed(dp) }, { str_colName: 'T3PosNet', value: (insertVal.T3PosNet == undefined) ? 'NULL' : Number(insertVal.T3PosNet).toFixed(dp) },
                    { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                    { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                    { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                    { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                    { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                    { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                    { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                    { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                    { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                    { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                    { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] },{ str_colName: 'Stage', value: 'Encapsulation' },{ str_colName: 'Lot', value: insertVal.Lot },
                    { str_colName: 'Area', value: insertVal.Area },{ str_colName: 'TestType', value: 1 }
                ]
            }
            var res = await database.save(insertTempObj);

            var selectDetailObj = {
                str_tableName: detailTableName,
                data: 'RepSerNo, RecSeqNo, DataValue, DataValue1, NetWeight, DecimalPoint',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo }
                ]
            }
            var detailData = await database.select(selectDetailObj);
            //var detailData = await this.getIndividualDetail(RepSerNo,detailTableName);
            var dpVal = insertVal.DecimalPoint;
            for (const v of detailData[0]) {
                var insertDetail = {
                    str_tableName: 'tbl_temp_detaildiff',
                    data: [
                        { str_colName: 'RepSerNo', value: v.RepSerNo },
                        { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                        { str_colName: 'DataValue', value: Number(v.DataValue).toFixed(dpVal) },
                        { str_colName: 'DataValue1', value: Number(v.DataValue1).toFixed(dpVal) },
                        { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                        { str_colName: 'NetWeight', value: Number(v.NetWeight).toFixed(dpVal) },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                    ]
                }

                var result = await database.save(insertDetail);

            }
            return true;
        }catch(error){
            return error;
        }
    }

    async calculationSoftshell(insertVal, RepSerNo, ip, value, reportType, SeqNo){
        try{
            const objData = {};
            const resultDp = {
                str_tableName:'tbl_product_softshell',
                data:'*',
                condition:[
                    { str_colName: 'ProductId', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName },
                    { str_colName: 'ProductVersion', value: insertVal.PVersion },
                    { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'BatchNo', value: insertVal.BatchNo },
                ]
            }
            var dpData = await database.select(resultDp);
            var dpValue = dpData[0][0];
            var dpVal = dpValue.Param0_Dp;
            
            var dp = insertVal.DecimalPoint;
            var result = await objStoredProcedure.getCalculationForSoftshell(RepSerNo, value);
            Object.assign(objData, {
                UserName: value.username,
                UserId: value.userId,
                HmiId: ip.split('.')[3],
                nom: Number(result[1][0]['@nominal']).toFixed(dpVal), // dpVal -> ProductMaster DP
                lowT2: Number(result[1][0]['@lowT2']).toFixed(dpVal), // dpVal -> ProductMaster DP
                uppT2: Number(result[1][0]['@uppT2']).toFixed(dpVal), // dpVal -> ProductMaster DP 
                lowT1: Number(result[1][0]['@lowT1']).toFixed(dpVal), // dpVal -> ProductMaster DP
                uppT1: Number(result[1][0]['@uppT1']).toFixed(dpVal), // dpVal -> ProductMaster DP
                AbvLmt1NoSide: result[1][0]['@aboveLimitCount'],
                BlwLmt1NoSide: result[1][0]['@belowLimitCount'],
                MinWeight: Number(result[1][0]['@minWeight']).toFixed(dp), // dp -> Weighment Master DP
                MaxWeight: Number(result[1][0]['@maxWeight']).toFixed(dp), // dp -> Weighment Master DP

                MinPercent: Number(result[1][0]['@minPercentage']).toFixed(dp), // dp -> Weighment Master DP
                MaxPercent: Number(result[1][0]['@maxPercentage']).toFixed(dp), // dp -> Weighment Master DP
                
                AverageValue: Number(result[1][0]['@average']),
                CalStandDev: Number(result[1][0]['@standardDeviation']),

                printNo: Number(value.printNo), 
                ICReport: value.reportType,
                SelectedValue: value.RepSerNo, 
                RecSeqNo: SeqNo, 
                Result: result[1][0]['@result'],waterMark: true,
                minWtGross : Number(result[1][0]['@minGrossWt']).toFixed(dp),
                minWtShell: Number(result[1][0]['@minShellWt']).toFixed(dp),
                minWtNet: Number(result[1][0]['@minNetWt']).toFixed(dp),

                maxWtNet: Number(result[1][0]['@maxNetWt']).toFixed(dp),
                maxWtShell: Number(result[1][0]['@maxShellWt']).toFixed(dp),
                maxWtGross: Number(result[1][0]['@maxGrossWt']).toFixed(dp),
                // All avg values are rouded of by 2 decimals
                // Customer requirement conveyed by Chaitanya 080221
                avgWtShell: Number(result[1][0]['@avgShellWt']).toFixed(2),
                avgWtNet: Number(result[1][0]['@avgNetWt']).toFixed(2),
                avgWtGross: Number(result[1][0]['@avgGrossWt']).toFixed(2)
            });
            return objData;

        }catch(error){
            return error;
        }
    }

    async printReasonSoftshellReport(value,req){
        try{
            var responseObj = {};
            var projectName = await this.getProjectName();
            if(projectName != false){
                var proj_name = projectName;   
            }
            var reportType = value.reportType;
            var recordFrom = value.recordFrom;
            var RepSerNo = value.RepSrNo;
            var clientIp = requestIp.getClientIp(req);
            var reciveObj = await this.commanFunctionForFindingOutTableName(reportType, recordFrom, proj_name);
            var printTableName = reciveObj.strPrintTableName;
            var selectObj = {
                str_tableName: printTableName,
                data: '*',
                condition: [
                    { str_colName: 'RepSrNo', value: RepSerNo }
                ]
            }
           var printResult = await database.select(selectObj);
           if(printResult[0].length > 0){
                var checkObj = {
                    str_tableName: 'tbl_printoutreason_weighingreport',
                    data: '*',
                    condition: [
                        { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] }
                    ]
                }
               var checkResult = await database.select(checkObj);
               if(checkResult[0].length > 0){
                    var deleteObj = {
                        str_tableName: 'tbl_printoutreason_weighingreport',
                        condition: [
                            { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] }
                        ]
                    }
                    var delResult = await database.delete(deleteObj);
                    for (const obj of printResult[0]) {
                        let inserDataObj = {
                            str_tableName: 'tbl_printoutreason_weighingreport',
                            data: [
                                { str_colName: 'RepSrNo', value: obj.RepSrNo },
                                { str_colName: 'PrintNo', value: obj.PrintNo },
                                { str_colName: 'Reason', value: obj.Reason },
                                { str_colName: 'Title', value: obj.Title },
                                { str_colName: 'UserID', value: obj.UserID },
                                { str_colName: 'UserName', value: obj.UserName },
                                { str_colName: 'Print_Dt', value: obj.Print_Dt },
                                { str_colName: 'Print_Tm', value: obj.Print_Tm },
                                { str_colName: 'IsIncomplete', value: obj.IsIncomplete[0] },
                                { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] },
                            ]
                        }
                       var result = await database.save(inserDataObj); 
                    }
                    Object.assign(responseObj, { HmiId: clientIp.split(':')[3].split('.')[3] });
                    return responseObj;
               }else{
                for (const obj of printResult[0]) {
                    let inserDataObj = {
                        str_tableName: 'tbl_printoutreason_weighingreport',
                        data: [
                            { str_colName: 'RepSrNo', value: obj.RepSrNo },
                            { str_colName: 'PrintNo', value: obj.PrintNo },
                            { str_colName: 'Reason', value: obj.Reason },
                            { str_colName: 'Title', value: obj.Title },
                            { str_colName: 'UserID', value: obj.UserID },
                            { str_colName: 'UserName', value: obj.UserName },
                            { str_colName: 'Print_Dt', value: obj.Print_Dt },
                            { str_colName: 'Print_Tm', value: obj.Print_Tm },
                            { str_colName: 'IsIncomplete', value: obj.IsIncomplete[0] },
                            { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] },
                        ]
                    }
                   var result1 = await database.save(inserDataObj); 
                }
                Object.assign(responseObj, { HmiId: clientIp.split(':')[3].split('.')[3] });
                return responseObj;
               }
           }
    
        }catch(error){
            return error;
        }
    }

    async insertprintReasonSoftshellReport(value,req){
        try{
            var now = new Date();
            var responseObj = {};
            var clientIp = requestIp.getClientIp(req);
            var projectName = await this.getProjectName();
            if(projectName != false){
                var proj_name = projectName;   
            }
            var reportType = value.reportType;
            var recordFrom = value.recordFrom;
            var RepSrNo = value.RepSrNo;
            const TableName = await this.commanFunctionForFindingOutTableName(reportType, recordFrom, proj_name);
            var printTableName = TableName.strPrintTableName;
            var masterTableName = TableName.masterTableName;

            const objPrint = {
                str_tableName:printTableName,
                data:[
                    { str_colName: "RepSrNo", value: value.RepSrNo },
                    { str_colName: "PrintNo", value: value.intPrintCount },
                    { str_colName: "Reason", value: value.strReason == "" ? "NA" : value.strReason },
                    { str_colName: "Title", value: 'Softshell' },
                    { str_colName: "UserID", value: value.strUserId },
                    { str_colName: "UserName", value: value.strUserName },
                    { str_colName: "Print_Dt", value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: "Print_Tm", value: date.format(now, 'HH:mm:ss') },
                    { str_colName: "IsIncomplete", value: value.reportType == "Complete" ? 1 : 0 }
                ]
            }
           var result = await database.save(objPrint); 
    
           const objUpdateTable = {
            str_tableName: masterTableName,
            data:[
                { str_colName: "PrintNo", value: value.intPrintCount }
            ],
            condition:[ { str_colName: "RepSerNo", value: value.RepSrNo }]
            }
            var resultUpdate = await database.update(objUpdateTable); 
    
           const objActivity = {
            str_tableName:'tbl_activity_log',
            data:[
                { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
                { str_colName: "userid", value: value.strUserId },
                { str_colName: "username", value: value.strUserName },
                { str_colName: "activity", value: 'Softshell Report Printed' },
            ]
        }
        var result1 = await database.save(objActivity);
        Object.assign(responseObj, { status: 'success' });
        return responseObj;

        }catch(error){
            return error;
        }
    }

    async getProjectName(){
        try{
            const selectDetailRpt = {
                str_tableName: 'tbl_rpt_path',
                data: '*',
            }
            var result = await database.select(selectDetailRpt);
            if(result[0].length > 0){
                var proj_name = result[0][0]['proj_name'];
                return proj_name;
            }else{
                return false;
            }
        }catch(error){
            return error;
        }
    }
    async commanFunctionForFindingOutTableName(reportType, recordFrom, proj_name){
        try{
            var masterTableName, detailTableName, intWeighmentSrNo, strPrintTableName;
            intWeighmentSrNo = 3;
            strPrintTableName = "tbl_cap_print3";
            if (reportType == 'Complete') {
                if (recordFrom == 'Current') { //current Complete
                    masterTableName = 'tbl_cap_master3';
                    detailTableName = 'tbl_cap_detail3';
                } else {  //archive Complete
                    masterTableName = 'tbl_cap_master3_archived';
                    detailTableName = 'tbl_cap_detail3_archived'
                }
            } else {
                if (recordFrom == 'Current') { // current Incomplete
                    masterTableName = 'tbl_cap_master3_incomplete';
                    detailTableName = 'tbl_cap_detail3_incomplete'
                } else {
                    // TO - DO for incomplete archive
                }
            }
            return {
                masterTableName: masterTableName, detailTableName: detailTableName,
                intWeighmentSrNo: intWeighmentSrNo, strPrintTableName: strPrintTableName
            }

        }catch(error){
            console.log(error);
            return error;
        }
    }

    async checkReportIsVerified(objReport)
    {
        var str_master_tableName = "";
       if(objReport.reportType == "Complete")
       {
        (objReport.recordFrom == "Current") ? str_master_tableName = "tbl_cap_master3" : str_master_tableName = "tbl_cap_master3_archived";
       }
       else
       {
        str_master_tableName = "tbl_cap_master3_incomplete";
       }

       const objGetData = {
           str_tableName: str_master_tableName,
           data:"CheckedByID",
           condition:[
               {str_colName:"RepSerNo", value:objReport.intReportSerNo}
           ]
       }

       let res= await database.select(objGetData);
        return res[0][0].CheckedByID;
    }

    async verifyReportSoftshell(objReport)
    {
        var str_master_tableName = "";
       if(objReport.reportType == "Complete")
       {
        (objReport.recordFrom == "Current") ? str_master_tableName = "tbl_cap_master3" : str_master_tableName = "tbl_cap_master3_archived";
       }
       else
       {
        str_master_tableName = "tbl_cap_master3_incomplete";
       }
       var now = new Date();
       const objGetData = {
           str_tableName: str_master_tableName,
           data:[
               {str_colName: "CheckedByID",value: objReport.strUserId},
               {str_colName: "CheckedByName",value: objReport.strUserName},
               {str_colName: "CheckedByDate",value: date.format(now, 'YYYY-MM-DD')}
           ],
           condition:[
               {str_colName:"RepSerNo", value:objReport.intReportSerNo}
           ]
       }

       let res= await database.update(objGetData);
        return 'Update';
    }
}
module.exports = SoftshellReportModel;