class ProductCapsule {
    

    getEmptyObject(req, reqAuditObject = false) {
        var emtGraphOn, blnEmtLimitOn;
        emtGraphOn = req.flt_EmptyGraphOn == "Standard" ? 0 : 1;
        blnEmtLimitOn = req.flt_EmptyLimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objEmpty = {
            Param0_Nom: req.flt_Emptystd,
            Param0_T1Neg: req.flt_EmptyT1Neg,
            Param0_T1Pos: req.flt_EmptyT1Pos,
            Param0_T2Neg: req.flt_EmptyT2Neg,
            Param0_T2Pos: req.flt_EmptyT2Pos,
            Param0_Dp: req.int_EmptyDp,
            Param0_IsOnStd: emtGraphOn,
            Param0_LimitOn: blnEmtLimitOn,
            Param0_NMTTab: req.flt_EmptyNMTCnt,
            Param0_Unit: req.str_unit_Balance, 
        }

        const objEmptyAudit = {
            NewParam0_Nom: req.flt_GrpStd,
            NewParam0_T1Neg: req.flt_GrpT1Neg,
            NewParam0_T1Pos: req.flt_GrpT1Pos,
            NewParam0_T2Neg: req.flt_GrpT2Neg,
            NewParam0_T2Pos: req.flt_GrpT2Pos,
            NewParam0_IsOnStd: emtGraphOn,
            NewParam0_LmtOn: blnEmtLimitOn,
            NewParam0_NMTTab: req.int_GrpNMTTabCnt,
            }

        if (reqAuditObject == true) {
            return objEmptyAudit;
        } else {
            return objEmpty;

        }
    }

    getNetObject(req, reqAuditObject = false) {
        var NetGraphOn, blnNetLimitOn;
        NetGraphOn = req.flt_DiffNetGraphOn == "Standard" ? 0 : 1;
        blnNetLimitOn = req.flt_DiffNetLimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)


        const objNet = {
                Param3_Nom: req.flt_DiffNet,
                Param3_T1Neg: req.flt_DiffNetT1Neg,
                Param3_T1Pos: req.flt_DiffNetT1Pos,
                Param3_T2Neg: req.flt_DiffNetT2Neg,
                Param3_T2Pos: req.flt_DiffNetT2Pos,
                Param3_DP: req.int_NetDp,
                Param3_IsOnStd: NetGraphOn,
                Param3_LimitOn: blnNetLimitOn,
                Param3_NMTTab: req.flt_DiffNetNMTCnt,
                Param3_Unit: req.str_unit_Balance, }
                
        const objNetAudit = {
                NewParam3_Nom: req.flt_GrpStd,
                NewParam3_T1Neg: req.flt_GrpT1Neg,
                NewParam3_T1Pos: req.flt_GrpT1Pos,
                NewParam3_T2Neg: req.flt_GrpT2Neg,
                NewParam3_T2Pos: req.flt_GrpT2Pos,
                NewParam3_IsOnStd: NetGraphOn,
                NewParam3_LmtOn: blnNetLimitOn,
                NewParam3_NMTTab: req.int_GrpNMTTabCnt,
            }

        if (reqAuditObject == true) {
            return objNetAudit;
        } else {
            return objNet;

        }
    }

    getDiameterObject(req, reqAuditObject = false) {
        var diaGraphOn;
        diaGraphOn = req.str_DiaGraphOn == "Standard" ? 0 : 1;
        const objDiameter = {
            Param4_Nom: req.flt_DiaStd,
            Param4_T1Neg: req.flt_DiaT1Neg,
            Param4_T1Pos: req.flt_DiaT1Pos,
            Param4_T2Neg: req.flt_DiaT2Neg,
            Param4_T2Pos: req.flt_DiaT2Pos,
            Param4_DP: req.int_DiaDp,
            Param4_IsOnStd: diaGraphOn,
            Param4_NMTTab: req.int_DiaNMTTabCnt,
        }
        

        const objDiameterAudit = {
            NewParam4_Nom: req.flt_DiaStd,
            NewParam4_T1Neg: req.flt_DiaT1Neg,
            NewParam4_T1Pos:req.flt_DiaT1Pos,
            NewParam4_T2Neg: req.flt_DiaT2Neg,
            NewParam4_T2Pos: req.flt_DiaT2Pos,
            NewParam4_IsOnStd: diaGraphOn,
            NewParam4_NMTTab: req.int_DiaNMTTabCnt,
        }

        if (reqAuditObject == true) {
            return objDiameterAudit;
        } else {
            return objDiameter;

        }
    }

    getDTObject(req, reqAuditObject = false) {
        var dtTime = req.int_DTHHTime + ':' + req.int_DTMMTime + ':' + req.int_DTSSTime;

        const objDT = {
            Param6_Nom: dtTime,
            Param6_T1Neg: req.flt_DTMinTemp,
            Param6_T1Pos: req.flt_DTMaxTemp,
            Param6_DP: req.int_DTDp
        }
    
        const objDTAudit = {
            Param13_Nom: dtTime,
            Param13_T1Neg: req.flt_DTMinTemp ,
            Param13_T1Pos: req.flt_DTMaxTemp ,
        }

        if (reqAuditObject) {
            return objDTAudit;
        } else {
            return objDT;
        }
    }

    getContent1Object(req) {
        var bln_content1_graphOn, bln_content1_limiton;
        bln_content1_graphOn = req.str_Content1GraphOn == "Standard" ? 0 : 1;
        bln_content1_limiton = req.str_Content1LimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objContent1 = {
            Param9_Nom: req.flt_Content1Std,
            Param9_T1Neg: req.flt_Content1T1Neg,
            Param9_T1Pos: req.flt_Content1T1Pos,
            Param9_T2Neg: req.flt_Content1T2Neg,
            Param9_T2Pos: req.flt_Content1T2Pos,
            Param9_DP: req.int_Content1DP,
            Param9_IsOnStd: bln_content1_graphOn,
            Param9_LimitOn: bln_content1_limiton,
            Param9_NMTTab: req.int_Content1NMTTabCnt,
            Param9_ContentType: req.str_content1_type,
            Param9_ContentDesc: req.str_content1_Name,
            Param9_Unit: req.str_unit_Balance,
        }

        return objContent1;
    }

    getContent2Object(req) {
        var bln_content2_graphOn, bln_content2_limiton;
        bln_content2_graphOn = req.str_Content2GraphOn == "Standard" ? 0 : 1;
        bln_content2_limiton = req.str_Content2LimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objContent2 = {
            Param10_Nom: req.flt_Content2Std,
            Param10_T1Neg: req.flt_Content2T1Neg,
            Param10_T1Pos: req.flt_Content2T1Pos,
            Param10_T2Neg: req.flt_Content2T2Neg,
            Param10_T2Pos: req.flt_Content2T2Pos,
            Param10_DP: req.int_Content2DP,
            Param10_IsOnStd: bln_content2_graphOn,
            Param10_LimitOn: bln_content2_limiton,
            Param10_NMTTab: req.int_Content2NMTTabCnt,
            Param10_ContentType: req.str_content2_type,
            Param10_ContentDesc: req.str_content2_Name,
            Param10_Unit: req.str_unit_Balance,}

        return objContent2;
    }

    getContent3Object(req) {
        var bln_content3_graphOn, bln_content3_limiton;
        bln_content3_graphOn = req.str_Content3GraphOn == "Standard" ? 0 : 1;
        bln_content3_limiton = req.str_Content3LimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objContent3 = {
            Param11_Nom: req.flt_Content3Std,
            Param11_T1Neg: req.flt_Content3T1Neg,
            Param11_T1Pos: req.flt_Content3T1Pos,
            Param11_T2Neg: req.flt_Content3T2Neg,
            Param11_T2Pos: req.flt_Content3T2Pos,
            Param11_DP: req.int_Content3DP,
            Param11_IsOnStd: bln_content3_graphOn,
            Param11_LimitOn: bln_content3_limiton,
            Param11_NMTTab: req.int_Content3NMTTabCnt,
            Param11_ContentType: req.str_content3_type ,
            Param11_ContentDesc: req.str_content3_Name,
            Param11_Unit: req.str_unit_Balance,
        }
        

        return objContent3;
    }

    getContent4Object(req) {
        var bln_content4_graphOn, bln_content4_limiton;
        bln_content4_graphOn = req.str_Content4GraphOn == "Standard" ? 0 : 1;
        bln_content4_limiton = req.str_Content4LimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objContent4 = { 
            Param12_Nom: req.flt_Content4Std,
            Param12_T1Neg: req.flt_Content4T1Neg,
            Param12_T1Pos: req.flt_Content4T1Pos,
            Param12_T2Neg: req.flt_Content4T2Neg,
            Param12_T2Pos: req.flt_Content4T2Pos,
            Param12_DP: req.int_Content4DP,
            Param12_IsOnStd: bln_content4_graphOn,
            Param12_LimitOn: bln_content4_limiton,
            Param12_NMTTab: req.int_Content4NMTTabCnt,
            Param12_ContentType: req.str_content4_type ,
            Param12_ContentDesc: req.str_content4_Name,
            Param12_Unit: req.str_unit_Balance,}
        

        return objContent4;
    }



}

module.exports = ProductCapsule;