const dbCon = require('../Utills/db')
const date = require('date-and-time')
const Database = require('../database/clsQueryProcess');
const database = new Database();

var models = require("../dbConnection").models;

class ParametersModel 
{

    async getAllParameterModel() 
    {
        try {
            let obj_response = {};
            let result = await models.tbl_setallparameter.findAll({logging : false});
            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;
        } catch (error) {
            return error;
        }
    }

    async commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value)
    {
        var now = new Date();

        await models.tbl_audit_all_periods.create({
            dt: date.format(now, 'YYYY-MM-DD'),
            tm: date.format(now, 'HH:mm:ss'),
            userid: value.userId,
            username: value.userName,
            oldValue: oldValue,
            NewValue: NewValue,
            TypeOfPeriod: TypeOfPeriod,
            Remark: value.remark
        });
    }

    async updateParametersModel(value) 
    {
        try
        {
            var responseObj = {};
            // var now = new Date();
            let now = new Date();

            //Fetched all paramaters values
            let resultParameter = await models.tbl_setallparameter.findAll();

            //Set all paramaters old values in varaiables
            var oldTimeOutPeriod = resultParameter[0].tbl_config_TimeoutPeriod;
            var oldArchivePeriod = resultParameter[0].tbl_config_ArchivePeriod;

            var oldPrintingMode = resultParameter[0].tbl_PrintingMode;

            var oldPasswordExpPeriod = resultParameter[0].tbl_config_PasswordExpPeriod;
            var oldReminderPassword = resultParameter[0].tbl_config_ReminderPassword;

            var oldLoginAttempts = resultParameter[0].tbl_config_LoginAttempts;
            var oldAutoEnableChances = resultParameter[0].tbl_config_AutoEnableChances;

            var oldDisabledTime = resultParameter[0].tbl_config_DisabledTime;

            var oldPwdHistoryCount = resultParameter[0].tbl_config_PwdHistoryCount;
            var oldAutoDisablePeriod = resultParameter[0].tbl_config_AutoDisablePeriod;

            //update paramater
            const Obj_UpdateParameter = await models.tbl_setallparameter.update
            (
                {
                    tbl_config_TimeoutPeriod : value.tbl_config_TimeoutPeriod,
                    tbl_config_PasswordExpPeriod : value.tbl_config_PasswordExpPeriod,
                    tbl_config_ReminderPassword:value.tbl_config_ReminderPassword,
                    tbl_config_ArchivePeriod:value.tbl_config_ArchivePeriod,
                    tbl_config_AutoDisablePeriod:value.tbl_config_AutoDisablePeriod,
                    tbl_config_LoginAttempts:value.tbl_config_LoginAttempts,
                    tbl_config_AutoEnableChances:value.tbl_config_AutoEnableChances,
                    tbl_config_DisabledTime:value.tbl_config_DisabledTime,
                    tbl_config_PwdHistoryCount:value.tbl_config_PwdHistoryCount,
                    tbl_PrintingMode:value.tbl_PrintingMode
                },
                {
                    where: {config_id:value.configId}
                }
            );

            //audit trail for TIME OUT PERIOD
            if(oldTimeOutPeriod != value.tbl_config_TimeoutPeriod)
            {
                let oldValue = oldTimeOutPeriod;
                let NewValue = value.tbl_config_TimeoutPeriod;
                let TypeOfPeriod = 'TIME OUT PERIOD';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for ARCHIVE TIME PERIOD
            if(oldArchivePeriod != value.tbl_config_ArchivePeriod)
            {
                let oldValue = oldArchivePeriod;
                let NewValue = value.tbl_config_ArchivePeriod;
                let TypeOfPeriod = 'ARCHIVE TIME PERIOD';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for PASSWORD AGING PERIOD
            if(oldPasswordExpPeriod != value.tbl_config_PasswordExpPeriod)
            {
                let oldValue = oldPasswordExpPeriod;
                let NewValue = value.tbl_config_PasswordExpPeriod;
                let TypeOfPeriod = 'PASSWORD AGING PERIOD';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for PASSWORD AGING REMINDER
            if(oldReminderPassword != value.tbl_config_ReminderPassword)
            {
                let oldValue = oldReminderPassword;
                let NewValue = value.tbl_config_ReminderPassword;
                let TypeOfPeriod = 'PASSWORD AGING REMINDER';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for PRINTING MODE
            if(oldPrintingMode != value.tbl_PrintingMode)
            {
                let oldValue = oldPrintingMode;
                let NewValue = value.tbl_PrintingMode;
                let TypeOfPeriod = 'PRINTING MODE';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for LOGIN FAILURE LIMIT
            if(oldLoginAttempts != value.tbl_config_LoginAttempts)
            {
                let oldValue = oldLoginAttempts;
                let NewValue = value.tbl_config_LoginAttempts;
                let TypeOfPeriod = 'LOGIN FAILURE LIMIT';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for AUTO ENABLE CHANCES
            if(oldAutoEnableChances != value.tbl_config_AutoEnableChances)
            {
                let oldValue = oldAutoEnableChances;
                let NewValue = value.tbl_config_AutoEnableChances;
                let TypeOfPeriod = 'AUTO ENABLE CHANCES';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for LOCK PERIOD
            if(oldDisabledTime != value.tbl_config_DisabledTime)
            {
                let oldValue = oldDisabledTime;
                let NewValue = value.tbl_config_DisabledTime;
                let TypeOfPeriod = 'LOCK PERIOD';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for PASSWORD HISTORY COUNT
            if(oldPwdHistoryCount != value.tbl_config_PwdHistoryCount)
            {
                let oldValue = oldPwdHistoryCount;
                let NewValue = value.tbl_config_PwdHistoryCount;
                let TypeOfPeriod = 'PASSWORD HISTORY COUNT';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

            //audit trail for NON LOGIN PERIOD
            if(oldAutoDisablePeriod != value.tbl_config_AutoDisablePeriod)
            {
                let oldValue = oldAutoDisablePeriod;//oldDisabledTime;
                let NewValue = value.tbl_config_AutoDisablePeriod;
                let TypeOfPeriod = 'NON LOGIN PERIOD';

                await this.commonAuditTrailFN(oldValue,NewValue,TypeOfPeriod,value);
            }

             await models.tbl_activity_log.create({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                userid:value.userId,
                username:value.userName,
                activity:'Parameter Updated'
            });

            Object.assign(responseObj, { status: 'success' }, { result: 'Parameters updated successfully' })
            return responseObj;

        }catch(error){
            return error;
        }
    }

}
module.exports = ParametersModel;