const seqTransaction = require("../dbConnection");
const models = require("../dbConnection").models;
const date = require('date-and-time');
const { Op } = require('sequelize');

class OtherEquipmentModel {
    async getOtherEquipment() {
        try {
            var obj_response = {};
            let result = await models.tbl_otherequipment.findAll();
            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;
        } catch (error) {
            return error;
        }
    }

    async getOtherEquipmentByID(str_eqpId,str_eqpType)
    {
        try {
            await models.tbl_otherequipment.findAll({where:[
                 {Eqp_ID: str_eqpId},
                 {Eqp_Type: str_eqpType}
            ]});
            return result;
        } catch (error) {
           return error; 
        }
       
    }

    async storeOtherEquipment(req) {
        try {
            let newData = '';   
            let obj_response = {};

            let resExist = await models.tbl_otherequipment.findAll({where:[
                 {Eqp_ID: req.body.Eqp_ID}, 
                 {Eqp_Type: req.body.Eqp_Type}
            ]});

            if(resExist.length != 0){
                Object.assign(obj_response, { status: 'success' }, { result: 'Otherequipment ID Already Exist' });
                return obj_response;
            }
            else
            {
                let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                    let now = new Date();
                    await models.tbl_otherequipment.create({
                        Eqp_Type:  req.body.Eqp_Type,
                        Eqp_ID:  req.body.Eqp_ID,
                        Eqp_Model:  req.body.Eqp_Model,
                        Eqp_Make:  req.body.Eqp_Make,
                        Eqp_SerialNo:  req.body.Eqp_SerialNo,
                        Eqp_Dept:  req.body.Eqp_Dept,
                        locked:  0,
                        Eqp_Active:  0,
                        Eqp_CalibDt:  req.body.Eqp_CalibDt,
                        Eqp_userID:  req.body.userid,
                        Eqp_HT_Type:  req.body.str_HT_Type,
                        Eqp_HT_IsMutliTester:  0
                    },{
                        transaction: t
                    });

                    await models.tbl_audit_other_equipment.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.body.userid,
                        username: req.body.username,
                        Action: req.body.Action,
                        Remark: req.body.Remark,
                        Eqp_Type: req.body.Eqp_Type,
                        Eqp_ID: req.body.Eqp_ID,
                        OldData: "NA",
                        NewData: req.body.NewData,
                        OldWeight: 'NA',
                        NewWeight: 'NA',
                    },{
                        transaction: t
                    });
            
                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.body.userid,
                        username: req.body.username,
                        activity: 'Instrument Added'
                    },{
                        transaction: t
                    });

                });

                Object.assign(obj_response, { status: 'success' }, { result: 'Otherequipment Added Successfully' });
                return obj_response;
            }

        } catch (error) {
            return error;
        }
    }

    async updateOtherEquipment(req) {
        try {
            let obj_response = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date(); 
                await models.tbl_otherequipment.update({
                    Eqp_ID: req.body.Eqp_ID,
                    Eqp_Model: req.body.Eqp_Model,
                    Eqp_Make: req.body.Eqp_Make,
                    Eqp_SerialNo: req.body.Eqp_SerialNo,
                    Eqp_Dept: req.body.Eqp_Dept,
                    locked: 0,
                    Eqp_Active: 0,
                    Eqp_CalibDt: req.body.Eqp_CalibDt,
                    Eqp_HT_Type: req.body.str_HT_Type
                },{
                    where:
                    { 
                    Eqp_ID: req.body.Eqp_ID,
                     Eqp_Type: req.body.Eqp_Type
                    }
                },{
                    transaction: t
                });

                await models.tbl_audit_other_equipment.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userid,
                    username: req.body.username,
                    Action: req.body.Action,
                    Remark: req.body.Remark,
                    Eqp_Type: req.body.Eqp_Type,
                    Eqp_ID: req.body.Eqp_ID,
                    OldData: req.body.OldData,
                    NewData: req.body.NewData,
                    OldWeight: 'NA',
                    NewWeight: 'NA',
                },{
                    transaction: t
                });
        
                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userid,
                    username: req.body.username,
                    activity: 'Instrument Updated'
                },{
                    transaction: t
                });
            });

            Object.assign(obj_response, { status: 'success' }, { result: 'Otherequipment Updated Successfully' })
            return obj_response;
        } catch (error) {
            return error;
        }
    }

    async getDetailData(req) {
        try {
            let obj_response = {};

            await models.tbl_otherequipment.findAll({where:
                { eqp_type: req.body.Eqp_Type}
            });

            var result1 = await models.tbl_otherequipment.findAll({where:
                { eqp_type: req.body.Eqp_Type}
            });

            var result2 = await models.tbl_cubical.findAll({  
                attributes: [[`${req.body.id}`, 'eqpid']],
                where:{ 
                    [`${req.body.id}`]: {[Op.ne]:'None'},
                }
            });

            Object.assign(obj_response, { status: 'success' }, { result1: result1 }, {result2: result2});
            return obj_response;
        } catch (error) {
            return error;
        }
    }

    async updateActivestatus(req) {
        try{
            var obj_response = {};
            var eqpActive = parseInt(req.body.Eqp_Active);
            var IsApproved = await this.getOtherEquipmentByID(req.body.Eqp_ID,req.body.Eqp_Type);

            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var now = new Date();

                if(IsApproved.Eqp_IsApproved == 0 && eqpActive == 1)
                {
                    await models.tbl_otherequipment.update({
                        Eqp_IsApproved: eqpActive,
                        Eqp_ApprovedBy: req.body.userid
                    },{where:[
                        { Eqp_ID: req.body.Eqp_ID },
                        { Eqp_Type: req.body.Eqp_Type }
                    ]},{
                        transaction: t
                    });
                }


                await models.tbl_otherequipment.update({
                    Eqp_Active: eqpActive
                },{where:[
                    { Eqp_ID: req.body.Eqp_ID },
                    { Eqp_Type: req.body.Eqp_Type }
                ]},{
                    transaction: t
                });

                await models.tbl_audit_other_equipment.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userid,
                    username: req.body.username,
                    Remark: req.body.Remark,
                    Action: req.body.Action,
                    Eqp_Type: req.body.Eqp_Type,
                    Eqp_ID: req.body.Eqp_ID,
                    OldData: 0,
                    NewData: 0
                },{
                    transaction: t
                });

            });

            Object.assign(obj_response, { status: 'success' }, { result: 'Status Activited Successfully' })
            return obj_response;
        }catch(error){
            return error;
        }
            
    }


    async getWeights(req) { 
        try {
            let str_tableName;
            let obj_response = {};
            if (type == 'Hardness') {
                str_tableName = 'tbl_hardness_weight'
            } else if('Moisture Analyzer') { 
                str_tableName = 'tbl_moitureanalyzer_weight'
            }

            let result = await models[str_tableName].findAll({where:
                { ID: req.body.ID}
            });

            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;

        } catch (error) {
            return error;
        }
    }

    async checkInCubicle(req)
    {
        try{
            let obj_res = {};
            let str_type = "";
            (req.body.str_eType == "Hardness") ? str_type = 'Sys_HardID' : (req.body.str_eType == "Tablet Tester") ? str_type = 'Sys_HardID' : (req.body.str_eType == "Disintegration Tester") ? str_type = 'Sys_DTID':
            (req.body.str_eType == "Friabilator") ? str_type = 'Sys_FriabID' : (req.body.str_eType == "Moisture Analyzer") ? str_type = 'Sys_MoistID':
            (req.body.str_eType == "Tapped Density") ? str_type = 'Sys_TapDensityID' :  str_type = 'Sys_SieveShakerID';
            var arr_cubicle = [];
            
            let res = await models.tbl_cubical.findAll({where:
                { [`${str_type}`]: req.body.str_eqpID }
            });

            if(res.length > 0)
            {
                let res_getCubicles = await models.tbl_cubicle_area.findAll({
                    attributes: ['IDSFrom','IDSTo'],
                    where:
                    { Area: res[0]['Sys_Area'] }
                });
               
                for(let i=res_getCubicles[0]['IDSFrom'];i<=res_getCubicles[0]['IDSTo'];i++)
                {
                    arr_cubicle.push(i);
                }
                let int_no = arr_cubicle.indexOf(res[0]['Sys_CubicNo']) + 1;
               obj_res = {'Sys_Area':res[0]['Sys_Area'],"Sys_CubicNo":int_no}; 
            }
            else
            {
                obj_res = null;
            }

            return obj_res;
            
        }catch(error){
            return error;
        }
    }
    
}
module.exports = OtherEquipmentModel;