const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const sequelize = require('./../dbConnection').sequelize;

class MachineModel {

    async getMachineData(str_machineID = "") {
        try {
            var result;
            if (str_machineID == "") {
                 result = await models.tbl_machine.findAll();
            } else {
                result = await models.tbl_machine.findAll({where:
                    {
                        Machine_ID: strMachineID
                    }
                 });
            }
            
            return result;

        } catch (error) {
            return error;
        }
       
    }
    
    /**
     * 
     * @param {*} value current request to activate or deactivate machine
     * @returns return activated or deactivated
     * @memberof MachineModel
     */
  async updateActiveDeactive(value) {
        try{ 
            var obj_response = {};
            var statusMsg;
            var action = value.action;
            var status;
            var approval;
            if (action == 'Activate') {
                status = 1;
                approval = 1;
            } else { 
                status = 0;
            }

            var machineID = value.machineID;
            var remark = value.remark;
            var userId = value.userId
            var userName = value.userName;
            var machineData = await this.getMachineData(machineID);

            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var now = new Date();

            if(machineData.Machine_IsApproved == 0 && action == 'Activate')
            {

                    await models.tbl_machine.update({
                        Machine_IsApproved: approval,
                        Machine_ApprovedBy: userId
                    },{where:
                        { Machine_ID: machineID }
                    },{
                        transaction: t
                    });
                
            }

            await models.tbl_machine.update({
                Machine_Active: status
            },{where:
                { Machine_ID: machineID }
            },{
                transaction: t
            });

            await models.tbl_audit_machine.create({
                DT: date.format(now, 'YYYY-MM-DD'),
                TM: date.format(now, 'HH:mm:ss'),
                userid: userId,
                username: userName,
                Remark: remark,
                ACT: action,
                MachineID: machineID,
                OldData: 'NA',
                NewData: 'NA'
            },{
                transaction: t
            });

                if (action == 'Activate') {
                    statusMsg = 'Machine Activated Successfully';
                } else { 
                    statusMsg = 'Machine Deactivated Successfully';
                }
            });
                Object.assign(obj_response, { status: 'success' }, { result: statusMsg })
                return obj_response
        
        }catch(error){
            return error;
        }
    }
    /**
     *This function is used to store the machine data 
     * @param {*} req = Currnet Request to fetch the params from it 
     * @returns Object { status: 'success / Error' }, { result: 'Msg' } 
     * @memberof MachineModel
     */
    async saveMachineData(req)
    {
       try {
        
            var obj_response = {};
            let resExist = await models.tbl_machine.findAll({where:
                { Machine_ID: req.MachineID }
            });

            if(resExist.length != 0){
                Object.assign(obj_response, { status: 'success' }, { result: 'Machine Already Exist' });
                return obj_response;
            }
            else
            {
                let lbl_Machine = await models.tbl_nomenclature.findOne({
                    attributes: ['MachineCode']
                });
                let str_label = lbl_Machine.MachineCode;

                let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date();
                  await models.tbl_machine.create({
                    Machine_ID: req.MachineID,
                    Machine_Model: req.Model,
                    Machine_Make: req.Make,
                    Machine_SerialNo: req.SrNo,
                    Machine_Rotary: req.RotaryType,
                    locked: 0,
                    Machine_Active: 0,
                    Machine_CubicleType:  req.CubicleType,
                    Machine_userID:  req.loggedUserId,
                    Machine_speed_Min:  req.MinSpeed,
                    Machine_speed_Max:  req.MaxSpeed
                },{
                    transaction: t
                });
        
                await models.tbl_audit_machine.create({
                    DT : date.format(now, 'YYYY-MM-DD'),
                    TM : date.format(now, 'HH:mm:ss'),
                    userid : req.loggedUserId,
                    username : req.loggedUserName,
                    ACT : req.action,
                    Remark : req.remark,
                    MachineID : req.MachineID,
                    NewData : req.newData
                },{
                    transaction: t
                });
        
                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: str_label.split(' ')[0] + " Added"
                },{
                    transaction: t
                });

            });
        
                Object.assign(obj_response, { status: 'success' }, { result: 'Machine Added Successfully' })
                return obj_response;
            }
            
       } catch (error) {
           console.log("Add Machine",error);
           return error;
       }
        
    }

   /**
    * This function will make machine Locked or Unlocked during Edit Machine
    * To Prevent the same machine edit from other location.
    * @param {*} req = Currnet Request to fetch the params from it 
    * @returns Promise with Object { status: 'success / Error' }, { result: 'Msg' }
    * @memberof MachineModel
    */
   togglelock(req) {
        const responseObj = {};
        return new Promise((resolve, reject) => {
            var lock;
            if(req.IsLock == true){
                lock = 1;
            } else {
                lock = 0;   
            }
            const lockObject = {
                str_tableName: "tbl_machine",
                data: [{
                    str_colName: 'Machine_Locked',
                    value: lock
                }],
                condition: [{
                    str_colName: 'Machine_ID',
                    value: req.MachineID
                }]
            }
            database.update(lockObject).then((result) => {
                Object.assign(responseObj, {status: 'success'}, {result: 'Machine Locked'})
                resolve(responseObj)
            }).catch((err) => {
                reject(err);
            })

        });
    }

   /**
    * This function is used to edit machine and make audit entry
    * @returns Promise with Object { status: 'success / Error' }, { result: 'Msg/err' } 
    * @memberof MachineModel
    */
   async editMachineData(req) {
        try {
            var obj_response = {};

            let lbl_Machine = await models.tbl_nomenclature.findOne({
                attributes: ['MachineCode']
            });
            let str_label = lbl_Machine.MachineCode;

            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date(); 

                await models.tbl_machine.update({
                    Machine_Model: req.Model,
                    Machine_Make: req.Make,
                    Machine_SerialNo: req.SrNo,
                    Machine_Rotary : req.RotaryType,
                    locked: 0,
                    Machine_Active: 0,
                    Machine_CubicleType: req.CubicleType,
                    Machine_speed_Min: req.MinSpeed,
                    Machine_speed_Max: req.MaxSpeed
                },{where:
                    {Machine_ID: req.MachineID} 
                },{
                    transaction: t
                });

               await models.tbl_audit_machine.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    MachineID: req.MachineID,
                    OldData: req.oldData,
                    NewData: req.newData
               },{
                   transaction: t
               });

               await models.tbl_activity_log.create({
                    dt : date.format(now, 'YYYY-MM-DD'),
                    tm : date.format(now, 'HH:mm:ss'),
                    userid : req.loggedUserId,
                    username : req.loggedUserName,
                    activity : str_label.split(' ')[0] + " Updated"
                },{
                    transaction: t
                });

            });

            Object.assign(obj_response, { status: 'success' }, { result: 'Machine Edited Successfully' });
            return obj_response;

        } catch (error) {
            console.log("Edit Machine",error);
            return error;
        }
    }


    async checkInCubicle(req)
    {
        try{
            let obj_res = {};
            var arr_cubicle = [];

            let result = await models.tbl_cubical.findAll({where:
             { Sys_MachineCode: req.body.str_eqpID}
            });

            if(result.length > 0)
            {
                let res_getCubicles = await models.tbl_cubicle_area.findAll({
                    attributes: ['IDSFrom','IDSTo'],
                    where: {
                        Area: result[0]['Sys_Area']
                    }
                });

                
                for(let i=res_getCubicles[0]['IDSFrom'];i<=res_getCubicles[0]['IDSTo'];i++)
                {
                    arr_cubicle.push(i);
                }
                let int_no = arr_cubicle.indexOf(result[0]['Sys_CubicNo']) + 1;
               obj_res = {'Sys_Area':result[0]['Sys_Area'],"Sys_CubicNo":int_no}; 
            }
            else
            {
                obj_res = null;
            }

            return obj_res;
            
        }catch(error){
            return error;
        }
    }

}

module.exports = MachineModel;