const Database = require('../database/clsQueryProcess');
const database = new Database();
const _strTableName = "tbl_product_master";
const _strDetailTableName = "tbl_product_capsule";

const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const sequelize = require('./../dbConnection').sequelize;
const { Op, where } = require("sequelize");
class CapsuleModel {

    static get strTableName() {
        return _strTableName;
    }

    static get strDetailTableName() {
        return _strDetailTableName;
    }

    async getMasterData(IProduct, intGenericName) {

        try {
            var objMaster;
            var str_tableName;
            if (intGenericName == 1) {
                str_tableName= CapsuleModel.strTableName;
                objMaster = await models[str_tableName].findAll({
                    where: {
                        ProductId: IProduct.ProductId,
                        ProductName: IProduct.ProductName,
                        ProductVersion: IProduct.ProductVersion,
                        Version: IProduct.Version,
                        GenericName: IProduct.str_GenericName,
                    }
                });
                
            }
            else {
                str_tableName = CapsuleModel.strTableName;
                objMaster = await models[str_tableName].findAll({
                    where: {
                        ProductId: IProduct.ProductId,
                        ProductName: IProduct.ProductName,
                        ProductVersion: IProduct.ProductVersion,
                        Version: IProduct.Version,
                    }
                });
            }
            var result = objMaster;
            var Master = { Master: result[0] };

            return Master;
        } catch (error) {
            console.log(error);
            throw error;
        }

    }


    async getCapsuleParams(IProduct, intGenericName) {
        try {
            var objCapsuleInfo = {};
            var str_tableName;
            if (intGenericName == 1) {
                str_tableName = CapsuleModel.strDetailTableName;

                objCapsuleInfo = await models[str_tableName].findAll({
                    where: {
                        ProductId: IProduct.ProductId,
                        ProductName: IProduct.ProductName,
                        ProductVersion: IProduct.ProductVersion,
                        Version: IProduct.Version,
                        GenericName: IProduct.str_GenericName,
                    }
                });
            }
            else {
                str_tableName = CapsuleModel.strDetailTableName;
                objCapsuleInfo = await models[str_tableName].findAll({
                    where: {
                        ProductId: IProduct.ProductId,
                        ProductName: IProduct.ProductName,
                        ProductVersion: IProduct.ProductVersion,
                        Version: IProduct.Version,
                    }
                });
            }
            var result = objCapsuleInfo;
            var product = { Capsule: result[0] };
            return product;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getCapsuleGranulationDetails(IProduct, intGenericName) {
        try {
            var objCapsuleInfo = {};
            if (intGenericName == 1) {

                objCapsuleInfo = await models.tbl_product_gran_cap.findAll({
                    where: {
                        ProductId: IProduct.ProductId,
                        ProductName: IProduct.ProductName,
                        ProductVersion: IProduct.ProductVersion,
                        Version: IProduct.Version,
                        GenericName: IProduct.str_GenericName,
                    }
                });
            }
            else {
                objCapsuleInfo = await models.tbl_product_gran_cap.findAll({
                    where: {
                        ProductId: IProduct.ProductId,
                        ProductName: IProduct.ProductName,
                        ProductVersion: IProduct.ProductVersion,
                        Version: IProduct.Version,
                    }
                });
            }

            var result = objCapsuleInfo;
            var product = { Granulation: result[0] };
            return product;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getCapsuleDetails(IProduct, intGenericName) {
        try {
            var Product = {};
            var Master = await this.getMasterData(IProduct, intGenericName);
            var CapsuleParams = await this.getCapsuleParams(IProduct, intGenericName);
            var granulation = await this.getCapsuleGranulationDetails(IProduct, intGenericName); // code is written for pallet coating for cubicle setting
            if (granulation.Granulation == undefined) {
                Object.assign(Product, Master, CapsuleParams);
            }
            else {
                Object.assign(Product, Master, CapsuleParams, granulation);
            }


            return Product;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
}
module.exports = CapsuleModel;