const models = require("../dbConnection").models;
const date = require('date-and-time');
const moment = require('moment');
const { Op } = require("sequelize");
const sequelize = require('../dbConnection').sequelize
const { QueryTypes } = require('sequelize');
const serverConfig = require('../global/serverConfig');

const str_tableName = {
    Balance: 'tbl_recalibration_balance_status',
    BinBalance: 'tbl_recalibration_balance_status_bin',
    Vernier: 'tbl_recalibration_vernier_status'
};

class Calibration {

        /**
     * To Get the Status of Positional Calibration 
     *
     * @param {*} int_CubNo  get Weighment status using cubicle no.
     * @returns Promise with Object
     * @memberof Calibration
     */
    async checkWeighingStatusStatus(int_CubNo) {
        try {
         let result = await models.tbl_system_weighingstatus.findAll({
             attributes:['Status'],
             where: {CubicleNo: int_CubNo}
        }); 
        return result[0]['Status'];
        } catch (error) {
            return error;
        }
    }

     
    async checkCalibrationStatus(int_CubNo) {
        try {
            let result = await models.tbl_cubical.findAll({
                attributes:['Sys_CalibInProcess'],
                where: {Sys_CubicNo: int_CubNo}
           }); 
           return result[0]['Sys_CalibInProcess'];
        } catch (error) {
            return error;
        }
    }

     /**
     * To get Status from recalibration table
     */
    async checkCalibrationStatusFromRecalibTbl(res)
    {
        try {
            if(res.strSelectedInstrumentType == "Vernier")
            {
               let result = await models[str_tableName.Vernier].findAll({
                    attributes:['DailyVerRecalib','PeriodicVerRecalib'],
                    where:{Ver_ID: res.id}
                });

                return result[0];
            }
            else
            {
               var strTableName = (res.strSelectedInstrumentType == "Balance") ?  str_tableName.Balance :  str_tableName.BinBalance; 
                let result = await models[strTableName].findAll({
                    attributes:['DailyBalRecalib','PeriodicBalRecalib'],
                    where:{Bal_ID: res.id}
                });

                return result[0];
            }
        } catch (error) {
            return error;
        }
    }

    /**
     * To Get the Status of Daily Calibration 
     *
     * @param {*} strBalanceId  Balance ID for Which calibration needs to be checked 
     * @param {*} strDate  date for which calibration needs to be checked
     * @param {*} int_WeighmentStatus  Weighment is in process
     * @param {*} int_recalibStatus  recalibStatus for which calibration needs to be checked
     * @returns Promise with Object
     * @memberof Calibration
     * if periodic calibration is pending that time daily calibration doesn't ask, if periodic calibration done then both recalibrate
     */
    async checkDailyCalibrationStatus(strBalanceId, strDate, int_WeighmentStatus, int_recalibStatus,int_calibrationStatus) {
        try {
                var now = new Date();
                var cntPeriodicDone = 0,Obj_dailyPending;
                let bln_EitherDailyOrPeriodicOrBoth = (serverConfig.developerPanelData.IncrencyCommon.find(x=>x.Name == 'EitherDailyOrPeriodicOrBoth').Value == '0') ? false : true;
                let result = await models.tbl_calibration_daily_master.findAll({where:
                    {
                        Daily_BalID: strBalanceId,
                        Daily_CalbDate: strDate
                    }
                });

                let resultPeriodic = await models.tbl_calibration_periodic_master.count({where:
                    {
                        Periodic_CalbDate: date.format(now, 'YYYY-MM-DD'),
                        Periodic_BalID: strBalanceId
                    }
                });

                if(resultPeriodic.length > 0) 
                {
                    cntPeriodicDone = resultPeriodic;
                }

                if(bln_EitherDailyOrPeriodicOrBoth == true) {            
                    let resultCalib = await models.tbl_balance_weights.findAll({
                        where:
                        {
                            Bal_ID: strBalanceId,
                            Bal_Daily: '1'
                        }
                    });
                    if(resultCalib == 0) {
                        Obj_dailyPending = { DailyPending : true, Message : 'NA' };
                        return Obj_dailyPending;
                    }
                }

                if(int_WeighmentStatus == "1")
                {
                    Obj_dailyPending =  { DailyPending: false, Message: "Weighment Is In Process" };
                }
                else if(int_calibrationStatus == "1")
                {
                    Obj_dailyPending =  { DailyPending: false, Message: "Calibration Is In Process" };
                }
                else if(result.length == 0 && int_recalibStatus == 0) //if today's calib not done 
                {
                    Obj_dailyPending =  { DailyPending: true, Message: "Routine Daily Calibration Pending" }; 
                }
                else if(result.length >= 1 && int_recalibStatus == 0 ) //if today's calib done
                {
                    Obj_dailyPending =  { DailyPending: false, Message: "No Calibration Pending" }; 
                }
                else if(int_recalibStatus == 1) 
                {
                    Obj_dailyPending =  { DailyPending: true, Message: "Initiated" }; 
                }
                return Obj_dailyPending;
        } catch (error) {
            return error;
        }
           
    }

        async checkDailyCalibrationStatusWithoutDaily(strBalanceId, strDate, int_WeighmentStatus, int_recalibStatus, strPeriodicStatus, str_projectName,int_calibrationStatus) {
            try {
                    var now = new Date();
                    var intIsVerified = 0;
                    var cntPeriodicDone = 0,Obj_dailyPending,isRoutinePeriodicVerification = 0;
                    let bln_EitherDailyOrPeriodicOrBoth = (serverConfig.developerPanelData.IncrencyCommon.find(x=>x.Name == 'EitherDailyOrPeriodicOrBoth').Value == '0') ? false : true;
                    //fetching calibdate to check current day is periodic due for the previous periodic calib verification pending
                    let obj_balanceData = await models.tbl_balance.findAll({where:
                        {Bal_ID: strBalanceId}
                    });

                    let result = await models.tbl_calibration_daily_master.findAll({where:
                        {
                            Daily_BalID: strBalanceId,
                            Daily_CalbDate: strDate
                        }
                    });

                    let cntRoutinePeriodicVerification = await models.tbl_calibration_periodic_master.count({where:
                        {
                            Periodic_BalID:strBalanceId,
                            Periodic_IsRecalib : 0 ,
                            [Op.or]: [{ Periodic_VerifyID: null }, { Periodic_VerifyID: "NULL" }, { Periodic_VerifyID: "" }]
                        }
                    });
                    
                    let cntRoutinePeriodic = await models.tbl_calibration_periodic_master.count({where:
                        {
                            Periodic_BalID:strBalanceId,
                            Periodic_IsRecalib : 0 ,
                            Periodic_CalbDate: date.format(now, 'YYYY-MM-DD')
                        }
                    });

                    if(cntRoutinePeriodicVerification > 0) {
                        isRoutinePeriodicVerification = cntRoutinePeriodicVerification;
                    }

                    let resultPeriodic = await models.tbl_calibration_periodic_master.count({where:
                        {
                            Periodic_BalID: strBalanceId,
                            Periodic_CalbDate: date.format(now, 'YYYY-MM-DD')
                        }
                    });

                    if(resultPeriodic > 0) 
                    {
                        cntPeriodicDone = resultPeriodic;
                    }

                    var resultVerification = await models.tbl_calibration_daily_master.count({
                        where:{
                            Daily_BalID: strBalanceId,
                            [Op.or]: [{ Daily_VerifyID: null }, { Daily_VerifyID: "NULL" }, { Daily_VerifyID: "" }]
                        }
                    });
                    console.log(resultVerification);
                    if(resultVerification > 0)
                    {
                        (resultVerification >  0) ?  intIsVerified = 1 : intIsVerified = 0;
                    }
                                       
                    if(bln_EitherDailyOrPeriodicOrBoth == true) {
                        if (intIsVerified == 1) {
                            Obj_dailyPending =  { DailyPending: true, Message: "Verification Not Done" };
                            return Obj_dailyPending;
    
                        } else {
                            let resultCalib = await models.tbl_balance_weights.findAll({
                                where:
                                {
                                    Bal_ID: strBalanceId,
                                    Bal_Daily: '1'
                                }
                            });
                            if(resultCalib == 0) {
                                Obj_dailyPending = { DailyPending : true, Message : 'NA' };
                                return Obj_dailyPending;
                            }
                        }
                    }

                    if(int_WeighmentStatus == "1")
                    {
                        Obj_dailyPending =  { DailyPending: false, Message: "Weighment Is In Process" };
                    }
                    else if(int_calibrationStatus == "1")
                    {
                        Obj_dailyPending =  { DailyPending: false, Message: "Calibration Is In Process" };
                    }
                    else if(intIsVerified == 1)
                    {
                        Obj_dailyPending =  { DailyPending: true, Message: "Verification Not Done" }; 
                    }else if(strPeriodicStatus == 'Verification Not Done' && int_recalibStatus == 0 && ((isRoutinePeriodicVerification > 0 && cntPeriodicDone > 0) /*|| result.length > 0*/ || obj_balanceData[0].Bal_CalbDueDt === strDate)) 
                    {    //Daily Calib Status for the day on which periodic routine calibration is performed and whose recalib status is 0 OR periodic is recalibrated but not verified and daily calibration is done OR today is calibration date and previous periodic not verified
                        Obj_dailyPending = {DailyPending : true, Message : 'NA'}  
                    }    
                    else if(strPeriodicStatus == "Verification Not Done" && int_recalibStatus == 0 && cntPeriodicDone > 0 /*&& result.length == 0*/)
                    {
                        // THIS condition fails if today is routine periodic done and recalibrate on same day and not verify than this will come true and show pending
                          //Daily calib status when periodic is recalibrated and daiy recalib status is 0 for next day daily show show pending.

                          Obj_dailyPending =  { DailyPending: false, Message: "No Calibration Pending" }; 
                          // Obj_dailyPending =  { DailyPending: true, Message: "Routine Daily Calibration Pending" }; 
                    }
                    // else if(result.length == 0) {
                    //     Obj_dailyPending =  { DailyPending: true, Message: "Routine Daily Calibration Pending" }; 
                    // }
                    else if(strPeriodicStatus == "Routine Periodic Calibration Pending" &&  int_recalibStatus == 0)
                    {
                       Obj_dailyPending =  { DailyPending: true, Message: "NA" }; 
                    }
                    else if(strPeriodicStatus == "Initiated" && int_recalibStatus == 0 && cntPeriodicDone > 0)
                    {
                          //If user calibrated on the same day of routine periodic
                          Obj_dailyPending =  { DailyPending: false, Message: "No Calibration Pending" }; 
                    }
                    else if(strPeriodicStatus == "Initiated" && int_recalibStatus == 0 &&  result.length > 0)
                    {
                            //if user recalibrated the periodic and daily calibration is done
                        Obj_dailyPending =  { DailyPending: false, Message: "No Calibration Pending" }; 
                    }
                    else if(strPeriodicStatus == "Initiated" && int_recalibStatus == 0 && cntPeriodicDone == 0)
                    {
                         //Periodic calibration is done and recalibrated on next day ask routine daily calib
                        Obj_dailyPending =  { DailyPending: true, Message: "Routine Daily Calibration Pending" }; 
                    }
                    else if(["No Calibration Pending","NA"].includes(strPeriodicStatus) && cntPeriodicDone > 0 && int_recalibStatus == 0)//periodic done today
                    {
                        Obj_dailyPending =  { DailyPending: false, Message: "No Calibration Pending" }; 
                    }
                    else if(["No Calibration Pending","NA"].includes(strPeriodicStatus) && cntPeriodicDone == 0 && int_recalibStatus == 0 && result.length == 0)
                    {
                        Obj_dailyPending =  { DailyPending: true, Message: "Routine Daily Calibration Pending" }; 
                    }
                    else if(result.length == 0 && strPeriodicStatus != "Routine Periodic Calibration Pending" && cntRoutinePeriodic == 0/*&& int_recalibStatus == 0*/) //if today's calib not done 
                    {
                        Obj_dailyPending =  { DailyPending: true, Message: "Routine Daily Calibration Pending" }; 
                    }
                    else if(result.length >= 1 && int_recalibStatus == 0 ) //if today's calib done
                    {
                        Obj_dailyPending =  { DailyPending: false, Message: "No Calibration Pending" }; 
                    }
                    else if(int_recalibStatus == 1) 
                    {
                        Obj_dailyPending =  { DailyPending: true, Message: "Initiated" }; 
                    }
                    return Obj_dailyPending;
                
            } catch (error) {
                return error;
            }
           
    }

    /**
     * To Get the Status of Periodic Calibration 
     *
     * @param {*} strBalanceId  Balance ID for Which calibration needs to be checked 
     * @param {*} strDate  date for which calibration needs to be checked
     * @param {*} int_WeighmentStatus  Weighment is in process
     * @returns Promise with Object
     * @memberof Calibration
     */
    async checkPeriodicCalibrationStatus(strBalanceId, strDate, int_weighingStatus, int_calibStatus,int_calibrationStatus) {
        try {
                let now = new Date();
                var intIsVerified = 0;
                var resultPeriodic,resultVerification;
                var int_periodicFirstReportRepeatability =  serverConfig.developerPanelData.IncrencyCommon.find(x=>x.Name == 'PeriodicFirstReportRepeatability').Value;
                let bln_EitherDailyOrPeriodicOrBoth = (serverConfig.developerPanelData.IncrencyCommon.find(x=>x.Name == 'EitherDailyOrPeriodicOrBoth').Value == '0') ? false : true;
                let result = await models.tbl_balance.findAll({where:
                    {Bal_ID: strBalanceId}
                });

                if(int_periodicFirstReportRepeatability == "1") {
                     resultPeriodic = await models.tbl_calibration_repetability_master.findAll({
                        attributes:['Repet_BalID','Repet_RepNo'],
                        where:
                        {
                            Repet_CalbDate: date.format(now, 'YYYY-MM-DD'),
                            Repet_BalID: strBalanceId
                        }
                    });
    
                     resultVerification = await models.tbl_calibration_repetability_master.count({
                        where:{
                            Repet_BalID: strBalanceId,
                            [Op.or] : [{Repet_VerifyID: null},{Repet_VerifyID: ''},{Repet_VerifyID: 'NULL'}]
                        }
                    });
    
                }else{
                     resultPeriodic = await models.tbl_calibration_periodic_master.findAll({
                        attributes:['Periodic_BalID','Periodic_RepNo'],
                        where:
                        {
                            Periodic_CalbDate: date.format(now, 'YYYY-MM-DD'),
                            Periodic_BalID: strBalanceId
                        }
                    });
    
                     resultVerification = await models.tbl_calibration_periodic_master.count({
                        where:{
                            Periodic_BalID: strBalanceId,
                            [Op.or] : [{Periodic_VerifyID: null},{Periodic_VerifyID: ''},{Periodic_VerifyID: 'NULL'}]
                        }
                    });
    
                }
                
                 //Show NA at the time of daily calib varification is pending and periodic No Calib is pending
                // var dailyMst = await models.tbl_calibration_daily_master.findAll({ where : { 
                //     Daily_BalID: strBalanceId,
                //     [Op.or] : [{Daily_VerifyID: null},{Daily_VerifyID: ''},{Daily_VerifyID: 'NULL'}]
                // }});

                
                console.log(resultVerification);
                if(resultVerification > 0)
                {
                    (resultVerification >  0) ?  intIsVerified = 1 : intIsVerified = 0;
                }

                var blnCalibType =  result[0].Bal_CalbStoreType;
                var int_isNewBalance = result[0].IsNewBalance;

                var ObjPeriodicPending = {};

                /** check reminder */
                var cnt_recalibMonthly = 0,cnt_recalibYearly = 0;

                // let dt_yearly = result[0].Bal_CalbDueDtYear;
                let dt_monthly = result[0].Bal_CalbDueDt;
                let int_reminder = result[0].Bal_CalbReminder;
                
                if(bln_EitherDailyOrPeriodicOrBoth == true) {
                    if (intIsVerified == 1) {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Verification Not Done" };
                        return ObjPeriodicPending;

                    } else {
                        let str_column = (int_periodicFirstReportRepeatability == "1") ? 'Bal_IsRepetability' : 'Bal_Periodic';
                        let resultCalib = await models.tbl_balance_weights.findAll({
                            where:
                            {
                                Bal_ID: strBalanceId,
                                [str_column]: '1'
                            }
                        });
                        if(resultCalib == 0) {
                            ObjPeriodicPending = { PeriodicPending: true , Message: "NA" };
                            return ObjPeriodicPending;
                        }
                    }
                
                }



                // ***************
                var currentDate = date.format(now, 'YYYY-MM-DD').split("-")[2];
                var Bal_CalbDueDt = result[0].Bal_CalbDueDt;
                var blnPeriodicPending = true;
                var currentDateMonth = date.format(now, 'YYYY-MM-DD').split("-")[1];
                var currentDateYear = date.format(now, 'YYYY-MM-DD').split("-")[0];
                var prevoiusMonth;
                var oldCalDueDate;
                var calibrationDate = Bal_CalbDueDt.split("-")[2];
                if (calibrationDate > currentDate) {
                    prevoiusMonth = this.previousMonth(currentDateMonth);
                    if (prevoiusMonth == 12) {
                        currentDateYear = Number(currentDateYear);
                        oldCalDueDate = `${currentDateYear - 1}-${12}-${calibrationDate}`;
                    } else {
                        oldCalDueDate = `${currentDateYear}-${currentDateMonth-1}-${calibrationDate}`;
                    }
                }
                else {
                    oldCalDueDate = `${currentDateYear}-${currentDateMonth}-${calibrationDate}`;
                }
                var toDate =date.format(now, 'YYYY-MM-DD');
                var objPeriodic = await models.tbl_calibration_periodic_master.findAll({
                    where:
                    {
                        Periodic_BalID: strBalanceId,
                        Periodic_CalbDate: { [Op.between]: [oldCalDueDate, toDate] }
                    }
                });
                if(objPeriodic.length > 0) // if current date data is available than set tha flag to false
                {
                    blnPeriodicPending = false;
                }

                // *****************













                if (blnCalibType == 1) 
                {
                

                    if(int_weighingStatus == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending : false , Message: "Weighment is in process"};
                    }
                    else if(int_calibrationStatus == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending : false , Message: "Calibration is in process"};
                    }
                    else if(int_isNewBalance == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Routine Periodic Calibration Pending"};
                    }
                    else if (intIsVerified == 1)
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Verification Not Done"};
                    }
                    // else if (Bal_CalbDueDt <= strDate) 
                    else if (blnPeriodicPending) 
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Routine Periodic Calibration Pending"};
                    }
                    else if (int_calibStatus == 1) 
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Initiated"};
                    }
                    // else if(cnt_recalibMonthly > 0)
                    // {
                    //     ObjPeriodicPending = { PeriodicPending: true , Message: "Routine Periodic Calibration Pending"};
                    // }
                    // else if(cnt_recalibYearly > 0)
                    // {
                    //     ObjPeriodicPending = { PeriodicPending: true , Message: "Routine Periodic Calibration Pending"};
                    // }
                    /*else if(dailyMst.length > 0){
                        ObjPeriodicPending = { PeriodicPending: true , Message: "NA"};
                    }*/
                    else { 
                        ObjPeriodicPending = { PeriodicPending: false , Message: "No Calibration Pending"};
                    }
                }
                else {
                    // need to be corrected
                    var currDate =  moment({h:0, m:0, s:0, ms:0});
                    var arrCalbDate = [],arr_lessCurrentDates,startDate;
                    arrCalbDate = result[0].Bal_CalbDates.split(",").map(Number);
                    var blnPeriodicPending = true;
                    var currentDate = date.format(now, 'YYYY-MM-DD').split("-")[2];
                    arr_lessCurrentDates = arrCalbDate.filter( e => Number(e) <= Number(currentDate))

                    if(arr_lessCurrentDates.length > 0){
                        startDate = moment({ year :currDate.year(), month :currDate.month(), day :arr_lessCurrentDates[arr_lessCurrentDates.length-1], 
                            hour :0, minute :0, second :0, millisecond :0});
                    }else{
                        startDate = moment({ year :currDate.year(), month :currDate.month() - 1, day :arrCalbDate[arrCalbDate.length-1], 
                            hour :0, minute :0, second :0, millisecond :0});
                    }

                    var objPeriodic = await models.tbl_calibration_periodic_master.findAll({
                        where:
                        {
                            Periodic_BalID: strBalanceId,
                            Periodic_CalbDate: { [Op.between]: [startDate, currDate] }
                        }
                    });
                    if(objPeriodic.length > 0) // if current date data is available than set tha flag to false
                    {
                        blnPeriodicPending = false;
                    }
                
                    if(int_weighingStatus == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending : false , Message: "Weighment is in process"};
                    }
                    else if(int_calibrationStatus == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending : false , Message: "Calibration is in process"};
                    }
                    else if (int_calibStatus == 1) 
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Initiated"};
                    }
                    else if(int_isNewBalance == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Routine Periodic Calibration Pending"};
                    }
                    else if (intIsVerified == 1)
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Verification Not Done"};
                    }
                    else if (blnPeriodicPending) 
                    {
                        ObjPeriodicPending = { PeriodicPending : true , Message: "Routine Periodic Calibration Pending"};
                    }/*else if(dailyMst.length > 0){
                        ObjPeriodicPending = { PeriodicPending: true , Message: "NA"};
                     }*/
                    else
                    {
                         ObjPeriodicPending = { PeriodicPending : false , Message: "No Calibration Pending"};
                    }
                }
                return ObjPeriodicPending;
        } catch (error) {
            console.log(error);
            throw error
        }  
    }

    async checkPeriodicCalibrationStatusVernier(strVernierId, strDate, int_weighingStatus, int_calibStatus,int_calibrationStatus) {
        try {
            let now = new Date();
            let result = await models.tbl_vernier.findAll({where:
                {VernierID: strVernierId}
            });
            
                var blnCalibType = result[0].CalbStoreType;
                var int_isNewVernier = result[0].Ver_IsNew;
    
                var ObjPeriodicPending = {};
                if (blnCalibType == 1) 
                {
                    // 1: DATE
                    var Bal_CalbDueDt = date.format(result[0].CalDueDT, 'YYYY-MM-DD');
                    
                    if(int_weighingStatus == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending : false , Message: "Weighment is in process"};
                    }
                    else if(int_calibrationStatus == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending : false , Message: "Calibration is in process"};
                    }
                    else if(int_isNewVernier == "1") // if new vernier then pending and value is true 
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Routine Periodic Calibration Pending"};
                    }
                    else if (Bal_CalbDueDt <= strDate) 
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Routine Periodic Calibration Pending"};
                    }
                    else if (int_calibStatus == 1) 
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Initiated"};
                    }
                    else { 
                        ObjPeriodicPending = { PeriodicPending: false , Message: "No Calibration Pending"};
                    }
                }
                else {
                    var arrCalbDate = [];
                    arrCalbDate = result[0][0].Caldates.split(",");
                    var blnPeriodicPending = false;
                    arrCalbDate.map((dt) => {
                        var currentMonth = new Date(now).getMonth()+1;
                        var currentYear = new Date(now).getFullYear();
                        var newDt = currentYear + "-" + currentMonth + "-" + dt;
                        newDt = new Date(newDt);
    
                        if (strDate >= newDt) {
                            blnPeriodicPending == false ? blnPeriodicPending = true : blnPeriodicPending = false;
                        }
                        
                    })
                    if(int_weighingStatus == "1")
                    {
                        ObjPeriodicPending = { PeriodicPending : false , Message: "Weighment is in process"};
                    }
                    else if (blnPeriodicPending == true) {
                         ObjPeriodicPending = { PeriodicPending : true , Message: "Routine Periodic Calibration Pending"};
                    }
                    else if (int_calibStatus == 1) 
                    {
                        ObjPeriodicPending = { PeriodicPending: true , Message: "Initiated"};
                    }
                    else
                    {
                         ObjPeriodicPending = { PeriodicPending : false , Message: "No Calibration Pending"};
                    }
                }
                return ObjPeriodicPending;
        } catch (error) {
           return error; 
        }

    }

    async checkYearlyCalibrationStatus(strBalanceId, strDate, int_weighingStatus, int_calibStatus,int_calibrationStatus) {
        try {
                let now = new Date();
                let result = await models.tbl_balance.findAll({where:
                    {Bal_ID: strBalanceId}
                });
            
                var blnCalibType = result[0].Bal_CalbStoreType;
                var int_isNewBalance = result[0].IsNewBalance[0];

                var ObjYearlyPending = {};
                if (blnCalibType == 1) 
                {
                    // 1: DATE
                    var Bal_CalbDueDt = result[0].Bal_CalbDueDtYear;
                    
                    if(int_weighingStatus == "1")
                    {
                        ObjYearlyPending = { YearlyPending : false , Message: "Weighment is in process"};
                    }
                    else if(int_calibrationStatus == "1")
                    {
                        ObjYearlyPending = { YearlyPending : false , Message: "Calibration is in process"};
                    }
                    else if(int_isNewBalance == "1")
                    {
                        ObjYearlyPending = { YearlyPending: true , Message: "Routine Yearly Calibration Pending"};
                    }
                    else if (Bal_CalbDueDt <= strDate) 
                    {
                        ObjYearlyPending = { YearlyPending: true , Message: "Routine Yearly Calibration Pending"};
                    }
                    else if (int_calibStatus == 1) 
                    {
                        ObjYearlyPending = { YearlyPending: true , Message: "Initiated"};
                    }
                    else { 
                        ObjYearlyPending = { YearlyPending: false , Message: "No Calibration Pending"};
                    }
                }
                else {// need to be corrected
                    var arrCalbDate = [];
                    arrCalbDate = result[0].Bal_CalbDates.split(",");
                    var blnYearlyPending = false;
                    arrCalbDate.map((dt) => {
                        var currentMonth = new Date(now).getMonth()+1;
                        var currentYear = new Date(now).getFullYear();
                        var newDt = currentYear + "-" + currentMonth + "-" + dt;
                        newDt = new Date(newDt);

                        if (strDate >= newDt) {
                            blnYearlyPending == false ? blnYearlyPending = true : blnYearlyPending = false;
                        }
                        
                    })
                    if(int_weighingStatus == "1")
                    {
                        ObjYearlyPending = { YearlyPending : false , Message: "Weighment is in process"};
                    }
                    else if(int_isNewBalance == "0")
                    {
                        ObjYearlyPending = { YearlyPending: true , Message: "Routine Periodic Calibration Pending"};
                    }
                    else if (blnYearlyPending == true) {
                         ObjYearlyPending = { YearlyPending : true , Message: "Routine Periodic Calibration Pending"};
                    }
                    else if (int_calibStatus == 1) 
                    {
                        ObjYearlyPending = { YearlyPending: true , Message: "Initiated"};
                    }
                    else
                    {
                         ObjYearlyPending = { YearlyPending : false , Message: "No Calibration Pending"};
                    }
                }
                return ObjYearlyPending;
        } catch (error) {
            return error;
        }  
    }


    
    async previousMonth(currentMonth) {
        // Parse the current month as a number (e.g., '01' becomes 1)
        let month = parseInt(currentMonth, 10);

        // Subtract 1 to get the previous month
        month = month === 1 ? 12 : month - 1;

        // Format the month back to a two-digit string
        return month < 10 ? `0${month}` : `${month}`;
    }


}

module.exports = Calibration