const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const {Op} = require("sequelize");
const sequelize = require('./../dbConnection').sequelize;

class AreaSetting {

    async getAuditArea() {
        try {
            let result = await models.tbl_audit_areasetting.findAll({attributes:['Area']});
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
    
    /**
     * this function is used to get IDS No to show in dropdown list
     */
    async getIDS() {
        try {
            let result = await models.tbl_rpi.findAll();
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

     /**
     * this function is used to get Cubicle Name to show in dropdown list
     */
    async getCubicleName(str_area) {
        try {
            let result = await models.tbl_cubical.findAll({
                attributes: [sequelize.fn('DISTINCT', sequelize.col('Sys_CubicName'))],
                where: {
                    Sys_Area: str_area.Area,
                    Sys_CubicName: {[Op.ne]: 'NULL'}
                }
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
 
      /**
     * this function is used to update instrument detail in respective table
     */
    async updateAllAreaRef(res) {
        try {
            var obj_response = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date();
                // update child cubicle if exist

                var getOldCubicleName = await models.tbl_cubical.findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('Sys_CubicName'))],
                    where: {Sys_CubicNo:res.Sys_CubicNo},
                    transaction: t
                });

               await models.tbl_cubical.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName,
                    Sys_IDSNo: res.Sys_IDSNo,
                    Sys_MachineCode: res.Sys_MachineCode,
                    Sys_CubType: res.Sys_CubType,
                    Sys_cubTypes: res.Sys_cubTypes,
                    Sys_rpi: (res.Sys_IDSNo == "NA") ? 'NULL' : res.Sys_rpi
                },{
                    where: {Sys_CubicNo:res.Sys_CubicNo},
                    transaction: t
                });

                await models.tbl_cubicle_bin_setting.update({
                    Sys_CubicName: res.Sys_CubicName,
                    Sys_IDSNo: res.Sys_IDSNo,
                    Sys_CubicleType: res.Sys_CubType,
                },{
                    where: {Sys_CubicNo:res.Sys_CubicNo},
                    transaction: t
                });
                  
                await models.tbl_system_weighingstatus.update({
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicleNo: res.Sys_CubicNo},
                    transaction: t
                });

                await models.tbl_calibration_status.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {Cubicle:res.Sys_CubicNo},
                    transaction: t
                });


                await models.tbl_calibration_status_bin.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {Cubicle:res.Sys_CubicNo},
                    transaction: t
                });


                await models.tbl_cubicle_product_sample.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName,
                    Sys_rpi: (res.Sys_IDSNo == "NA") ? 'NULL' :  res.Sys_rpi
                },{
                    where: {Sys_CubicNo:res.Sys_CubicNo},
                    transaction: t
                });


                await models.tbl_alert_param_duration.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicNo:res.Sys_CubicNo},
                    transaction: t
                });

                await models.tbl_recalibration_balance_status.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicNo:res.Sys_CubicNo},
                    transaction: t
                });


                await models.tbl_recalibration_balance_status_bin.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicNo:res.Sys_CubicNo},
                    transaction: t
                });

                

                await models.tbl_recalibration_vernier_status.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicNo:res.Sys_CubicNo},
                    transaction: t
                });

                

                await models.tbl_audit_areasetting.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: res.userid,
                    username: res.username,
                    Remark: res.Remark,
                    Act: res.Act,
                    Area: res.Sys_Area,
                    OldData: res.OldData,
                    NewData: res.NewData,
                    ISIDSSetting: (res.Setting == "Area") ? 1 : 0
                },
                {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: res.userid,
                    username: res.username,
                    activity: res.activitylog
                },
                {
                    transaction: t
                });
            });

            Object.assign(obj_response, { status: 'success' }, { result: res.Setting + ' Setting Updated Successfully' });
            return obj_response;

        } catch (error) {
            console.log("Update Area",error);
            throw error;
        }
    }

}

module.exports = AreaSetting;