const date = require('date-and-time')
const Database = require('../database/clsQueryProcess');
const database = new Database();
const clsQueryBuilder = require('../database/clsQueryTransactProcess');
const ObjQueryBuilder = new clsQueryBuilder();
const BalanceOPCInterface = require('../OPC/balance.interface');
const OPC = require('../OPC/opc.model');
const objOPC = new OPC();
class OPCModel {
    async postOPC(data) {
        try {
            let repSrNo = data.RepSerNo;
            let ReportOption = data.ReportOption;
            let TestType = data.TestType;
            let ReportType = data.ReportType;
            let ReportFrom = data.ReportFrom;
            let masterTbl = ""; let detailTbl = "";
            if (ReportOption == 'Individual') {
                if (ReportType == 'Complete' && ReportFrom == 'Current') {
                    masterTbl = 'tbl_tab_master1';
                    detailTbl = 'tbl_tab_detail1';
                } else if (ReportType == 'Incomplete') {
                    masterTbl = 'tbl_tab_master1_incomplete';
                    detailTbl = 'tbl_tab_detail1_incomplete';
                } else {
                    masterTbl = 'tbl_tab_master1_archived';
                    detailTbl = 'tbl_tab_detail1_archived';
                }
            }
            if (masterTbl != "" && detailTbl != "") {
                const IBalanceOPC = new BalanceOPCInterface();
                let masterDataobj = {
                    str_tableName: masterTbl,
                    data: '*',
                    condition: [
                        { str_colName: 'RepSerNo', value: repSrNo, comp: 'eq' },
                    ]
                }
                let detailDataobj = {
                    str_tableName: detailTbl,
                    data: '*',
                    condition: [
                        { str_colName: 'RepSerNo', value: repSrNo, comp: 'eq' },
                    ]
                }
                let masterData = await database.select(masterDataobj);
                let DetailData = await database.select(detailDataobj);
                masterData = masterData[0][0];
                DetailData = DetailData[0];
                IBalanceOPC.BalanceTags.strTest = ReportOption;
                IBalanceOPC.BalanceTags.strProductName = masterData.ProductName;
                IBalanceOPC.BalanceTags.strDate = masterData.PrDate;
                IBalanceOPC.BalanceTags.strStartTime = masterData.PrTime;
                IBalanceOPC.BalanceTags.strEndTime = masterData.PrEndTime;
                IBalanceOPC.BalanceTags.intNos = masterData.Qty;
                IBalanceOPC.BalanceTags.strBatchNo = masterData.BatchNo;
                IBalanceOPC.BalanceTags.strSide = masterData.Side;
                IBalanceOPC.BalanceTags.strLot = masterData.Lot;

                const values = [];
                var Result = "Pass";
                var aboveBelowT1 = 0;
                // var sum = 0;
                for (const val of DetailData) {
                    values.push(val.DataValue);
                    if ((val.DataValue > masterData.T1PosTol && val.DataValue < masterData.T2PosTol)
                        || (val.DataValue < masterData.T1NegTol && val.DataValue > masterData.T2NegTol)) {
                        aboveBelowT1 = aboveBelowT1 + 1;
                    }

                    if (val.DataValue > masterData.T2PosTol || val.DataValue < masterData.T2NegTol) {
                        Result = "Fail";
                    }
                }

                if (aboveBelowT1 > 3) {
                    Result = "Fail";
                }

            
                let sum = values.reduce((previous, current) => current += previous);
                let avg = sum / values.length;
                IBalanceOPC.BalanceTags.intMaximumInd = Math.min(...values);
                IBalanceOPC.BalanceTags.intMinimumInd = Math.max(...values);
                IBalanceOPC.BalanceTags.intAverage = avg;
                IBalanceOPC.BalanceTags.strResult = Result;
                let opcResponse = await objOPC.exportToOPC_Balance("24018", IBalanceOPC.BalanceTags);
                let responseObj = {};
                if (opcResponse.status == 'success') {
                    Object.assign(responseObj, { status: 'success', msg: 'OPC data posted', body:opcResponse.body });
                    return responseObj;
                } else { 
                    Object.assign(responseObj, { status: 'fail', msg: 'Fail to Post OPC data',body:'Some tag getting null or undefined' });
                    return responseObj;
                }
            } else {
                Object.assign(responseObj, {status:'fail', msg:'Invalid condition', body:'Table Not found'} );
                return responseObj;
            }
        } catch (err) { 
            throw new Error(err);
        }
    }
}
module.exports = OPCModel;