const date = require('date-and-time')
const Database = require('../database/clsQueryProcess');
const database = new Database();
const clsQueryBuilder = require('../database/clsQueryTransactProcess');
const sequelize = require('sequelize');
const ObjQueryBuilder = new clsQueryBuilder();
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");

class VernierModel {
async getVernier() {
    try {
        var vernierWeight = [];
        var  result = await models.tbl_vernier.findAll();
        var data = [];
        if(result.length > 0)
        {
            data = result;
            var  result1 = await models.tbl_vernier_blocks.findAll();
            vernierWeight = result1;
            for (let i = 0; i < data.length; i++)
            {
                let vernierId = data[i].VernierID;
                let weightDetails = vernierWeight.filter(k => k.ver_ID === vernierId);
                let obj_verDetail = { 'WtDetail': weightDetails }
                Object.assign(data[i], obj_verDetail);
            }

        }

        return data;
    } catch (error) {
        console.log(error);
        throw error;
    }
}
    
async storeVernier(req) {
    try{
        var responseObj = {};
        var now = new Date();
        const vernierObj = {
            str_tableName: 'tbl_vernier',
            data: '*',
            condition: [
                { str_colName: 'VernierID', value: req.body.vernierCode, comp: 'eq' },
            ]
        }
        var result = await database.select(vernierObj);
        if (result[0].length > 0) {
            Object.assign(responseObj, { status: 'success' }, { result: 'Vernier Already Exist' });
            return responseObj;
        } else {
            var storetype = req.body.cal_store_type;
            var calDate = req.body.cal_dates;
            var storeType, calibrationDate, calibrationDueDate, calibrationDuration;
            if (storetype == "set_days") {
                storeType = 1;
                calibrationDueDate = req.body.calibration_date;
                calibrationDate = '';
                calibrationDuration = req.body.duration;
            }
            else {
                storeType = 0;
                calibrationDueDate = 0;
                calibrationDate = calDate.toString();
                calibrationDuration = 0;
            }
            var weights = req.body.weights;
            var parameterOrg = JSON.stringify(weights);
            var paramOrg1 = parameterOrg.split(',');
            var count = weights.length;
            
            const insertVernierObj = {
                str_tableName: 'tbl_vernier',
                data: [
                    { str_colName: 'VernierNo', value: req.body.vernierSerialNo },
                    { str_colName: 'VernierID', value: req.body.vernierCode },
                    { str_colName: 'Model', value: req.body.vernierModelNo },
                    { str_colName: 'leastCount', value: req.body.leastCount },
                    { str_colName: 'RangeUnit', value: req.body.unit },
                    { str_colName: 'RangeMinVal', value: req.body.minRange },
                    { str_colName: 'RangeMaxVal', value: req.body.maxRange },
                    { str_colName: 'CalDueDT', value: calibrationDueDate },
                    { str_colName: 'CalDuration', value: calibrationDuration },
                    { str_colName: 'Caldates', value: calibrationDate },
                    { str_colName: 'CalibStoreType', value: storeType },
                    { str_colName: 'CalReminder', value: req.body.set_reminder },
                    { str_colName: 'Ver_Dept', value: 'NA' },
                    { str_colName: 'userID', value: req.body.LoggeduserId },
                    { str_colName: 'Ver_IsCalib', value: 1 },
                    { str_colName: 'Ver_IsNew', value: 1 },
                    { str_colName: 'ver_DP', value: req.body.int_dp },
                    { str_colName: 'Make', value: req.body.vernierMake }
                    
                ]
            }
            var result1 = await database.save(insertVernierObj);
            for (var i = 0; i < count; i++) {
                var stdwt = weights[i].stdBlock;
                var negTol = weights[i].negTol;
                var posTol = weights[i].posTol;
                var periodic = weights[i].periodic;
                var periodicValue;
                if (periodic == true) {
                    periodicValue = 1;
                } else {
                    periodicValue = 0;
                }
                const vernierWtObj = {
                    str_tableName: 'tbl_vernier_blocks',
                    data: [
                        { str_colName: 'ver_ID', value: req.body.vernierCode },
                        { str_colName: 'Ver_StdBlock', value: stdwt },
                        { str_colName: 'Ver_NegTol', value: negTol },
                        { str_colName: 'Ver_PosTol', value: posTol },
                        { str_colName: 'Ver_blnPeriodic', value: periodicValue }
                    ]
                }
                var result2 = await database.save(vernierWtObj);
            }
            var strChangedWts;
            var res = await this.getVernierAuditWeightData(req);
            strChangedWts = res;
            const insertAuditVernierObj = {
                str_tableName: 'tbl_audit_vernier',
                data: [
                    { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: req.body.LoggeduserId },
                    { str_colName: 'username', value: req.body.Loggedusername },
                    { str_colName: 'ACT', value: req.body.hdnAction },
                    { str_colName: 'Remark', value: req.body.remark },
                    { str_colName: 'VernierID', value: req.body.vernierCode },
                    { str_colName: 'NewParameter', value: req.body.newParameter },
                    { str_colName: 'NewWeight', value: strChangedWts }
                ]
            }
            var result3 = await database.save(insertAuditVernierObj);
            const vernierActivity = {
                str_tableName: 'tbl_activity_log',
                data: [
                    { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: req.body.LoggeduserId },
                    { str_colName: 'username', value: req.body.Loggedusername },
                    { str_colName: 'activity', value: 'Vernier Added' }
                ]
            }
            var result4 = await database.save(vernierActivity);
            Object.assign(responseObj, { status: 'success' }, { result: 'Vernier Added Successfully' })
            return responseObj;
        }
    }catch(error){
        console.log(error);
        throw error;
    }
}

updateLockVernier(req) {
    return new Promise((resolve, reject) => {
        let responseObj = {};
        var type = req.body.type;
        if (type == "Edit") {
            const updateLockObj = {
                str_tableName: 'tbl_vernier',
                data: [
                    { str_colName: 'locked', value: 1 }
                ],
                condition: [
                    { str_colName: 'VernierID', value: req.body.vernierID },
                ]
            }
            database.update(updateLockObj).catch(err => console.log(err));
            Object.assign(responseObj, { status: 'success' }, { result: 'Vernier lock updated' })
            resolve(responseObj)
        } else {
            const updateLockObj = {
                str_tableName: 'tbl_vernier',
                data: [
                    { str_colName: 'locked', value: 0 }
                ],
                condition: [
                    { str_colName: 'VernierID', value: req.body.vernierID },
                ]
            }
            database.update(updateLockObj).catch(err => console.log(err));
            Object.assign(responseObj, { status: 'success' }, { result: 'Vernier lock deleted' })
            resolve(responseObj)
        }
    })
}

async updateVernier(req) {
    try{
        var responseObj = {};
        var now = new Date();
        var storetype = req.body.cal_store_type;
        var calDate = req.body.cal_dates;
        var storeType, calibrationDate, calibrationDueDate, calibrationDuration;
        if (storetype == "set_days") {
            storeType = 1;
            calibrationDueDate = req.body.calibration_date;
            calibrationDate = '';
            calibrationDuration = req.body.duration;
        }
        else {
            storeType = 0;
            calibrationDueDate = 0;
            calibrationDate = calDate.toString();
            calibrationDuration = 0;
        }
        var weights = req.body.weights;
        var count = weights.length;
        

        const insertVernierObj = {
            str_tableName: 'tbl_vernier',
            data: [
                { str_colName: 'VernierNo', value: req.body.serialNo },
                { str_colName: 'Model', value: req.body.modelNo },
                { str_colName: 'leastCount', value: req.body.leastCount },
                { str_colName: 'RangeUnit', value: req.body.selectedUnit },
                { str_colName: 'RangeMinVal', value: req.body.minRange },
                { str_colName: 'RangeMaxVal', value: req.body.maxRange },
                { str_colName: 'CalDueDT', value: calibrationDueDate },
                { str_colName: 'CalDuration', value: calibrationDuration },
                { str_colName: 'Caldates', value: calibrationDate },
                { str_colName: 'CalibStoreType', value: storeType },
                { str_colName: 'CalReminder', value: req.body.set_reminder },
                { str_colName: 'Ver_Dept', value: 'NA' },
                { str_colName: 'ver_DP', value: req.body.bal_dp },
                { str_colName: 'Make', value: req.body.vernierMake }
            ],
            condition: [
                { str_colName: 'VernierID', value: req.body.vernierCode }
            ]
        }
        var result = await database.update(insertVernierObj);
        const deleteVernierObj = {
            str_tableName: 'tbl_vernier_blocks',
            condition: [
                { str_colName: 'ver_ID', value: req.body.vernierCode }
            ]
        }
        var result1 = await database.delete(deleteVernierObj);
            for (var i = 0; i < count; i++) {
                var stdwt = weights[i].std_wt;
                var negTol = weights[i].neg_Tol;
                var posTol = weights[i].pos_Tol;
                var periodic = weights[i].periodic;
                var periodicValue;
                if ((periodic == true) || (periodic == 1)) {
                    periodicValue = 1;
                } else {
                    periodicValue = 0;
                }
                const vernierWtObj = {
                    str_tableName: 'tbl_vernier_blocks',
                    data: [
                        { str_colName: 'ver_ID', value: req.body.vernierCode },
                        { str_colName: 'Ver_StdBlock', value: stdwt },
                        { str_colName: 'Ver_NegTol', value: negTol },
                        { str_colName: 'Ver_PosTol', value: posTol },
                        { str_colName: 'Ver_blnPeriodic', value: periodicValue }
                    ]
                }
                var result2 = await database.save(vernierWtObj);
            }
        const insertAuditVernierObj = {
            str_tableName: 'tbl_audit_vernier',
            data: [
                { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                { str_colName: 'userid', value: req.body.LoggeduserId },
                { str_colName: 'username', value: req.body.Loggedusername },
                { str_colName: 'ACT', value: req.body.hdnAction },
                { str_colName: 'Remark', value: req.body.remark },
                { str_colName: 'VernierID', value: req.body.vernierCode },
                { str_colName: 'OldParameter', value: req.body.oldParameter },
                { str_colName: 'NewParameter', value: req.body.newParameter },
                { str_colName: 'OldWeight', value: req.body.oldWeights  },
                { str_colName: 'NewWeight', value: req.body.newWeights  }
            ]
        }
        var result3 = await database.save(insertAuditVernierObj);
        const vernierActivity = {
            str_tableName: 'tbl_activity_log',
            data: [
                { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                { str_colName: 'userid', value: req.body.LoggeduserId },
                { str_colName: 'username', value: req.body.Loggedusername },
                { str_colName: 'activity', value: 'Vernier Updated' }
            ]
        }
        var result4 = await database.save(vernierActivity);
        Object.assign(responseObj, { status: 'success' }, { result: 'Vernier Updated Successfully' })
        return responseObj;

    }catch(error){
        return error;
    }
}

getVernierAuditWeightData(req)
{
    return new Promise((resolve, reject) =>
    {
        var weights = req.body.weights;
        var strPeriodicName = req.body.strPeriodicName;

        var strDaily = "";
        var strLin = "";
        var strEcc = "";
        var rep = "";
        var per = "";
        var uncer = "";
        var i = 0;
        weights.forEach(function (element)
        {
            // if (element.daily == true)
            // {
            //    if (strDaily == "") 
            //    {
            //        (element.daily == true) ? strDaily = "Daily:" : "";
            //    }
            //     strDaily = strDaily + " Standard Block:" + element.stdBlock + ",";
            //     strDaily = strDaily + "(-)Tolerance:" + element.neg_Tol + ",";
            //     strDaily = strDaily + "(+)Tolerance:" + element.pos_Tol;
            // }
            // if (element.linerity == true)
            // {
            //     if (strLin == "") 
            //    {
            //     (element.linerity == true) ? strLin = " | Linearaity:" : "";
            //    }
            //     strLin = strLin + " Standard Weight:" + element.stdBlock + ",";
            //     strLin = strLin + "(-)Tolerance:" + element.neg_Tol + ",";
            //     strLin = strLin + "(+)Tolerance:" + element.pos_Tol;
            // }
            if (element.periodic == true)
            {
                if (per == "") 
                {
                     (element.periodic == true) ? per = " "+ strPeriodicName + ":" : "";
                }
                per = per + " Standard Block:" + element.stdBlock + ",";
                per = per + "(-)Tolerance:" + element.negTol + ",";
                per = per + "(+)Tolerance:" + element.posTol+ "|";
            }
            // if (element.eccentricity == true)
            // {
            //     if (strEcc == "") 
            //     {
            //         (element.eccentricity == true) ? strEcc = " | Eccentricity:" : "";
            //     }
            //     strEcc = strEcc + " Standard Weight:" + element.stdBlock + ",";
            //     strEcc = strEcc + "(-)Tolerance:" + element.neg_Tol + ",";
            //     strEcc = strEcc + "(+)Tolerance:" + element.pos_Tol;
            // }
            // if (element.repetability == true)
            // {
            //     if (rep == "") 
            //     {
            //         (element.repetability == true) ? rep = " | Repetability:" : "";
            //     }
            //     rep = rep + " Standard Weight:" + element.stdBlock + ",";
            //     rep = rep + "(-)Tolerance:" + element.neg_Tol + ",";
            //     rep = rep + "(+)Tolerance:" + element.pos_Tol;
            // }
            // if (element.uncertainty == true)
            // {
            //     if (uncer == "") 
            //     {
            //         (element.uncertainty == true) ? uncer = " | Uncertainty:" : "";
            //     }
            //     uncer = uncer + " Standard Weight:" + element.stdBlock + ",";
            //     uncer = uncer + "(-)Tolerance:" + element.neg_Tol + ",";
            //     uncer = uncer + "(+)Tolerance:" + element.pos_Tol;
            // }

            i++;

        });
        //var final = strDaily + strLin + strEcc + rep + per + uncer;
        var final =  per ;

        //var newStr = final.substring(1, final.length);
        var newStr = final.substring(0, final.length - 1);

        resolve(newStr);

    })
}

async updateWithoutWeight(value) {
    try{
        var transactionRep = await seqTransaction.sequelize.transaction( async (t) => {
            var responseObj = {};
            var now = new Date();
            const objTranactionQry = [];


            const updateVernierObj = {
                str_tableName: 'tbl_vernier',
                data: [
                    { str_colName: 'VernierNo', value: value.vernierSerialNo.trim() },
                    { str_colName: 'Model', value: value.vernierModelNo.trim() },
                    { str_colName: 'leastCount', value: value.leastCount },
                    { str_colName: 'RangeUnit', value: value.unit },
                    { str_colName: 'RangeMinVal', value: value.minRange },
                    { str_colName: 'RangeMaxVal', value: value.maxRange },
                    { str_colName: 'ver_DP', value: value.int_dp},
                    { str_colName: 'Make', value: value.vernierMake}
                ],
                condition: [
                    { str_colName: 'VernierID', value: value.vernierCode }
                ],
                action: "up"
            }

            await models.tbl_vernier.update({
                VernierNo: value.vernierSerialNo.trim(),
                Model: value.vernierModelNo.trim(),
                leastCount: value.leastCount,
                RangeUnit: value.unit,
                RangeMinVal: value.minRange,
                RangeMaxVal: value.maxRange,
                ver_DP: value.int_dp,
                Make: value.vernierMake
            },{
                where:{ VernierID :  value.vernierCode},
                transaction: t
            })
            
            await models.tbl_audit_vernier.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: value.LoggeduserId,
                username: value.Loggedusername,
                ACT: value.hdnAction,
                Remark: value.remark,
                VernierID: value.vernierCode.trim(),
                OldParameter: value.oldParameters,
                NewParameter: value.newParameters,
            },{
                transaction: t
            })
                
            await models.tbl_activity_log.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: value.LoggeduserId,
                username: value.Loggedusername,
                activity: 'Vernier Updated'
            })

            Object.assign(responseObj, { status: 'success' }, { result: 'Vernier Updated Successfully' })
            return responseObj;
        });

        return transactionRep;
    }catch(error){
        console.log(error);
        throw error;
    }
}
   
async updateStatus(value){
    try{
        var transactionRes = await seqTransaction.sequelize.transaction( async (t) => {
            const responseObj = {};
            var now = new Date();
            var action = value.action;
            var status;
            var approval;
            if (action == 'Activate') {
                status = 1;
                approval = 1;
            } else {
                status = 0;
            }

            var vernierID = value.vernierID;
            var userId = value.userId
            var userName = value.userName;
            var remark = value.remark;
            var vernierData = await this.getVernierIdData(vernierID);
            
            let obj_vernier = {};
            if(vernierData[0].Ver_IsApproved == 0 && action == 'Activate')
            {
                Object.assign(obj_vernier,{ Ver_IsApproved:approval,Ver_ApprovedBy:userId });
            }

            Object.assign(obj_vernier,{ Ver_IsActivate : status});

            await models.tbl_vernier.update(obj_vernier,{
                where: { VernierID: vernierID },
                transaction:t
            });


            await models.tbl_audit_vernier.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: userId,
                username: userName,
                Remark: remark,
                ACT: action,
                VernierID: vernierID,
                OldParameter: 'NA',
                NewParameter: 'NA',
                OldWeight: 'NA',
                NewWeight: 'NA'
            },{
                transaction:t
            })

            var statusRes;
            if (action == 'Activate') {
                statusRes = 'Vernier Activated Successfully';
            } else {
                statusRes = 'Vernier Deactivated Successfully';
            }
            Object.assign(responseObj, { status: 'success' }, { result: statusRes })
            return responseObj;
        });

        return transactionRes;
        
    }catch(error){
        console.log(error);
        throw error;
    }
}

async getVernierIdData(vernierID) {
    try{
        var result = await models.tbl_vernier.findAll({
            where: { VernierID:vernierID }
        });

        if(result.length > 0){
            return result;
        }else{
            return false;
        }

    }catch(error){
        console.log(error);
        throw error;
    }
}

async addVernier(withoutCalibration,req) {
    try{
        var responseObj = {};
        var now = new Date();
        
        var transactionRes = await seqTransaction.sequelize.transaction( async (t) => {

            var result = await models.tbl_vernier.findAll({
                where: { VernierID :  withoutCalibration.vernierCode }
            });

            if(result.length > 0){
                Object.assign(responseObj, { status: 'success' }, { result: 'Vernier Already Exist' });
                return responseObj;
            }else{
                await models.tbl_vernier.create({
                    VernierID: withoutCalibration.vernierCode.trim(),
                    Model: withoutCalibration.vernierModelNo.trim(),
                    VernierNo: withoutCalibration.vernierSerialNo.trim(),
                    leastCount: withoutCalibration.leastCount,
                    RangeUnit: withoutCalibration.unit,
                    RangeMinVal: withoutCalibration.minRange,
                    RangeMaxVal: withoutCalibration.maxRange,
                    ver_DP: req.body.int_dp,
                    userID: withoutCalibration.LoggeduserId,
                    Make: withoutCalibration.vernierMake
                },{
                    transaction:t
                });

                await models.tbl_audit_vernier.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: withoutCalibration.LoggeduserId,
                    username: withoutCalibration.Loggedusername,
                    ACT: withoutCalibration.hdnAction,
                    Remark: withoutCalibration.remark,
                    VernierID: withoutCalibration.vernierCode.trim(),
                    OldParameter: withoutCalibration.oldParameters,
                    NewParameter: withoutCalibration.newParameters,
                },{
                    transaction:t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: withoutCalibration.LoggeduserId,
                    username: withoutCalibration.Loggedusername,
                    activity: 'Vernier Added',
                },{
                    transaction:t
                });

                Object.assign(responseObj, { status: 'success' }, { result: 'Vernier Added Successfully' });
                return responseObj;
            }
        });

        return transactionRes;

    }catch(error){
        console.log(error);
        throw error;
    }
}

getWithoutWeightStatus() {
    return new Promise((resolve, reject) => {
        models.tbl_vernier.findAll({}).then( res => {
            resolve(res);
        }).catch( err => {
            reject(err)
        })
        // dbCon.execute("SELECT * FROM `tbl_vernier`").then((result1) => {
        //     resolve(result1)
        // }).catch(err => {
        //     reject("Error : " + err)
        // })
    });
}

async checkInCubicle(req)
{
    try{
        let obj_res = {};
        let verID = req.body.vernierID;
        var arr_cubicle = [];
        // let res = await dbCon.execute("select * from tbl_cubical where Sys_VernierID='"+ verID +"'");
        let res = await models.tbl_cubical.findAll({ where : { Sys_VernierID: verID}});
        if(res.length > 0)
        {
            // let res_getCubicles = await dbCon.execute(`SELECT IDSFrom,IDSTo FROM tbl_cubicle_area WHERE Area='${res[0][0]['Sys_Area']}'`);
            let res_getCubicles = await models.tbl_cubicle_area.findAll({
                attributes:['IDSFrom','IDSTo'],
                where: { Area : res[0].Sys_Area}
            })

            for(let i=res_getCubicles[0]['IDSFrom'];i<=res_getCubicles[0]['IDSTo'];i++)
            {
                arr_cubicle.push(i);
            }
            let int_no = arr_cubicle.indexOf(res[0]['Sys_CubicNo']) + 1;
            obj_res = {'Sys_Area':res[0]['Sys_Area'],"Sys_CubicNo":int_no}; 
        }
        else
        {
            obj_res = null;
        }
       
        return obj_res;
    }catch(error){
        console.log(error);
        throw error;
    }
    
}

    
}
module.exports = VernierModel;