
const date = require('date-and-time')
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");

class StageModel {
    /**
     *This function is used to get all stages
     * @memberof StageModel
     */
    async getStage(){
        try {
            let result = await models.tbl_stages.findAll();
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
        
    }

     /**
     *This function is used to store the stage data
     * @param {*} req = Currnet Request to fetch the params from it 
     * @returns Object { status: 'success / Error' }, { result: 'Msg' } 
     * @memberof StageModel
     */
   async storeStage(req){
       try {
            var obj_response = {}; 
            /** Get stage to check that stage is exist or not in table */
            let resExist = await models.tbl_stages.findAll({where:
                { Stage: req.body.Stage }
            });
            if(resExist.length != 0){
                var obj_response = {}; 
                Object.assign(obj_response, { status: 'success' }, { result: 'Stage already exist' })
                return obj_response;
            }
            else
            {
                let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                   
                    let now = new Date();
                await models.tbl_stages.create({
                    Stage: req.body.Stage
                },{
                    transaction: t
                });
    
                await models.tbl_audit_stages.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userid,
                    username: req.body.username,
                    Stage: req.body.Stage,
                    Remark: req.body.Remark,
                    ACT: req.body.Action
                },{
                    transaction: t
                });
    
                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userid,
                    username: req.body.username,
                    activity: req.body.activity
                },{
                    transaction: t
                    });
                });
                Object.assign(obj_response, { status: 'success' }, { result: 'Stage Added Successfully' });
                return  obj_response;
            }
          
       } catch (error) {
        console.log("Add Stage",error);
        return error;
       }
    }
}

module.exports = StageModel;