const dbcon = require('../Utills/db');
const date = require('date-and-time');
const Database = require('../database/clsQueryProcess');
const database = new Database();

var models = require("../dbConnection").models;

class PwdComplexityModel {

    //Fetched all password complexity details
    async getPassword() 
    {
        try {
            let obj_response = {};
            let result = await models.tbl_pwd_complexity.findAll();
            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;
        } catch (error) {
            return error;
        }
    }

    //update password complexity, insert in audit trail & activity log
    async updatePassword(value) 
    {
        try
        {
            let responseObj = {};
            let now = new Date();

            //update password complexity
            const Obj_UpdatePassComplex = await models.tbl_pwd_complexity.update
            (
                {
                    Pwd_Length : value.passwordLength,
                    Pwd_SpecialChr : value.specialCharacters,
                    Pwd_Alphabate:value.alphabetUppercase,
                    Pwd_Digit:value.numericLength
                },
                {
                    where: {Pwd_id:value.Pwd_id}
                }
            );

            //insert in audit trail
            const obj_InsertPassComplex = await models.tbl_audit_pwd_complexity.create
            ({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'HH:mm:ss'),
                userid:value.userId,
                username:value.userName,
                act:value.action,
                oldvalues:value.oldData,
                newvalues:value.newData,
                remark:value.remark
            });

            //insert in activity log
            const obj_InsertParameterActivity = await models.tbl_activity_log.create({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'HH:mm:ss'),
                userid:value.userId,
                username:value.userName,
                activity:'Password Complexity Updated'
            });

            Object.assign(responseObj, { status: 'success' }, { result: 'Password Complexity Updated Successfully' })
            return responseObj;
        }
        catch(error)
        {
            return error;
        } 
    }
}
module.exports = PwdComplexityModel;