const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");

class MediaModel {

    async getMedia(){
        try {
            let result = await models.tbl_dtmedia.findAll();
            return result;
        } catch (error) {
            return error;
        }
    }

    async storeMedia(req)
    {
        try {
            var obj_response = {}; 
            /** Get stage to check that stage is exist or not in table */
            let resExist = await models.tbl_dtmedia.findAll({where:
                { Media: req.body.Media }
            });
            if(resExist.length != 0){
                var obj_response = {}; 
                Object.assign(obj_response, { status: 'success' }, { result: 'Media already exist' })
                return obj_response;
            }
            else
            {
                let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                   
                    let now = new Date();
                await models.tbl_dtmedia.create({
                    Media: req.body.Media
                },{
                    transaction: t
                });
    
                await models.tbl_audit_dtmedia.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userid,
                    username: req.body.username,
                    Media: req.body.Media,
                    Remark: req.body.Remark,
                    ACT: req.body.Action
                },{
                    transaction: t
                });
    
                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userid,
                    username: req.body.username,
                    activity: req.body.activity
                },{
                    transaction: t
                    });
                });

                Object.assign(obj_response, { status: 'success' }, { result: 'Media Added Successfully' })
                return  obj_response;
            }
        } catch (error) {
            console.log("Add Media",error);
            return error;
        }
    }

}

module.exports = MediaModel;