const fs = require('fs');
const serverConfig = require('../global/serverConfig');
const models = require("../dbConnection").models;
var obj_rpt_path = {};
const axios = require('axios').default;
const timeZone = require('../middleware/setTimeZone');
/**
 * This class is used to get details from project config and display when required.
 */
class SystemPrechecks { 
    /**
     * Main Function `getSystemPrechecks`()
     * Returns Object as API Response
     * Rest others are supporting functions to the main function.
     */
    async getSystemPrechecks()
    {
        try {
            var responseObj = {};
        var statusObj = {};
        var configurationObj = {};
        var SystemAuthenticationType = await this.getSystemAuthentication();
        var DBConnectionStatus = await this.getDBConnectionStatus();
        var ConfigPath =  await this.getConfigPath();
        var ConfigPathVerificationStatus = await this.verifyConfigPath(ConfigPath);
        var ReportPath =  await this.getReportPath();
        var ReportPathVerificationStatus = await this.verifyReportPath(ReportPath);
        var ReportHost = await this.getReportHost();
        var ReportHostVerificationStatus =  await this.verifyReportHost(ReportHost);
        var dbObject = await this.getDatabaseDetails();
        var apiObject = await this.getAPIDetails();
        var obj_getDateTime = await this.getDateTime();

        Object.assign(statusObj,{'DBConnectionStatus':DBConnectionStatus},
            {'ReportHostVerificationStatus':ReportHostVerificationStatus},
            {'ReportPathVerificationStatus':ReportPathVerificationStatus},
            {'ConfigPathVerificationStatus':ConfigPathVerificationStatus});
        Object.assign(configurationObj,{'Config_ReportHost':ReportHost},
            {'DB_ReportPath':ReportPath},
            {'DB_ConfigPath':ConfigPath}); 
        Object.assign(responseObj,
            {'SystemAuthenticationType':SystemAuthenticationType},
            {'Status':statusObj},
            {'Configuration':configurationObj},
            {'Database':dbObject},
            {'API':apiObject},
            {'TimeDate':obj_getDateTime});
        return responseObj; 
        } catch (error) {
            console.log(error)
        }
    }

    async getDateTime()
    {
        // Set Time zone here
        let now = new Date();
        let timeDate = timeZone.convertDateTime(now);
        return timeDate;
    }

    getSystemAuthentication()
    {
        return (serverConfig.isLDAP == true)? 'LDAP' : 'NLDAP';
    }

    getDBConnectionStatus()
    { 
        return new Promise((resolve, reject)=>{
                models.tbl_rpt_path.findOne().then(res=>{
                    obj_rpt_path = res
                    resolve("Connected"); 
                });
                
            });
    }

    getReportPath()
    {
        return obj_rpt_path.path;
    }

    verifyReportPath(path)
    {
        return new Promise ((resolve,reject)=>{
            try {
                if (fs.existsSync(path)) {
                    resolve('Report Path Exists')
                }
                else
                {
                    resolve('Report Path NOT Exists')
                }
              } catch(err) {
                console.error(err)
                resolve('Report Path NOT Exists')
            }
        })
    }

    getDatabaseDetails()
    {
        return new Promise((resolve,reject)=>{
            var dbObjectReturn = {};
            Object.assign(dbObjectReturn, {'Database':serverConfig.dbName},
            {'Database Host':serverConfig.dbHost},
            {'Database User':serverConfig.dbUser});
            resolve(dbObjectReturn);
        });
    }

    getAPIDetails()
    {
        return new Promise((resolve,reject)=>{
            var apiObjectReturn = {};
            Object.assign(apiObjectReturn, {'Host':serverConfig.host},
            {'Host API':serverConfig.hostApi});
            resolve(apiObjectReturn);
        });
    }

    getConfigPath()
    {
        return obj_rpt_path.Comp_name;
    }

    verifyConfigPath(path)
    {
        return new Promise((resolve,reject)=>{
            try {
                if (fs.existsSync(path)) {
                    resolve('Config Path Exists')
                }
                else
                {
                    resolve('Config Path NOT Exists')
                }
              } catch(err) {
                console.error(err)
                resolve('Config Path NOT Exists')
            }
        })
    }

    getReportHost()
    {
        return serverConfig.reporthost;
    } 

    async verifyReportHost(url)
    {   
        let response = await this.verifyUrlIfExists(url);
        return (response.status == '200') ?
       "Report Host Exists":
        (response.code == 'ECONNREFUSED') ? "Report Host NOT Exists" : "Report Host NOT Exists" + response;

    }

    async verifyUrlIfExists(url)
    {         
        try {
            let res =  await axios.get(url);
            return res;
        } catch(err) {
            return err;
        }
    }
}

module.exports = SystemPrechecks;