const dbcon = require('../Utills/db')
const date = require('date-and-time')
let in_array = require('in_array');
const Database = require('../database/clsQueryProcess');
const database = new Database();
const requestIp = require('request-ip');
const models = require("../dbConnection").models;
const sequelize = require('./../dbConnection').sequelize;
const { Op } = require("sequelize");
const { QueryTypes } = require('sequelize');

class RoleModel {

    async getRoleName(){
        try {
            let obj_response = {};
            let result = await models.tbl_role.findAll({
                attributes: [[sequelize.fn('DISTINCT', sequelize.col('role_name')), 'role_name']]
            });
            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;
        } catch (error) {
            return error;
        }
        
    }

    async getRight() {
        try {
            let obj_response = {};
            const result = await models.tbl_role.findAll({
                where: {
                    Visibility: 1
                }
            });
            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;
        } catch (error) {
           return error; 
        }
    }

  async getRole() {
      try{
        let responseObj = {};
        const result = await models.tbl_role.findAll({
            attributes : [ 'role_name' ],
            group: ['role_name']
           })
           Object.assign(responseObj, { status: 'success' }, { result: result })
           return responseObj;
      }catch(error){
          return error;
      }
    }

async getRoleGroup(){
    try {
        let responseObj = {};
        let data = {}
        let strCombinedRoles;

        if (sequelize.options.dialect === 'mssql') {
            strCombinedRoles = ` STRING_AGG(role_rights, ',') `;
        } else { // For mysql
            strCombinedRoles = ` GROUP_CONCAT(role_rights) `;
        }

        let str_query = `SELECT ${strCombinedRoles} as rights,role_name from tbl_role where role_name <> 'SuperAdmin' GROUP BY role_name `;
        var result = await sequelize.query(str_query,{ type: QueryTypes.SELECT });

        data = result;
        let roleName = [], roleLock = [], roleRights = []; 
        let finalArray = [];
        for(let i = 0; i < data.length; i++){
            roleName.push(data[i].role_name)
            // roleLock.push(data[i].locked.readUIntLE())
            roleRights.push(data[i].rights.split(','))
        }
        for(let j = 0; j < roleName.length; j++){
            let roleRightArray = {'roleName':roleName[j], 'roleRight':roleRights[j]};
            finalArray.push(roleRightArray);
        }
        Object.assign(responseObj, { status: 'success' }, { result: finalArray })
        return responseObj;
    } catch (error) {
        return error;
    }
}

    async getRoleRight(role) {
        try {
            let responseObj = {};
            let result = await models.tbl_role.findAll({ 
                where:{role_name:role}
            });
            Object.assign(responseObj, { status: 'success' }, { result: result })
            return responseObj;
        } catch (error) {
            return error;
        }
    }
    
 async storeRole(value) {
        try {
            let responseObj = {};
            let now = new Date();
            let roleName = value.roleName;
            let roleRight = value.roleRights;
            let auditRight = roleRight.toString();
            const result = await models.tbl_role.findAll({
                where: {
                    role_name: roleName
                }
            });
                
            if (result.length != 0)
            {
                Object.assign(responseObj, { status: 'success' }, { result: 'Role Already Exist' });
                return responseObj;
            }else{
                for (let i = 0; i < roleRight.length; i++) {
                    let right = roleRight[i];
                    const obj_InsertRole = await models.tbl_role.create({
                        role_name : roleName,
                        role_rights : right,
                        locked : 0,
                        editCounter : 0
                    });
                }

                const obj_InsertAuditRole = await models.tbl_audit_role.create({
                    DT : date.format(now, 'YYYY-MM-DD'),
                    TM : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                    userid : value.userId,
                    username : value.userName,
                    Remark:value.remark,
                    ACT:value.action,
                    RoleName:roleName,
                    old_add_user_assign_roles:0,
                    new_add_user_assign_roles:0,
                    RightAdded:auditRight,
                    RightRemoved:'NA'
                });

                const obj_InsertActivityRole = await models.tbl_activity_log.create({
                    dt : date.format(now, 'YYYY-MM-DD'),
                    tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                    userid : value.userId,
                    username : value.userName,
                    activity:'Role Added'
                });
                Object.assign(responseObj, { status: 'success' }, { result: 'Role Added Successfully' })
                return responseObj;
            }
        } catch (error) {
            return error;
        }
    }

  async updateRole(value) {
        try {
            let responseObj = {};
            let now = new Date();
            let roleName = value.roleName;
            let roleRight = value.roleRights;
            let removeRight = [];
            let addRight = [];
            var auditRemoveRight;
            var auditAddRight;
            let strCombinedRoles;

            if (sequelize.options.dialect === 'mssql') {
                strCombinedRoles = ` STRING_AGG(role_rights, ',') `;
            } else { // For mysql
                strCombinedRoles = ` GROUP_CONCAT(role_rights) `;
            }

            let str_query = `SELECT ${strCombinedRoles} as rights,role_name from tbl_role where role_name = '${roleName}' GROUP BY role_name`;
            var result = await sequelize.query(str_query,{ type: QueryTypes.SELECT });

            let data = [];
            data = result[0];
            let right = data.rights;
            let preRight = right.split(",");

            for (let i = 0; i < preRight.length; i++) {
                let previousright = preRight[i];
                let valuePreRights = in_array(previousright, roleRight);
                if (valuePreRights == false) {
                    removeRight.push(previousright);
                }
            }
            for (let j = 0; j < roleRight.length; j++) {
                let newRight = roleRight[j];
                let valueNewRights = in_array(newRight, preRight);
                if (valueNewRights == false) {
                    addRight.push(newRight);
                }
            }

            if(removeRight.length > 0){
                auditRemoveRight = removeRight.toString();
            }else{
                auditRemoveRight = "NA";
            }
            if(addRight.length > 0){
                auditAddRight = addRight.toString();
            }else{
                auditAddRight = "NA";
            }

            const delResult = await models.tbl_role.destroy({
                where: {
                    role_name: roleName
                }
            });
            for (let i = 0; i < roleRight.length; i++) {
                let right = roleRight[i];
                const obj_InsertRole = await models.tbl_role.create({
                    role_name : roleName,
                    role_rights : right,
                    locked : 0,
                    editCounter : 0
                }); 
            }
            const obj_InsertAuditRole = await models.tbl_audit_role.create({
                DT : date.format(now, 'YYYY-MM-DD'),
                TM : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                userid : value.userID,
                username : value.userName,
                Remark:value.remark,
                ACT:value.action,
                RoleName:roleName,
                old_add_user_assign_roles:0,
                new_add_user_assign_roles:0,
                RightAdded:auditAddRight,
                RightRemoved:auditRemoveRight
            });

            const obj_InsertActivityRole = await models.tbl_activity_log.create({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                userid : value.userID,
                username : value.userName,
                activity:'Role Updated'
            });
            Object.assign(responseObj, { status: 'success' }, { result: 'Role Updated Successfully' });
            return responseObj;
        } catch (error) {
            return error;
        }   
    }

  async updateLockStatus(value) {
     try {
        var obj_response = {};
        var type = value.type;
        if(type == 'Edit'){
            await models.tbl_role.update(
                {'locked': value.lock,'editCounter':0},
                {
                    where: {role_name:value.roleName}
                });
            Object.assign(obj_response, { status: 'success' }, { result: 'Role Lock Updated Successfully' })
            return obj_response;
        } else {
            await models.tbl_role.update(
                {'locked': value.lock,'editCounter':0},
                {
                    where: {role_name:value.roleName}
                });
            Object.assign(obj_response, { status: 'success' }, { result: 'Role Lock Reset Successfully' })
            return obj_response;
        }
     } catch (error) {
         return error;
     }  
    }

  async  getUserRights(req){
       try {
        let obj_response = {};
        const result = await models.tbl_users.findAll({
            where: {
                UserID: req.body.userid
            }
        }); 
        let data = {};
        data = result[0];
        let role = data.Role;
        let userid = req.body.userid;
        let rights = [], splrights = [], removerights = [];
        var result1 = await this.userRights(role);
        var result2 = await this.userSplRight(userid);
        var result3 = await this.userRemoveRight(userid);
        for(let i = 0; i < result1.length; i++){
            rights.push(result1[i].role_rights)
        }
        for(let i = 0; i < result2.length; i++){
            splrights.push(result2[i].spl_right)
        }
        for(let i = 0; i < result3.length; i++){
            removerights.push(result3[i].removed_right)
        }

        //adding special rights and removing removed rights 
        let finalRights = rights.slice();
        finalRights.push(...splrights);
        removerights.forEach(right => {
            finalRights.splice(finalRights.indexOf(right),1);
        });
        
        let datas = {};
        Object.assign(datas, {role: role}, { rights: rights }, { splRights: splrights }, { removeRights: removerights },{finalRights : finalRights},{data:data});
        Object.assign(obj_response, { status: 'success' }, { result: datas });
        return obj_response;
       } catch (error) {
           return error;
       }
    }

    async storeTempRole(req){

      const objResult = [];

      if(req.body.str_role == "All")
      {
        const storeAllData = await this.getAllData(req);
        objResult.push(storeAllData);
      } 
      else
      {
        const storePerticularData = await this.insertInTempTable(req);
        objResult.push(storePerticularData);  
      }
      return  objResult;
    }

   async getAllData(req){
        try {
            let strCombinedRoles;
            if (sequelize.options.dialect === 'mssql') {
                strCombinedRoles = ` STRING_AGG(role_rights, ',') `;
            } else { // For mysql
                strCombinedRoles = ` GROUP_CONCAT(role_rights) `;
            }
            const str_query = `SELECT ${strCombinedRoles} as rights
                ,role_name,locked 
                from tbl_role 
                where role_rights <> 'Create Admin' 
                GROUP BY role_name,locked`;
            var result = await sequelize.query(str_query,{ type: QueryTypes.SELECT });

            //let str_query = `SELECT GROUP_CONCAT(role_rights) as rights,role_name,locked from tbl_role where role_rights <> 'Create Admin' GROUP BY role_name`;
           // var result = await sequelize.query(str_query,{ type: QueryTypes.SELECT });

            let clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3]
            if (ip === undefined) {
                ip = '127.0.0.1'
            } else {
                ip = ip
            }
            ip=ip.split('.')[3];
            let responseObj = {}
            let data = {}
            data = result;
            let roleName = [], roleRights = []; 
            let finalArray = [];
            for(let i = 0; i < data.length; i++){
                roleName.push(data[i].role_name)
                roleRights.push(data[i].rights)
            }
            const deleteTempObj = await models.tbl_assignedrolewithright.destroy({
                where: {
                    HMIID: ip
                }
            });
            for(let j = 0; j < roleName.length; j++){
                const saveTempObj = await models.tbl_assignedrolewithright.create({
                    Role : roleName[j],
                    Rights : roleRights[j],
                    HMIID : ip
                });
            }
            Object.assign(responseObj, { status: 'success' },{data:ip});
            return responseObj;
        } catch (error) {
            return error;
        }
    }

    async  insertInTempTable(req){
        try {

            let strCombinedRoles;
            if (sequelize.options.dialect === 'mssql') {
                strCombinedRoles = ` STRING_AGG(role_rights, ',') `;
            } else { // For mysql
                strCombinedRoles = ` GROUP_CONCAT(role_rights) `;
            }
            let str_query = `SELECT ${strCombinedRoles} as rights,role_name from tbl_role where role_name = '${req.body.str_role}' GROUP BY role_name`;
            
            //let str_query = `SELECT GROUP_CONCAT(role_rights) as rights from tbl_role where role_rights <> 'Create Admin' and role_name='${req.body.str_role}' GROUP BY '${req.body.str_role}' `;
            var result = await sequelize.query(str_query,{ type: QueryTypes.SELECT });
            

            let clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3]
            if (ip === undefined) {
                ip = '127.0.0.1'
            } else {
                ip = ip
            } 
            ip=ip.split('.')[3];
            let responseObj = {}
            let data = {}
            data = result;
           
            const deleteTempObj = await models.tbl_assignedrolewithright.destroy({
                where: {
                    HMIID: ip
                }
            });

            const saveTempObj = await models.tbl_assignedrolewithright.create({
                Role: req.body.str_role,
                Rights : data[0].rights,
                HMIID : ip
            });
            Object.assign(responseObj, { status: 'success' },{data:ip})
            return responseObj;
        } catch (error) {
          return  error; 
        }
    }

  async  getPerticularData(req){
        try {

            let strCombinedRoles;
            if (sequelize.options.dialect === 'mssql') {
                strCombinedRoles = ` STRING_AGG(role_rights, ',') `;
            } else { // For mysql
                strCombinedRoles = ` GROUP_CONCAT(role_rights) `;
            }
            const str_query = `SELECT ${strCombinedRoles} as rights
                ,role_name,locked 
                from tbl_role 
                where role_rights <> 'Create Admin' 
                GROUP BY role_name`;
            var result = await sequelize.query(str_query,{ type: QueryTypes.SELECT });

            //let str_query = `SELECT GROUP_CONCAT(role_rights) as rights,role_name,locked from tbl_role where role_rights <> 'Create Admin' GROUP BY role_name`;
           

            let clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3]
            if (ip === undefined) {
                ip = '127.0.0.1'
            } else {
                ip = ip
            } 
            ip=ip.split('.')[3];
            let responseObj = {}
            let data = {}
            data = result;
            let roleName = [], roleRights = []; 
            let finalArray = [];
            for(let i = 0; i < data.length; i++){
                roleName.push(data[i].role_name)
                roleRights.push(data[i].rights)
            }
            const deleteTempObj = await models.tbl_assignedrolewithright.destroy({
                where: {
                    HMIID: ip
                }
            });
            for(let j = 0; j < roleName.length; j++){
                const saveTempObj = await models.tbl_assignedrolewithright.create({
                    Role : roleName[j],
                    Rights : roleRights[j],
                    HMIID : ip
                });
            }
            Object.assign(responseObj, { status: 'success' },{data:ip})
            return responseObj;
        } catch (error) {
          return  error; 
        }
    }

    async getSuperAdminRights()
    {
        try {
            //let res =  await dbcon.execute("SELECT `role_rights` FROM `tbl_role` WHERE `role_name` = ?", ['SuperAdmin']);
            var res = await models.tbl_role.findAll({
                attributes: [
                  'role_rights'
                ],
                where: {
                    role_name: {
                      [Op.eq]: 'SuperAdmin'
                    }
                }
            }); 
            var sarr_rights = [];
            res.forEach(element => {
                sarr_rights.push(element.role_rights);
            });
    
            return sarr_rights;
        } catch (error) {
          console.log(error);  
          return error;
        }
       
    }

 async userRights(role){
        try {
            var result1 = await models.tbl_role.findAll({
                attributes: [
                    'role_rights'
                  ],
                where: {
                    role_name: role
                }
            });
            return result1;
            
        } catch (error) {
            return error;
        }
        //return dbcon.execute("SELECT `role_rights` FROM `tbl_role` WHERE `role_name` = ?", [role]);
    }

  async userSplRight(userid){
        try {
            var result2 = await models.tbl_rights_special.findAll({
                attributes: [
                    'spl_right'
                  ],
                where: {
                    userid: userid
                }
            });
            return result2;  
        } catch (error) {
            return error;
        }  
        //return dbcon.execute("SELECT `spl_right` FROM `tbl_rights_special` WHERE `userid`=?", [userid]);
    }
    
 async userRemoveRight(userid){
        try {
            var result3 = await models.tbl_rights_removed.findAll({
                attributes: [
                    'removed_right'
                  ],
                where: {
                    userid: userid
                }
            });
            return result3;  
        } catch (error) {
            return error;
        }
        //return dbcon.execute("SELECT `removed_right` FROM `tbl_rights_removed` WHERE `userid`=?", [userid]);
    }

}
module.exports = RoleModel;
