const requestIp = require('request-ip');
const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const sequelize = require("../dbConnection").sequelize;
const { QueryTypes } = require('sequelize');
const { Op } = require("sequelize");
const e = require('express');
const clsMathJS = require('./clsMathJS');
const math = new clsMathJS();
const serverConfig = require('../global/serverConfig');
class BatchModel {

    async getAreaFromCubicleType() {
        try {
            let result = await models.tbl_cubicle_area.findAll({ attributes: ['Area'] });
            return result;
        } catch (error) {
            return error;
        }
    }

    async getQueryTabletCapsule(int_productType, condition, data) {
        try {
            if (int_productType == "1") {
                var str_query = "select " + data + " from tbl_batchsummary_master1" + condition
                    + " union select " + data + "from tbl_batchsummary_master2" + condition
                    + " union select " + data + "from tbl_batchsummary_master3" + condition
                    + " union select " + data + "from tbl_batchsummary_master4" + condition
                    + " union select " + data + "from tbl_batchsummary_master5" + condition
                    + " union select " + data + "from tbl_batchsummary_master6" + condition
                    + " union select " + data + "from tbl_batchsummary_master7" + condition
                    + " union select " + data + "from tbl_batchsummary_master8" + condition
                    + " union select " + data + "from tbl_batchsummary_master9" + condition
                    + " union select " + data + "from tbl_batchsummary_master10" + condition
                    + " union select " + data + "from tbl_batchsummary_master11" + condition
                    + " union select " + data + "from tbl_batchsummary_master12" + condition
                    + " union select " + data + "from tbl_batchsummary_master13" + condition
                    + " union select " + data + "from tbl_batchsummary_masterhtd" + condition;
            }
            else {
                var str_query = "select " + data + " from tbl_batchsummary_master1" + condition
                    + " union select " + data + "from tbl_batchsummary_master2" + condition
                    + " union select " + data + "from tbl_batchsummary_masterdiff" + condition
                    + " union select " + data + "from tbl_batchsummary_master5" + condition
                    + " union select " + data + "from tbl_batchsummary_master13" + condition;
            }

            return str_query;
        } catch (error) {
            return error;
        }
    }

    async getProductDetail(objProduct) {
        try {
            let data = " distinct BFGCode,ProductName,PVersion,Version ";
            var str_query = `Select ${data} from ${objProduct.str_db_tableName} where CubicleType = '${objProduct.str_cubicleType}' and PrdType = ${objProduct.str_productType} and Side='${objProduct.str_side}' and 
            Area='${objProduct.str_area}' and  BatchCompleted = 1`;
            var result = await sequelize.query(str_query);
            return result[0];
        } catch (error) {
            console.log("error", error);
            return error;
        }
    }

    async getProductAll(objProduct) {
        try {
            let data = " distinct BFGCode,ProductName,PVersion,Version ";
            var str_query;
            if (objProduct.str_productType == "1") // tablet
            {
                var condition = " where CubicleType ='" + objProduct.str_cubicleType + "' and Area='" + objProduct.str_area + "' and PrdType = 1 and BatchCompleted = 1";
                str_query = await this.getQueryTabletCapsule("1", condition, data);
            }
            else {
                var condition = " where CubicleType ='" + objProduct.str_cubicleType + "' and Area='" + objProduct.str_area + "' and PrdType = 2 and BatchCompleted = 1";
                str_query = str_query = await this.getQueryTabletCapsule("2", condition, data);
            }
            var result = await sequelize.query(str_query);
            return result[0];
        } catch (error) {
            return error;
        }
    }

    async getBatches(objBatch) {
        try {
            let resultBatch = await models[objBatch.str_db_tableName].findAll({
                attributes: [sequelize.fn('DISTINCT', sequelize.col('BatchNo'))],
                where: {
                    CubicleType: objBatch.str_cubicleType,
                    BFGCode: objBatch.str_prdID,
                    ProductName: objBatch.str_prdName,
                    PVersion: objBatch.str_prdVersion,
                    Version: objBatch.str_version,
                    Side: objBatch.str_side,
                    BatchCompleted: 1,
                    Area: objBatch.str_area
                }
            });
            return resultBatch;
        } catch (error) {
            console.log("error", error);
            return error;
        }
    }

    async getBatchesAll(objBatch) {
        try {
            let data = " distinct(BatchNo) ";
            var str_query;
            if (objBatch.str_productType == "1") // tablet
            {
                let condition = " where CubicleType ='" + objBatch.str_cubicleType + "' and Area='" + objBatch.str_area + "' and PrdType = 1 and BFGCode = '" + objBatch.str_prdID
                    + "' and ProductName='" + objBatch.str_prdName + "' and PVersion='" + objBatch.str_prdVersion
                    + "' and Version='" + objBatch.str_version + "' and BatchCompleted = 1";

                str_query = await this.getQueryTabletCapsule("1", condition, data);
            }
            else {
                var condition = " where CubicleType ='" + objBatch.str_cubicleType + "' and Area='" + objBatch.str_area + "' and PrdType = 2 and BFGCode = '" + objBatch.str_prdID
                    + "' and ProductName='" + objBatch.str_prdName + "' and PVersion='" + objBatch.str_prdVersion
                    + "' and Version='" + objBatch.str_version + "' and BatchCompleted = 1";

                str_query = await this.getQueryTabletCapsule("2", condition, data);
            }

            var result = await sequelize.query(str_query);
            return result[0];
        } catch (error) {
            return error;
        }
    }

    async getPrintNo(req) {
        try {
            let obj_response = {};
            let result = await models.tbl_batchsummary.findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('PrintNo')), 'PrintNo']
                ],
                where:
                {
                    ProductType: req.body.str_productType,
                    CubType: req.body.str_cubicleType,
                    ReportOption: req.body.str_reportOption,
                    BatchNo: req.body.str_batches,
                    ProductId: req.body.str_prdID,
                    ProductName: req.body.str_prdName,
                    PrdVersion: req.body.str_prdVersion,
                    Version: req.body.str_version,
                    Side: req.body.str_side,
                    Area: req.body.str_area
                }
            });

            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;

        } catch (error) {
            console.log("error", error);
            return error;
        }
    }

    async getPrintNoAll(req) {
        try {
            let obj_response = {};
            let result = await models.tbl_batchsummary.findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('PrintNo')), 'PrintNo']
                ],
                where:
                {
                    ProductType: req.body.str_productType,
                    CubType: req.body.str_cubicleType,
                    BatchNo: req.body.str_batches,
                    ProductId: req.body.str_prdID,
                    ProductName: req.body.str_prdName,
                    PrdVersion: req.body.str_prdVersion,
                    Version: req.body.str_version
                }
            });

            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;

        } catch (error) {
            return error;
        }
    }

    async increasePrintNoSummaryAll(objPrintCount) {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var now = new Date();
                var PrintNo = parseInt(Number(objPrintCount.int_printNo + 1));
                await models.tbl_batchsummary.update({
                    PrintNo: PrintNo
                    
                }, {
                    where:
                    {
                        ProductType: objPrintCount.str_prdType,
                        CubType: objPrintCount.str_cubType,
                        BatchNo: objPrintCount.str_batchNo,
                        ProductId: objPrintCount.str_prdID,
                        ProductName: objPrintCount.str_prdName,
                        PrdVersion: objPrintCount.str_prdVersion,
                        Version: objPrintCount.str_version,
                        Area: objPrintCount.str_area
                    }
                }, {
                    transaction: t
                });
                console.log("printno:", PrintNo);

                await models.tbl_batchsummary_printrecord.create({
                    Print_Dt: date.format(now, 'YYYY-MM-DD'),
                    Print_Tm: date.format(now, 'HH:mm:ss'),
                    UserID: objPrintCount.strUserId,
                    UserName: objPrintCount.strUserName,
                    ProductType: objPrintCount.str_prdType,
                    CubType: objPrintCount.str_cubType,
                    BatchNo: objPrintCount.str_batchNo,
                    BFGCode: objPrintCount.str_prdID,
                    PrdName: objPrintCount.str_prdName,
                    PrdVersion: objPrintCount.str_prdVersion,
                    Version: objPrintCount.str_version,
                    PrintNo: PrintNo,
                    Reason: objPrintCount.strReason,
                    Area: objPrintCount.str_area
                }, {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPrintCount.strUserId,
                    username: objPrintCount.strUserName,
                    activity: "Batch Summary Report Printed"
                }, {
                    transaction: t
                });
            });
            return "Success";
        } catch (error) {
            return error;
        }
    }

    IsDataValueValid(DataValue) {
        try {
            let int_cnt = 0;
            let strArr_InvalidChars = ["NA", "FL", "--"];
            
            if(Number(DataValue) >= 999)
            {
                int_cnt = int_cnt + 1;
            }
            else if (strArr_InvalidChars.includes(DataValue)) {
                int_cnt = int_cnt + 1;
            }
            if (int_cnt > 0) {
                return true;
            } else {
                return false;
            }

        } catch (error) {
            console.log("IsDataValueValid() : ", error);
            throw error;
        }
    }

    async processBatchSummeryData(objBatchSummery, req) {
        try {
            let Ip = requestIp.getClientIp(req);
            let ClIp = Ip.split(':')[3]
            var ClientIp;
            if (ClIp === undefined) {
                ClientIp = '127.0.0.1';
            } else {
                ClientIp = ClIp;
            }
            var ipAdd = ClientIp;
            var length = 0;
            var grpLength = 0;
            var str_masterData;
            let cntHard = 0, cntThick = 0, cntDiam = 0, cntDOLOB = 0;
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                /** Delete data from temp table */
                for (var k of ["tbl_batchsummary_master_temp", "tbl_batchsummary_detail_temp", "tbl_batchsummary_masterhtd_temp", "tbl_batchsummary_detailhtd_temp", "tbl_batchsummary_graph_temp","tbl_batchsummary_graph_temp_htd"]) {
                    await models[k].destroy({
                        where:
                            { HMIID: ipAdd }
                    }, {
                        transaction: t
                    });
                }

                //GetData from main table
                str_masterData = await models[objBatchSummery.str_tableName_master].findAll({
                    where:
                    {
                        BFGCode: objBatchSummery.str_prdID,
                        ProductName: objBatchSummery.str_prdName,
                        PVersion: objBatchSummery.str_prdVersion,
                        Version: objBatchSummery.str_version,
                        CubicleType: objBatchSummery.str_cubicleType,
                        PrdType: objBatchSummery.str_productType,
                        BatchNo: objBatchSummery.str_batches,
                        Area: objBatchSummery.str_area
                    },
                    transaction: t
                });

                var str_detailData = await models[objBatchSummery.str_tableName_detail].findAll({
                    where:
                    {
                        RepSerNo: str_masterData[0].RepSerNo
                    },
                    transaction: t
                });
                length = str_detailData.length;

                var str_detailDataComp = await models[objBatchSummery.str_tableName_detail].findAll({
                    where:
                    {
                        RepSerNo: str_masterData[0].RepSerNo,
                        TestResult: 'Complies'
                    },
                    transaction: t
                });
                grpLength = str_detailDataComp.length;
                //Insert data in temp table
                if(objBatchSummery.str_reportOption == "Hardness" && objBatchSummery.str_tableName_master == "tbl_batchsummary_masterhtd"){
                    var obj_create = {
                        RepSerNo: str_masterData[0].RepSerNo,
                        Area: str_masterData[0].Area,
                        PrdType: str_masterData[0].PrdType,
                        ReportType: str_masterData[0].ReportType,
                        BFGCode: str_masterData[0].BFGCode,
                        ProductName: str_masterData[0].ProductName,
                        PVersion: str_masterData[0].PVersion,
                        Version: str_masterData[0].Version,
                        CubicalNo: str_masterData[0].CubicalNo,
                        CubicleType: str_masterData[0].CubicleType,
                        BatchNo: str_masterData[0].BatchNo,
                        BatchSize: str_masterData[0].BatchSize,
                        Side: str_masterData[0].Side,
                        BLName: str_masterData[0].BLName,
                        NomHard: (str_masterData[0].NomHard == "NA") ? 0 : str_masterData[0].NomHard,
                        TolNegActualHard:  str_masterData[0].TolNegActualHard,
                        TolPosActualHard: str_masterData[0].TolPosActualHard,
                        TolNegHard: (str_masterData[0].TolNegHard == "NA") ? 0 : str_masterData[0].TolNegHard,
                        TolPosHard: (str_masterData[0].TolPosHard == "NA") ? 0 : str_masterData[0].TolPosHard,
                        NomThick: (str_masterData[0].NomThick == "NA") ? 0 : str_masterData[0].NomThick,
                        TolNegActualThick: str_masterData[0].TolNegActualThick,
                        TolPosActualThick: str_masterData[0].TolPosActualThick,
                        TolNegThick: (str_masterData[0].TolNegThick == "NA") ? 0 : str_masterData[0].TolNegThick,
                        TolPosThick: (str_masterData[0].TolPosThick == "NA") ? 0 : str_masterData[0].TolPosThick,
                        NomBL: (str_masterData[0].NomBL == "NA") ? 0 :  str_masterData[0].NomBL,
                        TolNegActualBL: str_masterData[0].TolNegActualBL,
                        TolPosActualBL:  str_masterData[0].TolPosActualBL,
                        TolNegBL:  (str_masterData[0].TolNegBL == "NA") ? 0 : str_masterData[0].TolNegBL,
                        TolPosBL:  (str_masterData[0].TolPosBL == "NA") ? 0 : str_masterData[0].TolPosBL,
                        MinValueHard: str_masterData[0].MinValueHard,
                        MaxValueHard: str_masterData[0].MaxValueHard,
                        AvgValueHard: str_masterData[0].AvgValueHard,
                        MinValueThick: str_masterData[0].MinValueThick,
                        MaxValueThick: str_masterData[0].MaxValueThick,
                        AvgValueThick: str_masterData[0].AvgValueThick,
                        MinValueBL: str_masterData[0].MinValueBL,
                        MaxValueBL:  str_masterData[0].MaxValueBL,
                        AvgValueBL:  str_masterData[0].AvgValueBL,
                        Remark: str_masterData[0].Remark,
                        StartDateHard: str_masterData[0].StartDateHard,
                        EndDateHard: str_masterData[0].EndDateHard,
                        StartDateThick: str_masterData[0].StartDateThick,
                        EndDateThick: str_masterData[0].EndDateThick,
                        StartDateBL:str_masterData[0].StartDateBL,
                        EndDateBL: str_masterData[0].EndDateBL,
                        Unit: str_masterData[0].Unit,
                        BatchCompleted: str_masterData[0].BatchCompleted,
                        HMIID: ipAdd,
                        Nom: (str_masterData[0].Nom == "NA") ? 0 : str_masterData[0].Nom,
                        NMT: (str_masterData[0].NMT == null)? 0 : str_masterData[0].NMT,
                        Tol1NegActual: str_masterData[0].Tol1NegActual,
                        Tol1PosActual: str_masterData[0].Tol1PosActual,
                        Tol2NegActual: str_masterData[0].Tol2NegActual,
                        Tol2PosActual: str_masterData[0].Tol2PosActual,
                        Tol1Neg: str_masterData[0].Tol1Neg,
                        Tol1Pos: str_masterData[0].Tol1Pos,
                        Tol2Neg: str_masterData[0].Tol2Neg,
                        Tol2Pos: str_masterData[0].Tol2Pos,
                        GraphOn: str_masterData[0].GraphOn,
                        LimitOn: str_masterData[0].LimitOn,
                        MinValue: str_masterData[0].MinValue,
                        MaxValue: str_masterData[0].MaxValue,
                        AvgValue: str_masterData[0].AvgValue,
                        StartDate: str_masterData[0].StartDate ,
                        EndDate: str_masterData[0].EndDate,
                        DP: str_masterData[0].DP,
                        Unit: str_masterData[0].Unit,
                        FinalMinDT: str_masterData[0].FinalMinDT,
                        FinalMaxDT: str_masterData[0].FinalMaxDT,
                        FinalAvgDT: str_masterData[0].FinalAvgDT,
                        StdTime: str_masterData[0].StdTime,
                        Stage: str_masterData[0].Stage,
                        StdLimit1: str_masterData[0].StdLimit1,
                        StdLimit2: str_masterData[0].StdLimit2,
                        Department: str_masterData[0].Department,
                        Min_Per: str_masterData[0].Min_Per,
                        Max_Per: str_masterData[0].Max_Per
                    }
                }
                else{
                    var obj_create = {
                        RepSerNo: str_masterData[0].RepSerNo,
                        Area: str_masterData[0].Area,
                        PrdType: str_masterData[0].PrdType,
                        ReportType: str_masterData[0].ReportType,
                        BFGCode: str_masterData[0].BFGCode,
                        ProductName: str_masterData[0].ProductName,
                        PVersion: str_masterData[0].PVersion,
                        Version: str_masterData[0].Version,
                        CubicalNo: str_masterData[0].CubicalNo,
                        CubicleType: str_masterData[0].CubicleType,
                        BatchNo: str_masterData[0].BatchNo,
                        BatchSize: str_masterData[0].BatchSize,
                        Side: str_masterData[0].Side,
                        Nom: str_masterData[0].Nom,
                        NMT: (str_masterData[0].NMT == null)? 0 : str_masterData[0].NMT,
                        Tol1NegActual:  (objBatchSummery.str_reportOption == 'Individual' || objBatchSummery.str_reportOption == 'Individual Layer 1' || objBatchSummery.str_reportOption == 'Individual Layer 2' || objBatchSummery.str_reportOption == 'Differential')? str_masterData[0].StdLimit1 : str_masterData[0].Tol1NegActual,
                        Tol1PosActual: str_masterData[0].Tol1PosActual,
                        Tol2NegActual:(objBatchSummery.str_reportOption == 'Individual' || objBatchSummery.str_reportOption == 'Individual Layer 1' || objBatchSummery.str_reportOption == 'Individual Layer 2' || objBatchSummery.str_reportOption == 'Differential')? str_masterData[0].StdLimit2 : str_masterData[0].Tol2NegActual,
                        Tol2PosActual: str_masterData[0].Tol2PosActual,
                        Tol1Neg: str_masterData[0].Tol1Neg,
                        Tol1Pos: str_masterData[0].Tol1Pos,
                        Tol2Neg: str_masterData[0].Tol2Neg,
                        Tol2Pos: str_masterData[0].Tol2Pos,
                        GraphOn: str_masterData[0].GraphOn,
                        LimitOn: str_masterData[0].LimitOn,
                        MinValue: str_masterData[0].MinValue,
                        MaxValue: str_masterData[0].MaxValue,
                        AvgValue: str_masterData[0].AvgValue,
                        Remark: str_masterData[0].Remark,
                        StartDate: str_masterData[0].StartDate ,
                        EndDate: str_masterData[0].EndDate,
                        DP: str_masterData[0].DP,
                        Unit: str_masterData[0].Unit,
                        FinalMinDT: str_masterData[0].FinalMinDT,
                        FinalMaxDT: str_masterData[0].FinalMaxDT,
                        FinalAvgDT: str_masterData[0].FinalAvgDT,
                        BatchCompleted: str_masterData[0].BatchCompleted,
                        HMIID: ipAdd,
                        ParamName: objBatchSummery.str_reportOption,
                        Stage: str_masterData[0].Stage,
                        DTStdTime: str_masterData[0].StdTime,
                        Department: str_masterData[0].Department,
                        Make: (objBatchSummery.str_reportOption == "Friability")? str_masterData[0].Make : 'NA',
                        ModelNo: (objBatchSummery.str_reportOption == "Friability")? str_masterData[0].ModelNo : 'NA'
                    }
                }

                if(['tbl_batchsummary_master19','tbl_batchsummary_master20','tbl_batchsummary_master13'].includes(objBatchSummery.str_tableName_master)){
                    Object.assign(obj_create,{TempRange: str_masterData[0].TempRange})
                }
                if(['tbl_batchsummary_master1','tbl_batchsummary_master9','tbl_batchsummary_master11'].includes(objBatchSummery.str_tableName_master)){
                    Object.assign(obj_create,{Min_Per : str_masterData[0].Min_Per},{Max_Per : str_masterData[0].Max_Per});
                }
                if(objBatchSummery.str_reportOption == "Hardness" && objBatchSummery.str_tableName_master == "tbl_batchsummary_masterhtd"){
                    await models.tbl_batchsummary_masterhtd_temp.create(obj_create, {
                        transaction: t
                    });
                }
                else{
                    await models.tbl_batchsummary_master_temp.create(obj_create, {
                        transaction: t
                    });
                }
                
              let kl =0;
            //   maintaing Friabcount for repseqno only for double rotatry to show graph sequence.
                let sideFriab = 0;
                var cntRecords = 0,cntRecordsR = 0 ;
                for (var l of str_detailData) {
                    if(objBatchSummery.str_reportOption == "Friability" && l.Side == 'LHS'){
                        sideFriab = sideFriab + 1
                    }
                    if(objBatchSummery.str_reportOption == "Hardness"  && objBatchSummery.str_tableName_detail == "tbl_batchsummary_detailhtd"){
                        await models.tbl_batchsummary_detailhtd_temp.create({
                            SerNo: kl+1,
                            RepSerNo: l.RepSerNo,
                            RecSeqNo: l.RecSeqNo,
                            Date: l.Date,
                            Time: date.format(l.Time, 'HH:mm:ss'),
                            InstrumentID: l.InstrumentID,
                            Side: l.Side,
                            // MinHard: (l.MinHard == "NA") ? "0" : l.MinHard,
                            // MaxHard: (l.MaxHard == "NA") ? "0" :l.MaxHard,
                            // AvgHard: (l.AvgHard == "NA") ? "0" :l.AvgHard,
                            // MinThick: (l.MinThick == "NA") ? "0.00" :l.MinThick,
                            // MaxThick: (l.MaxThick == "NA") ? "0.00" :l.MaxThick,
                            // AvgThick: (l.AvgThick == "NA") ? "0.00" :l.AvgThick,
                            // MinBL:  (l.MinBL == "NA") ? "0.00" : l.MinBL,
                            // MaxBL:  (l.MaxBL == "NA") ? "0.00" : l.MaxBL,
                            // AvgBL:  (l.AvgBL == "NA") ? "0.00" : l.AvgBL,
                            MinHard: l.MinHard,
                            MaxHard: l.MaxHard,
                            AvgHard: l.AvgHard,
                            MinThick: l.MinThick,
                            MaxThick: l.MaxThick,
                            AvgThick: l.AvgThick,
                            MinBL: l.MinBL,
                            MaxBL: l.MaxBL,
                            AvgBL: l.AvgBL,
                            TestResult: l.TestResult,
                            UserID: l.UserID,
                            UserName: l.UserName,
                            HMIID: ipAdd
                        }, {
                            transaction: t
                        });

                        if(l.TestResult == "Complies"){
                            if(l.Side == "LEFT" || l.Side == "NA" || l.Side == "LHS") {cntRecords = cntRecords + 1}
                            if(l.Side == "RIGHT" || l.Side == "RHS") {cntRecordsR = cntRecordsR + 1}
                            await models.tbl_batchsummary_graph_temp_htd.create({
                                RepSerNo: l.RepSerNo,
                                RecSeqNo: (l.Side == "RIGHT" || l.Side == "RHS") ? cntRecordsR : cntRecords,
                                Date: l.Date,
                                Time: date.format(l.Time, 'HH:mm:ss'),
                                InstrumentID: l.InstrumentID,
                                Side: l.Side,
                                MinHard: (l.MinHard == "NA") ? "0" : l.MinHard,
                                MaxHard: (l.MaxHard == "NA") ? "0" :l.MaxHard,
                                AvgHard: (l.AvgHard == "NA") ? "0" :l.AvgHard,
                                MinThick: (l.MinThick == "NA") ? "0.00" :l.MinThick,
                                MaxThick: (l.MaxThick == "NA") ? "0.00" :l.MaxThick,
                                AvgThick: (l.AvgThick == "NA") ? "0.00" :l.AvgThick,
                                MinDLB:  (l.MinBL == "NA") ? "0.00" : l.MinBL,
                                MaxDLB:  (l.MaxBL == "NA") ? "0.00" : l.MaxBL,
                                AvgDLB:  (l.AvgBL == "NA") ? "0.00" : l.AvgBL,
                                TestResult: l.TestResult,
                                UserID: l.UserID,
                                UserName: l.UserName,
                                HMIID: ipAdd
                            });
                       }
                        if (this.IsDataValueValid(l.MinHard) === true) {
                            cntHard = cntHard + 1;
                        }
                        if (this.IsDataValueValid(l.MinThick) === true) {
                            cntThick = cntThick + 1;
                        }
                        if (this.IsDataValueValid(l.MinBL) === true) {
                            cntDOLOB = cntDOLOB + 1;
                        }
                    }
                    else {
                        await models.tbl_batchsummary_detail_temp.create({
                            SerNo: kl+1,
                            RepSerNo: l.RepSerNo,
                            RecSeqNo: (objBatchSummery.str_reportOption == "Friability" && (l.Side != 'NA')? sideFriab : l.RecSeqNo),
                            Date: l.Date,
                            Time: date.format(l.Time, 'HH:mm:ss'),
                            InstrumentID: l.InstrumentID,
                            Side: l.Side,
                            Min: l.Min,
                            Max: (objBatchSummery.str_reportOption == 'Friability')? l.Friability : l.Max,
                            Avg: l.Avg,
                            MinTimeDT: date.format(l.MinTimeDT, 'HH:mm:ss'),
                            MaxTimeDT: date.format(l.MaxTimeDT, 'HH:mm:ss'),
                            AvgTimeDT: date.format(l.AvgTimeDT, 'HH:mm:ss'),
                            TestResult: l.TestResult,
                            UserID: l.UserID,
                            UserName: l.UserName,
                            HMIID: ipAdd,
                            Deviation: l.Deviation,
                            NoOfSample: l.NoOfSample,
                            InitialWeight: l.InitialWeight,
                            FinalWeight: l.FinalWeight,
                            Min_Per : l.Min_Per,
                            Max_Per : l.Max_Per
                        }, {
                            transaction: t
                        });

                        if(l.TestResult == "Complies"){
                            if(l.Side == "LEFT" || l.Side == "NA" || l.Side == "LHS") {cntRecords = cntRecords + 1}
                            if(l.Side == "RIGHT" || l.Side == "RHS") {cntRecordsR = cntRecordsR + 1}
                            await models.tbl_batchsummary_graph_temp.create({
                                RepSerNo: l.RepSerNo,
                                RecSeqNo: (l.Side == "RIGHT" || l.Side == "RHS") ? cntRecordsR : cntRecords,
                                Date: l.Date,
                                Time: date.format(l.Time, 'HH:mm:ss'),
                                InstrumentID: l.InstrumentID,
                                Side: l.Side,
                                MinPer: l.Min_Per,
                                MaxPer: l.Max_Per,
                                Min: l.Min,
                                Max: (objBatchSummery.str_reportOption == 'Friability')? l.Friability : l.Max,
                                Avg: l.Avg,
                                MinTimeDT: date.format(l.MinTimeDT, 'HH:mm:ss'),
                                MaxTimeDT: date.format(l.MaxTimeDT, 'HH:mm:ss'),
                                AvgTimeDT: date.format(l.AvgTimeDT, 'HH:mm:ss'),
                                TestResult: l.TestResult,
                                UserID: l.UserID,
                                UserName: l.UserName,
                                HMIID: ipAdd
                            }, {
                                transaction: t
                            });
                        }
                    }
                    
                }

                if(objBatchSummery.str_reportOption == "Hardness"  && objBatchSummery.str_tableName_detail == "tbl_batchsummary_detailhtd")
                {
                    if(cntRecordsR == 0) // RHS
                    {
                        if(cntHard != cntRecordsR)
                        {
                            cntHard = 0;
                        }
                        if(cntThick != cntRecordsR)
                        {
                            cntThick = 0;
                        }
                        if(cntDOLOB != cntRecordsR)
                        {
                            cntDOLOB = 0;
                        }
                    }
                    else // LHS or NA
                    {
                        if(cntHard != cntRecords)
                        {
                            cntHard = 0;
                        }
                        if(cntThick != cntRecords)
                        {
                            cntThick = 0;
                        }
                        if(cntDOLOB != cntRecords)
                        {
                            cntDOLOB = 0;
                        }

                    }
                }

            });
            var detailTempTableName = (objBatchSummery.str_reportOption == "Hardness" && objBatchSummery.str_tableName_detail == "tbl_batchsummary_detailhtd") ? detailTempTableName = 'tbl_batchsummary_detailhtd_temp' :  detailTempTableName = 'tbl_batchsummary_detail_temp';
            //for RecSeqNo count where side = right
            var query = `SELECT COUNT(RecSeqNo) as RecSeqCntR FROM ${detailTempTableName} WHERE Side='RHS' and HMIID = '${ipAdd}'`  // as per discussed with interface side change right to RHS

            var recSeqR = await sequelize.query(query, {
                type: QueryTypes.SELECT
            });

            //for RecSeqNo count where side != right
            var query1 = `SELECT COUNT(RecSeqNo) as RecSeqCnt FROM ${detailTempTableName} WHERE Side<>'RHS' and HMIID = '${ipAdd}'` // as per discussed with interface side change right to RHS

            var recSeq = await sequelize.query(query1, {
                type: QueryTypes.SELECT
            });

            //for RecSeqNo count where side != right and TestResult = complies
            var query2 = `SELECT COUNT(RecSeqNo) as RecSeqCnt FROM ${detailTempTableName} WHERE Side<>'RHS' and HMIID = '${ipAdd}' and TestResult = 'Complies'` 

            var graphRecSeq = await sequelize.query(query2, {
                type: QueryTypes.SELECT
            });

            //for RecSeqNo count where side = right
            var query3 = `SELECT COUNT(RecSeqNo) as RecSeqCntR FROM ${detailTempTableName} WHERE Side='RHS' and HMIID = '${ipAdd}' and TestResult = 'Complies'`  

            var graphRecSeqR = await sequelize.query(query3, {
                type: QueryTypes.SELECT
            });

            // check entry exist in table (for printno)
            var summeryInsert = await this.checkBatchSummaryDataInPermTable(objBatchSummery);
            if (summeryInsert == 'Successfull') {
                return { result: "Success", HMIId: ipAdd, qty: length, 
                    compGraphQty: grpLength, 
                    RecSeqNo: recSeq[0].RecSeqCnt, 
                    RecSeqNoR: recSeqR[0].RecSeqCntR, 
                    CompGraphRecSeqNo: graphRecSeq[0].RecSeqCnt, 
                    CompGraphRecSeqNoR: graphRecSeqR[0].RecSeqCntR,
                    cntHard: cntHard, cntThick: cntThick,
                    cntDiam: cntDiam, cntDOLOB: cntDOLOB};
            }

        } catch (error) {
            console.log("Summary", error);
            throw error;
        }
    }

    async processBatchSummeryDataAll(objBatchSummery, req) {
        let Ip = requestIp.getClientIp(req);
        let ClIp = Ip.split(':')[3]
        var ClientIp;
        if (ClIp === undefined) {
            ClientIp = '127.0.0.1';
        } else {
            ClientIp = ClIp;
        }
        //var ipAdd = ClientIp.split('.')[3];
        var ipAdd = ClientIp;

        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {

                /** Delete data from temp table */
                for (const j of [1, 2]) {
                    await models.tbl_batchsummary_temp.destroy({
                        where:
                            { HMIID: ipAdd }
                    }, {
                        transaction: t
                    });
                    console.log("deleteSummary", ipAdd);
                }

                let res_data = await models.tbl_batchsummary_temp.findAll({
                    where:
                        { HMIID: ipAdd }
                }, {
                    transaction: t
                });

                if (res_data.length > 0) {
                    await models.tbl_batchsummary_temp.destroy({
                        where:
                            { HMIID: ipAdd }
                    }, {
                        transaction: t
                    });
                }

                var intParamNo, strUnit;

                /** insert parameter name and product detail in temp table */
                for (let strParamName of objBatchSummery.arrParameters) {
                    intParamNo = (strParamName == "Group") ? 2 : (strParamName == "Individual") ? 1 :(strParamName == "Thickness") ? 3 :
                        (strParamName == "Length") ? 5 : (strParamName == "Breadth") ? 4 : (strParamName == "Diameter") ? 6 :
                            (strParamName == "Hardness") ? 7 : (strParamName == "Friability") ? 8 : (strParamName == "Individual Layer-1") ? 9 :
                                (strParamName == "Group Layer-1") ? 10 : (strParamName == "Individual Layer-2") ? 11 : (strParamName == "Group Layer-2") ? 12 :
                                    (strParamName == "Filled Content Weight") ? 3 : (strParamName == "Seal Length") ? 5 : 13;

                    await this.insertParamToTempTable(strParamName, ipAdd, objBatchSummery, intParamNo);
                }

                for (let strParamName of objBatchSummery.arrParameters) {
                    intParamNo = (strParamName == "Group") ? 2 : (strParamName == "Individual") ? 1 :(strParamName == "Thickness") ? 3 :
                        (strParamName == "Length") ? 5 : (strParamName == "Breadth") ? 4 : (strParamName == "Diameter") ? 6 :
                            (strParamName == "Hardness") ? 7 : (strParamName == "Friability") ? 8 : (strParamName == "Individual Layer-1") ? 9 :
                                (strParamName == "Group Layer-1") ? 10 : (strParamName == "Individual Layer-2") ? 11 : (strParamName == "Group Layer-2") ? 12 :
                                    (strParamName == "Filled Content Weight") ? 3 : (strParamName == "Seal Length") ? 5 : 13;

                    /** Get data from master table**/
                    var resMaster = await this.getDataFromSummaryTable_Master(intParamNo, objBatchSummery, strParamName);

                    if (resMaster[0] != undefined) {
                        // if (strParamName == "Disintegration Tester") {
                        //     let resDT = this.updateMinMaxAvgDT_Combine(resMaster[0].RepSerNo, resMaster[0].DTStdTime, intParamNo, ipAdd);
                        // }

                        strUnit = (intParamNo == 1 || intParamNo == 9 || intParamNo == 11 || strParamName == "Filled Content Weight") ? resMaster[0].Unit :
                            (intParamNo == 2 || intParamNo == 10 || intParamNo == 12) ? resMaster[0].Unit :
                                (strParamName == "Friability") ? "%w/w" : (intParamNo == 13) ? "HH:mm:ss" : (intParamNo == 7) ? resMaster[0].UnitHard : "mm";

                        await this.updateInTempTable(intParamNo, resMaster, ipAdd, strUnit);

                        if (strParamName != "Disintegration Tester") {
                            //let calDataUsingSP = await this.calculateDataUsingSP(resMaster[0].RepSerNo, strParamName, intParamNo);
                            /** Calculation update in temp table */
                            let resCalculation = await this.updateCalculationInTempTable(ipAdd, intParamNo, resMaster, strParamName, 1, resMaster[0].DP, strUnit, objBatchSummery);
                        }

                    }
                    else {
                        strUnit = (intParamNo == 1 || intParamNo == 9 || intParamNo == 11 || strParamName == "Filled Content Weight") ? "mg" :
                            (intParamNo == 2 || intParamNo == 10 || intParamNo == 12) ? "g" :
                                (strParamName == "Friability") ? "%w/w" : (intParamNo == 13) ? "HH:mm:ss" : (intParamNo == 7) ? "kp" : "mm";

                        let resUpdateUnit = await this.updateUnit(intParamNo, ipAdd, strUnit);

                        let resCalculation = await this.updateCalculationInTempTable(ipAdd, intParamNo, resMaster, strParamName, 0, 0, strUnit, objBatchSummery);
                    }
                }

                // update batch size if 1st parameter will not done.
                let resNotDone = await this.updateIfFirstParameterNotDone(ipAdd);
            });

            //update batch size if null (No parameter weightment done)
            await this.getNUpdateBatchSize(ipAdd);


    /** get End and Start Time/date for summary  */
        const objGetFormatDTTM =await models.tbl_nomenclature.findAll ({
            attributes: ['dateFormat','timeFormat']
        });

        const objGetTimeDateForSummary = await models.tbl_batches.findAll ({
            attributes: ['BatchStartDTTM','BatchEndDTTM'],
            where:
            {
                Prod_ID: objBatchSummery.str_prdID,
                Prod_Name: objBatchSummery.str_prdName,
                Prod_Version: objBatchSummery.str_prdVersion,
                Version: objBatchSummery.str_version,
                Batch: objBatchSummery.str_batches,
                cubicleType: objBatchSummery.str_cubicleType,
                BatchStartDTTM: { [Op.ne]: null },
                BatchEndDTTM: { [Op.ne]: null },
            }
        });
        // database.createTextFile('TxtBatchStart.txt',"data:"+objGetTimeDateForSummary);  
        // database.createTextFile('TxtBatchStart.txt',"res:"+resSummaryDTTM[0]);

            // check entry exist in table (for printno)
            var summeryInsert = await this.checkBatchSummaryDataInPermTable(objBatchSummery);
            // if (summeryInsert == 'Successfull') {
            //     return { result: "Success", HMIID: ipAdd };
            // }
            if (summeryInsert == 'Successfull') {
                return { result: "Success", HMIID: ipAdd, 
                StartTMDT: date.format(objGetTimeDateForSummary[0].BatchStartDTTM,objGetFormatDTTM[0].dateFormat.toUpperCase()) , 
                    EndTMDT: (date.format(objGetTimeDateForSummary[0].BatchEndDTTM,objGetFormatDTTM[0].dateFormat.toUpperCase()) == "aN/aN/aN") ? "" : date.format(objGetTimeDateForSummary[0].BatchEndDTTM,objGetFormatDTTM[0].dateFormat.toUpperCase())};
            }

        } catch (error) {
            return error;
        }
    }

    async getNUpdateBatchSize(ipAdd) {
        try {

            var str_batchSize = await models.tbl_batchsummary_temp.findAll({
                attributes: [sequelize.fn('DISTINCT', sequelize.col('BatchSize'))],
                where:
                {
                    BatchSize: { [Op.ne]: "NULL" },
                    HMIID: ipAdd
                }
            });

            await models.tbl_batchsummary_temp.update({
                BatchSize: str_batchSize[0].BatchSize
            }, {
                where:
                {
                    HMIID: ipAdd
                }
            });
        } catch (error) {
            return error;
        }
    }

    async insertParamToTempTable(strParamName, ipAdd, objBatchSummery, intParamNo, t) {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                await models.tbl_batchsummary_temp.create({
                    ParamNo: intParamNo,
                    ParamName: strParamName,
                    ProductType: objBatchSummery.str_productType,
                    BFGCode: objBatchSummery.str_prdID,
                    ProductName: objBatchSummery.str_prdName,
                    PVersion: objBatchSummery.str_prdVersion,
                    Version: objBatchSummery.str_version,
                    BatchNo: objBatchSummery.str_batches,
                    CubicleType: objBatchSummery.str_cubicleType,
                    Area: objBatchSummery.str_area,
                    HMIID: ipAdd
                }, {
                    transaction: t
                });
            });

            return "Inserted";
        } catch (error) {
            return error;
        }
    }

    /** Get data from master and detail table */
    async getDataFromSummaryTable_Master(intParamNo, objBatchSummery, strParamName) {
        try {
            
                var strTableName = (strParamName == "Filled Content Weight") ? "tbl_batchsummary_masterdiff" : "tbl_batchsummary_master" + intParamNo;
            let result = await models[strTableName].findAll({
                where:
                {
                    BFGCode: objBatchSummery.str_prdID,
                    ProductName: objBatchSummery.str_prdName,
                    PVersion: objBatchSummery.str_prdVersion,
                    Version: objBatchSummery.str_version,
                    CubicleType: objBatchSummery.str_cubicleType,
                    PrdType: objBatchSummery.str_productType,
                    BatchNo: objBatchSummery.str_batches,
                    Area: objBatchSummery.str_area
                }

            });

            return result;
            
        } catch (error) {
            return error;
        }
    }

    async updateInTempTable(intParamNo, resMaster, ipAdd, strUnit) {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                await models.tbl_batchsummary_temp.update({
                    Param_Unit: strUnit,
                    BatchSize: resMaster[0].BatchSize,
                    Param_RunTime: (intParamNo == 13) ? resMaster[0].StdTime : 'NULL',
                    Param_MinDT: (intParamNo == 13) ? resMaster[0].FinalMinDT : "00:00:00",
                    Param_MaxDT: (intParamNo == 13) ? resMaster[0].FinalMaxDT : "00:00:00",
                    Param_AvgDT: (intParamNo == 13) ? resMaster[0].FinalAvgDT : "00:00:00"
                }, {
                    where:
                    {
                        ParamNo: intParamNo,
                        HMIID: ipAdd
                    }
                }, {
                    transaction: t
                });
            });
        } catch (error) {
            return error;
        }
    }

    async updateUnit(intParamNo, ipAdd, strUnit) {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                if (intParamNo == 7) {
                    (strUnit == "" || strUnit == null || strUnit == undefined) ? strUnit = "Kp" : strUnit = strUnit;
                }
                else {
                    strUnit = strUnit;
                }

                await models.tbl_batchsummary_temp.update({
                    Param_Unit: strUnit
                }, {
                    where:
                    {
                        ParamNo: intParamNo,
                        HMIID: ipAdd
                    }
                }, {
                    transaction: t
                });
            });
        } catch (error) {
            return error;
        }
    }

    async updateIfFirstParameterNotDone(ipAdd) {
        try {
            let res = await models.tbl_batchsummary_temp.findAll({
                atrributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('BatchSize')), 'BatchSize']
                ],
                where:
                    { HMIID: ipAdd }
            });

            if (res.length > 0) {
                await models.tbl_batchsummary_temp.update({
                    BatchSize: res[0].BatchSize
                }, {
                    where:
                    {
                        HMIID: ipAdd,
                        BatchSize: 'NULL'
                    }
                });
            }
        } catch (error) {
            return error;
        }
    }

    async checkBatchSummaryDataInPermTable(objBatchSummery) {
        try {
            let objbs = {
                ProductType: objBatchSummery.str_productType,
                CubType: objBatchSummery.str_cubicleType,
                BatchNo: objBatchSummery.str_batches,
                ProductId: objBatchSummery.str_prdID,
                ProductName: objBatchSummery.str_prdName,
                PrdVersion: objBatchSummery.str_prdVersion,
                Version: objBatchSummery.str_version,
                Side: objBatchSummery.str_side,
                Area: objBatchSummery.str_area
            }
            
            if(serverConfig.developerPanelData.Summary[2].Value == 1)
            {
            Object.assign(objbs, {ReportOption: objBatchSummery.str_reportOption});
            }

            let res = await models.tbl_batchsummary.findAll({
                where: objbs
            });

            if (res.length == 0) {
                await models.tbl_batchsummary.create(objbs);
            }

            return "Successfull";

        } catch (error) {
            return error;
        }
    }

    async updateCalculationInTempTable(ipAdd, intParamNo, resMaster, strParamName, int_NoData, DP, strUnit, objBatchSummery) {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var intNom = 0, intT1Neg = 0, intT1Pos = 0, intT2Neg = 0, intT2Pos = 0, intMin = 0, intMax = 0, intAvg = 0, strRemark = "", remark = "", cnt = 0;
                if (intParamNo == 8) {
                    if (int_NoData == 0) {
                        intNom = "NA";
                        strRemark = "NA";
                    }
                    else {
                        intNom = (int_NoData == 0) ? "NA" : resMaster[0].Nom;
                        intMin = resMaster[0].MinValue;
                        intMax = resMaster[0].MaxValue;
                        intAvg = resMaster[0].AvgValue;
                        //strRemark = resMaster[0].FriabilityRemark;
                    }

                }
                // else if (intParamNo == 7) {
                //     if (int_NoData == 0) {
                //         intT1Neg = "0";
                //         intT1Pos = "0";
                //         strRemark = "NA";
                //     }
                //     else {
                //         intNom = resMaster[0].HardnessNom;
                //         intT1Neg = (int_NoData == 0 || resMaster[0].HardnessMin == null || resMaster[0].HardnessMin == '0.0') ? "0" : resMaster[0].HardnessLwr;
                //         intT1Pos = (int_NoData == 0 || resMaster[0].HardnessMin == null || resMaster[0].HardnessMin == '0.0') ? "0" : resMaster[0].HardnessUpp;
                //         intMin = (resMaster[0].HardnessMin == null || resMaster[0].HardnessMin == '0.0') ? "0.0" : resMaster[0].HardnessMin;
                //         intMax = (resMaster[0].HardnessMax == null || resMaster[0].HardnessMax == '0.0') ? "0.0" : resMaster[0].HardnessMax;
                //         intAvg = (resMaster[0].HardnessAvg == null || resMaster[0].HardnessAvg == '0.0') ? "0.0" : resMaster[0].HardnessAvg;
                //         if (math.roundUp(intT1Neg, 1) > math.roundUp(intMin, 1)) {
                //             cnt = cnt + 1;
                //         }
                //         if (math.roundUp(intT1Pos, 1) < math.roundUp(intMax, 1)) {
                //             cnt = cnt + 1;
                //         }

                //         strRemark = "";
                //         // (intNom == '0.0' || intNom == '0.00' || intNom == '0.0000' || intNom == '0.00000') ? "NA" :
                //         // (cnt > 0) ? "Out of Limit" : "Within Limit";//calDataUsingSP.HardnessRemark;

                //         if ((intNom == '0.0' || intNom == '0.00' || intNom == '0.0000' || intNom == '0.00000')) {
                //             strRemark = "NA"
                //         } else {
                //             if (cnt > 0) {
                //                 strRemark = "Out of Limit"
                //             } else {
                //                 strRemark = "Within Limit"
                //             }
                //         }
                //     }

                // }
                else if (intParamNo == 1 || intParamNo == 9 || intParamNo == 11 || strParamName == "Filled Content Weight") {
                    if (int_NoData == 0) {
                        intT1Neg = "0";
                        intT1Pos = "0";
                        intT2Neg = "0";
                        intT2Pos = "0";
                        strRemark = "NA";
                    }
                    else {
                        //var int_DP_avg = (strUnit == "mg") ? 2 : 4;
                        //DP = (strUnit == "mg") ? 1 : 4;

                        intNom = resMaster[0].Nom;
                        intT1Neg = (int_NoData == 0) ? "0" : resMaster[0].Tol1Neg;
                        intT1Pos = (int_NoData == 0) ? "0" : resMaster[0].Tol1Pos;
                        intT2Pos = (int_NoData == 0) ? "0" : resMaster[0].Tol2Pos;
                        intT2Neg = (int_NoData == 0) ? "0" : resMaster[0].Tol2Neg;
                        intMin = resMaster[0].MinValue;
                        intMax = resMaster[0].MaxValue;
                        intAvg = resMaster[0].AvgValue;
                        if (intT2Neg > intMin){
                            cnt = cnt + 1;
                        }
                        if (intT2Pos < intMax) {
                            cnt = cnt + 1;
                        }

                        strRemark = (cnt > 0) ? "Out of Limit" : "Within Limit";//calDataUsingSP.BalanceRemark;
                    }


                }
                else if (intParamNo == 2 || intParamNo == 10 || intParamNo == 12) {
                    if (int_NoData == 0) {
                        intT1Neg = "0";
                        intT1Pos = "0";
                        intT2Pos = "0";
                        intT2Neg = "0";
                        strRemark = "NA";
                    }
                    else {
                       // DP = (strUnit == "mg") ? 2 : 4;

                        intNom = resMaster[0].Nom;
                        intT1Neg = "0";
                        intT1Pos = "0";
                        intT2Pos = (int_NoData == 0) ? "0" : resMaster[0].Tol2Pos;
                        intT2Neg = (int_NoData == 0) ? "0" : resMaster[0].Tol2Neg;
                        intMin = resMaster[0].MinValue;
                        intMax = resMaster[0].MaxValue;
                        intAvg = resMaster[0].AvgValue;

                        if (intT2Neg > intMin) {
                            cnt = cnt + 1;
                        }
                        if (intT2Pos < intMax) {
                            cnt = cnt + 1;
                        }

                        strRemark = (intNom == '0.00' || intNom == '0.0000' || intNom == '0.00000') ? "NA" : (cnt > 0) ? "Out of Limit" : "Within Limit";//calDataUsingSP.BalanceGroupRemark;
                    }


                }
                // else if (intParamNo == 3) {
                //     if (int_NoData == 0) {
                //         intT1Neg = "0";
                //         intT1Pos = "0";
                //         strRemark = "NA";
                //     }
                //     else {
                //         intNom = resMaster[0].HardnessNomThick;
                //         intT1Neg = (int_NoData == 0 || resMaster[0].HardnessMinThick == null || resMaster[0].HardnessMinThick == '0.00') ? "0" : resMaster[0].HardnessLwrThick;
                //         intT1Pos = (int_NoData == 0 || resMaster[0].HardnessMinThick == null || resMaster[0].HardnessMinThick == '0.00') ? "0" : resMaster[0].HardnessUppThick;
                //         intMin = (resMaster[0].HardnessMinThick == null || resMaster[0].HardnessMinThick == '0.00') ? '0.00' : resMaster[0].HardnessMinThick;
                //         intMax = (resMaster[0].HardnessMaxThick == null || resMaster[0].HardnessMaxThick == '0.00') ? '0.00' : resMaster[0].HardnessMaxThick;
                //         intAvg = (resMaster[0].HardnessAvgThick == null || resMaster[0].HardnessAvgThick == '0.00') ? '0.00' : resMaster[0].HardnessAvgThick;

                //         if (math.roundUp(intT1Neg, 2) > math.roundUp(intMin, 2)) {
                //             cnt = cnt + 1;
                //         }
                //         if (math.roundUp(intT1Pos, 2) < math.roundUp(intMax, 2)) {
                //             cnt = cnt + 1;
                //         }

                //         strRemark = (intNom == '0.00' || intMin == '0.00') ? "NA" : (cnt > 0) ? "Out of Limit" : "Within Limit";//calDataUsingSP.HardnessRemarkThick;
                //     }
                // }
                // else if (intParamNo == 4) {
                //     if (int_NoData == 0) {
                //         intT1Neg = "0";
                //         intT1Pos = "0";
                //         strRemark = "NA";
                //     }
                //     else {
                //         intNom = resMaster[0].HardnessNomWidth;
                //         intT1Neg = (int_NoData == 0 || resMaster[0].HardnessMinWidth == null || resMaster[0].HardnessMinWidth == '0.00') ? "0" : resMaster[0].HardnessLwrWidth;
                //         intT1Pos = (int_NoData == 0 || resMaster[0].HardnessMinWidth == null || resMaster[0].HardnessMinWidth == '0.00') ? "0" : resMaster[0].HardnessUppWidth;
                //         intMin = (resMaster[0].HardnessMinWidth == null || resMaster[0].HardnessMinWidth == '0.00') ? '0.00' : resMaster[0].HardnessMinWidth;
                //         intMax = (resMaster[0].HardnessMaxWidth == null || resMaster[0].HardnessMaxWidth == '0.00') ? '0.00' : resMaster[0].HardnessMaxWidth;
                //         intAvg = (resMaster[0].HardnessAvgWidth == null || resMaster[0].HardnessAvgWidth == '0.00') ? '0.00' : resMaster[0].HardnessAvgWidth;

                //         if (math.roundUp(intT1Neg, 2) > math.roundUp(intMin, 2)) {
                //             cnt = cnt + 1;
                //         }
                //         if (math.roundUp(intT1Pos, 2) < math.roundUp(intMax, 2)) {
                //             cnt = cnt + 1;
                //         }


                //         strRemark = (intNom == '0.00' || intMin == '0.00') ? "NA" : (cnt > 0) ? "Out of Limit" : "Within Limit";//calDataUsingSP.HardnessRemarkWidth;
                //     }
                // }
                // else if (intParamNo == 5) {
                //     if (int_NoData == 0) {
                //         intT1Neg = "0";
                //         intT1Pos = "0";
                //         strRemark = "NA";
                //     }
                //     else {
                //         intNom = resMaster[0].HardnessNomLen;
                //         intT1Neg = (int_NoData == 0 || resMaster[0].HardnessMinLen == null || resMaster[0].HardnessMinLen == '0.00') ? "0" : resMaster[0].HardnessLwrLen;
                //         intT1Pos = (int_NoData == 0 || resMaster[0].HardnessMinLen == null || resMaster[0].HardnessMinLen == '0.00') ? "0" : resMaster[0].HardnessUppLen;
                //         intMin = (resMaster[0].HardnessMinLen == null || resMaster[0].HardnessMinLen == '0.00') ? '0.00' : resMaster[0].HardnessMinLen;
                //         intMax = (resMaster[0].HardnessMaxLen == null || resMaster[0].HardnessMaxLen == '0.00') ? '0.00' : resMaster[0].HardnessMaxLen;
                //         intAvg = (resMaster[0].HardnessAvgLen == null || resMaster[0].HardnessAvgLen == '0.00') ? '0.00' : resMaster[0].HardnessAvgLen;

                //         if (math.roundUp(intT1Neg, 2) > math.roundUp(intMin, 2)) {
                //             cnt = cnt + 1;
                //         }
                //         if (math.roundUp(intT1Pos, 2) < math.roundUp(intMax, 2)) {
                //             cnt = cnt + 1;
                //         }


                //         strRemark = (intNom == '0.00' || intMin == '0.00') ? "NA" : (cnt > 0) ? "Out of Limit" : "Within Limit";//calDataUsingSP.HardnessRemarkLen;
                //     }
                // }
                // else if (intParamNo == 6) {
                //     if (int_NoData == 0) {
                //         intT1Neg = "0";
                //         intT1Pos = "0";
                //         strRemark = "NA";
                //     }
                //     else {
                //         intNom = resMaster[0].HardnessNomDiam;
                //         intT1Neg = (int_NoData == 0 || resMaster[0].HardnessMinDiam == null || resMaster[0].HardnessMinDiam == '0.00') ? "0" : resMaster[0].HardnessLwrDiam;
                //         intT1Pos = (int_NoData == 0 || resMaster[0].HardnessMinDiam == null || resMaster[0].HardnessMinDiam == '0.00') ? "0" : resMaster[0].HardnessUppDiam;
                //         intMin = (resMaster[0].HardnessMinDiam == null || resMaster[0].HardnessMinDiam == '0.00') ? '0.00' : resMaster[0].HardnessMinDiam;
                //         intMax = (resMaster[0].HardnessMaxDiam == null || resMaster[0].HardnessMaxDiam == '0.00') ? '0.00' : resMaster[0].HardnessMaxDiam;
                //         intAvg = (resMaster[0].HardnessAvgDiam == null || resMaster[0].HardnessAvgDiam == '0.00') ? '0.00' : resMaster[0].HardnessAvgDiam;

                //         if (math.roundUp(intT1Neg, 2) > math.roundUp(intMin, 2)) {
                //             cnt = cnt + 1;
                //         }
                //         if (math.roundUp(intT1Pos, 2) < math.roundUp(intMax, 2)) {
                //             cnt = cnt + 1;
                //         }


                //         strRemark = (intNom == '0.00' || intMin == '0.00') ? "NA" : (cnt > 0) ? "Out of Limit" : "Within Limit";//calDataUsingSP.HardnessRemarkDiam;
                //     }
                // }
                else // vernier
                {
                    if (int_NoData == 0) {
                        intT2Neg = "0";
                        intT2Pos = "0";
                        strRemark = "NA";
                    }
                    else {
                        intNom = resMaster[0].Nom;
                        intT2Neg = (int_NoData == 0) ? "0" : resMaster[0].Tol2Neg;
                        intT2Pos = (int_NoData == 0) ? "0" : resMaster[0].Tol2Pos;
                        intMin = resMaster[0].MinValue;
                        intMax = resMaster[0].MaxValue;
                        intAvg = resMaster[0].AvgValue;
                        if (intT2Neg > intMin) {
                            cnt = cnt + 1;
                        }
                        if (intT2Pos < intMax) {
                            cnt = cnt + 1;
                        }

                        strRemark = (intNom == '0.00' || intMin == '0.00') ? "NA" : (cnt > 0) ? "Out of Limit" : "Within Limit";//calDataUsingSP.VernierRemark;
                    }

                }

                await models.tbl_batchsummary_temp.update({
                    Param_Nom: intNom,
                    Param_UppLimit: intT1Pos,
                    Param_LwrLimit: intT1Neg,
                    Param_UppLimit1: intT2Pos,
                    Param_LwrLimit1: intT2Neg,
                    Param_Min: intMin,
                    Param_Max: intMax,
                    Param_Avg: intAvg,
                    Remark: strRemark

                }, {
                    where:
                    {
                        ParamNo: intParamNo,
                        HMIID: ipAdd
                    }
                }, {
                    transaction: t
                });
            });
            return "Update"
        } catch (error) {
            return error;
        }

    }

    async calculateDataUsingSP(RepSerNo, strParamName, intParamNo) {
        try {
            let responseObj = {};

            let storedProcedureQuery = `CALL batchSummaryReportCalculation_Combine('${RepSerNo}','${intParamNo}','${strParamName}'`
                + `,@BalanceNom,@BalanceMin,@BalanceMax,@BalanceAvg,@BalanceT1Neg,@BalanceT1Pos,@BalanceT2Neg,@BalanceT2Pos,@BalanceRemark`
                + `,@BalanceGroupNom,@BalanceGroupMin,@BalanceGroupMax,@BalanceGroupAvg,@BalanceGroupT1Neg,@BalanceGroupT1Pos,@BalanceGroupRemark`
                + `,@VernierNom,@VernierT2Neg,@VernierT2Pos,@VernierMin,@VernierMax,@VernierAvg,@VernierRemark`
                + `,@HardnessNom,@HardnessLwr,@HardnessUpp,@HardnessMin,@HardnessMax,@HardnessAvg,@HardnessRemark`
                + `,@HardnessNomThick,@HardnessLwrThick,@HardnessUppThick,@HardnessMinThick,@HardnessMaxThick,@HardnessAvgThick,@HardnessRemarkThick`
                + `,@HardnessNomWidth,@HardnessLwrWidth,@HardnessUppWidth,@HardnessMinWidth,@HardnessMaxWidth,@HardnessAvgWidth,@HardnessRemarkWidth`
                + `,@HardnessNomLen,@HardnessLwrLen,@HardnessUppLen,@HardnessMinLen,@HardnessMaxLen,@HardnessAvgLen,@HardnessRemarkLen`
                + `,@HardnessNomDiam,@HardnessLwrDiam,@HardnessUppDiam,@HardnessMinDiam,@HardnessMaxDiam,@HardnessAvgDiam,@HardnessRemarkDiam`
                + `,@FriabilityNom,@FriabilityMin,@FriabilityMax,@FriabilityAvg,@FriabilityRemark);

            SELECT @BalanceNom as BalanceNom,@BalanceMin as BalanceMin,@BalanceMax as BalanceMax,@BalanceAvg as BalanceAvg`
                + `,@BalanceT1Neg as BalanceT1Neg,@BalanceT1Pos as BalanceT1Pos,@BalanceT2Neg as BalanceT2Neg,@BalanceT2Pos as BalanceT2Pos,@BalanceRemark as BalanceRemark`
                + `,@BalanceGroupNom as BalanceGroupNom,@BalanceGroupMin as BalanceGroupMin,@BalanceGroupMax as BalanceGroupMax,@BalanceGroupAvg as BalanceGroupAvg,@BalanceGroupT1Neg as BalanceGroupT1Neg,@BalanceGroupT1Pos as BalanceGroupT1Pos`
                + `,@BalanceGroupRemark as BalanceGroupRemark`
                + `,@VernierNom as VernierNom,@VernierT2Neg as VernierT2Neg,@VernierT2Pos as VernierT2Pos,@VernierMin as VernierMin,@VernierMax as VernierMax,@VernierAvg as VernierAvg,@VernierRemark as VernierRemark`
                + `,@HardnessNom as HardnessNom,@HardnessLwr as HardnessLwr,@HardnessUpp as HardnessUpp,@HardnessMin as HardnessMin,@HardnessMax as HardnessMax,@HardnessAvg as HardnessAvg,@HardnessRemark as HardnessRemark`
                + `,@HardnessNomThick as HardnessNomThick,@HardnessLwrThick as HardnessLwrThick,@HardnessUppThick as HardnessUppThick,@HardnessMinThick as HardnessMinThick,@HardnessMaxThick as HardnessMaxThick,@HardnessAvgThick as HardnessAvgThick,@HardnessRemarkThick as HardnessRemarkThick`
                + `,@HardnessNomWidth as HardnessNomWidth,@HardnessLwrWidth as HardnessLwrWidth,@HardnessUppWidth as HardnessUppWidth,@HardnessMinWidth as HardnessMinWidth,@HardnessMaxWidth as HardnessMaxWidth,@HardnessAvgWidth as HardnessAvgWidth,@HardnessRemarkWidth as HardnessRemarkWidth`
                + `,@HardnessNomLen as HardnessNomLen,@HardnessLwrLen as HardnessLwrLen,@HardnessUppLen as HardnessUppLen,@HardnessMinLen as HardnessMinLen,@HardnessMaxLen as HardnessMaxLen,@HardnessAvgLen as HardnessAvgLen,@HardnessRemarkLen as HardnessRemarkLen`
                + `,@HardnessNomDiam as HardnessNomDiam,@HardnessLwrDiam as HardnessLwrDiam,@HardnessUppDiam as HardnessUppDiam,@HardnessMinDiam as HardnessMinDiam,@HardnessMaxDiam as HardnessMaxDiam,@HardnessAvgDiam as HardnessAvgDiam,@HardnessRemarkDiam as HardnessRemarkDiam`
                + `,@FriabilityNom as FriabilityNom,@FriabilityMin as FriabilityMin,@FriabilityMax as FriabilityMax,@FriabilityAvg as FriabilityAvg,@FriabilityRemark as FriabilityRemark`;

            var result = await sequelize.query(storedProcedureQuery, { type: QueryTypes.SELECT });
            Object.assign(responseObj, { Values: result[1][0] })
            return responseObj;
        } catch (error) {
            return error;
        }

    }

    async updateMinMaxAvgDT_Combine(RepSerNo, RunTime, intParamNo, ipAdd) {
        try {
            var AvgTime = "";
            var MaxTime = "";
            var MinTime = "";
            var strRemark = "";

            var str_query = `SELECT TIME_FORMAT(SEC_TO_TIME(AVG(TIME_TO_SEC(AvgTimeDT))),'%H:%i:%s') AS 'AvgTime',`
                + `TIME_FORMAT(MIN(MinTimeDT),'%H:%i:%s') AS 'MinTime',TIME_FORMAT(MAX(MaxTimeDT),'%H:%i:%s') AS 'MaxTime' FROM tbl_batchsummary_detail13 where RepSerNo=${RepSerNo}`;
            var res = await sequelize.query(str_query);

            AvgTime = res[0][0].AvgTime;
            MaxTime = res[0][0].MaxTime;
            MinTime = res[0][0].MinTime;
            (MaxTime > RunTime) ? strRemark = "Out of Limit" : strRemark = "Within Limit";

            await models.tbl_batchsummary_master13.update({
                FinalMinDT: MinTime,
                FinalMaxDT: MaxTime,
                FinalAvgDT: AvgTime,
            }, {
                where:
                    { RepSerNo: RepSerNo }
            });


            await models.tbl_batchsummary_temp.update({
                Param_MinDT: MinTime,
                Param_MaxDT: MaxTime,
                Param_AvgDT: AvgTime,
                Remark: strRemark
            }, {
                where:
                {
                    ParamNo: intParamNo,
                    HMIID: ipAdd
                }
            });

            return "success";
        } catch (error) {
            return error;
        }
    }


    /** Product Summary Functions */

    async ProductSummary_getProductParameterWise(objProduct) {
        try {
            var result;
            if (objProduct.str_reportOption == "Length" || objProduct.str_reportOption == "Diameter") {
                result = await models[objProduct.str_tableName].findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('BFGCode')),
                        'ProductName',
                        'PVersion',
                        'Version'
                    ],
                    where:
                    {
                        CubicleType: objProduct.str_cubicleType,
                        PrdType: Number(objProduct.str_productType),
                        BatchCompleted: 1,
                        // DLBParamName: objProduct.str_reportOption        // missing column
                    }
                });
            }
            else if (objProduct.str_reportOption == "Width" || objProduct.str_reportOption == "Breadth") {
                result = await models[objProduct.str_tableName].findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('BFGCode')),
                        'ProductName',
                        'PVersion',
                        'Version'
                    ],
                    where:
                    {
                        CubicleType: objProduct.str_cubicleType,
                        PrdType: Number(objProduct.str_productType),
                        BatchCompleted: 1,
                    }
                });
            }
            else if (objProduct.str_reportOption == "Thickness") {
                result = await models[objProduct.str_tableName].findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('BFGCode')),
                        'ProductName',
                        'PVersion',
                        'Version'
                    ],
                    where:
                    {
                        CubicleType: objProduct.str_cubicleType,
                        PrdType: Number(objProduct.str_productType),
                        BatchCompleted: 1,
                    }
                });
            }
            else if (objProduct.str_reportOption == "Hardness") {
                result = await models[objProduct.str_tableName].findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('BFGCode')),
                        'ProductName',
                        'PVersion',
                        'Version'
                    ],
                    where:
                    {
                        CubicleType: objProduct.str_cubicleType,
                        PrdType: Number(objProduct.str_productType),
                        BatchCompleted: 1,
                    }
                });
            }
            else {
                result = await models[objProduct.str_tableName].findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('BFGCode')),
                        'ProductName',
                        'PVersion',
                        'Version'
                    ],
                    where:
                    {
                        CubicleType: objProduct.str_cubicleType,
                        PrdType: Number(objProduct.str_productType),
                        BatchCompleted: 1
                    }
                });

            }



            return result;
        } catch (error) {
            return error;
        }
    }

    async ProductSummary_getPrintNo(req) {
        try {
            let obj_response = {};
            let result = await models.tbl_productsummary.findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('PrintNo')), 'PrintNo']
                ],
                where:
                {
                    ProductType: req.str_productType,
                    CubType: req.str_cubicleType,
                    ReportOption: req.str_reportOption,
                    ProductId: req.str_prdID,
                    ProductName: req.str_prdName,
                    PrdVersion: req.str_prdVersion,
                    Version: req.str_version
                }
            });

            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;

        } catch (error) {
            return error;
        }
    }

    async processProductSummeryData(req, ip) {
        try {
            let obj_response = {};
            let Ip = requestIp.getClientIp(ip);
            let ClIp = Ip.split(':')[3]
            var ClientIp;
            if (ClIp === undefined) {
                ClientIp = '127.0.0.1';
            } else {
                ClientIp = ClIp;
            }
            // var ipAdd = ClientIp.split('.')[3];
            var ipAdd = ClientIp;
            /** Delete data from temp table */
            await models.tbl_productsummary_temp.destroy({
                where:
                    { HMI_ID: ipAdd }
            });

            /** check data exist or not */
            let int_masterSrNo = await this.getMasterSrNo_productSummary(req);
            var str_detailData = await this.getDetailData_productSummary(req, int_masterSrNo);

            if (str_detailData.length == 0) {
                Object.assign(obj_response, { status: "No Data" });
                return obj_response;
            }
            else {
                /** Insert data batchwise */
                let calculation;
                let calculationMaster;
                var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                    var str_unit_hardness = "", str_unit_Bal = "";
                    if (req.str_reportOption == "Hardness") /// get unit
                    {
                        // str_unit_hardness = await this.getUnit_productSummary_hardness(int_masterSrNo);
                        str_unit_hardness = await this.getUnit_productSummary(int_masterSrNo, req);
                    }

                    if (req.str_reportOption == "Individual" || req.str_reportOption == "Individual Layer 1" || req.str_reportOption == "Individual Layer 2" || req.str_reportOption == "Filled Content Weight"
                        || req.str_reportOption == "Group" || req.str_reportOption == "Group Layer 1" || req.str_reportOption == "Group Layer 2") {
                        str_unit_Bal = await this.getUnit_productSummary(int_masterSrNo, req);
                    }

                    var strUnit = (req.str_reportOption == "Individual" || req.str_reportOption == "Individual Layer 1" || req.str_reportOption == "Individual Layer 2" || req.str_reportOption == "Filled Content Weight") ? str_unit_Bal[0].Unit :
                        (req.str_reportOption == "Group" || req.str_reportOption == "Group Layer 1" || req.str_reportOption == "Group Layer 2") ? str_unit_Bal[0].Unit :
                            (req.str_reportOption == "Friability") ? "%w/w" : (req.str_reportOption == "Disintegration Tester") ? "HH:mm:ss" : (req.str_reportOption == "Hardness") ? str_unit_hardness[0].Unit : "mm";

                    for (const i of str_detailData) {
                        if (req.str_tableMasterName != "tbl_batchsummary_master_hdlb") {
                            let int_DPs = await this.getDP_productSummary(req, i);
                            // calculation = await this.getCalculation_productSummary(i, req, int_DPs[0].DP, strUnit);
                            calculationMaster = await this.getCalculation_productmastsummary(i, req, int_DPs[0].DP, strUnit);
                        }
                        else {
                            // calculation = await this.getCalculation_productSummary(i, req, 0, strUnit);
                            calculationMaster = await this.getCalculation_productmastsummary(i, req, 0, strUnit);
                        }


                        /** get Batch using rep ser no */
                        let str_batch = await this.getBatchNo_productSummary(i, req);
                        if (req.str_reportOption == "Hardness" || req.str_reportOption == "Width" || req.str_reportOption == "Thickness" || req.str_reportOption == "Length" || req.str_reportOption == "Diameter") {
                            // if (calculation.ValuesMin.MinValue != null) {
                                if (calculationMaster.ValuesMin.MinValue != null) {
                                // await this.insertIntoTempTable_productSummary(str_batch[0], calculation.Values, strUnit, ipAdd, req, calculation.ValuesMin, calculation.ValuesAvg);
                                await this.insertIntoTempTable_productSummary(str_batch[0], calculationMaster.Values, strUnit, ipAdd, req, calculationMaster.ValuesMin, calculationMaster.ValuesAvg);
                            }
                        }
                        else {
                            // await this.insertIntoTempTable_productSummary(str_batch[0], calculation.Values, strUnit, ipAdd, req, calculation.ValuesMin, calculation.ValuesAvg);
                            await this.insertIntoTempTable_productSummary(str_batch[0], calculationMaster.Values, strUnit, ipAdd, req, calculationMaster.ValuesMin, calculationMaster.ValuesAvg);
                        }

                    }

                });

                // check entry exist in table (for printno)
                var summeryInsert = await this.checkProductSummaryDataInPermTable(req);
                if (summeryInsert == "Successfull") {
                    Object.assign(obj_response, { HMIId: ipAdd });
                    return obj_response;
                }
            }

        } catch (error) {
            console.log("processProductSummeryData", error);
            return error;
        }
    }

    async getUnit_productSummary_hardness(repserno) {
        try {
            let res = await models.tbl_batchsummary_master_hdlb.findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('UnitHard')), 'UnitHard']
                ],
                where:
                {
                    RepSerNo: repserno[0].RepSerNo
                }
            });

            return res;
        } catch (error) {
            return error;
        }
    }

    async getUnit_productSummary(repserno, req) {
        try {
            let res = await models[req.str_tableMasterName].findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('Unit')), 'Unit']
                ],
                where:
                {
                    RepSerNo: repserno[0].RepSerNo
                }
            });

            return res;
        } catch (error) {
            return error;
        }
    }

    async getMasterSrNo_productSummary(req) {
        try {
            let res = await models[req.str_tableMasterName].findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('RepSerNo')), 'RepSerNo']
                ],
                where:
                {
                    PrdType: req.str_productType,
                    CubicleType: req.str_cubicleType,
                    BFGCode: req.str_prdID,
                    ProductName: req.str_prdName,
                    PVersion: req.str_prdVersion,
                    Version: req.str_version,
                    BatchCompleted: 1
                }
            });

            return res;
        } catch (error) {
            return error;
        }
    }

    async getDP_productSummary(req, RepSerNo) {
        try {
            let res = await models[req.str_tableMasterName].findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('DP')), 'DP']
                ],
                where:
                {
                    RepSerNo: RepSerNo
                }
            });

            return res;
        } catch (error) {
            return error;
        }
    }

    async getDetailData_productSummary(req, int_repSerNo) {
        try {
            var sarr_record = [];
            for (var i = 0; i <= int_repSerNo.length - 1; i++) {
                let res = await models[req.str_tableDetailName].findAll({
                    where:
                    {
                        RepSerNo: int_repSerNo[i].RepSerNo,
                        Date: { [Op.between]: [req.FromDate, req.ToDate] },
                    }
                });

                if (res.length > 0) {
                    sarr_record.push(int_repSerNo[i].RepSerNo);
                }

            }

            return sarr_record;
        } catch (error) {
            return error;
        }
    }

    async getCalculation_productSummary(RepSerNo, req, int_DPs, strUnit) {
        try {
            let obj_response = {};
            var str_queryDetail = "", str_queryDetailMin = "", str_queryDetailAvg = "";

            if (req.str_reportOption == "Individual" || req.str_reportOption == "Individual Layer-1" || req.str_reportOption == "Individual Layer-2" || req.str_reportOption == "Filled Content Weight") {
                int_DPs = (strUnit == "mg") ? 1 : 4;
                var int_DPs_avg = (strUnit == "mg") ? 2 : 4;
                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt',ROUND(CAST(MIN(Min) AS DECIMAL(20,15)),${int_DPs}) AS 'MinValue',ROUND(CAST(MAX(Max) AS DECIMAL(20,15)),${int_DPs}) AS 'MaxValue',`
                    + `  ROUND(CAST(AVG(CAST(Avg AS DECIMAL(20, 15))) AS DECIMAL(20, 15)), ${int_DPs_avg}) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }
            else if (req.str_reportOption == "Hardness") {
                str_queryDetailMin = `Select ROUND(CAST(MIN(MinHard) AS DECIMAL(20,15)),1) AS 'MinValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE MinHard <> 0.00000 and RepSerNo= ${RepSerNo}`;

                str_queryDetailAvg = `Select ROUND(CAST(AVG(AvgHard) AS DECIMAL(20,15)),1) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE AvgHard <> 0.00000 and RepSerNo= ${RepSerNo}`;


                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt',ROUND(CAST(MAX(MaxHard) AS DECIMAL(20,15)),1) AS 'MaxValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }
            else if (req.str_reportOption == "Length" || req.str_reportOption == "Diameter") {
                str_queryDetailMin = `Select ROUND(CAST(MIN(MinDiam) AS DECIMAL(20,15)),2) AS 'MinValue',`
                    + ` ROUND(CAST(AVG(AvgDiam) AS DECIMAL(20,15)),2) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE MinDiam <> 0.00000 and RepSerNo= ${RepSerNo}`;

                str_queryDetailAvg = `Select ROUND(CAST(AVG(AvgDiam) AS DECIMAL(20,15)),2) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE AvgDiam <> 0.00000 and RepSerNo= ${RepSerNo}`;


                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt',ROUND(CAST(MAX(MaxDiam) AS DECIMAL(20,15)),2) AS 'MaxValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }
            else if (req.str_reportOption == "Width") {
                str_queryDetailMin = `Select ROUND(CAST(MIN(MinDLB) AS DECIMAL(20,15)),2) AS 'MinValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE MinDLB <> 0.00000 and RepSerNo= ${RepSerNo}`;

                str_queryDetailAvg = `Select ROUND(CAST(AVG(AvgDLB) AS DECIMAL(20,15)),2) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE AvgDLB <> 0.00000 and RepSerNo= ${RepSerNo}`;

                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt',ROUND(CAST(MAX(MaxDLB) AS DECIMAL(20,15)),2) AS 'MaxValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }
            else if (req.str_reportOption == "Thickness") {
                str_queryDetailMin = `Select ROUND(CAST(MIN(CAST(Min AS DECIMAL(20, 15))) AS DECIMAL(20, 15)),2) AS 'MinValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE Min <> 0.00000 and RepSerNo= ${RepSerNo}`;

                str_queryDetailAvg = `Select ROUND(CAST(AVG(Avg) AS DECIMAL(20,15)),2) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE Avg <> 0.00000 and RepSerNo= ${RepSerNo}`;

                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt',ROUND(CAST(MAX(Max) AS DECIMAL(20,15)),2) AS 'MaxValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }
            else if (req.str_reportOption == "Group" || req.str_reportOption == "Group Layer-1" || req.str_reportOption == "Group Layer-2") {
                int_DPs = (strUnit == "mg") ? 2 : 4;
                //,MAX(Date) as 'EndDt'
                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt', ROUND(CAST(MIN(CAST(Min AS DECIMAL(20, 15))) AS DECIMAL(20, 15)),${int_DPs}) AS 'MinValue',ROUND(CAST(MAX(Max) AS DECIMAL(20,15)),${int_DPs}) AS 'MaxValue',`
                    + ` ROUND(CAST(AVG(CAST(Avg AS DECIMAL(20, 15))) AS DECIMAL(20, 15)), ${int_DPs}) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }
            else if (req.str_reportOption == "Friability") {
                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt', ROUND(CAST(MIN(CAST(Min AS DECIMAL(20, 15))) AS DECIMAL(20, 15)),4) AS 'MinValue',ROUND(CAST(MAX(Max) AS DECIMAL(20,15)),4) AS 'MaxValue',`
                    + `  ROUND(CAST(AVG(CAST(Avg AS DECIMAL(20, 15))) AS DECIMAL(20, 15)), 4) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }
            else if (req.str_reportOption == "Disintegration Tester") {
                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt',TIME_FORMAT(SEC_TO_TIME(AVG(TIME_TO_SEC(AvgTimeDT))),'%H:%i:%s') AS 'AvgValue',`
                    + ` TIME_FORMAT(MIN(MinTimeDT),'%H:%i:%s') AS 'MinValue',TIME_FORMAT(MAX(MaxTimeDT),'%H:%i:%s') AS 'MaxValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }
            else // Vernier
            {
                str_queryDetail = `Select MIN(Date) as 'StartDt',MAX(Date) as 'EndDt',ROUND(CAST(MIN(CAST(Min AS DECIMAL(20, 15))) AS DECIMAL(20, 15)),2) AS 'MinValue',ROUND(CAST(MAX(Max) AS DECIMAL(20,15)),2) AS 'MaxValue',`
                    + ` ROUND(CAST(AVG(CAST(Avg AS DECIMAL(20, 15))) AS DECIMAL(20, 15)), 2) AS 'AvgValue'`
                    + ` FROM ${req.str_tableDetailName} WHERE RepSerNo= ${RepSerNo}`;
            }


            var result = await sequelize.query(str_queryDetail);

            if (req.str_reportOption == "Hardness" || req.str_reportOption == "Width" || req.str_reportOption == "Thickness" || req.str_reportOption == "Length" || req.str_reportOption == "Diameter") {
                var resultMin = await sequelize.query(str_queryDetailMin);
                var resultAvg = await sequelize.query(str_queryDetailAvg);
                Object.assign(obj_response, { Values: result[1][0] }, { ValuesMin: resultMin[1][0] }, { ValuesAvg: resultAvg[1][0] });
            }
            else {
                // Object.assign(obj_response, { Values: result[1][0] }, { ValuesMin: "" }, { ValuesAvg: "" });
                Object.assign(obj_response, { Values: result[0][0] }, { ValuesMin: "" }, { ValuesAvg: "" });
            }


            return obj_response;
        } catch (error) {
            console.log("Calculation", error);
            return error;
        }

    }

  async getCalculation_productmastsummary(RepSerNo,req, int_DPs, strUnit) {
    try {
    let obj_response = {};
    var str_queryDetail = "", str_queryDetailMin = "", str_queryDetailAvg = "";

    if (req.str_reportOption == "Individual" || req.str_reportOption == "Individual Layer 1" || req.str_reportOption == "Individual Layer 2" || req.str_reportOption == "Filled Content Weight") {
        int_DPs = (strUnit == "mg") ? 1 : 4;
        var int_DPs_avg = (strUnit == "mg") ? 2 : 4;
        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt',MinValue AS 'MinValue', MaxValue AS 'MaxValue',`
            + `  AvgValue AS 'AvgValue', Min_Per AS 'MinPer', Max_Per AS 'MaxPer'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }
    else if (req.str_reportOption == "Hardness") {
        str_queryDetailMin = `Select MinValue AS 'MinValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;

        str_queryDetailAvg = `Select AvgValue AS 'AvgValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;


        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt',MaxValue AS 'MaxValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }
    else if (req.str_reportOption == "Length" || req.str_reportOption == "Diameter") {
        str_queryDetailMin = `Select MinValue AS 'MinValue',`
            + ` AvgValue AS 'AvgValue'`
            + ` FROM ${req.str_tableMasterName} WHERE  RepSerNo= ${RepSerNo}`;

        str_queryDetailAvg = `Select AvgValue AS 'AvgValue'`
            + ` FROM ${req.str_tableMasterName} WHERE  RepSerNo= ${RepSerNo}`;


        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt',MaxValue AS 'MaxValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }
    else if (req.str_reportOption == "Width") {
        str_queryDetailMin = `Select MinValue AS 'MinValue'`
            + ` FROM ${req.str_tableMasterName} WHERE MinDLB <> 0.00000 and RepSerNo= ${RepSerNo}`;

        str_queryDetailAvg = `Select AvgValue AS 'AvgValue'`
            + ` FROM ${req.str_tableMasterName} WHERE AvgDLB <> 0.00000 and RepSerNo= ${RepSerNo}`;

        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt',MaxValue AS 'MaxValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }
    else if (req.str_reportOption == "Thickness") {
        str_queryDetailMin = `Select MinValue AS 'MinValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;

        str_queryDetailAvg = `Select AvgValue AS 'AvgValue'`
            + ` FROM ${req.str_tableMasterName} WHERE  RepSerNo= ${RepSerNo}`;

        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt',MaxValue AS 'MaxValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }
    else if (req.str_reportOption == "Group" || req.str_reportOption == "Group Layer 1" || req.str_reportOption == "Group Layer 2") {
        int_DPs = (strUnit == "mg") ? 2 : 4;
        //,MAX(Date) as 'EndDt'
        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt', MinValue AS 'MinValue',MaxValue AS 'MaxValue',`
            + ` AvgValue AS 'AvgValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }
    else if (req.str_reportOption == "Friability") {
        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt', MinValue AS 'MinValue',MaxValue AS 'MaxValue',`
            + ` AvgValue AS 'AvgValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }
    else if (req.str_reportOption == "Disintegration Tester" || req.str_reportOption == "DT") {
        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt',FinalAvgDT AS 'AvgValue',`
            + ` FinalMinDT AS 'MinValue',FinalMaxDT AS 'MaxValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }
    else // Vernier
    {
        str_queryDetail = `Select StartDate as 'StartDt',EndDate as 'EndDt',MinValue AS 'MinValue',MaxValue AS 'MaxValue',`
            + ` AvgValue AS 'AvgValue'`
            + ` FROM ${req.str_tableMasterName} WHERE RepSerNo= ${RepSerNo}`;
    }


    var result = await sequelize.query(str_queryDetail);

    if (req.str_reportOption == "Hardness" || req.str_reportOption == "Width" || req.str_reportOption == "Thickness" || req.str_reportOption == "Length" || req.str_reportOption == "Diameter") {
        var resultMin = await sequelize.query(str_queryDetailMin);
        var resultAvg = await sequelize.query(str_queryDetailAvg);
        Object.assign(obj_response, { Values: result[0][0] }, { ValuesMin: resultMin[0][0] }, { ValuesAvg: resultAvg[0][0] });
    }
    else {
        // Object.assign(obj_response, { Values: result[1][0] }, { ValuesMin: "" }, { ValuesAvg: "" });
        Object.assign(obj_response, { Values: result[0][0] }, { ValuesMin: "" }, { ValuesAvg: "" });
    }


    return obj_response;
    
    } catch (error) {
        console.log("Calculation", error);
        throw error;
    }

  }

    async getBatchNo_productSummary(int_repSerNo, req) {
        try {
            let res = await models[req.str_tableMasterName].findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('BatchNo')), 'BatchNo']
                ],
                where:
                {
                    RepSerNo: int_repSerNo
                }
            });

            return res;
        } catch (error) {
            return error;
        }
    }

    async insertIntoTempTable_productSummary(str_batch, calculation, strUnit, ipAdd, req, calculationMin, calculationAvg) {
        try {
            await models.tbl_productsummary_temp.create({
                ParamName: req.str_reportOption,
                Param_Min: (req.str_reportOption == "Disintegration Tester") ? 0 : (calculationMin == "") ? calculation.MinValue : calculationMin.MinValue,
                Param_Max: (req.str_reportOption == "Disintegration Tester") ? 0 : calculation.MaxValue,
                Param_Avg: (req.str_reportOption == "Disintegration Tester") ? 0 : (calculationAvg == "") ? calculation.AvgValue : calculationAvg.AvgValue,
                Param_Unit: strUnit,
                ProductType: req.str_productType,
                ProductId: req.str_prdID,
                ProductName: req.str_prdName,
                PVersion: req.str_prdVersion,
                Version: req.str_version,
                BatchNo: str_batch.BatchNo,
                CubType: req.str_cubicleType,
                Param_MinDT: (req.str_reportOption == "Disintegration Tester") ? calculation.MinValue : "00:00:00",
                Param_MaxDT: (req.str_reportOption == "Disintegration Tester") ? calculation.MaxValue : "00:00:00",
                Param_AvgDT: (req.str_reportOption == "Disintegration Tester") ? calculation.AvgValue : "00:00:00",
                HMI_ID: ipAdd,
                StartDt: calculation.StartDt,
                EndDt: calculation.EndDt,
                Min_Per: calculation.MinPer,
                Max_Per: calculation.MaxPer

            });
            return "Insert";
        } catch (error) {
            console.log("Insert Summary", error)
            return error;
        }
    }

    async checkProductSummaryDataInPermTable(req) {
        try {
            let res = await models.tbl_productsummary.findAll({
                where:
                {
                    ProductType: req.str_productType,
                    CubType: req.str_cubicleType,
                    ReportOption: req.str_reportOption,
                    ProductId: req.str_prdID,
                    ProductName: req.str_prdName,
                    PrdVersion: req.str_prdVersion,
                    Version: req.str_version
                }
            });

            if (res.length == 0) {
                await models.tbl_productsummary.create({
                    ProductType: req.str_productType,
                    CubType: req.str_cubicleType,
                    ReportOption: req.str_reportOption,
                    ProductId: req.str_prdID,
                    ProductName: req.str_prdName,
                    PrdVersion: req.str_prdVersion,
                    Version: req.str_version
                });
            }

            return "Successfull";

        } catch (error) {
            return error;
        }
    }

    async printcountupProductSummary(objPrintCount) {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var now = new Date();
                await models.tbl_productsummary.update({
                    PrintNo: parseInt(Number(objPrintCount.int_printNo + 1))
                }, {
                    where:
                    {
                        ProductType: objPrintCount.str_prdType,
                        CubType: objPrintCount.str_cubType,
                        ReportOption: objPrintCount.str_reportOption,
                        ProductId: objPrintCount.str_prdID,
                        ProductName: objPrintCount.str_prdName,
                        PrdVersion: objPrintCount.str_prdVersion,
                        Version: objPrintCount.str_version
                    }
                }, {
                    transaction: t
                });

                await models.tbl_productsummary_printrecord.create({
                    Print_Dt: date.format(now, 'YYYY-MM-DD'),
                    Print_Tm: date.format(now, 'HH:mm:ss'),
                    UserID: objPrintCount.strUserId,
                    UserName: objPrintCount.strUserName,
                    ProductType: objPrintCount.str_prdType,
                    CubType: objPrintCount.str_cubType,
                    ParamName: objPrintCount.str_reportOption,
                    ProductId: objPrintCount.str_prdID,
                    ProductName: objPrintCount.str_prdName,
                    PrdVersion: objPrintCount.str_prdVersion,
                    Version: objPrintCount.str_version,
                    PrintNo: parseInt(Number(objPrintCount.int_printNo + 1)),
                    Reason: objPrintCount.strReason
                }, {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPrintCount.strUserId,
                    username: objPrintCount.strUserName,
                    activity: "Product Summary Report Printed - " + objPrintCount.str_reportOption
                }, {
                    transaction: t
                });
            });
            return "Success";
        } catch (error) {
            return error;
        }
    }

}
module.exports = BatchModel