/*
 * JasperReports - Free Java Reporting Library.
 * Copyright (C) 2001 - 2013 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of JasperReports.
 *
 * JasperReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JasperReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with JasperReports. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.jasperreports.forms.textinput;

import net.sf.jasperreports.engine.JRGenericElementType;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: TextInputElement.java 5922 2013-02-19 11:03:27Z teodord $
 */
public interface TextInputElement 
{
	
	public static final String TEXT_INPUT_ELEMENT_NAME = "textInput";
	public static final JRGenericElementType TEXT_INPUT_ELEMENT_TYPE = new JRGenericElementType(TextInputElementHandlerBundle.NAMESPACE, TEXT_INPUT_ELEMENT_NAME);

	public static final String PARAMETER_MULTI_LINE = "multiLine";
	public static final String PARAMETER_PRINT_TEXT_ELEMENT = "printText";
	
}