// Server Config modules
var config = require('../../../IncrencyV4CP10GConfig.json');

host = config.host;
maxDevices = 20;
WebPort = config.WebPort;
APIPORT = config.APIPORT;
hostApi = config.hostApi;
dbHost = config.dbHost;
dbUser = config.dbUser;
dbPass = config.dbPass;
dbName = config.dbName;
reporthost = config.reporthost;
foxit_path = config.foxit_path;
FtpHost = config.FtpHost;
FtpUname = config.FtpUname;
FtpPass = config.FtpPass;
strIpSeries = config.strIpSeries;
isLDAP = config.isLDAP;
byPassLDAP = config.byPassLDAP;
developerPanelFileName = config.developer_panel;
developerPanelData =  require('../../' + developerPanelFileName);

module.exports.host = host
module.exports.APIPORT = APIPORT
module.exports.maxDevices = maxDevices
module.exports.reporthost = reporthost
module.exports.foxit_path = foxit_path
module.exports.WebPort = WebPort
module.exports.dbUser = dbUser
module.exports.encryptedDBPass = dbPass
module.exports.dbName = dbName
module.exports.dbHost = dbHost
module.exports.FtpHost = FtpHost
module.exports.FtpUname = FtpUname
module.exports.FtpPass = FtpPass
module.exports.strIpSeries = strIpSeries
module.exports.isLDAP = isLDAP
module.exports.byPassLDAP = byPassLDAP
module.exports.developerPanelFileName = developerPanelFileName
module.exports.developerPanelData = developerPanelData
module.exports.hostApi = hostApi
/**
 * inline function to provide key in decrypted form 
 */
module.exports.decryptAsync = ( async (password) => {
    try {
        if(config.SetCrypto){
            const { decryptbrw } = await import("configpasswordencrypt");
            let res = decryptbrw(password)
            return res;
        }else{
            return password
        }
    } catch(error) {
        console.log("decryptAsync() : Error ", error);
        throw error
    }
});

/**
 *  inline function that will initialise dbpass so that can use in required
 */
module.exports.exportDBPass = (password) => { module.exports.dbPass = password  }