const clsstageModel = require('../model/clsstageModel');
const objClsStageModel = new clsstageModel();
var Joi = require('joi');
const clsStageSchema = require('../Validation/Stage/Stage.schema');
const objClsStageSchema = new clsStageSchema();

exports.getStage = (req, res) => {
    objClsStageModel.getStage().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.storeStage = (req, res) => {
    Joi.validate(req.body, objClsStageSchema.saveStageSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objClsStageModel.storeStage(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    }); 
}