const InterfaceModel = require('../model/interfaceModel');
const objInterfaceModel = new InterfaceModel();
exports.getIdsList = (req, res) => {
    objInterfaceModel.getIds().then((result) => {
        res.send(result[0])
    }).catch((err) => {
       // console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    });
}
// below function gives user details based on UserId only required for biometric module
exports.getUserDetail = (req, res) => {
    objInterfaceModel.getUserDetail(req.body.str_UserId)
        .then(result => {
            res.send(result[0]);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
}
exports.getUser = (req, res) => {
    objInterfaceModel.getUser(req.body.strUserId, req.body.strPassword)
        .then((result) => {
            //        console.log('pradip', result[0])
            res.send(result[0]);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
}
exports.getIdsDeatails = (req, res) => {
    objInterfaceModel.getIdsDeatails().then((result) => {
        res.send(result[0]);
    }).catch((err) => {
        console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
    });
}
exports.checkDailyCalibration = (req, res) => {
    objInterfaceModel.checkDailyCalibration(req.body.strBalId).then((result) => {
        res.send(result[0]);
    }).catch(err => { console.log('error in interface controller, checkDailyCalibration() while fetching DailyCalibration') })
}
exports.getBalanceCalibrationWeights = (req, res) => {
    objInterfaceModel.getBalanceCalibrationWeights(req.body.strBalId).then((result) => { 
        res.send(result[0]);
    }).catch(err => { console.log('error in interface controller, getBalanceCalibrationWeights() while fetching CalibrationWeights') })
}
exports.getAllParameters = (req, res) => { 
    objInterfaceModel.getAllParameters().then(result => { 
        res.send(result[0])
    }).catch(err => { console.log('error in interface controller, getAllParameters() while fetching parameters')})
}
