const printer = require('@thiagoelg/node-printer');
const path = require('path');
const config = require('../global/serverConfig');
var child_process = require('child_process');
const { default: axios } = require('axios');
const clsprinterModel = require('../model/clsprinterModel');
const objPrinterModel = new clsprinterModel();
const printpdf = require('pdf-to-printer');

/** This function is used to get the list of printers  */
exports.getPrinterList = (req, res) => {
    var printers = printer.getPrinters();
    var printerslist = {
        "PrinterName": printers.map(a => a.name)
    }

    res.statusCode = 200;
    res.send(printerslist);
}

async function print(pathToFile, pathToFoxit, printerName, cb) {
    var command = '"' + pathToFoxit + '" /t "' + pathToFile + '" "' + printerName + '"';
  // console.log(command);
    console.log(command);
    child_process.exec(command,{ maxBuffer: 10*1024 * 1024 }, cb);

}

/** This function is used to print the report  */
exports.printReport = (req, res) => {
    /**
     * @description Here we have filepath path like `http://192.168.1.145:8082/reports/RepoActivityLog9.pdf` 
     * but we have to send only `reports/RepoActivityLog9.pdf` to print function so we split the path using 
     * `/` so finnaly we get he path
     */
    var { reportObj, apiEndPoint } = req.body;
    console.log(apiEndPoint);
    var url = `http://${config.hostApi}:${config.APIPORT}/API/${apiEndPoint}`;
    var parts = req.body.filepath.split('/');
    var fileName = parts[parts.length - 2]+"/"+parts[parts.length - 1];
    var filepath = path.resolve(fileName);
    var strSelectedPrinter = req.body.strSelectedPrinter;
    printPDF(filepath,strSelectedPrinter).then( result => {
        console.log("Axios data",reportObj);
        if (apiEndPoint != '' && apiEndPoint) {
                axios.post(url, reportObj).then((result) => {
                console.log(result.data.result);
                    console.log('PrintUp Reuslt', result.data);
                    res.statusCode = 200;
                    strSuccessMessage = {
                        "Message": "Print Successfull"
                    }
                    res.send(strSuccessMessage);
            }).catch(error => {
                console.error(`Error ${apiEndPoint}:`, error);
                res.statusCode = 500;
                let responseObj = {};
                Object.assign(responseObj, { status: "fail" }, { result: error.message });
                res.send(responseObj);
            });
        } else {
            console.log("Non-Increment Print Successfull");
            res.statusCode = 200;
            strSuccessMessage = {
                "Message": "Print Successfull"
            }
            res.send(strSuccessMessage);
        }
    }).catch( err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
            responseObj, {
                status: "fail"
            }, {
                result: "Internal server error"
            }
        );
        res.send(responseObj);
    });
    
}

function printPDF(pdfFilePath, printerName) {
    return new Promise((resolve, reject) => {
        // Print the PDF to the specified printer
        const options = {
            printer: printerName,
        };
        printpdf.print(pdfFilePath, options).then((res)=>{    // returns undefined 
            console.log("print success",res);
            resolve('Done');
        })
        .catch((err) =>{
            console.log("print not success",err)
            reject(err)
        })
    }) 
}        

exports.incrementPrintNo = (req,res) => {
    if((req.body.repSrNo == '') || (req.body.repSrNo === undefined))
    {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    }
    else
    {
        objPrinterModel.incrementPrintNo(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}
