const OtherEquipmentModel = require('../model/clsOtherEquipmentModel');
const objOtherEquipmentModel = new OtherEquipmentModel();
var Joi = require('joi');
const clsEquipmentSchema = require('../Validation/Equipment/Equipment.schema');
const objClsEquipmentSchema = new clsEquipmentSchema();

exports.getOtherEquipment = (req, res) => {
    objOtherEquipmentModel.getOtherEquipment().then((result) => {
        res.statusCode = 200;
        res.send(result)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}
exports.storeOtherEquipment = (req, res) => {
    Joi.validate(req.body, objClsEquipmentSchema.saveEquipmentSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objOtherEquipmentModel.storeOtherEquipment(req).then((result) => {
                res.statusCode = 200;
                res.send(result)
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    });
    
}
exports.updateOtherEquipment = (req, res) => {
    Joi.validate(req.body, objClsEquipmentSchema.editEquipmentSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objOtherEquipmentModel.updateOtherEquipment(req).then((result) => {
                res.statusCode = 200;
                res.send(result)
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}

exports.getDetailData = (req, res) => {

    Joi.validate(req.body, objClsEquipmentSchema.getDetailEquipmentSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objOtherEquipmentModel.getDetailData(req).then((result) => {
                res.statusCode = 200;
                res.send(result)
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}

exports.updateActivestatus = (req, res) => {
    Joi.validate(req.body, objClsEquipmentSchema.activateDeactivateEquipmentSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objOtherEquipmentModel.updateActivestatus(req).then((result) => {
                res.statusCode = 200;
                res.send(result)
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
    
}
exports.getWeights = (req, res) => { 
    Joi.validate(req.body, objClsEquipmentSchema.getWeightSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objOtherEquipmentModel.getWeights(req).then(result => {
                res.statusCode = 200;
                res.send(result)
             }).catch(err => { 
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}
exports.checkInCubicle = (req,res) => {
    objOtherEquipmentModel.checkInCubicle(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}