const Joi = require('joi');
const ActivityLog = require('../model/activitylog.model');
const objActivitylog = new ActivityLog();
const ActivitylogShema  = require('../validation/activitylog/activitylog.shema');
const objActivitylogShema = new ActivitylogShema();

/**
 * @description to store data in tbl_activity_log
 */
exports.storeActivity = (req,res) => {
    Joi.validate(req.body, objActivitylogShema.ActivityLogSchema(), (err, value) => {
        if(err){
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {result: err})
            res.send(responseObj);
        }else{
            objActivitylog.storeActivity(value).then(result => {
                res.statusCode = 200;
                res.send(result);
             }).catch(err => { 
                 console.log(err)
                 res.statusCode = 500;
                 let responseObj = {}
                 Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                 res.send(responseObj);
            })
        }
    })
}