const dbconnnection = require("../../dbConnection").models;
class WebSocketModel { 
    /**
     * 
     * @param {*} sock socket for disconnected client
     * @description Function for releasing user if browser close as well as Relase all parametes which
     * are in `tbl_edit_status`
     */
    handleSocket(sock) {
        var WebSocketIP = sock.request.connection.remoteAddress;
        // CHECK IF THERE IS ENTRY IN 'tbl_edit_status' IF PRESENT THEN WE HAVE TO RELEASE RESPECTED FIELD
        // IN RESPECTED TABLE

        dbconnnection.tbl_edit_status.findAll({logging : false, where:{"Ip":WebSocketIP}}).then(result =>{
            if (result.length > 0) {
                for (let i = 0; i < result.length; i++) { 
                    let str_char = '=';
                    if (result[i].fieldName.includes(',')) {
                        str_char = ',';
                    }
                    let arrConditionColumn = result[i].fieldName.split(str_char); // result[i].fieldName.split('=');
                    let arrConditionValue = result[i].Item.split(str_char);  // result[i].Item.split('='); 
                    for (let j = 0; j < arrConditionColumn.length; j++) { 
                        var tableName = result[i].Type;
                        dbconnnection[tableName].update({
                            locked: 0
                        },
                        { where :
                            {  [arrConditionColumn[j]] : arrConditionValue[j] }
                        }).then(res=>{
                            dbconnnection.tbl_edit_status.destroy({where:
                                {"Ip":WebSocketIP}
                            }).then(() => { 
                                console.log('Parameters release successfully, Due to browser closed OR browser refresh')
                            }).catch(err => { console.log(err)});
                        }).catch(err => console.log(err));
                    }
                }
            }
        }).catch(err => console.log(err));

        // Release User After browser close 
        
        setTimeout(() => {
            var globalData = require('../../../API/global/globalData')
            if (globalData.arrWebSocket.find(k => k.request.connection.remoteAddress == WebSocketIP) == undefined) {
                dbconnnection.tbl_users.update({
                    'active':  0,
                     'HostName': 0 
                },
                { where : 
                    {   HostName: WebSocketIP }
                }).then(res=>{
                    console.log('User Logouts due to browser close')
                }).catch(err => console.log(err));
            }
        }, 15000);

    }
    DatabaseCon() { }
}
module.exports = WebSocketModel;