const Joi = require('joi');

class BinSchema {
    getCleanerSchema() {
        const getCleanerSchema = Joi.object().keys({
            cleanerID: Joi.string().required().not(['', null, 'undefined']),
            cleanerName: Joi.string().required().not(['', null, 'undefined']),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(255).required().not(['', null, 'undefined']),
            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            Activity: Joi.string().max(100).required().not(['', null, 'undefined'])
        })
        return getCleanerSchema;
    }

    getStageSchema() {
        const getStageSchema = Joi.object().keys({
            stage: Joi.string().max(200).required().not(['', null, 'undefined']),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(255).required().not(['', null, 'undefined']),
            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            Activity: Joi.string().max(100).required().not(['', null, 'undefined'])
        })
        return getStageSchema;
    }

    getContainerSchema() {
        const getContainerSchema = Joi.object().keys({
            containerID: Joi.string().required().not(['', null, 'undefined']),
            Product: Joi.string().required().not(['', null, 'undefined']),
            prdType: Joi.number().required().not(['', null, 'undefined']),
            tareWeight: Joi.number().unsafe().required().not(['', null, 'undefined']),
            tareWeightDP: Joi.number().empty("").default(0),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(255).required().not(['', null, 'undefined']),
            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            Activity: Joi.string().max(100).required().not(['', null, 'undefined'])
        })
        return getContainerSchema;
    }

    updateBinSchema()
    { 
        const updateSchema = Joi.object().keys({
            Sys_Area: Joi.string().max(200).required().not(['', null, 'undefined']),
            Sys_CubicType: Joi.string().max(100).required().not(['', null, 'undefined']),
            Sys_CubicNo : Joi.number().required().not(['', null, 'undefined']),
            Sys_CubicName: Joi.string().max(100).required().not(['', null, 'undefined']),
            Layer: Joi.string().required().not(['', null, 'undefined']),
            Sys_BFGCode: Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_ProductName: Joi.string().max(300).required().not(['',null,'undefined']),
            Sys_Version: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_PVersion: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_Batch: Joi.string().max(30).required().not(['',null,'undefined']),
            Sys_BatchSize : Joi.string().required().not(['', null, 'undefined']),
            Sys_PrinterName: Joi.string().max(500).required().not(['', null, 'undefined']),
            Sys_TotalBin: Joi.number().required(),
            Sys_TotalBinSelected: Joi.number().required(),
            Sys_InitialStage: Joi.string().max(200).required().not(['', null, 'undefined']),
            Sys_NextStage: Joi.string().max(200).required().not(['', null, 'undefined']),
            Sys_MfgDate: Joi.string().max(200).required().not(['', 'undefined']).allow(null),
            Sys_ExpDate: Joi.string().max(200).required().not(['', 'undefined']).allow(null),
            arr_removed: Joi.allow(),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_Lot: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_LabelHeader: Joi.string().max(200).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            NewData : Joi.string().required().not(['', null, 'undefined']),
            OldData: Joi.string().required().not(['', null, 'undefined']),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            userid: Joi.string().max(50).required().not(['', null, 'undefined']),
            activity: Joi.string().max(50).required().not(['', null, 'undefined']),
            NADate: Joi.allow(),
            Sys_Bin: Joi.array().items(
                Joi.object({
                    id: Joi.number().not([null, 'undefined']),
                    itemName: Joi.string().not([null, 'undefined']),
                    tareWt: Joi.string().not([null, 'undefined'])
                }) ),
            Sys_OldBin:Joi.array().items(
                Joi.object({
                    id: Joi.number().not([null, 'undefined']),
                    itemName: Joi.string().not([null, 'undefined']),
                    tareWt: Joi.string().not([null, 'undefined'])
                }) )
        });
        
        return updateSchema;
    }

    releaseContainerSchema()
    { 
        const releaseContainerSchema = Joi.object().keys({
            bin_PrdName: Joi.string().max(300).required().not(['', null, 'undefined']),
            bin_CubType: Joi.string().max(100).required().not(['', null, 'undefined']),
            bin_CleanerID: Joi.string().max(200).required().not(['',null,'undefined']),
            bin_CleanerName: Joi.string().max(200).required().not(['',null,'undefined']),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(255).required().not(['', null, 'undefined']),
            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            Activity: Joi.string().max(50).required().not(['', null, 'undefined']),
            bin_BinID: Joi.string().max(300).required().not(['', null, 'undefined']),
            bin_PrevPrdName:Joi.string().max(300).required().not(['', null, 'undefined'])
        });
        
        return releaseContainerSchema;
    }

    storeBinDataInTempSchema() {
        const storeBinDataInTempSchema = Joi.object().keys({
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_ICReport: Joi.string().required().not(['', null, 'undefined']),
            str_batches: Joi.string().required().not(['', null, 'undefined']),
            UserId: Joi.string().required().not(['', null, 'undefined']),
            UserName: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_version: Joi.string().required().not(['', null, 'undefined']),   
        })
        return storeBinDataInTempSchema;
    }

    storeBinLabelDataInTempSchema() {
        const storeBinLabelDataInTempSchema = Joi.object().keys({
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_ICReport: Joi.string().required().not(['', null, 'undefined']),
            UserId: Joi.string().required().not(['', null, 'undefined']),
            UserName: Joi.string().required().not(['', null, 'undefined']),
            RecNo: Joi.number().required(),
            idsNo:Joi.allow().optional(),
            str_hmi: Joi.allow(),
            str_source: Joi.allow()  
        })
        return storeBinLabelDataInTempSchema;
    }

    getProductFromCubicalSchema() {
        const getProductFromCubicalSchema = Joi.object().keys({
            str_prodId: Joi.string().required().not(['', null, 'undefined']),
            str_prodName: Joi.string().required().not(['', null, 'undefined']),
            str_prodVerNo: Joi.string().required().not(['', null, 'undefined']),
            str_verNo: Joi.string().required().not(['', null, 'undefined']),
        })
        return getProductFromCubicalSchema;
    }
}
module.exports = BinSchema