const BaseJoi = require('joi');
const Extension = require('joi-date-extensions');
const Joi = BaseJoi.extend(Extension);

class Precalibraion {

    handledWeighmentDataSchema()
    { 
        const handledWeighmentDataSchema = Joi.object().keys({
            id: Joi.number().required().not([null, 'undefined']),
            UID: Joi.number().required().not([null, 'undefined']),
            Equipment_ID: Joi.string().required().not(['',null,'undefined']),
            Equipment_Type: Joi.string().required().not([null, 'undefined']),
            Cubicle_Number: Joi.number().required().not([null, 'undefined']),
            Area_Name: Joi.string().required().not([null, 'undefined']),
            Cubicle_Name: Joi.string().required().not([null, 'undefined']),
            Standard_Weight_Block: Joi.number().required().not([null, 'undefined']),
            Negative_Tolerance: Joi.number().required().not([null, 'undefined']),
            Positive_Tolerance: Joi.number().required().not([null, 'undefined']),
            CalibrationBox_ID: Joi.string().required().not([null, 'undefined']),
            CalibrationBox_Calibration_Date: Joi.string().required().not([null, 'undefined']),
            CalibrationBox_Validity_Date: Joi.string().required().not([null, 'undefined']),
            CalibrationBox_Calibration_CertificateNo: Joi.string().required().not([null, 'undefined']),
            CalibrationBox_Elements_IDNo: Joi.allow(),
            CalibrationBox_Selected_Elements: Joi.string().required().not([null, 'undefined']),
            CalibrationBox_Elements_Unit: Joi.string().required().not([null, 'undefined']),
            Repeat_Count: Joi.number().required().not([null, 'undefined']),
            Percent_of_Capacity: Joi.number().required().not(['',null,'undefined']),
            Decimal_Point: Joi.number().required().not([null, 'undefined']),
            calibrationType: Joi.string().required().not([null, 'undefined']),
            userId: Joi.string().required().not(['',null,'undefined']),
            userName: Joi.string().required().not([null, 'undefined']),
            act:Joi.string().required().not([null, 'undefined'])
        });
        
        return handledWeighmentDataSchema;
    }

    storePrecalibrationSchema()
        {
            const storePrecalibrationSchema = Joi.object().keys({
                area:Joi.string().required().not([null, 'undefined']),
                calibrationType: Joi.string().required().not([null, 'undefined']),
                UID:Joi.number().required().not([null, 'undefined']),
                standardWeight:Joi.string().required().not([null, 'undefined']),
                cubicleName:Joi.string().required().not([null, 'undefined']),
                cublicleNo:Joi.number().required().not([null, 'undefined']),
                equipmentType:Joi.string().required().not(['',null,'undefined']),
                equipmentID:Joi.string().required().not(['',null,'undefined']),
                positiveTolerance: Joi.number().required().not([null, 'undefined']),
                negativeTolerance: Joi.number().required().not([null, 'undefined']),
                calibrationBoxID:Joi.string().required().not([null, 'undefined']),
                act:Joi.string().required().not([null, 'undefined']),
                strPorjectName:Joi.string().required().not(['',null,'undefined']),
                userId:Joi.string().required().not(['',null,'undefined']),
                userName:Joi.string().required().not(['',null,'undefined']),
                decimalPoint:Joi.number().required().not([null, 'undefined']),
                repeatCount:Joi.number().required().not([null, 'undefined']),
                percentageOfCapacity:Joi.allow(),
                calibrationCertificateNo:Joi.string().required().not([null, 'undefined']),
                calibrationBoxDate:Joi.string().required().not([null, 'undefined']),
                calibrationBoxValidityDate:Joi.string().required().not([null, 'undefined']),
                weightBox: Joi.allow(),
                weights:Joi.array()
            });
            
            return storePrecalibrationSchema; 
        }
    
}



module.exports = Precalibraion;