const Joi = require('joi');

class DepartmentSchema {
    saveDepartmentSchema()
    { 
        const saveDepartmentSchema = Joi.object().keys({
            department: Joi.string().max(50).required().not(['',null,'undefined']),
            loggedUserId: Joi.string().max(50).required().not(['',null,'undefined']),
            loggedUserName: Joi.string().max(255).required().not(['',null,'undefined']),
            action: Joi.string().max(50).required().not(['',null,'undefined']),
            remark: Joi.string().max(300).required().not(['', null, 'undefined'])
        });
        
        return saveDepartmentSchema;
    }

    updateDepartmentSchema(){
        const updateDepartmentSchema = Joi.object().keys({
            deptId: Joi.number().required().not(['',null,'undefined']),
            deptName: Joi.string().max(50).required().not(['',null,'undefined']),
            loggeduserid: Joi.string().max(50).required().not(['',null,'undefined']),
            loggedusername: Joi.string().max(255).required().not(['',null,'undefined']),
            action: Joi.string().max(50).required().not(['',null,'undefined']),
            remark: Joi.string().max(500).required().not(['', null, 'undefined'])
        });
        
        return updateDepartmentSchema;  
    }

    

    updateDeptLockStatusSchema(){
        const updateDeptLockStatusSchema = Joi.object().keys({
            deptId: Joi.string().required().not(['',null,'undefined']),
            lock_status: Joi.string().required().not(['',null,'undefined'])
        });
        
        return updateDeptLockStatusSchema;  
    }
}
module.exports = DepartmentSchema;