const Joi = require('joi');

class YieldSchema {
    getProductDetail() {
        const productSchema = Joi.object().keys({
            area: Joi.string().required().not(['', null, 'undefined'])
        })
        return productSchema;
    }

    getBatchDetail() {
        const batchSchema = Joi.object().keys({
            BFGCode: Joi.string().required().not(['', null, 'undefined']),
            ProductName: Joi.string().required().not(['', null, 'undefined']),
            PVersion: Joi.string().required().not(['', null, 'undefined']),
            Version: Joi.string().required().not(['', null, 'undefined']),
            Area: Joi.string().required().not(['', null, 'undefined']),
        })
        return batchSchema;
    }

    getBatchFromMasterSchema() {
        const getBatchFromMasterSchema = Joi.object().keys({
            BFGCode: Joi.string().required().not(['', null, 'undefined']),
            ProductName: Joi.string().required().not(['', null, 'undefined']),
            PVersion: Joi.string().required().not(['', null, 'undefined']),
            Version: Joi.string().required().not(['', null, 'undefined'])
        })
        return getBatchFromMasterSchema;
    }

    getYieldDetail() {
        const yieldSchema = Joi.object().keys({
            BatchNo: Joi.string().required().not(['', null, 'undefined']),
            BFGCode: Joi.string().required().not(['', null, 'undefined']),
            ProductName: Joi.string().required().not(['', null, 'undefined']),
            PVersion: Joi.string().required().not(['', null, 'undefined']),
            Version: Joi.string().required().not(['', null, 'undefined']),
            Area: Joi.string().required().not(['', null, 'undefined']),
        })
        return yieldSchema;
    }

    saveYieldData() {
        const saveYieldSchema = Joi.object().keys({
            product: Joi.string().required().not(['', null, 'undefined']),
            productType: Joi.string().required().not(['', null, 'undefined']),
            BFGCode: Joi.string().required().not(['', null, 'undefined']),
            ProductName: Joi.string().required().not(['', null, 'undefined']),
            PVersion: Joi.string().required().not(['', null, 'undefined']),
            Version: Joi.string().required().not(['', null, 'undefined']),
            cubicalType: Joi.string().required().not(['', null, 'undefined']),
            selectedYield: Joi.string().required().not(['', null, 'undefined']),
            batch: Joi.string().required().not(['', null, 'undefined']),
            UserId: Joi.string().required().not(['', null, 'undefined']),
            UserName: Joi.string().required().not(['', null, 'undefined']),
            DecimalPoint: Joi.string().default(5),
            PrintNo: Joi.string().default(0),
            stdWt: Joi.string().required().not(['', null, 'undefined']),
            theoriticalYield: Joi.required().not(['', null, 'undefined']),

            TheoreticalYield_KG_1: Joi.required().not(['', null, 'undefined']),
            TheoreticalYield_GM_1: Joi.required().not(['', null, 'undefined']),
            TheoreticalYield_NOS_1: Joi.required().not(['', null, 'undefined']),
            TheoreticalYield_P_1: Joi.required().not(['', null, 'undefined']),

            AverageWeight_KG_2: Joi.required().not(['', null, 'undefined']),
            AverageWeight_GM_2: Joi.required().not(['', null, 'undefined']),
            AverageWeight_NOS_2: Joi.required().not(['', null, 'undefined']),
            AverageWeight_P_2: Joi.required().not(['', null, 'undefined']),

            ActualWeightFirstLayer_KG_19: Joi.required().not(['', null, 'undefined']),
            ActualWeightFirstLayer_GM_19: Joi.required().not(['', null, 'undefined']),
            ActualWeightFirstLayer_NOS_19: Joi.required().not(['', null, 'undefined']),
            ActualWeightFirstLayer_P_19: Joi.required().not(['', null, 'undefined']),

            ActualWeightSecondLayer_KG_20: Joi.required().not(['', null, 'undefined']),
            ActualWeightSecondLayer_GM_20: Joi.required().not(['', null, 'undefined']),
            ActualWeightSecondLayer_NOS_20: Joi.required().not(['', null, 'undefined']),
            ActualWeightSecondLayer_P_20: Joi.required().not(['', null, 'undefined']),

            YieldOfLubricatedGranules_KG_3: Joi.required().not(['', null, 'undefined']),
            YieldOfLubricatedGranules_GM_3: Joi.required().not(['', null, 'undefined']),
            YieldOfLubricatedGranules_NOS_3: Joi.required().not(['', null, 'undefined']),
            YieldOfLubricatedGranules_P_3: Joi.required().not(['', null, 'undefined']),

            YieldOfCompressed_KG_4: Joi.required().not(['', null, 'undefined']),
            YieldOfCompressed_GM_4: Joi.required().not(['', null, 'undefined']),
            YieldOfCompressed_NOS_4: Joi.required().not(['', null, 'undefined']),
            YieldOfCompressed_P_4: Joi.required().not(['', null, 'undefined']),

            YieldOfCompressedNLT: Joi.required().not(['', null, 'undefined']),
            YieldOfCoated_KG_5: Joi.required().not(['', null, 'undefined']),
            YieldOfCoated_GM_5: Joi.required().not(['', null, 'undefined']),
            YieldOfCoated_NOS_5: Joi.required().not(['', null, 'undefined']),

            YieldOfCoated_P_5: Joi.required().not(['', null, 'undefined']),
            YieldOfCoatedNLT: Joi.required().not(['', null, 'undefined']),
            YieldOfCapsule_KG_6: Joi.required().not(['', null, 'undefined']),
            YieldOfCapsule_GM_6: Joi.required().not(['', null, 'undefined']),

            YieldOfCapsule_NOS_6: Joi.required().not(['', null, 'undefined']),
            YieldOfCapsule_P_6: Joi.required().not(['', null, 'undefined']),
            YieldOfCapsuleNLT: Joi.required().not(['', null, 'undefined']),
            SampleQuantityInProcess_KG_7: Joi.required().not(['', null, 'undefined']),

            SampleQuantityInProcess_GM_7: Joi.required().not(['', null, 'undefined']),
            SampleQuantityInProcess_NOS_7: Joi.required().not(['', null, 'undefined']),
            SampleQuantityInProcess_P_7: Joi.required().not(['', null, 'undefined']),
            SampleQuantityQualityControl_KG_8: Joi.required().not(['', null, 'undefined']),

            SampleQuantityQualityControl_GM_8: Joi.required().not(['', null, 'undefined']),
            SampleQuantityQualityControl_NOS_8: Joi.required().not(['', null, 'undefined']),
            SampleQuantityQualityControl_P_8: Joi.required().not(['', null, 'undefined']),
            ValidationSamples_KG_9: Joi.required().not(['', null, 'undefined']),

            ValidationSamples_GM_9: Joi.required().not(['', null, 'undefined']),
            ValidationSamples_NOS_9: Joi.required().not(['', null, 'undefined']),
            ValidationSamples_P_9: Joi.required().not(['', null, 'undefined']),
            YieldIncudingSample_KG_15: Joi.required().not(['', null, 'undefined']),

            YieldIncudingSample_GM_15: Joi.required().not(['', null, 'undefined']),
            YieldIncudingSample_NOS_15: Joi.required().not(['', null, 'undefined']),
            YieldIncudingSample_P_15: Joi.required().not(['', null, 'undefined']),
            Rejects_KG_10: Joi.required().not(['', null, 'undefined']),

            Rejects_GM_10: Joi.required().not(['', null, 'undefined']),
            Rejects_NOS_10: Joi.required().not(['', null, 'undefined']),
            Rejects_P_10: Joi.required().not(['', null, 'undefined']),
            ResidualRejects_KG_11: Joi.required().not(['', null, 'undefined']),

            ResidualRejects_GM_11: Joi.required().not(['', null, 'undefined']),
            ResidualRejects_NOS_11: Joi.required().not(['', null, 'undefined']),
            ResidualRejects_P_11: Joi.required().not(['', null, 'undefined']),
            TotalAccounted_KG_12: Joi.required().not(['', null, 'undefined']),

            TotalAccounted_GM_12: Joi.required().not(['', null, 'undefined']),
            TotalAccounted_NOS_12: Joi.required().not(['', null, 'undefined']),
            TotalAccounted_P_12: Joi.required().not(['', null, 'undefined']),
            UnaccountedLoss_KG_13: Joi.required().not(['', null, 'undefined']),

            UnaccountedLoss_GM_13: Joi.required().not(['', null, 'undefined']),
            UnaccountedLoss_NOS_13: Joi.required().not(['', null, 'undefined']),
            UnaccountedLoss_P_13: Joi.required().not(['', null, 'undefined']),
            TotalLoss_KG_14: Joi.required().not(['', null, 'undefined']),

            TotalLoss_GM_14: Joi.required().not(['', null, 'undefined']),
            TotalLoss_NOS_14: Joi.required().not(['', null, 'undefined']),
            TotalLoss_P_14: Joi.required().not(['', null, 'undefined']),
            TotalLossNMT: Joi.required().not(['', null, 'undefined']),

            SampleQuantityInProcess_KG_16: Joi.required().not(['', null, 'undefined']),
            SampleQuantityInProcess_GM_16: Joi.required().not(['', null, 'undefined']),
            SampleQuantityInProcess_NOS_16: Joi.required().not(['', null, 'undefined']),
            SampleQuantityInProcess_P_16: Joi.required().not(['', null, 'undefined']),

            SampleQuantityQualityControl_KG_17: Joi.required().not(['', null, 'undefined']),
            SampleQuantityQualityControl_GM_17: Joi.required().not(['', null, 'undefined']),
            SampleQuantityQualityControl_NOS_17: Joi.required().not(['', null, 'undefined']),
            SampleQuantityQualityControl_P_17: Joi.required().not(['', null, 'undefined']),

            ValidationSamples_KG_18: Joi.required().not(['', null, 'undefined']),
            ValidationSamples_GM_18: Joi.required().not(['', null, 'undefined']),
            ValidationSamples_NOS_18: Joi.required().not(['', null, 'undefined']),
            ValidationSamples_P_18: Joi.required().not(['', null, 'undefined']),
        })
        return saveYieldSchema;
    }
}

module.exports = YieldSchema;