const Joi = require('joi');

class SoftgelReportSchema {
    getSoftshellSchema()
    { 
        const getSoftshellSchema = Joi.object().keys({
            fromDate: Joi.string().max(100).required().not(['',null,'undefined']),
            toDate: Joi.string().max(500).required().not(['',null,'undefined']),
            reportType: Joi.string().max(50).required().not(['',null,'undefined']),
            recordFrom: Joi.string().max(20).required().not(['',null,'undefined']),
            
        });
        return getSoftshellSchema;
    }
    viewSoftshellSchema(){
        const viewSoftshellSchema = Joi.object().keys({
            recordFrom: Joi.string().max(100).required().not(['',null,'undefined']),
            reportType: Joi.string().max(500).required().not(['',null,'undefined']),
            RepSerNo: Joi.number().required().not(['',null,'undefined']),
            userId: Joi.string().max(500).required().not(['',null,'undefined']),
            username: Joi.string().max(500).required().not(['',null,'undefined']),
            printNo: Joi.number().required().not(['',null,'undefined'])
            
        });
        return viewSoftshellSchema; 
    }
    printoftshellSchema(){
        const printoftshellSchema = Joi.object().keys({
            recordFrom: Joi.string().max(100).required().not(['',null,'undefined']),
            reportType: Joi.string().max(500).required().not(['',null,'undefined']),
            RepSrNo: Joi.number().required().not(['',null,'undefined'])
            
        });
        return printoftshellSchema;   
    }

    insertprintoftshellSchema(){
        const viewSoftshellSchema = Joi.object().keys({
            reportType: Joi.string().required().not(['', null, 'undefined']),
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            RepSrNo:Joi.number().required().not(['', null, 'undefined']),
            intPrintCount: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            
        });
        return viewSoftshellSchema;    
    }

    VerifyReportSoftShell() {
        const VerifyReportSoftShell = Joi.object().keys({
            recordFrom: Joi.string().required(),
            reportType: Joi.string().required(),
            intReportSerNo: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required()
        })
        return VerifyReportSoftShell;
    }
}

module.exports = SoftgelReportSchema;