const Joi = require('joi');

class CalibrationSchema 
{
    saveCalibrationSchema()
    { 
        const saveCalibrationSchema = Joi.object().keys
        ({            
            CB_ID: Joi.string().max(50).required().not(['',null,'undefined']),
            CB_Type: Joi.string().max(100).required().not(['',null,'undefined']),
            CB_Wt: Joi.allow(),
            CB_CertNo: Joi.string().max(100).required().not(['',null,'undefined']),
            CB_CalibDt: Joi.allow(),
            CB_MassWeight: Joi.allow(),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            CB_validDt: Joi.allow(),
            ACB_oldValue: Joi.allow(),
            ACB_oldValue: Joi.allow(),
            Remark: Joi.string().max(300).required().not(['',null,'undefined']),
            activity: Joi.string().max(150).required().not(['',null,'undefined']),
            userid: Joi.allow(),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            NewData: Joi.allow(),
            int_IdentificationNo: Joi.allow(),
        });
        
        return saveCalibrationSchema;
    }

    updateCalibrationSchema()
    { 
        const updateCalibrationSchema = Joi.object().keys
        ({            
            CB_ID: Joi.string().max(50).required().not(['',null,'undefined']),
            CB_Type: Joi.string().max(100).required().not(['',null,'undefined']),
            CB_Wt: Joi.allow(),
            CB_MassWeight: Joi.allow(),
            CB_CertNo: Joi.string().max(100).required().not(['',null,'undefined']),
            CB_CalibDt: Joi.allow(),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            CB_validDt: Joi.allow(),
            ACB_oldValue: Joi.allow(),
            ACB_oldValue: Joi.allow(),
            Remark: Joi.string().max(300).required().not(['',null,'undefined']),
            activity: Joi.string().max(150).required().not(['',null,'undefined']),
            userid: Joi.allow(),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            NewData: Joi.allow(),
            int_IdentificationNo: Joi.allow(),
            ACB_newValue: Joi.allow(),
            ACB_OldWeight: Joi.allow(),
            ACB_NewWeight: Joi.allow(),
        });
        
        return updateCalibrationSchema;
    }
}



module.exports = CalibrationSchema;