const Joi = require('joi');
class BatchSchema {
    // Schema for the tablet report for all types
    getProductSchema() {
        const getReportSchema = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_db_tableName: Joi.string().required().not(['', null, 'undefined']),
            str_side: Joi.string().required().not(['', null, 'undefined']),
            str_area: Joi.string().required().not(['', null, 'undefined'])
        })
        return getReportSchema;
    }

    getbatchesSchema() {
        const getReportSchema = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_db_tableName: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_side: Joi.string().required().not(['', null, 'undefined']),
            str_version: Joi.string().required().not(['', null, 'undefined']),
            str_area: Joi.string().required().not(['', null, 'undefined'])
        })
        return getReportSchema;
    }

    getbatchesAllSchema() {
        const getbatchesAllSchema = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_version: Joi.string().required().not(['', null, 'undefined']),
            str_area: Joi.string().required().not(['', null, 'undefined']),
            str_projectName: Joi.allow()
        })
        return getbatchesAllSchema;
    }


    getprintnoSchema() {

        const getprintnoSchema = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_batches: Joi.string().required().not(['', null, 'undefined']),
            str_reportOption: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_side:Joi.string().required().not(['', null, 'undefined']),
            str_version:Joi.string().required().not(['', null, 'undefined']),
            str_area: Joi.string().required().not(['', null, 'undefined'])
        })
        return getprintnoSchema;
    }

    getprintnoAllSchema() {

        const getprintnoAllSchema = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_batches: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_version:Joi.string().required().not(['', null, 'undefined']),
            str_area: Joi.string().required().not(['', null, 'undefined'])
        })
        return getprintnoAllSchema;
    }

    getprintnoAllSchema_ProductSummary() {

        const getprintnoAllSchema_ProductSummary = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_reportOption: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_version:Joi.string().required().not(['', null, 'undefined'])
        })
        return getprintnoAllSchema_ProductSummary;
    }

    storeBatchTempSchema() {
        const storeBatchTempSchema = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_tableName_master: Joi.string().required().not(['', null, 'undefined']),
            str_tableName_detail: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_batches: Joi.string().required().not(['', null, 'undefined']),
            UserId: Joi.string().required().not(['', null, 'undefined']),
            UserName: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_version: Joi.string().required().not(['', null, 'undefined']),
            str_reportOption: Joi.string().required().not(['', null, 'undefined']),
            str_side:Joi.string().required().not(['', null, 'undefined']),
            str_area: Joi.string().required().not(['', null, 'undefined']),
            str_projectName:Joi.string().required().not(['', null, 'undefined'])
        })
        return storeBatchTempSchema;
    }

    storeBatchTempAllSchema() {
        const storeBatchTempAllSchema = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_batches: Joi.string().required().not(['', null, 'undefined']),
            UserId: Joi.string().required().not(['', null, 'undefined']),
            UserName: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_version: Joi.string().required().not(['', null, 'undefined']),
            str_projectName:Joi.string().required().not(['', null, 'undefined']),
            str_area:Joi.string().required().not(['', null, 'undefined']),
           // str_batchSize:Joi.string().required().not(['', null, 'undefined']),
            arrParameters:Joi.array()     
        })
        return storeBatchTempAllSchema;
    }

     PrintReportCountSummaryAll() {
        const PrintReportCountSummaryAll = Joi.object().keys({
            str_batchNo: Joi.string().required(),
            str_cubType: Joi.string().required(),
            str_prdID: Joi.string().required(),
            str_prdName: Joi.string().required(),
            str_prdVersion: Joi.string().required(),
            str_version: Joi.string().required(),
            int_printNo: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            str_prdType: Joi.string().required(),
            str_area: Joi.string().required()
        })
        return PrintReportCountSummaryAll;
    }

    storeProductTempSchema() {
        const storeProductTempSchema = Joi.object().keys({
            str_productType: Joi.string().required().not(['', null, 'undefined']),
            str_cubicleType: Joi.string().required().not(['', null, 'undefined']),
            str_reportOption: Joi.string().required().not(['', null, 'undefined']),
            UserId: Joi.string().required().not(['', null, 'undefined']),
            UserName: Joi.string().required().not(['', null, 'undefined']),
            str_prdID: Joi.string().required().not(['', null, 'undefined']),
            str_prdName: Joi.string().required().not(['', null, 'undefined']),
            str_prdVersion: Joi.string().required().not(['', null, 'undefined']),
            str_version: Joi.string().required().not(['', null, 'undefined']),
            FromDate: Joi.allow(),
            ToDate: Joi.allow(),
            str_tableMasterName: Joi.string().required().not(['', null, 'undefined']),
            str_tableDetailName: Joi.string().required().not(['', null, 'undefined'])  
        })
        return storeProductTempSchema;
    }

    PrintReportCountProductSummary() {
        const PrintReportCountProductSummary = Joi.object().keys({
            str_reportOption: Joi.string().required(),
            str_cubType: Joi.string().required(),
            str_prdID: Joi.string().required(),
            str_prdName: Joi.string().required(),
            str_prdVersion: Joi.string().required(),
            str_version: Joi.string().required(),
            int_printNo: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            str_prdType: Joi.string().required()
        })
        return PrintReportCountProductSummary;
    }
}
module.exports = BatchSchema