const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_tapdensity', {
    RepSerNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    MstSerNo: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    WgmtModeNo: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },  
    ProductType: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    Area: {
        type: DataTypes.STRING(200),
        allowNull: true,
        defaultValue: "NULL"
    },
    CubicalNo: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    CubicleName: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    CubicleType: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    IPQCType: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    CoatingType: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    MachineCode: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    Department: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    BFGCode: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    ProductName: {
        type: DataTypes.STRING(500),
        allowNull: true,
        defaultValue: "NULL"
    },
    PVersion: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    Version: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    BatchNo: {
        type: DataTypes.STRING(25),
        allowNull: true,
        defaultValue: "NULL"
    },
    BatchSize: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    BMRNo: {
        type: DataTypes.STRING(150),
        allowNull: true,
        defaultValue: "NULL"
    },
    Qty: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    GrpQty: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    GrpFreq: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    Idsno: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    BalanceId: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDID: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    UserId: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    UserName: {
        type: DataTypes.STRING(200),
        allowNull: true,
        defaultValue: "NULL"
    },
    PrDate: {
        type: DataTypes.DATEONLY,
        allowNull: true
    },
    PrTime: {
        type: DataTypes.TIME,
        allowNull: true
    },
    PrEndDate: {
        type: DataTypes.DATEONLY,
        allowNull: true
    },
    PrEndTime: {
        type: DataTypes.TIME,
        allowNull: true
    },
    SideNo: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    Side: {
        type: DataTypes.STRING(20),
        allowNull: true,
        defaultValue: "NULL"
    },
    Unit: {
        type: DataTypes.STRING(10),
        allowNull: true,
        defaultValue: "NULL"
    },
    T1NegTD: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    T1PosTD: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TNegBulk: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TPosBulk: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    BulkWeight: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    BulkVolume: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    BulkDensity: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDCount1: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDCount2: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDCount3: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDCount4: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDVol1: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDVol2: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDVol3: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDVol4: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDVol5: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    TDensity: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    ReportType: {
        type: DataTypes.STRING(5),
        allowNull: true,
        defaultValue: "NULL"
    },
    PrintNo: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    IsArchived: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    BatchComplete: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: "0"
    },
    CheckedByID: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    CheckedByName: {
        type: DataTypes.STRING(200),
        allowNull: true,
        defaultValue: "NULL"
    },
    CheckedByDate: {
        type: DataTypes.DATEONLY,
        allowNull: true
    },
    Lot: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    Layer: {
        type: DataTypes.STRING(200),
        allowNull: true,
        defaultValue: "NULL"
    },
    Method: {
        type: DataTypes.STRING(200),
        allowNull: true,
        defaultValue: "NULL"
    },
    Remark: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "NULL"
    },
    FailedRemark: {
        type: DataTypes.STRING(200),
        allowNull: true,
        defaultValue: "NULL"
    },
    FailedRemarkTSH: {
        type: DataTypes.STRING(200),
        allowNull: true,
        defaultValue: "NULL"
    },
    Inprocess: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: 0
    },
    Stage: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    BulkTestSample: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    LayerName: {
        type: DataTypes.STRING(50),
        allowNull: true
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Sys_Validation: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0:unchecked,1:checked"
    }
  }, {
    sequelize,
    tableName: 'tbl_tapdensity',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_tab___647BBB29CF10CD57",
        unique: true,
        fields: [
          { name: "RepSerNo" },
        ]
      },
    ]
  });
};
