const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_tab_master13', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    WgmtModeNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    IPQCType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    CoatingType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    BFGCode: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    ProductName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true
    },
    BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    BMRNo: {
      type: DataTypes.STRING(150),
      allowNull: true
    },
    GraphType: {
      type: DataTypes.STRING(15),
      allowNull: true
    },
    Qty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    GrpQty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    GrpFreq: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Idsno: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    InstrumentID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    SideNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(20),
      allowNull: true
    },
    Unit: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    DecimalPoint: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    T1NegTol: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    T1PosTol: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Nom: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    ReportType: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    CheckedByID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CheckedByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Media: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Lot: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    MinTemp: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxTemp: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinTime: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxTime: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Jar: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    Remark: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    FailedRemark: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    FailedRemarkTSH: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Inprocess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    StdTime: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TempRange: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Nom_stdtarget: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    MeshSize_Bolus: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Media_Temp: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Bath_Temp: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Apparatus_Type: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Program_No: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Sys_Validation: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0:unchecked,1:checked"
    },
    Basket_Type: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Stage: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_tab_master13',
    schema: 'dbo',
    timestamps: false
  });
};
