const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_bin_list', {
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    CubicleNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    cubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    binID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    binTareWeight: {
      type: DataTypes.DECIMAL(10,5),
      allowNull: true,
      defaultValue: 0.00000
    },
    tareWtDP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    PreviousProductName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    binStatus: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    IsDiscarded: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    bin_date: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    bin_updatedDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Bin_CubicNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    }
  }, {
    sequelize,
    tableName: 'tbl_bin_list',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_bin___36047C74FD5D5E8C",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
