'use strict';

const fs = require('fs');
const path = require('path');
const Sequelize = require('sequelize');
const process = require('process');
const basename = path.basename(__filename);
const env = process.env.NODE_ENV || 'development';
const config = require(__dirname + '/../config/config.json')[env];
const htDocConfig = require(__dirname + '/../../IncrencyV4CP10GConfig.json');

class SequelizeSetup{
  password
  constructor(realPassword){
    this.password = realPassword
  }

  getSequelizeObj(){
    let getSequalizeObj = this.SequelizeSetup(this.password)
    return getSequalizeObj;
  }

  SequelizeSetup(dbPass) {
    const db = {};

    //To Avoid [DeprecationWarning: The logging-option should be either a function or false. Default: console.log].
    if(config.logging) {
      config.logging = console.log;
    }

    Object.assign(config,{"username":htDocConfig.dbUser,
      "password": dbPass,
      "database": htDocConfig.dbName,
      "host": htDocConfig.dbHost.split('\\')[0]})

      let sequelize;
      if(config.use_env_variable) {
        sequelize = new Sequelize(process.env[config.use_env_variable], config);
      }else{
        sequelize = new Sequelize(config.database, config.username, config.password, config);
      }

      fs
      .readdirSync(__dirname)
      .filter(file =>{
        return(
          file.indexOf('.') !== 0 &&
          file !== basename &&
          file.slice(-3) === '.js' &&
          file.indexOf('.test.js') === -1
        );
      })
      .forEach(file =>{
        const model = require(path.join(__dirname,file))(sequelize,Sequelize.DataTypes);
        db[model.name] = model;
      });

      Object.keys(db).forEach(modelName =>{
        if(db[modelName].associate) {
          db[modelName].associate(db);
        }
      });

      db.sequelize = sequelize;
      db.sequelize = sequelize;

      return db;
  }
}
// module.exports = SequelizeSetup;
const db = {};

// To avoid [DeprecationWarning: The logging-option should be either a function or false. Default: console.log].
if (config.logging) {
  config.logging = console.log;
}



let sequelize;
if (config.use_env_variable) {
  sequelize = new Sequelize(process.env[config.use_env_variable], config);
} else {
  sequelize = new Sequelize(config.database, config.username, config.password, config);
}

fs
  .readdirSync(__dirname)
  .filter(file => {
    return (
      file.indexOf('.') !== 0 &&
      file !== basename &&
      file.slice(-3) === '.js' &&
      file.indexOf('.test.js') === -1
    );
  })
  .forEach(file => {
    const model = require(path.join(__dirname, file))(sequelize, Sequelize.DataTypes);
    db[model.name] = model;
  });

Object.keys(db).forEach(modelName => {
  if (db[modelName].associate) {
    db[modelName].associate(db);
  }
});

db.sequelize = sequelize;
db.Sequelize = Sequelize;
db.SequelizeSetup = SequelizeSetup
//Un-Comment following lines only if new table added / altered in init-models.js file.
// db.sequelize.sync({ force: true }).then(() => {
//   console.log("yes re-sync:Table addition");
// }).catch((e) => { console.log(e); });


module.exports = db;