const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_calibration_uncertinity_master', {
    Uncertinity_RepNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Uncertinity_CalbDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    Uncertinity_DueDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    Uncertinity_CalbTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Uncertinity_CubicalNo:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Uncertinity_CubicalName:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Uncertinity_Area:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Uncertinity_IDSNo:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Uncertinity_BalID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Serial: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Make: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Model: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Unit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Dept: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_MassWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_LeastCnt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Uncertinity_MaxCap: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Uncertinity_MinCap: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Uncertinity_Bal_MinOR:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: "0"
    },
    Uncertinity_Bal_MaxOR:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: 0.00000
    },
    Uncertinity_ZeroError: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Uncertinity_SpritLevel: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Uncertinity_GeneralCare: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Uncertinity_UserID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_UserName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_VerifyID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_VerifyName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_VerifyDate: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "1992-12-08 00:00:00"
    },
    Uncertinity_PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Uncertinity_IsRecalib:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Uncertinity_DP:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Uncertinity_StdWeight: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Uncertinity_NegTol: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Uncertinity_PosTol: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Uncertinity_Remark:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Uncertinity_AllWeightboxID: {
      type: DataTypes.STRING(1000),
      allowNull: true
    },
    Uncertinity_AllWeightboxCert: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_AllWeightboxValidUpto: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_IsBinBalance: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Uncertinity_SD: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Mean: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Percentage : {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Result : {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Uncertinity_Deviation : {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
  }, {
    sequelize,
    tableName: 'tbl_calibration_uncertinity_master',
    timestamps: false
  });
  seq.removeAttribute('id')
  return seq
};
