"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF]);
const NText = {
  id: 0x63,
  type: 'NTEXT',
  name: 'NText',
  hasTableName: true,
  declaration: function () {
    return 'ntext';
  },
  resolveLength: function (parameter) {
    const value = parameter.value; // Temporary solution. Remove 'any' later.

    if (value != null) {
      return value.length;
    } else {
      return -1;
    }
  },

  generateTypeInfo(parameter, _options) {
    const buffer = Buffer.alloc(10);
    buffer.writeUInt8(this.id, 0);
    buffer.writeInt32LE(parameter.length, 1);

    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 5, 0, 5);
    }

    return buffer;
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(Buffer.byteLength(parameter.value, 'ucs2'), 0);
    return buffer;
  },

  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield Buffer.from(parameter.value.toString(), 'ucs2');
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    return value;
  }
};
var _default = NText;
exports.default = _default;
module.exports = NText;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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