const express = require('express');
const path = require('path');
const app = express();
const cors = require('cors');
const bodyParser = require('body-parser');
const sequelize = require('./config/dbConnection').sequelize
const { QueryTypes } = require('sequelize');
const mssql = require("mssql");

//middlewares
app.use(express.static(path.join(__dirname, '')));
app.use(cors({ credentials: true, origin: true }))
app.use(bodyParser.json());
app.use(express.json());

//module import
require('./Interface/model/Mqtt/mqtt.model');
const serverConfig = require('./Interface/global/serverConfig');
const calibrationStatus = require('./Interface/routes/calibrationStatusRoute.js');
const login = require('./Interface/routes/login.route');
const globalData = require('./Interface/global/globalData');
const menuRequest = require('./Interface/routes/menu_Request_Route');
const weighmentRoute = require('./Interface/routes/weighment.route');
const exceptionRoute = require('./Interface/routes/exceptionFromAndriod');
const ipcRoute = require('./Interface/routes/ipcweighment.route');
const ipqcRoute = require('./Interface/routes/ipqc.route');
const ShowAlert = require('./Interface/model/Alert/alert.model');
const MenuDetails = require('./Interface/model/Menu/MenuRequest.model');
const menuDetails = new MenuDetails();
const objShowAlert = new ShowAlert();


//Middleware for Interface Routes
app.use('/INTERFACE/CalibrationStatus', calibrationStatus);
app.use('/INTERFACE/login', login);
app.use('/INTERFACE/Menu', menuRequest);
app.use('/INTERFACE/Weighment', weighmentRoute);
app.use('/INTERFACE/AndriodException', exceptionRoute);
app.use('/INTERFACE/IPC', ipcRoute);
app.use('/INTERFACE/IPQC', ipqcRoute)
// app.use('/INTERFACE/alert', ShowAlert);


app.listen(serverConfig.INTERFACE_NO, serverConfig.HOST_IP, async () => {
    // await sequelize.query(`update tbl_users set active = 0,loginatmpt = 0,autoEnbl = 0,Status = 0,suspensionPeriod = 0 where (source = "hardware"|| source ="")`,{ type: QueryTypes.UPDATE })
    //     var quer =  `UPDATE tbl_users set active = 0,loginatmpt = 0,autoEnbl = 0,Status = 0,suspensionPeriod = 0 where (source = "Hardware"|| source ="")`
    //    await mssql.query(quer);

   var quer =   `UPDATE tbl_users SET active = 0,loginatmpt = 0 WHERE source = 'TSH'`
    await sequelize.query(quer, { type: QueryTypes.UPDATE});
    console.log(`INTERFACE SERVER STARTED ON : ${serverConfig.HOST_IP}:${serverConfig.INTERFACE_NO}....`);

    await menuDetails.prepareAlertObject();
    globalData.alertArrTemp = globalData.alertArr;

    setInterval(async () => {
        
        await objShowAlert.updateAlertObject();
        await objShowAlert.showAlert();
    }, 10000)


});

process.on('uncaughtException', (err, origin) => {
    console.log(err);
    console.log('error came');
})