//modules

const clsHmiModel = require('./hmiDetail.model');
const Database = require('../database/clsQueryProcess');
const globalData = require('../global/globalData');
const moment = require('moment')
const models = require('../../config/dbConnection').models;
const sequelize = require('../../config/dbConnection').sequelize;
const { Op } = require('sequelize');
const { QueryTypes } = require('sequelize');


//instances of classes
const objHmiModel = new clsHmiModel();
const database = new Database();


class PreWeighmentCheck {

    async CheckProductSet(strHmi) {
        try {
            let cubicObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
            let cubicalData = cubicObj.cubicalData;
            if (cubicalData.Sys_ProductName == 'NULL' || cubicalData.Sys_BFGCode == 'NULL'||
                (cubicalData.Sys_Version == 'NULL') || (cubicalData.Sys_PVersion == 'NULL') ||
                cubicalData.Sys_ProductName.toUpperCase() == 'NONE' || cubicalData.Sys_BFGCode.toUpperCase() == 'NONE'||
                (cubicalData.Sys_Version.toUpperCase() == 'NONE') || (cubicalData.Sys_PVersion.toUpperCase() == 'NONE')
            ){
                return false;
            } else {
                return cubicalData;
            }

        } catch (error) {
            throw new Error(error)
        }
    }

    async CheckProductActivate(strHmi) {
        try {
            let cubicObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
            let cubicalData = cubicObj.cubicalData;
            if (cubicalData.Sys_ProductName == null || cubicalData.Sys_BFGCode == null ||
                cubicalData.Sys_Version == null || cubicalData.Sys_PVersion == null
            ) {
                return false;
            }
            return cubicalData

        } catch (error) {
            throw new Error(error)
        }
    }

    async CheckBatchStatus(strIdsNo, strHmi) {
        try {
            let cubicObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
            let cubicalData = cubicObj.cubicalData;
            let status, strMessage;
            let resObj = {};

            const batchDetails = await models.tbl_batches.findAll({
                where: {
                    CubicNo: cubicalData.Sys_CubicNo,
                    Prod_ID: cubicalData.Sys_BFGCode,
                    Prod_Name: cubicalData.Sys_ProductName,
                    Version: cubicalData.Sys_Version,
                    Prod_Version: cubicalData.Sys_PVersion,
                    Batch: cubicalData.Sys_Batch
                }
            })
            // str_tableName: 'tbl_batches',
            // data: '*',
            // condition: [
            //     { str_colName: 'CubicNo', value: cubicalData.Sys_CubicNo },
            //     { str_colName: 'Prod_ID', value: cubicalData.Sys_BFGCode },
            //     { str_colName: 'Prod_Name', value: cubicalData.Sys_ProductName },
            //     { str_colName: 'Version', value: cubicalData.Sys_Version },
            //     { str_colName: 'Prod_Version', value: cubicalData.Sys_PVersion },
            //     { str_colName: 'Batch', value: cubicalData.Sys_Batch },
            // ]

            let batchArrDetails = [batchDetails];
            let maxBatchRecord = batchArrDetails[0][batchArrDetails[0].length - 1];

            //put condition if batch not set
            const batchStatus = maxBatchRecord.Status;

            switch (batchStatus) {
                case 'E':
                    status = false;
                    strMessage = "Batch has Ended";
                    break;
                case 'R':
                    status = true;
                    strMessage = "Batch has Resumed";
                    break;
                case 'S':
                    status = true;
                    strMessage = "Batch has Started";
                    break;
                case 'I':
                    status = true;
                    strMessage = "Batch IPQC";
                    break;
                case 'N':
                    status = false;
                    strMessage = "Start Batch";
                    break;
                case 'P':
                    status = false;
                    strMessage = "Resume Batch";
                    break;
            }
            return Object.assign(resObj, {
                status: status,
                message: strMessage
            });
        } catch (error) {
            throw new Error(error)
        }
    }

    async checkBatchStartFORAlert(batchInfo) {
        try {
            let status, strMessage;
            let resObj = {};
            var query1 = await models.tbl_cubical.findAll({
                where: {
                    Sys_Batch: batchInfo.strBatch,
                    Sys_IDSNo: batchInfo.IDSNO,
                    Sys_CubicNo: batchInfo.intCubicleNo
                }
            })
            var result = [query1]

            var query = await models.tbl_batches.max('RecNo', {
                where: {
                    CubicNo: result[0][0].Sys_CubicNo,
                    Prod_ID: result[0][0].Sys_BFGCode,
                    Prod_Name: result[0][0].Sys_ProductName,
                    Version: result[0][0].Sys_Version,
                    Prod_Version: result[0][0].Sys_PVersion,
                    Batch: result[0][0].Sys_Batch
                }
            })
            var result1 = [query]

            var batchData = await models.tbl_batches.findAll({
                where: {
                    RecNo: result1[0]
                }
            })

            var batchStatus = batchData[0].Status
            switch (batchStatus) {
                case 'E':
                    status = false;
                    strMessage = "Start Batch";
                    break;
                case 'R':
                    status = true;
                    strMessage = "Batch Started";
                    break;
                case 'S':
                    status = true;
                    strMessage = "Batch Started";
                    break;
                case 'I':
                    status = true;
                    strMessage = "Batch IPQC";
                    break;
                case 'N':
                    status = true;
                    strMessage = "Start Batch";
                    break;
                case 'P':
                    status = false;
                    strMessage = "Start Batch";
                    break;
            }
            return Object.assign(resObj, {
                status: status,
                message: strMessage
            });
        } catch (error) {
            throw new Error(error)
        }


        //     switch (batchStatus) {
        //         case 'E':
        //             status = false;
        //             strMessage = "Batch has Ended";
        //             break;
        //         case 'R':
        //             status = true;
        //             strMessage = "Batch has Resumed";
        //             break;
        //         case 'S':
        //             status = true;
        //             strMessage = "Batch has Started";
        //             break;
        //         case 'I':
        //             status = true;
        //             strMessage = "Batch IPQC";
        //             break;
        //         case 'N':
        //             status = true;
        //             strMessage = "New Batch";
        //             break;
        //         case 'P':
        //             status = false;
        //             strMessage = "Batch has been paused";
        //             break;
        //     }
        //     return Object.assign(resObj, {
        //         status: status,
        //         message: strMessage
        //     });
        // } catch (error) {
        //     throw new Error(error)
        // }
    }

    async checkgrpflag(batchInfo) {
        // return new Promise(async (resolve, reject) => {
        try {

            var query1 = await models.tbl_cubical.findAll({
                where: {
                    Sys_Batch: batchInfo.strBatch,
                    Sys_IDSNo: batchInfo.IDSNO,
                    Sys_CubicNo: batchInfo.intCubicleNo
                }
            })
            var result = [query1];

            var query = await models.tbl_batches.max('RecNo', {
                where: {
                    CubicNo: result[0][0].Sys_CubicNo,
                    Prod_ID: result[0][0].Sys_BFGCode,
                    Prod_Name: result[0][0].Sys_ProductName,
                    Version: result[0][0].Sys_Version,
                    Prod_Version: result[0][0].Sys_PVersion,
                    Batch: result[0][0].Sys_Batch
                }
            })
            var result1 = [query]

            var batchData = await models.tbl_batches.findAll({
                where: {
                    RecNo: result1[0]
                }
            })
            
            if (batchData[0].grpflag == 1) {
                var now = new Date();
                var todayDate = moment(now).format('YYYY-MM-DD');
                var currentTime = moment(now, 'HH:mm:ss');
                var updatedtime;
                if (moment(batchData[0].tm1, 'HH:mm:ss').format('HH:mm:ss').split(":")[0].length == 1) {
                    let updateTime1 = "0" + batchData[0].tm1;
                    updatedtime = updateTime1;
                }
                else {
                    updatedtime = moment(batchData[0].tm1, 'HH:mm:ss').format("HH:mm:ss");
                }

                let datetimeA = moment(moment(batchInfo.AlertDate).format('YYYY-MM-DD') + " " + updatedtime);
                let datetimeB = moment(moment(todayDate).format('YYYY-MM-DD') + " " + currentTime.format("HH:mm:ss"));
                let datetimeC = datetimeB.diff(datetimeA, 'minutes');
                if (datetimeC >= batchInfo.intGroupParam) {
                    var groupAlertRes = await models.tbl_batches.update({
                        grpflag: 0,
                    }, {
                        where: {
                            Batch: batchData[0].Batch,
                            [Op.or]: [{ Status: "S" }, { Status: "R" }],
                            CubicNo: result[0][0].Sys_CubicNo,
                            Prod_Name: result[0][0].Sys_ProductName,
                        }
                    });

                    console.log("GRP FLAG UPDATED to 0");
                    return 0;
                }
                return batchData[0].grpflag;
            } else {
                return batchData[0].grpflag;
            }

        } catch (error) {
            console.log(error);
        }

    }
    async checkReportRemarkPending(strIdsNo) {
        try {
            //check report remark pending or not
            let CubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo);


            let selectedIdsNo;

            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds;
            } else {
                selectedIdsNo = strIdsNo;
            }

            let selectedCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;
            let StrBatch = selectedCubicInfo.Sys_Batch;
            const objIncompRemark = await models.tbl_remark_incomplete_master.findAll({
                where: {
                    IDSNo: strIdsNo,
                    BatchNumber: StrBatch
                }
            })
            // {
            //     str_tableName: 'tbl_remark_incomplete_master',
            //     data: '*',
            //     condition: [
            //         { str_colName: 'IDSNo', value: strIdsNo },
            //         { str_colName: 'BatchNumber', value: StrBatch }
            //     ]
            // }

            let arrRemarkDetails = [objIncompRemark];
            if (arrRemarkDetails[0].length > 0) {
                let tableName = arrRemarkDetails[0][0].tableName;
                let testName = arrRemarkDetails[0][0].paramName;
                let batchNo = StrBatch;

                const objRemark = await models[tableName].findAll({
                    where: {
                        BatchNo: batchNo,
                        IDSNo: strIdsNo
                    }
                })


                //     data: '*',
                //     condition: [
                //         { str_colName: 'BatchNo', value: batchNo },
                //         { str_colName: 'IDSNo', value: strIdsNo }
                //     ]


                let incompRemarkDetails = [objRemark];
                incompRemarkDetails = incompRemarkDetails[0].pop()

                const checkConditionsArr = ['NULL', "Null", null];

                if (incompRemarkDetails != undefined || incompRemarkDetails != null) {
                    if (checkConditionsArr.some(conditionParameter =>
                        incompRemarkDetails.RepoLabel13.includes(conditionParameter)
                    )) {
                        return { status: true, menuName: testName }
                    }
                    else {
                        return false;
                    }
                } else {
                    return false;
                }

            } else {
                return false;
            }

        } catch (error) {
            throw new Error(error)
        }
    }

}

module.exports = PreWeighmentCheck;