const globalData = require("../global/globalData");
const date = require("date-and-time");
const IncompleteReport = require("../model/Product/clsIncompleteReport");
const clsWeighmentDataTransfer = require('../model/Product/clsWeighmentDataTransfer');
const clsFormula = require("../model/Product/clsformulaFun.model");
const BatchSummaryModel = require("../model/Product/clsBatchSummaryOperation");
const GLOBAL_NOMENCLATURE = require("../global/GLOBAL_NOMENCLATURE");
const moment = require("moment");
const objWeighmentDataTransfer = new clsWeighmentDataTransfer();
const objIncompleteReport = new IncompleteReport();
const objFormula = new clsFormula();
const now = new Date();
const objBatchSummary = new BatchSummaryModel();
const maths = require('mathjs');
const { Op } = require("sequelize");
// const { tbl_cubical } = require('sequelize');
const models = require('../../config/dbConnection').models;
const sequelize = require('../../config/dbConnection').sequelize;
const { QueryTypes } = require("sequelize");
const momentObj = require("moment");

const { create } = require("joi/lib/ref");

class calculation_operation {
  async calculation_operation(Dataobj, repSerNo) {
    try {
      var ProdData = Dataobj.objProductDetails;
      var strHmi = ProdData.Hmi;
      var actualWt = Dataobj.ProtocolData
      var DataValue_arr = [];
      var detail_tableName = Dataobj.strDetailTbl.concat("_incomplete");
      var master_tableName = Dataobj.strTableName.concat("_incomplete");
      var Nominal = Dataobj.objProductDetails.Nominal.split(' ')[0];
      //For balanceDp = 3 and vernierDP 2 and Avg(balance)DP=4 and Avg(vernier)DP=3
      var DP = Dataobj.objProductDetails.Dp;
      Nominal = Number(Nominal).toFixed(DP);
      var get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: repSerNo } });
      var get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });
      DataValue_arr.push(get_Datavalue);
      var arr = [];
      var total_weight = 0
      for (var i = 0; i < get_Datavalue.length; i++) {
        var a = get_Datavalue[i].DataValue;
        arr.push(Number(a));
        console.log(arr);
        total_weight = Number(total_weight) + Number(get_Datavalue[i].DataValue)


      }
      var dp_Ver_bal //= DP == 3 ? 4 : 3;
      DP = get_Datavalue[0].DP;
      if (ProdData.menuName == GLOBAL_NOMENCLATURE.IndividualMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayerMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu) {
        dp_Ver_bal = Dataobj.ProtocolUnit != 'mg' ? 4 : 1
      } else {
        dp_Ver_bal = DP
      }

      var max_value = maths.max(arr);
      max_value = max_value.toFixed(DP);
      var min_value = maths.min(arr);
      min_value = min_value.toFixed(DP);
      var std_value = maths.std(arr);
      std_value = std_value.toFixed(4);
      var total = arr.reduce((acc, total) => {
        return Number(total) + Number(acc);
      }, 0)
      var avg = total / arr.length
      avg = Number(maths.round(maths.abs(avg), dp_Ver_bal)).toFixed(dp_Ver_bal);
      // var Per_Dev = ((Nominal - avg) / Nominal) * 100;
      // Per_Dev = Number(Per_Dev).toFixed(DP);
      var minPer_value = ((Nominal - min_value) / Nominal) * 100;
      minPer_value = (minPer_value).toFixed(2)
      if (!minPer_value.startsWith('-')) {
        // minPer_value = '+' + " " + minPer_value
        minPer_value = minPer_value
      } else {
        minPer_value = maths.abs(minPer_value).toFixed(2)
        // minPer_value = '-' + " " + minPer_value
      }
      var maxPer_value = ((max_value - Nominal) / Nominal) * 100;
      maxPer_value = (maxPer_value).toFixed(2)
      if (!maxPer_value.startsWith('-')) {
        // maxPer_value = '+' + " " + maxPer_value
        maxPer_value = maxPer_value
      } else {
        maxPer_value = maths.abs(maxPer_value).toFixed(2)
        // maxPer_value = '-' + " " + maxPer_value

      }

      // console.log();
      console.log(max_value, min_value, std_value, avg, minPer_value, maxPer_value);
      // return arr;
      // }
      //No.of Tablets Above and Below limit
      var T1Pos_Tol, T1Neg_Tol, T2Pos_Tol, T2Neg_Tol;
      T1Pos_Tol = get_Datavalue1[0].T1PosTol;
      T1Neg_Tol = get_Datavalue1[0].T1NegTol;
      T2Pos_Tol = get_Datavalue1[0].T2PosTol;
      T2Neg_Tol = get_Datavalue1[0].T2NegTol;

      var nob1 = 0;
      var noa1 = 0;
      var nob2 = 0;
      var noa2 = 0;
      if (ProdData.menuName == GLOBAL_NOMENCLATURE.IndividualMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayerMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu) {
        for (var i = 0; i < get_Datavalue.length; i++) {
          if (Number(get_Datavalue[i].DataValue) < Number(T2Neg_Tol)) { //No of below limit 2
            nob2 = nob2 + 1;
          } else if (Number(get_Datavalue[i].DataValue) > Number(T2Pos_Tol)) { //No of Above limit 2
            noa2 = noa2 + 1;
          }
          if (T1Neg_Tol != 0 && T1Pos_Tol != 0) {
            if (Number(get_Datavalue[i].DataValue) < Number(T1Neg_Tol) && Number(get_Datavalue[i].DataValue) >= Number(T2Neg_Tol)) { //No of below limit 1
              nob1 = nob1 + 1;
            } else if (Number(get_Datavalue[i].DataValue) > Number(T1Pos_Tol) && Number(get_Datavalue[i].DataValue) <= Number(T2Pos_Tol)) { //No of Above limit 1
              noa1 = noa1 + 1;
            }
          }
        }
      } else {
        for (var i = 0; i < get_Datavalue.length; i++) {
          if (Number(get_Datavalue[i].DataValue) < Number(T2Neg_Tol)) { //No of below limit 2
            nob2 = nob2 + 1;
          } else if (Number(get_Datavalue[i].DataValue) > Number(T2Pos_Tol)) { //No of Above limit 2
            noa2 = noa2 + 1;
          }
        }
      }
      // if ((Number(actualWt) < Number(T2Neg_Tol))) {
      //   get_Datavalue1[0].NoOfBelow2 = Number(get_Datavalue1[0].NoOfBelow2) + 1;
      // } else if ((Number(actualWt) > Number(T2Pos_Tol))) {
      //   get_Datavalue1[0].NoOfAbove2 = Number(get_Datavalue1[0].NoOfAbove2) + 1;
      // }
      // if (T1Pos_Tol != 0 && T1Neg_Tol != 0) {
      //   if ((Number(actualWt) < Number(T1Neg_Tol) && Number(actualWt) >= Number(T2Neg_Tol))) {
      //     get_Datavalue1[0].NoOfBelow1 = Number(get_Datavalue1[0].NoOfBelow1) + 1;
      //   } else if ((Number(actualWt) > Number(T1Pos_Tol) && Number(actualWt) <= Number(T2Pos_Tol))) {
      //     get_Datavalue1[0].NoOfAbove1 = Number(get_Datavalue1[0].NoOfAbove1) + 1;
      //   }
      // }
      console.log(Number(maths.round(avg, dp_Ver_bal)).toFixed(dp_Ver_bal));
      //update Min and Max value in Master and also Std,minPer,maxPer,%Dev
      var get_Datavalue11 = await models[master_tableName].update({
        AvgWeight: Number(maths.round(avg, dp_Ver_bal)).toFixed(dp_Ver_bal),
        MinWeight: Number(min_value).toFixed(DP),
        MaxWeight: Number(max_value).toFixed(DP),
        StdDev: Dataobj.ProtocolUnit != 'mg' ? maths.round(std_value, 4).toFixed(4) : maths.round(std_value, 1).toFixed(1),
        MinPer: minPer_value,
        MaxPer: maxPer_value,
        TotalWeight: Dataobj.ProtocolUnit != 'mg' ? maths.round(total_weight, 4).toFixed(4) : maths.round(total_weight, 1).toFixed(1),
        // Deviation: Per_Dev,
        NoOfAbove1: noa1,
        NoOfAbove2: noa2,
        NoOfBelow1: nob1,
        NoOfBelow2: nob2
      }, { where: { RepSerNo: repSerNo } });
      //19/05/23 END
      var remark;
      var SampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);
      var objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
      get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: repSerNo } });
      get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });

      if (ProdData.menuName == GLOBAL_NOMENCLATURE.IndividualMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayerMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu) {
        if (((Number(get_Datavalue1[0].NoOfAbove1) + Number(get_Datavalue1[0].NoOfBelow1)) > Number(get_Datavalue1[0].NMT) || (Number(get_Datavalue1[0].NoOfAbove2) != 0) || Number(get_Datavalue1[0].NoOfBelow2) != 0)) {
          remark = 'Not Complies';
          SampleRemark.OutOfRemark = true
        } else {
          remark = 'Complies';
          SampleRemark.OutOfRemark = false
        }
      } else {
        if ((Number(get_Datavalue1[0].NoOfAbove2) != 0) || Number(get_Datavalue1[0].NoOfBelow2) != 0) {
          remark = 'Not Complies';
          SampleRemark.OutOfRemark = true
        } else {
          remark = 'Complies';
          SampleRemark.OutOfRemark = false
        }
      }
      if (Number(Dataobj.objProductDetails.noOfSample) == Dataobj.seqNoOfWt) {
        if (objSelMenu.selectedProductDetail.isonstd == 1) {
          var get_Datavalue_final = await models[detail_tableName].findAll({ where: { RepSerNo: repSerNo } });
          var get_Datavalue1_final = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });

          objSelMenu.selectedProductDetail.nominal = get_Datavalue1_final[0].AvgWeight;

          var Nominal_final = objSelMenu.selectedProductDetail.nominal;
          Nominal_final = Number(Nominal_final).toFixed(DP);

          var typeValue = 1;
          var maxLimitT1_avg = objFormula.upperLimit(objSelMenu.selectedProductDetail, 'T1');
          var maxLimitT2_avg = objFormula.upperLimit(objSelMenu.selectedProductDetail, 'T2');
          var minLimitT2_avg = objFormula.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
          var minLimitT1_avg = objFormula.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

          var DataValue_arr = [];

          get_Datavalue1_final[0].NoOfBelow1 = 0;
          get_Datavalue1_final[0].NoOfAbove1 = 0;
          get_Datavalue1_final[0].NoOfBelow2 = 0;
          get_Datavalue1_final[0].NoOfAbove2 = 0;

          DataValue_arr.push(get_Datavalue_final);
          var arr_final = [];
          for (var j = 0; j < get_Datavalue_final.length; j++) {
            var AB = get_Datavalue_final[j].DataValue;
            arr_final.push(Number(AB));
            console.log(arr_final);
            // }
            if (Number(AB) < Number(minLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfBelow2 = Number(get_Datavalue1_final[0].NoOfBelow2) + 1;
            } else if (Number(AB) > Number(maxLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfAbove2 = Number(get_Datavalue1_final[0].NoOfAbove2) + 1;
            }
            if (maxLimitT1_avg != 0 && minLimitT1_avg != 0) {
              if (Number(AB) < Number(minLimitT1_avg) && Number(AB) >= Number(minLimitT2_avg)) {
                get_Datavalue1_final[0].NoOfBelow1 = Number(get_Datavalue1_final[0].NoOfBelow1) + 1;
              } else if (Number(AB) > Number(maxLimitT1_avg) && Number(AB) <= Number(maxLimitT2_avg)) {
                get_Datavalue1_final[0].NoOfAbove1 = Number(get_Datavalue1_final[0].NoOfAbove1) + 1;
              }
            }
          }
          // arr_final.push(Number(AB));
          // console.log(arr_final);
          var max_value_final = maths.max(arr_final);
          max_value_final = max_value_final.toFixed(DP);
          var min_value_final = maths.min(arr_final);
          min_value_final = min_value_final.toFixed(DP);
          var std_value_final = maths.std(arr_final);
          std_value_final = std_value_final.toFixed(4);
          var total_final = arr_final.reduce((acc, total_final) => {
            return Number(total_final) + Number(acc);
          }, 0)
          var avg_final = total_final / arr_final.length
          avg_final = Number(maths.round(maths.abs(avg_final), dp_Ver_bal)).toFixed(dp_Ver_bal);
          var minPer_value_final = ((Nominal_final - min_value_final) / Nominal_final) * 100;

          minPer_value_final = (minPer_value_final).toFixed(2);
          if (!minPer_value_final.startsWith('-')) {
            minPer_value_final = minPer_value_final
          } else {
            minPer_value_final = maths.abs(minPer_value_final).toFixed(2)
            minPer_value_final = minPer_value_final
          }
          var maxPer_value_final = ((Nominal_final - max_value_final) / Nominal_final) * 100;
          maxPer_value_final = (maxPer_value_final).toFixed(2);
          if (!maxPer_value_final.startsWith('-')) {
            maxPer_value_final = maxPer_value_final
          } else {
            maxPer_value_final = maths.abs(maxPer_value_final).toFixed(2)
            maxPer_value_final = maxPer_value_final
          }

          // minPer_value_final = (minPer_value_final).toFixed(2);
          // if (!minPer_value_final.startsWith('-')) {
          //   minPer_value_final = '+' + " " + minPer_value_final
          // }
          // var maxPer_value_final = ((Nominal_final - max_value_final) / Nominal_final) * 100;
          // maxPer_value_final = (maxPer_value_final).toFixed(2);
          // if (!maxPer_value_final.startsWith('-')) {
          //   maxPer_value_final = '+' + " " + maxPer_value_final
          // }

          // console.log();
          console.log(max_value_final, min_value_final, std_value_final, avg_final, minPer_value_final, maxPer_value_final);
          // return arr;

          var master_update = await models[master_tableName].update({
            AvgWeight: avg_final,
            StdDev: Number(std_value_final).toFixed(4),
            MinWeight: min_value_final,
            MaxWeight: max_value_final,
            MinPer: minPer_value_final,
            MaxPer: maxPer_value_final,
            NoOfAbove1: noa1,
            NoOfAbove2: noa2,
            NoOfBelow1: nob1,
            NoOfBelow2: nob2,
            TotalWeight: Number(total_weight).toFixed(DP),
            T1NegTol: Number(minLimitT1_avg).toFixed(DP),
            T1PosTol: Number(maxLimitT1_avg).toFixed(DP),
            T2NegTol: Number(minLimitT2_avg).toFixed(DP),
            T2PosTol: Number(maxLimitT2_avg).toFixed(DP),
          }, { where: { RepSerNo: repSerNo } });
          // }
          // if (((Number(get_Datavalue1_final[0].NoOfAbove1) + Number(get_Datavalue1_final[0].NoOfBelow1)) > Number(get_Datavalue1_final[0].NMT) || (Number(get_Datavalue1_final[0].NoOfAbove2) != 0) || Number(get_Datavalue1_final[0].NoOfBelow2) != 0)) {
          //   remark = 'Not Complies';
          //   SampleRemark.OutOfRemark = true
          // } else {
          //   remark = 'Complies';
          //   SampleRemark.OutOfRemark = false
          // }
          if (ProdData.menuName == GLOBAL_NOMENCLATURE.IndividualMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayerMenu || ProdData.menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu) {
            if (((Number(get_Datavalue1[0].NoOfAbove1) + Number(get_Datavalue1[0].NoOfBelow1)) > Number(get_Datavalue1[0].NMT) || (Number(get_Datavalue1[0].NoOfAbove2) != 0) || Number(get_Datavalue1[0].NoOfBelow2) != 0)) {
              remark = 'Not Complies';
              SampleRemark.OutOfRemark = true
            } else {
              remark = 'Complies';
              SampleRemark.OutOfRemark = false
            }
          } else {
            if ((Number(get_Datavalue1[0].NoOfAbove2) != 0) || Number(get_Datavalue1[0].NoOfBelow2) != 0) {
              remark = 'Not Complies';
              SampleRemark.OutOfRemark = true
            } else {
              remark = 'Complies';
              SampleRemark.OutOfRemark = false
            }
          }
        }
        await models[master_tableName].update({
          Remark: remark
        }, { where: { RepSerNo: repSerNo } });
      } else {
        await models[master_tableName].update({
          Remark: 'NA'
        }, { where: { RepSerNo: repSerNo } });
      }
      return remark;
    } catch (error) {
      console.log(error);
    }
  }

}
module.exports = calculation_operation