const globalData = require('../../global/globalData');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsIncompleteReport = require('../Product/clsIncompleteReport');
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const FormulaFunModel = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const MqttModel = require('../Mqtt/mqttSender.class');
const Database = require('../../database/clsQueryProcess');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const utillDb = require('../../Utills/db');
const clsProObj = require('../Product/clsProductDetailModel');
const date = require('date-and-time');
const clsBatchSummary = require('../Product/clsBatchSummaryOperation');
const sequelize = require('../../../config/dbConnection').sequelize
const momentObj = require('moment');
const { models } = require('../../../config/dbConnection').sequelize;
// let OpcOps = require('../OPC/opcOps')
// let objopcOps = new OpcOps();
const clsPrintOperations = require("../Print/clsPrintOperation")

const printOperations = new clsPrintOperations()
const database = new Database();
const objIncompleteReport = new clsIncompleteReport();
const objCommonInsertOpt = new clsCommonInsertOpt();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objformulaFun = new FormulaFunModel();
const mqttSender = new MqttModel();
const proObj = new clsProObj();
const objBatchSummary = new clsBatchSummary();

class LOD {
    /**
     * sample is not their in LOD 
     * @description LOD Data Come here
     * @param {*} IdsNo
     * @param {*} protocol
     */
    async insertBulkWeighmentLOD(dataObj) {

        var actualProtocol = dataObj.dataObj.Parsedata;
        let now = new Date();
        let strIdsNo = dataObj.idsNo;
        let strHmi = dataObj.Hmi;
        var menu = dataObj.menuName
        // var tdValue = actualProtocol.substring(0, 5);//starting 
        const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
        // var protocolIncomingType = tdValue.substring(0, 1);//here incoming protocol is check T Or H
        let selectedIdsNo;
        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
        if (IPQCObject != undefined) {
            selectedIdsNo = IPQCObject.selectedIds;
        } else {
            selectedIdsNo = strIdsNo;
        }
        dataObj.productObj = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi).productDetail[0];
        const productObj = dataObj.productObj
        let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
        if (tempCounterObj === undefined) {
            globalData.arrWeighmentCounter.push({ 'Hmi': strHmi, 'counter': 0 })
        }
        tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
        await objInstrumentUsage.InstrumentUsage('LOD', strIdsNo, 'tbl_instrumentlog_lod', menu, 'started');

        if (tempCounterObj.counter == 0) {
            //insert initial and temp
            var objActivity = {};
            Object.assign(objActivity,
                { strUserId: tempUserObject.UserId },
                { strUserName: tempUserObject.UserName },
                { activity: `${menu} Weighment Started on TSH ` + strHmi });
            await objActivityLog.ActivityLogEntry(objActivity);
            // Instrument usage for LOD started
            // await objInstrumentUsage.InstrumentUsage('LOD', strIdsNo, 'tbl_instrumentlog_lod', menu, 'started');
            await this.saveLodData(productObj, actualProtocol, tempUserObject, strIdsNo, 0, strHmi);
            tempCounterObj.counter += 1;
        } else {
            await this.saveLodData(productObj, actualProtocol, tempUserObject, strIdsNo, tempCounterObj.counter, strHmi);
        }



    }


    async saveLodData(productObj, arrLodData, tempUserObject, IdsNo, counter, strHmi) {
        try {
            var department = "";
            let responseObj = {};
            var currentCubicle = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo).cubicalData;
            var cubicType, GranuRepoHeading = 0, decimalPoint;
            department = currentCubicle.Sys_dept;
            var lodData = globalData.arrProtocolData.find(k => k.strHmi == strHmi);
            let hmiDetails = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi).data;
            var lodData1_value = Object.assign(arrLodData[0], arrLodData[1], arrLodData[2], arrLodData[3], { "Hmi": strHmi })
            if (lodData == undefined) {

                globalData.arrProtocolData.push(lodData1_value)
                // globalData.arrProtocolData.push({'strHmi':strHmi})
            }
            lodData = globalData.arrProtocolData.find(k => k.Hmi == strHmi);

            // var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);
            let LOTDetails = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            let selectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds;
            } else {
                selectedIdsNo = IdsNo;
            }

            var ProductType = globalData.arrProductTypeArray.find(k => k.idsNo == selectedIdsNo).productType; //ProductType
            if (currentCubicle.Sys_CubType == 'IPQC' && (currentCubicle.Sys_Area == 'Granulation' || currentCubicle.Sys_Area == 'Granulation IPQC'
            ||currentCubicle.Sys_Area == 'IPQC' || currentCubicle.Sys_Area == 'IPQC' || currentCubicle.Sys_Area == 'Pallet Coating')) {

                var selectedCubicle = productObj;
                cubicType = 1;
                // let tempMenuLOD = globalData.arrLODTypeSelectedMenu.find(k => k.idsNo == IdsNo);
                var tempMenuLOD = globalData.arrSelectedMenu.find(k => k.idsNo == IdsNo);
                switch (tempMenuLOD.menuName) {
                    case GLOBAL_NOMENCLATURE.granulationDry: // COMPRESSED DRY
                    case GLOBAL_NOMENCLATURE.LODMenu:
                        GranuRepoHeading = 1;
                        break;
                    case GLOBAL_NOMENCLATURE.granulationLub: //COMPRESSED LUB
                        GranuRepoHeading = 43;
                        break;
                    case GLOBAL_NOMENCLATURE.lay1Dry:
                        GranuRepoHeading = 4;
                        break;
                    case GLOBAL_NOMENCLATURE.lay1Lub:
                    case GLOBAL_NOMENCLATURE.LODLayer1Menu:
                        GranuRepoHeading = 44;
                        break;
                    case GLOBAL_NOMENCLATURE.lay2Dry:
                        GranuRepoHeading = 5;
                        break;
                    case GLOBAL_NOMENCLATURE.lay2Lub:
                        GranuRepoHeading = 6;
                        break;
                    case GLOBAL_NOMENCLATURE.LODLayer2Menu:
                        GranuRepoHeading = 7;
                        break;
                    default:
                        // for coating and compression
                        // Finding Out the department of selected for coating and compression
                        var objGranuInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);
                        let objCompCoatInfo = globalData.arrIdsInfo.find(k => k.Sys_ProductName == objGranuInfo.cubicalData.Sys_ProductName
                            && k.Sys_BFGCode == objGranuInfo.cubicalData.Sys_BFGCode && k.Sys_PVersion == objGranuInfo.cubicalData.Sys_PVersion
                            && k.Sys_Version == objGranuInfo.cubicalData.Sys_Version && (k.Sys_Area != 'Granulation' || k.Sys_Area != 'Effervescent Granulation'));

                        department = objCompCoatInfo.Sys_dept;
                        selectedCubicle = objCompCoatInfo;
                        GranuRepoHeading = 0;
                        cubicType = 0;
                }
            } else {
                // For Compression and coating
                cubicType = 0;
                GranuRepoHeading = 0;
            }
            let now = new Date();
            // let tempLODdata = globalData.arrLodData.find(lod => lod.idsNo == IdsNo);
            lodData = globalData.arrProtocolData.find(k => k.Hmi == strHmi);
            // lodData.Parsedata = arrLodData
            if ((lodData != undefined)) {

                if ((lodData.Modal == 'HS153' && lodData == undefined) || (lodData.Modal == 'HS83' && lodData == undefined) || (lodData.Modal == 'HX204' && lodData == undefined)) {
                    var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
                    if (objLodData == undefined) {
                        globalData.arrLodData.push({ idsNo: IdsNo, arr: [], counter: 0 })
                    }
                    else {
                        objLodData.arr = [];
                    }
                    console.log('InValid LOD data string');
                    return 'Invalid data string';
                }
                if (lodData.setTemp.flag == true) {
                    // here check product is from granulation or COMP & COAT
                    let objSelectedLOD = globalData.arrLODTypeSelectedMenu.find(k => k.idsNo == IdsNo);
                    var productTableName = "";
                    if (objSelectedLOD != undefined) {
                        if (objSelectedLOD.selectedLOD == "LOD COATING") {
                            productTableName = "tbl_product_tablet_coated";
                        } else if (objSelectedLOD.selectedLOD == "LOD COMPRESSION") {
                            productTableName = "tbl_product_tablet";
                        }
                    } else if (currentCubicle.Sys_Area == 'Compression' || currentCubicle.Sys_Area == 'Granulation IPQC') {
                        productTableName = "tbl_product_tablet";
                    } else if (currentCubicle.Sys_Area == 'Coating') {
                        productTableName = "tbl_product_tablet_coated";
                    }

                    if (currentCubicle.Sys_Area == 'Pellets-II' || currentCubicle.Sys_Area == 'Granulation' || currentCubicle.Sys_Area == 'IPQC' || currentCubicle.Sys_Area == 'IPQC') {
                        productTableName = "tbl_product_gran";
                    }
                    var res = await proObj.productData(currentCubicle, productTableName);


                    var layer = 'NA';
                    var layerName = 'NA';

                    if (GranuRepoHeading == 4 || GranuRepoHeading == 44) {
                        layer = 'Layer 1';
                        layerName = res[0].IsBilayerLbl;
                    } else if (GranuRepoHeading == 7) {
                        layer = 'Layer 2';
                        layerName = res[0].IsTrilayerLbl;
                    }

                    if (GranuRepoHeading != 0) {
                        var paramNom = `Param${GranuRepoHeading}_Nom`;
                        var paramLow = `Param${GranuRepoHeading}_Low`;
                        var paramUpp = `Param${GranuRepoHeading}_Upp`;
                        var paramDp = `Param${GranuRepoHeading}_DP`;
                        var paramIsOnStd = `Param${GranuRepoHeading}_IsOnStd`;
                    } else {
                        var paramNom = `Param16_Nom`;
                        var paramLow = `Param16_T1Neg`;
                        var paramUpp = `Param16_T1Pos`;
                        var paramDp = `Param16_DP`;
                        var paramIsOnStd = `Param16_LimitOn`;
                    }


                    const checkData = await models.tbl_lodmaster.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'RepSerNo']],
                        where: {
                            BFGCode: currentCubicle.Sys_BFGCode,
                            ProductName: currentCubicle.Sys_ProductName,
                            PVersion: currentCubicle.Sys_PVersion,
                            Version: currentCubicle.Sys_Version,
                            BatchNo: currentCubicle.Sys_Batch,
                            IdsNo: strHmi,
                        }
                    })
                    let result = checkData;
                    var intMstSerNo;
                    if (result[0].RepSerNo == null) {
                        intMstSerNo = 1;
                    } else {
                        var newMstSerNo = result[0].RepSerNo + 1;
                        intMstSerNo = newMstSerNo;
                    }
                    const checkBRepSer = await models.tbl_lodmaster.findAll({
                        attribute: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'BRepSerNo']],
                        where: {
                            BFGCode: currentCubicle.Sys_BFGCode,
                            ProductName: currentCubicle.Sys_ProductName,
                            PVersion: currentCubicle.Sys_PVersion,
                            Version: currentCubicle.Sys_Version,
                            BatchNo: currentCubicle.Sys_Batch,
                            ReportType: currentCubicle.Sys_RptType,
                            Side: currentCubicle.Sys_RotaryType,
                        }

                    })

                    let batchResult = checkBRepSer;
                    if (batchResult[0] != undefined) {
                        var intBRepSerNo;
                        if (batchResult[0].BRepSerNo == null) {
                            intBRepSerNo = 1;
                        } else {
                            var newBRepSerNo = batchResult[0].BRepSerNo + 1;
                            intBRepSerNo = newBRepSerNo;
                        }
                    } else {
                        intBRepSerNo = 1;
                    }

                    let arrToObj = arrLodData.reduce(((r, c) => Object.assign(r, c)), {})
                    if (arrToObj.hasOwnProperty("iniWt") && arrToObj.hasOwnProperty("setTemp")) {
                        var arrtoobj_value = (arrToObj['iniWt']).iniWt.split(' ')[0]; //for iniwt
                        var arrtoobj_value1 = (arrToObj['setTemp']).setTemp.split(' ')[0] //for set temp
                        if ((isNaN(parseInt(arrtoobj_value))) || (isNaN(parseInt(arrtoobj_value1)))) {
                            return 'Invalid data string';
                        }
                    }


                    // if (arrToObj.hasOwnProperty("iniWt")) {
                    var isModalExist = arrToObj.hasOwnProperty("Modal")
                    var arrTempSplit = isModalExist ? arrLodData[2].iniWt.iniWt.split('.') : arrLodData[1].iniWt.split(".")
                    //}
                    var dp_arr = [];
                    dp_arr = arrTempSplit[1].split(' ')[0];
                    decimalPoint = arrTempSplit[1] == undefined ? 0 : dp_arr.length;
                    var lossOnWt;
                    var finwt = arrLodData.filter(k => k.hasOwnProperty('finalWt'))
                    if (finwt.length == 0) {

                        lossOnWt = 0;
                    }
                    else {
                        lossOnWt = finwt[0].finalWt.finalWt
                    }


                    if (!lossOnWt == 0) {
                        var saveLodData = await models.tbl_lodmaster.create({
                            MstSerNo: intMstSerNo,
                            BRepSerNo: intBRepSerNo,
                            BFGCode: currentCubicle.Sys_BFGCode,
                            ProductName: currentCubicle.Sys_ProductName,
                            ProductType: ProductType.ProductType,
                            IdsNo: strHmi,
                            BatchNo: currentCubicle.Sys_Batch,
                            StartTm: momentObj().format('HH:mm:ss'),
                            CubicleName: currentCubicle.Sys_CubicName,
                            CubicleType: currentCubicle.Sys_CubType,
                            CubicalNo: currentCubicle.Sys_CubicNo,
                            CubicleLocation: currentCubicle.Sys_dept,
                            Dept: currentCubicle.Sys_dept,
                            InstruId: 0,
                            Side: currentCubicle.Sys_RotaryType,
                            DryingTemp: 0,
                            SampleWt: 0,
                            //LossOnWt: 0 },
                            UserId: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            IsArchived: 0,
                            PrDate: momentObj().format('YYYY-MM-DD'),
                            PrTime: momentObj().format('HH:mm:ss'),
                            PrintNo: 0,
                            Remark: 0,
                            ReportType: currentCubicle.Sys_RptType,
                            MachineId: currentCubicle.Sys_MachineCode,
                            // MinLimit: res[1][paramLow].toFixed(2),
                            // MaxLimit: res[1][paramUpp].toFixed(2),
                            // MinLimit:tempMenuLOD.selectedProductDetail.T1Neg.toFixed(2),
                            // MaxLimit: tempMenuLOD.selectedProductDetail.T1Pos.toFixed(2),
                            MinLimit: tempMenuLOD.selectedProductDetail.T1Neg != 'NA' ? tempMenuLOD.selectedProductDetail.T1Neg.toFixed(2) : 'NA',
                            MaxLimit: tempMenuLOD.selectedProductDetail.T1Pos != 'NA' ? tempMenuLOD.selectedProductDetail.T1Pos.toFixed(2) : 'NA',
                            Stage: currentCubicle.Sys_Stage,
                            PrEndDate: momentObj().format('YYYY-MM-DD'),
                            PrEndTime: momentObj().format('HH:mm:ss'),
                            Unit: 0,
                            DecimalPoint: decimalPoint,
                            WgmtModeNo: "16",
                            BatchComplete: 0,
                            LODID: currentCubicle.Sys_MoistID,
                            PVersion: currentCubicle.Sys_PVersion,
                            Version: currentCubicle.Sys_Version,
                            //  CheckedByID', value: nwtAfterTest },
                            //  CheckedByName', value: lwtBeforeTest },
                            //  CheckedByDate', value: lwtAfterTest },
                            Lot: LOTDetails.data.lotno,
                            // RunTime: rwtBeforeTest },
                            // DryWt: isModalExist ? arrLodData[2].iniWt.iniWt.split(' ')[0] : arrLodData[1].iniWt,
                            InitalWt: (isModalExist ? parseFloat(arrLodData[2].iniWt.iniWt.split(' ')[0]) : parseFloat(arrLodData[1].iniWt)).toFixed(3),
                            FinalWt: parseFloat(lossOnWt.split(' ')[0]).toFixed(3),
                            Duration: arrLodData[3].totaltime, //.totaltime,
                            MoistCont: 0,
                            RotaryType: 0,
                            IPQCType: currentCubicle.Sys_IPQCType,
                            //SerialNo: date.format(now, 'HH:mm:ss') },
                            BatchSize: `${currentCubicle.Sys_BatchSize} ${currentCubicle.Sys_BatchSizeUnit}`,
                            Layer: layer,
                            LayerName: layerName,
                            SetTemp: isModalExist ? arrLodData[1].setTemp.setTemp : arrLodData[0].setTemp,
                            // IsRepoComp: cubicType,
                            GranuRepoHeading: GranuRepoHeading,
                            RepoLabel11: currentCubicle.Sys_Validation,
                            // Lot: hmiDetails.LotNo,
                            Area: currentCubicle.Sys_Area,
                            AppearanceDesc: currentCubicle.Sys_Appearance,
                            MachineSpeed_Min: currentCubicle.Sys_MachineSpeed_Min,
                            MachineSpeed_Max: currentCubicle.Sys_MachineSpeed_Max,
                            GenericName: currentCubicle.Sys_GenericName,
                            BMRNo: currentCubicle.Sys_BMRNo,
                            Temp: isModalExist ? arrLodData[1].setTemp.setTemp.split(' ')[0] : arrLodData[0].setTemp,
                        })

                    }
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(arrToObj)}`)



                    // await database.save(saveLodData);
                    Object.assign(responseObj, { status: 'success' });
                    // If Initial weight completes then set initWt flag to false
                    // objMonitor.monit({ case: 'LODFINWT', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER' } });
                    lodData.setTemp.flag = false;
                    //clear
                }
                //resolve(responseObj);

                let initwt = isModalExist ? arrLodData[2].iniWt : arrLodData[1].iniWt
                if (initwt != undefined && lossOnWt != 0) {

                    let result = await this.SaveLodLastPortion(productObj, tempUserObject, IdsNo, lodData, cubicType, responseObj);

                    globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
                        ? globalData.arrSelectedMenu
                        : globalData.arrSelectedMenu.splice(
                            globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
                            1
                        );

                    globalData.arrLODTypeSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
                        ? globalData.arrLODTypeSelectedMenu
                        : globalData.arrLODTypeSelectedMenu.splice(
                            globalData.arrLODTypeSelectedMenu.findIndex((k) => k.Hmi == strHmi),
                            1
                        );

                    globalData.arr_IPQCRelIds.findIndex((k) => k.Hmi == strHmi) == -1
                        ? globalData.arr_IPQCRelIds
                        : globalData.arr_IPQCRelIds.splice(
                            globalData.arr_IPQCRelIds.findIndex((k) => k.Hmi == strHmi),
                            1
                        );

                    globalData.arrLodData.findIndex((k) => k.Hmi == strHmi) == -1
                        ? globalData.arrLodData
                        : globalData.arrLodData.splice(
                            globalData.arrLodData.findIndex((k) => k.Hmi == strHmi),
                            1
                        );

                    globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((element) => element.Hmi == strHmi), 1);

                    return result;
                }
                // else {

                //     return `${protocolIncomingType}R0,,,,,`;
                // }

            }
            else {


                const objMasterData = await models.tbl_lodmaster.findAll({
                    // data: 'max(RepSerNo) as RepSerNo',
                    attribute: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
                    where: {
                        BFGCode: currentCubicle.Sys_BFGCode,
                        ProductName: currentCubicle.Sys_ProductName,
                        PVersion: currentCubicle.Sys_PVersion,
                        Version: currentCubicle.Sys_Version,
                        BatchNo: currentCubicle.Sys_Batch,
                        IdsNo: IdsNo,
                        // IsRepoComp: cubicType,
                    }
                })


                // let res = await database.select(objMasterData);
                var maxRepNo = res[0][0].RepSerNo;

                const updateData = await models.tbl_lodmaster.update({

                    LossOnWt: tempLODdata.arr[2].finalWt,
                }, {
                    where: {
                        RepSerNo: maxRepNo,
                    }

                });
                // await database.update(updateData);
                let result = await this.SaveLodLastPortion(productObj, tempUserObject, IdsNo, protocolIncomingType, tempLODdata, cubicType, responseObj);
                //clear Array

                globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
                    ? globalData.arrSelectedMenu
                    : globalData.arrSelectedMenu.splice(
                        globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
                        1
                    );

                globalData.arrLODTypeSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
                    ? globalData.arrLODTypeSelectedMenu
                    : globalData.arrLODTypeSelectedMenu.splice(
                        globalData.arrLODTypeSelectedMenu.findIndex((k) => k.Hmi == strHmi),
                        1
                    );

                globalData.arr_IPQCRelIds.findIndex((k) => k.Hmi == strHmi) == -1
                    ? globalData.arr_IPQCRelIds
                    : globalData.arr_IPQCRelIds.splice(
                        globalData.arr_IPQCRelIds.findIndex((k) => k.Hmi == strHmi),
                        1
                    );

                globalData.arrLodData.findIndex((k) => k.Hmi == strHmi) == -1
                    ? globalData.arrLodData
                    : globalData.arrLodData.splice(
                        globalData.arrLodData.findIndex((k) => k.Hmi == strHmi),
                        1
                    );
                globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((element) => element.Hmi === strHmi), 1);
                return result;



            }
        }
        catch (err) {
            var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
            if (objLodData == undefined) {
                globalData.arrLodData.push({ idsNo: IdsNo, arr: [], counter: 0 })
            }
            else {
                objLodData.arr = [];
            }
            // Error loging in Error file
            var logError = momentObj().format('DD-MM-YYYY HH:mm:ss');
            console.log(err.stack)
            throw new Error(err);
        }
    }

    async SaveLodLastPortion(productObj, tempUserObject, IdsNo, tempLODdata, cubicType, responseObj) {

        var currentCubicle = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo)
        var strHmi = currentCubicle.Hmi
        currentCubicle = currentCubicle.cubicalData
        var menuName = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
        const objMasterData = await models.tbl_lodmaster.findAll({
            attribute: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
            where: {
                BFGCode: currentCubicle.Sys_BFGCode,
                ProductName: currentCubicle.Sys_ProductName,
                PVersion: currentCubicle.Sys_PVersion,
                Version: currentCubicle.Sys_Version,
                BatchNo: currentCubicle.Sys_Batch,
                IdsNo: strHmi,
                // IsRepoComp: cubicType,
            }
        })

        let res = objMasterData;
        var maxRepNo = res.pop();
        var RepSerNo = maxRepNo.RepSerNo

        var menu = menuName.menuName

        var objActivity = {};
        Object.assign(objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: `${menu} Weighment Completed on TSH ` + strHmi });

        await objActivityLog.ActivityLogEntry(objActivity);
        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Test Completed`);
        var currentCubicle = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
        var cubicalData = currentCubicle.cubicalData;
        // if (!(cubicalData.Sys_IPQCType == 'Compression' && cubicalData.Sys_Area == "Coating")) {
        //     await objBatchSummary.saveBatchSummaryLOD(productObj, strHmi, tempLODdata, tempUserObject);
        // }
        // objMonitor.monit({ case: 'BL', idsNo: IdsNo, data: { test: 'MOISTURE ANALYZER', flag: 'COMPLETED' } });
        // var LOD = await sequelize.query(`SELECT ROUND(CAST((((InitalWt-FinalWt)/InitalWt)*100) AS DECIMAL(20,15)),2) AS lodPer,ROUND(CAST(MinLimit AS DECIMAL(20,15)),2)  AS MINWT,ROUND(CAST(MaxLimit AS DECIMAL(20,15)),2) AS MAXWT FROM tbl_lodmaster WHERE RepSerNo=${RepSerNo}`);
        var LOD = (((maxRepNo.InitalWt - maxRepNo.FinalWt) / maxRepNo.InitalWt) * 100).toFixed(2)
        Object.assign(responseObj, { status: 'success' })
        var remark;
        if (parseFloat(LOD) < parseFloat(maxRepNo.MinLimit) ||
            parseFloat(LOD) > parseFloat(maxRepNo.MaxLimit)) {
            remark = "Not Complies";
            // remark = "Out of Limit";
        } else {
            remark = "Complies";
            // remark = "Within Limit";
        }

        const updatelodmaster = await models.tbl_lodmaster.update(
            {
                NetWt: Number(LOD).toFixed(2),
                Remark: remark
            },
            {
                where: {
                    RepSerNo: RepSerNo
                    // Idsno: strHmi,
                },
            }
        );
        //   return updatelodmaster;



        //OPC post tagss
        // await objopcOps.MoistAnalizer(maxRepNo);
        //
        if (cubicalData.Sys_RptType == 0) {
            var objOnlineReport = {
                SelectedAction: maxRepNo,
                UserId: tempUserObject.UserId,
                UserName: tempUserObject.UserName,
                waterMark: true,
                SelectedValue: LOD,
            }
            const objPrinterName = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);

            var objReport = {
                reportOption: 'Moisture Analyzer',
                RepSerNo: maxRepNo
            }
            // await objPrintReport.printReport(objOnlineReport, objReport, objPrinterName.cubicalData.Sys_PrinterName);
        } else {
            // console.log('Initial report')
        }

        if (remark == "Complies") {
            var repop = 'LOD';
            var intProductType = 1;

            // if (menu == GLOBAL_NOMENCLATURE.LODMenu) {
            //     repop = 'LOD';
            // } else if (menu == GLOBAL_NOMENCLATURE.LODLayer1Menu) {
            //     repop = 'LOD Layer 1';
            // } else if (menu == GLOBAL_NOMENCLATURE.LODLayer2Menu) {
            //     repop = 'LOD Layer 2';
            // }

            if (menu == GLOBAL_NOMENCLATURE.LODMenu) {
                repop = 'LOD';
            } else if (menu == GLOBAL_NOMENCLATURE.granulationDry) {
                repop = 'Granulation Dry';
            } else if (menu == GLOBAL_NOMENCLATURE.granulationLub) {
                repop = 'Granulation Lubricant';
            } else if (menu == GLOBAL_NOMENCLATURE.lay1Dry) {
                repop = 'Layer 1 Granulation Dry';
            } else if (menu == GLOBAL_NOMENCLATURE.lay1Lub) {
                repop = 'Layer 1 Granulation Lubricant';
            } else if (menu == GLOBAL_NOMENCLATURE.LODLayer1Menu) {
                repop = 'LOD LAYER 1';
            } else if (menu == GLOBAL_NOMENCLATURE.LODLayer2Menu) {
                repop = 'LOD LAYER 2';
            }

            var printObj = {
                recordFrom: "Current",
                Side: "Single",
                reportOption: repop,
                reportType: "Complete",
                testType: "Regular",
                RepSerNo: RepSerNo,
                batchNo: cubicalData.Sys_Batch,
                cubicleType: cubicalData.Sys_CubType,
                userId: tempUserObject.UserId,
                username: tempUserObject.UserName,
                int_ReportFormat: 1,
                printNo: 0,
                str_url: intProductType === 1 ? "Tablet" : "Capsule"
            }

            await printOperations.callViewTabReport(printObj, intProductType, strHmi);
        }


        //clearing and reiniting LOD DATA
        var objLodData = globalData.arrLodData.find(LD => LD.idsNo == IdsNo);
        if (objLodData == undefined) {
            globalData.arrLodData.push({ idsNo: IdsNo, arr: [], counter: 0 })
        }
        else {
            objLodData.arr = [];
        }
        return 'LOD Weighment Completed on TSH';
    }


}

// precision(a) ;{
//     if (!isFinite(a)) return 0;
//     var e = 1, p = 0;
//     while (Math.round(a * e) / e !== a) { e *= 10; p++; }
//     return p;
// }

module.exports = LOD