const globalData = require("../../global/globalData");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsIncompleteReport = require("../Product/clsIncompleteReport");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const MqttModel = require("../Mqtt/mqttSender.class");
const Database = require("../../database/clsQueryProcess");
const clsCommonUseFunction = require("../clsCommonUseFunction");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
const clsCalculation = require('../clsCalculationOperation');
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const clsPrintOperations = require("../Print/clsPrintOperation")

const objMonit = new clsMonit();
const objcalc = new clsCalculation();
const database = new Database();
const objIncompleteReport = new clsIncompleteReport();
const objCommonInsertOpt = new clsCommonInsertOpt();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objformulaFun = new FormulaFunModel();
const mqttSender = new MqttModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objPowerBackup = new PowerBackup();
const printOperations = new clsPrintOperations()

class Individual {
  async processIndividualData(__parameterObj) {
    try {
      let strHmi = __parameterObj.Hmi;
      let strIdsNo = __parameterObj.idsNo;
      let actualWt = __parameterObj.actualWt;
      let unit = __parameterObj.unit;
      let ProtocolPortNo = __parameterObj.ProtocolPortNo;
      const strMenuName = __parameterObj.menuName;
      let objResIndividualActivity;
      let objResIndividual;
      let objActivity = {};
      let typeValue;
      let outFlag = 0;
      let reportLimitMsg = "Report Within Limit";
      let minLimitT2;
      let maxLimitT2;
      let maxLimitT1;
      let minLimitT1;
      let masterTable;
      let detailTable;
      let dblTable;
      let readingIgnore;


      // const menuDetailsArr = globalData.arr_limits.find(k => k.Hmi == strHmi);
      let individualDetail = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      );

      var cubicObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
      var AreaName = cubicObj.Sys_Area

      let objSelMenu = globalData.arrSelectedMenu.find(
        (k) => k.idsNo == strIdsNo
      );
      let sample = parseFloat(individualDetail.data.noOfSample);
      let batchNo = individualDetail.data.Batch;

      if (unit == "g" || unit == "G" || unit == "gm" || unit == "Gm" || unit == "GM") {
        unit = "g"
      }

      // if ((unit).toLowerCase() != (objSelMenu.selectedProductDetail.unit).toLowerCase()) {
      //   mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Unit Received`)
      //   return;
      // }
      //let menuDetail = menuDetailsArr.Menus.filter(obj => Object.keys(obj) == strMenuName)[0][strMenuName];
      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }
      // let productDetail = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi).productType;


      switch (strMenuName) {
        case `${GLOBAL_NOMENCLATURE.IndividualMenu}`:
          if (cubicObj.Sys_CubType == 'Capsule Filling' || cubicObj.Sys_IPQCType == 'Capsule Filling') {
            masterTable = 'tbl_cap_master1';
            detailTable = 'tbl_cap_detail1';
            // strincomplete = 'tbl_cap_master1_incomplete';
            typeValue = 1;
            maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
            maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail);
            minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail);
            minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');
          } else {
            masterTable = 'tbl_tab_master1';
            detailTable = 'tbl_tab_detail1';
            // strincomplete =  'tbl_tab_master1_incomplete'
            typeValue = 1;
            maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
            maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail);
            minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail);
            minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');
          }
          break;
        case `${GLOBAL_NOMENCLATURE.IndLayerMenu}`:
          masterTable = 'tbl_tab_master9'
          detailTable = 'tbl_tab_detail9'
          // strincomplete ='tbl_tab_master9_incomplete'
          typeValue = 9;
          maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
          maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail);
          minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail);
          minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');
          break;
        case `${GLOBAL_NOMENCLATURE.IndLayer1Menu}`:
          masterTable = 'tbl_tab_master11';
          detailTable = 'tbl_tab_detail11';
          // strincomplete ='tbl_tab_master11_incomplete'
          typeValue = 11;
          maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
          maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail);
          minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail);
          minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');
          break;
        case GLOBAL_NOMENCLATURE.GroupIndividual:
          masterTable = "tbl_tab_master19";
          detailTable = "tbl_tab_detail19";
          // strincomplete ="tbl_tab_master19_incomplete"
          typeValue = 19;
          maxLimitT1 = (null, 'T1');
          maxLimitT2 = null;
          minLimitT2 = null;
          minLimitT1 = (null, 'T1');
          break;
      }

      let intProductType = objSelMenu.selectedProductDetail.ProductType;

      let tempCounterObj = globalData.arrWeighmentCounter.find((k) => k.Hmi == strHmi);
      if (tempCounterObj === undefined) {
        globalData.arrWeighmentCounter.push({ Hmi: strHmi, counter: 0 });
      }
      tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      // globalData.arrUserRights
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);
      let _cubicalData = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData;
      // console.log(tempUserObject);
      var Side = individualDetail.data.Side
      let __parameterIndividual;

      var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
      var SelectedIdsNo
      if (IPQCObject != undefined) {
        SelectedIdsNo = IPQCObject.selectedIds.Idsno;
      } else {
        SelectedIdsNo = strHmi;
      }

      let lastInserted_repsrno;

      //check for power backup
      if (sample >= tempCounterObj.counter) {
        // tempCounterObj.counter += 1;
        __parameterIndividual = {
          strTableName: masterTable,
          strDetailTbl: detailTable,
          // strDblDetailTbl: dblTable,
          objProductDetails: individualDetail.data,
          uniqueSerialNumber: strIdsNo,
          strBalId: __parameterObj.instrumentId,
          ProtocolData: __parameterObj.actualWt,
          ProtocolUnit: (unit).toLowerCase(),
          ProtocolDecPoint: __parameterObj.decPoint,
          strHmi: strHmi,
          seqNoOfWt: tempCounterObj.counter,
          productType: objSelMenu.selectedProductDetail.ProductType,
        };
        let tableName = "tbl_powerbackup";
        var powerbackupobj = {
          strTableName: masterTable,
          strDetailTbl: detailTable,
          cubicaNo: _cubicalData.Sys_CubicNo,
          cubicType: _cubicalData.Sys_CubType,
          cubicSysBFGcode: _cubicalData.Sys_BFGCode,
          cubicBatch: _cubicalData.Sys_Batch,
          menuName: individualDetail.data.menuName,
          ProductType: objSelMenu.selectedProductDetail.ProductType,
          ReportType: _cubicalData.Sys_RptType,
          Userid: individualDetail.data.userId,
          RecSampleNo: tempCounterObj.counter,
          idsNo: strIdsNo,
          Hmi: strHmi,
          SelectedIds: SelectedIdsNo
          // Incomp_RepSerNo: tempCounterObj.counter,
        };

        let _check_combination = await objPowerBackup._check_combination_pow(objSelMenu, powerbackupobj, tableName);
        if (_check_combination !== undefined) {
          //   tempCounterObj.counter = _check_combination.Incomp_RepSerNo + 1;
          // }
          tempCounterObj.counter = _check_combination.RecSampleNo + 1;
          powerbackupobj.RecSampleNo = tempCounterObj.counter
          __parameterIndividual.seqNoOfWt = tempCounterObj.counter
        }
        else {
          tempCounterObj.counter += 1;
          powerbackupobj.RecSampleNo = tempCounterObj.counter
          __parameterIndividual.seqNoOfWt = tempCounterObj.counter
        }
        //else {
        //     tempCounterObj.counter += 1;
        // }

        const __ParamRemark = {
          idsNo: strHmi,
          menuName: strMenuName,
          batchNo: batchNo,
          tableName: masterTable,
        };

        // insert double entry for individual dbl_detail table
        // var check_Double = await this.calculateDoubleVal(
        //   individualDetail.data.Nominal,
        //   __parameterObj.actualWt
        // );

        // if (check_Double) {
        //   readingIgnore = "Double Value received";
        //   decimal = await objCommonInsertOpt.insert_Into_Dbl_Detail(
        //     __parameterIndividual
        //   );
        // } else {
        var side;
        var act_msg = individualDetail.data.Side == 'NA' ? `${strMenuName} Weighment Started on TSH ${strHmi}` : `${strMenuName} Weighment Started on TSH ${strHmi} for side ${individualDetail.data.Side}`
        if (tempCounterObj.counter == 1) {
          let __activityObj = {
            strUserId: tempUserObject.UserId,
            strUserName: tempUserObject.UserName,
            activity: act_msg,
          };

          await objActivityLog.ActivityLogEntry(__activityObj);
          await objInstrumentUsage.InstrumentUsage('Balance',
            strIdsNo, 'tbl_instrumentlog_balance', strMenuName, 'started');

          var msrNo = await objCommonInsertOpt.insert_Into_Incomplete_Master(__parameterIndividual);

          // if(incompRepSerNo !== undefined){
          //   tempCounterObj.counter = incompRepSerNo;
          // }
          // let TableName =  masterTable + "_incomplete"
          // const insertRepoRemarkDetail =
          //   await models.tbl_remark_incomplete_master.create({ IDSNo: strHmi, paramName: strMenuName, tableName: masterTable.name + "_incomplete", BatchNumber: batchNo });

          // await insertRepoRemarkDetail;
          // insert into remark table
        }
        // __parameterIndividual.mserNo = msrNo ;
        lastInserted_repsrno = await objCommonInsertOpt.insert_Into_Incomplete_Detail(__parameterIndividual);
        // objResIndividual = await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', '', 'completed');
        powerbackupobj.Incomp_RepSerNo = lastInserted_repsrno.repSerNo

        await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
        var incompRepSerNo = await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
        //update calculation
        var updateData = await objcalc.calculation_operation(__parameterIndividual, lastInserted_repsrno.repSerNo);
        let hmiEntryinConfig = globalData.arrConfigSettings.find((k) => k.Hmi == strHmi).configSetting;
        let autoTare = hmiEntryinConfig[0].AutoTare;
        let tareCommand = hmiEntryinConfig[0].Tare_Command.concat(`\r\n`);
        const objUpdateValidation = await models.tbl_cubical.update({
          'Sys_Validation': 0
        }, {
          where: {
            'Sys_rpi': cubicObj.Sys_rpi
          }

        });
        let sampleNo = tempCounterObj.counter;
        let limitObjResp = await objCommonUseFunc.SendCommon({
          strHmi,
          actualWt,
          readingIgnore,
          minLimitT2,
          maxLimitT2,
          minLimitT1,
          maxLimitT1,
          strMenuName,
          sampleNo,
        });
        let color = limitObjResp.Color;
        let limit = limitObjResp.limit;

        mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayResult}${tempCounterObj.counter}:${actualWt} ${(unit).toLowerCase()}:${color}`
        );
        //monit


        await objMonit.monit({
          case: 'TestWeight', Hmi: strHmi, data: {
            Weight: `${actualWt} ${(unit).toLowerCase()}`, srNo: "", message: `${limit}`
          }
        });

        if (autoTare) {
          mqttSender.sendData(
            strHmi,
            `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
          );
        }
        if (limit != 'DisplayMessage:Within Limit') {
          mqttSender.sendData(strHmi, limit);
        }



        // if (limit.includes("ABOVE") || limit.includes("BELOW")) {
        //   reportLimitMsg = "Report Out Of Limit"
        // }
        // else {
        //   reportLimitMsg = "Report Within Limit"
        // }

        // mqttSender.sendData(strHmi, limit);

        if (sample == tempCounterObj.counter) {
          //move data from incomplete to complete
          //remove outOfLimit Flag
          //check nmt range
          //limit checking
          var updateData = await objcalc.calculation_operation(__parameterIndividual, lastInserted_repsrno.repSerNo);
          var act = `${strMenuName} Test Completed on TSH ${strHmi}`
          if (Side == 'LHS') {
            var act = `${strMenuName} Test Completed on TSH ${strHmi} for side LHS`
          }
          // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${act}`);
          // if (Side == 'RHS') {
          //   var response = await objCommonInsertOpt.saveCompleteData(__parameterIndividual, typeValue, Side);
          //   await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, masterTable);
          // } else {
          //   if (_cubicalData.Sys_RotaryType == "Single") {
              var response = await objCommonInsertOpt.saveCompleteData(__parameterIndividual, typeValue, Side);
              // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, masterTable);
            // }
          // }
          const _deletePowerbackup = await models.tbl_powerbackup.destroy({
            where: {
              Idsno: strHmi,
              Sys_Batch: _cubicalData.Sys_Batch,
              WeighmentName: strMenuName
            },
          });
          if (updateData == "Not Complies") {
            reportLimitMsg = "Report Out Of Limit"
          }
          else {
            reportLimitMsg = "Report Within Limit"
          }
          // let result = await objIncompleteReport.getIncomepleteData(__parameterIndividual, __parameterIndividual.strTableName, __parameterIndividual.strDetailTbl, strIdsNo);
          var act_lastmsg = individualDetail.data.Side == 'NA' ? `${strMenuName} Weighment Completed on TSH ${strHmi}` : `${strMenuName} Weighment Completed on TSH ${strHmi} for side ${individualDetail.data.Side}`
          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            {
              activity: act_lastmsg,
            }
          );
          objResIndividualActivity = await objActivityLog.ActivityLogEntry(
            objActivity
          );
          objResIndividual = await objInstrumentUsage.InstrumentUsage("Balance", strIdsNo, "tbl_instrumentlog_balance", "", "completed");
          console.log(tempCounterObj.counter);

          // let tempMenuName;
          // switch (){

          // }
          // if (Side == 'RHS') {
            if (updateData == "Complies") {
              var printObj = {
                RepSerNo: response.RepSerNo,
                Side:Side,
                batchNo:cubicObj.Sys_Batch,
                cubicleType:cubicObj.Sys_CubType,
                int_ReportFormat:1,
                printNo: 0,
                recordFrom: "Current",
                reportOption: strMenuName,
                reportType: "Complete",
                str_url: intProductType === 1 ? "Tablet" : "Capsule",
                testType: "Regular", 
                userId: tempUserObject.UserId,
                username: tempUserObject.UserName,
              

              }


              await printOperations.callViewTabReport(printObj, intProductType, strHmi);

            // }
          }
          globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrWeighmentCounter
            : globalData.arrWeighmentCounter.splice(
              globalData.arrWeighmentCounter.findIndex(
                (k) => k.Hmi == strHmi), 1
            );


          globalData.arrCurrentOperationStatus.findIndex(
            (element) => element.Hmi === strHmi
          ) == -1
            ? globalData.arrCurrentOperationStatus
            : globalData.arrCurrentOperationStatus.splice(
              globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );

          globalData.arrOutFlagForTest.findIndex(
            (element) => element.Hmi === strHmi
          ) == -1
            ? globalData.arrOutFlagForTest
            : globalData.arrOutFlagForTest.splice(
              globalData.arrOutFlagForTest.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );
          globalData.arrWeighmentProductData.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrWeighmentProductData
            : globalData.arrWeighmentProductData.splice(
              globalData.arrWeighmentProductData.findIndex(
                (k) => k.Hmi == strHmi), 1
            );
          //test splice if rotarty is not double
          globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrSelectedMenu
            : globalData.arrSelectedMenu.splice(
              globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
              1
            );
             await objMonit.monit({
                            case: 'ReportStatus',
                            Hmi: strHmi,
                            data: {
                                message: reportLimitMsg
                            }
                        });
          mqttSender.sendData(strHmi,`${mqttProtocol.TestCompleted}${reportLimitMsg}`);
         
          return;
        }
        // }

        //insert data into detail table
        //console.log(tempCounterObj.counter);

        // if (incompRepSerNo !== undefined) {
        //     tempCounterObj.counter = incompRepSerNo;
        // }


      }
    } catch (error) {
      throw new Error(error);
    }
  }

  async calculateDoubleVal(Nominal, CommingWT) {
    var percent = (80 / 100) * parseFloat(Nominal);
    return CommingWT > parseFloat(Nominal) + percent ? true : false;
  }

}
module.exports = Individual;
