//packages
const date = require("date-and-time");

const globalData = require("../../global/globalData");
const Database = require("../../database/clsQueryProcess");
const MqttSender = require("../Mqtt/mqttSender.class");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const ActivityModel = require("../clsActivityLog.model");
const InstrumentUsageModel = require("../clsInstrumentUsageLog");
const MqttModel = require("../Mqtt/mqttSender.class");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const clsCommonUseFunction = require("../clsCommonUseFunction");
const BatchSummaryModel = require("../Product/clsBatchSummaryOperation");
const momentObj = require("moment")
const maths = require('mathjs')
const clsFormula = require("../Product/clsformulaFun.model");
const objFormula = new clsFormula();
const database = new Database();
const now = new Date();
const objformulaFun = new FormulaFunModel();
const objActivityLog = new ActivityModel();
const objInstrumentUsage = new InstrumentUsageModel();
const mqttSender = new MqttModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objBatchSummary = new BatchSummaryModel();
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
//const { models } = require('../../../config/dbConnection');
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const { QueryTypes } = require("sequelize");
const objMonit = new clsMonit();


class Group {
  async processGroupData(dataObj) {
    try {
      let strHmi = dataObj.Hmi;
      let strIdsNo = dataObj.idsNo;
      const menuName = dataObj.menuName;
      var [Balinfo] = await models.tbl_balance.findAll({
        where: {
          'Bal_ID': dataObj.instrumentId
        }
      })
      var DP = Balinfo.Bal_DP;
      const actualWt = Number(maths.round(dataObj.actualWt, DP)).toFixed(DP)
      const InstrumentId = dataObj.instrumentId;
      const protocolUnit = dataObj.unit;
      const decimalPoint = dataObj.decPoint;
      let ProtocolPortNo = dataObj.ProtocolPortNo;
      let GroupDetail = globalData.arrWeighmentProductData.find((k) => k.Hmi == strHmi);
      let sample = GroupDetail.data.noOfSample;
      let tempCounterArr = globalData.arrWeighmentCounter.find((k) => k.Hmi == strHmi);
      if (tempCounterArr == undefined) {
        globalData.arrWeighmentCounter.push({
          Hmi: strHmi,
          idsNo: strIdsNo,
          counter: 1,
        });
      }
      tempCounterArr = globalData.arrWeighmentCounter.find((k) => k.Hmi == strHmi);

      const __paramGroup = {
        actualWt: actualWt,
        InstrumentId: InstrumentId,
        menuName: menuName,
        idsNo: strIdsNo,
        Hmi: strHmi,
        GroupDetail: GroupDetail,
        protocolUnit: protocolUnit,
        decimalPoint: decimalPoint,
        baldecimalPoint: DP,
        ProtocolPortNo: ProtocolPortNo,
      };
      //10 >= 1
      if (tempCounterArr.counter == 1) {
        //insert into incomp master and detail
        await this.SaveGroupCompleteData(__paramGroup);
      }
    } catch (error) {
      console.log(error)
      throw new Error(error);

    }
  }

  async SaveGroupCompleteData(dataObj) {
    try {
      let masterTable, detailTable, typeValue;
      let strHmi = dataObj.Hmi;
      let strIdsNo = dataObj.idsNo;
      const strMenuName = dataObj.menuName;
      let ProtocolPortNo = dataObj.ProtocolPortNo;
      var lotNo = dataObj.GroupDetail.data.lotno;
      var decimalPoint = dataObj.decimalPoint;
      var baldecimalPoint = dataObj.baldecimalPoint;
      let actualWt = Number(maths.round(dataObj.actualWt, baldecimalPoint)).toFixed(baldecimalPoint)
      const InstrumentId = dataObj.InstrumentId;
      var protocolUnit = dataObj.protocolUnit;
      const productDetail = dataObj.GroupDetail.data;
      var sample = parseFloat(productDetail.noOfSample);
      let side = productDetail.Side;
      const currentCubical = globalData.arrIdsInfo.find((k) => k.Hmi == strHmi).cubicalData;
      const tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == strIdsNo);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      const currentCubicalObj = globalData.arrIdsInfo.find((k) => k.idsNo == selectedIdsNo);

      const menuDetailsArr = globalData.arr_limits.find((k) => k.idsNo == selectedIdsNo);

      let menuDetail = menuDetailsArr.Menus.filter((obj) => Object.keys(obj) == strMenuName)[0][strMenuName];
      // var Nominal = menuDetail.nominal;
      // Nominal = Number(maths.round(Nominal,3)).toFixed(3);

      // let menuDetail = menuDetailsArr.Menus.filter((obj) => Object.keys(obj) == strMenuName)[0][strMenuName];

      // if (protocolUnit.startsWith('g')) {
      //   protocolUnit = protocolUnit == ("g" || "gm") ? "g" : "g"
      // }


      // if (protocolUnit != menuDetail.unit) {
      //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Unit Received`)
      // }


      if (protocolUnit == "g" || protocolUnit == "G" || protocolUnit == "gm" || protocolUnit == "Gm" || protocolUnit == "GM") {
        if (protocolUnit.startsWith('g') || protocolUnit.startsWith('G')) {
          // protocolUnit = protocolUnit == "g" ? "gm" : "gm"
          protocolUnit = "g";
        }
      }
      // if (protocolUnit != 'g') {
      //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Unit Received`)
      // }

      const cubicalObj = currentCubicalObj.cubicalData;
      const NMT = menuDetail.NMT;
      const T1Neg = menuDetail.T1Neg;
      const T2Neg = menuDetail.T2Neg;
      const T1Pos = menuDetail.T1Pos;
      const T2Pos = menuDetail.T2Pos;
      let outFlag = 0;
      let intMstSerNo;
      let reportLimitMsg = `${mqttProtocol.DisplayMessage}Report generated is Within limit`;
      let minLimitT2;
      let maxLimitT2;
      let maxLimitT1;
      let minLimitT1;

      if (cubicalObj.Sys_CubType == 'Coating' && cubicalObj.Sys_IPQCType != "Compression") {
        var productData = await models.tbl_product_tablet_coated.findAll({
          where: {
            ProductId: cubicalObj.Sys_BFGCode,
            ProductName: cubicalObj.Sys_ProductName,
            ProductVersion: cubicalObj.Sys_PVersion,
            Version: cubicalObj.Sys_Version,
          }
        });
      } else if (cubicalObj.Sys_CubType == 'Capsule Filling' || cubicalObj.Sys_IPQCType == 'Capsule Filling') {
        var productData = await models.tbl_product_capsule.findAll({
          where: {
            ProductId: cubicalObj.Sys_BFGCode,
            ProductName: cubicalObj.Sys_ProductName,
            ProductVersion: cubicalObj.Sys_PVersion,
            Version: cubicalObj.Sys_Version,
          }
        });
      }
      else {
        var productData = await models.tbl_product_tablet.findAll({
          where: {
            ProductId: cubicalObj.Sys_BFGCode,
            ProductName: cubicalObj.Sys_ProductName,
            ProductVersion: cubicalObj.Sys_PVersion,
            Version: cubicalObj.Sys_Version,
          }
        });
      }

      switch (strMenuName) {
        case GLOBAL_NOMENCLATURE.GroupMenu:
          if (cubicalObj.Sys_CubType == 'Capsule Filling' || cubicalObj.Sys_IPQCType == 'Capsule Filling') {
            masterTable = 'tbl_cap_master2';
            detailTable = 'tbl_cap_detail2';
            typeValue = 2;
            maxLimitT1 = objformulaFun.upperLimit(menuDetail, 'T1');
            maxLimitT2 = objformulaFun.upperLimit(menuDetail);
            minLimitT2 = objformulaFun.lowerLimit(menuDetail);
            minLimitT1 = objformulaFun.lowerLimit(menuDetail, 'T1');
            break;
          } else {
            masterTable = 'tbl_tab_master2';
            detailTable = 'tbl_tab_detail2';
            typeValue = 2;
            maxLimitT1 = objformulaFun.upperLimit(menuDetail, 'T1');
            maxLimitT2 = objformulaFun.upperLimit(menuDetail);
            minLimitT2 = objformulaFun.lowerLimit(menuDetail);
            minLimitT1 = objformulaFun.lowerLimit(menuDetail, 'T1');
            break;
          }
        case GLOBAL_NOMENCLATURE.GroupLayerMenu://group layer 1
          masterTable = "tbl_tab_master10";
          detailTable = "tbl_tab_detail10";
          typeValue = 10;
          maxLimitT1 = objformulaFun.upperLimit(menuDetail, 'T1');
          maxLimitT2 = objformulaFun.upperLimit(menuDetail);
          minLimitT2 = objformulaFun.lowerLimit(menuDetail);
          minLimitT1 = objformulaFun.lowerLimit(menuDetail, 'T1');
          break;
        case GLOBAL_NOMENCLATURE.GroupLayer1Menu:
          masterTable = "tbl_tab_master12";
          detailTable = "tbl_tab_detail12";
          typeValue = 12;
          maxLimitT1 = objformulaFun.upperLimit(menuDetail, 'T1');
          maxLimitT2 = objformulaFun.upperLimit(menuDetail);
          minLimitT2 = objformulaFun.lowerLimit(menuDetail);
          minLimitT1 = objformulaFun.lowerLimit(menuDetail, 'T1');
          break;
        default:
          masterTable = "tbl_cap_master2";
          detailTable = "tbl_cap_detail2";
          typeValue = 12;
          maxLimitT1 = objformulaFun.upperLimit(menuDetail, 'T1');
          maxLimitT2 = objformulaFun.upperLimit(menuDetail);
          minLimitT2 = objformulaFun.lowerLimit(menuDetail);
          minLimitT1 = objformulaFun.lowerLimit(menuDetail, 'T1');
      }

      var act = `${strMenuName} Test Started on TSH ${strHmi}`
      if (side == 'LHS') {
        var act = `${strMenuName} Test Started on TSH ${strHmi} for side LHS`
      } else if (side == 'RHS') {
        var act = `${strMenuName} Test Started on TSH ${strHmi} for side RHS`
      }


      let __activityObj = {
        strUserId: tempUserObject.UserId,
        strUserName: tempUserObject.UserName,
        activity: act,
      };

      await objActivityLog.ActivityLogEntry(__activityObj);
      await objInstrumentUsage.InstrumentUsage(
        "Balance",
        strIdsNo,
        "tbl_instrumentlog_balance",
        strMenuName,
        "started"
      );

      if (cubicalObj.Sys_RotaryType == 'Double') {
        side = side;
      }

      let resultCompleteData = await models[masterTable].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],

        where: {
          'BFGCode': cubicalObj.Sys_BFGCode,
          'ProductName': cubicalObj.Sys_ProductName,
          'PVersion': cubicalObj.Sys_PVersion,
          'Version': cubicalObj.Sys_Version,
          'BatchNo': cubicalObj.Sys_Batch,
          'CubicleType': cubicalObj.Sys_CubType,
          'ReportType': cubicalObj.Sys_RptType,
          // 'Side': side
        }
      })
      let resultDetailRecSeq = await models[detailTable].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RecSeqNo")), "RecSeqNo"],
        ],

        where: { RepSerno: resultCompleteData[0].RepSerNo }
      });
      let remark = "Complies"
      let RepSerno = resultCompleteData[0].RepSerNo;

      if (resultCompleteData[0].RepSerNo != null) {
        resultCompleteData = await models[masterTable].findAll({
          where: {
            RepSerNo: RepSerno
          }
        })
      }
      if (resultCompleteData[0].RepSerNo == null) {
        intMstSerNo = 1;
        var nob1 = 0
        var noa2 = 0
        var noa1 = 0
        var nob2 = 0

        if (Number(actualWt) < Number(minLimitT2)) { //No of below limit 2
          var nob2 = 1;
          remark = "Not Complies"
        } else if (Number(actualWt) > Number(maxLimitT2).toFixed(baldecimalPoint)) { //No of Above limit 2
          var noa2 = 1;
          remark = "Not Complies"
        }
        if (minLimitT1 != 0 && maxLimitT1 != 0) {
          if (actualWt < minLimitT1 && actualWt >= minLimitT2) { //No of below limit 1
            var nob1 = 1;
            remark = "Complies"    //CR 
          } else if (actualWt > maxLimitT1 && actualWt <= maxLimitT2) { //No of Above limit 1
            var noa1 = 1;
            remark = "Complies"
          }
        }
      } else {
        var newMstSerNo = resultCompleteData[0].RepSerNo + 1;
        intMstSerNo = newMstSerNo;
        var nob1 = Number(resultCompleteData[0].NoOfBelow1)
        var noa1 = Number(resultCompleteData[0].NoOfAbove1)
        var nob2 = Number(resultCompleteData[0].NoOfBelow2)
        var noa2 = Number(resultCompleteData[0].NoOfAbove2)


        if (Number(actualWt) < Number(minLimitT2)) { //No of below limit 2
          var nob2 = Number(resultCompleteData[0].NoOfBelow2) + 1;
          remark = "Not Complies"
        } else if (Number(actualWt) > Number(maxLimitT2).toFixed(baldecimalPoint)) { //No of Above limit 2
          var noa2 = Number(resultCompleteData[0].NoOfAbove2) + 1;
          remark = "Not Complies"
        }
        if (minLimitT1 != 0 && maxLimitT1 != 0) {
          if (Number(actualWt) < Number(minLimitT1) && Number(actualWt) >= Number(minLimitT2)) { //No of below limit 1
            var nob1 = Number(resultCompleteData[0].NoOfBelow1) + 1;
            remark = "Complies" //CR
          } else if (Number(actualWt) > Number(maxLimitT1) && Number(actualWt) <= Number(maxLimitT2)) { //No of Above limit 1
            var noa1 = Number(resultCompleteData[0].NoOfAbove1) + 1;
            remark = "Complies"
          }
        }
      }
      let minMaxDp = menuDetail.LimitOn == 0 ? baldecimalPoint : 2;
      if (intMstSerNo != 1) {

        let tabDetails = await models[masterTable].findAll({
          where: {
            RepSerNo: RepSerno,
          },
        });


        const __paramProductInfoData = {
          side: side,
          masterTable: masterTable,
          detailTable: detailTable,
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          BatchNo: cubicalObj.Sys_Batch,
          ReportType: cubicalObj.Sys_RptType,
        };

        let seqNo = await this.calculateSeqNo(__paramProductInfoData);
        decimalPoint = resultCompleteData[0].DecimalPoint;
        if (tabDetails.length > 0) {
          const insertIncompleteDetailObj = {
            RepSerNo: RepSerno,
            MstSerNo: resultCompleteData[0].MstSerNo,
            RecSeqNo: seqNo,
            LotNo: lotNo,
            DataValue: Number(maths.round(actualWt, baldecimalPoint)).toFixed(baldecimalPoint),
            BatchNo: currentCubical.Sys_Batch,
            BFGCode: cubicalObj.Sys_BFGCode,
            ProductName: productDetail.ProductName,
            UserId: productDetail.userId,
            UserName: productDetail.userName,
            PrDate: momentObj().format("YYYY-MM-DD"),
            PrTime: momentObj().format("HH:mm:ss"),
            Side: side == 'NA' ? 'Single' : side,
            DecimalPoint: decimalPoint,
            PVersion: cubicalObj.Sys_PVersion,
            Version: cubicalObj.Sys_Version,
            // AvgWeight: (Number(actualWt)).toFixed(4),
            // Deviation: (((Number(Nominal) - Number(actualWt)) / Number(Nominal)) * 100).toFixed(4),
            Remark: remark,
            InstrumentID: InstrumentId,
            NoOfSample: productDetail.noOfSample,
            IPC_Code: productDetail.ipccode

          };
          var seq = await models[detailTable].create(insertIncompleteDetailObj);

          var DataValue_arr = [];
          var obj = {}
          // var Nominal = menuDetail.nominal;
          // Nominal = Number(Nominal).toFixed(3);
          var get_Datavalue = await models[detailTable].findAll({ where: { RepSerNo: RepSerno } })
          var get_Datavalue1 = await models[masterTable].findAll({ where: { RepSerNo: RepSerno } })
          var start = get_Datavalue[0].DataValue;
          var seq_data = get_Datavalue.length
          var end = Number(maths.round(actualWt, baldecimalPoint)).toFixed(baldecimalPoint);
          var gain = ((Math.abs(end - start)) / sample) * 1000; //As per DS formula
          console.log("gain", gain);
          DataValue_arr.push(get_Datavalue);
          var arr = [];
          var avgarr = [];
          for (var i = 0; i < get_Datavalue.length; i++) {
            var a = get_Datavalue[i].DataValue;
            var b = get_Datavalue[i].AvgWeight;
            arr.push(Number(a));
            avgarr.push(Number(b));
            // console.log(arr);
            var max_value = maths.max(arr); //Max Group Weight on report
            var min_value = maths.min(arr); //Min Group Weight on report

            var avg_max = maths.max(avgarr); // Max Weight on report
            var avg_min = maths.min(avgarr); //Min Weight on report

            var totalGrp = maths.sum(arr); //Average Group Weight on report
            var totalAvg = maths.sum(avgarr); //Average weight of tab on report
            var Nommm = Number(menuDetail.nominal).toFixed(baldecimalPoint);
            var MinPer = maths.abs(((Nommm - min_value) / Nommm) * 100).toFixed(2);
            var MaxPer = maths.abs(((Nommm - max_value) / Nommm) * 100).toFixed(2);
            // console.log();
            // console.log(max_value, min_value);
            // return arr;
          }

          var AvgGrpWeight = ((Number(totalGrp)) / Number(get_Datavalue.length))
          var AvgWeight = ((Number(totalAvg)) / Number(get_Datavalue.length))

          let productDetailArr = globalData.arrProductTypeArray.find((k) => k.Hmi == strHmi).productDetail[0];
          let wtGainDp = (productDetailArr[0].Param2_Unit) == "mg" ? 2 : baldecimalPoint;

          minLimitT2 = (Math.round(minLimitT2 * 1000) / 1000);
          maxLimitT2 = (Math.round(maxLimitT2 * 1000) / 1000);


          const detailUpdate = await models[detailTable].update({
            WeightGain: Number(maths.round(gain, wtGainDp)).toFixed(wtGainDp),
          }, {
            where: {
              RecSeqNo: seq_data,
              RepSerNo: RepSerno
            },
          });

          const resupdate = await models[masterTable].update(
            {
              PrEndDate: momentObj().format("YYYY-MM-DD"),
              PrEndTime: momentObj().format("HH:mm:ss"),
              MinGrpWeight: Number(min_value).toFixed(baldecimalPoint),
              MaxGrpWeight: Number(max_value).toFixed(baldecimalPoint),
              MinWeight: Number(avg_min).toFixed(baldecimalPoint),
              MaxWeight: Number(avg_max).toFixed(baldecimalPoint),
              MinPer: MinPer,
              MaxPer: MaxPer,
              AvgGrpWeight: Number(maths.round(AvgGrpWeight, 4)).toFixed(4),
              AvgWeight: Number(maths.round(AvgWeight, 4)).toFixed(4),  //mathj.round(((totalGrp) / (totalRecNo)), 1).toFixed(decimalPoint)
              NoOfBelow1: nob1 != undefined ? nob1 : 0,
              NoOfAbove1: noa1 != undefined ? noa1 : 0,
              NoOfBelow2: nob2 != undefined ? nob2 : 0,
              NoOfAbove2: noa2 != undefined ? noa2 : 0,
              Nom: Number(menuDetail.nominal).toFixed(baldecimalPoint),
              T1NegTol: Number(minLimitT1).toFixed(baldecimalPoint),
              T1PosTol: Number(maxLimitT1).toFixed(baldecimalPoint),
              T2NegTol: (Number(minLimitT2)).toFixed(baldecimalPoint),
              T2PosTol: (Number(maxLimitT2)).toFixed(baldecimalPoint),
              T2NegTolActual: productData[0].Param2_T2Neg.toFixed(minMaxDp),
              T2PosTolActual: productData[0].Param2_T2Pos.toFixed(minMaxDp),
              // T2PosTolActual: productData[0].Param2_T2Neg.toFixed(minMaxDp),
              Start_Weight: Number(start).toFixed(baldecimalPoint),
              End_Weight: Number(end).toFixed(baldecimalPoint),
              Weight_Gain: Number(maths.round(gain, wtGainDp)).toFixed(wtGainDp),
              // StdDev: 1,
              // Remark: remark
            },
            {
              where: {
                RepSerNo: RepSerno,
              },
            }
          );
          //If product set on Average 24/08/23 S
          var objSelMenu = globalData.arrSelectedMenu.find((k) => k.Hmi == strHmi);
          // 
          // if (objSelMenu.selectedProductDetail.isonstd == 1 
          // || objSelMenu.selectedProductDetail.isonstd == 0
          // ) {
          var get_Datavalue_final = await models[detailTable].findAll({ where: { RepSerNo: RepSerno } });
          var get_Datavalue1_final = await models[masterTable].findAll({ where: { RepSerNo: RepSerno } });
          var arr_final = [];
          if (objSelMenu.selectedProductDetail.isonstd == 1) {
            objSelMenu.selectedProductDetail.nominal = get_Datavalue1_final[0].AvgWeight;

            // objSelMenu.selectedProductDetail.nominal = get_Datavalue1_final[0].AvgGrpWeight;



            var maxLimitT1_avg = objFormula.upperLimit(objSelMenu.selectedProductDetail, 'T1');
            var maxLimitT2_avg = objFormula.upperLimit(objSelMenu.selectedProductDetail, 'T2');
            var minLimitT2_avg = objFormula.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
            var minLimitT1_avg = objFormula.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

            var DataValue_arr = [];

            get_Datavalue1_final[0].NoOfBelow1 = 0;
            get_Datavalue1_final[0].NoOfAbove1 = 0;
            get_Datavalue1_final[0].NoOfBelow2 = 0;
            get_Datavalue1_final[0].NoOfAbove2 = 0;

            DataValue_arr.push(get_Datavalue_final);
            var arr_final = [];
            for (var j = 0; j < get_Datavalue_final.length; j++) {
              var AB = get_Datavalue_final[j].DataValue;
              arr_final.push(Number(AB));
              console.log(arr_final);
            }
            if (Number(AB) < Number(minLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfBelow2 = Number(get_Datavalue1_final[0].NoOfBelow2) + 1;
            } else if (Number(AB) > Number(maxLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfAbove2 = Number(get_Datavalue1_final[0].NoOfAbove2) + 1;
            }
            if (maxLimitT1_avg != 0 && minLimitT1_avg != 0) {
              if (Number(AB) < Number(minLimitT1_avg) && Number(AB) >= Number(minLimitT2_avg)) {
                get_Datavalue1_final[0].NoOfBelow1 = Number(get_Datavalue1_final[0].NoOfBelow1) + 1;
              } else if (Number(AB) > Number(maxLimitT1_avg) && Number(AB) <= Number(maxLimitT2_avg)) {
                get_Datavalue1_final[0].NoOfAbove1 = Number(get_Datavalue1_final[0].NoOfAbove1) + 1;
              }
            }
          }
          for (var j = 0; j < get_Datavalue_final.length; j++) {
            var AB = get_Datavalue_final[j].DataValue;
            arr_final.push(Number(AB));
            // console.log(arr_final);
          }
          var Nominal_final = objSelMenu.selectedProductDetail.nominal;
          Nominal_final = Number(Nominal_final).toFixed(3);
          var max_value_final = maths.max(arr_final);
          max_value_final = max_value_final.toFixed(baldecimalPoint);
          var min_value_final = maths.min(arr_final);
          min_value_final = min_value_final.toFixed(baldecimalPoint);
          var std_value_final = maths.std(arr_final);
          std_value_final = std_value_final.toFixed(4);
          var total_final = arr_final.reduce((acc, total_final) => {
            return Number(total_final) + Number(acc);
          }, 0)
          var avg_final = total_final / arr_final.length
          avg_final = Number(maths.round(maths.abs(avg_final), 2)).toFixed(2);
          var minPer_value_final = ((Nominal_final - min_value_final) / Nominal_final) * 100;
          minPer_value_final = maths.abs(minPer_value_final).toFixed(2);
          var maxPer_value_final = ((Nominal_final - max_value_final) / Nominal_final) * 100;
          maxPer_value_final = maths.abs(maxPer_value_final).toFixed(2);

          // console.log();
          // console.log(max_value_final, min_value_final, std_value_final, avg_final, minPer_value_final, maxPer_value_final);
          // return arr;

          minLimitT2 = (Math.round(minLimitT2 * 1000) / 1000);
          maxLimitT2 = (Math.round(maxLimitT2 * 1000) / 1000);

          var master_update = await models[masterTable].update({
            AvgValue: avg_final,
            MinValue: min_value_final,
            MaxValue: max_value_final,
            MinPer: minPer_value_final,
            MaxPer: maxPer_value_final,
            NoOfAbove1: get_Datavalue1_final[0].NoOfAbove1,
            NoOfAbove2: get_Datavalue1_final[0].NoOfAbove2,
            NoOfBelow1: get_Datavalue1_final[0].NoOfBelow1,
            NoOfBelow2: get_Datavalue1_final[0].NoOfBelow2,
            Nom: Number(menuDetail.nominal).toFixed(baldecimalPoint),
            T1NegTol: Number(minLimitT1_avg).toFixed(baldecimalPoint),
            T1PosTol: Number(maxLimitT1_avg).toFixed(baldecimalPoint),
            T2NegTol: (Number(minLimitT2)).toFixed(baldecimalPoint),
            T2PosTol: (Number(maxLimitT2)).toFixed(baldecimalPoint),
            // T2NegTol: Number(minLimitT2_avg).toFixed(baldecimalPoint),
            // T2PosTol: Number(maxLimitT2_avg).toFixed(baldecimalPoint),
            T2NegTolActual: productData[0].Param2_T2Neg.toFixed(minMaxDp),
            T2PosTolActual: productData[0].Param2_T2Pos.toFixed(minMaxDp),
            StdDev: std_value_final,
            // Remark: remark
          }, { where: { RepSerNo: RepSerno } });
          // }
          // }        
          // }
          //END 24/08/23
          const resCubUpdate = models.tbl_cubical.update(
            {
              Sys_Validation: 0,
            },
            {
              where: {
                Sys_rpi: cubicalObj.Sys_rpi,

              },
            }
          );
          //mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${1}:${actualWt} ${protocolUnit}`);
          let hmiEntryinConfig = globalData.arrConfigSettings.find((k) => k.Hmi == strHmi).configSetting;

          let autoTare = hmiEntryinConfig[0].AutoTare;

          let tareCommand = hmiEntryinConfig[0].Tare_Command.concat(`\r\n`);

          let sampleNo = 1;
          let limitObjResp = await objCommonUseFunc.SendCommon({
            strHmi,
            actualWt,
            minLimitT2,
            maxLimitT2,
            minLimitT1,
            maxLimitT1,
            strMenuName,
            sampleNo,
          });
          let color = limitObjResp.Color;
          let limit = limitObjResp.limit;
          if (limit.includes("out") || limit.includes("Below") || limit.includes("Above")) {
            reportLimitMsg = "Report Out Of Limit"
          }
          else {
            reportLimitMsg = "Report Within Limit"
          }

          mqttSender.sendData(
            strHmi,
            `${mqttProtocol.DisplayResult}${1}:${Number(actualWt).toFixed(baldecimalPoint)} ${protocolUnit}:${color}`);

          await objMonit.monit({
            case: 'TestWeight', Hmi: strHmi, data: {
              Weight: `${actualWt} ${(protocolUnit).toLowerCase()}`, srNo: "", message: `${limit}`
            }
          });

          if (autoTare) {
            mqttSender.sendData(
              strHmi,
              `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
            );
          }

          // mqttSender.sendData(strHmi, limit);
        }
      } else {

        minLimitT2 = (Math.round(minLimitT2 * 1000) / 1000);
        maxLimitT2 = (Math.round(maxLimitT2 * 1000) / 1000);

        const masterCompleteData = {
          MstSerNo: intMstSerNo,
          // InstruId: 1,
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          ProductType: menuDetail.ProductType,
          Qty: 0,
          GrpQty: sample,
          GrpFreq: 0,
          Idsno: currentCubical.Sys_IDSNo,
          CubicalNo: currentCubical.Sys_CubicNo,
          Department: currentCubical.Sys_dept,
          BalanceId: currentCubical.Sys_BalID,
          VernierId: currentCubical.Sys_VernierID,
          BatchNo: currentCubical.Sys_Batch,
          UserId: productDetail.userId,
          UserName: productDetail.userName,
          PrDate: momentObj().format("YYYY-MM-DD"),
          PrTime: momentObj().format("HH:mm:ss"),
          Side: side,
          Unit: protocolUnit,
          DecimalPoint: decimalPoint,
          MinGrpWeight: Number(actualWt).toFixed(baldecimalPoint),//Number(min_value).toFixed(decimalPoint),
          MaxGrpWeight: Number(actualWt).toFixed(baldecimalPoint),//Number(max_value).toFixed(decimalPoint),
          MinWeight: Number(actualWt).toFixed(baldecimalPoint),//Number(avg_min).toFixed(decimalPoint),
          MaxWeight: Number(actualWt).toFixed(baldecimalPoint),//Number(avg_max).toFixed(decimalPoint),
          AvgGrpWeight: Number(maths.round(((Number(actualWt) / Number(1))), 4)).toFixed(4), //mathj.round(((totalGrp) / (totalRecNo)), 1).toFixed(decimalPoint)
          AvgWeight: Number(maths.round(((Number(actualWt) / Number(1))), 4)).toFixed(4),
          PrEndDate: momentObj().format("YYYY-MM-DD"),
          PrEndTime: momentObj().format("HH:mm:ss"),
          Start_Weight: Number(actualWt).toFixed(baldecimalPoint),
          End_Weight: Number(actualWt).toFixed(baldecimalPoint),
          StdDev: actualWt,
          Weight_Gain: Number('0').toFixed(baldecimalPoint),
          NoOfBelow1: nob1 != undefined ? nob1 : 0,
          NoOfAbove1: noa1 != undefined ? noa1 : 0,
          NoOfBelow2: nob2 != undefined ? nob2 : 0,
          NoOfAbove2: noa2 != undefined ? noa2 : 0,
          WgmtModeNo: typeValue,
          Nom: Number(menuDetail.nominal).toFixed(baldecimalPoint),
          T1NegTol: Number(minLimitT1).toFixed(baldecimalPoint) == 0 ? 0 : Number(minLimitT1).toFixed(baldecimalPoint),
          T1PosTol: Number(maxLimitT1).toFixed(baldecimalPoint) == 0 ? 0 : Number(maxLimitT1).toFixed(baldecimalPoint),
          T2NegTol: (Number(minLimitT2)).toFixed(baldecimalPoint),
          T2PosTol: (Number(maxLimitT2)).toFixed(baldecimalPoint),
          T2NegTolActual: productData[0].Param2_T2Neg.toFixed(minMaxDp),
          T2PosTolActual: productData[0].Param2_T2Pos.toFixed(minMaxDp),
          // T2NegTolActual: [`${Number(minLimitT2).toFixed(decimalPoint)}`] + [`(-${productData[0].Param2_T2Neg.toFixed(2)}%)`],
          // T2PosTolActual: [`${Number(maxLimitT2).toFixed(3)}`] + [`(+${productData[0].Param2_T2Neg.toFixed(2)}%)`],
          LimitOn: menuDetail.LimitOn,
          CubicleType: currentCubical.Sys_CubType,
          IPQCType: currentCubical.Sys_IPQCType,
          ReportType: currentCubical.Sys_RptType,
          // RepoLabel10: currentCubical.Sys_IPQCType,
          MachineCode: currentCubical.Sys_MachineCode,
          // MFGCode: currentCubical.Sys_MfgCode,
          BatchSize: currentCubical.Sys_BatchSize,
          FriabilityID: currentCubical.Sys_FriabID,
          HardnessID: currentCubical.Sys_HardID,
          CubicleName: currentCubical.Sys_CubicName,
          // CubicleLocation: currentCubical.Sys_dept,
          Layer: "NA",
          PrintNo: 0,
          IsArchived: 0,
          GraphType: "0",
          BatchComplete: 0,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          Lot: dataObj.GroupDetail.data.lotno,
          Area: cubicalObj.Sys_Area,
          SideNo: 1,
          Stage: currentCubical.Sys_Stage,
        };

        if (strMenuName == GLOBAL_NOMENCLATURE.GroupMenu) {
          // masterCompleteData.data.push({ str_colName: 'IsPrintable', value: 0 });
          Object.assign(masterCompleteData, { IsPrintable: 0 });
        }
        // let resultincomplete = await database.save(masterCompleteData);

        let resultincomplete = await models[masterTable].create(
          masterCompleteData
        );

        var lastInsertedID = resultincomplete.RepSerNo;

        // if (cubicalObj.Sys_RotaryType == 'Double') {
        //   side = "LHS";
        // }
        const insertIncompleteDetailObj = {
          RepSerNo: lastInsertedID,
          MstSerNo: intMstSerNo,
          RecSeqNo: 1,//1,
          LotNo: lotNo,
          WeightGain:  Number('0').toFixed(baldecimalPoint),
          DataValue: Number(actualWt).toFixed(baldecimalPoint),
          NoOfSample: productDetail.noOfSample,
          BatchNo: cubicalObj.Sys_Batch,
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: productDetail.ProductName,
          UserId: productDetail.userId,
          UserName: productDetail.userName,
          PrDate: momentObj().format("YYYY-MM-DD"),
          PrTime: momentObj().format("HH:mm:ss"),
          Side: side == 'NA' ? 'Single' : side,
          DecimalPoint: decimalPoint,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          // AvgWeight: (Number(actualWt)).toFixed(4),
          // Deviation: (((Number(Nominal) - Number(actualWt)) / Number(Nominal)) * 100).toFixed(4),
          Remark: remark,
          InstrumentID: InstrumentId,
          // IPC_Code: productDetail.ipccode
        };

        //await database.save(insertIncompleteDetailObj);
        await models[detailTable].create(
          insertIncompleteDetailObj
        );

        //If product set on Average 24/08/23 S
        var objSelMenu = globalData.arrSelectedMenu.find((k) => k.Hmi == strHmi);

        // if (objSelMenu.selectedProductDetail.isonstd == 1) {
        var get_Datavalue_final = await models[detailTable].findAll({ where: { RepSerNo: lastInsertedID } });
        var get_Datavalue1_final = await models[masterTable].findAll({ where: { RepSerNo: lastInsertedID } });
        var arr_final = [];
        if (objSelMenu.selectedProductDetail.isonstd == 1) {
          objSelMenu.selectedProductDetail.nominal = get_Datavalue1_final[0].AvgWeight;
          // }


          var maxLimitT1_avg = objFormula.upperLimit(objSelMenu.selectedProductDetail, 'T1');
          var maxLimitT2_avg = objFormula.upperLimit(objSelMenu.selectedProductDetail, 'T2');
          var minLimitT2_avg = objFormula.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
          var minLimitT1_avg = objFormula.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

          var DataValue_arr = [];

          get_Datavalue1_final[0].NoOfBelow1 = 0;
          get_Datavalue1_final[0].NoOfAbove1 = 0;
          get_Datavalue1_final[0].NoOfBelow2 = 0;
          get_Datavalue1_final[0].NoOfAbove2 = 0;

          DataValue_arr.push(get_Datavalue_final);
          var arr_final = [];
          for (var j = 0; j < get_Datavalue_final.length; j++) {
            var AB = get_Datavalue_final[j].DataValue;
            arr_final.push(Number(AB));
            console.log(arr_final);
          }
          if (Number(AB) < Number(minLimitT2_avg)) {
            get_Datavalue1_final[0].NoOfBelow2 = Number(get_Datavalue1_final[0].NoOfBelow2) + 1;
          } else if (Number(AB) > Number(maxLimitT2_avg)) {
            get_Datavalue1_final[0].NoOfAbove2 = Number(get_Datavalue1_final[0].NoOfAbove2) + 1;
          }
          if (maxLimitT1_avg != 0 && minLimitT1_avg != 0) {
            if (Number(AB) < Number(minLimitT1_avg) && Number(AB) >= Number(minLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfBelow1 = Number(get_Datavalue1_final[0].NoOfBelow1) + 1;
            } else if (Number(AB) > Number(maxLimitT1_avg) && Number(AB) <= Number(maxLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfAbove1 = Number(get_Datavalue1_final[0].NoOfAbove1) + 1;
            }
          }
        }
        for (var j = 0; j < get_Datavalue_final.length; j++) {
          var AB = get_Datavalue_final[j].DataValue;
          arr_final.push(Number(AB));
          console.log(arr_final);
        }
        var Nominal_final = objSelMenu.selectedProductDetail.nominal;
        Nominal_final = Number(Nominal_final).toFixed(baldecimalPoint);

        var max_value_final = maths.max(arr_final);
        max_value_final = max_value_final.toFixed(baldecimalPoint);
        var min_value_final = maths.min(arr_final);
        min_value_final = min_value_final.toFixed(baldecimalPoint);
        var std_value_final = maths.std(arr_final);
        std_value_final = std_value_final.toFixed(4);
        var total_final = arr_final.reduce((acc, total_final) => {
          return Number(total_final) + Number(acc);
        }, 0)
        var avg_final = total_final / arr_final.length
        avg_final = maths.abs(avg_final).toFixed(4);
        var minPer_value_final = ((Nominal_final - min_value_final) / Nominal_final) * 100;
        minPer_value_final = maths.abs(minPer_value_final).toFixed(2);
        var maxPer_value_final = ((Nominal_final - max_value_final) / Nominal_final) * 100;
        maxPer_value_final = maths.abs(maxPer_value_final).toFixed(2);

        // console.log();
        // console.log(max_value_final, min_value_final, std_value_final, avg_final, minPer_value_final, maxPer_value_final);
        // return arr;
        // comment decimal for balance DP.
        // baldecimalPoint = menuDetail.LimitOn == 0 ? baldecimalPoint : 2;

        // minLimitT2= (Math.ceil(minLimitT2 * 1000) / 1000).toFixed(baldecimalPoint);
        minLimitT2 = (Math.round(minLimitT2 * 1000) / 1000);
        maxLimitT2 = (Math.round(maxLimitT2 * 1000) / 1000);

        var master_update = await models[masterTable].update({
          AvgValue: Number(maths.round(avg_final, 4)),
          MinValue: min_value_final,
          MaxValue: max_value_final,
          MinPer: minPer_value_final,
          MaxPer: maxPer_value_final,
          StdDev: std_value_final,
          NoOfAbove1: get_Datavalue1_final[0].NoOfAbove1,
          NoOfAbove2: get_Datavalue1_final[0].NoOfAbove2,
          NoOfBelow1: get_Datavalue1_final[0].NoOfBelow1,
          NoOfBelow2: get_Datavalue1_final[0].NoOfBelow2,
          T1NegTol: Number(minLimitT1_avg).toFixed(baldecimalPoint),
          T1PosTol: Number(maxLimitT1_avg).toFixed(baldecimalPoint),
          T2NegTol: (Number(minLimitT2)).toFixed(baldecimalPoint),
          T2PosTol: (Number(maxLimitT2)).toFixed(baldecimalPoint),
          T2NegTolActual: productData[0].Param2_T2Neg.toFixed(minMaxDp),
          T2PosTolActual: productData[0].Param2_T2Pos.toFixed(minMaxDp),
          Remark: remark
        }, { where: { RepSerNo: lastInsertedID } });
        // }

        // }   // }
        //END 24/08/23

        let upValidationRes = await models.tbl_cubical.update(
          {
            Sys_Validation: 0,
          },
          {
            where: {
              Sys_rpi: cubicalObj.Sys_rpi
            },
          }
        );

        //mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${1}:${actualWt} ${protocolUnit}`);
        let hmiEntryinConfig = globalData.arrConfigSettings.find((k) => k.Hmi == strHmi).configSetting;
        let autoTare = hmiEntryinConfig[0].AutoTare;
        let tareCommand = hmiEntryinConfig[0].Tare_Command.concat(`\r\n`);
        let sampleNo = 1;
        let limitObjResp = await objCommonUseFunc.SendCommon({
          strHmi,
          actualWt,
          minLimitT2,
          maxLimitT2,
          minLimitT1,
          maxLimitT1,
          strMenuName,
          sampleNo,
        });
        let color = limitObjResp.Color;
        let limit = limitObjResp.limit;
        if (limit.includes("out") || limit.includes("Below") || limit.includes("Above")) {
          reportLimitMsg = "Report Out Of Limit"
        }
        else {
          reportLimitMsg = "Report Within Limit"
        }

        mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayResult}${1}:${Number(
            actualWt
          ).toFixed(baldecimalPoint)} ${protocolUnit}:${color}`
        );

        if (autoTare) {
          mqttSender.sendData(
            strHmi,
            `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
          );
        }

        // mqttSender.sendData(strHmi, limit);
      }

      //for remark updation
      var remarkData = await models[masterTable].findAll({
        where: {
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          BatchNo: cubicalObj.Sys_Batch,
          Area: cubicalObj.Sys_Area,
          // Side: side,
          ReportType: cubicalObj.Sys_RptType
        }
      });

      if (remarkData[0].Remark == null || (remarkData[0].Remark != "Not Complies" && remarkData[0].Remark != remark)) {
        var remarkupdate = await models[masterTable].update({
          Remark: remark
        }, { where: { RepSerNo: remarkData[0].RepSerNo, ReportType: cubicalObj.Sys_RptType } });
      }

      const SampleRemark = globalData.arrSampleRemarkForAllTest.find(
        (k) => k.Hmi == strHmi
      );
      if (remark == 'Not Complies') {
        // remark = 'Not Complies';
        globalData.arrSampleRemarkForAllTest.push({
          "Hmi": strHmi,
          "OutOfRemark": true
        });
        // SampleRemark.OutOfRemark = true
      } else {
        // remark = 'Complies';
        globalData.arrSampleRemarkForAllTest.push({
          "Hmi": strHmi,
          "OutOfRemark": false
        });
      }

      var act = `${strMenuName} Weighment Completed on TSH ${strHmi}`
      if (side == 'LHS') {
        var act = `${strMenuName} Weighment Completed on TSH ${strHmi} for side LHS`
      } else if (side == 'RHS') {
        var act = `${strMenuName} Weighment Completed on TSH ${strHmi} for side RHS`
      }

      //instrument usage and activity log
      __activityObj = {
        strUserId: tempUserObject.UserId,
        strUserName: tempUserObject.UserName,
        activity: act,
      };

      await objActivityLog.ActivityLogEntry(__activityObj);

      await objInstrumentUsage.InstrumentUsage(
        "Balance",
        strIdsNo,
        "tbl_instrumentlog_balance",
        strMenuName,
        "completed"
      );
      //Batch Summary added get_Datavalue[0];
      // var result = {
      //   completeTableName: masterTable,
      //   detailData: get_Datavalue,
      //   detailTableName: detailTable,
      //   incompleteData: get_Datavalue1[0],
      //   incompletedetailTableName: detailTable,
      //   incompleteTableName: masterTable,
      // }
      // await objBatchSummary.saveGroupBatchData(result, typeValue, strHmi, strIdsNo, masterTable, remark);
      globalData.arrOutFlagForTest.findIndex(
        (element) => element.Hmi === strHmi
      ) == -1
        ? globalData.arrOutFlagForTest
        : globalData.arrOutFlagForTest.splice(
          globalData.arrOutFlagForTest.findIndex(
            (element) => element.Hmi === strHmi
          ),
          1
        );

      globalData.arrSelectedMenu.findIndex(
        (element) => element.Hmi === strHmi
      ) == -1
        ? globalData.arrSelectedMenu
        : globalData.arrSelectedMenu.splice(
          globalData.arrSelectedMenu.findIndex(
            (element) => element.Hmi === strHmi
          ),
          1
        );

      globalData.arrWeighmentCounter.findIndex(
        (element) => element.Hmi === strHmi
      ) == -1
        ? globalData.arrWeighmentCounter
        : globalData.arrWeighmentCounter.splice(
          globalData.arrWeighmentCounter.findIndex(
            (element) => element.Hmi === strHmi
          ),
          1
        );

      globalData.arrSampleRemarkForAllTest.findIndex(
        (element) => element.Hmi === strHmi
      ) == -1
        ? globalData.arrSampleRemarkForAllTest
        : globalData.arrSampleRemarkForAllTest.splice(
          globalData.arrSampleRemarkForAllTest.findIndex(
            (element) => element.Hmi === strHmi
          ),
          1
        );

      await objMonit.monit({
        case: 'ReportStatus',
        Hmi: strHmi,
        data: {
          message: reportLimitMsg
        }
      });
      // mqttSender.sendData(strHmi, reportLimitMsg);
      mqttSender.sendData(strHmi, `${GLOBAL_NOMENCLATURE.TestCompleted} ${reportLimitMsg}`);//Report within / Outoflimit       
      // mqttSender.sendData(
      //   strHmi,
      //   `${mqttProtocol.TestCompleted}${strMenuName} Test is Completed`
      // );

      return
    } catch (error) {
      throw new Error(error);
    }
  }

  async calculateSeqNo(dataObj) {
    try {
      const masterTableName = dataObj.masterTable;
      const detailTableName = dataObj.detailTable;
      let side = dataObj.side;

      // if (side == 'LHS' || side == 'RHS') { //10/10/23
      //   side = "LHS"
      // }

      let selectRes = await models[masterTableName].max("RepSerNo", {
        where: {
          BFGCode: dataObj.BFGCode,
          ProductName: dataObj.ProductName,
          PVersion: dataObj.PVersion,
          Version: dataObj.Version,
          BatchNo: dataObj.BatchNo,
          Side: side,
          ReportType: dataObj.ReportType,
        },
      });

      side = dataObj.side;
      if (side != 'RHS') {
        if (!selectRes) {
          return 1;
        } else {
          let reqSeqRes = await models[detailTableName].max("RecSeqNo", {
            where: {
              RepSerNo: selectRes,
              Side: side == 'NA' ? 'Single' : side,
            },
          });

          if (!reqSeqRes) {
            return 1;
          } else {
            return reqSeqRes + 1;
          }
        }
      } else {
        let RHSRes = await models[masterTableName].max("RepSerNo", {
          where: {
            BFGCode: dataObj.BFGCode,
            ProductName: dataObj.ProductName,
            PVersion: dataObj.PVersion,
            Version: dataObj.Version,
            BatchNo: dataObj.BatchNo,
            Side: 'LHS',
            ReportType: dataObj.ReportType,
          },
        });
        let RHSSeqRes = await models[detailTableName].max("RecSeqNo", {
          where: {
            RepSerNo: RHSRes,
            Side: side == 'NA' ? 'Single' : side,
          },
        });

        if (!RHSSeqRes) {
          return 1;
        } else {
          return RHSSeqRes + 1;
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }
}
module.exports = Group;
