const moment = require('moment')
const date = require('date-and-time');
const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const clsformulaFun = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const clsBatchSummary = require('../Product/clsBatchSummaryOperation');
const clsMonit = require('../MonitorSocket/clsMonitSocket');
const clsPrintOperations = require("../Print/clsPrintOperation")
const sequelize = require('../../../config/dbConnection').sequelize
const models = require('../../../config/dbConnection').models;
const printOperations = new clsPrintOperations()
const objMonit = new clsMonit()
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new clsformulaFun();
const { QueryTypes } = require('sequelize');
const dbcon = require('../../global/dbCon');
// const { models } = require('../../../config/dbConnection');
const objBatchSummary = new clsBatchSummary();

class DTModel {

    async processDTData(dataObj) {
        try {
            const strHmi = dataObj.Hmi;
            const strIdsNo = dataObj.idsNo;
            let actualWt = dataObj.actualWt;
            var menuName1 = dataObj.menuName;
            let minLimitT2, maxLimitT2, maxLimitT1, minLimitT1, typeValue, strTableName, strDetailTbl, layer, layer_name, actucaltime;
            let objActivity = {};
            const DTDetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
            const layer_label_2 = globalData.arrProductTypeArray.find(k => k.idsNo == strIdsNo);
            var runtimeActual = layer_label_2.productDetail[0][0]
            var layerlabel = layer_label_2.productType
            const intProductType = objSelMenu.selectedProductDetail.ProductType
            let batchNo = DTDetail.data.Batch;
            let sample = DTDetail.data.noOfSample;
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            var side = DTDetail.data.Side

            let productType = layerlabel.ProductType;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
            if (IPQCObject != undefined) {
                var selectedIdsNo = IPQCObject.selectedIds;
            } else {
                var selectedIdsNo = strIdsNo;
            }

            switch (menuName1) {
                case mqttProtocol.DT: {
                    if (productType == 1) {
                        strTableName = "tbl_tab_master13"
                        strDetailTbl = "tbl_tab_detail13"
                        typeValue = 13
                    } else {
                        strTableName = "tbl_cap_master6"
                        strDetailTbl = "tbl_cap_detail6"
                        typeValue = 6
                    }

                    layer = 'NA',
                        layer_name = 'NA'
                    actucaltime = objSelMenu.selectedProductDetail.nominal
                    minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1')
                    maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1')
                    maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail)
                    minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail)
                }
                    break
                case mqttProtocol.DTLayer1Menu: {
                    strTableName = "tbl_tab_master19"
                    strDetailTbl = "tbl_tab_detail19"
                    typeValue = 19
                    layer = 'Layer 1'
                    layer_name = layerlabel.IsBilayerLbl
                    actucaltime = objSelMenu.selectedProductDetail.nominal
                    maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1')
                    maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail)
                    minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail)
                    minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1')
                }
                    break

                case mqttProtocol.DTLayer2Menu: {
                    strTableName = "tbl_tab_master20"
                    strDetailTbl = "tbl_tab_detail20"
                    typeValue = 20
                    layer = 'Layer 2'
                    layer_name = layerlabel.IsTrilayerLbl
                    actucaltime = objSelMenu.selectedProductDetail.nominal
                    minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1')
                    maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1')
                    maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail)
                    minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail)
                }
                    break
            }

            const __parameterDT = {
                strTableName: strTableName,
                strDetailTbl: strDetailTbl,
                detailTable: strDetailTbl,
                objProductDetails: DTDetail.data,
                uniqueSerialNumber: strIdsNo,
                strBalId: objSelMenu.instrumentId,
                ProtocolData: dataObj.actualWt,
                actucaltime: actucaltime,
                typeValue: typeValue,
                menuName: menuName1,
                layer: layer,
                layer_name: layer_name,
                // ProtocolUnit: dataObj.unit,
                // ProtocolDecPoint: dataObj.decPoint,
                strHmi: strHmi,
                // seqNoOfWt: counter,
                productType: objSelMenu.selectedProductDetail
            }

            // if (counter == 1) {

            Object.assign(objActivity,
                { strUserId: tempUserObject.UserId },
                { strUserName: tempUserObject.UserName },
                { activity: side == 'NA' ? 'DT Weighment Started on TSH ' + strHmi : 'DT Weighment Started on TSH ' + strHmi + ' ' + 'for' + ' ' + side })
            var startTimee = __parameterDT.ProtocolData.start_time_Jar_A == 'N.A.' ? __parameterDT.ProtocolData.start_time_Jar_B : __parameterDT.ProtocolData.start_time_Jar_A;
            if (startTimee == undefined) {
                var startTimee = __parameterDT.ProtocolData.startTime
            }
            await objActivityLog.ActivityLogEntry(objActivity, startTimee);

            await objInstrumentUsage.InstrumentUsage('DT', strIdsNo, 'tbl_instrumentlog_dt', 'DT', 'started', startTimee);

            if (dataObj.model.includes("Labindia")) {
                var weighmentDetail = await this.insert_DT_Data_for_LABIndia(__parameterDT);
                // } else if (dataObj.model.Eqp_Make == 'Electrolab') {
                //     var weighmentDetail = await this.insert_DT_Data_for_EDI_2SA(__parameterDT);
            }
            else if (dataObj.model == "Electrolab-ED3POX") {
                var weighmentDetail = await this.insert_DT_Data_for_ElectroLabED3PO(__parameterDT);
            } else if (dataObj.model == "ED-2 SAPOX") {
                var a = await this.insert_DT_Data(__parameterDT);

            } else if (dataObj.model == "EDI-2SA") {
                var a = await this.insert_DT_Data(__parameterDT);

            } else {
                console.log('unkown dt model')
                return
            }
            if (weighmentDetail == 'Invalid String recieved') {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
            }

            Object.assign(objActivity,
                { strUserId: tempUserObject.UserId },
                { strUserName: tempUserObject.UserName },
                { activity: side == 'NA' ? 'DT Weighment Completed on TSH ' + strHmi : 'DT Weighment Completed on TSH ' + strHmi + ' ' + 'for' + ' ' + side });
            var cubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData
            var sidee = cubicInfo.Sys_RotaryType == "Double" ? "LHS" : __parameterDT.objProductDetails.Side
            // var masterInfo = await models['tbl_tab_master13'].findAll({
            //     attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
            // },
            //     {
            //         where: {
            //             BFGCode: cubicInfo.Sys_BFGCode,
            //             ProductName: cubicInfo.Sys_ProductName,
            //             PVersion: cubicInfo.Sys_PVersion,
            //             Version: cubicInfo.Sys_Version,
            //             Side: sidee,
            //             CubicleType: cubicInfo.Sys_CubType,
            //             BatchNo: cubicInfo.Sys_Batch,
            //         }
            //     })
            // var endTimee = await models['tbl_tab_detail13'].findAll({
            //     where: {
            //         RepSerNo: masterInfo[0].RepSerNo,
            //     }
            // })
            // var i = endTimee.length-1;
            // endTimee = endTimee[i].DT_EndTm;
            var endTimee;
            if (a.Rhs != undefined && a.Lhs != undefined) {
                let aMax = a.Lhs.sort();
                aMax = aMax[aMax.length - 1];
                let endTmSS = moment(__parameterDT.ProtocolData.start_time_Jar_A, "HH:mm:ss").add(aMax.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                let endTmMM = moment(endTmSS, "HH:mm:ss").add(aMax.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                let lhsEndTimee = moment(endTmMM, "HH:mm:ss").add(aMax.trim().split(":")[0], 'hours').format("HH:mm:ss");


                let bMax = a.Rhs.sort();
                bMax = bMax[bMax.length - 1];
                let rendTmSS = moment(__parameterDT.ProtocolData.start_time_Jar_B, "HH:mm:ss").add(bMax.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                let rendTmMM = moment(rendTmSS, "HH:mm:ss").add(bMax.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                let rhsEndTimee = moment(rendTmMM, "HH:mm:ss").add(bMax.trim().split(":")[0], 'hours').format("HH:mm:ss");

                endTimee = lhsEndTimee < rhsEndTimee ? rhsEndTimee : lhsEndTimee;
            }
            else if (a.Lhs != undefined) {
                a = a.Lhs.sort();
                endTimee = a[a.length - 1];
                let endTmSS = moment(startTimee, "HH:mm:ss").add(endTimee.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                let endTmMM = moment(endTmSS, "HH:mm:ss").add(endTimee.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                endTimee = moment(endTmMM, "HH:mm:ss").add(endTimee.trim().split(":")[0], 'hours').format("HH:mm:ss");
            } else if (a.Rhs != undefined) {
                a = a.Rhs.sort();
                endTimee = a[a.length - 1];
                let endTmSS = moment(startTimee, "HH:mm:ss").add(endTimee.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                let endTmMM = moment(endTmSS, "HH:mm:ss").add(endTimee.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                endTimee = moment(endTmMM, "HH:mm:ss").add(endTimee.trim().split(":")[0], 'hours').format("HH:mm:ss");
            }

            await objActivityLog.ActivityLogEntry(objActivity, endTimee);

            await objInstrumentUsage.InstrumentUsage('DT', strIdsNo, 'tbl_instrumentlog_dt', 'DT', 'completed', endTimee);

            (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ?
                globalData.arrCurrentOperationStatus :
                globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);

            //test splice if rotarty is not double
            globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                globalData.arrSelectedMenu :
                globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);


            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${JSON.stringify(a.le)}`)
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${weighmentDetail.le}`)

            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Test Completed`);
            return 0
        } catch (error) {
            throw new Error(error);
        }
    }
    // async insert_DT_Data(dataObj) {
    //     try {
    //         const strTableName = dataObj.strTableName;
    //         const strIdsNo = dataObj.uniqueSerialNumber;
    //         const strHmi = dataObj.strHmi;
    //         const now = new Date();
    //         let jar_A_Arr = [];
    //         let jar_B_Arr = [];
    //         let minTemp, maxTemp, BminTemp, BmaxTemp , startTime, endTime, haltDuration, side,SetTemp,SetTempB;
    //         let objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
    //         const objProductDetails = objSelMenu.selectedProductDetail;
    //         const DTId = dataObj.strBalId;
    //         const ProtocolData = dataObj.ProtocolData;
    //         const ProtocolUnit = dataObj.ProtocolUnit;
    //         const ProtocolDecPoint = dataObj.ProtocolDecPoint;
    //         const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
    //         const intNominal = dataObj.objProductDetails.Nominal;
    //         var startTimedfromOBJ = dataObj.objProductDetails.Time;
    //         startTimedfromOBJ = moment().format(startTimedfromOBJ, ' hh:mm:ss ');
    //         var startDatefromOBJ = dataObj.objProductDetails.Date;
    //         startDatefromOBJ = moment().format('YYYY-MM-D', startDatefromOBJ);
    //         let jarType, endDate;
    //         if (dataObj.objProductDetails.Rotary == "Single") {
    //             side = "NA";
    //             jarType = dataObj.objProductDetails.Side.trim()
    //                 .charAt(dataObj.objProductDetails.Side.length - 1)
    //         } else if (dataObj.objProductDetails.Rotary == "Double") {
    //             side = "LHS/RHS";
    //             jarType = "N";
    //         }
    //         // if(dataObj.objProductDetails.Rotary == 'Single'){
    //         //     if(ProtocolData.Jar_A_maxTemp  != undefined  && jarType == 'B'){
    //         //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //         //     }
    //         //         if(ProtocolData.Jar_B_maxTemp  != undefined && jarType == 'A'){
    //         //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //         // }
    //         // }
    //         // if(dataObj.objProductDetails.Rotary == 'Double'){
    //         //     if(ProtocolData.start_time_Jar_A  == 'N.A' && ProtocolData.start_time_Jar_B == 'N.A' && jarType != 'N'){
    //         //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //         //     }
    //         // }


    //         let i = 1;
    //         for (let obj in ProtocolData) {
    //             if (ProtocolData.hasOwnProperty(`${i}_SampleLHS`)) {
    //                 if (ProtocolData[`${i}_SampleLHS`] !== "") {
    //                     jar_A_Arr.push(ProtocolData[`${i}_SampleLHS`])
    //                 }
    //                 if (ProtocolData.hasOwnProperty(`${i}_SampleRHS`)) {
    //                     if (ProtocolData[`${i}_SampleRHS`] !== "") {
    //                         jar_B_Arr.push(ProtocolData[`${i}_SampleRHS`])
    //                     }
    //                 }
    //                 i++;
    //             }
    //         }

    //         let obj = {
    //             mainData: ProtocolData,
    //             Lhs: jar_A_Arr,
    //             Rhs: jar_B_Arr
    //         }
    //         if (dataObj.objProductDetails.Rotary == "Single") {
    //             if (jarType == "A") {
    //                 obj = {
    //                     Lhs: jar_A_Arr,
    //                 }
    //             } else if (jarType == "B") {
    //                 obj = {
    //                     Rhs: jar_B_Arr,
    //                 }
    //             }
    //         }
    //         const regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
    //         let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
    //         let startDate = dataObj.ProtocolData.Start_Date;
    //         startDate = startDate.split("/").reverse().join("-");
    //         let arrProductType = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
    //         let productDetail = arrProductType.productType;
    //         let remark = " ";
    //         let paramDetails = arrProductType.productDetail;
    //         paramDetails = paramDetails[0][0]
    //         let le = "Report generated is Within limit";

    //         //dynamically take from android
    //         let actualRunTime = productDetail.ProductType == 1 ? paramDetails.Param13_Nom : paramDetails.Param6_Nom;
    //         let completeTable = productDetail.ProductType == 1 ? 'tbl_tab_master13' : 'tbl_cap_master6';
    //         let detailTable = productDetail.ProductType == 1 ? 'tbl_tab_detail13' : 'tbl_cap_detail6';
    //         if (dataObj.objProductDetails.Rotary == 'Single') {
    //             if (jarType == "A") {
    //                 minTemp = dataObj.ProtocolData.Jar_A_minTemp;
    //                 maxTemp = dataObj.ProtocolData.Jar_A_maxTemp;
    //                 startTime = dataObj.ProtocolData.start_time_Jar_A;
    //                 endTime = dataObj.ProtocolData.end_time_Jar_A;
    //                 haltDuration = dataObj.ProtocolData.HALT_DUR_JAR_A;
    //                 SetTemp = dataObj.ProtocolData.SetTempA;
    //             } else if (jarType == "B") {
    //                 minTemp = dataObj.ProtocolData.Jar_B_minTemp;
    //                 maxTemp = dataObj.ProtocolData.Jar_B_maxTemp;
    //                 startTime = dataObj.ProtocolData.start_time_Jar_B;
    //                 endTime = dataObj.ProtocolData.end_time_Jar_B;
    //                 haltDuration = dataObj.ProtocolData.HALT_DUR_JAR_B;
    //                 SetTemp = dataObj.ProtocolData.SetTempB;
    //             }
    //         } else {
    //             minTemp = dataObj.ProtocolData.Jar_A_minTemp;
    //             maxTemp = dataObj.ProtocolData.Jar_A_maxTemp;
    //             BminTemp = dataObj.ProtocolData.Jar_B_minTemp;
    //             BmaxTemp = dataObj.ProtocolData.Jar_B_maxTemp;
    //             startTime = dataObj.ProtocolData.start_time_Jar_A;
    //             endTime = dataObj.ProtocolData.end_time_Jar_B;
    //             haltDuration = dataObj.ProtocolData.HALT_DUR_JAR_A
    //             SetTemp = dataObj.ProtocolData.SetTempA;
    //             SetTempB = dataObj.ProtocolData.SetTempB;
    //         }
    //         let bRepSerNo = await this.getMaxBRepSerNo(dataObj.objProductDetails.ProductName, dataObj.objProductDetails.Batch, strTableName, hmiDetailsInPMenu.Sys_RptType)
    //         // let side = dataObj.objProductDetails.Rotary == "Single" ? 'NA' : "LHS/RHS"
    //         const insertObj = await models[strTableName].create({
    //             'MstSerNo': 1,
    //             'InstruId': 1,
    //             'BFGCode': dataObj.objProductDetails.ProductId,
    //             'ProductName': dataObj.objProductDetails.ProductName,
    //             'ProductType': objProductDetails.ProductType,
    //             'Qty': 6,
    //             'GrpQty': 0,
    //             'GrpFreq': 0,
    //             'Idsno': strHmi,
    //             'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
    //             'BalanceId': 0,
    //             'BalanceNo': 0,
    //             //  'VernierId': hmiDetailsInPMenu.Sys_VernierID ,
    //             'VernierNo': 0,
    //             'BatchNo': dataObj.objProductDetails.Batch,
    //             'UserId': dataObj.objProductDetails.userId,
    //             'UserName': dataObj.objProductDetails.userName,
    //             'PrDate': startDatefromOBJ,
    //             'PrTime': startTimedfromOBJ,
    //             'PrEndDate': '1992-12-08',
    //             'PrEndTime': '',
    //             'Side': side == "NA" ? "NA" :"LHS" ,
    //             'Unit': 'C',
    //             'DecimalPoint': '0',
    //             'WgmtModeNo':  productDetail.ProductType == 1 ? "13":"6",
    //             'Nom': intNominal,
    //             'T1NegTol': objProductDetails.T1Neg,
    //             'T1PosTol': objProductDetails.T1Pos,
    //             'MinTemp': minTemp,
    //             'MaxTemp': maxTemp,
    //             'limitOn': 0,
    //             //  'T1NMTTab': objProductDetails.NMT ,
    //             'NomEmpty': 0,
    //             'T1NegEmpty': 0,
    //             'T1PosEmpty': 0,
    //             //  'T2NegEmpty': 0 ,
    //             //  'T2PosEmpty': 0 ,
    //             'NomNet': 0,
    //             'T1NegNet': 0,
    //             'T1PosNet': 0,
    //             //  'T2NegNet': 0 ,
    //             //  'T2PosNet': 0 ,
    //             'CubicleType': hmiDetailsInPMenu.Sys_CubType,
    //             'ReportType': hmiDetailsInPMenu.Sys_RptType,
    //             'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
    //             'Media': hmiDetailsInPMenu.Sys_media,
    //             'MFGCode': hmiDetailsInPMenu.Sys_Stage,
    //             'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
    //             //  'FriabilityID': hmiDetailsInPMenu.Sys_FriabID ,
    //             //  'HardnessID': hmiDetailsInPMenu.Sys_HardID ,
    //             'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
    //             'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
    //             'RepoLabel10': 'Standard',
    //             'RepoLabel11': 0,
    //             'RepoLabel12': 'Null',
    //             'RepoLabel13': 'Null',
    //             'PrintNo': 0,
    //             'IsArchived': 0,
    //             'GraphType': 0,
    //             'BatchComplete': 0,
    //             'PVersion': hmiDetailsInPMenu.Sys_PVersion,
    //             'Version': hmiDetailsInPMenu.Sys_Version,
    //             //  'CheckedByID': objProductDetails.userid ,
    //             //  'CheckedByName': objProductDetails.userName ,
    //             //  'CheckedByDate': date.format(now, 'YYYY-MM-DD') ,
    //             'BRepSerNo': bRepSerNo,
    //             'Lot': hmiDetailsInPMenu.Sys_LotNo,
    //             'Area': hmiDetailsInPMenu.Sys_Area,
    //             // SideNo
    //             'AppearanceDesc':hmiDetailsInPMenu.Sys_Appearance,
    //             'MachineSpeed_Min':hmiDetailsInPMenu.Sys_MachineSpeed_Min,
    //             'MachineSpeed_Max':hmiDetailsInPMenu.Sys_MachineSpeed_Max,
    //             'GenericName' :hmiDetailsInPMenu.Sys_GenericName,
    //             "BMRNo": hmiDetailsInPMenu.Sys_BMRNo,
    //             // IsNMT
    //             // Inprocess
    //             'DTID': DTId,
    //             "DT_Mode":dataObj.ProtocolData.Mode,
    //             'DT_SetTemp': SetTemp,
    //             'DT_Jar': jarType == "N" ? "A" : jarType,
    //             // Uuid
    //             'DT_BasketType': ProtocolData.JarBasket,
    //             'Interval': dataObj.objProductDetails.interval
    //         });
    //         let arrResult = (insertObj);
    //         let lastInsertedID = arrResult.RepSerNo;
    //         // comment undefined object----kai
    //         // const insertObj = {
    //         //     str_tableName: strTableName,
    //         //     data: [
    //         //         { str_colName: 'MstSerNo', value: 0 },
    //         //         { str_colName: 'InstruId', value: 1 },
    //         //         { str_colName: 'BFGCode', value: dataObj.objProductDetails.ProductId },
    //         //         { str_colName: 'ProductName', value: dataObj.objProductDetails.ProductName },
    //         //         { str_colName: 'ProductType', value: objProductDetails.ProductType },
    //         //         { str_colName: 'Qty', value: 6 },
    //         //         { str_colName: 'GrpQty', value: 0 },
    //         //         { str_colName: 'GrpFreq', value: 0 },
    //         //         { str_colName: 'Idsno', value: strIdsNo },
    //         //         { str_colName: 'CubicalNo', value: hmiDetailsInPMenu.Sys_CubicNo },
    //         //         { str_colName: 'BalanceId', value: 0 },
    //         //         { str_colName: 'BalanceNo', value: 0 },
    //         //         // { str_colName: 'VernierId', value: hmiDetailsInPMenu.Sys_VernierID },
    //         //         { str_colName: 'VernierNo', value: 0 },
    //         //         { str_colName: 'BatchNo', value: dataObj.objProductDetails.Batch },
    //         //         { str_colName: 'UserId', value: dataObj.objProductDetails.userid },
    //         //         { str_colName: 'UserName', value: dataObj.objProductDetails.userName },
    //         //         { str_colName: 'PrDate', value: date.format(now, 'YYYY-MM-DD') },
    //         //         { str_colName: 'PrTime', value: date.format(now, 'HH:mm:ss') },
    //         //         { str_colName: 'PrEndDate', value: '1992-12-08' },
    //         //         { str_colName: 'PrEndTime', value: '' },
    //         //         { str_colName: 'Side', value: side },
    //         //         { str_colName: 'Unit', value: '123' },
    //         //         { str_colName: 'DecimalPoint', value: '0' },
    //         //         { str_colName: 'WgmtModeNo', value: 1 },
    //         //         { str_colName: 'Nom', value: intNominal },
    //         //         { str_colName: 'T1NegTol', value: objProductDetails.T1Neg },
    //         //         { str_colName: 'T1PosTol', value: objProductDetails.T1Pos },
    //         //         { str_colName: 'MinTemp', value: minTemp },
    //         //         { str_colName: 'MaxTemp', value: maxTemp },
    //         //         { str_colName: 'limitOn', value: 0 },
    //         //         // { str_colName: 'T1NMTTab', value: objProductDetails.NMT },
    //         //         { str_colName: 'NomEmpty', value: 0 },
    //         //         { str_colName: 'T1NegEmpty', value: 0 },
    //         //         { str_colName: 'T1PosEmpty', value: 0 },
    //         //         // { str_colName: 'T2NegEmpty', value: 0 },
    //         //         // { str_colName: 'T2PosEmpty', value: 0 },
    //         //         { str_colName: 'NomNet', value: 0 },
    //         //         { str_colName: 'T1NegNet', value: 0 },
    //         //         { str_colName: 'T1PosNet', value: 0 },
    //         //         // { str_colName: 'T2NegNet', value: 0 },
    //         //         // { str_colName: 'T2PosNet', value: 0 },
    //         //         { str_colName: 'CubicleType', value: hmiDetailsInPMenu.Sys_CubType },
    //         //         { str_colName: 'ReportType', value: 0 },
    //         //         { str_colName: 'MachineCode', value: hmiDetailsInPMenu.Sys_MachineCode },
    //         //         // { str_colName: 'MFGCode', value: hmiDetailsInPMenu.Sys_MfgCode },
    //         //         { str_colName: 'BatchSize', value: hmiDetailsInPMenu.Sys_BatchSize },
    //         //         // { str_colName: 'FriabilityID', value: hmiDetailsInPMenu.Sys_FriabID },
    //         //         // { str_colName: 'HardnessID', value: hmiDetailsInPMenu.Sys_HardID },
    //         //         { str_colName: 'CubicleName', value: hmiDetailsInPMenu.Sys_CubicName },
    //         //         // { str_colName: 'CubicleLocation', value: hmiDetailsInPMenu.Sys_Location },
    //         //         { str_colName: 'RepoLabel10', value: 'Standard' },
    //         //         { str_colName: 'RepoLabel11', value: 0 },
    //         //         { str_colName: 'RepoLabel12', value: 'Null' },
    //         //         { str_colName: 'RepoLabel13', value: 'Null' },
    //         //         { str_colName: 'PrintNo', value: 0 },
    //         //         { str_colName: 'IsArchived', value: 0 },
    //         //         { str_colName: 'GraphType', value: 0 },
    //         //         { str_colName: 'BatchComplete', value: 0 },
    //         //         { str_colName: 'PVersion', value: hmiDetailsInPMenu.Sys_PVersion },
    //         //         { str_colName: 'Version', value: hmiDetailsInPMenu.Sys_Version },
    //         //         // { str_colName: 'CheckedByID', value: objProductDetails.userid },
    //         //         // { str_colName: 'CheckedByName', value: objProductDetails.userName },
    //         //         // { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD') },
    //         //         { str_colName: 'BRepSerNo', value: 0 },
    //         //         // { str_colName: 'Lot', value: hmiDetailsInPMenu.Sys_LotNo },
    //         //         { str_colName: 'Area', value: hmiDetailsInPMenu.Sys_Area },
    //         //         { str_colName: 'DTID', value: dataObj.strBalId }
    //         //     ]
    //         // }


    //         if (jarType == "A") {
    //             let startTimeval = moment(startTime, 'HH:mm:ss');
    //             let endTimeval = moment(endTime, 'HH:mm:ss');
    //             let runTime = moment.utc(moment(endTimeval, "HH:mm:ss")
    //                 .diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
    //             let hDur = haltDuration;

    //             for (const [i, dtVal] of jar_A_Arr.entries()) {

    //                 let endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
    //                 let endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
    //                 var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");

    //                 let res;
    //                 var resp;
    //                 let obj1;
    //                 var max;




    //                 // let times = ['04:30:45','16:40:45','12:20:50','15:10:10'];
    //                 var maxTime = '00:00:00';
    //                 for (let i = 0; i < jar_A_Arr.length; i++) {
    //                     let c_h = Number(jar_A_Arr[i].substring(0, 2));
    //                     let c_m = Number(jar_A_Arr[i].substring(3, 5));
    //                     let c_s = Number(jar_A_Arr[i].substring(6, 8));

    //                     let s_h = Number(maxTime.substring(0, 2));
    //                     let s_m = Number(maxTime.substring(3, 5));
    //                     let s_s = Number(maxTime.substring(6, 8));

    //                     if (c_h > s_h) {
    //                         maxTime = jar_A_Arr[i];
    //                     } else if (c_h === s_h) {
    //                         if (c_m > s_m) {
    //                             maxTime = jar_A_Arr[i];
    //                         } else if (c_m === s_m) {
    //                             if (c_s > s_s) {
    //                                 maxTime = jar_A_Arr[i];
    //                             }
    //                         }
    //                     }

    //                 }
    //                 var minTime = maxTime;
    //                 for (let i = 0; i < jar_A_Arr.length; i++) {
    //                     let c_h = Number(jar_A_Arr[i].substring(0, 2));
    //                     let c_m = Number(jar_A_Arr[i].substring(3, 5));
    //                     let c_s = Number(jar_A_Arr[i].substring(6, 8));

    //                     let s_h = Number(minTime.substring(0, 2));
    //                     let s_m = Number(minTime.substring(3, 5));
    //                     let s_s = Number(minTime.substring(6, 8));

    //                     if (c_h < s_h) {
    //                         minTime = jar_A_Arr[i];
    //                     } else if (c_h === s_h) {
    //                         if (c_m < s_m) {
    //                             minTime = jar_A_Arr[i];
    //                         } else if (c_m === s_m) {
    //                             if (c_s < s_s) {
    //                                 minTime = jar_A_Arr[i];
    //                             }
    //                         }
    //                     }

    //                 }




    //                 // for (const [i, dtVal] of jar_A_Arr.entries()) {
    //                 //     if (dtVal != null) {
    //                 //         for (const [i, dtVal1] of jar_A_Arr.entries()) {
    //                 //             // if (dtVal != dtVal1) {
    //                 //                 if (resp != undefined) {
    //                 //                     if (resp > dtVal1) {
    //                 //                         resp = dtVal
    //                 //                     }
    //                 //                     if (resp < dtVal1) {
    //                 //                         max = dtVal
    //                 //                     }
    //                 //                 }
    //                 //                 else {
    //                 //                     if (dtVal < dtVal1) {
    //                 //                         resp = dtVal
    //                 //                     }
    //                 //                     if (dtVal > dtVal1) {
    //                 //                         max = dtVal
    //                 //                     }
    //                 //                 }

    //                 //             // }
    //                 //         }
    //                 //     }
    //                 // }
    //             }

    //             const insertDetailObj = await models[detailTable].create({
    //                 'RepSerNo': lastInsertedID,
    //                 // Uuid
    //                 'MstSerNo': 1,
    //                 'RecSeqNo':  1,
    //                 'DT_ID': DTId,
    //                 'DT_Side': 'NA',
    //                 'DT_BasketID': 0,
    //                 'DT_Temp': dataObj.ProtocolData.Jar_A_maxTemp,
    //                 'DT_StartTm': startTime,
    //                 'DT_EndTm': endTm,
    //                 'DT_TimeMinSec': 0,
    //                 'DT_RunTime': maxTime,
    //                 // 'DT_RunTime': dtVal.trim(),
    //                 'DT_Remark': remark,
    //                 'DT_DoneByID': tempUserObject.UserId,
    //                 'DT_DoneByName': tempUserObject.UserName,
    //                 'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
    //                 'DT_HaltDur': hDur,
    //                 'DT_MinVal': minTime,
    //                 'DT_MaxVal': maxTime,
    //                 'DT_Jar': jarType,
    //                 // DT_Temp_Max
    //             })


    //             var JarAobj = {
    //                 'DT_HaltDur': hDur,
    //                 'DT_MinVal': minTime,
    //                 'DT_MaxVal': maxTime,
    //                 'DT_MinTemp': minTemp,
    //                 'DT_MaxTemp': maxTemp
    //             }
    //             // const insertDetailObj = {
    //             //     str_tableName: detailTable,
    //             //     data: [
    //             //         { str_colName: 'RepSerNo', value: lastInsertedID },
    //             //         { str_colName: 'MstSerNo', value: 0 },
    //             //         { str_colName: 'RecSeqNo', value: i + 1 },
    //             //         { str_colName: 'DT_Side', value: jarType == "A" ? "LHS" : "RHS" },
    //             //         { str_colName: 'DT_BasketID', value: 0 },
    //             //         { str_colName: 'DT_Temp', value: 0 },
    //             //         { str_colName: 'DT_StartTm', value: startTime },
    //             //         { str_colName: 'DT_EndTm', value: endTm },
    //             //         { str_colName: 'DT_TimeMinSec', value: 0 },
    //             //         // { str_colName: 'DT_RunTime', value: runTime },
    //             //         { str_colName: 'DT_RunTime', value: dtVal.trim() },
    //             //         { str_colName: 'DT_Remark', value: 0 },
    //             //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
    //             //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
    //             //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
    //             //         { str_colName: 'DT_HaltDur', value: hDur }
    //             //     ]
    //             // }


    //             const returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strHmi);
    //             const objUpdateValidation = await models.tbl_cubical.update({
    //                 'Sys_Validation': 0
    //             }, {
    //                 where: {
    //                     'Sys_IDSNo': strHmi
    //                 }

    //             });
    //             // {
    //             //     str_tableName: "tbl_cubical",
    //             //     data: [
    //             //         { str_colName: 'Sys_Validation', value: 0 },
    //             //     ],
    //             //     condition: [
    //             //         { str_colName: 'Sys_IDSNo', value: strIdsNo },
    //             //     ]
    //             // }
    //             // await database.update(objUpdateValidation);
    //             let tempFlagAJar = false; // For time
    //             let tempFlagTemp = false // for Tempreture
    //             for (const [i, dtVal] of jar_A_Arr.entries()) {
    //                 if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
    //                     tempFlagAJar = true;
    //                 }
    //             }
    //             if ((parseFloat(dataObj.productType.T1Neg) > parseFloat(minTemp)) ||
    //                 (parseFloat(dataObj.productType.T1Pos) < parseFloat(maxTemp))) {
    //                 tempFlagTemp = true;
    //             }
    //             if (tempFlagTemp == true || tempFlagAJar == true) {
    //                 le = "Report generated is out of limit"
    //             }
    //             if (lastInsertedID != null || lastInsertedID != undefined) {
    //                 const updateEndTime = await models[strTableName].update({
    //                     'PrEndDate': date.format(now, 'YYYY-MM-DD'),
    //                     'PrEndTime': date.format(now, 'HH:mm:ss')
    //                 }, {
    //                     where: {
    //                         RepSerNo: lastInsertedID
    //                     }
    //                 });
    //             }
    //             var mainObj = {
    //                 JarA: JarAobj
    //             }
    //             await objMonit.monit({
    //                 case: 'TestDTWeight',
    //                 Hmi: strHmi,
    //                 data: {
    //                     Weight: JarAobj,
    //                     Jar: "JAR A",
    //                     message: ""
    //                 }
    //             });
    //             mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`);

    //             obj.le = le
    //             obj.RepSerNo = lastInsertedID
    //             return obj;
    //         } else if (jarType == "B") {
    //             le = "Report generated is Within limit";
    //             var startTimeval = moment(startTime, 'HH:mm:ss');
    //             var endTimeval = moment(endTime, 'HH:mm:ss');
    //             var runTime = moment.utc(moment(endTimeval, "HH:mm:ss")
    //                 .diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
    //             var hDur = haltDuration;

    //             for (const [i, dtVal] of jar_B_Arr.entries()) {

    //                 var endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
    //                 var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
    //                 var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");

    //                 let res;
    //                 var resp;
    //                 let obj1;
    //                 var max;
    //                 var maxTime = '00:00:00';
    //                 for (let i = 0; i < jar_B_Arr.length; i++) {
    //                     let c_h = Number(jar_B_Arr[i].substring(0, 2));
    //                     let c_m = Number(jar_B_Arr[i].substring(3, 5));
    //                     let c_s = Number(jar_B_Arr[i].substring(6, 8));

    //                     let s_h = Number(maxTime.substring(0, 2));
    //                     let s_m = Number(maxTime.substring(3, 5));
    //                     let s_s = Number(maxTime.substring(6, 8));

    //                     if (c_h > s_h) {
    //                         maxTime = jar_B_Arr[i];
    //                     } else if (c_h === s_h) {
    //                         if (c_m > s_m) {
    //                             maxTime = jar_B_Arr[i];
    //                         } else if (c_m === s_m) {
    //                             if (c_s > s_s) {
    //                                 maxTime = jar_B_Arr[i];
    //                             }
    //                         }
    //                     }

    //                 }
    //                 var minTime = maxTime;
    //                 for (let i = 0; i < jar_B_Arr.length; i++) {
    //                     let c_h = Number(jar_B_Arr[i].substring(0, 2));
    //                     let c_m = Number(jar_B_Arr[i].substring(3, 5));
    //                     let c_s = Number(jar_B_Arr[i].substring(6, 8));

    //                     let s_h = Number(minTime.substring(0, 2));
    //                     let s_m = Number(minTime.substring(3, 5));
    //                     let s_s = Number(minTime.substring(6, 8));

    //                     if (c_h < s_h) {
    //                         minTime = jar_B_Arr[i];
    //                     } else if (c_h === s_h) {
    //                         if (c_m < s_m) {
    //                             minTime = jar_B_Arr[i];
    //                         } else if (c_m === s_m) {
    //                             if (c_s < s_s) {
    //                                 minTime = jar_B_Arr[i];
    //                             }
    //                         }
    //                     }

    //                 }
    //                 // for (const [i, dtVal] of jar_B_Arr.entries()) {
    //                 //     if (dtVal != null) {

    //                 //         for (const [i, dtVal1] of jar_B_Arr.entries()) {
    //                 //             if (dtVal != dtVal1) {
    //                 //                 if (resp != undefined) {
    //                 //                     if (resp > dtVal1) {
    //                 //                         resp = dtVal
    //                 //                     }
    //                 //                     if (resp < dtVal1) {
    //                 //                         max = dtVal
    //                 //                     }
    //                 //                 }
    //                 //                 else {
    //                 //                     if (dtVal < dtVal1) {
    //                 //                         resp = dtVal
    //                 //                     }
    //                 //                     if (dtVal > dtVal1) {
    //                 //                         max = dtVal
    //                 //                     }
    //                 //                 }

    //                 //             }
    //                 //         }
    //                 //     }
    //                 // }
    //             }
    //             const insertDetailObj = await models[detailTable].create({
    //                 'RepSerNo': lastInsertedID,
    //                 'MstSerNo': 1,
    //                 'RecSeqNo':  1,
    //                 'DT_ID': DTId,
    //                 'DT_Side': 'NA',
    //                 'DT_BasketID': 0,
    //                 'DT_Temp': dataObj.ProtocolData.Jar_B_maxTemp,
    //                 'DT_StartTm': startTime,
    //                 'DT_EndTm': endTm,
    //                 'DT_TimeMinSec': 0,
    //                 'DT_RunTime': maxTime,
    //                 // 'DT_RunTime': dtVal.trim(),
    //                 'DT_Remark': remark,
    //                 'DT_DoneByID': tempUserObject.UserId,
    //                 'DT_DoneByName': tempUserObject.UserName,
    //                 'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
    //                 'DT_HaltDur': hDur,
    //                 'DT_MinVal': minTime,
    //                 'DT_MaxVal': maxTime,
    //                 'DT_Jar': jarType,


    //             })
    //             var JarBobj = {
    //                 'DT_HaltDur': hDur,
    //                 'DT_MinVal': minTime,
    //                 'DT_MaxVal': maxTime,
    //                 'DT_MinTemp': minTemp,
    //                 'DT_MaxTemp': maxTemp
    //             }
    //             // const insertDetailObj = {
    //             //     str_tableName: detailTable,
    //             //     data: [
    //             //         { str_colName: 'RepSerNo', value: lastInsertedID },
    //             //         { str_colName: 'MstSerNo', value: 0 },
    //             //         { str_colName: 'RecSeqNo', value: i + 1 },
    //             //         { str_colName: 'DT_Side', value: jarType == "A" ? "LHS" : "RHS" },
    //             //         { str_colName: 'DT_BasketID', value: 0 },
    //             //         { str_colName: 'DT_Temp', value: 0 },
    //             //         { str_colName: 'DT_StartTm', value: startTime },
    //             //         { str_colName: 'DT_EndTm', value: endTm },
    //             //         { str_colName: 'DT_TimeMinSec', value: 0 },
    //             //         { str_colName: 'DT_RunTime', value: dtVal.trim() },
    //             //         { str_colName: 'DT_Remark', value: 0 },
    //             //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
    //             //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
    //             //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
    //             //         { str_colName: 'DT_HaltDur', value: hDur }
    //             //     ]
    //             // }

    //             // var jarBRes = await database.save(insertDetailObj);




    //             const returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strHmi);
    //             const objUpdateValidation = await models.tbl_cubical.update({
    //                 'Sys_Validation': 0
    //             }, {
    //                 where: {
    //                     'Sys_IDSNo': strHmi
    //                 }

    //             })

    //             // const objUpdateValidation = {
    //             //     str_tableName: "tbl_cubical",
    //             //     data: [
    //             //         { str_colName: 'Sys_Validation', value: 0 },
    //             //     ],
    //             //     condition: [
    //             //         { str_colName: 'Sys_IDSNo', value: strIdsNo },
    //             //     ]
    //             // }
    //             // await database.update(objUpdateValidation);
    //             let tempFlagAJar = false; // For time
    //             let tempFlagTemp = false // for Tempreture
    //             for (const [i, dtVal] of jar_B_Arr.entries()) {
    //                 if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
    //                     // return le = `${protocolIncomingType}` + `R2`;
    //                     tempFlagAJar = true;
    //                 }
    //             }
    //             if ((parseFloat(dataObj.productType.T1Neg) > parseFloat(minTemp)) ||
    //                 (parseFloat(dataObj.productType.T1Pos) < parseFloat(maxTemp))) {
    //                 tempFlagTemp = true;
    //             }
    //             if (tempFlagTemp == true || tempFlagAJar == true) {
    //                 le = "Report generated is out of limit";
    //             }
    //             if (lastInsertedID != null || lastInsertedID != undefined) {
    //                 const updateEndTime = await models[strTableName].update({
    //                     'PrEndDate': date.format(now, 'YYYY-MM-DD'),
    //                     'PrEndTime': date.format(now, 'HH:mm:ss')
    //                 }, {
    //                     where: {
    //                         RepSerNo: lastInsertedID
    //                     }
    //                 });
    //             }

    //             var mainObj = {
    //                 JarB: JarBobj
    //             }
    //             await objMonit.monit({
    //                 case: 'TestDTWeight',
    //                 Hmi: strHmi,
    //                 data: {
    //                     Weight: JarBobj,
    //                     Jar: "JAR B",
    //                     message: ""
    //                 }
    //             });
    //             mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`);

    //             obj.le = le
    //             obj.RepSerNo = lastInsertedID
    //             return obj;

    //         } else {

    //             // var objJARTypeDT = globalData.arrJARTypeDT.find(k => k.idsNo == IdsNo);
    //             // if (objJARTypeDT.JarType == "A") {
    //             //     jarType = "A";
    //             // }
    //             // else {
    //             //     jarType = "B";
    //             // }

    //             let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
    //             let startTimeA = dataObj.ProtocolData.start_time_Jar_A;
    //             let endTimeA = dataObj.ProtocolData.end_time_Jar_A;
    //             let startTimevalA = moment(startTimeA, 'HH:mm:ss');
    //             let endTimevalA = moment(endTimeA, 'HH:mm:ss');
    //             let runTimeA = moment.utc(moment(endTimevalA, "HH:mm:ss")
    //                 .diff(moment(startTimevalA, "HH:mm:ss"))).format("HH:mm:ss")
    //             let hDurA = dataObj.ProtocolData.HALT_DUR_JAR_A.trim();

    //             let startTimeB = dataObj.ProtocolData.start_time_Jar_B;
    //             let endTimeB = dataObj.ProtocolData.end_time_Jar_B;
    //             let startTimevalB = moment(startTimeB, 'HH:mm:ss');
    //             let endTimevalB = moment(endTimeB, 'HH:mm:ss');
    //             let runTimeB = moment.utc(moment(endTimevalB, "HH:mm:ss")
    //                 .diff(moment(startTimevalB, "HH:mm:ss"))).format("HH:mm:ss")
    //             let hDurB = dataObj.ProtocolData.HALT_DUR_JAR_B.trim();

    //             for (const [i, dtVal] of jar_A_Arr.entries()) {
    //                 let endTmSS = moment(startTimeA, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
    //                 let endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
    //                 var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
    //                 var DT_MinVal = dataObj.ProtocolData.Jar_Bath_min;
    //                 var DT_MaxVal = dataObj.ProtocolData.Jar_Bath_max;
    //                 let res;
    //                 var resp;
    //                 let obj1;
    //                 var max;
    //                 var maxTime = '00:00:00';
    //                 for (let i = 0; i < jar_A_Arr.length; i++) {
    //                     let c_h = Number(jar_A_Arr[i].substring(0, 2));
    //                     let c_m = Number(jar_A_Arr[i].substring(3, 5));
    //                     let c_s = Number(jar_A_Arr[i].substring(6, 8));

    //                     let s_h = Number(maxTime.substring(0, 2));
    //                     let s_m = Number(maxTime.substring(3, 5));
    //                     let s_s = Number(maxTime.substring(6, 8));

    //                     if (c_h > s_h) {
    //                         maxTime = jar_A_Arr[i];
    //                     } else if (c_h === s_h) {
    //                         if (c_m > s_m) {
    //                             maxTime = jar_A_Arr[i];
    //                         } else if (c_m === s_m) {
    //                             if (c_s > s_s) {
    //                                 maxTime = jar_A_Arr[i];
    //                             }
    //                         }
    //                     }

    //                 }
    //                 var minTime = maxTime;
    //                 for (let i = 0; i < jar_A_Arr.length; i++) {
    //                     let c_h = Number(jar_A_Arr[i].substring(0, 2));
    //                     let c_m = Number(jar_A_Arr[i].substring(3, 5));
    //                     let c_s = Number(jar_A_Arr[i].substring(6, 8));

    //                     let s_h = Number(minTime.substring(0, 2));
    //                     let s_m = Number(minTime.substring(3, 5));
    //                     let s_s = Number(minTime.substring(6, 8));

    //                     if (c_h < s_h) {
    //                         minTime = jar_A_Arr[i];
    //                     } else if (c_h === s_h) {
    //                         if (c_m < s_m) {
    //                             minTime = jar_A_Arr[i];
    //                         } else if (c_m === s_m) {
    //                             if (c_s < s_s) {
    //                                 minTime = jar_A_Arr[i];
    //                             }
    //                         }
    //                     }

    //                 }
    //                 // for (const [i, dtVal] of jar_A_Arr.entries()) {
    //                 //     if (dtVal != null) {

    //                 //         for (const [i, dtVal1] of jar_A_Arr.entries()) {
    //                 //             if (dtVal != dtVal1) {
    //                 //                 if (resp != undefined) {
    //                 //                     if (resp > dtVal1) {
    //                 //                         resp = dtVal
    //                 //                     }
    //                 //                     if (resp < dtVal1) {
    //                 //                         max = dtVal
    //                 //                     }
    //                 //                 }
    //                 //                 else {
    //                 //                     if (dtVal < dtVal1) {
    //                 //                         resp = dtVal
    //                 //                     }
    //                 //                     if (dtVal > dtVal1) {
    //                 //                         max = dtVal
    //                 //                     }
    //                 //                 }

    //                 //             }
    //                 //         }
    //                 //     }
    //                 // }
    //             }


    //             const insertDetailObjA = await models[detailTable].create({
    //                 'RepSerNo': lastInsertedID,
    //                 'MstSerNo': 1,
    //                 'RecSeqNo':  1,
    //                 'DT_ID': DTId,
    //                 'DT_Side': 'LHS',
    //                 'DT_BasketID': 0,
    //                 'DT_Temp': dataObj.ProtocolData.Jar_A_maxTemp,
    //                 'DT_StartTm': startTimeA,
    //                 'DT_EndTm': endTm,
    //                 'DT_TimeMinSec': 0,
    //                 'DT_RunTime': maxTime,
    //                 // 'DT_RunTime': dtVal.trim(),
    //                 'DT_Remark': remark,
    //                 'DT_DoneByID': tempUserObject.UserId,
    //                 'DT_DoneByName': tempUserObject.UserName,
    //                 'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
    //                 'DT_HaltDur': hDurA,
    //                 'DT_MinVal': minTime,
    //                 'DT_MaxVal': maxTime,
    //                 'DT_Jar': "A",


    //             })
    //             var JarAobj = {
    //                 'DT_HaltDur': hDurA,
    //                 'DT_MinVal': minTime,
    //                 'DT_MaxVal': maxTime,
    //                 'DT_MinTemp': minTemp,
    //                 'DT_MaxTemp': maxTemp
    //             }
    //             // const insertDetailObjA = {
    //             //     str_tableName: detailTable,
    //             //     data: [
    //             //         { str_colName: 'RepSerNo', value: lastInsertedID },
    //             //         { str_colName: 'MstSerNo', value: 0 },
    //             //         { str_colName: 'RecSeqNo', value: i + 1 },
    //             //         { str_colName: 'DT_Side', value: 'LHS' },
    //             //         { str_colName: 'DT_BasketID', value: 0 },
    //             //         { str_colName: 'DT_Temp', value: 0 },
    //             //         { str_colName: 'DT_StartTm', value: startTimeA },
    //             //         { str_colName: 'DT_EndTm', value: endTm },
    //             //         { str_colName: 'DT_TimeMinSec', value: 0 },
    //             //         //{ str_colName: 'DT_RunTime', value: runTimeA },
    //             //         { str_colName: 'DT_RunTime', value: dtVal.trim() },
    //             //         { str_colName: 'DT_Remark', value: 0 },
    //             //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
    //             //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
    //             //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
    //             //         { str_colName: 'DT_HaltDur', value: hDurA }
    //             //     ]
    //             // }
    //             // var ResJarA = await database.save(insertDetailObjA);


    //             startTime = startTimeB;
    //             endTime = endTimeB;

    //             var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
    //             endDate = timeStatus ? startDate : date.format(now, 'YYYY-MM-DD');
    //             let bRepSerNo = await this.getMaxBRepSerNo(dataObj.objProductDetails.ProductName, dataObj.objProductDetails.Batch, strTableName, hmiDetailsInPMenu.Sys_RptType)

    //             /* inserting Data of double rotatry for B*/
    //             const insertObj = await models[strTableName].create({
    //                 'MstSerNo': 1,
    //                 'InstruId': 1,
    //                 'BFGCode': dataObj.objProductDetails.ProductId,
    //                 'ProductName': dataObj.objProductDetails.ProductName,
    //                 'ProductType': objProductDetails.ProductType,
    //                 'Qty': 6,
    //                 'GrpQty': 0,
    //                 'GrpFreq': 0,
    //                 'Idsno': strHmi,
    //                 'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
    //                 'BalanceId': 0,
    //                 'BalanceNo': 0,
    //                 //  'VernierId': hmiDetailsInPMenu.Sys_VernierID ,
    //                 'VernierNo': 0,
    //                 'BatchNo': dataObj.objProductDetails.Batch,
    //                 'UserId': dataObj.objProductDetails.userId,
    //                 'UserName': dataObj.objProductDetails.userName,
    //                 'PrDate': startDatefromOBJ,
    //                 'PrTime': startTimedfromOBJ,
    //                 'PrEndDate': '1992-12-08',
    //                 'PrEndTime': '',
    //                 'Side': "RHS" ,
    //                 'Unit': 'C',
    //                 'DecimalPoint': '0',
    //                 'WgmtModeNo': productDetail.ProductType == 1 ? "13":"6",
    //                 'Nom': intNominal,
    //                 'T1NegTol': objProductDetails.T1Neg,
    //                 'T1PosTol': objProductDetails.T1Pos,
    //                 'MinTemp': BminTemp,
    //                 'MaxTemp': BmaxTemp,
    //                 'limitOn': 0,
    //                 //  'T1NMTTab': objProductDetails.NMT ,
    //                 'NomEmpty': 0,
    //                 'T1NegEmpty': 0,
    //                 'T1PosEmpty': 0,
    //                 //  'T2NegEmpty': 0 ,
    //                 //  'T2PosEmpty': 0 ,
    //                 'NomNet': 0,
    //                 'T1NegNet': 0,
    //                 'T1PosNet': 0,
    //                 //  'T2NegNet': 0 ,
    //                 //  'T2PosNet': 0 ,
    //                 'CubicleType': hmiDetailsInPMenu.Sys_CubType,
    //                 'ReportType': hmiDetailsInPMenu.Sys_RptType,
    //                 'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
    //                 'Media': hmiDetailsInPMenu.Sys_media,
    //                 'MFGCode': hmiDetailsInPMenu.Sys_Stage,
    //                 'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
    //                 //  'FriabilityID': hmiDetailsInPMenu.Sys_FriabID ,
    //                 //  'HardnessID': hmiDetailsInPMenu.Sys_HardID ,
    //                 'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
    //                 'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
    //                 'RepoLabel10': 'Standard',
    //                 'RepoLabel11': 0,
    //                 'RepoLabel12': 'Null',
    //                 'RepoLabel13': 'Null',
    //                 'PrintNo': 0,
    //                 'IsArchived': 0,
    //                 'GraphType': 0,
    //                 'BatchComplete': 0,
    //                 'PVersion': hmiDetailsInPMenu.Sys_PVersion,
    //                 'Version': hmiDetailsInPMenu.Sys_Version,
    //                 //  'CheckedByID': objProductDetails.userid ,
    //                 //  'CheckedByName': objProductDetails.userName ,
    //                 //  'CheckedByDate': date.format(now, 'YYYY-MM-DD') ,
    //                 'BRepSerNo': bRepSerNo,
    //                 'Lot': hmiDetailsInPMenu.Sys_LotNo,
    //                 'Area': hmiDetailsInPMenu.Sys_Area,
    //                 // SideNo
    //                 'AppearanceDesc':hmiDetailsInPMenu.Sys_Appearance,
    //                 'MachineSpeed_Min':hmiDetailsInPMenu.Sys_MachineSpeed_Min,
    //                 'MachineSpeed_Max':hmiDetailsInPMenu.Sys_MachineSpeed_Max,
    //                 'GenericName' :hmiDetailsInPMenu.Sys_GenericName,
    //                 "BMRNo": hmiDetailsInPMenu.Sys_BMRNo,
    //                 // IsNMT
    //                 // Inprocess
    //                 'DTID': DTId,
    //                 "DT_Mode":dataObj.ProtocolData.Mode,
    //                 'DT_SetTemp': SetTemp,
    //                 'DT_Jar': "B",
    //                 // Uuid
    //                 'DT_BasketType': ProtocolData.JarBasket,
    //                 'Interval': dataObj.objProductDetails.interval
    //             });
    //             let arrResult = insertObj;
    //             let lastInsertedIDJarB = arrResult.RepSerNo;

    //             //var lastInsertedIDJarB = resultCompleteDataJarB[0].insertId;
    //             for (const [i, dtVal] of jar_B_Arr.entries()) {
    //                 var endTmSS = moment(startTimeA, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
    //                 var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
    //                 var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
    //                 var DT_MinVal = dataObj.ProtocolData.Jar_Bath_min;
    //                 var DT_MaxVal = dataObj.ProtocolData.Jar_Bath_max;
    //                 let res;
    //                 var resp;
    //                 let obj1;
    //                 var max;
    //                 var maxTime = '00:00:00';
    //                 for (let i = 0; i < jar_B_Arr.length; i++) {
    //                     let c_h = Number(jar_B_Arr[i].substring(0, 2));
    //                     let c_m = Number(jar_B_Arr[i].substring(3, 5));
    //                     let c_s = Number(jar_B_Arr[i].substring(6, 8));

    //                     let s_h = Number(maxTime.substring(0, 2));
    //                     let s_m = Number(maxTime.substring(3, 5));
    //                     let s_s = Number(maxTime.substring(6, 8));

    //                     if (c_h > s_h) {
    //                         maxTime = jar_B_Arr[i];
    //                     } else if (c_h === s_h) {
    //                         if (c_m > s_m) {
    //                             maxTime = jar_B_Arr[i];
    //                         } else if (c_m === s_m) {
    //                             if (c_s > s_s) {
    //                                 maxTime = jar_B_Arr[i];
    //                             }
    //                         }
    //                     }

    //                 }
    //                 var minTime = maxTime;
    //                 for (let i = 0; i < jar_B_Arr.length; i++) {
    //                     let c_h = Number(jar_B_Arr[i].substring(0, 2));
    //                     let c_m = Number(jar_B_Arr[i].substring(3, 5));
    //                     let c_s = Number(jar_B_Arr[i].substring(6, 8));

    //                     let s_h = Number(minTime.substring(0, 2));
    //                     let s_m = Number(minTime.substring(3, 5));
    //                     let s_s = Number(minTime.substring(6, 8));

    //                     if (c_h < s_h) {
    //                         minTime = jar_B_Arr[i];
    //                     } else if (c_h === s_h) {
    //                         if (c_m < s_m) {
    //                             minTime = jar_B_Arr[i];
    //                         } else if (c_m === s_m) {
    //                             if (c_s < s_s) {
    //                                 minTime = jar_B_Arr[i];
    //                             }
    //                         }
    //                     }

    //                 }
    //                 // for (const [i, dtVal] of jar_B_Arr.entries()) {
    //                 //     if (dtVal != null) {

    //                 //         for (const [i, dtVal1] of jar_B_Arr.entries()) {
    //                 //             if (dtVal != dtVal1) {
    //                 //                 if (resp != undefined) {
    //                 //                     if (resp > dtVal1) {
    //                 //                         resp = dtVal
    //                 //                     }
    //                 //                     if (resp < dtVal1) {
    //                 //                         max = dtVal
    //                 //                     }
    //                 //                 }
    //                 //                 else {
    //                 //                     if (dtVal < dtVal1) {
    //                 //                         resp = dtVal
    //                 //                     }
    //                 //                     if (dtVal > dtVal1) {
    //                 //                         max = dtVal
    //                 //                     }
    //                 //                 }

    //                 //             }
    //                 //         }
    //                 //     }
    //                 // }
    //             }
    //             const insertDetailObjB = await models[detailTable].create({
    //                 'RepSerNo': lastInsertedIDJarB,
    //                 'MstSerNo': 1,
    //                 'RecSeqNo':  1,
    //                 'DT_ID': DTId,
    //                 'DT_Side': 'RHS',
    //                 'DT_BasketID': 0,
    //                 'DT_Temp': dataObj.ProtocolData.Jar_B_maxTemp,
    //                 'DT_StartTm': startTimeB,
    //                 'DT_EndTm': endTm,
    //                 'DT_TimeMinSec': 0,
    //                 //{ str_colName: 'DT_RunTime': runTimeB ,
    //                 'DT_RunTime': maxTime,
    //                 'DT_Remark': remark,
    //                 'DT_DoneByID': tempUserObject.UserId,
    //                 'DT_DoneByName': tempUserObject.UserName,
    //                 'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
    //                 'DT_HaltDur': hDurB,
    //                 'DT_MinVal': minTime,
    //                 'DT_MaxVal': maxTime,
    //                 'DT_Jar': "B",
    //             })


    //             var JarBobj = {
    //                 'DT_HaltDur': hDurB,
    //                 'DT_MinVal': minTime,
    //                 'DT_MaxVal': maxTime,
    //                 'DT_MinTemp': BminTemp,
    //                 'DT_MaxTemp': BmaxTemp,
    //             }
    //             //     str_tableName: detailTable,
    //             //     data: [
    //             //         { str_colName: 'RepSerNo', value: lastInsertedIDJarB },
    //             //         { str_colName: 'MstSerNo', value: 0 },
    //             //         { str_colName: 'RecSeqNo', value: i + 1 },
    //             //         { str_colName: 'DT_Side', value: 'RHS' },
    //             //         { str_colName: 'DT_BasketID', value: 0 },
    //             //         { str_colName: 'DT_Temp', value: 0 },
    //             //         { str_colName: 'DT_StartTm', value: startTimeB },
    //             //         { str_colName: 'DT_EndTm', value: endTm },
    //             //         { str_colName: 'DT_TimeMinSec', value: 0 },
    //             //         //{ str_colName: 'DT_RunTime', value: runTimeB },
    //             //         { str_colName: 'DT_RunTime', value: dtVal.trim() },
    //             //         { str_colName: 'DT_Remark', value: 0 },
    //             //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
    //             //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
    //             //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
    //             //         { str_colName: 'DT_HaltDur', value: hDurB }
    //             //     ]
    //             // }

    //             // var ResDetailB = await database.save(insertDetailObjB);


    //             /* end of  inserting Data of double rotatry for B*/
    //             const objUpdateValidation = await models.tbl_cubical.update({
    //                 'Sys_Validation': 0
    //             }, {
    //                 where: {
    //                     'Sys_IDSNo': strHmi
    //                 }

    //             });
    //             // const objUpdateValidation = {
    //             //     str_tableName: "tbl_cubical",
    //             //     data: [
    //             //         { str_colName: 'Sys_Validation', value: 0 },
    //             //     ],
    //             //     condition: [
    //             //         { str_colName: 'Sys_IDSNo', value: strIdsNo },
    //             //     ]
    //             // }
    //             hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData
    //             await objBatchSummary.saveBatchSummaryDT(lastInsertedID, lastInsertedIDJarB, hmiDetailsInPMenu, strHmi);
    //             // await database.update(objUpdateValidation);

    //             le = `Report generated is Within limit`;
    //             let tempFlagAJar = false; // For time
    //             let tempFlagTemp = false // for Tempreture
    //             for (const [i, dtVal] of jar_A_Arr.entries()) {
    //                 if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
    //                     tempFlagAJar = true;
    //                 }
    //             }
    //             for (const [i, dtVal] of jar_B_Arr.entries()) {
    //                 if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
    //                     tempFlagAJar = true;
    //                 }
    //             }

    //             if ((parseFloat(dataObj.objProductDetails.Nominal) < parseFloat(JarBobj.DT_MinVal)) ||
    //                 (parseFloat(dataObj.objProductDetails.Nominal) < parseFloat(JarBobj.DT_MaxVal)) ||
    //                 (parseFloat(dataObj.objProductDetails.Nominal) > parseFloat(JarAobj.DT_MinVal)) ||
    //                 (parseFloat(dataObj.objProductDetails.Nominal) > parseFloat(JarAobj.DT_MaxVal))) {
    //                 tempFlagTemp = true;
    //             }
    //             // if (tempFlagTemp == true || tempFlagAJar == true) {
    //             //     le = `Report generated is out of limit`;
    //             // }
    //             if (lastInsertedID != null || lastInsertedID != undefined) {
    //                 const updateEndTime = await models[strTableName].update({
    //                     'PrEndDate': date.format(now, 'YYYY-MM-DD'),
    //                     'PrEndTime': date.format(now, 'HH:mm:ss')
    //                 }, {
    //                     where: {
    //                         RepSerNo: lastInsertedID
    //                     }
    //                 });
    //             }
    //             // if (lastInsertedIDJarB != null || lastInsertedIDJarB != undefined) {
    //             //     const updateEndTime = await models[strTableName].update({
    //             //         'PrEndDate': date.format(now, 'YYYY-MM-DD'),
    //             //         'PrEndTime': date.format(now, 'HH:mm:ss')
    //             //     }, {
    //             //         where: {
    //             //             RepSerNo: lastInsertedIDJarB
    //             //         }
    //             //     });
    //             // }
    //             var mainObj = {
    //                 JarA: JarAobj,
    //                 JarB: JarBobj
    //             }
    //             await objMonit.monit({
    //                 case: 'TestDTWeight',
    //                 Hmi: strHmi,
    //                 data: {
    //                     Weight: JarAobj,
    //                     Jar: "JAR A",
    //                     message: ""
    //                 }
    //             });
    //             await objMonit.monit({
    //                 case: 'TestDTWeight',
    //                 Hmi: strHmi,
    //                 data: {
    //                     Weight: JarBobj,
    //                     Jar: "JAR B",
    //                     message: ""
    //                 }
    //             });
    //             mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`);

    //             // obj.le = le
    //             obj.RepSerNo = lastInsertedID
    //             return obj;
    //         }
    //     } catch (error) {
    //         throw new Error(error)
    //     }
    // }
    async insert_DT_Data_for_EDI_2SA(dataObj) {
        try {
            const strTableName = dataObj.strTableName
            const detailTable = dataObj.strDetailTbl
            const strIdsNo = dataObj.uniqueSerialNumber
            let objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo)
            const objProductDetails = objSelMenu.selectedProductDetail
            const DTId = dataObj.strBalId
            const ProtocolData = dataObj.ProtocolData
            // var jar_A_Arr = ProtocolData.jar_A_Obj.jar_A_Arr
            // var jar_B_Arr = ProtocolData.jar_B_Obj.jar_B_Arr
            var jar_A_Arr = [];
            var jar_B_Arr = [];
            jar_A_Arr = [{
                end_time_Jar_A: ProtocolData.end_time_Jar_A,
                HALT_DUR_JAR_A: ProtocolData.HALT_DUR_JAR_A,
                Jar_A_maxTemp: ProtocolData.Jar_A_maxTemp,
                Jar_A_minTemp: ProtocolData.Jar_A_minTemp,
                start_time_Jar_A: ProtocolData.start_time_Jar_A,
                '1_SampleLHS': ProtocolData["1_SampleLHS"],
                '2_SampleLHS': ProtocolData["2_SampleLHS"],
                '3_SampleLHS': ProtocolData["3_SampleLHS"],
                '4_SampleLHS': ProtocolData["4_SampleLHS"],
                '5_SampleLHS': ProtocolData["5_SampleLHS"],
                '6_SampleLHS': ProtocolData["6_SampleLHS"],


            }]
            jar_B_Arr = [{
                end_time_Jar_B: ProtocolData.end_time_Jar_B,
                HALT_DUR_JAR_B: ProtocolData.HALT_DUR_JAR_B,
                Jar_B_maxTemp: ProtocolData.Jar_B_maxTemp,
                Jar_B_minTemp: ProtocolData.Jar_B_minTemp,
                start_time_Jar_B: ProtocolData.start_time_Jar_B,
                '1_SampleRHS': ProtocolData["1_SampleRHS"],
                '2_SampleRHS': ProtocolData["2_SampleRHS"],
                '3_SampleRHS': ProtocolData["3_SampleRHS"],
                '4_SampleRHS': ProtocolData["4_SampleRHS"],
                '5_SampleRHS': ProtocolData["5_SampleRHS"],
                '6_SampleRHS': ProtocolData["6_SampleRHS"],

            }]

            const strHmi = dataObj.strHmi
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi)
            const intNominal = dataObj.productType.nominal

            var hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            var arrProductType = globalData.arrProductTypeArray.find(k => k.idsNo == strIdsNo)
            var productDetail = arrProductType.productType
            var paramDetails = arrProductType.productDetail[0][0]


            var jarType, side
            if (dataObj.objProductDetails.Rotary == "Single") {
                jarType = dataObj.objProductDetails.Side
                // .charAt(dataObj.objProductDetails.Side.length - 1)
                side = jarType == "A" ? 'LHS' : 'RHS'
            } else if (dataObj.objProductDetails.Rotary == "Double") {
                jarType = "AB"
                side = "NA"
            }

            var testRemark = "Report generated is Within limit"

            var actualRunTime = productDetail.ProductType == 1 ? paramDetails.Param13_Nom : paramDetails.Param6_Nom

            var startDate = dataObj.ProtocolData.Start_Date
            startDate = moment(startDate, 'DD/MM/YYYY').format('YYYY-MM-DD')

            var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/
            var startTime, endTime, haltDuration_A, haltDuration_B, minTemp, maxTemp, obj, endDate

            if (dataObj.objProductDetails.Rotary == 'Single') {

                if (jarType == "A") {
                    minTemp = ProtocolData.Jar_A_minTemp
                    maxTemp = ProtocolData.Jar_A_maxTemp
                    startTime = ProtocolData.start_time_Jar_A;
                    endTime = ProtocolData.end_time_Jar_A;
                    endTime = await this.addTwoTimes(startTime, endTime)
                    var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
                    endDate = timeStatus ? startDate : moment().format('YYYY-MM-DD')
                    obj = {
                        LHS: jar_A_Arr,
                    }
                    haltDuration_A = ProtocolData.HALT_DUR_JAR_A

                } else if (jarType == "B") {

                    minTemp = ProtocolData.Jar_B_minTemp
                    maxTemp = ProtocolData.Jar_B_maxTemp
                    startTime = ProtocolData.start_time_Jar_B
                    endTime = ProtocolData.end_time_Jar_B
                    endTime = await this.addTwoTimes(startTime, endTime)
                    var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
                    endDate = timeStatus ? startDate : moment().format('YYYY-MM-DD')
                    obj = {
                        RHS: jar_B_Arr,
                    }
                    haltDuration_B = ProtocolData.HALT_DUR_JAR_B
                }

            } else {
                minTemp = ProtocolData.Jar_A_minTemp < ProtocolData.Jar_B_minTemp ? ProtocolData.Jar_A_minTemp : ProtocolData.Jar_B_minTemp
                maxTemp = ProtocolData.Jar_A_maxTemp > ProtocolData.Jar_B_maxTemp ? ProtocolData.Jar_A_maxTemp : ProtocolData.Jar_B_maxTemp
                startTime = Number(ProtocolData.start_time_Jar_B.replace(regExp, "$1$2$3")) < Number(ProtocolData.start_time_Jar_A.replace(regExp, "$1$2$3")) ? ProtocolData.start_time_Jar_B : ProtocolData.start_time_Jar_A;
                endTime = Number(ProtocolData.end_time_Jar_B.replace(regExp, "$1$2$3")) > Number(ProtocolData.end_time_Jar_A.replace(regExp, "$1$2$3")) ? ProtocolData.end_time_Jar_B : ProtocolData.end_time_Jar_A;
                endTime = await this.addTwoTimes(startTime, endTime);
                var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
                endDate = timeStatus ? startDate : moment().format('YYYY-MM-DD')
                obj = {
                    LHS: jar_A_Arr,
                    RHS: jar_B_Arr
                }
                haltDuration_A = ProtocolData.HALT_DUR_JAR_A
                haltDuration_B = ProtocolData.HALT_DUR_JAR_B
            }

            var arrResult = await models[strTableName].create({
                MstSerNo: 0,
                InstruId: 1,
                BFGCode: dataObj.objProductDetails.ProductId,
                ProductName: dataObj.objProductDetails.ProductName,
                ProductType: objProductDetails.ProductType,
                Qty: 6,
                GrpQty: 0,
                GrpFreq: 0,
                Idsno: strHmi,
                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                BalanceId: hmiDetailsInPMenu.Sys_BalID,
                BalanceNo: 0,
                VernierId: hmiDetailsInPMenu.Sys_VernierID,
                VernierNo: 0,
                BatchNo: dataObj.objProductDetails.Batch,
                UserId: dataObj.objProductDetails.userId,
                UserName: dataObj.objProductDetails.userName,
                Stage :hmiDetailsInPMenu.Sys_Stage,
                PrDate: startDate,
                PrTime: startTime,
                PrEndDate: endDate,
                PrEndTime: endTime,
                Side: side,
                // Unit: 123,
                DecimalPoint: '0',
                WgmtModeNo: 13,
                Nom: intNominal,
                T1NegTol: objProductDetails.T1Neg,
                T1PosTol: objProductDetails.T1Pos,
                MinTemp: minTemp,
                MaxTemp: maxTemp,
                limitOn: 0,
                //  T1NMTTab: objProductDetails.NMT,
                NomEmpty: 0,
                T1NegEmpty: 0,
                T1PosEmpty: 0,
                //  T2NegEmpty: 0,
                //  T2PosEmpty: 0,
                NomNet: 0,
                T1NegNet: 0,
                T1PosNet: 0,
                //  T2NegNet: 0,
                //  T2PosNet: 0,
                CubicleType: hmiDetailsInPMenu.Sys_CubType,
                ReportType: 0,
                MachineCode: hmiDetailsInPMenu.Sys_MachineCode,
                // MFGCode: hmiDetailsInPMenu.Sys_MfgCode,
                BatchSize: hmiDetailsInPMenu.Sys_BatchSize,
                FriabilityID: hmiDetailsInPMenu.Sys_FriabID,
                HardnessID: hmiDetailsInPMenu.Sys_HardID,
                CubicleName: hmiDetailsInPMenu.Sys_CubicName,
                CubicleLocation: hmiDetailsInPMenu.Sys_Location,
                RepoLabel10: 'Standard',
                RepoLabel11: 0,
                RepoLabel12: 'Null',
                RepoLabel13: 'Null',
                GraphType: 0,
                BatchComplete: 0,
                PVersion: hmiDetailsInPMenu.Sys_PVersion,
                Version: hmiDetailsInPMenu.Sys_Version,
                BRepSerNo: 0,
                Lot: hmiDetailsInPMenu.Sys_LotNo,
                Area: hmiDetailsInPMenu.Sys_Area,
                DTID: hmiDetailsInPMenu.Sys_DTID
            })

            var lastInsertedID = arrResult.dataValues.RepSerNo;


            // let startTimeval = moment(startTime, 'HH:mm:ss');
            // let endTimeval = moment(endTime, 'HH:mm:ss');
            // let runTime = moment.utc(moment(endTimeval, "HH:mm:ss")
            //     .diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
            // let hDur = haltDuration;

            if (parseFloat(dataObj.productType.T1Neg) > Number(minTemp) ||
                parseFloat(dataObj.productType.T1Pos) < Number(maxTemp))
                testRemark = "Report generated is out of limit"


            if (jarType.includes("A"))
                await this.insertIntoDetailTable(hmiDetailsInPMenu.Sys_DTID, jar_A_Arr, testRemark, actualRunTime, startDate, startTime, detailTable, lastInsertedID, tempUserObject, side, haltDuration_A)


            if (jarType.includes("B"))
                await this.insertIntoDetailTable(hmiDetailsInPMenu.Sys_DTID, jar_B_Arr, testRemark, actualRunTime, startDate, startTime, detailTable, lastInsertedID, tempUserObject, side, haltDuration_B)


            await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strIdsNo)

            await models.tbl_cubical.update({
                Sys_Validation: 0
            }, {
                where: {
                    Sys_rpi: strIdsNo,
                }
            })

            obj.testRemark = testRemark

            return obj


        } catch (error) {
            throw new Error(error)
        }
    }

    // async insert_DT_Data_for_LABIndia(dataObj) {
    //     try {
    //         const strTableName = dataObj.strTableName
    //         const detailTable = dataObj.strDetailTbl
    //         const strIdsNo = dataObj.uniqueSerialNumber
    //         const DTId = dataObj.strBalId
    //         const ProtocolData = dataObj.ProtocolData
    //         // const jar_A_Arr = ProtocolData.jar_A_Arr
    //         // const jar_B_Arr = ProtocolData.jar_B_Arr
    //         const jar_A_Arr = ProtocolData.Jar_A_minTemp
    //         const jar_B_Arr = ProtocolData.Jar_B_minTemp
    //         const strHmi = dataObj.strHmi
    //         const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi)
    //         const intNominal = dataObj.productType.nominal
    //         var objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo)
    //         var objProductDetails = objSelMenu.selectedProductDetail

    //         var jarType, side
    //         if (dataObj.objProductDetails.Rotary == "Single") {
    //             jarType = dataObj.objProductDetails.Side
    //             // .charAt(dataObj.objProductDetails.Side.length - 1)
    //             side = jarType == "Jar A" ? 'LHS' : 'RHS'
    //         } else if (dataObj.objProductDetails.Rotary == "Double") {
    //             jarType = "Jar AB"
    //             side = "NA"
    //         }

    //         var hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
    //         var arrProductType = globalData.arrProductTypeArray.find(k => k.idsNo == strIdsNo);
    //         var productDetail = arrProductType.productType;
    //         var paramDetails = arrProductType.productDetail[0][0];

    //         var testRemark = "Report generated is Within limit";

    //         var actualRunTime = productDetail.ProductType == 1 ? paramDetails.Param13_Nom : paramDetails.Param6_Nom;

    //         var startDate = dataObj.ProtocolData.Start_Date
    //         startDate = moment(startDate, 'DD/MM/YY').format('YYYY-MM-DD')

    //         var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;

    //         var startTime, endTime, minTemp, maxTemp, obj, endDate

    //         if (dataObj.objProductDetails.Rotary == 'Single') {

    //             if (jarType == "Jar A") {

    //                 minTemp = Math.min(...jar_A_Arr.map(k => k.temp))
    //                 maxTemp = Math.max(...jar_A_Arr.map(k => k.temp))
    //                 startTime = dataObj.ProtocolData.time;
    //                 startTime = startTime.concat(':00')
    //                 endTime = jar_A_Arr[jar_A_Arr.length - 1].data;
    //                 endTime = await this.addTwoTimes(startTime, endTime);
    //                 var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
    //                 endDate = timeStatus ? startDate : moment().format('YYYY-MM-DD')
    //                 obj = {
    //                     LHS: jar_A_Arr,
    //                 }

    //             } else if (jarType == "Jar B") {

    //                 minTemp = Math.min(...jar_B_Arr.map(k => k.temp))
    //                 maxTemp = Math.max(...jar_B_Arr.map(k => k.temp))
    //                 startTime = dataObj.ProtocolData.time;
    //                 startTime = startTime.concat(':00')
    //                 endTime = jar_B_Arr[jar_B_Arr.length - 1].data;
    //                 endTime = await this.addTwoTimes(startTime, endTime);
    //                 var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
    //                 endDate = timeStatus ? startDate : moment().format('YYYY-MM-DD')
    //                 obj = {
    //                     RHS: jar_B_Arr,
    //                 }
    //             }

    //         } else {

    //             minTemp = Math.min(...jar_A_Arr.concat(jar_B_Arr).map(k => k.temp))
    //             maxTemp = Math.max(...jar_B_Arr.concat(jar_B_Arr).map(k => k.temp))
    //             startTime = dataObj.ProtocolData.time;
    //             startTime = startTime.concat(':00')
    //             endTime = jar_A_Arr[jar_A_Arr.length - 1].data;
    //             endTime = await this.addTwoTimes(startTime, endTime);
    //             var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
    //             endDate = timeStatus ? startDate : moment().format('YYYY-MM-DD')
    //             obj = {
    //                 LHS: jar_A_Arr,
    //                 RHS: jar_B_Arr
    //             }
    //         }

    //         var arrResult = await models[strTableName].create({
    //             MstSerNo: 0,
    //             InstruId: 1,
    //             BFGCode: dataObj.objProductDetails.ProductId,
    //             ProductName: dataObj.objProductDetails.ProductName,
    //             ProductType: objProductDetails.ProductType,
    //             Qty: 6,
    //             GrpQty: 0,
    //             GrpFreq: 0,
    //             Idsno: strHmi,
    //             CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
    //             BalanceId: hmiDetailsInPMenu.Sys_BalID,
    //             BalanceNo: 0,
    //             VernierId: hmiDetailsInPMenu.Sys_VernierID,
    //             VernierNo: 0,
    //             BatchNo: dataObj.objProductDetails.Batch,
    //             UserId: dataObj.objProductDetails.userId,
    //             UserName: dataObj.objProductDetails.userName,
    //             PrDate: startDate,
    //             PrTime: startTime,
    //             PrEndDate: endDate,
    //             PrEndTime: endTime,
    //             Side: side,
    //             // Unit: 123,
    //             DecimalPoint: '0',
    //             WgmtModeNo: 1,
    //             Nom: intNominal,
    //             T1NegTol: objProductDetails.T1Neg,
    //             T1PosTol: objProductDetails.T1Pos,
    //             MinTemp: minTemp,
    //             MaxTemp: maxTemp,
    //             limitOn: 0,
    //             //  T1NMTTab: objProductDetails.NMT,
    //             NomEmpty: 0,
    //             T1NegEmpty: 0,
    //             T1PosEmpty: 0,
    //             //  T2NegEmpty: 0,
    //             //  T2PosEmpty: 0,
    //             NomNet: 0,
    //             T1NegNet: 0,
    //             T1PosNet: 0,
    //             //  T2NegNet: 0,
    //             //  T2PosNet: 0,
    //             CubicleType: hmiDetailsInPMenu.Sys_CubType,
    //             ReportType: 0,
    //             MachineCode: hmiDetailsInPMenu.Sys_MachineCode,
    //             MFGCode: hmiDetailsInPMenu.Sys_MfgCode,
    //             BatchSize: hmiDetailsInPMenu.Sys_BatchSize,
    //             FriabilityID: hmiDetailsInPMenu.Sys_FriabID,
    //             HardnessID: hmiDetailsInPMenu.Sys_HardID,
    //             CubicleName: hmiDetailsInPMenu.Sys_CubicName,
    //             CubicleLocation: hmiDetailsInPMenu.Sys_Location,
    //             RepoLabel10: 'Standard',
    //             RepoLabel11: 0,
    //             RepoLabel12: 'Null',
    //             RepoLabel13: 'Null',
    //             GraphType: 0,
    //             BatchComplete: 0,
    //             PVersion: hmiDetailsInPMenu.Sys_PVersion,
    //             Version: hmiDetailsInPMenu.Sys_Version,
    //             BRepSerNo: 0,
    //             Lot: hmiDetailsInPMenu.Sys_LotNo,
    //             Area: hmiDetailsInPMenu.Sys_Area,
    //             DTID: hmiDetailsInPMenu.Sys_DTID
    //         })

    //         var lastInsertedID = arrResult.dataValues.RepSerNo;


    //         // var startTimeval = moment(startTime, 'HH:mm:ss');
    //         // let endTimeval = moment(endTime, 'HH:mm:ss');
    //         // let runTime = moment.utc(moment(endTimeval, "HH:mm:ss")
    //         //     .diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
    //         // let hDur = haltDuration;

    //         if (parseFloat(dataObj.productType.T1Neg) > parseFloat(minTemp) ||
    //             parseFloat(dataObj.productType.T1Pos) < parseFloat(maxTemp))
    //             testRemark = "Report generated is out of limit"

    //         if (jarType.includes("A"))
    //             await this.insertIntoDetailTable(hmiDetailsInPMenu.Sys_DTID, jar_A_Arr, testRemark, actualRunTime, startDate, startTime, detailTable, lastInsertedID, tempUserObject, side)


    //         if (jarType.includes("B"))
    //             await this.insertIntoDetailTable(hmiDetailsInPMenu.Sys_DTID, jar_B_Arr, testRemark, actualRunTime, startDate, startTime, detailTable, lastInsertedID, tempUserObject, side)


    //         await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strIdsNo)

    //         await models.tbl_cubical.update({
    //             Sys_Validation: 0
    //         }, {
    //             where: {
    //                 Sys_rpi: strIdsNo,
    //             }
    //         })

    //         obj.testRemark = testRemark

    //         return obj


    //     } catch (error) {
    //         throw new Error(error)
    //     }
    // }

    async insert_DT_Data_for_LABIndia(dataObj) {
        try {
            const strTableName = dataObj.strTableName;
            const strIdsNo = dataObj.uniqueSerialNumber;
            const strHmi = dataObj.strHmi;
            const now = new Date();
            let jar_A_Arr = [];
            let jar_B_Arr = [];
            let jarA_Arr = [];
            let jarB_Arr = [];
            let minTemp, maxTemp, startTime, endTime, haltDuration, side;
            let objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            const objProductDetails = objSelMenu.selectedProductDetail;
            const DTId = dataObj.strBalId;
            const ProtocolData = dataObj.ProtocolData;
            const ProtocolUnit = dataObj.ProtocolUnit;
            const ProtocolDecPoint = dataObj.ProtocolDecPoint;
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            const intNominal = dataObj.objProductDetails.Nominal;
            var startTimedfromOBJ = dataObj.objProductDetails.Time;
            startTimedfromOBJ = moment().format(startTimedfromOBJ, 'hh:mm:ss');
            var startDatefromOBJ = dataObj.objProductDetails.Date;
            startDatefromOBJ = moment().format('YYYY-MM-D', startDatefromOBJ);
            let jarType, endDate;
            var insertDetailObj
            if (dataObj.objProductDetails.Rotary == "Single") {
                side = "NA";
                jarType = dataObj.objProductDetails.Side.trim()
                    .charAt(dataObj.objProductDetails.Side.length - 1)
            } else if (dataObj.objProductDetails.Rotary == "Double") {
                side = "LHS/RHS";
                jarType = "N";
            }

            let i = 1;
            for (let Obj in ProtocolData) {
                if (ProtocolData.hasOwnProperty(`${i}_SampleLHS`)) {
                    if (ProtocolData[`${i}_SampleLHS`] !== "") {
                        jarA_Arr.push(ProtocolData[`${i}_SampleLHS`])
                    }
                    if (ProtocolData.hasOwnProperty(`${i}_SampleRHS`)) {
                        if (ProtocolData[`${i}_SampleRHS`] !== "") {
                            jarB_Arr.push(ProtocolData[`${i}_SampleRHS`])
                        }
                    }
                    i++;
                }
            }
            var Obj = {
                LHS: jarA_Arr,
                RHS: jarB_Arr
            }
            i = 1;
            for (var obj in ProtocolData) {
                if (ProtocolData.hasOwnProperty(`${i}_SampleLHS`)) {
                    if (ProtocolData[`${i}_SampleLHS`] !== "") {
                        jar_A_Arr.push({ data: (ProtocolData[`${i}_SampleLHS`]), temp: parseFloat(ProtocolData[`${i}_SampleLHSTemp`]) })
                    }
                    if (ProtocolData.hasOwnProperty(`${i}_SampleRHS`)) {
                        if (ProtocolData[`${i}_SampleRHS`] !== "") {
                            jar_B_Arr.push({ data: ProtocolData[`${i}_SampleRHS`], temp: parseFloat(ProtocolData[`${i}_SampleRHSTemp`]) })
                        }
                    }
                    i++;
                }
            }


            var obj = {
                Lhs: jar_A_Arr,
                Rhs: jar_B_Arr
            }
            if (dataObj.objProductDetails.Rotary == "Single") {
                if (jarType == "A") {
                    obj = {
                        Lhs: jar_A_Arr,
                    }
                } else if (jarType == "B") {
                    obj = {
                        Rhs: jar_B_Arr,
                    }
                }
            }


            const regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let startDate = dataObj.ProtocolData.Start_Date;
            startDate = startDate.split("/").reverse().join("-");
            let arrProductType = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
            let productDetail = arrProductType.productType;
            let paramDetails = arrProductType.productDetail;
            paramDetails = paramDetails[0][0]
            var BathTemp = ProtocolData.BathTemp
            let le = "Within limit";

            //dynamically take from android
            let actualRunTime = productDetail.ProductType == 1 ? paramDetails.Param13_Nom : paramDetails.Param6_Nom;
            let completeTable = productDetail.ProductType == 1 ? 'tbl_tab_master13' : 'tbl_cap_master6';
            let detailTable = productDetail.ProductType == 1 ? 'tbl_tab_detail13' : 'tbl_cap_detail6';
            // if (dataObj.objProductDetails.Rotary == 'Single') {
            //     if (ProtocolData.Jar_B_minTemp != undefined && jarType == 'B') {
            //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
            //     }
            //     if (ProtocolData.Jar_A_minTemp == undefined && jarType == 'A') {
            //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
            //     }
            // }
            // if (dataObj.objProductDetails.Rotary == 'Double') {
            //     if (ProtocolData.start_time_Jar_A == 'N.A' && ProtocolData.start_time_Jar_B == 'N.A' && jarType != 'N') {
            //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
            //     }
            // }
            if (dataObj.objProductDetails.Rotary == 'Single') {
                if (jarType == "A") {
                    minTemp = Math.min(...jar_A_Arr.map(k => k.temp));
                    maxTemp = Math.max(...jar_A_Arr.map(k => k.temp));
                    // minTime = Math.min(...jar_A_Arr.map(k => k.data));
                    // maxTime = Math.max(...jar_A_Arr.map(k => k.data));
                    startTime = dataObj.ProtocolData.time;
                    startTime = startTime.concat(':00')
                    endTime = jar_A_Arr[jar_A_Arr.length - 1].data;
                    endTime = await this.addTwoTimes(startTime, endTime);
                    let regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
                    var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
                    endDate = timeStatus ? startDate : date.format(now, 'YYYY-MM-DD');
                } else if (jarType == "B") {
                    minTemp = Math.min(...jar_B_Arr.map(k => k.temp));
                    maxTemp = Math.max(...jar_B_Arr.map(k => k.temp));
                    startTime = dataObj.ProtocolData.time;
                    startTime = startTime.concat(':00')
                    endTime = jar_B_Arr[jar_B_Arr.length - 1].data;
                    endTime = await this.addTwoTimes(startTime, endTime);
                    let regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
                    var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
                    endDate = timeStatus ? startDate : date.format(now, 'YYYY-MM-DD');
                }
            } else {
                minTemp = Math.min(...jar_A_Arr.map(k => k.temp));
                maxTemp = Math.max(...jar_A_Arr.map(k => k.temp));

                startTime = dataObj.ProtocolData.time;
                startTime = startTime.concat(':00')
                endTime = jar_A_Arr[jar_A_Arr.length - 1].data;
                endTime = await this.addTwoTimes(startTime, endTime);
                let regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
                var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
                endDate = timeStatus ? startDate : date.format(now, 'YYYY-MM-DD');
            }
            let bRepSerNo = await this.getMaxBRepSerNo(dataObj.objProductDetails.ProductName, dataObj.objProductDetails.Batch, strTableName, hmiDetailsInPMenu.Sys_RptType)

            const insertObj = await models[strTableName].create({
                'MstSerNo': 0,
                'InstruId': 1,
                'BFGCode': dataObj.objProductDetails.ProductId,
                'ProductName': dataObj.objProductDetails.ProductName,
                'ProductType': objProductDetails.ProductType,
                'Qty': 6,
                'GrpQty': 0,
                'GrpFreq': 0,
                'Idsno': strHmi,
                'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                'BalanceId': 0,
                'BalanceNo': 0,
                // 'VernierId': hmiDetailsInPMenu.Sys_VernierID ,
                'VernierNo': 0,
                'BatchNo': dataObj.objProductDetails.Batch,
                'UserId': dataObj.objProductDetails.userId,
                'UserName': dataObj.objProductDetails.userName,
                'Media': hmiDetailsInPMenu.Sys_media,
                'PrDate': startDatefromOBJ,
                'PrTime': startTimedfromOBJ,
                'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                'PrEndTime': endTime,
                'Side': side,
                'Unit': '123',
                'DecimalPoint': '0',
                'WgmtModeNo': 13,
                'Nom': intNominal,
                Media_Temp: ProtocolData.MediaTemp,
                Bath_Temp: BathTemp,
                Apparatus_Type: ProtocolData.ApparatusType,
                Program_No: ProtocolData.Program_No,
                StdTime: dataObj.objProductDetails.Nominal,
                TempRange: dataObj.objProductDetails.T1Neg.split(' ')[0] + " - " + dataObj.objProductDetails.T1Pos.split(' ')[0],
                // 'T1NegTol': objProductDetails.T1Neg,
                // 'T1PosTol': objProductDetails.T1Pos,
                'MinTemp': minTemp,
                'MaxTemp': maxTemp,
                'limitOn': 0,
                // 'T1NMTTab': objProductDetails.NMT ,
                'NomEmpty': 0,
                'T1NegEmpty': 0,
                'T1PosEmpty': 0,
                // 'T2NegEmpty': 0 ,
                // 'T2PosEmpty': 0 ,
                'NomNet': 0,
                'T1NegTol': dataObj.objProductDetails.T1Neg.split(' ')[0],
                'T1PosTol': dataObj.objProductDetails.T1Pos.split(' ')[0],
                // 'T2NegNet': 0 ,
                // 'T2PosNet': 0 ,
                'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                'ReportType': hmiDetailsInPMenu.Sys_RptType,
                'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                'MFGCode': hmiDetailsInPMenu.Sys_Stage,
                'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
                // 'FriabilityID': hmiDetailsInPMenu.Sys_FriabID ,
                // 'HardnessID': hmiDetailsInPMenu.Sys_HardID ,
                'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                // 'CubicleLocation': hmiDetailsInPMenu.Sys_Location ,
                'RepoLabel10': 'Standard',
                'RepoLabel11': 0,
                'RepoLabel12': 'Null',
                'RepoLabel13': 'Null',
                'PrintNo': 0,
                'IsArchived': 0,
                'GraphType': 0,
                'BatchComplete': 0,
                'PVersion': hmiDetailsInPMenu.Sys_PVersion,
                'Version': hmiDetailsInPMenu.Sys_Version,
                // 'CheckedByID': objProductDetails.userid ,
                // 'CheckedByName': objProductDetails.userName ,
                // 'CheckedByDate': date.format(now, 'YYYY-MM-DD') ,
                'BRepSerNo': bRepSerNo,
                // 'Lot': hmiDetailsInPMenu.Sys_LotNo ,
                'Area': hmiDetailsInPMenu.Sys_Area,
                'InstrumentID': DTId,
                'Interval': dataObj.objProductDetails.interval
            })
            // const insertObj = {
            //     str_tableName: strTableName,
            //     data: [
            //         { str_colName: 'MstSerNo', value: 0 },
            //         { str_colName: 'InstruId', value: 1 },
            //         { str_colName: 'BFGCode', value: dataObj.objProductDetails.ProductId },
            //         { str_colName: 'ProductName', value: dataObj.objProductDetails.ProductName },
            //         { str_colName: 'ProductType', value: objProductDetails.ProductType },
            //         { str_colName: 'Qty', value: 6 },
            //         { str_colName: 'GrpQty', value: 0 },
            //         { str_colName: 'GrpFreq', value: 0 },
            //         { str_colName: 'Idsno', value: strIdsNo },
            //         { str_colName: 'CubicalNo', value: hmiDetailsInPMenu.Sys_CubicNo },
            //         { str_colName: 'BalanceId', value: 0 },
            //         { str_colName: 'BalanceNo', value: 0 },
            //         // { str_colName: 'VernierId', value: hmiDetailsInPMenu.Sys_VernierID },
            //         { str_colName: 'VernierNo', value: 0 },
            //         { str_colName: 'BatchNo', value: dataObj.objProductDetails.Batch },
            //         { str_colName: 'UserId', value: dataObj.objProductDetails.userid },
            //         { str_colName: 'UserName', value: dataObj.objProductDetails.userName },
            //         { str_colName: 'PrDate', value: startDate },
            //         { str_colName: 'PrTime', value: startTime },
            //         { str_colName: 'PrEndDate', value: endDate },
            //         { str_colName: 'PrEndTime', value: endTime },
            //         { str_colName: 'Side', value: side },
            //         { str_colName: 'Unit', value: '123' },
            //         { str_colName: 'DecimalPoint', value: '0' },
            //         { str_colName: 'WgmtModeNo', value: 1 },
            //         { str_colName: 'Nom', value: intNominal },
            //         { str_colName: 'T1NegTol', value: objProductDetails.T1Neg },
            //         { str_colName: 'T1PosTol', value: objProductDetails.T1Pos },
            //         { str_colName: 'MinTemp', value: minTemp },
            //         { str_colName: 'MaxTemp', value: maxTemp },
            //         { str_colName: 'limitOn', value: 0 },
            //         // { str_colName: 'T1NMTTab', value: objProductDetails.NMT },
            //         { str_colName: 'NomEmpty', value: 0 },
            //         { str_colName: 'T1NegEmpty', value: 0 },
            //         { str_colName: 'T1PosEmpty', value: 0 },
            //         // { str_colName: 'T2NegEmpty', value: 0 },
            //         // { str_colName: 'T2PosEmpty', value: 0 },
            //         { str_colName: 'NomNet', value: 0 },
            //         { str_colName: 'T1NegNet', value: 0 },
            //         { str_colName: 'T1PosNet', value: 0 },
            //         // { str_colName: 'T2NegNet', value: 0 },
            //         // { str_colName: 'T2PosNet', value: 0 },
            //         { str_colName: 'CubicleType', value: hmiDetailsInPMenu.Sys_CubType },
            //         { str_colName: 'ReportType', value: 0 },
            //         { str_colName: 'MachineCode', value: hmiDetailsInPMenu.Sys_MachineCode },
            //         // { str_colName: 'MFGCode', value: hmiDetailsInPMenu.Sys_MfgCode },
            //         { str_colName: 'BatchSize', value: hmiDetailsInPMenu.Sys_BatchSize },
            //         // { str_colName: 'FriabilityID', value: hmiDetailsInPMenu.Sys_FriabID },
            //         // { str_colName: 'HardnessID', value: hmiDetailsInPMenu.Sys_HardID },
            //         { str_colName: 'CubicleName', value: hmiDetailsInPMenu.Sys_CubicName },
            //         // { str_colName: 'CubicleLocation', value: hmiDetailsInPMenu.Sys_Location },
            //         { str_colName: 'RepoLabel10', value: 'Standard' },
            //         { str_colName: 'RepoLabel11', value: 0 },
            //         { str_colName: 'RepoLabel12', value: 'Null' },
            //         { str_colName: 'RepoLabel13', value: 'Null' },
            //         { str_colName: 'PrintNo', value: 0 },
            //         { str_colName: 'IsArchived', value: 0 },
            //         { str_colName: 'GraphType', value: 0 },
            //         { str_colName: 'BatchComplete', value: 0 },
            //         { str_colName: 'PVersion', value: hmiDetailsInPMenu.Sys_PVersion },
            //         { str_colName: 'Version', value: hmiDetailsInPMenu.Sys_Version },
            //         // { str_colName: 'CheckedByID', value: objProductDetails.userid },
            //         // { str_colName: 'CheckedByName', value: objProductDetails.userName },
            //         // { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD') },
            //         { str_colName: 'BRepSerNo', value: 0 },
            //         // { str_colName: 'Lot', value: hmiDetailsInPMenu.Sys_LotNo },
            //         { str_colName: 'Area', value: hmiDetailsInPMenu.Sys_Area },
            //         // { str_colName: 'DTID', value:DTId }
            //     ]
            // }
            let arrResult = insertObj;
            let lastInsertedID = arrResult.RepSerNo;

            if (jarType == "A") {
                let startTimeval = moment(startTime, 'HH:mm:ss');
                let endTimeval = moment(endTime, 'HH:mm:ss');
                let runTime = moment.utc(moment(endTimeval, "HH:mm:ss")
                    .diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
                let hDur = haltDuration;

                for (const [i, dtVal] of jar_A_Arr.entries()) {

                    let endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.data.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    let endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.data.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    let endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.data.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    let res;
                    let resp;
                    let obj1;
                    let max;
                    // for (const [i, dtVal] of jar_A_Arr.entries()) {
                    //     if(dtVal != null){

                    //         for (const [i, dtVal1] of jar_A_Arr.entries()) {
                    //             if(dtVal != dtVal1) {
                    //                 if(resp != undefined){
                    //                     if(resp > dtVal1 ){
                    //                         resp = dtVal
                    //                    }
                    //                    if(resp < dtVal1 ){
                    //                     max = dtVal
                    //                }
                    //                 }
                    //                 else{
                    //                 if(dtVal < dtVal1 ){
                    //                      resp = dtVal
                    //                 }
                    //                 if(dtVal > dtVal1 ){
                    //                     max = dtVal
                    //                }
                    //             }

                    //             }
                    //         }
                    //     }
                    // }

                    var maxTime = '00:00:00';
                    for (let i = 0; i < jarA_Arr.length; i++) {
                        let c_h = Number(jarA_Arr[i].substring(0, 2));
                        let c_m = Number(jarA_Arr[i].substring(3, 5));
                        let c_s = Number(jarA_Arr[i].substring(6, 8));

                        let s_h = Number(maxTime.substring(0, 2));
                        let s_m = Number(maxTime.substring(3, 5));
                        let s_s = Number(maxTime.substring(6, 8));

                        if (c_h > s_h) {
                            maxTime = jarA_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m > s_m) {
                                maxTime = jarA_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s > s_s) {
                                    maxTime = jarA_Arr[i];
                                }
                            }
                        }

                    }
                    var minTime = maxTime;
                    for (let i = 0; i < jarA_Arr.length; i++) {
                        let c_h = Number(jarA_Arr[i].substring(0, 2));
                        let c_m = Number(jarA_Arr[i].substring(3, 5));
                        let c_s = Number(jarA_Arr[i].substring(6, 8));

                        let s_h = Number(minTime.substring(0, 2));
                        let s_m = Number(minTime.substring(3, 5));
                        let s_s = Number(minTime.substring(6, 8));

                        if (c_h < s_h) {
                            minTime = jarA_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m < s_m) {
                                minTime = jarA_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s < s_s) {
                                    minTime = jarA_Arr[i];
                                }
                            }
                        }

                    }

                    var insertmasterobj = await models[strTableName].update({
                        MinTime: minTime,
                        MaxTime: maxTime
                    }, {
                        where: {
                            BatchNo: dataObj.objProductDetails.Batch,
                            BFGCode: dataObj.objProductDetails.ProductId,
                            ProductName: dataObj.objProductDetails.ProductName,
                        }
                    });

                    // const insertDetailObj = {
                    //     str_tableName: detailTable,
                    //     data: [
                    //         { str_colName: 'RepSerNo': lastInsertedID },
                    //         { str_colName: 'MstSerNo', value: 0 },
                    //         { str_colName: 'RecSeqNo', value: i + 1 },
                    //         { str_colName: 'DT_Side', value: jarType == "A" ? "LHS" : "RHS" },
                    //         { str_colName: 'DT_BasketID', value: 0 },
                    //         { str_colName: 'DT_Temp', value: dtVal.temp },
                    //         { str_colName: 'DT_StartTm', value: startTime },
                    //         { str_colName: 'DT_EndTm', value: endTm },
                    //         { str_colName: 'DT_TimeMinSec', value: 0 },
                    //         // { str_colName: 'DT_RunTime', value: runTime },
                    //         { str_colName: 'DT_RunTime', value: dtVal.data.trim() },
                    //         { str_colName: 'DT_Remark', value: 0 },
                    //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
                    //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
                    //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
                    //         { str_colName: 'DT_HaltDur', value: "00:00:00" }
                    //     ]
                    // }
                    // await database.save(insertDetailObj);


                    insertDetailObj = await models[detailTable].create({
                        'RepSerNo': lastInsertedID,
                        'MstSerNo': 0,
                        'RecSeqNo': i + 1,
                        'DT_ID': DTId,
                        'DT_Side': 'NA',
                        'DT_BasketID': "A",
                        'DT_Temp': BathTemp,
                        'DT_StartTm': startTime,
                        'DT_EndTm': endTm,
                        'DT_TimeMinSec': 0,
                        // 'DT_RunTime': runTime ,
                        'DT_RunTime': dtVal.data.trim(),
                        'DT_Remark': 0,
                        'DT_DoneByID': tempUserObject.UserId,
                        'DT_DoneByName': tempUserObject.UserName,
                        'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
                        'DT_HaltDur': "00:00:00",
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                    });
                }
                const returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strHmi);
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0
                }, {
                    where: {
                        'Sys_IDSNo': strHmi
                    }

                });
                // const objUpdateValidation = {
                //     str_tableName: "tbl_cubical",
                //     data: [
                //         { str_colName: 'Sys_Validation', value: 0 },
                //     ],
                //     condition: [
                //         { str_colName: 'Sys_IDSNo', value: strIdsNo },
                //     ]
                // }
                // await database.update(objUpdateValidation);
                let tempFlagAJar = false; // For time
                let tempFlagTemp = false // for Tempreture
                // for (const [i, dtVal] of jar_A_Arr.entries()) {
                //     if (parseInt(dtVal.data.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                //         tempFlagAJar = true;
                //     }
                // }
                if (parseFloat(dataObj.objProductDetails.Nominal) > parseFloat(maxTime))
                //  ||
                //     (parseFloat(dataObj.objProductDetails.Nominal) < parseFloat(maxTime))) {
                {
                    tempFlagTemp = true;
                }
                if (tempFlagTemp == true)
                // || tempFlagAJar == true) 
                {
                    le = "Out of Limit"
                }
                if (lastInsertedID != null || lastInsertedID != undefined) {
                    const updateEndTime = await models[strTableName].update({
                        'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                        'PrEndTime': date.format(now, 'HH:mm:ss'),
                        Remark: le
                    }, {
                        where: {
                            RepSerNo: lastInsertedID
                        }
                    });
                }
                let jarAobj = {
                    // 'DT_HaltDur': "00:00:00",
                    'DT_MinVal': minTime,
                    'DT_MaxVal': maxTime,
                    'DT_MinTemp': minTemp,
                    'DT_MaxTemp': maxTemp,
                }
                var mainObj = {
                    JarA: jarAobj
                }
                await objMonit.monit({
                    case: 'TestDTWeight',
                    Hmi: strHmi,
                    data: {
                        Weight: jarAobj,
                        Jar: "JAR A",
                        message: ""
                    }
                });
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`)
                obj.le = le
                obj.RepSerNo = lastInsertedID
                return obj;
            } else if (jarType == "B") {
                le = "Within limit";
                let startTimeval = moment(startTime, 'HH:mm:ss');
                let endTimeval = moment(endTime, 'HH:mm:ss');
                let runTime = moment.utc(moment(endTimeval, "HH:mm:ss")
                    .diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
                let hDur = haltDuration;

                for (const [i, dtVal] of jar_B_Arr.entries()) {

                    var endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.data.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.data.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.data.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    let res;
                    let resp;
                    let obj1;
                    let max;
                    for (const [i, dtVal] of jar_B_Arr.entries()) {
                        if (dtVal != null) {

                            for (const [i, dtVal1] of jar_B_Arr.entries()) {
                                if (dtVal != dtVal1) {
                                    if (resp != undefined) {
                                        if (resp > dtVal1) {
                                            resp = dtVal
                                        }
                                        if (resp < dtVal1) {
                                            max = dtVal
                                        }
                                    }
                                    else {
                                        if (dtVal < dtVal1) {
                                            resp = dtVal
                                        }
                                        if (dtVal > dtVal1) {
                                            max = dtVal
                                        }
                                    }

                                }
                            }
                        }
                    }

                    var maxTime = '00:00:00';
                    for (let i = 0; i < jarB_Arr.length; i++) {
                        let c_h = Number(jarB_Arr[i].substring(0, 2));
                        let c_m = Number(jarB_Arr[i].substring(3, 5));
                        let c_s = Number(jarB_Arr[i].substring(6, 8));

                        let s_h = Number(maxTime.substring(0, 2));
                        let s_m = Number(maxTime.substring(3, 5));
                        let s_s = Number(maxTime.substring(6, 8));

                        if (c_h > s_h) {
                            maxTime = jarB_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m > s_m) {
                                maxTime = jarB_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s > s_s) {
                                    maxTime = jarB_Arr[i];
                                }
                            }
                        }

                    }
                    var minTime = maxTime;
                    for (let i = 0; i < jarB_Arr.length; i++) {
                        let c_h = Number(jarB_Arr[i].substring(0, 2));
                        let c_m = Number(jarB_Arr[i].substring(3, 5));
                        let c_s = Number(jarB_Arr[i].substring(6, 8));

                        let s_h = Number(minTime.substring(0, 2));
                        let s_m = Number(minTime.substring(3, 5));
                        let s_s = Number(minTime.substring(6, 8));

                        if (c_h < s_h) {
                            minTime = jarB_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m < s_m) {
                                minTime = jarB_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s < s_s) {
                                    minTime = jarB_Arr[i];
                                }
                            }
                        }

                    }




                    // var jarBRes = await database.save(insertDetailObj);
                    // const insertDetailObj = {
                    //     str_tableName: detailTable,
                    //     data: [
                    //         { str_colName: 'RepSerNo', value: lastInsertedID },
                    //         { str_colName: 'MstSerNo', value: 0 },
                    //         { str_colName: 'RecSeqNo', value: i + 1 },
                    //         { str_colName: 'DT_Side', value: jarType == "A" ? "LHS" : "RHS" },
                    //         { str_colName: 'DT_BasketID', value: 0 },
                    //         { str_colName: 'DT_Temp', value: dtVal.temp },
                    //         { str_colName: 'DT_StartTm', value: startTime },
                    //         { str_colName: 'DT_EndTm', value: endTm },
                    //         { str_colName: 'DT_TimeMinSec', value: 0 },
                    //         { str_colName: 'DT_RunTime', value: dtVal.data.trim() },
                    //         { str_colName: 'DT_Remark', value: 0 },
                    //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
                    //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
                    //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
                    //         { str_colName: 'DT_HaltDur', value: "00:00:00" }
                    //     ]
                    // }

                    // var jarBRes = await database.save(insertDetailObj);




                    insertDetailObj = await models[detailTable].create({

                        'RepSerNo': lastInsertedID,
                        'MstSerNo': 0,
                        'RecSeqNo': i + 1,
                        'DT_ID': DTId,
                        'DT_Side': 'NA',
                        'DT_BasketID': "B",
                        'DT_Temp': BathTemp,
                        'DT_StartTm': startTime,
                        'DT_EndTm': endTm,
                        'DT_TimeMinSec': 0,
                        'DT_RunTime': dtVal.data.trim(),
                        'DT_Remark': le,
                        'DT_DoneByID': tempUserObject.UserId,
                        'DT_DoneByName': tempUserObject.UserName,
                        'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
                        'DT_HaltDur': "00:00:00",
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                    });
                }

                const returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strHmi);
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0
                }, {
                    where: {
                        'Sys_IDSNo': strHmi
                    }

                });
                // const objUpdateValidation = {
                //     str_tableName: "tbl_cubical",
                //     data: [
                //         { str_colName: 'Sys_Validation', value: 0 },
                //     ],
                //     condition: [
                //         { str_colName: 'Sys_IDSNo', value: strIdsNo },
                //     ]
                // }
                // await database.update(objUpdateValidation);
                let tempFlagAJar = false; // For time
                let tempFlagTemp = false // for Tempreture
                // for (const [i, dtVal] of jar_B_Arr.entries()) {
                //     if (parseInt(dtVal.data.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                //         // return le = `${protocolIncomingType}` + `R2`;
                //         tempFlagAJar = true;
                //     }
                // }
                if (parseFloat(dataObj.productType.nominal) > parseFloat(minTemp))
                // ||
                // (parseFloat(dataObj.productType.nominal) < parseFloat(maxTemp)))
                {
                    tempFlagTemp = true;
                }
                if (tempFlagTemp == true || tempFlagAJar == true) {
                    le = "Out of Limit";
                }
                if (lastInsertedID != null || lastInsertedID != undefined) {
                    const updateEndTime = await models[strTableName].update({
                        'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                        'PrEndTime': date.format(now, 'HH:mm:ss'),
                        Remark: le
                    }, {
                        where: {
                            RepSerNo: lastInsertedID
                        }
                    });
                }
                var JarBobj = {
                    // 'DT_HaltDur': "00:00:00",
                    'DT_MinVal': minTime,
                    'DT_MaxVal': maxTime,
                    'DT_MinTemp': minTemp,
                    'DT_MaxTemp': maxTemp,

                }
                var mainObj = {
                    JarB: JarBobj
                }
                await objMonit.monit({
                    case: 'TestDTWeight',
                    Hmi: strHmi,
                    data: {
                        Weight: JarBobj,
                        Jar: "JAR B",
                        message: ""
                    }
                });
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`)
                obj.le = le
                obj.RepSerNo = lastInsertedID
                return obj;

            } else {

                // var objJARTypeDT = globalData.arrJARTypeDT.find(k => k.idsNo == IdsNo);
                // if (objJARTypeDT.JarType == "A") {
                //     jarType = "A";
                // }
                // else {
                //     jarType = "B";
                // }

                let startTime = dataObj.ProtocolData.time;
                startTime = startTime.concat(':00')
                let endTimeA = jar_A_Arr[jar_A_Arr.length - 1].data;
                let endTimeB = jar_B_Arr[jar_B_Arr.length - 1].data;
                //    endTime = endTimeA > endTimeB ? endTimeA : endTimeB;
                //    endTime = await this.addTwoTimes(startTime, endTime);


                let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
                let startTimeA = startTime;
                // let endTimeA = endTimeA;
                let startTimevalA = moment(startTimeA, 'HH:mm:ss');
                let endTimevalA = moment(endTimeA, 'HH:mm:ss');
                let runTimeA = moment.utc(moment(endTimevalA, "HH:mm:ss")
                    .diff(moment(startTimevalA, "HH:mm:ss"))).format("HH:mm:ss")
                // let hDurA = dataObj.ProtocolData.HALT_DUR_JAR_A.trim();


                //     let startTime = dataObj.ProtocolData.time;
                //     startTime = startTime.concat(':00')
                //    let endTimeA = jar_A_Arr[jar_A_Arr.length - 1].data;
                //    let endTimeB  = jar_B_Arr[jar_B_Arr.length - 1].data;
                //    endTime = endTimeA > endTimeB ? endTimeA : endTimeB;
                //    endTime = await this.addTwoTimes(startTime, endTime);



                let startTimeB = startTime;
                // let endTimeB =  endTimeB ;
                let startTimevalB = moment(startTimeB, 'HH:mm:ss');
                let endTimevalB = moment(endTimeB, 'HH:mm:ss');
                let runTimeB = moment.utc(moment(endTimevalB, "HH:mm:ss")
                    .diff(moment(startTimevalB, "HH:mm:ss"))).format("HH:mm:ss")
                // let hDurB = dataObj.ProtocolData.HALT_DUR_JAR_B.trim();

                for (const [i, dtVal] of jar_A_Arr.entries()) {

                    let endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.data.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    let endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.data.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    let endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.data.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    let res;
                    let resp;
                    let obj1;
                    let max;
                    for (const [i, dtVal] of jar_A_Arr.entries()) {
                        if (dtVal != null) {

                            for (const [i, dtVal1] of jar_A_Arr.entries()) {
                                if (dtVal != dtVal1) {
                                    if (resp != undefined) {
                                        if (resp > dtVal1) {
                                            resp = dtVal
                                        }
                                        if (resp < dtVal1) {
                                            max = dtVal
                                        }
                                    }
                                    else {
                                        if (dtVal < dtVal1) {
                                            resp = dtVal
                                        }
                                        if (dtVal > dtVal1) {
                                            max = dtVal
                                        }
                                    }

                                }
                            }
                        }
                    }

                    var maxTime = '00:00:00';
                    for (let i = 0; i < jarA_Arr.length; i++) {
                        let c_h = Number(jarA_Arr[i].substring(0, 2));
                        let c_m = Number(jarA_Arr[i].substring(3, 5));
                        let c_s = Number(jarA_Arr[i].substring(6, 8));

                        let s_h = Number(maxTime.substring(0, 2));
                        let s_m = Number(maxTime.substring(3, 5));
                        let s_s = Number(maxTime.substring(6, 8));

                        if (c_h > s_h) {
                            maxTime = jarA_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m > s_m) {
                                maxTime = jarA_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s > s_s) {
                                    maxTime = jarA_Arr[i];
                                }
                            }
                        }

                    }
                    var minTime = maxTime;
                    for (let i = 0; i < jarA_Arr.length; i++) {
                        let c_h = Number(jarA_Arr[i].substring(0, 2));
                        let c_m = Number(jarA_Arr[i].substring(3, 5));
                        let c_s = Number(jarA_Arr[i].substring(6, 8));

                        let s_h = Number(minTime.substring(0, 2));
                        let s_m = Number(minTime.substring(3, 5));
                        let s_s = Number(minTime.substring(6, 8));

                        if (c_h < s_h) {
                            minTime = jarA_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m < s_m) {
                                minTime = jarA_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s < s_s) {
                                    minTime = jarA_Arr[i];
                                }
                            }
                        }

                    }





                    var JarAobj = {
                        //  'DT_HaltDur': "00:00:00",
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                        'DT_MinTemp': minTemp,
                        'DT_MaxTemp': maxTemp,


                    }

                    //     const insertDetailObj = {
                    //         str_tableName: detailTable,
                    //         data: [
                    //             { str_colName: 'RepSerNo', value: lastInsertedID },
                    //             { str_colName: 'MstSerNo', value: 0 },
                    //             { str_colName: 'RecSeqNo', value: i + 1 },
                    //             { str_colName: 'DT_Side', value: jarType == "A" ? "LHS" : "RHS" },
                    //             { str_colName: 'DT_BasketID', value: 0 },
                    //             { str_colName: 'DT_Temp', value: dtVal.temp },
                    //             { str_colName: 'DT_StartTm', value: startTime },
                    //             { str_colName: 'DT_EndTm', value: endTm },
                    //             { str_colName: 'DT_TimeMinSec', value: 0 },
                    //             // { str_colName: 'DT_RunTime', value: runTime },
                    //             { str_colName: 'DT_RunTime', value: dtVal.data.trim() },
                    //             { str_colName: 'DT_Remark', value: 0 },
                    //             { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
                    //             { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
                    //             { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
                    //             { str_colName: 'DT_HaltDur', value: "00:00:00" }
                    //         ]
                    //     }
                    //     await database.save(insertDetailObj);
                    // }
                    startTime = startTimeB;
                    endTime = endTimeB;

                    var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
                    endDate = timeStatus ? startDate : date.format(now, 'YYYY-MM-DD');
                    // let bRepSerNo = await this.getMaxBRepSerNo(dataObj.objProductDetails.ProductName, dataObj.objProductDetails.Batch,hmiDetailsInPMenu.Sys_RptType, strTableName)


                    // const insertObj = await models[strTableName].create({
                    //     'MstSerNo': 0,
                    //     'InstruId': 1,
                    //     'BFGCode': dataObj.objProductDetails.ProductId,
                    //     'ProductName': dataObj.objProductDetails.ProductName,
                    //     'ProductType': objProductDetails.ProductType,
                    //     'Qty': 6,
                    //     'GrpQty': 0,
                    //     'GrpFreq': 0,
                    //     'Idsno': strHmi,
                    //     'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                    //     'BalanceId': 0,
                    //     'BalanceNo': 0,
                    //     //'VernierId': hmiDetailsInPMenu.Sys_VernierID ,
                    //     'VernierNo': 0,
                    //     'BatchNo': dataObj.objProductDetails.Batch,
                    //     'UserId': dataObj.objProductDetails.userid,
                    //     'UserName': dataObj.objProductDetails.userName,
                    //     'PrDate': date.format(now, 'YYYY-MM-DD'),
                    //     'PrTime': startTime ,
                    //     'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                    //     'PrEndTime': endTime ,
                    //     'Side': side,
                    //     'Unit': '123',
                    //     'DecimalPoint': '0',
                    //     'WgmtModeNo': 1,
                    //     'Nom': intNominal,
                    //     'T1NegTol': objProductDetails.T1Neg,
                    //     'T1PosTol': objProductDetails.T1Pos,
                    //     'MinTemp': minTemp,
                    //     'MaxTemp': maxTemp,
                    //     'limitOn': 0,
                    //     //'T1NMTTab': objProductDetails.NMT ,
                    //     'NomEmpty': 0,
                    //     'T1NegEmpty': 0,
                    //     'T1PosEmpty': 0,
                    //     //'T2NegEmpty': 0 ,
                    //     //'T2PosEmpty': 0 ,
                    //     'NomNet': 0,
                    //     'T1NegNet': 0,
                    //     'T1PosNet': 0,
                    //     //'T2NegNet': 0 ,
                    //     //'T2PosNet': 0 ,
                    //     'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                    //     'ReportType': 0,
                    //     'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                    //     //'MFGCode': hmiDetailsInPMenu.Sys_MfgCode ,
                    //     'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
                    //     //'FriabilityID': hmiDetailsInPMenu.Sys_FriabID ,
                    //     //'HardnessID': hmiDetailsInPMenu.Sys_HardID ,
                    //     'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                    //     'Media':hmiDetailsInPMenu.Sys_media,
                    //     //'CubicleLocation': hmiDetailsInPMenu.Sys_Location ,
                    //     'RepoLabel10': 'Standard',
                    //     'RepoLabel11': 0,
                    //     'RepoLabel12': 'Null',
                    //     'RepoLabel13': 'Null',
                    //     'PrintNo': 0,
                    //     'IsArchived': 0,
                    //     'GraphType': 0,
                    //     'BatchComplete': 0,
                    //     'PVersion': hmiDetailsInPMenu.Sys_PVersion,
                    //     'Version': hmiDetailsInPMenu.Sys_Version,
                    //     //'CheckedByID': objProductDetails.userid ,
                    //     //'CheckedByName': objProductDetails.userName ,
                    //     //'CheckedByDate': date.format(now, 'YYYY-MM-DD') ,
                    //     'BRepSerNo': bRepSerNo,
                    //     //'Lot': hmiDetailsInPMenu.Sys_LotNo ,
                    //     'Area': hmiDetailsInPMenu.Sys_Area,
                    //     'DTID':DTIdDTId,
                    //     'Interval':dataObj.objProductDetails.interval
                    // });
                    // let arrResult = insertObj

                    /* inserting Data of double rotatry for B*/
                    // const insertObj = {
                    //     str_tableName: strTableName,
                    //     data: [
                    //        'MstSerNo': 0 },
                    //        'InstruId': 1 },
                    //         { str_colName: 'BFGCode': dataObj.objProductDetails.ProductId },
                    //         { str_colName: 'ProductName': dataObj.objProductDetails.ProductName },
                    //         { str_colName: 'ProductType': objProductDetails.ProductType },
                    //         { str_colName: 'Qty': 6 },
                    //         { str_colName: 'GrpQty': 0 },
                    //         { str_colName: 'GrpFreq', value: 0 },
                    //         { str_colName: 'Idsno', value: strIdsNo },
                    //         { str_colName: 'CubicalNo', value: hmiDetailsInPMenu.Sys_CubicNo },
                    //         { str_colName: 'BalanceId', value: 0 },
                    //         { str_colName: 'BalanceNo', value: 0 },
                    //         // { str_colName: 'VernierId', value: hmiDetailsInPMenu.Sys_VernierID },
                    //         { str_colName: 'VernierNo', value: 0 },
                    //         { str_colName: 'BatchNo', value: dataObj.objProductDetails.Batch },
                    //         { str_colName: 'UserId', value: dataObj.objProductDetails.userid },
                    //         { str_colName: 'UserName', value: dataObj.objProductDetails.userName },
                    //         { str_colName: 'PrDate', value: startDate },
                    //         { str_colName: 'PrTime', value: startTime },
                    //         { str_colName: 'PrEndDate', value: endDate },
                    //         { str_colName: 'PrEndTime', value: endTime },
                    //         { str_colName: 'Side', value: side },
                    //         { str_colName: 'Unit', value: '123' },
                    //         { str_colName: 'DecimalPoint', value: '0' },
                    //         { str_colName: 'WgmtModeNo', value: 1 },
                    //         { str_colName: 'Nom', value: intNominal },
                    //         { str_colName: 'T1NegTol', value: objProductDetails.T1Neg },
                    //         { str_colName: 'T1PosTol', value: objProductDetails.T1Pos },
                    //         { str_colName: 'MinTemp', value: minTemp },
                    //         { str_colName: 'MaxTemp', value: maxTemp },
                    //         { str_colName: 'limitOn', value: 0 },
                    //         // { str_colName: 'T1NMTTab', value: objProductDetails.NMT },
                    //         { str_colName: 'NomEmpty', value: 0 },
                    //         { str_colName: 'T1NegEmpty', value: 0 },
                    //         { str_colName: 'T1PosEmpty', value: 0 },
                    //         // { str_colName: 'T2NegEmpty', value: 0 },
                    //         // { str_colName: 'T2PosEmpty', value: 0 },
                    //         { str_colName: 'NomNet', value: 0 },
                    //         { str_colName: 'T1NegNet', value: 0 },
                    //         { str_colName: 'T1PosNet', value: 0 },
                    //         // { str_colName: 'T2NegNet', value: 0 },
                    //         // { str_colName: 'T2PosNet', value: 0 },
                    //         { str_colName: 'CubicleType', value: hmiDetailsInPMenu.Sys_CubType },
                    //         { str_colName: 'ReportType', value: 0 },
                    //         { str_colName: 'MachineCode', value: hmiDetailsInPMenu.Sys_MachineCode },
                    //         // { str_colName: 'MFGCode', value: hmiDetailsInPMenu.Sys_MfgCode },
                    //         { str_colName: 'BatchSize', value: hmiDetailsInPMenu.Sys_BatchSize },
                    //         // { str_colName: 'FriabilityID', value: hmiDetailsInPMenu.Sys_FriabID },
                    //         // { str_colName: 'HardnessID', value: hmiDetailsInPMenu.Sys_HardID },
                    //         { str_colName: 'CubicleName', value: hmiDetailsInPMenu.Sys_CubicName },
                    //         // { str_colName: 'CubicleLocation', value: hmiDetailsInPMenu.Sys_Location },
                    //         { str_colName: 'RepoLabel10', value: 'Standard' },
                    //         { str_colName: 'RepoLabel11', value: 0 },
                    //         { str_colName: 'RepoLabel12', value: 'Null' },
                    //         { str_colName: 'RepoLabel13', value: 'Null' },
                    //         { str_colName: 'PrintNo', value: 0 },
                    //         { str_colName: 'IsArchived', value: 0 },
                    //         { str_colName: 'GraphType', value: 0 },
                    //         { str_colName: 'BatchComplete', value: 0 },
                    //         { str_colName: 'PVersion', value: hmiDetailsInPMenu.Sys_PVersion },
                    //         { str_colName: 'Version', value: hmiDetailsInPMenu.Sys_Version },
                    //         // { str_colName: 'CheckedByID', value: objProductDetails.userid },
                    //         // { str_colName: 'CheckedByName', value: objProductDetails.userName },
                    //         // { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD') },
                    //         { str_colName: 'BRepSerNo', value: 0 },
                    //         // { str_colName: 'Lot', value: hmiDetailsInPMenu.Sys_LotNo },
                    //         { str_colName: 'Area', value: hmiDetailsInPMenu.Sys_Area },
                    //         // { str_colName: 'DTID', value:DTId }
                    //     ]


                    insertDetailObj = await models[detailTable].create({

                        'RepSerNo': lastInsertedID,
                        'MstSerNo': 0,
                        'RecSeqNo': i + 1,
                        'DT_ID': DTId,
                        'DT_Side': "LHS",
                        'DT_BasketID': 0,
                        'DT_Temp': BathTemp,
                        'DT_StartTm': startTime,
                        'DT_EndTm': endTm,
                        'DT_TimeMinSec': 0,
                        // 'DT_RunTime': runTime ,
                        'DT_RunTime': dtVal.data.trim(),
                        'DT_Remark': le,
                        'DT_DoneByID': tempUserObject.UserId,
                        'DT_DoneByName': tempUserObject.UserName,
                        'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
                        'DT_HaltDur': "00:00:00",
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                        'DT_Jar': 'A'
                    });
                }
                let arrResult = insertObj;
                let lastInsertedIDJarB = arrResult.RepSerNo
                //var lastInsertedIDJarB = resultCompleteDataJarB[0].insertId;
                for (const [i, dtVal] of jar_B_Arr.entries()) {

                    var endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.data.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.data.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.data.trim().split(":")[0], 'hours').format("HH:mm:ss");

                    let res;
                    let resp;
                    let obj1;
                    let max;
                    for (const [i, dtVal] of jar_B_Arr.entries()) {
                        if (dtVal != null) {

                            for (const [i, dtVal1] of jar_B_Arr.entries()) {
                                if (dtVal != dtVal1) {
                                    if (resp != undefined) {
                                        if (resp > dtVal1) {
                                            resp = dtVal
                                        }
                                        if (resp < dtVal1) {
                                            max = dtVal
                                        }
                                    }
                                    else {
                                        if (dtVal < dtVal1) {
                                            resp = dtVal
                                        }
                                        if (dtVal > dtVal1) {
                                            max = dtVal
                                        }
                                    }

                                }
                            }
                        }
                    }



                    var maxTime = '00:00:00';
                    for (let i = 0; i < jarB_Arr.length; i++) {
                        let c_h = Number(jarB_Arr[i].substring(0, 2));
                        let c_m = Number(jarB_Arr[i].substring(3, 5));
                        let c_s = Number(jarB_Arr[i].substring(6, 8));

                        let s_h = Number(maxTime.substring(0, 2));
                        let s_m = Number(maxTime.substring(3, 5));
                        let s_s = Number(maxTime.substring(6, 8));

                        if (c_h > s_h) {
                            maxTime = jarB_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m > s_m) {
                                maxTime = jarB_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s > s_s) {
                                    maxTime = jarB_Arr[i];
                                }
                            }
                        }

                    }
                    var minTime = maxTime;
                    for (let i = 0; i < jarB_Arr.length; i++) {
                        let c_h = Number(jarB_Arr[i].substring(0, 2));
                        let c_m = Number(jarB_Arr[i].substring(3, 5));
                        let c_s = Number(jarB_Arr[i].substring(6, 8));

                        let s_h = Number(minTime.substring(0, 2));
                        let s_m = Number(minTime.substring(3, 5));
                        let s_s = Number(minTime.substring(6, 8));

                        if (c_h < s_h) {
                            minTime = jarB_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m < s_m) {
                                minTime = jarB_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s < s_s) {
                                    minTime = jarB_Arr[i];
                                }
                            }
                        }

                    }




                    // const insertDetailObj = {
                    //     str_tableName: detailTable,
                    //     data: [
                    //         { str_colName: 'RepSerNo', value: lastInsertedIDJarB },
                    //         { str_colName: 'MstSerNo', value: 0 },
                    //         { str_colName: 'RecSeqNo', value: i + 1 },
                    //         { str_colName: 'DT_Side', value: jarType == "A" ? "LHS" : "RHS" },
                    //         { str_colName: 'DT_BasketID', value: 0 },
                    //         { str_colName: 'DT_Temp', value: dtVal.temp },
                    //         { str_colName: 'DT_StartTm', value: startTime },
                    //         { str_colName: 'DT_EndTm', value: endTm },
                    //         { str_colName: 'DT_TimeMinSec', value: 0 },
                    //         { str_colName: 'DT_RunTime', value: dtVal.data.trim() },
                    //         { str_colName: 'DT_Remark', value: 0 },
                    //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
                    //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
                    //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
                    //         { str_colName: 'DT_HaltDur', value: "00:00:00" }
                    //     ]
                    // }

                    // var jarBRes = await database.save(insertDetailObj);

                    var JarBobj = {
                        // 'DT_HaltDur': "00:00:00",
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                        'DT_MinTemp': minTemp,
                        'DT_MaxTemp': maxTemp,


                    }


                    insertDetailObj = await models[detailTable].create({
                        'RepSerNo': lastInsertedIDJarB,
                        'MstSerNo': 0,
                        'RecSeqNo': i + 1,
                        'DT_ID': DTId,
                        'DT_Side': "RHS",
                        'DT_BasketID': 0,
                        'DT_Temp': BathTemp,
                        'DT_StartTm': startTime,
                        'DT_EndTm': endTm,
                        'DT_TimeMinSec': 0,
                        'DT_RunTime': dtVal.data.trim(),
                        'DT_Remark': 0,
                        'DT_DoneByID': tempUserObject.UserId,
                        'DT_DoneByName': tempUserObject.UserName,
                        'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
                        'DT_HaltDur': "00:00:00",
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                        'DT_Jar': 'B'
                        //
                    });
                }
                var jarBRes = insertDetailObj;
                /* end of  inserting Data of double rotatry for B*/
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0

                },
                    {
                        where: {
                            'Sys_IDSNo': strHmi
                        }

                    });
                // const objUpdateValidation = {
                //     str_tableName: "tbl_cubical",
                //     data: [
                //         { str_colName: 'Sys_Validation', value: 0 },
                //     ],
                //     condition: [
                //         { str_colName: 'Sys_IDSNo', value: strIdsNo },
                //     ]
                // }\
                let mainobj = {
                    JarA: JarAobj,
                    JarB: JarBobj
                }
                let mainobjA = {
                    JarA: JarAobj,

                }
                let mainobjB = {
                    JarA: JarBobj,

                }
                await objMonit.monit({
                    case: 'TestDTWeight',
                    Hmi: strHmi,
                    data: {
                        Weight: JarAobj,
                        Jar: "JAR A",
                        message: ""
                    }
                });
                await objMonit.monit({
                    case: 'TestDTWeight',
                    Hmi: strHmi,
                    data: {
                        Weight: JarBobj,
                        Jar: "JAR B",
                        message: ""
                    }
                });
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainobj)}`)



                hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData
                await objBatchSummary.saveBatchSummaryDT(lastInsertedID, lastInsertedIDJarB, hmiDetailsInPMenu, strHmi);
                // await database.update(objUpdateValidation);

                le = `Within limit`;
                let tempFlagAJar = false; // For time
                let tempFlagTemp = false // for Tempreture
                // for (const [i, dtVal] of jar_A_Arr.entries()) {
                //     if (parseInt(dtVal.data.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                //         tempFlagAJar = true;
                //     }
                // }
                // for (const [i, dtVal] of jar_B_Arr.entries()) {
                //     if (parseInt(dtVal.data.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                //         tempFlagAJar = true;
                //     }
                // }

                if ((parseFloat(dataObj.productType.T1Neg) > parseFloat(dataObj.ProtocolData.Jar_A_minTemp)) ||
                    (parseFloat(dataObj.productType.T1Neg) > parseFloat(dataObj.ProtocolData.Jar_B_minTemp)) ||
                    (parseFloat(dataObj.productType.T1Pos) < parseFloat(dataObj.ProtocolData.Jar_A_maxTemp)) ||
                    (parseFloat(dataObj.productType.T1Pos) < parseFloat(dataObj.ProtocolData.Jar_B_minTemp))) {
                    tempFlagTemp = true;
                }
                if (tempFlagTemp == true || tempFlagAJar == true) {
                    le = `Out of Limit`;
                }
                // if (lastInsertedID != null || lastInsertedID != undefined) {
                //     const updateEndTime = await models[strTableName].update({
                //         'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                //         'PrEndTime': date.format(now, 'HH:mm:ss')
                //     }, {
                //         where: {
                //             RepSerNo: lastInsertedID
                //         }
                //     });
                // }
                if (lastInsertedID != null || lastInsertedID != undefined) {
                    const updateEndTime = await models[strTableName].update({
                        'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                        'PrEndTime': date.format(now, 'HH:mm:ss'),
                        Remark: le
                    }, {
                        where: {
                            RepSerNo: lastInsertedID
                        }
                    });
                }
                obj.le = le
                obj.RepSerNo = lastInsertedID
                return obj;
            }
        } catch (error) {
            console.log(error)
            throw new Error(error)
        }
    }

    async insert_DT_Data_for_ElectroLabED3PO(dataObj) {
        try {
            const strTableName = dataObj.strTableName;
            const strHmi = dataObj.strHmi;
            const strIdsNo = dataObj.uniqueSerialNumber;
            const now = new Date();
            let jar_A_Arr = [];
            let jar_B_Arr = [];
            let minTemp, maxTemp, startTime, endTime, haltDuration, side;
            let objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            var menu = objSelMenu.menuName;
            const objProductDetails = objSelMenu.selectedProductDetail;
            const DTId = dataObj.strBalId;
            const ProtocolData = dataObj.ProtocolData;
            const ProtocolUnit = dataObj.ProtocolUnit;
            const ProtocolDecPoint = dataObj.ProtocolDecPoint;
            var intProductType = objSelMenu.selectedProductDetail.ProductType;
            var LotNo = dataObj.objProductDetails.lotno

            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let productObj = globalData.arrIdsInfo.find((k) => k.Hmi == strHmi).cubicalData;
            const intNominal = dataObj.objProductDetails.Nominal;
            var startTimedfromOBJ = dataObj.objProductDetails.Time;
            startTimedfromOBJ = moment().format(startTimedfromOBJ, ' hh:mm:ss ');
            var startDatefromOBJ = dataObj.objProductDetails.Date;
            startDatefromOBJ = moment().format('YYYY-MM-D', startDatefromOBJ);
            let jarType, endDate;
            if (dataObj.objProductDetails.Rotary == "Single") {
                side = "NA";
                jarType = dataObj.objProductDetails.Jar.split(" ")[1]
            } else if (dataObj.objProductDetails.Rotary == "Double") {
                side = dataObj.objProductDetails.Side
                jarType = "N";
            }

            let i = 1;
            let runtimeo = ProtocolData.testRunDuration
            for (let obj in ProtocolData.A_tempMax) {
                jar_A_Arr.push({ data: ProtocolData[`A_tempMax`], temp: ProtocolData[`A_tempMin`], })
                i++;
            }

            let obj = {
                Lhs: jar_A_Arr,
                // Rhs: jar_B_Arr
            }
            if (jar_A_Arr[0] == undefined) {
                var objcc = 'Invalid String recieved'
                return objcc
            }
            // if (dataObj.objProductDetails.Rotary == 'Double') {
            //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)

            // }

            const regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let startDate = dataObj.ProtocolData.Start_Date;
            startDate = startDate.split("/").reverse().join("-");
            let arrProductType = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
            let productDetail = arrProductType.productType;
            let maxVal = dataObj.ProtocolData.testRunDuration
            let paramDetails = arrProductType.productDetail;
            paramDetails = paramDetails[0][0]
            let le = "Report generated is Within limit";
            var result_data = 'Complies'
            // var all_date = {}
            // var insertObj
            // var arrResult
            // var lastInsertedID
            // var bRepSerNo
            // var tempFlagAJar = false; // For time
            // var tempFlagTemp = false

            //dynamically take from android
            let actualRunTime = productDetail.ProductType == 1 ? paramDetails.Param13_Nom : paramDetails.Param6_Nom;
            let completeTable = productDetail.ProductType == 1 ? 'tbl_tab_master13' : 'tbl_cap_master6';
            let detailTable = productDetail.ProductType == 1 ? 'tbl_tab_detail13' : 'tbl_cap_detail6';

            maxTemp = jar_A_Arr[0].data[0]
            minTemp = jar_A_Arr[0].data[0];
            startTime = dataObj.ProtocolData.startTime;
            endTime = dataObj.ProtocolData.endTime;
            //let regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
            // var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
            // endDate = timeStatus ? startDate : date.format(now, 'YYYY-MM-DD');
            let bRepSerNo = await this.getMaxBRepSerNo(dataObj.objProductDetails.ProductName, dataObj.objProductDetails.Batch, strTableName, hmiDetailsInPMenu.Sys_RptType)

            // let getProductTablets = await models.tbl_product_tablet.findAll({
            //     where: {
            //         ProductId: dataObj.objProductDetails.ProductId,
            //         ProductName: dataObj.objProductDetails.ProductName,
            //         ProductVersion: hmiDetailsInPMenu.Sys_PVersion,
            //         Version: hmiDetailsInPMenu.Sys_Version,
            //     }
            // })

            let getCubicalData = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: strHmi,
                }
            })
            // let area;
            // if( == "IPQC"){
            //     area = "IPQA I";
            // }
            // if(getCubicalData[0].Sys_Area == "IPQC"){
            //     area = "IPQA II";
            // }

            let min = dataObj.objProductDetails.T1Neg.split(' ')[0];
            let max = dataObj.objProductDetails.T1Pos.split(' ')[0];

            const insertObj = await models[strTableName].create({

                MstSerNo: 0,
                // WgmtModeNo: 13,
                // Area: getCubicalData[0].Sys_Area,
                Area: productObj.Sys_Area,
                IPQCType: getCubicalData[0].Sys_IPQCType,
                InstrumentID: hmiDetailsInPMenu.Sys_DTID,
                BFGCode: dataObj.objProductDetails.ProductId,
                ProductName: dataObj.objProductDetails.ProductName,
                ProductType: objProductDetails.ProductType,
                Qty: objProductDetails.noOfSamples,
                GrpQty: 0,
                GrpFreq: 0,
                Idsno: strHmi,
                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                Stage:productObj.Sys_Stage,
                Media_Temp: ProtocolData.BathTemp.split(" ")[0],
                // Bath_Temp: ProtocolData.BathTemp.split(" ")[0],
                // BalanceId: 0,
                //BalanceNo: 0,
                // 'VernierId': hmiDetailsInPMenu.Sys_VernierID,
                // VernierNo: 0,
                BatchNo: dataObj.objProductDetails.Batch,
                UserId: dataObj.objProductDetails.userId,
                UserName: dataObj.objProductDetails.userName,
                PrDate: startDate,
                PrTime: startTime,
                // PrEndDate: date.format(now, 'YYYY-MM-DD'),
                // PrEndTime: ProtocolData.endTime,
                Side: side,
                Unit: objProductDetails.unit,
                DecimalPoint: '0',
                WgmtModeNo: objProductDetails.ProductType == 1 ? 13 : 6,
                Nom: objProductDetails.nominal,
                T1NegTol: parseFloat(objProductDetails.T1Neg).toFixed(1),
                T1PosTol: parseFloat(objProductDetails.T1Pos).toFixed(1),
                MinTemp: maxTemp,
                MaxTemp: maxTemp,
                limitOn: 0,
                TempRange: parseFloat(min).toFixed(1) + " - " + parseFloat(max).toFixed(1),
                // 'T1NMTTab': objProductDetails.NMT,
                //NomEmpty: 0,
                //T1NegEmpty: 0,
                //T1PosEmpty: 0,
                // 'T2NegEmpty': 0,
                // 'T2PosEmpty': 0,
                //NomNet: 0,
                //T1NegNet: 0,
                //T1PosNet: 0,
                // 'T2NegNet': 0,
                // 'T2PosNet': 0,
                StdTime: dataObj.objProductDetails.Nominal,
                Department: hmiDetailsInPMenu.Sys_dept,
                CubicleType: hmiDetailsInPMenu.Sys_CubType,
                ReportType: hmiDetailsInPMenu.Sys_RptType,
                MachineCode: hmiDetailsInPMenu.Sys_MachineCode,
                // MFGCode: hmiDetailsInPMenu.Sys_Stage,
                BatchSize: hmiDetailsInPMenu.Sys_BatchSize,
                // 'FriabilityID': hmiDetailsInPMenu.Sys_FriabID,
                // 'HardnessID': hmiDetailsInPMenu.Sys_HardID,
                CubicleName: hmiDetailsInPMenu.Sys_CubicName,
                // 'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
                // RepoLabel10: 'Standard',
                //RepoLabel11: 0,
                //RepoLabel12: 'Null',
                //RepoLabel13: 'Null',
                PrintNo: 0,
                IsArchived: 0,
                GraphType: 0,
                BatchComplete: 0,
                PVersion: hmiDetailsInPMenu.Sys_PVersion,
                Version: hmiDetailsInPMenu.Sys_Version,
                Media: hmiDetailsInPMenu.Sys_media,
                // CheckedByID: dataObj.objProductDetails.userId,
                // CheckedByName: dataObj.objProductDetails.userName,
                // CheckedByDate: date.format(now, 'YYYY-MM-DD'),

                Lot: LotNo == undefined ? hmiDetailsInPMenu.Sys_LotNo : LotNo,
                // Area: hmiDetailsInPMenu.Sys_Area,
                //DTID: DTId,
                Jar: dataObj.objProductDetails.Jar.split(" ")[1],
                Basket_Type: ProtocolData.JarBasket,
                Apparatus_Type: ProtocolData.JarBasket,
                Layer: dataObj.layer,
                LayerName: dataObj.layer_name
                //Interval: dataObj.objProductDetails.interval
            });

            let arrResult = insertObj;


            let lastInsertedID = arrResult.RepSerNo;


            let startTimeval = moment(startTime, 'HH:mm:ss');
            // let endTimeval = moment(endTime, 'HH:mm:ss');
            let second1 = moment(startTimeval, "HH:mm:ss").add(runtimeo.trim().split(":")[2], 'seconds').format("HH:mm:ss")
            let minute1 = moment(second1, "HH:mm:ss").add(runtimeo.trim().split(":")[1], 'minutes').format("HH:mm:ss");
            let runTime = moment(minute1, "HH:mm:ss").add(runtimeo.trim().split(":")[0], 'hours').format("HH:mm:ss");
            // let runTime = moment(startTimeval, "HH:mm:ss").add(runtimeo, '"HH:mm:ss"').format("HH:mm:ss");
            let hDur = haltDuration;

            for (const [i, dtVal] of jar_A_Arr[0].data.entries()) {

                let endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                let endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                let endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
                let res;
                let resp;
                let obj1;
                let max;
                for (const [i, dtVal] of jar_A_Arr[0].data.entries()) {
                    if (dtVal != null) {

                        for (const [i, dtVal1] of jar_A_Arr[0].data.entries()) {
                            if (dtVal != dtVal1) {
                                if (resp != undefined) {
                                    if (resp > dtVal1) {
                                        resp = dtVal
                                    }
                                    if (resp < dtVal1) {
                                        max = dtVal
                                    }
                                }
                                else {
                                    if (dtVal < dtVal1) {
                                        resp = dtVal
                                    }
                                    if (dtVal > dtVal1) {
                                        max = dtVal
                                    }
                                }

                            }
                        }
                    }
                }

                const StartTime = moment.duration(startTime);
                const RunTime = moment.duration(runTime);
                const totalDuration = StartTime.add(RunTime);
                const formattedTotalDuration = runTime


                // var maxTime = '00:00:00';
                //     for (let i = 0; i < jarA_Arr.length; i++) {
                //         let c_h = Number(jarA_Arr[i].substring(0, 2));
                //         let c_m = Number(jarA_Arr[i].substring(3, 5));
                //         let c_s = Number(jarA_Arr[i].substring(6, 8));

                //         let s_h = Number(maxTime.substring(0, 2));
                //         let s_m = Number(maxTime.substring(3, 5));
                //         let s_s = Number(maxTime.substring(6, 8));

                //         if (c_h > s_h) {
                //             maxTime = jarA_Arr[i];
                //         } else if (c_h === s_h) {
                //             if (c_m > s_m) {
                //                 maxTime = jarA_Arr[i];
                //             } else if (c_m === s_m) {
                //                 if (c_s > s_s) {
                //                     maxTime = jarA_Arr[i];
                //                 }
                //             }
                //         }

                //     }
                //     var minTime = maxTime;
                //     for (let i = 0; i < jarA_Arr.length; i++) {
                //         let c_h = Number(jarA_Arr[i].substring(0, 2));
                //         let c_m = Number(jarA_Arr[i].substring(3, 5));
                //         let c_s = Number(jarA_Arr[i].substring(6, 8));

                //         let s_h = Number(minTime.substring(0, 2));
                //         let s_m = Number(minTime.substring(3, 5));
                //         let s_s = Number(minTime.substring(6, 8));

                //         if (c_h < s_h) {
                //             minTime = jarA_Arr[i];
                //         } else if (c_h === s_h) {
                //             if (c_m < s_m) {
                //                 minTime = jarA_Arr[i];
                //             } else if (c_m === s_m) {
                //                 if (c_s < s_s) {
                //                     minTime = jarA_Arr[i];
                //                 }
                //             }
                //         }

                //     }

                // var insertmasterobj = await models[strTableName].update({
                //     MinTime: minTime,
                //     MaxTime: maxTime
                // }, {
                //     where: {
                //         BatchNo: dataObj.objProductDetails.Batch,
                //         BFGCode: dataObj.objProductDetails.ProductId,
                //         ProductName: dataObj.objProductDetails.ProductName,
                //     }
                // });

                const insertDetailObj = await models[detailTable].create({

                    'RepSerNo': lastInsertedID,
                    'MstSerNo': 0,
                    'RecSeqNo': i + 1,
                    //'DT_ID': DTId,
                    'DT_Side': side,
                    //'DT_BasketID': jarType,
                    'DT_Temp': dtVal.trim(),
                    'DT_StartTm': startTime,
                    // 'DT_EndTm': endTime,
                    'DT_EndTm': formattedTotalDuration,
                    //'DT_TimeMinSec': 0,
                    'DT_RunTime': runtimeo,
                    // 'DT_RunTime': dtVal.trim(),
                    'DT_Remark': 0,
                    'DT_DoneByID': tempUserObject.UserId,
                    'DT_DoneByName': tempUserObject.UserName,
                    'DT_StartDate': startDate,
                    'DT_HaltDur': ProtocolData.testHaltDuration,
                    //'DT_MinVal': "00:00:00",
                    //'DT_MaxVal': maxVal,
                    'DT_Jar': jarType,
                    'Layer': dataObj.layer,
                    'LayerName': dataObj.layer_name
                });

                let detailRes = await models[detailTable].findAll({
                    attributes: [[sequelize.fn('max', sequelize.col('DT_RunTime')), 'DT_RunTime']],
                    where: {
                        RepSerNo: lastInsertedID,
                    }
                });

                let updateMaster = await models[strTableName].update({
                    MaxTime: detailRes[0].DT_RunTime,
                    MinTime: detailRes[0].DT_RunTime,
                }, {
                    where: {
                        BatchNo: dataObj.objProductDetails.Batch,
                        // BFGCode: dataObj.objProductDetails.ProductId,
                        ProductName: dataObj.objProductDetails.ProductName,
                        Idsno: dataObj.objProductDetails.Hmi,
                        RepSerNo: lastInsertedID
                    }
                })

                // let obj = {
                //     testHaltDuration: ProtocolData.testHaltDuration,
                //     testRunDuration: ProtocolData.testRunDuration,
                //     A_tempMax: ProtocolData.A_tempMax,
                //     // data : ProtocolData
                // }
                var Jarobj = {
                    'DT_HaltDur': ProtocolData.testHaltDuration,
                    'DT_MinVal': runtimeo,
                    'DT_MaxVal': runtimeo,
                    'DT_MinTemp': maxTemp,
                    'DT_MaxTemp': maxTemp,
                }
                var jar = "Jar" + jarType.toString()
                var mainObj = {
                    [jar]: Jarobj
                    // JarB: JarBobj
                }

                // const insertDetailObj = {
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`)
                //     str_tableName: detailTable,
                //     data: [
                //         { str_colName: 'RepSerNo', value: lastInsertedID },
                //         { str_colName: 'MstSerNo', value: 0 },
                //         { str_colName: 'RecSeqNo', value: i + 1 },
                //         { str_colName: 'DT_Side', value: "LHS" },
                //         { str_colName: 'DT_BasketID', value: 0 },
                //         { str_colName: 'DT_Temp', value: jar_A_Arr[0].temp },
                //         { str_colName: 'DT_StartTm', value: startTime },
                //         { str_colName: 'DT_EndTm', value: endTm },
                //         { str_colName: 'DT_TimeMinSec', value: 0 },
                //         // { str_colName: 'DT_RunTime', value: runTime },
                //         { str_colName: 'DT_RunTime', value: dtVal.trim() },
                //         { str_colName: 'DT_Remark', value: 0 },
                //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
                //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
                //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
                //         { str_colName: 'DT_HaltDur', value: "00:00:00" }
                //     ]
                // }
                // await database.save(insertDetailObj);
            }
            // const objUpdateValidation = {
            //     str_tableName: "tbl_cubical",
            //     data: [
            //         { str_colName: 'Sys_Validation', value: 0 },
            //     ],
            //     condition: [
            //         { str_colName: 'Sys_IDSNo', value: strIdsNo },
            //     ]
            // }
            // await database.update(objUpdateValidation);
            let tempFlagAJar = false; // For time
            let tempFlagTemp = false // for Tempreture
            for (const [i, dtVal] of jar_A_Arr[0].data.entries()) {
                if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                    tempFlagAJar = true;
                }
            }
            // if (((parseFloat(dataObj.productType.T1Neg) > parseFloat(minTemp)) ||
            //     (parseFloat(dataObj.productType.T1Pos) < parseFloat(maxTemp))  ||
            //     (parseFloat(dataObj.productType.T1Neg) > parseFloat(ProtocolData.BathTemp.split(" ")[0])) ||
            //     (parseFloat(dataObj.productType.T1Pos) < parseFloat(ProtocolData.BathTemp.split(" ")[0])))) {
            //     tempFlagTemp = true;
            // }
            if (((parseFloat(dataObj.objProductDetails.T1Neg) > parseFloat(minTemp)) ||
                (parseFloat(dataObj.objProductDetails.T1Pos) < parseFloat(maxTemp)))) {
                tempFlagTemp = true;
            }
            if (runtimeo > objProductDetails.nominal) {
                tempFlagAJar = true
            }
            if (tempFlagTemp == true || tempFlagAJar == true) {
                le = "Report generated is out of limit"
                result_data = 'Not Complies'
            }
            if (lastInsertedID != null || lastInsertedID != undefined) {
                const updateEndTime = await models[strTableName].update({
                    'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                    'PrEndTime': date.format(now, 'HH:mm:ss'),
                    "Remark": result_data
                }, {
                    where: {
                        RepSerNo: lastInsertedID
                    }
                });
            }

            if (result_data == "Not Complies") {
                var reportLimitMsg = "Report Out Of Limit"
            }
            else {
                reportLimitMsg = "Report Within Limit"
            }

            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${reportLimitMsg}`);
            mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);

            //  setTimeout(() => {
            //     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${reportLimitMsg}`);
            // }, 500);



            const returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strHmi, objProductDetails);
            const objUpdateValidation = await models.tbl_cubical.update({
                'Sys_Validation': 0
            },
                {
                    where: {
                        'Sys_IDSNo': strHmi
                    }

                });
            // if (lastInsertedIDJarB != null || lastInsertedIDJarB != undefined) {
            //     const updateEndTime = await models[strTableName].update({
            //         'PrEndDate': date.format(new Date(), 'YYYY-MM-DD'),
            //         'PrEndTime': date.format(new Date(), 'HH:mm:ss')
            //     }, {
            //         where: {
            //             RepSerNo: lastInsertedIDJarB
            //         }
            //     })
            // }

            obj.le = le
            obj.Lhs = obj.Lhs.map(k => k.data[0])
            obj.RepSerNo = lastInsertedID
            if (!le.includes('out')) {
                var printObj = {
                    recordFrom: "Current",
                    Side: side,
                    reportOption: menu,
                    reportType: "Complete",
                    testType: "Regular",
                    RepSerNo: lastInsertedID,
                    batchNo: hmiDetailsInPMenu.Sys_Batch,
                    cubicleType: hmiDetailsInPMenu.Sys_CubType,
                    userId: tempUserObject.UserId,
                    username: tempUserObject.UserName,
                    int_ReportFormat: 1,
                    printNo: 1,
                    str_url: intProductType === 1 ? "Tablet" : "Capsule"
                }

                await printOperations.callViewTabReport(printObj, intProductType, strHmi)
            }
            return obj;
        } catch (error) {
            console.log(error);
            throw new Error(error)
        }
    }

    async addTwoTimes(Tm1, Tm2) {
        var a = Tm1.split(":");
        var seconds = +a[0] * 60 * 60 + +a[1] * 60 + +a[2];
        var b = Tm2.split(":");
        var seconds2 = +b[0] * 60 * 60 + +b[1] * 60 + +b[2];

        var date = new Date(1970, 0, 1);
        date.setSeconds(seconds + seconds2);

        var c = date.toTimeString().replace(/.*(\d{2}:\d{2}:\d{2}).*/, "$1");
        return c;
    }

    async insertIntoDetailTable(DT_ID, jarDetail, testRemark, actualRunTime, startDate, startTime, detailTable, lastInsertedID, tempUserObject, side, DTHalt = '00:00:00') {
        try {

            const regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/

            for (const [i, dtVal] of jarDetail.entries()) {

                let endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.data.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                let endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.data.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                let endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.data.trim().split(":")[0], 'hours').format("HH:mm:ss");

                if (parseInt(dtVal.data.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3")))
                    testRemark = "Report generated is out of limit"

                await models[detailTable].create({

                    RepSerNo: lastInsertedID,
                    MstSerNo: 0,
                    RecSeqNo: i + 1,
                    DT_Side: side,
                    DT_BasketID: 0,
                    DT_Temp: dtVal.temp == undefined ? 0 : dtVal.temp,
                    DT_StartTm: startTime,
                    DT_EndTm: endTm,
                    DT_TimeMinSec: 0,
                    DT_ID: DT_ID,
                    DT_RunTime: dtVal.data.trim(),
                    DT_Remark: 0,
                    DT_DoneByID: tempUserObject.UserId,
                    DT_DoneByName: tempUserObject.UserName,
                    DT_StartDate: startDate,
                    DT_HaltDur: DTHalt
                })

            }

        } catch (error) {
            throw new Error(error)
        }
    }
    async insert_DT_Data(dataObj) {
        try {
            const strTableName = dataObj.strTableName;
            const strIdsNo = dataObj.uniqueSerialNumber;
            const detailTable = dataObj.detailTable
            const strHmi = dataObj.strHmi;
            var menuName = dataObj.menuName
            var layer = dataObj.layer
            var layer_name = dataObj.layer_name
            var typeValues = dataObj.typeValue
            var actucaltimes = dataObj.actucaltime
            const now = new Date();
            let jar_A_Arr = [];
            let jar_B_Arr = [];
            let minTemp, maxTemp, startTime, endTime, haltDuration, side, minTempB, maxTempB, settemp, SetTempA, SetTempB
            let objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            const objProductDetails = objSelMenu.selectedProductDetail;
            const intProductType = objSelMenu.selectedProductDetail.ProductType
            const DTId = dataObj.strBalId;
            const ProtocolData = dataObj.ProtocolData;
            const ProtocolUnit = dataObj.ProtocolUnit;
            const ProtocolDecPoint = dataObj.ProtocolDecPoint;
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            const intNominal = dataObj.objProductDetails.Nominal;
            var startTimedfromOBJ = dataObj.objProductDetails.Time;
            var LotNo = dataObj.objProductDetails.lotno
            startTimedfromOBJ = moment().format(startTimedfromOBJ, ' hh:mm:ss ');
            var startDatefromOBJ = dataObj.objProductDetails.Date;
            startDatefromOBJ = moment().format('YYYY-MM-D', startDatefromOBJ);
            let jarType, endDate;
            if (dataObj.objProductDetails.Rotary == "Single") {
                side = "NA";
                jarType = dataObj.objProductDetails.Jar.trim().charAt(dataObj.objProductDetails.Jar.length - 1)
            } else if (dataObj.objProductDetails.Rotary == "Double") {
                side = "LHS/RHS";
                jarType = "N";
            }
            // if(dataObj.objProductDetails.Rotary == 'Single'){
            //     if(ProtocolData.Jar_A_maxTemp  != undefined  && jarType == 'B'){
            //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
            //     }
            //         if(ProtocolData.Jar_B_maxTemp  != undefined && jarType == 'A'){
            //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
            // }
            // }
            // if(dataObj.objProductDetails.Rotary == 'Double'){
            //     if(ProtocolData.start_time_Jar_A  == 'N.A' && ProtocolData.start_time_Jar_B == 'N.A' && jarType != 'N'){
            //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
            //     }
            // }


            let i = 1;
            for (let obj in ProtocolData) {
                if (ProtocolData.hasOwnProperty(`${i}_SampleLHS`)) {
                    if (ProtocolData[`${i}_SampleLHS`] !== "") {
                        jar_A_Arr.push(ProtocolData[`${i}_SampleLHS`])
                    }
                    if (ProtocolData.hasOwnProperty(`${i}_SampleRHS`)) {
                        if (ProtocolData[`${i}_SampleRHS`] !== "") {
                            jar_B_Arr.push(ProtocolData[`${i}_SampleRHS`])
                        }
                    }
                    i++;
                }
            }

            let obj = {
                mainData: ProtocolData,
                Lhs: jar_A_Arr,
                Rhs: jar_B_Arr
            }
            if (dataObj.objProductDetails.Rotary == "Single") {
                if (jarType == "A") {
                    obj = {
                        Lhs: jar_A_Arr,
                    }
                } else if (jarType == "B") {
                    obj = {
                        Rhs: jar_B_Arr,
                    }
                }
            }
            const regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let startDate = dataObj.ProtocolData.Start_Date;
            startDate = startDate.split("/").reverse().join("-");
            let arrProductType = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
            let productDetail = arrProductType.productType;
            let remark = "Within limit";
            let paramDetails = arrProductType.productDetail;
            paramDetails = paramDetails[0][0]
            let le = "Report generated is Within limit";
            var result_data = 'Complies'
            var all_date = {}
            var insertObj
            var arrResult
            var lastInsertedID
            var bRepSerNo
            var tempFlagAJar = false; // For time
            var tempFlagTemp = false
            //dynamically take from android
            let actualRunTime = actucaltimes


            let completeTable = productDetail.ProductType == 1 ? 'tbl_tab_master13' : 'tbl_cap_master6';
            let detailTable1 = productDetail.ProductType == 1 ? 'tbl_tab_detail13' : 'tbl_cap_detail6';
            if (dataObj.objProductDetails.Rotary == 'Single') {
                if (jarType == "A") {
                    minTemp = Number(dataObj.ProtocolData.Jar_A_minTemp).toFixed(1);
                    maxTemp = Number(dataObj.ProtocolData.Jar_A_maxTemp).toFixed(1);
                    startTime = dataObj.ProtocolData.start_time_Jar_A;
                    endTime = dataObj.ProtocolData.end_time_Jar_A;
                    haltDuration = dataObj.ProtocolData.HALT_DUR_JAR_A;
                    settemp = Number(dataObj.ProtocolData.SetTempA).toFixed(1);

                } else if (jarType == "B") {
                    minTemp = Number(dataObj.ProtocolData.Jar_B_minTemp).toFixed(1);
                    maxTemp = Number(dataObj.ProtocolData.Jar_B_maxTemp).toFixed(1);
                    startTime = dataObj.ProtocolData.start_time_Jar_B;
                    endTime = dataObj.ProtocolData.end_time_Jar_B;
                    haltDuration = dataObj.ProtocolData.HALT_DUR_JAR_B;
                    settemp = Number(dataObj.ProtocolData.SetTempB).toFixed(1);
                }
            } else {
                minTemp = Number(dataObj.ProtocolData.Jar_A_minTemp).toFixed(1);
                maxTemp = Number(dataObj.ProtocolData.Jar_A_maxTemp).toFixed(1);
                minTempB = Number(dataObj.ProtocolData.Jar_B_minTemp).toFixed(1);
                maxTempB = Number(dataObj.ProtocolData.Jar_B_maxTemp).toFixed(1);
                startTime = dataObj.ProtocolData.start_time_Jar_A;
                endTime = dataObj.ProtocolData.end_time_Jar_B;
                haltDuration = dataObj.ProtocolData.HALT_DUR_JAR_A
                SetTempA = Number(dataObj.ProtocolData.SetTempA).toFixed(1);
                SetTempB = Number(dataObj.ProtocolData.SetTempB).toFixed(1);
            }
            bRepSerNo = await this.getMaxBRepSerNo(dataObj.objProductDetails.ProductName, dataObj.objProductDetails.Batch, strTableName, hmiDetailsInPMenu.Sys_RptType)
            if (dataObj.objProductDetails.Rotary == 'Single') {
                insertObj = await models[strTableName].create({
                    'MstSerNo': 0,
                    'InstruId': 1,
                    'BFGCode': dataObj.objProductDetails.ProductId,
                    'ProductName': dataObj.objProductDetails.ProductName,
                    'ProductType': objProductDetails.ProductType,
                    'Qty': objProductDetails.noOfSamples,
                    'Department': hmiDetailsInPMenu.Sys_dept,
                    'IPQCType': hmiDetailsInPMenu.Sys_IPQCType,
                    'GrpQty': 0,
                    'GrpFreq': 0,
                    'Stage' :hmiDetailsInPMenu.Sys_Stage,
                    'Idsno': strHmi,
                    'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                    'BalanceId': 0,
                    'BalanceNo': 0,
                    'VernierNo': 0,
                    'BatchNo': dataObj.objProductDetails.Batch,
                    'UserId': dataObj.objProductDetails.userId,
                    'UserName': dataObj.objProductDetails.userName,
                    'PrDate': startDate,
                    'PrTime': startTime,
                    // 'PrEndDate': '1992-12-08',
                    // 'PrEndTime': '',
                    'Side': side,
                    'Unit': hmiDetailsInPMenu.Sys_BatchSizeUnit,
                    'DecimalPoint': '0',
                    'WgmtModeNo': typeValues,
                    'Nom': intNominal,
                    'T1NegTol': Number(objProductDetails.T1Neg).toFixed(1),
                    'T1PosTol': Number(objProductDetails.T1Pos).toFixed(1),
                    'TempRange': Number(objProductDetails.T1Neg).toFixed(1) + " - " + Number(objProductDetails.T1Pos).toFixed(1),
                    'MinTemp': minTemp,
                    'MaxTemp': maxTemp,
                    'limitOn': 0,
                    'T1NMTTab': objProductDetails.NMT,
                    'NomEmpty': 0,
                    'T1NegEmpty': 0,
                    'T1PosEmpty': 0,
                    //  'T2NegEmpty': 0 ,
                    //  'T2PosEmpty': 0 ,
                    'NomNet': 0,
                    'T1NegNet': 0,
                    'T1PosNet': 0,
                    //  'T2NegNet': 0 ,
                    //  'T2PosNet': 0 ,
                    'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                    'ReportType': hmiDetailsInPMenu.Sys_RptType,
                    'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                    'Media': hmiDetailsInPMenu.Sys_media,
                    'Media_Temp': settemp, //settemp
                    'MeshSize_Bolus': dataObj.ProtocolData.Mode, // mode 
                    // 'Bath_Temp': BathTemp,
                    'MFGCode': hmiDetailsInPMenu.Sys_Stage,
                    'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
                    //  'FriabilityID': hmiDetailsInPMenu.Sys_FriabID ,
                    //  'HardnessID': hmiDetailsInPMenu.Sys_HardID ,
                    'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                    'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
                    'RepoLabel10': 'Standard',
                    'RepoLabel11': 0,
                    'RepoLabel12': 'Null',
                    'RepoLabel13': 'Null',
                    'PrintNo': 0,
                    'IsArchived': 0,
                    'GraphType': 0,
                    'BatchComplete': 0,
                    'PVersion': hmiDetailsInPMenu.Sys_PVersion,
                    'Version': hmiDetailsInPMenu.Sys_Version,
                    //  'CheckedByID': objProductDetails.userid ,
                    //  'CheckedByName': objProductDetails.userName ,
                    //  'CheckedByDate': date.format(now, 'YYYY-MM-DD') ,
                    'BRepSerNo': bRepSerNo,
                    'Lot': LotNo == undefined ? hmiDetailsInPMenu.Sys_LotNo : LotNo,
                    'Area': hmiDetailsInPMenu.Sys_Area,
                    'InstrumentID': DTId,
                    'Jar': jarType,
                    'Basket_Type': ProtocolData.JarBasketA,
                    'Apparatus_Type': ProtocolData.JarBasketA,
                    "Layer": layer,
                    "LayerName": layer_name,
                    'Inprocess': 0,
                });
                arrResult = (insertObj);
                lastInsertedID = arrResult.RepSerNo;
            }
            if (jarType == "A") {
                let startTimeval = moment(startTime, 'HH:mm:ss');
                let endTimeval = moment(endTime, 'HH:mm:ss');
                let runTime = moment.utc(moment(endTimeval, "HH:mm:ss")
                    .diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
                let hDur = haltDuration;

                for (const [i, dtVal] of jar_A_Arr.entries()) {

                    let endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    let endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");

                    let res;
                    var resp;
                    let obj1;
                    var max;




                    // let times = ['04:30:45','16:40:45','12:20:50','15:10:10'];
                    var maxTime = '00:00:00';
                    for (let i = 0; i < jar_A_Arr.length; i++) {
                        let c_h = Number(jar_A_Arr[i].substring(0, 2));
                        let c_m = Number(jar_A_Arr[i].substring(3, 5));
                        let c_s = Number(jar_A_Arr[i].substring(6, 8));

                        let s_h = Number(maxTime.substring(0, 2));
                        let s_m = Number(maxTime.substring(3, 5));
                        let s_s = Number(maxTime.substring(6, 8));

                        if (c_h > s_h) {
                            maxTime = jar_A_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m > s_m) {
                                maxTime = jar_A_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s > s_s) {
                                    maxTime = jar_A_Arr[i];
                                }
                            }
                        }

                    }
                    var minTime = maxTime;
                    for (let i = 0; i < jar_A_Arr.length; i++) {
                        let c_h = Number(jar_A_Arr[i].substring(0, 2));
                        let c_m = Number(jar_A_Arr[i].substring(3, 5));
                        let c_s = Number(jar_A_Arr[i].substring(6, 8));

                        let s_h = Number(minTime.substring(0, 2));
                        let s_m = Number(minTime.substring(3, 5));
                        let s_s = Number(minTime.substring(6, 8));

                        if (c_h < s_h) {
                            minTime = jar_A_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m < s_m) {
                                minTime = jar_A_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s < s_s) {
                                    minTime = jar_A_Arr[i];
                                }
                            }
                        }

                    }

                }
                for (const [i, dtVal] of jar_A_Arr.entries()) {

                    var endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    const insertDetailObj = await models[detailTable].create({
                        'RepSerNo': lastInsertedID,
                        'MstSerNo': 0,
                        'RecSeqNo': i + 1,
                        'DT_ID': DTId,
                        'DT_Side': 'NA',
                        'DT_BasketID': 0,
                        'DT_Temp': 0,
                        'DT_StartTm': startTime,
                        'DT_EndTm': endTm,
                        'DT_TimeMinSec': 0,
                        'DT_RunTime': maxTime,
                        'DT_RunTime': dtVal.trim(),
                        'DT_Remark': remark,
                        'DT_DoneByID': tempUserObject.UserId,
                        'DT_DoneByName': tempUserObject.UserName,
                        'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
                        'DT_HaltDur': hDur,
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                        'DT_Jar': jarType,
                        "Layer": layer,
                        "LayerName": layer_name,
                    })

                }



                var JarAobj = {
                    'DT_MinTemp': minTemp,
                    'DT_MaxTemp': maxTemp,
                    'DT_HaltDur': hDur,
                    'DT_MinVal': minTime,
                    'DT_MaxVal': maxTime,
                }
                // const insertDetailObj = {
                //     str_tableName: detailTable,
                //     data: [
                //         { str_colName: 'RepSerNo', value: lastInsertedID },
                //         { str_colName: 'MstSerNo', value: 0 },
                //         { str_colName: 'RecSeqNo', value: i + 1 },
                //         { str_colName: 'DT_Side', value: jarType == "A" ? "LHS" : "RHS" },
                //         { str_colName: 'DT_BasketID', value: 0 },
                //         { str_colName: 'DT_Temp', value: 0 },
                //         { str_colName: 'DT_StartTm', value: startTime },
                //         { str_colName: 'DT_EndTm', value: endTm },
                //         { str_colName: 'DT_TimeMinSec', value: 0 },
                //         // { str_colName: 'DT_RunTime', value: runTime },
                //         { str_colName: 'DT_RunTime', value: dtVal.trim() },
                //         { str_colName: 'DT_Remark', value: 0 },
                //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
                //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
                //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
                //         { str_colName: 'DT_HaltDur', value: hDur }
                //     ]
                // }

                var insertObj1 = await models[strTableName].update({
                    MinTime: minTime,
                    MaxTime: maxTime
                }, {
                    where: {
                        RepSerNo: lastInsertedID
                    }

                })
                all_date = {
                    side: 'A',
                    JarA: JarAobj
                }
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0
                }, {
                    where: {
                        'Sys_rpi': hmiDetailsInPMenu.Sys_rpi
                    }

                });

                let tempFlagAJar = false; // For time
                let tempFlagTemp = false // for Tempreture
                for (const [i, dtVal] of jar_A_Arr.entries()) {
                    if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                        tempFlagAJar = true;
                    }
                }
                if ((parseFloat(dataObj.productType.T1Neg) > parseFloat(minTemp)) ||
                    (parseFloat(dataObj.productType.T1Pos) < parseFloat(maxTemp)) ||
                    (parseFloat(dataObj.productType.T1Neg) > parseFloat(settemp)) ||
                    (parseFloat(dataObj.productType.T1Pos) < parseFloat(settemp))) {
                    tempFlagTemp = true;
                }
                if (tempFlagTemp == true || tempFlagAJar == true) {
                    le = "Report generated is out of limit"
                    result_data = 'Not Complies'
                }
                if (lastInsertedID != null || lastInsertedID != undefined) {
                    const updateEndTime = await models[strTableName].update({
                        'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                        'PrEndTime': date.format(now, 'HH:mm:ss'),
                        "Remark": result_data
                    }, {
                        where: {
                            RepSerNo: lastInsertedID
                        }
                    });
                }
                var mainObj = {
                    JarA: JarAobj
                }
                await objMonit.monit({
                    case: 'TestDTWeight',
                    Hmi: strHmi,
                    data: {
                        Weight: JarAobj,
                        Jar: "JAR A",
                        message: ""
                    }
                });
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`);

                if (result_data == "Not Complies") {
                    var reportLimitMsg = "Report Out Of Limit"
                }
                else {
                    reportLimitMsg = "Report Within Limit"
                }

                // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${reportLimitMsg}`);
                mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);
                const returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strHmi, menuName, objProductDetails, all_date, result_data);
                obj.le = le
                obj.RepSerNo = lastInsertedID
                if (!le.includes('out')) {
                    var printObj = {
                        recordFrom: "Current",
                        reportOption: menuName,
                        reportType: "Complete",
                        testType: "Regular",
                        RepSerNo: lastInsertedID,
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        printNo: 0,
                        str_url: intProductType === 1 ? "Tablet" : "Capsule"
                    }

                    await printOperations.callViewTabReport(printObj, intProductType, strHmi)
                }
                return obj;
            } else if (jarType == "B") {
                le = "Report generated is Within limit";
                var startTimeval = moment(startTime, 'HH:mm:ss');
                var endTimeval = moment(endTime, 'HH:mm:ss');
                var runTime = moment.utc(moment(endTimeval, "HH:mm:ss")
                    .diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
                var hDur = haltDuration;

                for (const [i, dtVal] of jar_B_Arr.entries()) {

                    var endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");

                    let res;
                    var resp;
                    let obj1;
                    var max;
                    var maxTime = '00:00:00';
                    for (let i = 0; i < jar_B_Arr.length; i++) {
                        let c_h = Number(jar_B_Arr[i].substring(0, 2));
                        let c_m = Number(jar_B_Arr[i].substring(3, 5));
                        let c_s = Number(jar_B_Arr[i].substring(6, 8));

                        let s_h = Number(maxTime.substring(0, 2));
                        let s_m = Number(maxTime.substring(3, 5));
                        let s_s = Number(maxTime.substring(6, 8));

                        if (c_h > s_h) {
                            maxTime = jar_B_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m > s_m) {
                                maxTime = jar_B_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s > s_s) {
                                    maxTime = jar_B_Arr[i];
                                }
                            }
                        }

                    }
                    var minTime = maxTime;
                    for (let i = 0; i < jar_B_Arr.length; i++) {
                        let c_h = Number(jar_B_Arr[i].substring(0, 2));
                        let c_m = Number(jar_B_Arr[i].substring(3, 5));
                        let c_s = Number(jar_B_Arr[i].substring(6, 8));

                        let s_h = Number(minTime.substring(0, 2));
                        let s_m = Number(minTime.substring(3, 5));
                        let s_s = Number(minTime.substring(6, 8));

                        if (c_h < s_h) {
                            minTime = jar_B_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m < s_m) {
                                minTime = jar_B_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s < s_s) {
                                    minTime = jar_B_Arr[i];
                                }
                            }
                        }

                    }
                }
                for (const [i, dtVal] of jar_B_Arr.entries()) {

                    var endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    const insertDetailObj = await models[detailTable].create({
                        'RepSerNo': lastInsertedID,
                        'MstSerNo': 0,
                        'RecSeqNo': i + 1,
                        'DT_ID': DTId,
                        'DT_Side': 'NA',
                        'DT_BasketID': 0,
                        'DT_Temp': 0,
                        'DT_StartTm': startTime,
                        'DT_EndTm': endTm,
                        'DT_TimeMinSec': 0,
                        'DT_RunTime': maxTime,
                        'DT_RunTime': dtVal.trim(),
                        'DT_Remark': remark,
                        'DT_DoneByID': tempUserObject.UserId,
                        'DT_DoneByName': tempUserObject.UserName,
                        'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
                        'DT_HaltDur': hDur,
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                        'DT_Jar': jarType,
                        "Layer": layer,
                        "LayerName": layer_name,
                    })

                }
                var JarBobj = {
                    'DT_MinTemp': minTemp,
                    'DT_MaxTemp': maxTemp,
                    'DT_HaltDur': hDur,
                    'DT_MinVal': minTime,
                    'DT_MaxVal': maxTime,
                }
                // const insertDetailObj = {
                //     str_tableName: detailTable,
                //     data: [
                //         { str_colName: 'RepSerNo', value: lastInsertedID },
                //         { str_colName: 'MstSerNo', value: 0 },
                //         { str_colName: 'RecSeqNo', value: i + 1 },
                //         { str_colName: 'DT_Side', value: jarType == "A" ? "LHS" : "RHS" },
                //         { str_colName: 'DT_BasketID', value: 0 },
                //         { str_colName: 'DT_Temp', value: 0 },
                //         { str_colName: 'DT_StartTm', value: startTime },
                //         { str_colName: 'DT_EndTm', value: endTm },
                //         { str_colName: 'DT_TimeMinSec', value: 0 },
                //         { str_colName: 'DT_RunTime', value: dtVal.trim() },
                //         { str_colName: 'DT_Remark', value: 0 },
                //         { str_colName: 'DT_DoneByID', value: tempUserObject.UserId },
                //         { str_colName: 'DT_DoneByName', value: tempUserObject.UserName },
                //         { str_colName: 'DT_StartDate', value: date.format(now, 'YYYY-MM-DD') },
                //         { str_colName: 'DT_HaltDur', value: hDur }
                //     ]
                // }

                // var jarBRes = await database.save(insertDetailObj);



                var insertObj1 = await models[strTableName].update({
                    MinTime: minTime,
                    MaxTime: maxTime
                }, {
                    where: {
                        RepSerNo: lastInsertedID
                    }

                })
                all_date = {
                    side: 'B',
                    JarB: JarBobj
                }
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0
                }, {
                    where: {
                        'Sys_rpi': hmiDetailsInPMenu.Sys_rpi
                    }

                })

                // const objUpdateValidation = {
                //     str_tableName: "tbl_cubical",
                //     data: [
                //         { str_colName: 'Sys_Validation', value: 0 },
                //     ],
                //     condition: [
                //         { str_colName: 'Sys_IDSNo', value: strIdsNo },
                //     ]
                // }
                // await database.update(objUpdateValidation);
                let tempFlagAJar = false; // For time
                let tempFlagTemp = false // for Tempreture
                for (const [i, dtVal] of jar_B_Arr.entries()) {
                    if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                        // return le = `${protocolIncomingType}` + `R2`;
                        tempFlagAJar = true;
                    }
                }
                if ((parseFloat(dataObj.productType.T1Neg) > parseFloat(minTemp)) ||
                    (parseFloat(dataObj.productType.T1Pos) < parseFloat(maxTemp))) {
                    tempFlagTemp = true;
                }
                if (tempFlagTemp == true || tempFlagAJar == true) {
                    le = "Report generated is out of limit";
                    result_data = 'Not Complies'
                }
                if (lastInsertedID != null || lastInsertedID != undefined) {
                    const updateEndTime = await models[strTableName].update({
                        'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                        'PrEndTime': date.format(now, 'HH:mm:ss'),
                        "Remark": result_data
                    }, {
                        where: {
                            RepSerNo: lastInsertedID
                        }
                    });
                }

                var mainObj = {
                    JarB: JarBobj
                }
                await objMonit.monit({
                    case: 'TestDTWeight',
                    Hmi: strHmi,
                    data: {
                        Weight: JarBobj,
                        Jar: "JAR B",
                        message: ""
                    }
                });
                const returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strHmi, menuName, objProductDetails, all_date, result_data);
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`);

                if (result_data == "Not Complies") {
                    var reportLimitMsg = "Report Out Of Limit"
                }
                else {
                    reportLimitMsg = "Report Within Limit"
                }

                // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${reportLimitMsg}`);
                mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);

                obj.le = le
                obj.RepSerNo = lastInsertedID
                if (!le.includes('out')) {
                    var printObj = {
                        recordFrom: "Current",
                        reportOption: menuName,
                        reportType: "Complete",
                        testType: "Regular",
                        RepSerNo: lastInsertedID,
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        printNo: 0,
                        str_url: intProductType === 1 ? "Tablet" : "Capsule"
                    }


                    await printOperations.callViewTabReport(printObj, intProductType, strHmi)
                }
                return obj;

            } else {
                var returnBatchRes
                let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
                let startTimeA = dataObj.ProtocolData.start_time_Jar_A;
                let endTimeA = dataObj.ProtocolData.end_time_Jar_A;
                let startTimevalA = moment(startTimeA, 'HH:mm:ss');
                let endTimevalA = moment(endTimeA, 'HH:mm:ss');
                let runTimeA = moment.utc(moment(endTimevalA, "HH:mm:ss")
                    .diff(moment(startTimevalA, "HH:mm:ss"))).format("HH:mm:ss")
                let hDurA = dataObj.ProtocolData.HALT_DUR_JAR_A.trim();

                let startTimeB = dataObj.ProtocolData.start_time_Jar_B;
                let endTimeB = dataObj.ProtocolData.end_time_Jar_B;
                let startTimevalB = moment(startTimeB, 'HH:mm:ss');
                let endTimevalB = moment(endTimeB, 'HH:mm:ss');
                let runTimeB = moment.utc(moment(endTimevalB, "HH:mm:ss")
                    .diff(moment(startTimevalB, "HH:mm:ss"))).format("HH:mm:ss")
                let hDurB = dataObj.ProtocolData.HALT_DUR_JAR_B.trim();
                bRepSerNo = await this.getMaxBRepSerNo(dataObj.objProductDetails.ProductName, dataObj.objProductDetails.Batch, strTableName, hmiDetailsInPMenu.Sys_RptType)
                insertObj = await models[strTableName].create({
                    'MstSerNo': 0,
                    'InstruId': 1,
                    'BFGCode': dataObj.objProductDetails.ProductId,
                    'ProductName': dataObj.objProductDetails.ProductName,
                    'ProductType': objProductDetails.ProductType,
                    'Qty': objProductDetails.noOfSamples,
                    'Stage' :hmiDetailsInPMenu.Sys_Stage,
                    'GrpQty': 0,
                    'GrpFreq': 0,
                    'Idsno': strHmi,
                    'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                    'BalanceId': 0,
                    'BalanceNo': 0,
                    'VernierNo': 0,
                    'BatchNo': dataObj.objProductDetails.Batch,
                    'UserId': dataObj.objProductDetails.userId,
                    'UserName': dataObj.objProductDetails.userName,
                    'PrDate': startDatefromOBJ,
                    'PrTime': startTime,
                    'PrEndDate': '1992-12-08',
                    'PrEndTime': '',
                    'Side': 'LHS',
                    'Unit': '123',
                    'DecimalPoint': '0',
                    'Department': hmiDetailsInPMenu.Sys_dept,
                    'WgmtModeNo': typeValues,
                    'Nom': intNominal,
                    'T1NegTol': Number(objProductDetails.T1Neg).toFixed(1),
                    'T1PosTol': Number(objProductDetails.T1Pos).toFixed(1),
                    'TempRange': Number(objProductDetails.T1Neg).toFixed(1) + " - " + Number(objProductDetails.T1Pos).toFixed(1),
                    'MinTemp': minTemp,
                    'MaxTemp': maxTemp,
                    'limitOn': 0,
                    'T1NMTTab': objProductDetails.NMT,
                    'NomEmpty': 0,
                    'T1NegEmpty': 0,
                    'T1PosEmpty': 0,

                    'NomNet': 0,
                    'T1NegNet': 0,
                    'T1PosNet': 0,

                    'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                    'ReportType': hmiDetailsInPMenu.Sys_RptType,
                    'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                    'Media': hmiDetailsInPMenu.Sys_media,
                    'MFGCode': hmiDetailsInPMenu.Sys_Stage,
                    'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,

                    'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                    'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
                    'RepoLabel10': 'Standard',
                    'RepoLabel11': 0,
                    'RepoLabel12': 'Null',
                    'RepoLabel13': 'Null',
                    'PrintNo': 0,
                    'IsArchived': 0,
                    'GraphType': 0,
                    'BatchComplete': 0,
                    'PVersion': hmiDetailsInPMenu.Sys_PVersion,
                    'Version': hmiDetailsInPMenu.Sys_Version,

                    'BRepSerNo': bRepSerNo,
                    'Lot': LotNo == undefined ? hmiDetailsInPMenu.Sys_LotNo : LotNo,
                    'Area': hmiDetailsInPMenu.Sys_Area,
                    'InstrumentID': DTId,
                    'Jar': 'A',
                    'Basket_Type': ProtocolData.JarBasketA,
                    'Apparatus_Type': ProtocolData.JarBasketA,
                    "Layer": layer,
                    "LayerName": layer_name,
                    'Inprocess': 0,
                    'MeshSize_Bolus': ProtocolData.Mode,  // mode 
                    'Media_Temp': ProtocolData.SetTempA, //settemp,

                });
                arrResult = (insertObj);
                lastInsertedID = arrResult.RepSerNo;
                for (const [i, dtVal] of jar_A_Arr.entries()) {
                    let endTmSS = moment(startTimeA, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    let endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    var DT_MinVal = dataObj.ProtocolData.Jar_Bath_min;
                    var DT_MaxVal = dataObj.ProtocolData.Jar_Bath_max;
                    let res;
                    var resp;
                    let obj1;
                    var max;
                    var maxTime = '00:00:00';
                    for (let i = 0; i < jar_A_Arr.length; i++) {
                        let c_h = Number(jar_A_Arr[i].substring(0, 2));
                        let c_m = Number(jar_A_Arr[i].substring(3, 5));
                        let c_s = Number(jar_A_Arr[i].substring(6, 8));

                        let s_h = Number(maxTime.substring(0, 2));
                        let s_m = Number(maxTime.substring(3, 5));
                        let s_s = Number(maxTime.substring(6, 8));

                        if (c_h > s_h) {
                            maxTime = jar_A_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m > s_m) {
                                maxTime = jar_A_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s > s_s) {
                                    maxTime = jar_A_Arr[i];
                                }
                            }
                        }

                    }
                    var minTime = maxTime;
                    for (let i = 0; i < jar_A_Arr.length; i++) {
                        let c_h = Number(jar_A_Arr[i].substring(0, 2));
                        let c_m = Number(jar_A_Arr[i].substring(3, 5));
                        let c_s = Number(jar_A_Arr[i].substring(6, 8));

                        let s_h = Number(minTime.substring(0, 2));
                        let s_m = Number(minTime.substring(3, 5));
                        let s_s = Number(minTime.substring(6, 8));

                        if (c_h < s_h) {
                            minTime = jar_A_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m < s_m) {
                                minTime = jar_A_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s < s_s) {
                                    minTime = jar_A_Arr[i];
                                }
                            }
                        }

                    }
                }
                for (const [i, dtVal] of jar_A_Arr.entries()) {

                    var endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    const insertDetailObj = await models[detailTable].create({
                        'RepSerNo': lastInsertedID,
                        'MstSerNo': 0,
                        'RecSeqNo': i + 1,
                        'DT_ID': DTId,
                        'DT_Side': 'LHS',
                        'DT_BasketID': 0,
                        'DT_Temp': 0,
                        'DT_StartTm': startTime,
                        'DT_EndTm': endTm,
                        'DT_TimeMinSec': 0,
                        'DT_RunTime': maxTime,
                        'DT_RunTime': dtVal.trim(),
                        'DT_Remark': remark,
                        'DT_DoneByID': tempUserObject.UserId,
                        'DT_DoneByName': tempUserObject.UserName,
                        'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
                        'DT_HaltDur': hDurA,
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                        'DT_Jar': 'A',
                        "Layer": layer,
                        "LayerName": layer_name,
                    })

                }
                result_data = 'Complies'
                tempFlagAJar = false; // For time
                tempFlagTemp = false // for Tempreture
                for (const [i, dtVal] of jar_A_Arr.entries()) {
                    if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                        tempFlagAJar = true;
                    }
                }
                if ((parseFloat(dataObj.productType.T1Neg) > parseFloat(minTemp)) ||
                    (parseFloat(dataObj.productType.T1Pos) < parseFloat(maxTemp))) {
                    tempFlagTemp = true;
                }
                if (tempFlagTemp == true || tempFlagAJar == true) {
                    le = "Report generated is out of limit"
                    result_data = 'Not Complies'
                }
                if (lastInsertedID != null || lastInsertedID != undefined) {
                    const updateEndTime = await models[strTableName].update({
                        'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                        'PrEndTime': date.format(now, 'HH:mm:ss'),
                        "Remark": result_data
                    }, {
                        where: {
                            RepSerNo: lastInsertedID
                        }
                    });
                }
                var JarAobj = {
                    'DT_MinTemp': minTemp,
                    'DT_MaxTemp': maxTemp,
                    'DT_HaltDur': hDurA,
                    'DT_MinVal': minTime,
                    'DT_MaxVal': maxTime,
                }
                all_date = {
                    side: 'A',
                    JarA: JarAobj
                }
                var insertObj1 = await models[strTableName].update({
                    MinTime: minTime,
                    MaxTime: maxTime
                }, {
                    where: {
                        RepSerNo: lastInsertedID
                    }

                });

                let jarARemark = result_data;

                returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedID, 0, hmiDetailsInPMenu, strHmi, menuName, objProductDetails, all_date, result_data);
                if (!le.includes('out')) {
                    var printObj = {
                        recordFrom: "Current",
                        reportOption: menuName,
                        reportType: "Complete",
                        testType: "Regular",
                        RepSerNo: lastInsertedID,
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        printNo: 0,
                        str_url: intProductType === 1 ? "Tablet" : "Capsule"
                    }


                    await printOperations.callViewTabReport(printObj, intProductType, strHmi)
                }
                startTime = startTimeB;
                endTime = endTimeB;

                var timeStatus = (parseInt(endTime.replace(regExp, "$1$2$3")) > parseInt(startTime.replace(regExp, "$1$2$3")))
                endDate = timeStatus ? startDate : date.format(now, 'YYYY-MM-DD');
                bRepSerNo = await this.getMaxBRepSerNo(dataObj.objProductDetails.ProductName, dataObj.objProductDetails.Batch, strTableName, hmiDetailsInPMenu.Sys_RptType)
                insertObj = await models[strTableName].create({
                    'MstSerNo': 0,
                    'InstruId': 1,
                    'BFGCode': dataObj.objProductDetails.ProductId,
                    'ProductName': dataObj.objProductDetails.ProductName,
                    'Department': hmiDetailsInPMenu.Sys_dept,
                    'ProductType': objProductDetails.ProductType,
                    'Qty': objProductDetails.noOfSamples,
                    'GrpQty': 0,
                    'GrpFreq': 0,
                    'Idsno': strHmi,
                    'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                    'Stage' :hmiDetailsInPMenu.Sys_Stage,
                    'BalanceId': 0,
                    'BalanceNo': 0,
                    'VernierNo': 0,
                    'BatchNo': dataObj.objProductDetails.Batch,
                    'UserId': dataObj.objProductDetails.userId,
                    'UserName': dataObj.objProductDetails.userName,
                    'PrDate': startDatefromOBJ,
                    'PrTime': startTime,
                    'PrEndDate': '1992-12-08',
                    'PrEndTime': '',
                    'Side': 'RHS',
                    'Unit': '123',
                    'DecimalPoint': '0',
                    'WgmtModeNo': typeValues,
                    'Nom': intNominal,
                    'T1NegTol': Number(objProductDetails.T1Neg).toFixed(1),
                    'T1PosTol': Number(objProductDetails.T1Pos).toFixed(1),
                    'MinTemp': minTempB,
                    'MaxTemp': maxTempB,
                    'limitOn': 0,
                    'T1NMTTab': objProductDetails.NMT,
                    'NomEmpty': 0,
                    'T1NegEmpty': 0,
                    'T1PosEmpty': 0,
                    'NomNet': 0,
                    'T1NegNet': 0,
                    'T1PosNet': 0,
                    'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                    'ReportType': hmiDetailsInPMenu.Sys_RptType,
                    'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                    'Media': hmiDetailsInPMenu.Sys_media,
                    'MFGCode': hmiDetailsInPMenu.Sys_Stage,
                    'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
                    'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                    'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
                    'RepoLabel10': 'Standard',
                    'RepoLabel11': 0,
                    'RepoLabel12': 'Null',
                    'RepoLabel13': 'Null',
                    'PrintNo': 0,
                    'IsArchived': 0,
                    'GraphType': 0,
                    'BatchComplete': 0,
                    'PVersion': hmiDetailsInPMenu.Sys_PVersion,
                    'Version': hmiDetailsInPMenu.Sys_Version,
                    'BRepSerNo': bRepSerNo,
                    'Lot': LotNo == undefined ? hmiDetailsInPMenu.Sys_LotNo : LotNo,
                    'Area': hmiDetailsInPMenu.Sys_Area,
                    'InstrumentID': DTId,
                    'TempRange': Number(objProductDetails.T1Neg).toFixed(1) + " - " + Number(objProductDetails.T1Pos).toFixed(1),
                    'Jar': 'B',
                    'Basket_Type': ProtocolData.JarBasketB,
                    'Apparatus_Type': ProtocolData.JarBasketB,
                    "Layer": layer,
                    "LayerName": layer_name,
                    'Inprocess': 0,
                    'Media_Temp': ProtocolData.SetTempB, //settemp,
                    'MeshSize_Bolus': ProtocolData.Mode, // mode 
                });
                arrResult = insertObj;
                var lastInsertedIDJarB = arrResult.RepSerNo;
                for (const [i, dtVal] of jar_B_Arr.entries()) {
                    var endTmSS = moment(startTimeA, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    var DT_MinVal = dataObj.ProtocolData.Jar_Bath_min;
                    var DT_MaxVal = dataObj.ProtocolData.Jar_Bath_max;
                    let res;
                    var resp;
                    let obj1;
                    var max;
                    var maxTime = '00:00:00';
                    for (let i = 0; i < jar_B_Arr.length; i++) {
                        let c_h = Number(jar_B_Arr[i].substring(0, 2));
                        let c_m = Number(jar_B_Arr[i].substring(3, 5));
                        let c_s = Number(jar_B_Arr[i].substring(6, 8));

                        let s_h = Number(maxTime.substring(0, 2));
                        let s_m = Number(maxTime.substring(3, 5));
                        let s_s = Number(maxTime.substring(6, 8));

                        if (c_h > s_h) {
                            maxTime = jar_B_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m > s_m) {
                                maxTime = jar_B_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s > s_s) {
                                    maxTime = jar_B_Arr[i];
                                }
                            }
                        }

                    }
                    var minTime = maxTime;
                    for (let i = 0; i < jar_B_Arr.length; i++) {
                        let c_h = Number(jar_B_Arr[i].substring(0, 2));
                        let c_m = Number(jar_B_Arr[i].substring(3, 5));
                        let c_s = Number(jar_B_Arr[i].substring(6, 8));

                        let s_h = Number(minTime.substring(0, 2));
                        let s_m = Number(minTime.substring(3, 5));
                        let s_s = Number(minTime.substring(6, 8));

                        if (c_h < s_h) {
                            minTime = jar_B_Arr[i];
                        } else if (c_h === s_h) {
                            if (c_m < s_m) {
                                minTime = jar_B_Arr[i];
                            } else if (c_m === s_m) {
                                if (c_s < s_s) {
                                    minTime = jar_B_Arr[i];
                                }
                            }
                        }

                    }

                }
                for (const [i, dtVal] of jar_B_Arr.entries()) {

                    var endTmSS = moment(startTime, "HH:mm:ss").add(dtVal.trim().split(":")[2], 'seconds').format("HH:mm:ss");
                    var endTmMM = moment(endTmSS, "HH:mm:ss").add(dtVal.trim().split(":")[1], 'minutes').format("HH:mm:ss");
                    var endTm = moment(endTmMM, "HH:mm:ss").add(dtVal.trim().split(":")[0], 'hours').format("HH:mm:ss");
                    const insertDetailObj = await models[detailTable].create({
                        'RepSerNo': lastInsertedIDJarB,
                        'MstSerNo': 0,
                        'RecSeqNo': i + 1,
                        'DT_ID': DTId,
                        'DT_Side': 'RHS',
                        'DT_BasketID': 0,
                        'DT_Temp': 0,
                        'DT_StartTm': startTime,
                        'DT_EndTm': endTm,
                        'DT_TimeMinSec': 0,
                        'DT_RunTime': maxTime,
                        'DT_RunTime': dtVal.trim(),
                        'DT_Remark': remark,
                        'DT_DoneByID': tempUserObject.UserId,
                        'DT_DoneByName': tempUserObject.UserName,
                        'DT_StartDate': date.format(now, 'YYYY-MM-DD'),
                        'DT_HaltDur': hDurB,
                        'DT_MinVal': minTime,
                        'DT_MaxVal': maxTime,
                        'DT_Jar': 'B',
                        "Layer": layer,
                        "LayerName": layer_name,
                    })

                }
                var JarBobj = {
                    'DT_MinTemp': minTempB,
                    'DT_MaxTemp': maxTempB,
                    'DT_HaltDur': hDurB,
                    'DT_MinVal': minTime,
                    'DT_MaxVal': maxTime,
                }
                all_date = {
                    side: 'B',
                    JarB: JarBobj,

                }
                result_data = 'Complies'
                tempFlagAJar = false; // For time
                tempFlagTemp = false // for Tempreture
                for (const [i, dtVal] of jar_B_Arr.entries()) {
                    if (parseInt(dtVal.trim().replace(regExp, "$1$2$3")) > parseInt(actualRunTime.replace(regExp, "$1$2$3"))) {
                        tempFlagAJar = true;
                    }
                }
                if ((parseFloat(dataObj.productType.T1Neg) > parseFloat(minTempB)) ||
                    (parseFloat(dataObj.productType.T1Pos) < parseFloat(maxTempB))) {
                    tempFlagTemp = true;
                }
                if (tempFlagTemp == true || tempFlagAJar == true) {
                    le = "Report generated is out of limit";
                    result_data = 'Not Complies'
                }
                if (lastInsertedIDJarB != null || lastInsertedIDJarB != undefined) {
                    const updateEndTime = await models[strTableName].update({
                        'PrEndDate': date.format(now, 'YYYY-MM-DD'),
                        'PrEndTime': date.format(now, 'HH:mm:ss'),
                        "Remark": result_data
                    }, {
                        where: {
                            RepSerNo: lastInsertedIDJarB
                        }
                    });
                }

                let jarBRemark = result_data


                returnBatchRes = await objBatchSummary.saveBatchSummaryDT(lastInsertedIDJarB, 0, hmiDetailsInPMenu, strHmi, menuName, objProductDetails, all_date, result_data);

                if (!le.includes('out')) {
                    var printObj = {
                        recordFrom: "Current",
                        reportOption: menuName,
                        reportType: "Complete",
                        testType: "Regular",
                        RepSerNo: lastInsertedIDJarB,
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        printNo: 0,
                        str_url: intProductType === 1 ? "Tablet" : "Capsule"
                    }


                    await printOperations.callViewTabReport(printObj, intProductType, strHmi)
                }
                insertObj1 = await models[strTableName].update({
                    MinTime: minTime,
                    MaxTime: maxTime
                }, {
                    where: {
                        RepSerNo: lastInsertedIDJarB
                    }

                });

                /* end of  inserting Data of double rotatry for B*/
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0
                }, {
                    where: {
                        'Sys_rpi': hmiDetailsInPMenu.Sys_rpi
                    }

                });

                all_date = {
                    side: 'Double',
                    JarB: JarBobj,
                    JarA: JarAobj
                }

                hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData

                var mainObj = {
                    JarA: JarAobj,
                    JarB: JarBobj
                }
                await objMonit.monit({
                    case: 'TestDTWeight',
                    Hmi: strHmi,
                    data: {
                        Weight: JarAobj,
                        Jar: "JAR A",
                        message: ""
                    }
                });
                await objMonit.monit({
                    case: 'TestDTWeight',
                    Hmi: strHmi,
                    data: {
                        Weight: JarBobj,
                        Jar: "JAR B",
                        message: ""
                    }
                });
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(mainObj)}`);

                if (jarBRemark == "Not Complies" || jarARemark == "Not Complies") {
                    var reportLimitMsg = "Report Out Of Limit"
                }
                else {
                    reportLimitMsg = "Report Within Limit"
                }

                // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${reportLimitMsg}`);

                await objMonit.monit({
                    case: 'ReportStatus',
                    Hmi: strHmi,
                    data: {
                        message: reportLimitMsg
                    }
                });
                mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);

                obj.le = le
                obj.RepSerNo = lastInsertedID
                return obj;
            }
        } catch (error) {
            throw new Error(error)
        }
    }
    async getMaxBRepSerNo(productName, strBatch, strTableName, reportType, cubicType) {
        try {
            const tblDetails = await models[strTableName].findAll({
                where: {
                    BatchNo: strBatch,
                    ProductName: productName,
                    ReportType: reportType,

                }
            }
            )
            if (tblDetails.length != 0) {
                let maxColumn = tblDetails.length >= 1 ? tblDetails.pop() : tblDetails;
                let BRepSerNo = maxColumn.RepSerNo + 1
                return BRepSerNo;
            } else {
                return 1
            }
        } catch (error) {
            throw new Error()
        }
    }
}

module.exports = DTModel;